/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Ca;
import at.cdes.api.joinDto.CaJoin;
import at.cdes.impl.dao.CaDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcCaDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcCaDAO
extends AbstractJdbcCaDAO
implements CaDAO {
    @Override
    public List<Ca> getValidUserCas(final Long networkId) {
        String sql = "SELECT ca.id, ca.organisation_person_id, ca.ca_cert_id, ca.subject_dn, ca.cert_serial, ca.cert_valid_from, ca.cert_valid_to, ca.may_issue, ca.may_authenticate, ca.network_id FROM ca WHERE ca.network_id = ? AND ca.may_issue = 1 AND ca.cert_valid_to >= ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Ca>>(){

            public List<Ca> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)networkId);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)2, (Double)((double)System.currentTimeMillis() / 1000.0));
                ResultSet rs = statement.executeQuery();
                ArrayList<Ca> ret = new ArrayList<Ca>();
                while (rs.next()) {
                    Ca ca = JdbcCaDAO.this.fillCaFromResultSetPartly(rs);
                    ret.add(ca);
                }
                return ret;
            }
        });
    }

    private Ca fillCaFromResultSetPartly(ResultSet rs) throws Exception {
        Ca ca = new Ca();
        ca.setId(JDBCHelper.getLong((ResultSet)rs, (int)1));
        ca.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)2));
        ca.setCaCertId(JDBCHelper.getLong((ResultSet)rs, (int)3));
        ca.setSubjectDn(new String(rs.getBytes(4)));
        ca.setCertSerial(rs.getString(5));
        ca.setCertValidFrom(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)6));
        ca.setCertValidTo(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)7));
        ca.setMayIssue(JDBCHelper.getBoolean((ResultSet)rs, (int)8));
        ca.setMayAuthenticate(JDBCHelper.getBoolean((ResultSet)rs, (int)9));
        ca.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)10));
        return ca;
    }

    @Override
    public List<CaJoin> getAllCaJoins() {
        String sql = "SELECT " + JdbcCaDAO.getCaJoinSelectClause() + "FROM ca LEFT JOIN organisation_person ON ca.organisation_person_id = organisation_person.id LEFT JOIN person              ON organisation_person.person_id = person.id ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcCaDAO::fillCaJoinFromResultSet, statement -> {});
    }
}

