/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.dto.ConsortiumMember;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkOrganisation;
import at.cdes.api.dto.Organisation;
import at.cdes.api.guiService.OrganisationService;
import at.cdes.api.joinDto.OrganisationDeleteJoin;
import at.cdes.api.joinDto.OrganisationJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.OrganisationPersonSelectionJoin;
import at.cdes.api.organisation.compositeDto.OrganisationInfo;
import at.cdes.api.organisation.compositeDto.OrganisationSearchInfo;
import at.cdes.api.organisation.searchModel.OrganisationSearchModel;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.ConsortiumMemberDAO;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.NetworkOrganisationDAO;
import at.cdes.impl.dao.OrganisationDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.unionComponent.OrganisationDeleteUnionComponent;
import at.cdes.impl.export.organisation.ConsortiumListExporter;
import at.cdes.impl.export.organisation.ConsortiumListPdfCallable;
import at.cdes.impl.export.organisation.OrganisationListExporter;
import at.cdes.impl.export.organisation.OrganisationListPdfCallable;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.BatchedDAOGetterMap;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganisationServiceImpl
implements OrganisationService {
    private static final Logger log = LoggerFactory.getLogger(OrganisationServiceImpl.class);
    private ActionDAO actionDAO;
    private ConsortiumListExporter consortiumListExporter;
    private ConsortiumMemberDAO consortiumMemberDAO;
    private NetworkDAO networkDAO;
    private NetworkOrganisationDAO networkOrganisationDAO;
    private IOneTimeScheduler oneTimeScheduler;
    private OrganisationDAO organisationDAO;
    private OrganisationListExporter organisationListExporter;
    private OrganisationPersonDAO organisationPersonDAO;
    private int sqlQueryBatchSize;
    private Boolean enableAutoInitSearch;
    private Boolean enableCustomerLogo;
    private String costumerLabel;
    private Boolean certificateAdministrationGlobal;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setConsortiumListExporter(ConsortiumListExporter consortiumListExporter) {
        this.consortiumListExporter = consortiumListExporter;
    }

    public void setConsortiumMemberDAO(ConsortiumMemberDAO consortiumMemberDAO) {
        this.consortiumMemberDAO = consortiumMemberDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setNetworkOrganisationDAO(NetworkOrganisationDAO networkOrganisationDAO) {
        this.networkOrganisationDAO = networkOrganisationDAO;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOrganisationListExporter(OrganisationListExporter organisationListExporter) {
        this.organisationListExporter = organisationListExporter;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setSqlQueryBatchSize(int sqlQueryBatchSize) {
        this.sqlQueryBatchSize = sqlQueryBatchSize;
    }

    public void setEnableAutoInitSearch(Boolean enableAutoInitSearch) {
        this.enableAutoInitSearch = enableAutoInitSearch;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public void setCertificateAdministrationGlobal(Boolean certificateAdministrationGlobal) {
        this.certificateAdministrationGlobal = certificateAdministrationGlobal;
    }

    public Organisation getOrganisation(Long organisationId) {
        return (Organisation)this.organisationDAO.get(organisationId);
    }

    public OrganisationSearchInfo getOrganisationSearchInfo(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkForGlobalNetworkActions(organisationPersonId);
        OrganisationSearchInfo searchInfo = new OrganisationSearchInfo();
        searchInfo.setNetworkId(networkId);
        List<Network> administratedNetworks = this.networkDAO.getNetworksToAdmin(organisationPersonId);
        searchInfo.setAdministratedNetworks(administratedNetworks);
        searchInfo.setNetworks(null);
        List<Organisation> organisations = this.organisationDAO.getNetworkOrganisationNames(networkId, false);
        searchInfo.setOrganisations(organisations);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkId, Action.EDIT_ORGANISATION);
        HashMap<String, Boolean> networkActionMap = new HashMap<String, Boolean>();
        Set<Action> networkActions = networkIdToActions.get(networkId);
        if (networkActions != null) {
            for (Action action : networkActions) {
                networkActionMap.put(action.getName(), true);
            }
        }
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        searchInfo.setGlobalActions(ActionHelper.convertEnumToString(globalActions));
        searchInfo.setEnableAutoInitSearch(this.enableAutoInitSearch.booleanValue());
        searchInfo.setNetworkActions(networkActionMap);
        searchInfo.setCertificateAdministrationGlobal(this.certificateAdministrationGlobal);
        return searchInfo;
    }

    public OrganisationSearchInfo getConsortiumSearchInfo(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkForGlobalNetworkActions(organisationPersonId);
        OrganisationSearchInfo searchInfo = new OrganisationSearchInfo();
        searchInfo.setNetworkId(networkId);
        List<Network> administratedNetworks = this.networkDAO.getNetworksToAdmin(organisationPersonId);
        searchInfo.setAdministratedNetworks(administratedNetworks);
        searchInfo.setNetworks(null);
        List<Organisation> organisationsAndConsortiums = this.organisationDAO.getNetworkOrganisationNames(networkId, null);
        ArrayList<Organisation> organisations = new ArrayList<Organisation>();
        ArrayList<Organisation> consortiums = new ArrayList<Organisation>();
        for (Organisation organisationOrConsortium : organisationsAndConsortiums) {
            if (organisationOrConsortium.isConsortiumFlag().booleanValue()) {
                consortiums.add(organisationOrConsortium);
                continue;
            }
            organisations.add(organisationOrConsortium);
        }
        searchInfo.setOrganisations(organisations);
        searchInfo.setConsortiums(consortiums);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkId, Action.EDIT_CONSORTIUM);
        HashMap<String, Boolean> networkActionMap = new HashMap<String, Boolean>();
        Set<Action> networkActions = networkIdToActions.get(networkId);
        if (networkActions != null) {
            for (Action action : networkActions) {
                networkActionMap.put(action.getName(), true);
            }
        }
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        searchInfo.setGlobalActions(ActionHelper.convertEnumToString(globalActions));
        searchInfo.setEnableAutoInitSearch(this.enableAutoInitSearch.booleanValue());
        searchInfo.setNetworkActions(networkActionMap);
        searchInfo.setCertificateAdministrationGlobal(this.certificateAdministrationGlobal);
        return searchInfo;
    }

    public List<OrganisationInfo> getOrganisationJoins(OrganisationSearchModel searchModel) {
        return this.getOrganisationJoinsImpl(searchModel, false);
    }

    public List<OrganisationInfo> getConsortiumJoins(OrganisationSearchModel searchModel) {
        return this.getOrganisationJoinsImpl(searchModel, true);
    }

    private List<OrganisationInfo> getOrganisationJoinsImpl(OrganisationSearchModel searchModel, boolean consortiumFlag) {
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkForGlobalNetworkActions(organisationPersonId);
        ArrayList<OrganisationInfo> organisationInfos = new ArrayList<OrganisationInfo>();
        List<OrganisationJoin> organisationJoins = this.organisationDAO.getOrganisationJoins(searchModel, consortiumFlag);
        ArrayList<Long> organisationIds = new ArrayList<Long>();
        for (OrganisationJoin organisationJoin : organisationJoins) {
            organisationIds.add(organisationJoin.getOrganisationId());
        }
        Map<Object, Object> consortiumIdToMemberJoins = consortiumFlag ? QueryHelper.executeDAOGetter(organisationIds, this.sqlQueryBatchSize / 2, new BatchedDAOGetterMap<List<OrganisationJoin>, Long>(){

            @Override
            public Map<Long, List<OrganisationJoin>> execute(List<Long> ids) {
                return OrganisationServiceImpl.this.organisationDAO.getMemberJoinsByConsortiums(ids);
            }
        }) : new HashMap();
        HashSet<Long> allOrganisationIds = new HashSet<Long>();
        allOrganisationIds.addAll(organisationIds);
        for (List list : consortiumIdToMemberJoins.values()) {
            for (OrganisationJoin memberJoin : list) {
                allOrganisationIds.add(memberJoin.getOrganisationId());
            }
        }
        ArrayList<Long> allOrganisationIdsList = new ArrayList<Long>();
        allOrganisationIdsList.addAll(allOrganisationIds);
        Map map = QueryHelper.executeDAOGetter(allOrganisationIdsList, this.sqlQueryBatchSize / 2, new BatchedDAOGetterMap<List<Network>, Long>(){

            @Override
            public Map<Long, List<Network>> execute(List<Long> ids) {
                return OrganisationServiceImpl.this.networkDAO.getNetworksByOrganisations(ids);
            }
        });
        List<Long> networkIds = ContainerHelper.getIdsFromMultiMapAsList(map);
        Map<Object, Object> networkIdToActions = networkIds != null && networkIds.size() > 0 ? this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, Action.DELETE_ORGANISATION, Action.EDIT_ORGANISATION, Action.SHOW_ORGANISATION, Action.REFERENCE_ORGANISATION) : new HashMap();
        for (OrganisationJoin organisationJoin : organisationJoins) {
            Long organisationId = organisationJoin.getOrganisationId();
            List<Object> networks = map.containsKey(organisationId) ? map.get(organisationId) : new ArrayList();
            List memberJoins = (List)consortiumIdToMemberJoins.get(organisationId);
            ArrayList<OrganisationInfo> memberInfos = new ArrayList<OrganisationInfo>();
            if (memberJoins != null) {
                for (OrganisationJoin memberJoin : memberJoins) {
                    Long memberId = memberJoin.getOrganisationId();
                    ArrayList arrayList = map.get(memberId);
                    OrganisationInfo memberInfo = new OrganisationInfo();
                    memberInfo.setOrganisationJoin(memberJoin);
                    memberInfo.setNetworks((List)(arrayList != null ? arrayList : new ArrayList()));
                    memberInfos.add(memberInfo);
                }
            }
            OrganisationInfo organisationInfo = new OrganisationInfo();
            organisationInfo.setOrganisationJoin(organisationJoin);
            organisationInfo.setMembers(memberInfos);
            organisationInfo.setNetworks(networks);
            HashSet<Action> actions = new HashSet<Action>();
            if (networks != null) {
                for (Network network : networks) {
                    Long networkId = network.getId();
                    Set currActions = (Set)networkIdToActions.get(networkId);
                    if (currActions == null) continue;
                    actions.addAll(currActions);
                }
            }
            organisationInfo.setActions(ActionHelper.convertEnumToString(actions));
            organisationInfos.add(organisationInfo);
        }
        return organisationInfos;
    }

    public OrganisationInfo getOrganisationCreateInfo(Long organisationPersonId, Long networkId) {
        return this.getOrganisationCreateInfoImpl(organisationPersonId, networkId, false, Action.SHOW_ORGANISATION, Action.EDIT_ORGANISATION);
    }

    public OrganisationInfo getConsortiumCreateInfo(Long organisationPersonId, Long networkId) {
        return this.getOrganisationCreateInfoImpl(organisationPersonId, networkId, true, Action.SHOW_CONSORTIUM, Action.EDIT_CONSORTIUM);
    }

    public OrganisationInfo getOrganisationEditInfo(Long organisationPersonId, Long organisationId) {
        return this.getOrganisationEditInfoImpl(organisationPersonId, organisationId, false, Action.SHOW_ORGANISATION, Action.EDIT_ORGANISATION);
    }

    public OrganisationInfo getConsortiumEditInfo(Long organisationPersonId, Long organisationId) {
        return this.getOrganisationEditInfoImpl(organisationPersonId, organisationId, true, Action.SHOW_CONSORTIUM, Action.EDIT_CONSORTIUM);
    }

    private OrganisationInfo getOrganisationCreateInfoImpl(Long organisationPersonId, Long networkId, boolean consortiumFlag, Action showAction, Action editAction) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ArrayList<Long> allNetworkIdsList = new ArrayList<Long>();
        allNetworkIdsList.add(networkId);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, allNetworkIdsList, Action.SHOW_ORGANISATION, Action.EDIT_ORGANISATION, Action.SHOW_CONSORTIUM, Action.EDIT_CONSORTIUM, Action.SHOW_PERSON, Action.EDIT_PERSON);
        boolean hasShowAction = ActionHelper.hasActionsForAnyNetwork(networkIdToActions, showAction);
        boolean hasEditAction = ActionHelper.hasActionsForAnyNetwork(networkIdToActions, editAction);
        if (!hasShowAction && !hasEditAction) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege [" + showAction + "] or [" + editAction + "] to get data for creating an " + (consortiumFlag ? "consortium" : "organisation") + " in network [" + networkId + "]");
        }
        OrganisationInfo organisationInfo = new OrganisationInfo();
        List<Organisation> organisations = this.organisationDAO.getNetworkOrganisationNames(null, consortiumFlag);
        organisationInfo.setOrganisations(organisations);
        return organisationInfo;
    }

    private OrganisationInfo getOrganisationEditInfoImpl(Long organisationPersonId, Long organisationId, boolean consortiumFlag, Action showAction, Action editAction) {
        boolean fetchedConsortiumFlag;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Map<Long, List<Network>> memberIdToNetworks = null;
        List<OrganisationJoin> memberJoins = null;
        if (consortiumFlag) {
            memberJoins = this.organisationDAO.getMemberJoinsByConsortiumId(organisationId);
            memberIdToNetworks = this.getOrganisationToNetworksMap(memberJoins);
        }
        List<Network> networks = this.networkDAO.getNetworksByOrganisation(organisationId);
        HashSet<Long> allNetworkIds = new HashSet<Long>();
        List<Long> networkIds = ContainerHelper.getPersistentIdsList(networks);
        allNetworkIds.addAll(networkIds);
        if (consortiumFlag) {
            for (List<Network> memberNetworks : memberIdToNetworks.values()) {
                allNetworkIds.addAll(ContainerHelper.getPersistentIdsList(memberNetworks));
            }
        }
        ArrayList<Long> allNetworkIdsList = new ArrayList<Long>();
        allNetworkIdsList.addAll(allNetworkIds);
        Map<Long, Set<Action>> networkIdToActions = allNetworkIdsList.size() == 0 ? new HashMap<Long, Set<Action>>() : this.actionDAO.getNetworkToActionMap(organisationPersonId, allNetworkIdsList, Action.SHOW_ORGANISATION, Action.EDIT_ORGANISATION, Action.SHOW_CONSORTIUM, Action.EDIT_CONSORTIUM, Action.SHOW_PERSON, Action.EDIT_PERSON);
        boolean hasShowAction = ActionHelper.hasActionsForAnyNetwork(networkIdToActions, showAction);
        boolean hasEditAction = ActionHelper.hasActionsForAnyNetwork(networkIdToActions, editAction);
        if (!hasShowAction && !hasEditAction) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege [" + showAction + "] or [" + editAction + "] to access " + (consortiumFlag ? "consortium" : "organisation") + " [" + organisationId + "]");
        }
        OrganisationJoin organisationJoin = this.organisationDAO.getOrganisationJoinById(organisationId);
        boolean bl = fetchedConsortiumFlag = organisationJoin.getOrganisationConsortiumFlag() != null && organisationJoin.getOrganisationConsortiumFlag() != false;
        if (fetchedConsortiumFlag != consortiumFlag) {
            throw new IllegalArgumentException("getOrganisationEditInfo received consortiumFlag [" + consortiumFlag + "] and organisationId [" + organisationId + "], however that Organisation has consortiumFlag [" + fetchedConsortiumFlag + "], which is inconsistent to the given consortiumFlag parameter.");
        }
        OrganisationInfo organisationInfo = new OrganisationInfo();
        organisationInfo.setOrganisationJoin(organisationJoin);
        organisationInfo.setNetworks(networks);
        if (consortiumFlag) {
            ArrayList<OrganisationInfo> memberInfos = new ArrayList<OrganisationInfo>();
            for (OrganisationJoin memberJoin : memberJoins) {
                OrganisationInfo memberInfo = this.constructOrganisationInfo(memberJoin, memberIdToNetworks, networkIdToActions);
                memberInfos.add(memberInfo);
            }
            organisationInfo.setMembers(memberInfos);
        } else {
            List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoinByOrganisation(organisationId);
            organisationInfo.setOrganisationPersonJoins(organisationPersonJoins);
        }
        List<Organisation> organisations = this.organisationDAO.getNetworkOrganisationNames(null, consortiumFlag);
        organisationInfo.setOrganisations(organisations);
        HashSet<String> actions = new HashSet<String>();
        for (Long networkId : networkIds) {
            if (!networkIdToActions.containsKey(networkId)) continue;
            actions.addAll(ActionHelper.convertEnumToString(networkIdToActions.get(networkId)));
        }
        organisationInfo.setActions(actions);
        return organisationInfo;
    }

    private Map<Long, List<Network>> getOrganisationToNetworksMap(List<OrganisationJoin> organisationJoins) {
        ArrayList<Long> organisationIds = new ArrayList<Long>();
        for (OrganisationJoin organisationJoin : organisationJoins) {
            organisationIds.add(organisationJoin.getOrganisationId());
        }
        Map<Long, List<Network>> organisationIdToNetworks = QueryHelper.executeDAOGetter(organisationIds, this.sqlQueryBatchSize / 2, new BatchedDAOGetterMap<List<Network>, Long>(){

            @Override
            public Map<Long, List<Network>> execute(List<Long> ids) {
                return OrganisationServiceImpl.this.networkDAO.getNetworksByOrganisations(ids);
            }
        });
        return organisationIdToNetworks;
    }

    private OrganisationInfo constructOrganisationInfo(OrganisationJoin organisationJoin, Map<Long, List<Network>> organisationIdToNetworks, Map<Long, Set<Action>> networkIdToActions) {
        Long organisationId = organisationJoin.getOrganisationId();
        OrganisationInfo organisationInfo = new OrganisationInfo();
        organisationInfo.setOrganisationJoin(organisationJoin);
        if (organisationIdToNetworks.containsKey(organisationId)) {
            List<Network> organisationNetworks = organisationIdToNetworks.get(organisationId);
            HashSet<String> organisationActions = new HashSet<String>();
            for (Network organisationNetwork : organisationNetworks) {
                Long organisationNetworkId = organisationNetwork.getId();
                if (!networkIdToActions.containsKey(organisationNetworkId)) continue;
                Set<Action> organisationNetworkActions = networkIdToActions.get(organisationNetworkId);
                organisationActions.addAll(ActionHelper.convertEnumToString(organisationNetworkActions));
            }
            organisationInfo.setNetworks(organisationNetworks);
            organisationInfo.setActions(organisationActions);
        } else {
            organisationInfo.setNetworks(new ArrayList());
            organisationInfo.setActions(new HashSet());
        }
        return organisationInfo;
    }

    public List<Organisation> getNetworkOrganisationNames(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ArrayList<Long> networkIds = new ArrayList<Long>();
        networkIds.add(networkId);
        return this.organisationDAO.getNetworkOrganisationNames(networkId, false);
    }

    public List<OrganisationJoin> getNetworkOrganisationJoins(Long organisationPersonId, List<Long> networkIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        return this.organisationDAO.getNetworkOrganisationJoins(networkIds, false);
    }

    public List<OrganisationInfo> getNetworkOrganisationInfos(Long organisationPersonId, List<Long> networkIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkForNetworkActions(organisationPersonId, networkIds, Action.EDIT_ORGANISATION);
        HashSet<Long> allNetworkIds = new HashSet<Long>();
        allNetworkIds.addAll(networkIds);
        List<OrganisationJoin> organisationJoins = this.organisationDAO.getNetworkOrganisationJoins(networkIds, false);
        Map<Long, List<Network>> organisationIdToNetworks = this.getOrganisationToNetworksMap(organisationJoins);
        for (List<Network> networks : organisationIdToNetworks.values()) {
            for (Network network : networks) {
                allNetworkIds.add(network.getId());
            }
        }
        ArrayList<Long> allNetworkIdsList = new ArrayList<Long>();
        allNetworkIdsList.addAll(allNetworkIds);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, allNetworkIdsList, Action.SHOW_ORGANISATION, Action.EDIT_ORGANISATION, Action.SHOW_CONSORTIUM, Action.EDIT_CONSORTIUM, Action.SHOW_PERSON, Action.EDIT_PERSON);
        for (Long networkId : networkIds) {
            if (networkIdToActions.containsKey(networkId) && networkIdToActions.get(networkId).contains(Action.EDIT_ORGANISATION)) continue;
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have required permission [" + Action.EDIT_ORGANISATION.getName() + "] to query organisations for network [" + networkId + "]");
        }
        ArrayList<OrganisationInfo> organisationInfos = new ArrayList<OrganisationInfo>();
        for (OrganisationJoin organisationJoin : organisationJoins) {
            OrganisationInfo organisationInfo = this.constructOrganisationInfo(organisationJoin, organisationIdToNetworks, networkIdToActions);
            organisationInfos.add(organisationInfo);
        }
        return organisationInfos;
    }

    public List<OrganisationPersonSelectionJoin> getOrganisationPersonSelectionJoinsByOrganisation(Long organisationPersonId, Long organisationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to retrieve OrganisationPersonSelectionJoins.  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        return this.organisationPersonDAO.getOrganisationPersonSelectionJoinsByOrganisation(organisationId);
    }

    public List<OrganisationPersonSelectionJoin> getAllOrganisationPersonSelectionJoins(Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to retrieve the OrganisationPersonSelectionJoins.  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        return this.organisationPersonDAO.getAllOrganisationPersonSelectionJoins();
    }

    public List<List<String>> getOrganisationInUseHints(Long organisationPersonId, Long organisationId) {
        this.checkDeleteOrganisationPrivileges(organisationPersonId, organisationId);
        OrganisationPersonJoin organisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String locale = organisationPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        ArrayList<List<String>> hints = new ArrayList<List<String>>();
        List<OrganisationDeleteJoin> deleteJoins = this.organisationDAO.getOrganisationDeleteJoins(organisationId);
        for (OrganisationDeleteJoin deleteJoin : deleteJoins) {
            List<String> hint;
            OrganisationDeleteUnionComponent component = OrganisationDeleteUnionComponent.getByValue(deleteJoin.getUnionClause());
            String organisationName = deleteJoin.getOrganisationName();
            if (log.isDebugEnabled()) {
                log.debug("Processing OrganisationDeleteJoin: organisationId [" + organisationId + "], organisation [" + organisationName + "], component [" + (Object)((Object)component) + "]");
            }
            if (component == OrganisationDeleteUnionComponent.LABEL) {
                hint = this.getLabelRefOrganisationMessage(resourceBundle, deleteJoin);
                hints.add(hint);
                continue;
            }
            if (component == OrganisationDeleteUnionComponent.NETWORK) {
                hint = this.getNetworkRefOrganisationMessage(resourceBundle, deleteJoin);
                hints.add(hint);
                continue;
            }
            if (component == OrganisationDeleteUnionComponent.ORGANISATION_ORDER_STEP) {
                hint = this.getPlotOrderRefOrganisationMessage(resourceBundle, deleteJoin);
                hints.add(hint);
                continue;
            }
            if (component == OrganisationDeleteUnionComponent.ORGANISATION_PERSON) {
                hint = this.getOrganisationPersonRefOrganisationMessage(resourceBundle, deleteJoin);
                hints.add(hint);
                continue;
            }
            if (component == OrganisationDeleteUnionComponent.PLOT_ORDER) {
                hint = this.getPlotOrderRefOrganisationMessage(resourceBundle, deleteJoin);
                hints.add(hint);
                continue;
            }
            if (component == OrganisationDeleteUnionComponent.PROJECT_PARTICIPATION) {
                hint = this.getProjectParticipationRefOrganisationMessage(resourceBundle, deleteJoin);
                hints.add(hint);
                continue;
            }
            throw new IllegalArgumentException("Found unsupported OrganisationDeleteUnionComponent [" + (Object)((Object)component) + "]");
        }
        return hints;
    }

    private static String getNonNullInfoString(String s) {
        return s != null && s.trim().length() > 0 ? s.trim() : "---";
    }

    private List<String> getLabelRefOrganisationMessage(ResourceBundle resourceBundle, OrganisationDeleteJoin deleteJoin) {
        String organisationName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getOrganisationName());
        String labelName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getLabelName());
        ArrayList<String> hint = new ArrayList<String>();
        String rawPrefix = resourceBundle.getString("organisationInUseLabelPrefix");
        hint.add(MessageFormat.format(rawPrefix, organisationName));
        hint.add("<table>");
        hint.add("<tr>");
        hint.add(resourceBundle.getString("labelItem"));
        hint.add(labelName);
        hint.add("</tr>");
        hint.add("</table>");
        hint.add(resourceBundle.getString("organisationInUseLabelPostfix"));
        return hint;
    }

    private List<String> getNetworkRefOrganisationMessage(ResourceBundle resourceBundle, OrganisationDeleteJoin deleteJoin) {
        String organisationName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getOrganisationName());
        String networkName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getNetworkName());
        ArrayList<String> hint = new ArrayList<String>();
        String rawPrefix = resourceBundle.getString("organisationInUseNetworkPrefix");
        hint.add(MessageFormat.format(rawPrefix, organisationName));
        hint.add("<table>");
        hint.add("<tr>");
        hint.add(resourceBundle.getString("networkItem"));
        hint.add(networkName);
        hint.add("</tr>");
        hint.add("</table>");
        hint.add(resourceBundle.getString("organisationInUseNetworkPostfix"));
        return hint;
    }

    private List<String> getOrganisationPersonRefOrganisationMessage(ResourceBundle resourceBundle, OrganisationDeleteJoin deleteJoin) {
        String organisationName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getOrganisationName());
        String personName = PersonHelper.getCommonName(deleteJoin.getPerson());
        ArrayList<String> hint = new ArrayList<String>();
        String rawPrefix = resourceBundle.getString("organisationInUseOrganisationPersonPrefix");
        hint.add(MessageFormat.format(rawPrefix, organisationName));
        hint.add("<table>");
        hint.add("<tr>");
        hint.add(resourceBundle.getString("person"));
        hint.add(personName);
        hint.add("</tr>");
        hint.add("</table>");
        hint.add(resourceBundle.getString("organisationInUseOrganisationPersonPostfix"));
        return hint;
    }

    private List<String> getPlotOrderRefOrganisationMessage(ResourceBundle resourceBundle, OrganisationDeleteJoin deleteJoin) {
        String organisationName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getOrganisationName());
        String templateName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getPlottOrderTemplateName());
        Long jobNumber = deleteJoin.getPlottOrderJobNumber();
        String jobNumberString = jobNumber != null ? jobNumber.toString() : "\u2015";
        ArrayList<String> hint = new ArrayList<String>();
        String rawPrefix = resourceBundle.getString("organisationInUseOrganisationOrderStepPrefix");
        hint.add(MessageFormat.format(rawPrefix, organisationName));
        hint.add("<table>");
        hint.add("<tr>");
        hint.add(resourceBundle.getString("plotOrderTemplate"));
        hint.add(templateName);
        hint.add("</tr>");
        hint.add("<tr>");
        hint.add(resourceBundle.getString("plotOrderJobNumber"));
        hint.add(jobNumberString);
        hint.add("</tr>");
        hint.add("</table>");
        hint.add(resourceBundle.getString("organisationInUseOrganisationOrderStepPostfix"));
        return hint;
    }

    private List<String> getProjectParticipationRefOrganisationMessage(ResourceBundle resourceBundle, OrganisationDeleteJoin deleteJoin) {
        String organisationName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getOrganisationName());
        String personName = deleteJoin.getPersonId() != null ? PersonHelper.getCommonName(deleteJoin.getPerson()) : "\u2015";
        String projectCode = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getProjectCode());
        String projectName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getProjectName());
        String networkName = OrganisationServiceImpl.getNonNullInfoString(deleteJoin.getNetworkName());
        ArrayList<String> hint = new ArrayList<String>();
        String rawPrefix = resourceBundle.getString("organisationInUseProjectParticipationPrefix");
        hint.add(MessageFormat.format(rawPrefix, organisationName));
        hint.add("<table>");
        hint.add("<tr>");
        hint.add(resourceBundle.getString("person"));
        hint.add(personName);
        hint.add("</tr>");
        hint.add("<tr>");
        hint.add(resourceBundle.getString("project"));
        hint.add(projectCode + " " + projectName);
        hint.add("</tr>");
        hint.add("<tr>");
        hint.add(resourceBundle.getString("network"));
        hint.add(networkName);
        hint.add("</tr>");
        hint.add("</table>");
        return hint;
    }

    public void deleteOrganisation(Long organisationPersonId, Long organisationId) {
        this.checkDeleteOrganisationPrivileges(organisationPersonId, organisationId);
        Organisation organisation = (Organisation)this.organisationDAO.get(organisationId);
        this.consortiumMemberDAO.deleteByOrganisation(organisationId);
        this.networkOrganisationDAO.deleteByOrganisation(organisationId);
        if (organisation.isConsortiumFlag().booleanValue()) {
            this.consortiumMemberDAO.deleteByConsortium(organisationId);
        }
        this.organisationDAO.delete(organisationId);
    }

    public void addOrganisationToNetworks(Long organisationPersonId, Long organisationId, List<Long> networkIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForAllNetworks(this.actionDAO, organisationPersonId, networkIds, Action.REFERENCE_ORGANISATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to add organisation [" + organisationId + "] to networks [" + networkIds + "]; missing permission is [" + Action.REFERENCE_ORGANISATION.getName() + "]");
        }
        List<NetworkOrganisation> networkOrganisations = this.networkOrganisationDAO.getByOrganisation(organisationId);
        HashSet<Long> alreadyExistingNetworkIds = new HashSet<Long>();
        for (NetworkOrganisation networkOrganisation : networkOrganisations) {
            Long currNetworkId = networkOrganisation.getNetworkId();
            alreadyExistingNetworkIds.add(currNetworkId);
        }
        ArrayList<NetworkOrganisation> newNetworkOrganisations = new ArrayList<NetworkOrganisation>();
        for (Long networkId : networkIds) {
            if (alreadyExistingNetworkIds.contains(networkId)) continue;
            NetworkOrganisation networkOrganisation = new NetworkOrganisation();
            networkOrganisation.setOrganisationId(organisationId);
            networkOrganisation.setNetworkId(networkId);
            newNetworkOrganisations.add(networkOrganisation);
        }
        if (newNetworkOrganisations.size() > 0) {
            this.networkOrganisationDAO.saveBatch(newNetworkOrganisations);
        }
    }

    public List<OrganisationInfo> getSimilarOrganisations(Long organisationPersonId, Organisation organisation) {
        return this.getSimilarOrganisationsImpl(organisationPersonId, organisation, false, Action.EDIT_ORGANISATION);
    }

    public List<OrganisationInfo> getSimilarConsortiums(Long organisationPersonId, Organisation organisation) {
        return this.getSimilarOrganisationsImpl(organisationPersonId, organisation, true, Action.EDIT_CONSORTIUM);
    }

    private List<OrganisationInfo> getSimilarOrganisationsImpl(Long organisationPersonId, Organisation organisation, Boolean consortiumFlag, Action editAction) {
        List<Long> networkIds;
        Map<Long, Set<Action>> networkIdToActions;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Long organisationId = organisation.getId();
        List<Network> networks = this.networkDAO.getNetworksByOrganisation(organisationId);
        if (networks.size() > 0 && !ActionHelper.hasActionsForAnyNetwork(networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds = ContainerHelper.getPersistentIdsList(networks), editAction), editAction)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to query similar organisations to organisation [" + organisationId + "] in networks [" + networkIds + "]; permission [" + editAction.getName() + "] is needed for at least one of these networks.");
        }
        List<Organisation> candidateOrganisations = this.organisationDAO.getByConsortiumFlag(consortiumFlag);
        ArrayList<OrganisationJoin> matchingOrganisationJoins = new ArrayList<OrganisationJoin>();
        String name = organisation.getName();
        for (Organisation candidateOrganisation : candidateOrganisations) {
            String candidateName = candidateOrganisation.getName();
            if (organisation.getId() != null && organisation.getId().longValue() == candidateOrganisation.getId().longValue() || !SearchHelper.areStringsSimilar(name, candidateName, 3)) continue;
            OrganisationJoin organisationJoin = new OrganisationJoin();
            organisationJoin.setOrganisationId(candidateOrganisation.getId());
            organisationJoin.setOrganisationName(candidateOrganisation.getName());
            matchingOrganisationJoins.add(organisationJoin);
        }
        Map<Long, List<Network>> organisationIdToNetworks = this.getOrganisationToNetworksMap(matchingOrganisationJoins);
        HashSet<Long> allNetworkIds = new HashSet<Long>();
        for (List list : organisationIdToNetworks.values()) {
            for (Network currNetwork : list) {
                allNetworkIds.add(currNetwork.getId());
            }
        }
        ArrayList<Long> allNetworkIdsList = new ArrayList<Long>();
        allNetworkIdsList.addAll(allNetworkIds);
        HashMap hashMap = allNetworkIdsList != null && allNetworkIdsList.size() > 0 ? this.actionDAO.getNetworkToActionMap(organisationPersonId, allNetworkIdsList, Action.REFERENCE_ORGANISATION) : new HashMap();
        ArrayList<OrganisationInfo> organisationInfos = new ArrayList<OrganisationInfo>();
        for (OrganisationJoin organisationJoin : matchingOrganisationJoins) {
            OrganisationInfo organisationInfo = new OrganisationInfo();
            organisationInfo.setOrganisationJoin(organisationJoin);
            Long currOrganisationId = organisationJoin.getOrganisationId();
            List<Network> currNetworks = organisationIdToNetworks.get(currOrganisationId);
            if (currNetworks == null) {
                currNetworks = new ArrayList<Network>();
            }
            organisationInfo.setNetworks(currNetworks);
            HashSet<String> currActions = new HashSet<String>();
            for (Network network : currNetworks) {
                if (!hashMap.containsKey(network.getId())) continue;
                Set matchingActions = (Set)hashMap.get(network.getId());
                currActions.addAll(ActionHelper.convertEnumToString(matchingActions));
            }
            organisationInfo.setActions(currActions);
            organisationInfos.add(organisationInfo);
        }
        return organisationInfos;
    }

    public OrganisationInfo saveOrUpdateOrganisation(Long organisationPersonId, Organisation organisation, Long networkId) {
        Long organisationId = organisation.getId();
        if (organisationId != null) {
            boolean oldConsortiumFlag;
            Organisation oldOrganisation = (Organisation)this.organisationDAO.get(organisationId);
            boolean bl = oldConsortiumFlag = oldOrganisation.getConsortiumFlag() != null && oldOrganisation.getConsortiumFlag() != false;
            if (oldConsortiumFlag) {
                throw new IllegalArgumentException("Trying to update consortium [" + organisationId + "] towards organisation, this is forbidden.");
            }
        }
        organisation.setConsortiumFlag(Boolean.valueOf(false));
        return this.saveOrUpdateImpl(organisationPersonId, organisation, networkId, null, Action.EDIT_ORGANISATION);
    }

    public OrganisationInfo saveOrUpdateConsortium(Long organisationPersonId, Organisation consortium, Long networkId, Set<Long> memberIds) {
        Long organisationId = consortium.getId();
        if (organisationId != null) {
            boolean oldConsortiumFlag;
            Organisation oldConsortium = (Organisation)this.organisationDAO.get(organisationId);
            boolean bl = oldConsortiumFlag = oldConsortium.getConsortiumFlag() != null && oldConsortium.getConsortiumFlag() != false;
            if (!oldConsortiumFlag) {
                throw new IllegalArgumentException("Trying to update organisation [" + organisationId + "] towards consortium, this is forbidden.");
            }
        }
        consortium.setConsortiumFlag(Boolean.valueOf(true));
        return this.saveOrUpdateImpl(organisationPersonId, consortium, networkId, memberIds, Action.EDIT_CONSORTIUM);
    }

    private OrganisationInfo saveOrUpdateImpl(Long organisationPersonId, Organisation organisation, Long networkId, Set<Long> memberIds, Action editAction) {
        ArrayList<Long> networkIds;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Long organisationId = organisation.getId();
        if (organisationId == null) {
            networkIds = new ArrayList<Long>();
            networkIds.add(networkId);
        } else {
            List<Network> networks = this.networkDAO.getNetworksByOrganisation(organisationId);
            networkIds = ContainerHelper.getPersistentIdsList(networks);
        }
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, editAction);
        if (!ActionHelper.hasActionsForAnyNetwork(networkIdToActions, editAction)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to query similar organisations to organisation [" + organisationId + "] in networks [" + networkIds + "]; permission [" + editAction.getName() + "] is needed for at least one of these networks.");
        }
        if (organisationId == null && networkId == null) {
            throw new IllegalArgumentException("When creating new Organisations, a network must be given.");
        }
        if (organisationId == null) {
            organisation = (Organisation)this.organisationDAO.save(organisation);
            organisationId = organisation.getId();
            NetworkOrganisation networkOrganisation = new NetworkOrganisation();
            networkOrganisation.setNetworkId(networkId);
            networkOrganisation.setOrganisationId(organisationId);
            this.networkOrganisationDAO.save(networkOrganisation);
        } else {
            this.organisationDAO.update(organisation);
        }
        if (organisation.getConsortiumFlag() != null && organisation.getConsortiumFlag().booleanValue()) {
            List<ConsortiumMember> oldConsortiumMembers = this.consortiumMemberDAO.getByConsortium(organisationId);
            HashSet<Long> oldMemberIds = new HashSet<Long>();
            for (ConsortiumMember consortiumMember : oldConsortiumMembers) {
                oldMemberIds.add(consortiumMember.getOrganisationId());
            }
            Set<Long> memberIdsToRemove = ContainerHelper.getDeletedKeys(oldMemberIds, memberIds);
            Set<Long> memberIdsToAdd = ContainerHelper.getNewKeys(oldMemberIds, memberIds);
            for (Long memberIdToRemove : memberIdsToRemove) {
                this.consortiumMemberDAO.deleteByOrganisation(memberIdToRemove);
            }
            if (memberIdsToAdd.size() > 0) {
                ArrayList<ConsortiumMember> newConsortiumMembers = new ArrayList<ConsortiumMember>();
                for (Long memberIdToAdd : memberIdsToAdd) {
                    ConsortiumMember newConsortiumMember = new ConsortiumMember();
                    newConsortiumMember.setConsortiumId(organisationId);
                    newConsortiumMember.setOrganisationId(memberIdToAdd);
                    newConsortiumMembers.add(newConsortiumMember);
                }
                this.consortiumMemberDAO.saveBatch(newConsortiumMembers);
            }
        }
        if (organisation.getConsortiumFlag() != null && organisation.getConsortiumFlag().booleanValue()) {
            return this.getConsortiumEditInfo(organisationPersonId, organisationId);
        }
        return this.getOrganisationEditInfo(organisationPersonId, organisationId);
    }

    private void checkDeleteOrganisationPrivileges(Long organisationPersonId, Long organisationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<Network> networks = this.networkDAO.getNetworksByOrganisation(organisationId);
        List<Long> networkIds = ContainerHelper.getPersistentIdsList(networks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, Action.DELETE_ORGANISATION);
        if (!ActionHelper.hasActionsForAllNetworks(networkIdToActions, Action.DELETE_ORGANISATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to delete organisation [" + organisationId + "], since it misses the permission [" + Action.DELETE_ORGANISATION.getName() + "] for at least one of its networks [" + networkIds + "]");
        }
    }

    private void checkForGlobalNetworkActions(Long organisationPersonId) {
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.NETWORK_SECTION_OVERVIEW, Action.SUPER_ADMIN_RIGHT);
        if (!globalActions.contains(Action.NETWORK_SECTION_OVERVIEW) && !globalActions.contains(Action.SUPER_ADMIN_RIGHT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has neither global permission [networkSectionOverview] nor global permission [superAdminRight].");
        }
    }

    private void checkForNetworkActions(Long organisationPersonId, List<Long> networkIds, Action actionName) {
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, actionName);
        for (Long networkId : networkIds) {
            if (networkIdToActions.containsKey(networkId) && networkIdToActions.get(networkId).contains(actionName)) continue;
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have required permission [" + actionName + "] to query organisations for network [" + networkId + "]");
        }
    }

    public String triggerExportOrganisationList(OrganisationSearchModel searchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns) {
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkForGlobalNetworkActions(organisationPersonId);
        List columnSortSpecs = ColumnSortSpec.getFromClient(sortColumns);
        OrganisationListPdfCallable job = new OrganisationListPdfCallable(this.organisationListExporter, this, searchModel, columnToWidth, columnSortSpecs, this.enableCustomerLogo);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public String triggerExportConsortiumList(OrganisationSearchModel searchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns) {
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkForGlobalNetworkActions(organisationPersonId);
        List columnSortSpecs = ColumnSortSpec.getFromClient(sortColumns);
        ConsortiumListPdfCallable job = new ConsortiumListPdfCallable(this.consortiumListExporter, this, searchModel, columnToWidth, columnSortSpecs, this.enableCustomerLogo);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }
}

