/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentList;
import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentNumberPartGroup;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.api.dto.FutureEmail;
import at.cdes.api.dto.Localisation;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkPerson;
import at.cdes.api.dto.ObjectList;
import at.cdes.api.dto.ObjectListRelease;
import at.cdes.api.dto.ObjectPlannerDefinition;
import at.cdes.api.dto.ObjectPlannerPositionDefinition;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Persistent;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PlottOrder;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipantHistoryPart;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ProjectParticipationSubProjectRestrictions;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.RoleType;
import at.cdes.api.dto.SubProject;
import at.cdes.api.dto.SubProjectType;
import at.cdes.api.guiService.ProjectService;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ObjectPlannerDefinitionTemplateJoin;
import at.cdes.api.joinDto.ObjectPlannerPositionReleaseChainJoin;
import at.cdes.api.joinDto.OrganisationJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.OrganisationPersonSelectionJoin;
import at.cdes.api.joinDto.ParticipationDeleteJoin;
import at.cdes.api.joinDto.ParticipationListJoin;
import at.cdes.api.joinDto.ParticipationPageEditJoin;
import at.cdes.api.joinDto.ParticipationPageSearchJoin;
import at.cdes.api.joinDto.PlotOrderDeleteJoin;
import at.cdes.api.joinDto.ProjectEditJoin;
import at.cdes.api.joinDto.ProjectPageJoin;
import at.cdes.api.joinDto.ProjectParticipantHistoryPartJoin;
import at.cdes.api.joinDto.ProjectParticipationJoin;
import at.cdes.api.joinDto.ProjectSearchJoin;
import at.cdes.api.joinDto.ReviewCycleRealmChainJoin;
import at.cdes.api.joinDto.RoleConflictJoin;
import at.cdes.api.joinDto.SubProjectRestrictionsJoin;
import at.cdes.api.person.compositeDto.ConsortiumPersonInfo;
import at.cdes.api.person.compositeDto.OrganisationPersonInfo;
import at.cdes.api.project.compositeDto.IRestrictionParticipationEditInfo;
import at.cdes.api.project.compositeDto.ObjectPlannerDefinitionInfo;
import at.cdes.api.project.compositeDto.ObjectPlannerPositionDefinitionInfo;
import at.cdes.api.project.compositeDto.OrganisationParticipationEditInfo;
import at.cdes.api.project.compositeDto.OrganisationParticipationInfo;
import at.cdes.api.project.compositeDto.ParticipantInfo;
import at.cdes.api.project.compositeDto.ParticipationDeleteInfo;
import at.cdes.api.project.compositeDto.ParticipationEditInfo;
import at.cdes.api.project.compositeDto.ParticipationInfo;
import at.cdes.api.project.compositeDto.ParticipationPageEditInfo;
import at.cdes.api.project.compositeDto.ParticipationPageInfo;
import at.cdes.api.project.compositeDto.ParticipationPageSearchInfo;
import at.cdes.api.project.compositeDto.ParticipationSearchInfo;
import at.cdes.api.project.compositeDto.ParticipationSecurityInfo;
import at.cdes.api.project.compositeDto.ProjectInfo;
import at.cdes.api.project.compositeDto.ProjectListPageInfo;
import at.cdes.api.project.compositeDto.ProjectPageInfo;
import at.cdes.api.project.compositeDto.ProjectPageSearchInfo;
import at.cdes.api.project.compositeDto.ProjectSaveInfo;
import at.cdes.api.project.compositeDto.RestrictionParticipationEditInfo;
import at.cdes.api.project.compositeDto.RoleConflictInfo;
import at.cdes.api.project.compositeDto.SubProjectEditInfo;
import at.cdes.api.project.compositeDto.SubProjectInfo;
import at.cdes.api.project.searchModel.ParticipationPageSearchModel;
import at.cdes.api.project.searchModel.ProjectPageSearchModel;
import at.cdes.api.project.searchModel.ProjectParticipationSearchModel;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.voc.CdesErrors;
import at.cdes.api.voc.ProjectFlag;
import at.cdes.api.voc.ProjectStatus;
import at.cdes.api.voc.RoleTypeEnum;
import at.cdes.api.voc.action.Action;
import at.cdes.api.voc.project.ProjectAccess;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.CdesRoleDAO;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentListDAO;
import at.cdes.impl.dao.DocumentNumberPartDAO;
import at.cdes.impl.dao.DocumentNumberPartGroupDAO;
import at.cdes.impl.dao.DocumentReleaseDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.DocumentVersionTaskDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.LocalisationDAO;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.NetworkPersonDAO;
import at.cdes.impl.dao.ObjectListDAO;
import at.cdes.impl.dao.ObjectListReleaseDAO;
import at.cdes.impl.dao.ObjectPlannerDefinitionDAO;
import at.cdes.impl.dao.ObjectPlannerDefinitionTemplateDAO;
import at.cdes.impl.dao.ObjectPlannerPositionDefinitionDAO;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.OrderStepDAO;
import at.cdes.impl.dao.OrganisationDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.dao.PlottOrderDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectHolidayDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipantHistoryPartDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ProjectParticipationSubProjectRestrictionsDAO;
import at.cdes.impl.dao.RealmDAO;
import at.cdes.impl.dao.ReviewCycleDAO;
import at.cdes.impl.dao.ReviewCycleNodePositionDAO;
import at.cdes.impl.dao.ReviewCycleResultOptionDAO;
import at.cdes.impl.dao.RoleTypeDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.dao.SubProjectTypeDAO;
import at.cdes.impl.dao.unionComponent.ParticipationPageEditUnionComponent;
import at.cdes.impl.dao.unionComponent.ParticipationPageSearchUnionComponent;
import at.cdes.impl.email.EmailUtils;
import at.cdes.impl.export.project.ParticipationPdfCallable;
import at.cdes.impl.export.project.ParticipationPdfExporter;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.objects.ObjectUtils;
import at.cdes.impl.planDeliver.PlanDeliverUtils;
import at.cdes.impl.plot.PlotUtils;
import at.cdes.impl.project.ProjectUtils;
import at.cdes.impl.reviewCycle.ReviewUtils;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.MappedCollection;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.StreamUtil;
import at.cdes.impl.util.i18n.I18nHelper;
import com.google.gson.GsonBuilder;
import java.text.Collator;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.clazzes.gson.rpc2.JsonRpcException;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectServiceImpl
implements ProjectService {
    private static final Logger log = LoggerFactory.getLogger(ProjectServiceImpl.class);
    private CdesRoleDAO cdesRoleDAO;
    private DocumentVersionTaskDAO documentVersionTaskDAO;
    private EmailUtils emailUtils;
    private Boolean enableCustomerLogo;
    private String costumerLabel;
    private FutureEmailDAO futureEmailDAO;
    private PlanDeliverUtils planDeliverUtils;
    private DocumentListDAO documentListDAO;
    private ObjectListDAO objectListDAO;
    private ObjectListReleaseDAO objectListReleaseDAO;
    private ObjectPlannerDefinitionDAO objectPlannerDefinitionDAO;
    private ObjectPlannerDefinitionTemplateDAO objectPlannerDefinitionTemplateDAO;
    private ObjectPlannerPositionDefinitionDAO objectPlannerPositionDefinitionDAO;
    private ObjectPlannerReleaseDAO objectPlannerReleaseDAO;
    private ObjectUtils objectUtils;
    private IOneTimeScheduler oneTimeScheduler;
    private OrderStepDAO orderStepDAO;
    private OrganisationDAO organisationDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private ParticipationPdfExporter participationPdfExporter;
    private PlottOrderDAO plotOrderDAO;
    private PlotUtils plotUtils;
    private ProjectDAO projectDAO;
    private ProjectParticipantHistoryPartDAO projectParticipantHistoryPartDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ProjectParticipationSubProjectRestrictionsDAO projectParticipationSubProjectRestrictionDAO;
    private ProjectUtils projectUtils;
    private RealmDAO realmDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private ReviewCycleNodePositionDAO reviewCycleNodePositionDAO;
    private ReviewUtils reviewUtils;
    private RoleTypeDAO roleTypeDAO;
    private PersonDAO personDAO;
    private SubProjectDAO subProjectDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ActionDAO actionDAO;
    private PlottOrderDAO plottOrderDAO;
    private ProjectParticipationSubProjectRestrictionsDAO projectParticipationSubProjectRestrictionsDAO;
    private NetworkDAO networkDAO;
    private SubProjectTypeDAO subProjectTypeDAO;
    private LocalisationDAO localisationDAO;
    private DocumentNumberPartGroupDAO documentNumberPartGroupDAO;
    private DocumentNumberPartDAO documentNumberPartDAO;
    private ProjectHolidayDAO projectHolidayDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private DocumentVersionDAO documentVersionDAO;
    private DocumentDAO documentDAO;
    private DocumentReleaseDAO documentReleaseDAO;
    private NetworkPersonDAO networkPersonDAO;
    private Boolean isTestInstance;

    public void setCdesRoleDAO(CdesRoleDAO cdesRoleDAO) {
        this.cdesRoleDAO = cdesRoleDAO;
    }

    public void setDocumentVersionTaskDAO(DocumentVersionTaskDAO documentVersionTaskDAO) {
        this.documentVersionTaskDAO = documentVersionTaskDAO;
    }

    public void setEmailUtils(EmailUtils emailUtils) {
        this.emailUtils = emailUtils;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public void setFutureEmailDAO(FutureEmailDAO futureEmailDAO) {
        this.futureEmailDAO = futureEmailDAO;
    }

    public void setPlanDeliverUtils(PlanDeliverUtils planDeliverUtils) {
        this.planDeliverUtils = planDeliverUtils;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setObjectListDAO(ObjectListDAO objectListDAO) {
        this.objectListDAO = objectListDAO;
    }

    public void setObjectListReleaseDAO(ObjectListReleaseDAO objectListReleaseDAO) {
        this.objectListReleaseDAO = objectListReleaseDAO;
    }

    public void setObjectPlannerDefinitionDAO(ObjectPlannerDefinitionDAO objectPlannerDefinitionDAO) {
        this.objectPlannerDefinitionDAO = objectPlannerDefinitionDAO;
    }

    public void setObjectPlannerDefinitionTemplateDAO(ObjectPlannerDefinitionTemplateDAO objectPlannerDefinitionTemplateDAO) {
        this.objectPlannerDefinitionTemplateDAO = objectPlannerDefinitionTemplateDAO;
    }

    public void setObjectPlannerPositionDefinitionDAO(ObjectPlannerPositionDefinitionDAO objectPlannerPositionDefinitionDAO) {
        this.objectPlannerPositionDefinitionDAO = objectPlannerPositionDefinitionDAO;
    }

    public void setObjectPlannerReleaseDAO(ObjectPlannerReleaseDAO objectPlannerReleaseDAO) {
        this.objectPlannerReleaseDAO = objectPlannerReleaseDAO;
    }

    public void setObjectUtils(ObjectUtils objectUtils) {
        this.objectUtils = objectUtils;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setOrderStepDAO(OrderStepDAO orderStepDAO) {
        this.orderStepDAO = orderStepDAO;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setParticipationPdfExporter(ParticipationPdfExporter participationPdfExporter) {
        this.participationPdfExporter = participationPdfExporter;
    }

    public void setPlotOrderDAO(PlottOrderDAO plotOrderDAO) {
        this.plotOrderDAO = plotOrderDAO;
    }

    public void setPlotUtils(PlotUtils plotUtils) {
        this.plotUtils = plotUtils;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectParticipantHistoryPartDAO(ProjectParticipantHistoryPartDAO projectParticipantHistoryPartDAO) {
        this.projectParticipantHistoryPartDAO = projectParticipantHistoryPartDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setProjectParticipationSubProjectRestrictionDAO(ProjectParticipationSubProjectRestrictionsDAO projectParticipationSubProjectRestrictionDAO) {
        this.projectParticipationSubProjectRestrictionDAO = projectParticipationSubProjectRestrictionDAO;
    }

    public void setProjectUtils(ProjectUtils projectUtils) {
        this.projectUtils = projectUtils;
    }

    public void setRealmDAO(RealmDAO realmDAO) {
        this.realmDAO = realmDAO;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    public void setReviewCycleNodePositionDAO(ReviewCycleNodePositionDAO reviewCycleNodePositionDAO) {
        this.reviewCycleNodePositionDAO = reviewCycleNodePositionDAO;
    }

    public void setReviewUtils(ReviewUtils reviewUtils) {
        this.reviewUtils = reviewUtils;
    }

    public void setRoleTypeDAO(RoleTypeDAO roleTypeDAO) {
        this.roleTypeDAO = roleTypeDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setPlottOrderDAO(PlottOrderDAO plottOrderDAO) {
        this.plottOrderDAO = plottOrderDAO;
    }

    public void setProjectParticipationSubProjectRestrictionsDAO(ProjectParticipationSubProjectRestrictionsDAO projectParticipationSubProjectRestrictionsDAO) {
        this.projectParticipationSubProjectRestrictionsDAO = projectParticipationSubProjectRestrictionsDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setSubProjectTypeDAO(SubProjectTypeDAO subProjectTypeDAO) {
        this.subProjectTypeDAO = subProjectTypeDAO;
    }

    public void setLocalisationDAO(LocalisationDAO localisationDAO) {
        this.localisationDAO = localisationDAO;
    }

    public void setDocumentNumberPartGroupDAO(DocumentNumberPartGroupDAO documentNumberPartGroupDAO) {
        this.documentNumberPartGroupDAO = documentNumberPartGroupDAO;
    }

    public void setDocumentNumberPartDAO(DocumentNumberPartDAO documentNumberPartDAO) {
        this.documentNumberPartDAO = documentNumberPartDAO;
    }

    public void setProjectHolidayDAO(ProjectHolidayDAO projectHolidayDAO) {
        this.projectHolidayDAO = projectHolidayDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentReleaseDAO(DocumentReleaseDAO documentReleaseDAO) {
        this.documentReleaseDAO = documentReleaseDAO;
    }

    public void setNetworkPersonDAO(NetworkPersonDAO networkPersonDAO) {
        this.networkPersonDAO = networkPersonDAO;
    }

    public void setIsTestInstance(Boolean isTestInstance) {
        this.isTestInstance = isTestInstance;
    }

    public ParticipationSecurityInfo getParticipationSecurityInfo(Long organisationPersonId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ParticipationSecurityInfo participationSecurityInfo = new ParticipationSecurityInfo();
        if (projectId == null) {
            return participationSecurityInfo;
        }
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.PROJECT_PARTICIPATIONS_OVERVIEW)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to query supported actions for project [" + projectId + "], due to lack of permission [" + Action.PROJECT_PARTICIPATIONS_OVERVIEW + "]");
        }
        Set<Action> superAdminActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT);
        boolean hasSuperAdminRight = superAdminActions.contains(Action.SUPER_ADMIN_RIGHT);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkActions(organisationPersonId, Action.EDIT_PERSON, Action.SHOW_PERSON);
        boolean hasEditPerson = ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.EDIT_PERSON);
        boolean hasShowPerson = ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.SHOW_PERSON);
        Set<Action> projectActions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.PROJECT_PARTICIPATIONS_OVERVIEW, Action.EDIT_PROJECT_PARTICIPATION, Action.DELETE_PROJECT_PARTICIPATION, Action.SHOW_PROJECT_PARTICIPATION, Action.INSERT_PROJECT_PARTICIPATION);
        boolean hasEditProjectParticipation = projectActions.contains(Action.EDIT_PROJECT_PARTICIPATION);
        boolean hasShowProjectParticipation = projectActions.contains(Action.SHOW_PROJECT_PARTICIPATION);
        boolean hasDeleteProjectParticipation = projectActions.contains(Action.DELETE_PROJECT_PARTICIPATION);
        boolean hasInsertProjectParticipation = projectActions.contains(Action.INSERT_PROJECT_PARTICIPATION);
        participationSecurityInfo.setMayExportPdf(projectActions.contains(Action.PROJECT_PARTICIPATIONS_OVERVIEW));
        participationSecurityInfo.setMayInsertParticipation(hasInsertProjectParticipation);
        participationSecurityInfo.setMayEmailAllParticipations(hasEditPerson || hasShowPerson);
        participationSecurityInfo.setMayShowPerson(hasShowPerson);
        participationSecurityInfo.setMayEmailParticipation(hasEditPerson || hasShowPerson);
        participationSecurityInfo.setMayDeleteDeputy(hasEditProjectParticipation || hasSuperAdminRight);
        participationSecurityInfo.setMayInsertMeAsDeputy(hasEditProjectParticipation || hasSuperAdminRight);
        participationSecurityInfo.setMayShowHistory(hasEditProjectParticipation);
        participationSecurityInfo.setMayDeleteParticipation(hasDeleteProjectParticipation);
        participationSecurityInfo.setMayEditParticipation(hasEditProjectParticipation);
        participationSecurityInfo.setMayShowParticipation(hasShowProjectParticipation);
        return participationSecurityInfo;
    }

    public ParticipationSearchInfo getParticipationSearchInfo(Long organisationPersonId, Long personId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        HashMap<Long, Person> idToPerson = new HashMap<Long, Person>();
        HashMap<Long, Organisation> idToOrganisation = new HashMap<Long, Organisation>();
        Person person = (Person)this.personDAO.get(personId);
        List<OrganisationPersonSelectionJoin> orgPersonJoins = this.organisationPersonDAO.getParticipationSearchOrganisationPersonSelectionJoins(personId);
        for (OrganisationPersonSelectionJoin join : orgPersonJoins) {
            idToPerson.put(join.getPersonId(), join.getPerson());
            idToOrganisation.put(join.getOrganisationId(), join.getOrganisation());
        }
        List<CdesRole> cdesRoles = this.cdesRoleDAO.getByPersonViaParticipations(personId);
        HashMap<Long, Network> idToNetwork = new HashMap<Long, Network>();
        HashMap<Long, Project> idToProject = new HashMap<Long, Project>();
        HashMap<Long, SubProject> idToSubProject = new HashMap<Long, SubProject>();
        HashMap<Long, ObjectRelease> idToObjectRelease = new HashMap<Long, ObjectRelease>();
        HashMap subProjectIdToObjectReleaseIds = new HashMap();
        HashMap<Long, ObjectPlannerRelease> idToObjectPlannerRelease = new HashMap<Long, ObjectPlannerRelease>();
        HashMap<Long, ReviewCycleInstanceReleased> idToReviewCycleInstanceReleased = new HashMap<Long, ReviewCycleInstanceReleased>();
        HashMap<Long, ObjectPlannerPositionDefinition> idToObjectPlannerPositionDefinition = new HashMap<Long, ObjectPlannerPositionDefinition>();
        HashMap projectIdToObjectPlannerPositionDefinitionIds = new HashMap();
        List<ObjectPlannerPositionReleaseChainJoin> objectPlannerReleaseChainJoins = this.objectPlannerReleaseDAO.getObjectPlannerPositionReleaseChainJoinsByPersonViaObjectPlannerPositionRelease(personId);
        for (ObjectPlannerPositionReleaseChainJoin join : objectPlannerReleaseChainJoins) {
            Long positionDefinitionId;
            if (join.getNetworkId() != null) {
                idToNetwork.put(join.getNetworkId(), join.getNetwork());
            }
            if (join.getProjectId() != null) {
                idToProject.put(join.getProjectId(), join.getProject());
            }
            if (join.getSubProjectId() != null) {
                idToSubProject.put(join.getSubProjectId(), join.getSubProject());
            }
            if (join.getObjectReleaseId() != null) {
                idToObjectRelease.put(join.getObjectReleaseId(), join.getObjectRelease());
                Long subProjectId = join.getSubProjectId();
                if (!subProjectIdToObjectReleaseIds.containsKey(subProjectId)) {
                    subProjectIdToObjectReleaseIds.put(subProjectId, new HashSet());
                }
                ((Set)subProjectIdToObjectReleaseIds.get(subProjectId)).add(join.getObjectReleaseId());
            }
            if (join.getObjectPlannerReleaseId() != null) {
                idToObjectPlannerRelease.put(join.getObjectPlannerReleaseId(), join.getObjectPlannerRelease());
            }
            if (join.getReviewCycleInstanceReleased() != null && join.getReviewCycleInstanceReleasedId() != null) {
                idToReviewCycleInstanceReleased.put(join.getReviewCycleInstanceReleasedId(), join.getReviewCycleInstanceReleased());
            }
            if ((positionDefinitionId = join.getObjectPlannerPositionDefinitionId()) == null) continue;
            idToObjectPlannerPositionDefinition.put(positionDefinitionId, join.getObjectPlannerPositionDefinition());
            Long projectId = join.getObjectPlannerDefinitionProjectId();
            if (projectId == null) continue;
            if (!projectIdToObjectPlannerPositionDefinitionIds.containsKey(projectId)) {
                projectIdToObjectPlannerPositionDefinitionIds.put(projectId, new ArrayList());
            }
            ((List)projectIdToObjectPlannerPositionDefinitionIds.get(projectId)).add(positionDefinitionId);
        }
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        HashMap<Long, ReviewCycle> idToReviewCycle = new HashMap<Long, ReviewCycle>();
        HashMap networkIdToReviewCycleIds = new HashMap();
        HashMap<Long, ReviewCycleCell> idToReviewCycleCell = new HashMap<Long, ReviewCycleCell>();
        HashMap<Long, ReviewCycleNode> idToReviewCycleNode = new HashMap<Long, ReviewCycleNode>();
        HashMap<Long, Realm> idToRealm = new HashMap<Long, Realm>();
        List<ReviewCycleRealmChainJoin> reviewCycleRealmChainJoins = this.reviewCycleDAO.getReviewCycleRealmChainJoinsByPersonViaInstanceReleased(personId);
        for (ReviewCycleRealmChainJoin join : reviewCycleRealmChainJoins) {
            Long networkId;
            if (join.getReviewCycleId() != null) {
                ReviewCycle reviewCycle = join.getReviewCycle();
                String reviewCycleName = I18nHelper.convertDatabaseToJs(reviewCycle.getName(), personVariablesUserLocale, null);
                reviewCycle.setName(reviewCycleName);
                idToReviewCycle.put(join.getReviewCycleId(), reviewCycle);
            }
            if (!networkIdToReviewCycleIds.containsKey(networkId = join.getNetworkReviewCycleNetworkId())) {
                networkIdToReviewCycleIds.put(networkId, new ArrayList());
            }
            ((List)networkIdToReviewCycleIds.get(networkId)).add(join.getNetworkReviewCycleReviewCycleId());
            if (join.getReviewCycleCellId() != null) {
                ReviewCycleCell reviewCycleCell = join.getReviewCycleCell();
                String reviewCycleCellName = I18nHelper.convertDatabaseToJs(reviewCycleCell.getName(), personVariablesUserLocale, null);
                reviewCycleCell.setName(reviewCycleCellName);
                idToReviewCycleCell.put(join.getReviewCycleCellId(), reviewCycleCell);
            }
            if (join.getReviewCycleNodeId() != null) {
                ReviewCycleNode reviewCycleNode = join.getReviewCycleNode();
                String reviewCycleNodeName = I18nHelper.convertDatabaseToJs(reviewCycleNode.getName(), personVariablesUserLocale, null);
                reviewCycleNode.setName(reviewCycleNodeName);
                idToReviewCycleNode.put(join.getReviewCycleNodeId(), reviewCycleNode);
            }
            if (join.getRealmId() != null) {
                Realm realm = join.getRealm();
                String realmName = I18nHelper.convertDatabaseToJs(realm.getName(), personVariablesUserLocale, null);
                realm.setName(realmName);
                idToRealm.put(join.getRealmId(), realm);
            }
            if (join.getSubProjectId() != null) {
                idToSubProject.put(join.getSubProjectId(), join.getSubProject());
            }
            if (join.getObjectReleaseId() != null) {
                idToObjectRelease.put(join.getObjectReleaseId(), join.getObjectRelease());
                Long subProjectId = join.getSubProjectId();
                if (!subProjectIdToObjectReleaseIds.containsKey(subProjectId)) {
                    subProjectIdToObjectReleaseIds.put(subProjectId, new HashSet());
                }
                ((Set)subProjectIdToObjectReleaseIds.get(subProjectId)).add(join.getObjectReleaseId());
            }
            if (join.getObjectPlannerReleaseId() != null) {
                idToObjectPlannerRelease.put(join.getObjectPlannerReleaseId(), join.getObjectPlannerRelease());
            }
            if (join.getNetworkId() != null) {
                idToNetwork.put(join.getNetworkId(), join.getNetwork());
            }
            if (join.getProjectId() == null) continue;
            idToProject.put(join.getProjectId(), join.getProject());
        }
        ParticipationSearchInfo searchInfo = new ParticipationSearchInfo();
        searchInfo.setPersonName(person.getSurName() + " " + person.getGivenName());
        searchInfo.setOrganisations(this.getUniqueOrganisationList(idToOrganisation));
        searchInfo.setPersons(this.getUniquePersonList(idToPerson));
        searchInfo.setCdesRoles(this.getUniqueCdesRoleList(cdesRoles));
        searchInfo.setNetworks(idToNetwork.values().stream().collect(Collectors.toList()));
        searchInfo.setProjects(idToProject.values().stream().collect(Collectors.toList()));
        searchInfo.setSubProjects(this.getUniqueSubProjectList(idToSubProject));
        searchInfo.setIdToObjectRelease(this.getUniqueObjectReleaseMap(idToObjectRelease));
        searchInfo.setSubProjectIdToObjectReleaseIds(subProjectIdToObjectReleaseIds);
        searchInfo.setObjectPlannerReleases(this.getUniqueObjectPlannerReleaseList(idToObjectPlannerRelease));
        searchInfo.setReviewCycleInstanceReleaseds(this.getUniqueReviewCycleInstanceReleasedList(idToReviewCycleInstanceReleased));
        searchInfo.setIdToObjectPlannerPositionDefinition(this.getUniqueObjectPlannerPositionDefinitionMap(idToObjectPlannerPositionDefinition));
        searchInfo.setProjectIdToObjectPlannerPositionDefinitionIds(projectIdToObjectPlannerPositionDefinitionIds);
        searchInfo.setIdToReviewCycle(idToReviewCycle);
        searchInfo.setNetworkIdToReviewCycleIds(networkIdToReviewCycleIds);
        searchInfo.setReviewCycleCells(this.getUniqueReviewCycleCellList(idToReviewCycleCell));
        searchInfo.setReviewCycleNodes(this.getUniqueReviewCycleNodeList(idToReviewCycleNode));
        searchInfo.setRealms(this.getUniqueRealmList(idToRealm));
        return searchInfo;
    }

    private List<CdesRole> getUniqueCdesRoleList(List<CdesRole> roles) {
        ArrayList<CdesRole> newRoles = new ArrayList<CdesRole>();
        HashSet<String> roleNamesSoFar = new HashSet<String>();
        for (CdesRole role : roles) {
            String name = role.getName();
            if (roleNamesSoFar.contains(name)) continue;
            newRoles.add(role);
            roleNamesSoFar.add(name);
        }
        return newRoles;
    }

    private List<Person> getUniquePersonList(Map<Long, Person> idToPerson) {
        ArrayList<Person> persons = new ArrayList<Person>();
        HashSet<String> foundPersonKeys = new HashSet<String>();
        for (Person person : idToPerson.values()) {
            String key = PersonHelper.getInverseCommonName(person);
            if (foundPersonKeys.contains(key)) continue;
            persons.add(person);
            foundPersonKeys.add(key);
        }
        return persons;
    }

    private List<Organisation> getUniqueOrganisationList(Map<Long, Organisation> idToOrganisation) {
        ArrayList<Organisation> organisations = new ArrayList<Organisation>();
        HashSet<String> foundOrganisationNames = new HashSet<String>();
        for (Organisation organisation : idToOrganisation.values()) {
            String organisationName = organisation.getName();
            if (foundOrganisationNames.contains(organisationName)) continue;
            organisations.add(organisation);
            foundOrganisationNames.add(organisationName);
        }
        return organisations;
    }

    private List<SubProject> getUniqueSubProjectList(Map<Long, SubProject> idToSubProject) {
        ArrayList<SubProject> subProjects = new ArrayList<SubProject>();
        HashSet<String> foundSubProjectKeys = new HashSet<String>();
        for (SubProject subProject : idToSubProject.values()) {
            String subProjectKey = subProject.getCode() + (subProject.getNumber() != null ? subProject.getNumber() : "") + " " + subProject.getName();
            if (foundSubProjectKeys.contains(subProjectKey)) continue;
            subProjects.add(subProject);
            foundSubProjectKeys.add(subProjectKey);
        }
        return subProjects;
    }

    private Map<Long, ObjectRelease> getUniqueObjectReleaseMap(Map<Long, ObjectRelease> idToObjectRelease) {
        HashMap<Long, ObjectRelease> newObjectReleases = new HashMap<Long, ObjectRelease>();
        HashSet<String> foundObjectReleaseKeys = new HashSet<String>();
        for (ObjectRelease objectRelease : idToObjectRelease.values()) {
            String subProjectKey = objectRelease.getCode() + " " + objectRelease.getName();
            if (foundObjectReleaseKeys.contains(subProjectKey)) continue;
            newObjectReleases.put(objectRelease.getId(), objectRelease);
            foundObjectReleaseKeys.add(subProjectKey);
        }
        return newObjectReleases;
    }

    private List<ObjectPlannerRelease> getUniqueObjectPlannerReleaseList(Map<Long, ObjectPlannerRelease> idToObjectPlannerRelease) {
        ArrayList<ObjectPlannerRelease> objectPlannerReleases = new ArrayList<ObjectPlannerRelease>();
        HashSet<String> foundObjectPlannerReleaseKeys = new HashSet<String>();
        for (ObjectPlannerRelease objectPlannerRelease : idToObjectPlannerRelease.values()) {
            String subProjectKey = objectPlannerRelease.getCode() + " " + objectPlannerRelease.getArea();
            if (foundObjectPlannerReleaseKeys.contains(subProjectKey)) continue;
            objectPlannerReleases.add(objectPlannerRelease);
            foundObjectPlannerReleaseKeys.add(subProjectKey);
        }
        return objectPlannerReleases;
    }

    private Map<Long, ObjectPlannerPositionDefinition> getUniqueObjectPlannerPositionDefinitionMap(Map<Long, ObjectPlannerPositionDefinition> idToObjectPlannerPositionDefinition) {
        HashMap<Long, ObjectPlannerPositionDefinition> newObjectPlannerPositionDefinitions = new HashMap<Long, ObjectPlannerPositionDefinition>();
        HashSet<String> foundObjectPlannerPositionDefinitionNames = new HashSet<String>();
        for (ObjectPlannerPositionDefinition objectPlannerPositionDefinition : idToObjectPlannerPositionDefinition.values()) {
            String objectPlannerPositionDefinitionName = objectPlannerPositionDefinition.getName();
            if (foundObjectPlannerPositionDefinitionNames.contains(objectPlannerPositionDefinitionName)) continue;
            newObjectPlannerPositionDefinitions.put(objectPlannerPositionDefinition.getId(), objectPlannerPositionDefinition);
            foundObjectPlannerPositionDefinitionNames.add(objectPlannerPositionDefinitionName);
        }
        return newObjectPlannerPositionDefinitions;
    }

    private List<ReviewCycleInstanceReleased> getUniqueReviewCycleInstanceReleasedList(Map<Long, ReviewCycleInstanceReleased> idToReviewCycleInstanceReleased) {
        ArrayList<ReviewCycleInstanceReleased> reviewCycleInstanceReleaseds = new ArrayList<ReviewCycleInstanceReleased>();
        HashSet<String> foundReviewCycleInstanceReleasedNames = new HashSet<String>();
        for (ReviewCycleInstanceReleased reviewCycleInstanceReleased : idToReviewCycleInstanceReleased.values()) {
            String reviewCycleInstanceReleasedName = reviewCycleInstanceReleased.getName();
            if (foundReviewCycleInstanceReleasedNames.contains(reviewCycleInstanceReleasedName)) continue;
            reviewCycleInstanceReleaseds.add(reviewCycleInstanceReleased);
            foundReviewCycleInstanceReleasedNames.add(reviewCycleInstanceReleasedName);
        }
        return reviewCycleInstanceReleaseds;
    }

    private List<ReviewCycleCell> getUniqueReviewCycleCellList(Map<Long, ReviewCycleCell> idToReviewCycleCell) {
        ArrayList<ReviewCycleCell> reviewCycleCells = new ArrayList<ReviewCycleCell>();
        HashSet<String> foundReviewCycleCellKeys = new HashSet<String>();
        for (ReviewCycleCell reviewCycleCell : idToReviewCycleCell.values()) {
            String reviewCycleCellKey = reviewCycleCell.getCode() + " " + reviewCycleCell.getName();
            if (foundReviewCycleCellKeys.contains(reviewCycleCellKey)) continue;
            reviewCycleCells.add(reviewCycleCell);
            foundReviewCycleCellKeys.add(reviewCycleCellKey);
        }
        return reviewCycleCells;
    }

    private List<ReviewCycleNode> getUniqueReviewCycleNodeList(Map<Long, ReviewCycleNode> idToReviewCycleNode) {
        ArrayList<ReviewCycleNode> reviewCycleNodes = new ArrayList<ReviewCycleNode>();
        HashSet<String> foundReviewCycleNodeKeys = new HashSet<String>();
        for (ReviewCycleNode reviewCycleNode : idToReviewCycleNode.values()) {
            String reviewCycleNodeKey = reviewCycleNode.getName();
            if (foundReviewCycleNodeKeys.contains(reviewCycleNodeKey)) continue;
            reviewCycleNodes.add(reviewCycleNode);
            foundReviewCycleNodeKeys.add(reviewCycleNodeKey);
        }
        return reviewCycleNodes;
    }

    private List<Realm> getUniqueRealmList(Map<Long, Realm> idToRealm) {
        ArrayList<Realm> realms = new ArrayList<Realm>();
        HashSet<String> foundRealmKeys = new HashSet<String>();
        for (Realm realm : idToRealm.values()) {
            String realmKey = realm.getCode() + " " + realm.getName();
            if (foundRealmKeys.contains(realmKey)) continue;
            realms.add(realm);
            foundRealmKeys.add(realmKey);
        }
        return realms;
    }

    public List<ProjectParticipationJoin> getParticipationJoins(Long organisationPersonId, Long roleTypeId, List<Long> projectIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<ProjectParticipationJoin> participationJoins = this.projectParticipationDAO.getParticipationJoins(roleTypeId, projectIds);
        return participationJoins;
    }

    public List<ProjectParticipationJoin> getParticipationJoinsByIds(Long organisationPersonId, List<Long> projectParticipationIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        HashMap<Long, ProjectParticipationJoin> participationJoins = new HashMap<Long, ProjectParticipationJoin>();
        for (Long id : projectParticipationIds) {
            List<ProjectParticipationJoin> participationJoinsPart = this.projectParticipationDAO.getParticipationJoins(id);
            for (ProjectParticipationJoin pj : participationJoinsPart) {
                participationJoins.put(pj.getOrganisationPersonId(), pj);
            }
        }
        return new ArrayList<ProjectParticipationJoin>(participationJoins.values());
    }

    public List<ParticipationListJoin> getParticipationListJoins(Long organisationPersonId, ProjectParticipationSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<ParticipationListJoin> participationListJoins = this.projectParticipationDAO.getParticipationListJoins(searchModel);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        for (ParticipationListJoin participationListJoin : participationListJoins) {
            String reviewCycleName = participationListJoin.getReviewCycleName();
            String reviewCycleCellName = participationListJoin.getReviewCycleCellName();
            String reviewCycleNodeName = participationListJoin.getReviewCycleNodeName();
            String realmName = participationListJoin.getRealmName();
            reviewCycleName = I18nHelper.convertDatabaseToJs(reviewCycleName, personVariablesUserLocale, null);
            reviewCycleCellName = I18nHelper.convertDatabaseToJs(reviewCycleCellName, personVariablesUserLocale, null);
            reviewCycleNodeName = I18nHelper.convertDatabaseToJs(reviewCycleNodeName, personVariablesUserLocale, null);
            realmName = I18nHelper.convertDatabaseToJs(realmName, personVariablesUserLocale, null);
            participationListJoin.setReviewCycleName(reviewCycleName);
            participationListJoin.setReviewCycleCellName(reviewCycleCellName);
            participationListJoin.setReviewCycleNodeName(reviewCycleNodeName);
            participationListJoin.setRealmName(realmName);
            if (participationListJoin.getObjectPlannerReleasePositionId() != null) {
                participationListJoin.setObjectPlannerRelease(participationListJoin.getObjectPlannerReleasePosition());
            }
            if (participationListJoin.getObjectReleasePositionId() != null) {
                participationListJoin.setObjectRelease(participationListJoin.getObjectReleasePosition());
            }
            if (participationListJoin.getSubProjectPositionId() == null) continue;
            participationListJoin.setSubProject(participationListJoin.getSubProjectPosition());
        }
        long artificialId = 0L;
        for (ParticipationListJoin participationListJoin : participationListJoins) {
            participationListJoin.setArtificialId(Long.valueOf(artificialId));
            ++artificialId;
        }
        return participationListJoins;
    }

    public List<ProjectParticipantHistoryPartJoin> getParticipantHistoryPartJoins(Long organisationPersonId, Long participationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(participationId);
        Long projectId = participation.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.EDIT_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to open history of ProjectParticipation [" + participationId + "] in project [" + projectId + "] due to lack of permission [" + Action.EDIT_PROJECT_PARTICIPATION + "]");
        }
        return this.projectParticipantHistoryPartDAO.getJoinByParticipation(participationId);
    }

    public List<Project> getValidProjectsByNetworkId(Long networkId, boolean buekMode) {
        if (buekMode) {
            return this.projectDAO.getUserVisibleByStatesAndNetwork(networkId, ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue());
        }
        return this.projectDAO.getUserVisibleByStatesAndNetwork(networkId, ProjectStatus.ACTIVE.getValue());
    }

    public List<Project> getValidProjectsByNetworkIdAndOrgPersonId(Long networkId, Long organisationPersonId, boolean buekMode) {
        List<Object> visibleProjects = new ArrayList();
        visibleProjects = buekMode ? this.projectDAO.getUserVisibleByStatesAndNetwork(networkId, ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) : this.projectDAO.getUserVisibleByStatesAndNetwork(networkId, ProjectStatus.ACTIVE.getValue());
        if (organisationPersonId != null) {
            Set<Long> allowedProjectIds = this.projectDAO.getProjectIdsByOrganisationPerson(organisationPersonId);
            if (log.isDebugEnabled()) {
                log.debug("getValidProjectsByNetworkIdAndOrgPersonId: orgPersonId = " + organisationPersonId + ", visibleProjects = " + ((Object)visibleProjects).toString());
                log.debug("getValidProjectsByNetworkIdAndOrgPersonId: orgPersonId = " + organisationPersonId + ", allowedProjectIds = " + allowedProjectIds.toString());
            }
            ArrayList<Project> filteredProjects = new ArrayList<Project>();
            for (Project project : visibleProjects) {
                Long projectNetworkId = project.getNetworkId();
                Long projectId = project.getId();
                if (!allowedProjectIds.contains(projectId) || project.getAccess().intValue() == ProjectAccess.INVISIBLE.getValue()) continue;
                filteredProjects.add(project);
            }
            if (log.isDebugEnabled()) {
                log.debug("getValidProjectsByNetworkIdAndOrgPersonId: orgPersonId = " + organisationPersonId + ", filteredProjects = " + ((Object)filteredProjects).toString());
            }
            return filteredProjects;
        }
        return visibleProjects;
    }

    private Set<Long> getRestrictedSubProjectIds(Long organisationPersonId) {
        Map<Long, Set<Long>> restrictedSubProjectIdToParticipationIds = this.subProjectDAO.getRestrictedSubProjectIdToParticipationIds(organisationPersonId);
        Set<Long> participationIds = this.projectParticipationDAO.getActiveParticipationIdsByOrganisationPerson(organisationPersonId);
        HashSet<Long> restrictedSubProjectIds = new HashSet<Long>();
        for (Long subProjectId : restrictedSubProjectIdToParticipationIds.keySet()) {
            boolean restricted = true;
            Set<Long> currParticipationIds = restrictedSubProjectIdToParticipationIds.get(subProjectId);
            for (Long participationId : participationIds) {
                if (currParticipationIds.contains(participationId)) continue;
                restricted = false;
            }
            if (!restricted) continue;
            restrictedSubProjectIds.add(subProjectId);
        }
        return restrictedSubProjectIds;
    }

    private Set<Long> getRestrictedSubProjectIdsByProjectId(Long projectId, Long organisationPersonId) {
        Map<Long, Set<Long>> restrictedSubProjectIdToParticipationIds = this.subProjectDAO.getRestrictedSubProjectIdToParticipationIds(organisationPersonId);
        Set<Long> participationIds = this.projectParticipationDAO.getActiveParticipationIdsByByProjectAndOrganisationPerson(projectId, organisationPersonId);
        HashSet<Long> restrictedSubProjectIds = new HashSet<Long>();
        for (Long subProjectId : restrictedSubProjectIdToParticipationIds.keySet()) {
            boolean restricted = true;
            Set<Long> currParticipationIds = restrictedSubProjectIdToParticipationIds.get(subProjectId);
            for (Long participationId : participationIds) {
                if (currParticipationIds.contains(participationId)) continue;
                restricted = false;
            }
            if (!restricted) continue;
            restrictedSubProjectIds.add(subProjectId);
        }
        return restrictedSubProjectIds;
    }

    public List<ContextJoin> getCopyContextJoinsByNetworkId(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<Project> projects = this.projectDAO.getByNetwork(networkId);
        List<Long> projectIds = ContainerHelper.getPersistentIdsList(projects);
        Map<Long, Set<Action>> projectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.EDIT_OBJECT_LIST);
        List<ContextJoin> unfilteredContextJoins = this.subProjectDAO.getSubProjectContextJoinsByNetwork(networkId);
        ArrayList<ContextJoin> contextJoins = new ArrayList<ContextJoin>();
        for (ContextJoin contextJoin : unfilteredContextJoins) {
            Long projectId = contextJoin.getProjectId();
            ProjectStatus projectStatus = ProjectStatus.fromValue((int)contextJoin.getProjectStatus());
            ProjectAccess projectAccess = ProjectAccess.fromValue((int)contextJoin.getProjectAccess());
            if (projectStatus != ProjectStatus.ACTIVE || projectAccess == ProjectAccess.INVISIBLE || !projectIdToActions.containsKey(projectId) || !projectIdToActions.get(projectId).contains(Action.EDIT_OBJECT_LIST)) continue;
            contextJoins.add(contextJoin);
        }
        return contextJoins;
    }

    public List<SubProject> getValidSubProjectsByProjectId(Long projectId, Long activeOrganisationPersonId) {
        List<SubProject> validSubProjects = this.subProjectDAO.getValidByProject(projectId);
        if (activeOrganisationPersonId == null) {
            return validSubProjects;
        }
        ArrayList<SubProject> validRestrictedSubProjects = new ArrayList<SubProject>();
        Set<Long> restrictedSubProjectIds = this.getRestrictedSubProjectIdsByProjectId(projectId, activeOrganisationPersonId);
        for (SubProject subProject : validSubProjects) {
            if (restrictedSubProjectIds.contains(subProject.getId())) continue;
            validRestrictedSubProjects.add(subProject);
        }
        return validRestrictedSubProjects;
    }

    public ParticipationPageInfo getParticipationPageInfo(Long organisationPersonId, ParticipationPageSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ParticipationPageInfo retInfo = new ParticipationPageInfo();
        Long projectId = searchModel.getProjectId();
        List<OrganisationParticipationInfo> organisationParticipationInfos = this.getParticipationPageInfos(organisationPersonId, searchModel);
        ParticipationPageEditInfo editInfo = this.getParticipationPageEditInfo(projectId);
        retInfo.setOrganisationParticipationInfos(organisationParticipationInfos);
        retInfo.setEditInfo(editInfo);
        return retInfo;
    }

    private List<OrganisationParticipationInfo> getParticipationPageInfos(Long organisationPersonId, ParticipationPageSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (searchModel.getNewForOrgMode() != null && searchModel.getNewForOrgMode() > 0) {
            ArrayList<OrganisationParticipationInfo> infos = new ArrayList<OrganisationParticipationInfo>();
            return infos;
        }
        Long projectId = searchModel.getProjectId();
        ArrayList<OrganisationParticipationInfo> organisationParticipationInfos = new ArrayList<OrganisationParticipationInfo>();
        if (projectId == null) {
            return organisationParticipationInfos;
        }
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.SHOW_PROJECT_PARTICIPATION, Action.EDIT_PROJECT_PARTICIPATION);
        if (!actions.contains(Action.SHOW_PROJECT_PARTICIPATION) && !actions.contains(Action.EDIT_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] may not fetch ParticipationPageInfos for Project [" + projectId + "].  Needs either privilege [" + Action.SHOW_PROJECT_PARTICIPATION + "] or privilege [" + Action.EDIT_PROJECT_PARTICIPATION + "]");
        }
        List<ProjectParticipationJoin> participationJoins = this.projectParticipationDAO.getParticipationJoinsByPageSearchModel(searchModel);
        HashMap organisationIdToJoins = new HashMap();
        for (ProjectParticipationJoin participationJoin : participationJoins) {
            Long organisationId = participationJoin.getOrganisationId();
            if (!organisationIdToJoins.containsKey(organisationId)) {
                organisationIdToJoins.put(organisationId, new ArrayList());
            }
            ((List)organisationIdToJoins.get(organisationId)).add(participationJoin);
        }
        Map allowedSubProjects = this.projectParticipationSubProjectRestrictionsDAO.getPositiveByProjectParticipations(MappedCollection.newInstance(participationJoins, ProjectParticipationJoin::getProjectParticipationId)).stream().collect(Collectors.groupingBy(SubProjectRestrictionsJoin::getProjectParticipationId, Collectors.mapping(SubProjectRestrictionsJoin::getSubProject, Collectors.toList())));
        for (Long organisationId : organisationIdToJoins.keySet()) {
            List joins = (List)organisationIdToJoins.get(organisationId);
            ProjectParticipationJoin someJoin = (ProjectParticipationJoin)joins.get(0);
            OrganisationParticipationInfo organisationParticipationInfo = new OrganisationParticipationInfo();
            organisationParticipationInfo.setOrganisation(someJoin.getOrganisation());
            organisationParticipationInfo.setWithSubProjectRestrictions(someJoin.getProjectWithParticipantsSubProjectRestriction());
            HashMap participationIdToJoins = new HashMap();
            for (ProjectParticipationJoin participationJoin : joins) {
                Long participationId = participationJoin.getProjectParticipationId();
                if (!participationIdToJoins.containsKey(participationId)) {
                    participationIdToJoins.put(participationId, new ArrayList());
                }
                ((List)participationIdToJoins.get(participationId)).add(participationJoin);
            }
            ArrayList<ParticipationInfo> participationInfos = new ArrayList<ParticipationInfo>();
            for (Long participationId : participationIdToJoins.keySet()) {
                ParticipationInfo participationInfo = new ParticipationInfo();
                List participantJoins = (List)participationIdToJoins.get(participationId);
                ProjectParticipationJoin someParticipantJoin = (ProjectParticipationJoin)participantJoins.get(0);
                participationInfo.setCdesRole(someParticipantJoin.getCdesRole());
                participationInfo.setProjectParticipation(someParticipantJoin.getProjectParticipation());
                ParticipantInfo mainParticipantInfo = null;
                ArrayList<ParticipantInfo> deputyInfos = new ArrayList<ParticipantInfo>();
                for (ProjectParticipationJoin participantJoin : participantJoins) {
                    ParticipantInfo participantInfo = new ParticipantInfo();
                    participantInfo.setParticipant(participantJoin.getProjectParticipant());
                    participantInfo.setOrganisationPerson(participantJoin.getOrganisationPerson());
                    participantInfo.setOrganisation(participantJoin.getOpOrganisation());
                    participantInfo.setPerson(participantJoin.getPerson());
                    if (participantJoin.getProjectParticipantMainParticipantFlag() != null && participantJoin.getProjectParticipantMainParticipantFlag().booleanValue()) {
                        mainParticipantInfo = participantInfo;
                        continue;
                    }
                    deputyInfos.add(participantInfo);
                }
                participationInfo.setMainParticipantInfo(mainParticipantInfo);
                participationInfo.setDeputyInfos(deputyInfos);
                final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                List allowedSubProjectsList = allowedSubProjects.getOrDefault(participationId, Collections.emptyList());
                Collections.sort(allowedSubProjectsList, new Comparator<SubProject>(){

                    @Override
                    public int compare(SubProject s1, SubProject s2) {
                        String codeOne = s1.getCode() != null ? s1.getCode() : "";
                        String codeTwo = s2.getCode() != null ? s2.getCode() : "";
                        String numberOne = s1.getNumber() != null ? s1.getNumber().toString() : "";
                        String numberTwo = s2.getNumber() != null ? s2.getNumber().toString() : "";
                        String l1 = codeOne + numberOne;
                        String l2 = codeTwo + numberTwo;
                        return collator.compare(l1, l2);
                    }
                });
                participationInfo.setAllowedSubProjects(allowedSubProjectsList);
                participationInfos.add(participationInfo);
            }
            organisationParticipationInfo.setParticipationInfos(participationInfos);
            organisationParticipationInfos.add(organisationParticipationInfo);
        }
        return organisationParticipationInfos;
    }

    public boolean mayAddSubProjectRestriction(Long organisationPersonId, Long participationId, Long subProjectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        SubProject subProject = (SubProject)this.subProjectDAO.get(subProjectId);
        Long projectId = subProject.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.PROJECT_PARTICIPATIONS_OVERVIEW)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to check sub project restrictions for project [" + projectId + "], due to lack of permission [" + Action.PROJECT_PARTICIPATIONS_OVERVIEW + "]");
        }
        return this.projectParticipationDAO.mayRestrictParticipation(participationId, subProjectId);
    }

    public ParticipationPageSearchInfo getParticipationPageSearchInfo(Long projectId) {
        List<ParticipationPageSearchJoin> searchJoins = this.projectParticipationDAO.getParticipationPageSearchJoins(projectId);
        ArrayList<Organisation> organisations = new ArrayList<Organisation>();
        ArrayList<CdesRole> cdesRoles = new ArrayList<CdesRole>();
        ArrayList<SubProject> subProjects = new ArrayList<SubProject>();
        ArrayList<OrganisationPersonInfo> mainParticipantInfosRaw = new ArrayList<OrganisationPersonInfo>();
        ArrayList<OrganisationPersonInfo> deputyInfosRaw = new ArrayList<OrganisationPersonInfo>();
        for (ParticipationPageSearchJoin searchJoin : searchJoins) {
            ParticipationPageSearchUnionComponent component = ParticipationPageSearchUnionComponent.getByValue(searchJoin.getUnionClause());
            if (component == ParticipationPageSearchUnionComponent.ORGANISATION) {
                organisations.add(searchJoin.getOrganisation());
                continue;
            }
            if (component == ParticipationPageSearchUnionComponent.CDES_ROLE) {
                cdesRoles.add(searchJoin.getCdesRole());
                continue;
            }
            if (component == ParticipationPageSearchUnionComponent.SUB_PROJECT) {
                subProjects.add(searchJoin.getSubProject());
                continue;
            }
            if (component == ParticipationPageSearchUnionComponent.PARTICIPANT) {
                OrganisationPersonInfo organisationPersonInfo = new OrganisationPersonInfo();
                organisationPersonInfo.setOrganisation(searchJoin.getOrganisation());
                organisationPersonInfo.setPerson(searchJoin.getPerson());
                organisationPersonInfo.setOrganisationPerson(searchJoin.getOrganisationPerson());
                Boolean mainParticipantFlag = searchJoin.getProjectParticipantMainParticipantFlag();
                if (mainParticipantFlag != null && mainParticipantFlag.booleanValue()) {
                    mainParticipantInfosRaw.add(organisationPersonInfo);
                    continue;
                }
                deputyInfosRaw.add(organisationPersonInfo);
                continue;
            }
            throw new IllegalArgumentException("Unsupported component [" + (Object)((Object)component) + "]");
        }
        List<OrganisationPersonInfo> mainParticipantInfos = this.groupOpInfosByOpId(mainParticipantInfosRaw);
        List<OrganisationPersonInfo> deputyInfos = this.groupOpInfosByOpId(deputyInfosRaw);
        ParticipationPageSearchInfo searchInfo = new ParticipationPageSearchInfo();
        searchInfo.setOrganisations(organisations);
        searchInfo.setCdesRoles(cdesRoles);
        searchInfo.setSubProjects(subProjects);
        searchInfo.setMainParticipantInfos(mainParticipantInfos);
        searchInfo.setDeputyInfos(deputyInfos);
        return searchInfo;
    }

    private List<OrganisationPersonInfo> groupOpInfosByOpId(List<OrganisationPersonInfo> opInfos) {
        ArrayList<OrganisationPersonInfo> restrictedInfos = new ArrayList<OrganisationPersonInfo>();
        HashMap<Long, OrganisationPersonInfo> opIdToOpInfo = new HashMap<Long, OrganisationPersonInfo>();
        for (OrganisationPersonInfo opInfo : opInfos) {
            Long organisationPersonId = opInfo.getOrganisationPerson().getId();
            opIdToOpInfo.put(organisationPersonId, opInfo);
        }
        restrictedInfos.addAll(opIdToOpInfo.values());
        return restrictedInfos;
    }

    public ParticipationPageEditInfo getParticipationPageEditInfo(Long projectId) {
        List<ParticipationPageEditJoin> editJoins = this.projectParticipationDAO.getParticipationPageEditJoins(projectId);
        HashMap<Long, Organisation> idToOrganisation = new HashMap<Long, Organisation>();
        ArrayList<CdesRole> cdesRoles = new ArrayList<CdesRole>();
        ArrayList<SubProject> subProjects = new ArrayList<SubProject>();
        Project project = null;
        HashMap<Long, List> personInfos = new HashMap<Long, List>();
        HashMap consortiumIdToOrganisations = new HashMap();
        for (ParticipationPageEditJoin editJoin : editJoins) {
            ParticipationPageEditUnionComponent component = ParticipationPageEditUnionComponent.getByValue(editJoin.getUnionClause());
            if (component == ParticipationPageEditUnionComponent.ORGANISATION) {
                Organisation consortium = editJoin.getConsortium();
                idToOrganisation.put(consortium.getId(), consortium);
                if (editJoin.getOrganisationId() == null) continue;
                if (!consortiumIdToOrganisations.containsKey(consortium.getId())) {
                    consortiumIdToOrganisations.put(consortium.getId(), new ArrayList());
                }
                ((List)consortiumIdToOrganisations.get(consortium.getId())).add(editJoin.getOrganisation());
                continue;
            }
            if (component == ParticipationPageEditUnionComponent.PROJECT) {
                project = editJoin.getProject();
                continue;
            }
            if (component == ParticipationPageEditUnionComponent.CDES_ROLE) {
                cdesRoles.add(editJoin.getCdesRole());
                continue;
            }
            if (component == ParticipationPageEditUnionComponent.SUB_PROJECT) {
                subProjects.add(editJoin.getSubProject());
                continue;
            }
            if (component == ParticipationPageEditUnionComponent.PARTICIPANT) {
                ConsortiumPersonInfo consortiumPersonInfo = new ConsortiumPersonInfo();
                Long groupingId = null;
                if (editJoin.getConsortiumId() != null) {
                    groupingId = editJoin.getConsortiumId();
                    consortiumPersonInfo.setConsortium(editJoin.getConsortium());
                    consortiumPersonInfo.setConsortiumMember(editJoin.getConsortiumMember());
                } else {
                    groupingId = editJoin.getOrganisationId();
                }
                consortiumPersonInfo.setOrganisation(editJoin.getOrganisation());
                consortiumPersonInfo.setPerson(editJoin.getPerson());
                consortiumPersonInfo.setOrganisationPerson(editJoin.getOrganisationPerson());
                personInfos.computeIfAbsent(groupingId, a -> new ArrayList()).add(consortiumPersonInfo);
                continue;
            }
            throw new IllegalArgumentException("Unsupported component [" + (Object)((Object)component) + "]");
        }
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(subProjects, new Comparator<SubProject>(){

            @Override
            public int compare(SubProject s1, SubProject s2) {
                String codeOne = s1.getCode() != null ? s1.getCode() : "";
                String codeTwo = s2.getCode() != null ? s2.getCode() : "";
                String numberOne = s1.getNumber() != null ? s1.getNumber().toString() : "";
                String numberTwo = s2.getNumber() != null ? s2.getNumber().toString() : "";
                String l1 = codeOne + numberOne;
                String l2 = codeTwo + numberTwo;
                return collator.compare(l1, l2);
            }
        });
        ArrayList organisations = new ArrayList();
        organisations.addAll(idToOrganisation.values());
        ParticipationPageEditInfo editInfo = new ParticipationPageEditInfo();
        editInfo.setOrganisations(organisations);
        editInfo.setProject(project);
        editInfo.setCdesRoles(cdesRoles);
        editInfo.setSubProjects(subProjects);
        editInfo.setPersonInfos(personInfos);
        editInfo.setConsortiumIdToOrganisations(consortiumIdToOrganisations);
        return editInfo;
    }

    public void saveParticipationPageInfo(Long projectId, Long organisationPersonId, OrganisationParticipationEditInfo info) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ArrayList<ParticipationEditInfo> createParticipationEditInfos = new ArrayList<ParticipationEditInfo>();
        ArrayList<ParticipationEditInfo> updateParticipationEditInfos = new ArrayList<ParticipationEditInfo>();
        for (ParticipationEditInfo editInfo : info.getParticipations()) {
            Long participationId = editInfo.getParticipationId();
            if (participationId != null) {
                updateParticipationEditInfos.add(editInfo);
                continue;
            }
            createParticipationEditInfos.add(editInfo);
        }
        Project project = (Project)this.projectDAO.get(projectId);
        Set<Action> actions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.EDIT_PROJECT_PARTICIPATION, Action.INSERT_PROJECT_PARTICIPATION, Action.DELETE_PROJECT_PARTICIPATION);
        if (updateParticipationEditInfos.size() != 0 && !actions.contains(Action.EDIT_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.EDIT_PROJECT_PARTICIPATION + "] to edit ProjectParticipations in project [" + projectId + "]");
        }
        if (createParticipationEditInfos.size() != 0 && !actions.contains(Action.INSERT_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.INSERT_PROJECT_PARTICIPATION + "] to insert ProjectParticipations into project [" + projectId + "]");
        }
        if (info.getDeletedParticipationIds().size() != 0 && !actions.contains(Action.DELETE_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.DELETE_PROJECT_PARTICIPATION + "] to delete ProjectParticipations from project [" + projectId + "]");
        }
        Set<Long> updateParticipationIds = this.getParticipationEditIds(updateParticipationEditInfos);
        List oldParticipations = this.projectParticipationDAO.getBatch(updateParticipationIds);
        Map<Long, ProjectParticipation> idToOldParticipation = ContainerHelper.groupById(oldParticipations);
        this.checkForProject(oldParticipations, projectId);
        Map<Long, OrganisationPerson> idToOrgPerson = this.getIdToAffectedMainParticipantOrgPerson(createParticipationEditInfos, updateParticipationEditInfos);
        Map<Long, List<OrganisationJoin>> consortiumIdToMemberJoins = this.getConsortiumIdToMemberJoins(info);
        Long passedOrganisationId = info.getOrganisationId();
        this.updateParticipationEditOrganisationIds(createParticipationEditInfos, idToOrgPerson, passedOrganisationId, consortiumIdToMemberJoins);
        this.updateParticipationEditOrganisationIds(updateParticipationEditInfos, idToOrgPerson, passedOrganisationId, consortiumIdToMemberJoins);
        this.saveParticipationsToCreate(createParticipationEditInfos, projectId);
        List<ProjectParticipation> participationsToUpdate = this.getParticipationsToUpdate(updateParticipationEditInfos, project, idToOldParticipation);
        List participationIdsToDelete = info.getDeletedParticipationIds();
        if (participationsToUpdate.size() > 0) {
            this.projectParticipationDAO.updateBatch(participationsToUpdate);
        }
        if (participationIdsToDelete.size() > 0) {
            this.projectParticipationDAO.invalidateBatch(participationIdsToDelete);
        }
        ArrayList<ProjectParticipant> participantsToCreate = new ArrayList<ProjectParticipant>();
        ArrayList<ProjectParticipant> participantsToUpdate = new ArrayList<ProjectParticipant>();
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(orgPersonJoin.getPersonVariablesUserLocale());
        this.processParticipantsToCreateParticipations(createParticipationEditInfos, participantsToCreate);
        this.processParticipantsForUpdateParticipations(updateParticipationEditInfos, participantsToCreate, participantsToUpdate, resourceBundle);
        this.processParticipantsForDeleteParticipations(participationIdsToDelete, participantsToUpdate, resourceBundle);
        this.checkForUnfinishedPlotOrders(participantsToUpdate, projectId);
        if (participantsToCreate.size() > 0) {
            this.projectParticipantDAO.saveBatch(participantsToCreate);
        }
        if (participantsToUpdate.size() > 0) {
            this.projectParticipantDAO.updateBatch(participantsToUpdate);
        }
        this.processHistoryParts(organisationPersonId, participantsToCreate, participantsToUpdate);
        ArrayList<IRestrictionParticipationEditInfo> editInfos = new ArrayList<IRestrictionParticipationEditInfo>();
        editInfos.addAll(createParticipationEditInfos);
        editInfos.addAll(updateParticipationEditInfos);
        this.saveRestrictions(editInfos, projectId);
    }

    public void saveParticipationComment(Long organisationPersonId, Long participationId, String comment) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(participationId);
        Long projectId = participation.getProjectId();
        Set<Action> actions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.EDIT_PROJECT_PARTICIPATION);
        if (!actions.contains(Action.EDIT_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.EDIT_PROJECT_PARTICIPATION + "] to edit ProjectParticipation comment in project [" + projectId + "]");
        }
        participation.setComment(comment);
        this.projectParticipationDAO.update(participation);
    }

    private Set<Long> getParticipationEditIds(List<ParticipationEditInfo> editInfos) {
        HashSet<Long> ids = new HashSet<Long>();
        for (ParticipationEditInfo editInfo : editInfos) {
            ids.add(editInfo.getParticipationId());
        }
        return ids;
    }

    private void checkForProject(List<ProjectParticipation> participations, Long projectId) {
        for (ProjectParticipation participation : participations) {
            Long currProjectId = participation.getProjectId();
            if (currProjectId.longValue() == projectId.longValue()) continue;
            throw new SecurityException("Editing ProjectParticipation [" + participation.getId() + "] in project [" + currProjectId + "] is not allowed; is not in currently processed project [" + projectId + "]");
        }
    }

    private Map<Long, OrganisationPerson> getIdToAffectedMainParticipantOrgPerson(List<ParticipationEditInfo> createEditInfos, List<ParticipationEditInfo> updateEditInfos) {
        HashSet<Long> mainParticipantOrgPersonIds = new HashSet<Long>();
        for (ParticipationEditInfo editInfo : createEditInfos) {
            mainParticipantOrgPersonIds.add(editInfo.getMainParticipantOrganisationPersonId());
        }
        for (ParticipationEditInfo editInfo : updateEditInfos) {
            mainParticipantOrgPersonIds.add(editInfo.getMainParticipantOrganisationPersonId());
        }
        List orgPersons = this.organisationPersonDAO.getBatch(mainParticipantOrgPersonIds);
        Map<Long, OrganisationPerson> idToOrgPerson = ContainerHelper.groupById(orgPersons);
        return idToOrgPerson;
    }

    public Map<Long, List<OrganisationJoin>> getConsortiumIdToMemberJoins(OrganisationParticipationEditInfo info) {
        ArrayList<Long> organisationIdsList = new ArrayList<Long>();
        organisationIdsList.add(info.getOrganisationId());
        return this.organisationDAO.getMemberJoinsByConsortiums(organisationIdsList);
    }

    private boolean doesOrganisationJoinsContainOrganisation(List<OrganisationJoin> organisationJoins, Long organisationId) {
        for (OrganisationJoin organisationJoin : organisationJoins) {
            if (organisationJoin.getOrganisationId().longValue() != organisationId.longValue()) continue;
            return true;
        }
        return false;
    }

    private void updateParticipationEditOrganisationIds(List<ParticipationEditInfo> editInfos, Map<Long, OrganisationPerson> idToOrgPerson, Long passedOrganisationId, Map<Long, List<OrganisationJoin>> consortiumIdToMemberJoins) {
        for (ParticipationEditInfo editInfo : editInfos) {
            Long orgPersonId = editInfo.getMainParticipantOrganisationPersonId();
            OrganisationPerson orgPerson = idToOrgPerson.get(orgPersonId);
            Long organisationId = orgPerson.getOrganisationId();
            if (passedOrganisationId != null && consortiumIdToMemberJoins.containsKey(passedOrganisationId) && this.doesOrganisationJoinsContainOrganisation(consortiumIdToMemberJoins.get(passedOrganisationId), organisationId)) {
                editInfo.setOrganisationId(passedOrganisationId);
                continue;
            }
            editInfo.setOrganisationId(organisationId);
        }
    }

    private void updateParticipationFromEditInfo(ProjectParticipation participation, Long projectId, ParticipationEditInfo editInfo) {
        participation.setId(editInfo.getParticipationId());
        participation.setProjectId(projectId);
        participation.setRoleId(editInfo.getCdesRoleId());
        participation.setComment(editInfo.getComment());
        participation.setAttachmentEmailAddress(editInfo.getAttachmentEmailAddress());
        participation.setOrganisationId(editInfo.getOrganisationId());
        participation.setMailFlag(editInfo.getMailFlag());
        participation.setInvalidated(Integer.valueOf(0));
        participation.setCustomerId(editInfo.getCustomerId());
    }

    private void saveParticipationsToCreate(List<ParticipationEditInfo> createEditInfos, Long projectId) {
        for (ParticipationEditInfo createEditInfo : createEditInfos) {
            ProjectParticipation participation = new ProjectParticipation();
            this.updateParticipationFromEditInfo(participation, projectId, createEditInfo);
            participation = (ProjectParticipation)this.projectParticipationDAO.save(participation);
            createEditInfo.setParticipationId(participation.getId());
        }
    }

    private List<ProjectParticipation> getParticipationsToUpdate(List<ParticipationEditInfo> updateEditInfos, Project project, Map<Long, ProjectParticipation> idToOldParticipation) {
        Long projectId = project.getId();
        ArrayList<ProjectParticipation> participationsToUpdate = new ArrayList<ProjectParticipation>();
        for (ParticipationEditInfo updateEditInfo : updateEditInfos) {
            Long participationId = updateEditInfo.getParticipationId();
            ProjectParticipation oldParticipation = idToOldParticipation.get(participationId);
            if (project.getStatus().intValue() == ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) {
                Long oldRoleId = oldParticipation.getRoleId();
                Long newRoleId = updateEditInfo.getCdesRoleId();
                if (oldRoleId.longValue() != newRoleId.longValue()) {
                    throw new JsonRpcException("Cannot change role of participation [" + participationId + "] in project [" + projectId + "] from [" + oldRoleId + "] to [" + newRoleId + "]", CdesErrors.CANNOT_CHANGE_ROLE);
                }
            }
            this.updateParticipationFromEditInfo(oldParticipation, projectId, updateEditInfo);
            participationsToUpdate.add(oldParticipation);
        }
        return participationsToUpdate;
    }

    private void processParticipantsToCreateParticipations(List<ParticipationEditInfo> createEditInfos, List<ProjectParticipant> participantsToCreate) {
        for (ParticipationEditInfo editInfo : createEditInfos) {
            Long participationId = editInfo.getParticipationId();
            Long mainParticipantOrgPersonId = editInfo.getMainParticipantOrganisationPersonId();
            List deputyOrgPersonIds = editInfo.getDeputyOrganisationPersonIds();
            if (mainParticipantOrgPersonId != null) {
                ProjectParticipant participant = this.createParticipant(mainParticipantOrgPersonId, participationId, true);
                participantsToCreate.add(participant);
            }
            for (Long deputyOrgPersonId : deputyOrgPersonIds) {
                if (deputyOrgPersonId == null || mainParticipantOrgPersonId != null && mainParticipantOrgPersonId.longValue() == deputyOrgPersonId.longValue()) continue;
                ProjectParticipant participant = this.createParticipant(deputyOrgPersonId, participationId, false);
                participantsToCreate.add(participant);
            }
        }
    }

    private void processParticipantsForDeleteParticipations(List<Long> deleteParticipationIds, List<ProjectParticipant> participantsToUpdate, ResourceBundle resourceBundle) {
        if (deleteParticipationIds.size() > 0) {
            List<ProjectParticipant> oldParticipants = this.projectParticipantDAO.getByParticipations(deleteParticipationIds);
            for (ProjectParticipant oldParticipant : oldParticipants) {
                oldParticipant.setInactiveFlag(Boolean.valueOf(true));
                oldParticipant.setInactiveComment(resourceBundle.getString("projectParticipantOrdinaryParticipantInactiveComment"));
                participantsToUpdate.add(oldParticipant);
            }
        }
    }

    private void processParticipantsForUpdateParticipations(List<ParticipationEditInfo> updateEditInfos, List<ProjectParticipant> participantsToCreate, List<ProjectParticipant> participantsToUpdate, ResourceBundle resourceBundle) {
        Set<Long> participationIds = this.getParticipationEditIds(updateEditInfos);
        List<ProjectParticipant> oldParticipants = this.projectParticipantDAO.getByParticipations(participationIds);
        Map<Long, Map<Long, ProjectParticipant>> participationIdToOrgPersonIdToOldParticipant = this.getActiveParticipationIdToOrgPersonIdToParticipant(oldParticipants);
        for (ParticipationEditInfo editInfo : updateEditInfos) {
            Long participationId = editInfo.getParticipationId();
            HashMap<Long, ProjectParticipant> orgPersonIdToParticipant = participationIdToOrgPersonIdToOldParticipant.containsKey(participationId) ? participationIdToOrgPersonIdToOldParticipant.get(participationId) : new HashMap();
            Long mainParticipantOrgPersonId = editInfo.getMainParticipantOrganisationPersonId();
            List deputyOrgPersonIds = editInfo.getDeputyOrganisationPersonIds();
            HashSet<Long> keptParticipantIds = new HashSet<Long>();
            this.processUpdateOrgPersonId(orgPersonIdToParticipant, mainParticipantOrgPersonId, participationId, participantsToCreate, participantsToUpdate, keptParticipantIds, true, resourceBundle);
            for (Long deputyOrgPersonId : deputyOrgPersonIds) {
                if (deputyOrgPersonId == null || mainParticipantOrgPersonId != null && deputyOrgPersonId.longValue() == mainParticipantOrgPersonId.longValue()) continue;
                this.processUpdateOrgPersonId(orgPersonIdToParticipant, deputyOrgPersonId, participationId, participantsToCreate, participantsToUpdate, keptParticipantIds, false, resourceBundle);
            }
            for (ProjectParticipant participant : orgPersonIdToParticipant.values()) {
                Long participantId = participant.getId();
                if (keptParticipantIds.contains(participantId)) continue;
                participant.setInactiveFlag(Boolean.valueOf(true));
                participant.setInactiveComment(resourceBundle.getString("projectParticipantOrdinaryParticipantInactiveComment"));
                participantsToUpdate.add(participant);
            }
        }
    }

    private Map<Long, Map<Long, ProjectParticipant>> getActiveParticipationIdToOrgPersonIdToParticipant(List<ProjectParticipant> participants) {
        HashMap<Long, Map<Long, ProjectParticipant>> participationIdToOrgPersonIdToParticipant = new HashMap<Long, Map<Long, ProjectParticipant>>();
        for (ProjectParticipant participant : participants) {
            Long participationId = participant.getParticipationId();
            Long orgPersonId = participant.getOrganisationPersonId();
            Boolean invalidated = participant.getInactiveFlag();
            if (invalidated != null && invalidated.booleanValue()) continue;
            if (!participationIdToOrgPersonIdToParticipant.containsKey(participationId)) {
                participationIdToOrgPersonIdToParticipant.put(participationId, new HashMap());
            }
            Map orgPersonIdToParticipant = (Map)participationIdToOrgPersonIdToParticipant.get(participationId);
            orgPersonIdToParticipant.put(orgPersonId, participant);
        }
        return participationIdToOrgPersonIdToParticipant;
    }

    private void processUpdateOrgPersonId(Map<Long, ProjectParticipant> orgPersonIdToParticipant, Long orgPersonId, Long participationId, List<ProjectParticipant> participantsToCreate, List<ProjectParticipant> participantsToUpdate, Set<Long> keptParticipantIds, boolean mainParticipantFlag, ResourceBundle resourceBundle) {
        if (orgPersonId == null) {
            log.warn("Received null orgPersonId for participation [" + participationId + "].  Will do nothing.");
            return;
        }
        ProjectParticipant existingParticipant = orgPersonIdToParticipant.get(orgPersonId);
        if (existingParticipant != null) {
            Boolean existingMainParticipantFlag = existingParticipant.getMainParticipantFlag();
            if (existingMainParticipantFlag != null && existingMainParticipantFlag != mainParticipantFlag) {
                ProjectParticipant participant = this.createParticipant(orgPersonId, participationId, mainParticipantFlag);
                participantsToCreate.add(participant);
            } else {
                keptParticipantIds.add(existingParticipant.getId());
            }
        } else {
            ProjectParticipant participant = this.createParticipant(orgPersonId, participationId, mainParticipantFlag);
            participantsToCreate.add(participant);
        }
    }

    private ProjectParticipant createParticipant(Long orgPersonId, Long participationId, boolean mainParticipantFlag) {
        ProjectParticipant participant = new ProjectParticipant();
        participant.setInactiveFlag(Boolean.valueOf(false));
        participant.setInactiveComment(null);
        participant.setMainParticipantFlag(Boolean.valueOf(mainParticipantFlag));
        participant.setOrganisationPersonId(orgPersonId);
        participant.setParticipationId(participationId);
        return participant;
    }

    private void checkForUnfinishedPlotOrders(List<ProjectParticipant> updatedParticipants, Long projectId) {
        List<PlottOrder> unfinishedPlotOrders;
        HashSet<Long> invalidateOrgPersonIds = new HashSet<Long>();
        for (ProjectParticipant participant : updatedParticipants) {
            if (!participant.getInactiveFlag().booleanValue()) continue;
            invalidateOrgPersonIds.add(participant.getOrganisationPersonId());
        }
        if (invalidateOrgPersonIds.size() > 0 && (unfinishedPlotOrders = this.plottOrderDAO.getUnfinishedByProjectAndPersons(projectId, invalidateOrgPersonIds)).size() > 0) {
            throw new JsonRpcException("Unfinished plot orders.", CdesErrors.UNFINISHED_PLOT_ORDERS);
        }
    }

    private void processHistoryParts(Long organisationPersonId, List<ProjectParticipant> createdParticipants, List<ProjectParticipant> updatedParticipants) {
        ArrayList<ProjectParticipantHistoryPart> historyPartsToCreate = new ArrayList<ProjectParticipantHistoryPart>();
        ArrayList<ProjectParticipantHistoryPart> historyPartsToUpdate = new ArrayList<ProjectParticipantHistoryPart>();
        for (ProjectParticipant toCreateParticipant : createdParticipants) {
            ProjectParticipantHistoryPart historyPart = new ProjectParticipantHistoryPart();
            historyPart.setProjectParticipantId(toCreateParticipant.getId());
            historyPart.setOrganisationPersonId(organisationPersonId);
            historyPart.setStartDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            historyPart.setEditDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            historyPartsToCreate.add(historyPart);
        }
        for (ProjectParticipant toDeleteParticipant : updatedParticipants) {
            if (toDeleteParticipant.getInactiveFlag() == null || !toDeleteParticipant.getInactiveFlag().booleanValue()) continue;
            ProjectParticipantHistoryPart latestHistoryPart = this.projectParticipantHistoryPartDAO.getNewestByParticipant(toDeleteParticipant.getId());
            if (latestHistoryPart == null) {
                latestHistoryPart = new ProjectParticipantHistoryPart();
                latestHistoryPart.setProjectParticipantId(toDeleteParticipant.getId());
            }
            latestHistoryPart.setEndDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            latestHistoryPart.setEditDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            latestHistoryPart.setOrganisationPersonId(organisationPersonId);
            if (latestHistoryPart.getId() == null) {
                historyPartsToCreate.add(latestHistoryPart);
                continue;
            }
            historyPartsToUpdate.add(latestHistoryPart);
        }
        if (historyPartsToCreate.size() > 0) {
            this.projectParticipantHistoryPartDAO.saveBatch(historyPartsToCreate);
        }
        if (historyPartsToUpdate.size() > 0) {
            this.projectParticipantHistoryPartDAO.updateBatch(historyPartsToUpdate);
        }
    }

    private SaveParticipationsRet saveParticipations(Long projectId, OrganisationParticipationEditInfo info, List<ParticipationEditInfo> toUpdate, List<ParticipationEditInfo> toCreate, Project project) throws Error {
        Long organisationId;
        OrganisationPerson orgPerson;
        Long orgPersonId;
        ArrayList originalParticipations = toUpdate.size() > 0 ? this.projectParticipationDAO.getBatch(toUpdate.stream().map(ParticipationEditInfo::getParticipationId).collect(Collectors.toList())) : new ArrayList();
        Map<Long, ProjectParticipation> originalParticipationsById = originalParticipations.stream().collect(Collectors.toMap(Persistent::getId, a -> a));
        if (!originalParticipations.stream().allMatch(a -> a.getProjectId().equals(projectId))) {
            throw new RuntimeException("trying to edit project participations that are not in the current project.");
        }
        HashSet<Long> mainParticipantOrgPersonIds = new HashSet<Long>();
        for (ParticipationEditInfo editInfo2 : toUpdate) {
            mainParticipantOrgPersonIds.add(editInfo2.getMainParticipantOrganisationPersonId());
        }
        for (ParticipationEditInfo editInfo2 : toCreate) {
            mainParticipantOrgPersonIds.add(editInfo2.getMainParticipantOrganisationPersonId());
        }
        List orgPersons = this.organisationPersonDAO.getBatch(mainParticipantOrgPersonIds);
        Map idToOrgPerson = ContainerHelper.groupById(orgPersons);
        for (ParticipationEditInfo editInfo3 : toUpdate) {
            orgPersonId = editInfo3.getMainParticipantOrganisationPersonId();
            orgPerson = (OrganisationPerson)idToOrgPerson.get(orgPersonId);
            organisationId = orgPerson.getOrganisationId();
            editInfo3.setOrganisationId(organisationId);
        }
        for (ParticipationEditInfo editInfo3 : toCreate) {
            orgPersonId = editInfo3.getMainParticipantOrganisationPersonId();
            orgPerson = (OrganisationPerson)idToOrgPerson.get(orgPersonId);
            organisationId = orgPerson.getOrganisationId();
            editInfo3.setOrganisationId(organisationId);
        }
        List updated = toUpdate.stream().map(editInfo -> this.mapFromProjectParticipationEditInfo(projectId, (ParticipationEditInfo)editInfo)).collect(Collectors.toList());
        List created = toCreate.stream().map(editInfo -> this.mapFromProjectParticipationEditInfo(projectId, (ParticipationEditInfo)editInfo)).collect(Collectors.toList());
        if (project.getStatus().intValue() == ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) {
            for (ProjectParticipation newParticipation : updated) {
                ProjectParticipation originalParticipation = originalParticipationsById.get(newParticipation.getId());
                if (originalParticipation.getRoleId().equals(newParticipation.getRoleId())) continue;
                throw new JsonRpcException("cannot change role", CdesErrors.CANNOT_CHANGE_ROLE);
            }
        }
        if (updated.size() > 0) {
            this.projectParticipationDAO.updateBatch(updated);
        }
        if (created.size() > 0) {
            this.projectParticipationDAO.saveBatch(created);
            StreamUtil.zip(created.stream(), toCreate.stream(), Pair::new).forEach(p -> ((ParticipationEditInfo)p.getSecond()).setParticipationId(((ProjectParticipation)p.getFirst()).getId()));
        }
        if (info.getDeletedParticipationIds().size() > 0) {
            this.projectParticipationDAO.invalidateBatch(info.getDeletedParticipationIds());
        }
        return new SaveParticipationsRet(() -> Stream.concat(toCreate.stream(), toUpdate.stream()), () -> Stream.concat(created.stream(), updated.stream()));
    }

    private void saveParticipants(Long projectId, Supplier<Stream<ParticipationEditInfo>> editInfos, Supplier<Stream<ProjectParticipation>> participations, Long organisationPersonId) {
        List<ProjectParticipant> originalParticipants = this.projectParticipantDAO.getByParticipations(participations.get().map(Persistent::getId).collect(Collectors.toList()));
        ArrayList<ProjectParticipant> originalParticipantsWithoutInactive = new ArrayList<ProjectParticipant>();
        for (ProjectParticipant projectParticipant2 : originalParticipants) {
            if (projectParticipant2.isInactiveFlag().booleanValue()) continue;
            originalParticipantsWithoutInactive.add(projectParticipant2);
        }
        Map<Long, ProjectParticipant> originalParticipantsById = originalParticipantsWithoutInactive.stream().collect(Collectors.toMap(Persistent::getId, a -> a));
        Map<Pair, ProjectParticipant> originalParticipantsByParticipationAndPerson = originalParticipantsWithoutInactive.stream().collect(Collectors.toMap(participant -> new Pair((Object)participant.getParticipationId(), (Object)participant.getOrganisationPersonId()), a -> a, (participantA, participantB) -> participantA));
        HashMap<Long, ProjectParticipant> toDeleteParticipants = new HashMap<Long, ProjectParticipant>(originalParticipantsById);
        ArrayList toCreateParticipants = new ArrayList();
        ArrayList toUpdateParticipants = new ArrayList();
        ProjectServiceImpl.forEachParticipants(editInfos.get().iterator(), participations.get().iterator(), (editInfo, participation, personId, mainParticipantFlag) -> {
            ProjectParticipant original = (ProjectParticipant)originalParticipantsByParticipationAndPerson.get(new Pair((Object)editInfo.getParticipationId(), personId));
            if (original != null) {
                toDeleteParticipants.remove(original.getId());
                toUpdateParticipants.add(this.makeUpdateParticipant(original, (ProjectParticipation)participation, (Long)personId, (boolean)mainParticipantFlag));
            } else {
                toCreateParticipants.add(this.makeParticipant((ProjectParticipation)participation, (Long)personId, (boolean)mainParticipantFlag));
            }
        });
        List<PlottOrder> unfinishedPlotOrders = this.plottOrderDAO.getUnfinishedByProjectAndPersons(projectId, toUpdateParticipants.stream().filter(ProjectParticipant::getMainParticipantFlag).map(Persistent::getId).collect(Collectors.toList()));
        if (unfinishedPlotOrders.size() > 1) {
            throw new JsonRpcException("Unfinished plot orders.", CdesErrors.UNFINISHED_PLOT_ORDERS);
        }
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(orgPersonJoin.getPersonVariablesUserLocale());
        this.projectParticipantDAO.saveBatch(toCreateParticipants);
        this.projectParticipantDAO.updateBatch(toUpdateParticipants);
        if (toDeleteParticipants.size() > 0) {
            this.projectParticipantDAO.deactiveBatch(toDeleteParticipants.keySet(), resourceBundle.getString("projectParticipantOrdinaryParticipantInactiveComment"));
        }
        for (ProjectParticipant toCreateParticipant : toCreateParticipants) {
            ProjectParticipantHistoryPart historyPart = new ProjectParticipantHistoryPart();
            historyPart.setProjectParticipantId(toCreateParticipant.getId());
            historyPart.setOrganisationPersonId(organisationPersonId);
            historyPart.setStartDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            historyPart.setEditDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            historyPart = (ProjectParticipantHistoryPart)this.projectParticipantHistoryPartDAO.save(historyPart);
        }
        for (ProjectParticipant toDeleteParticipant : toDeleteParticipants.values()) {
            ProjectParticipantHistoryPart latestHistoryPart = this.projectParticipantHistoryPartDAO.getNewestByParticipant(toDeleteParticipant.getId());
            if (latestHistoryPart == null) {
                latestHistoryPart = new ProjectParticipantHistoryPart();
                latestHistoryPart.setProjectParticipantId(toDeleteParticipant.getId());
            }
            latestHistoryPart.setEndDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            latestHistoryPart.setEditDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            latestHistoryPart.setOrganisationPersonId(organisationPersonId);
            if (latestHistoryPart.getId() == null) {
                this.projectParticipantHistoryPartDAO.save(latestHistoryPart);
                continue;
            }
            this.projectParticipantHistoryPartDAO.update(latestHistoryPart);
        }
    }

    private void saveRestrictions(List<IRestrictionParticipationEditInfo> editInfos, Long projectId) {
        Set<Long> participationIds = this.getParticipationIdsFromRestrictionEditInfos(editInfos);
        List<ProjectParticipationSubProjectRestrictions> originalRestrictions = this.projectParticipationSubProjectRestrictionsDAO.getByProjectParticipations(participationIds);
        Map<Long, Set<Long>> oldParticipationIdToRestrictedSubProjects = this.groupRestrictionsByParticipation(originalRestrictions);
        Set<Long> allSubProjectIds = this.getValidSubProjectIds(projectId);
        ArrayList newRestrictions = new ArrayList();
        for (IRestrictionParticipationEditInfo editInfo : editInfos) {
            Long participationId = editInfo.getParticipationId();
            List allowedSubProjectIdsList = editInfo.getAllowedSubProjectIds();
            HashSet allowedSubProjectIds = new HashSet();
            allowedSubProjectIds.addAll(allowedSubProjectIdsList);
            Set<Long> currOldRestrictedSubProjectIds = oldParticipationIdToRestrictedSubProjects.get(participationId);
            for (Long allowedSubProjectId : allowedSubProjectIds) {
                if (currOldRestrictedSubProjectIds == null || !currOldRestrictedSubProjectIds.contains(allowedSubProjectId)) continue;
                this.projectParticipationSubProjectRestrictionsDAO.deleteInstance(allowedSubProjectId, participationId);
            }
            for (Long subProjectId : allSubProjectIds) {
                if (allowedSubProjectIds.contains(subProjectId) || currOldRestrictedSubProjectIds != null && currOldRestrictedSubProjectIds.contains(subProjectId)) continue;
                if (!this.projectParticipationDAO.mayRestrictParticipation(participationId, subProjectId)) {
                    throw new RuntimeException("May not add sub project restriction since participation [" + participationId + "] is already in use in subProject [" + subProjectId + "].  Hint: This should be treated by the client beforehand (--> at.cdes.api.guiService.ProjectService.mayAddSubProjectRestriction(Long, Long, Long)).  Please inspect why we end up here.");
                }
                ProjectParticipationSubProjectRestrictions restrictions = new ProjectParticipationSubProjectRestrictions();
                restrictions.setProjectParticipationId(participationId);
                restrictions.setSubProjectId(subProjectId);
                this.projectParticipationSubProjectRestrictionDAO.save(restrictions);
            }
        }
    }

    private Set<Long> getParticipationIdsFromRestrictionEditInfos(List<IRestrictionParticipationEditInfo> editInfos) {
        HashSet<Long> participationIds = new HashSet<Long>();
        for (IRestrictionParticipationEditInfo editInfo : editInfos) {
            participationIds.add(editInfo.getParticipationId());
        }
        return participationIds;
    }

    private Map<Long, Set<Long>> groupRestrictionsByParticipation(List<ProjectParticipationSubProjectRestrictions> restrictions) {
        HashMap<Long, Set<Long>> participationIdToRestrictedSubProjects = new HashMap<Long, Set<Long>>();
        for (ProjectParticipationSubProjectRestrictions restriction : restrictions) {
            Long participationId = restriction.getProjectParticipationId();
            Long subProjectId = restriction.getSubProjectId();
            if (!participationIdToRestrictedSubProjects.containsKey(participationId)) {
                participationIdToRestrictedSubProjects.put(participationId, new HashSet());
            }
            ((Set)participationIdToRestrictedSubProjects.get(participationId)).add(subProjectId);
        }
        return participationIdToRestrictedSubProjects;
    }

    private Set<Long> getValidSubProjectIds(Long projectId) {
        List<SubProject> validSubProjects = this.subProjectDAO.getValidByProject(projectId);
        HashSet<Long> validSubProjectIds = new HashSet<Long>();
        for (SubProject subProject : validSubProjects) {
            validSubProjectIds.add(subProject.getId());
        }
        return validSubProjectIds;
    }

    private void saveRestrictions(Supplier<? extends Stream<? extends IRestrictionParticipationEditInfo>> editInfos, Long projectId) {
        List<ProjectParticipationSubProjectRestrictions> originalRestrictions = this.projectParticipationSubProjectRestrictionsDAO.getByProjectParticipations(editInfos.get().map(IRestrictionParticipationEditInfo::getParticipationId).collect(Collectors.toList()));
        Set validSubProjectIds = this.subProjectDAO.getValidByProject(projectId).stream().map(Persistent::getId).collect(Collectors.toSet());
        Set allPossibleRestriction = editInfos.get().map(IRestrictionParticipationEditInfo::getParticipationId).flatMap(participation -> validSubProjectIds.stream().map(ProjectServiceImpl.makeRestriction(participation))).collect(Collectors.toSet());
        Set inverseRestrictions = editInfos.get().flatMap(editInfo -> editInfo.getAllowedSubProjectIds().stream().map(ProjectServiceImpl.makeRestriction(editInfo.getParticipationId()))).collect(Collectors.toSet());
        HashSet toCreateRestrictions = new HashSet(allPossibleRestriction);
        toCreateRestrictions.removeAll(inverseRestrictions);
        for (ProjectParticipationSubProjectRestrictions restriction : toCreateRestrictions) {
            Long subProjectId;
            Long participationId = restriction.getProjectParticipationId();
            if (this.projectParticipationDAO.mayRestrictParticipation(participationId, subProjectId = restriction.getSubProjectId())) continue;
            throw new RuntimeException("May not add sub project restriction since participation [" + participationId + "] is already in use in subProject [" + subProjectId + "].  Hint: This should be treated by the client beforehand (--> at.cdes.api.guiService.ProjectService.mayAddSubProjectRestriction(Long, Long, Long)).  Please inspect why we end up here.");
        }
        HashSet<ProjectParticipationSubProjectRestrictions> toDeleteRestrictions = new HashSet<ProjectParticipationSubProjectRestrictions>(originalRestrictions);
        toDeleteRestrictions.removeAll(toCreateRestrictions);
        toCreateRestrictions.removeAll(originalRestrictions);
        log.info("toCreate = {}, toDelete = {}", (Object)new GsonBuilder().setPrettyPrinting().create().toJson(toCreateRestrictions), (Object)new GsonBuilder().setPrettyPrinting().create().toJson(toDeleteRestrictions));
        this.projectParticipationSubProjectRestrictionsDAO.saveBatch(toCreateRestrictions.stream().collect(Collectors.toList()));
        this.projectParticipationSubProjectRestrictionsDAO.deleteBatch(toDeleteRestrictions);
    }

    public void saveSubProjectRestrictions(Long organisationPersonId, Long projectParticipationId, List<Long> allowedSubProjectIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(projectParticipationId);
        if (!this.actionDAO.getActionsForProject(organisationPersonId, participation.getProjectId(), Action.EDIT_PROJECT_PARTICIPATION).contains(Action.EDIT_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.EDIT_PROJECT_PARTICIPATION + "] to edit ProjectParticipations in project [" + participation.getProjectId() + "]");
        }
        RestrictionParticipationEditInfo editInfo = new RestrictionParticipationEditInfo();
        editInfo.setParticipationId(projectParticipationId);
        editInfo.setAllowedSubProjectIds(allowedSubProjectIds);
        ArrayList<IRestrictionParticipationEditInfo> editInfos = new ArrayList<IRestrictionParticipationEditInfo>();
        editInfos.add((IRestrictionParticipationEditInfo)editInfo);
        this.saveRestrictions(editInfos, participation.getProjectId());
    }

    private ProjectParticipant makeUpdateParticipant(ProjectParticipant original, ProjectParticipation participation, Long organisationPersonId, boolean mainParticipant) {
        ProjectParticipant dto = new ProjectParticipant();
        dto.setId(original.getId());
        dto.setParticipationId(participation.getId());
        dto.setOrganisationPersonId(organisationPersonId);
        dto.setMainParticipantFlag(Boolean.valueOf(mainParticipant));
        dto.setInactiveFlag(Boolean.valueOf(false));
        return dto;
    }

    private ProjectParticipant makeParticipant(ProjectParticipation participation, Long organisationPersonId, boolean mainParticipant) {
        ProjectParticipant dto = new ProjectParticipant();
        dto.setParticipationId(participation.getId());
        dto.setOrganisationPersonId(organisationPersonId);
        dto.setMainParticipantFlag(Boolean.valueOf(mainParticipant));
        dto.setInactiveFlag(Boolean.valueOf(false));
        return dto;
    }

    private ProjectParticipation mapFromProjectParticipationEditInfo(Long projectId, ParticipationEditInfo editInfo) {
        ProjectParticipation dto = new ProjectParticipation();
        dto.setId(editInfo.getParticipationId());
        dto.setProjectId(projectId);
        dto.setRoleId(editInfo.getCdesRoleId());
        dto.setComment(editInfo.getComment());
        dto.setAttachmentEmailAddress(editInfo.getAttachmentEmailAddress());
        dto.setOrganisationId(editInfo.getOrganisationId());
        dto.setMailFlag(editInfo.getMailFlag());
        dto.setInvalidated(Integer.valueOf(0));
        dto.setCustomerId(editInfo.getCustomerId());
        dto.setAsBuiltPlannerParticipationId(null);
        return dto;
    }

    public RoleConflictInfo getRoleConflictInfo(Long organisationPersonId, OrganisationParticipationEditInfo orgEditInfo, Long organisationId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Map<Long, Long> participationIdToNewCdesRoleId = this.getParticipationIdToCdesRoleId(orgEditInfo);
        Map<Long, CdesRole> idToNewCdesRole = this.getIdToCdesRolesByMap(participationIdToNewCdesRoleId);
        Map<Long, CdesRole> participationIdToOldCdesRole = this.getOldParticipationIdToCdesRole(projectId, organisationId);
        ArrayList<Long> conflictParticipationIds = new ArrayList<Long>();
        for (Long participationId : participationIdToNewCdesRoleId.keySet()) {
            Long cdesRoleId = participationIdToNewCdesRoleId.get(participationId);
            CdesRole oldCdesRole = participationIdToOldCdesRole.get(participationId);
            CdesRole newCdesRole = idToNewCdesRole.get(cdesRoleId);
            Long oldRoleTypeId = oldCdesRole != null ? oldCdesRole.getTypeId() : null;
            Long newRoleTypeId = newCdesRole.getTypeId();
            if (oldRoleTypeId == null || newRoleTypeId == null || oldRoleTypeId.longValue() == newRoleTypeId.longValue()) continue;
            conflictParticipationIds.add(participationId);
        }
        if (conflictParticipationIds.size() > 0) {
            List<RoleConflictJoin> roleConflictJoins = this.reviewCycleNodePositionDAO.getRoleConflictJoins(conflictParticipationIds, projectId);
            if (roleConflictJoins.size() > 0) {
                RoleConflictInfo roleConflictInfo = new RoleConflictInfo();
                roleConflictInfo.setRoleConflictJoins(roleConflictJoins);
                return roleConflictInfo;
            }
            return null;
        }
        return null;
    }

    private Map<Long, Long> getParticipationIdToCdesRoleId(OrganisationParticipationEditInfo orgEditInfo) {
        HashMap<Long, Long> participationIdToNewCdesRoleId = new HashMap<Long, Long>();
        List editInfos = orgEditInfo.getParticipations();
        for (ParticipationEditInfo editInfo : editInfos) {
            participationIdToNewCdesRoleId.put(editInfo.getParticipationId(), editInfo.getCdesRoleId());
        }
        return participationIdToNewCdesRoleId;
    }

    private Map<Long, CdesRole> getIdToCdesRolesByMap(Map<Long, Long> participationIdToCdesRoleId) {
        Collection<Long> cdesRoleIds = participationIdToCdesRoleId.values();
        List cdesRoles = cdesRoleIds.size() > 0 ? this.cdesRoleDAO.getBatch(cdesRoleIds) : new ArrayList();
        return ContainerHelper.groupById(cdesRoles);
    }

    private Map<Long, CdesRole> getOldParticipationIdToCdesRole(Long projectId, Long organisationId) {
        List<ProjectParticipationJoin> oldParticipationJoins = this.projectParticipationDAO.getParticipationJoinsByProjectAndOrganisation(projectId, organisationId);
        HashMap<Long, CdesRole> participationIdToCdesRole = new HashMap<Long, CdesRole>();
        for (ProjectParticipationJoin join : oldParticipationJoins) {
            Long participationId = join.getProjectParticipationId();
            CdesRole cdesRole = join.getCdesRole();
            participationIdToCdesRole.put(participationId, cdesRole);
        }
        return participationIdToCdesRole;
    }

    public void deleteDeputy(Long organisationPersonId, Long participantId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Project project = this.projectDAO.getByParticipant(participantId);
        Long projectId = project.getId();
        Set<Action> superAdminActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT);
        boolean hasSuperAdminRight = superAdminActions.contains(Action.SUPER_ADMIN_RIGHT);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.EDIT_PROJECT_PARTICIPATION) && !hasSuperAdminRight) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] may not delete participant [" + participantId + "] in project [" + projectId + "]; it has neither permission [" + Action.EDIT_PROJECT_PARTICIPATION + "] nor the super admin permission.");
        }
        ProjectParticipant participant = (ProjectParticipant)this.projectParticipantDAO.get(participantId);
        if (participant.isMainParticipantFlag().booleanValue()) {
            throw new IllegalArgumentException("Trying to delete participant [" + participantId + "], may not delete a mainParticipant using this method.");
        }
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(orgPersonJoin.getPersonVariablesUserLocale());
        if (!participant.isInactiveFlag().booleanValue()) {
            participant.setInactiveFlag(Boolean.valueOf(true));
            participant.setInactiveComment(resourceBundle.getString("projectParticipantOrdinaryParticipantInactiveComment"));
            this.projectParticipantDAO.update(participant);
            ProjectParticipantHistoryPart latestHistoryPart = this.projectParticipantHistoryPartDAO.getNewestByParticipant(participantId);
            if (latestHistoryPart == null) {
                latestHistoryPart = new ProjectParticipantHistoryPart();
                latestHistoryPart.setProjectParticipantId(participantId);
            }
            latestHistoryPart.setEndDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            latestHistoryPart.setEditDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            latestHistoryPart.setOrganisationPersonId(organisationPersonId);
            if (latestHistoryPart.getId() == null) {
                this.projectParticipantHistoryPartDAO.save(latestHistoryPart);
            } else {
                this.projectParticipantHistoryPartDAO.update(latestHistoryPart);
            }
        }
    }

    public ParticipantInfo insertDeputy(Long organisationPersonId, Long deputyOrganisationPersonId, Long projectParticipationId) {
        return this.doInsertDeputy(organisationPersonId, deputyOrganisationPersonId, projectParticipationId);
    }

    public ParticipantInfo insertMeAsDeputy(Long organisationPersonId, Long projectParticipationId) {
        return this.doInsertDeputy(organisationPersonId, organisationPersonId, projectParticipationId);
    }

    private ParticipantInfo doInsertDeputy(Long organisationPersonId, Long deputyOrganisationPersonId, Long projectParticipationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(projectParticipationId);
        Long projectId = participation.getProjectId();
        Set<Action> superAdminActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT);
        boolean hasSuperAdminRight = superAdminActions.contains(Action.SUPER_ADMIN_RIGHT);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.EDIT_PROJECT_PARTICIPATION) && !hasSuperAdminRight) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] may not insert itself as deputy of participation [" + projectParticipationId + "] in project [" + projectId + "]; it has neither permission [" + Action.EDIT_PROJECT_PARTICIPATION + "] nor the super admin permission.");
        }
        ProjectParticipant oldParticipant = this.projectParticipantDAO.getByParticipationAndOrganisationPerson(projectParticipationId, deputyOrganisationPersonId);
        if (oldParticipant != null) {
            throw new RuntimeException("ProjectParticipant for organisationPersonId [" + organisationPersonId + "] and participationId [" + projectParticipationId + "] already exists.");
        }
        ProjectParticipant participant = new ProjectParticipant();
        participant.setOrganisationPersonId(deputyOrganisationPersonId);
        participant.setParticipationId(projectParticipationId);
        participant.setMainParticipantFlag(Boolean.valueOf(false));
        participant.setInactiveFlag(Boolean.valueOf(false));
        participant.setInactiveComment(null);
        participant = (ProjectParticipant)this.projectParticipantDAO.save(participant);
        Long participantId = participant.getId();
        Long cdesRoleId = participation.getRoleId();
        boolean isSurveillantRole = this.cdesRoleDAO.hasTypeAndAction(cdesRoleId, RoleTypeEnum.PROJECT_SURVEILLANT, Action.MONITOR_LATE_REVIEWS);
        if (isSurveillantRole) {
            this.emailUtils.createLateTaskEmail(deputyOrganisationPersonId, participantId);
        }
        ProjectParticipantHistoryPart historyPart = new ProjectParticipantHistoryPart();
        historyPart.setProjectParticipantId(participantId);
        historyPart.setOrganisationPersonId(organisationPersonId);
        historyPart.setStartDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        historyPart.setEditDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        historyPart = (ProjectParticipantHistoryPart)this.projectParticipantHistoryPartDAO.save(historyPart);
        OrganisationPersonJoin deputyOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(deputyOrganisationPersonId);
        OrganisationPerson deputyOrganisationPerson = deputyOrganisationPersonJoin.getOrganisationPerson();
        Person person = deputyOrganisationPersonJoin.getPerson();
        Organisation organisation = deputyOrganisationPersonJoin.getOrganisation();
        ParticipantInfo participantInfo = new ParticipantInfo();
        participantInfo.setParticipant(participant);
        participantInfo.setOrganisationPerson(deputyOrganisationPerson);
        participantInfo.setOrganisation(organisation);
        participantInfo.setPerson(person);
        return participantInfo;
    }

    public String getDeleteParticipationMessageByOrganisation(Long organisationPersonId, Long projectId, Long organisationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.DELETE_PROJECT_PARTICIPATION + "] to delete ProjectParticipations from project [" + projectId + "]");
        }
        List<ProjectParticipationJoin> participationJoins = this.projectParticipationDAO.getParticipationJoinsByProjectAndOrganisation(projectId, organisationId);
        for (ProjectParticipationJoin participationJoin : participationJoins) {
            String message = this.getDeleteParticipationMessage(participationJoin);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    public String getDeleteParticipationMessageByParticipation(Long organisationPersonId, Long projectParticipationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ProjectParticipationJoin participationJoin = this.projectParticipationDAO.getParticipationJoin(projectParticipationId);
        Long projectId = participationJoin.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.DELETE_PROJECT_PARTICIPATION + "] to delete ProjectParticipations from project [" + projectId + "]");
        }
        return this.getDeleteParticipationMessage(participationJoin);
    }

    private String getDeleteParticipationMessage(ProjectParticipationJoin participationJoin) {
        Long projectParticipationId = participationJoin.getProjectParticipationId();
        Integer projectFlag = participationJoin.getCdesRoleProjectFlag();
        String roleName = participationJoin.getCdesRoleName();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        List<ProjectParticipation> participationsPreventingInvalidate = this.projectParticipationDAO.mayInvalidateParticipation(projectParticipationId);
        if (participationsPreventingInvalidate.size() > 0) {
            return MessageFormat.format(resourceBundle.getString("projectParticipationDeleteUsedError"), roleName);
        }
        if (projectFlag.intValue() == ProjectFlag.PROJECT_MANAGER_ROLE.getValue() || projectFlag.intValue() == ProjectFlag.PROJECT_ADMIN_ROLE.getValue() || projectFlag.intValue() == ProjectFlag.PROJECT_ADMIN_PLANNING_NOTIFICATION.getValue()) {
            Long projectId = participationJoin.getProjectId();
            List<ProjectParticipationJoin> allJoinsInProject = this.projectParticipationDAO.getParticipationJoinsByProject(projectId, false);
            boolean deletePossible = false;
            for (ProjectParticipationJoin currJoin : allJoinsInProject) {
                int currProjectFlag = currJoin.getCdesRoleProjectFlag();
                if (currJoin.isProjectParticipantInactiveFlag().booleanValue() || currJoin.getProjectParticipationId().longValue() == participationJoin.getProjectParticipationId().longValue() || currProjectFlag != ProjectFlag.PROJECT_MANAGER_ROLE.getValue() && currProjectFlag != ProjectFlag.PROJECT_ADMIN_ROLE.getValue() && currProjectFlag != ProjectFlag.PROJECT_ADMIN_PLANNING_NOTIFICATION.getValue()) continue;
                deletePossible = true;
                break;
            }
            if (!deletePossible) {
                int projectStatus = participationJoin.getProjectStatus();
                if (projectStatus != ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) {
                    return MessageFormat.format(resourceBundle.getString("projectParticipationDeleteAdminErrorNonBuek"), roleName);
                }
                return MessageFormat.format(resourceBundle.getString("projectParticipationDeleteAdminErrorBuek"), roleName);
            }
        }
        List<DocumentVersionTask> affectedPlotTasks = this.documentVersionTaskDAO.getPlotTasksByParticipationId(projectParticipationId);
        List<OrderStep> orderStepsPreventingDelete = this.orderStepDAO.getOrderStepsPreventingParticipationDeletion(projectParticipationId);
        if (affectedPlotTasks.size() > 0 || orderStepsPreventingDelete.size() > 0) {
            return MessageFormat.format(resourceBundle.getString("projectParticipationDeleteTaskError"), roleName);
        }
        return null;
    }

    public ParticipationDeleteInfo getDeleteParticipationInfoByOrganisation(Long organisationPersonId, Long projectId, Long organisationId) {
        List<ParticipationDeleteJoin> deleteJoins = this.projectParticipationDAO.getParticipationDeleteJoins(projectId, organisationId, null);
        return this.projectUtils.getInfoByParticipationDeleteJoins(deleteJoins, projectId, null);
    }

    public ParticipationDeleteInfo getDeleteParticipationInfoByParticipation(Long organisationPersonId, Long projectParticipationId) {
        List<ParticipationDeleteJoin> deleteJoins = this.projectParticipationDAO.getParticipationDeleteJoins(null, null, projectParticipationId);
        return this.projectUtils.getInfoByParticipationDeleteJoins(deleteJoins, null, projectParticipationId);
    }

    public void deleteParticipationById(Long organisationPersonId, Long projectParticipationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(projectParticipationId);
        Long projectId = participation.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.DELETE_PROJECT_PARTICIPATION + "] to delete ProjectParticipations from project [" + projectId + "]");
        }
        try {
            this.doDeleteParticipationById(organisationPersonId, projectParticipationId);
        }
        catch (RuntimeException e) {
            this.invalidateParticipationById(organisationPersonId, projectParticipationId);
        }
    }

    private void doDeleteParticipationById(Long organisationPersonId, Long projectParticipationId) {
        ProjectParticipationJoin participationJoin = this.projectParticipationDAO.getParticipationJoin(projectParticipationId);
        String message = this.getDeleteParticipationMessage(participationJoin);
        if (message != null) {
            throw new RuntimeException("Cannot delete ProjectParticipation [" + projectParticipationId + "] for the following reason: " + message + "; Hint: This should already be checked at client side, we should (almost, --> e.g. deletion of all administrators in one transaction) never end up here.");
        }
        List<ProjectParticipant> participants = this.projectParticipantDAO.getByParticipation(projectParticipationId);
        List<ProjectParticipantHistoryPart> historyParts = this.projectParticipantHistoryPartDAO.getByParticipation(projectParticipationId);
        List<Long> participantIds = QueryHelper.getPersistentIds(participants);
        List<Long> historyPartIds = QueryHelper.getPersistentIds(historyParts);
        this.projectParticipantHistoryPartDAO.deleteBatch(historyPartIds);
        this.projectParticipantDAO.deleteBatch(participantIds);
        List<FutureEmail> futureEmails = this.futureEmailDAO.getByProjectParticipation(projectParticipationId);
        List<Long> futureEmailIds = QueryHelper.getPersistentIds(futureEmails);
        this.futureEmailDAO.deleteBatch(futureEmailIds);
        this.projectParticipationDAO.delete(projectParticipationId);
    }

    private void invalidateParticipationById(Long organisationPersonId, Long projectParticipationId) {
        ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(projectParticipationId);
        participation.setInvalidated(Integer.valueOf(1));
        this.projectParticipationDAO.update(participation);
    }

    public void deleteParticipationByOrganisation(Long organisationPersonId, Long organisationId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.DELETE_PROJECT_PARTICIPATION + "] to delete participations for project [" + projectId + "] and organisation [" + organisationId + "]");
        }
        List<ProjectParticipation> participationsToDelete = this.projectParticipationDAO.getActiveParticipationsByProjectAndOrganisation(projectId, organisationId);
        for (ProjectParticipation participation : participationsToDelete) {
            Long projectParticipationId = participation.getId();
            try {
                this.doDeleteParticipationById(organisationPersonId, projectParticipationId);
            }
            catch (RuntimeException e) {
                this.invalidateParticipationById(organisationPersonId, projectParticipationId);
            }
        }
    }

    public void deleteParticipationWithRelationsById(Long organisationPersonId, Long projectParticipationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(projectParticipationId);
        Long projectId = participation.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.DELETE_PROJECT_PARTICIPATION + "] to delete ProjectParticipations from project [" + projectId + "]");
        }
        this.projectUtils.doDeleteParticipationWithRelationsById(projectParticipationId);
    }

    public void deleteParticipationWithRelationsByOrganisation(Long organisationPersonId, Long projectId, Long organisationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.DELETE_PROJECT_PARTICIPATION + "] to delete participations for project [" + projectId + "] and organisation [" + organisationId + "]");
        }
        List<ProjectParticipation> participationsToDelete = this.projectParticipationDAO.getActiveParticipationsByProjectAndOrganisation(projectId, organisationId);
        for (ProjectParticipation participation : participationsToDelete) {
            Long projectParticipationId = participation.getId();
            this.projectUtils.doDeleteParticipationWithRelationsById(projectParticipationId);
        }
    }

    private static void forEachParticipants(Iterator<ParticipationEditInfo> editInfos, Iterator<ProjectParticipation> participations, QuadConsumer<ParticipationEditInfo, ProjectParticipation, Long, Boolean> consumer) {
        while (editInfos.hasNext() && participations.hasNext()) {
            ParticipationEditInfo editInfo = editInfos.next();
            ProjectParticipation participation = participations.next();
            consumer.consume(editInfo, participation, editInfo.getMainParticipantOrganisationPersonId(), true);
            for (Long deputyId : editInfo.getDeputyOrganisationPersonIds()) {
                consumer.consume(editInfo, participation, deputyId, false);
            }
        }
    }

    private static Function<Long, ProjectParticipationSubProjectRestrictions> makeRestriction(Long projectParticipationId) {
        return subProjectId -> {
            ProjectParticipationSubProjectRestrictions ret = new ProjectParticipationSubProjectRestrictions();
            ret.setProjectParticipationId(projectParticipationId);
            ret.setSubProjectId(subProjectId);
            return ret;
        };
    }

    public ProjectListPageInfo getProjectListPageInfo(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Map<Object, Object> networkIdToActions = new HashMap();
        ArrayList<Long> networkPersonsNetworkIds = new ArrayList<Long>();
        ArrayList<Long> organisationPersonsNetworkIds = new ArrayList<Long>();
        if (networkId == null) {
            List<NetworkPerson> networkPersons = this.networkPersonDAO.getByOrganisationPerson(organisationPersonId);
            for (NetworkPerson networkPerson : networkPersons) {
                networkPersonsNetworkIds.add(networkPerson.getNetworkId());
            }
            networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkPersonsNetworkIds, Action.INSERT_PROJECT);
            List<Network> organisationPersonsNetworks = this.networkDAO.getNetworksByOrganisationPerson(organisationPersonId);
            for (Network organisationPersonsNetwork : organisationPersonsNetworks) {
                organisationPersonsNetworkIds.add(organisationPersonsNetwork.getId());
            }
            if (!ActionHelper.hasActionsForAnyNetwork(this.actionDAO, organisationPersonId, organisationPersonsNetworkIds, Action.PROJECTS_OVERVIEW)) {
                throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to query project related data for any networkPersonsNetworks , it does not have privilege [" + Action.PROJECTS_OVERVIEW + "]");
            }
        } else {
            networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkId, Action.INSERT_PROJECT);
            if (!ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId, Action.PROJECTS_OVERVIEW)) {
                throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to query project related data for network [" + networkId + "], it does not have privilege [" + Action.PROJECTS_OVERVIEW + "]");
            }
        }
        Set actions = new HashSet();
        boolean hasInsertProject = false;
        if (networkId == null) {
            for (Long networkPersonsNetworkId : networkPersonsNetworkIds) {
                if (networkIdToActions == null || networkIdToActions.isEmpty() || !(hasInsertProject = (actions = (Set)networkIdToActions.get(networkPersonsNetworkId)).contains(Action.INSERT_PROJECT))) continue;
                break;
            }
        } else if (networkIdToActions != null && !networkIdToActions.isEmpty()) {
            actions = (Set)networkIdToActions.get(networkId);
            hasInsertProject = actions.contains(Action.INSERT_PROJECT);
        }
        ProjectListPageInfo projectListPageInfo = new ProjectListPageInfo();
        projectListPageInfo.setMayAddProject(hasInsertProject);
        return projectListPageInfo;
    }

    public List<ProjectInfo> getProjectInfos(Long organisationPersonId, ProjectPageSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Long> leadedProjectIds = this.projectDAO.getLeadedProjectIdsByProjectFlags(organisationPersonId, ProjectFlag.PROJECT_ADMIN_ROLE, ProjectFlag.PROJECT_ADMIN_PLANNING_NOTIFICATION);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkActions(organisationPersonId, Action.INSERT_PROJECT, Action.ADMINISTRATE_NETWORK_PROJECT);
        List<ProjectInfo> projectInfos = this.projectDAO.getProjectPageJoins(organisationPersonId, searchModel).stream().collect(Collectors.groupingBy(ProjectPageJoin::getProjectId)).values().stream().map(joins -> {
            ProjectPageJoin someJoin = (ProjectPageJoin)joins.get(0);
            Long networkId = someJoin.getNetworkId();
            Long projectId = someJoin.getProjectId();
            if (log.isDebugEnabled()) {
                log.debug("joins = {}", (Object)new GsonBuilder().setPrettyPrinting().create().toJson(joins));
            }
            ProjectInfo ret = new ProjectInfo();
            ret.setNetworkId(networkId);
            ret.setNetworkName(someJoin.getNetworkName());
            ret.setProjectId(projectId);
            ret.setProjectCode(someJoin.getProjectCode());
            ret.setProjectName(someJoin.getProjectName());
            ret.setProjectCreated(someJoin.getProjectCreated());
            ret.setProjectRouteName(someJoin.getProjectRouteName());
            ret.setProjectStatus(ProjectStatus.fromValue((int)someJoin.getProjectStatus()));
            ret.setProjectAccess(ProjectAccess.fromValue((int)someJoin.getProjectAccess()));
            ret.setIsProjectAdmin(Boolean.valueOf(leadedProjectIds.contains(projectId)));
            ret.setCreator(someJoin.getProjectCreatorPerson());
            boolean withSubProjectRestrictions = someJoin.isProjectWithParticipantsSubProjectRestriction();
            Set<Object> restrictedSubProjectIds = new HashSet();
            if (withSubProjectRestrictions) {
                restrictedSubProjectIds = this.getRestrictedSubProjectIdsByProjectId(projectId, organisationPersonId);
            }
            HashMap<Long, ProjectPageJoin> idToSubProjectJoin = new HashMap<Long, ProjectPageJoin>();
            HashMap<Long, ProjectPageJoin> idToProjectLeaderJoin = new HashMap<Long, ProjectPageJoin>();
            for (ProjectPageJoin join : joins) {
                Long subProjectId = join.getSubProjectId();
                Long projectLeaderOrganisationPersonId = join.getProjectLeaderOrganisationPerson_Id();
                if (subProjectId != null) {
                    idToSubProjectJoin.put(subProjectId, join);
                }
                if (projectLeaderOrganisationPersonId == null) continue;
                idToProjectLeaderJoin.put(projectLeaderOrganisationPersonId, join);
            }
            ArrayList<SubProjectInfo> subProjectInfos = new ArrayList<SubProjectInfo>();
            ArrayList<OrganisationPersonInfo> projectLeaderInfos = new ArrayList<OrganisationPersonInfo>();
            for (ProjectPageJoin subprojectJoin : idToSubProjectJoin.values()) {
                Long subProjectId = subprojectJoin.getSubProjectId();
                if (restrictedSubProjectIds.size() != 0 && restrictedSubProjectIds.contains(subProjectId)) continue;
                SubProjectInfo subRet = new SubProjectInfo();
                subRet.setName(subprojectJoin.getSubProjectName());
                subRet.setCode(subprojectJoin.getSubProjectCode());
                subRet.setNumber(subprojectJoin.getSubProjectNumber());
                subRet.setComment(subprojectJoin.getSubProjectComment());
                subRet.setId(subprojectJoin.getSubProjectId());
                subRet.setReadOnly(subprojectJoin.getSubProjectReadOnly());
                subRet.setProjectId(subprojectJoin.getProjectId());
                subRet.setIsAsBuiltType(subprojectJoin.getSubProjectTypeIsAsBuiltType());
                subProjectInfos.add(subRet);
            }
            for (ProjectPageJoin projectLeaderJoin : idToProjectLeaderJoin.values()) {
                OrganisationPersonInfo projectLeaderInfo = new OrganisationPersonInfo();
                projectLeaderInfo.setOrganisation(projectLeaderJoin.getProjectLeaderOrganisation_());
                projectLeaderInfo.setPerson(projectLeaderJoin.getProjectLeaderPerson_());
                projectLeaderInfo.setOrganisationPerson(projectLeaderJoin.getProjectLeaderOrganisationPerson_());
                projectLeaderInfos.add(projectLeaderInfo);
            }
            ret.setSubProjects(subProjectInfos);
            ret.setProjectLeaderInfos(projectLeaderInfos);
            return ret;
        }).collect(Collectors.toList());
        Set<Long> allowedProjectIds = this.projectDAO.getProjectIdsByOrganisationPerson(organisationPersonId);
        ArrayList filteredProjectInfos = new ArrayList();
        for (ProjectInfo projectInfo : projectInfos) {
            Long networkId = projectInfo.getNetworkId();
            Long projectId = projectInfo.getProjectId();
            if (networkIdToActions.containsKey(networkId) && networkIdToActions.get(networkId).contains(Action.INSERT_PROJECT)) {
                filteredProjectInfos.add(projectInfo);
                continue;
            }
            if (!allowedProjectIds.contains(projectId) || projectInfo.getProjectAccess() == ProjectAccess.INVISIBLE) continue;
            filteredProjectInfos.add(projectInfo);
        }
        projectInfos = filteredProjectInfos;
        ArrayList<Long> projectIds = new ArrayList<Long>();
        HashSet<Long> networkIdsSet = new HashSet<Long>();
        for (ProjectInfo projectInfo : projectInfos) {
            projectIds.add(projectInfo.getProjectId());
            networkIdsSet.add(projectInfo.getNetworkId());
        }
        ArrayList<Long> networkIds = new ArrayList<Long>();
        networkIds.addAll(networkIdsSet);
        Map<Long, Set<Action>> projectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.CHANGE_PROJECT_ACCESS_MODE, Action.ADMINISTRATE_NETWORK_PROJECT, Action.DELETE_PROJECT, Action.EDIT_PROJECT, Action.SHOW_PROJECT, Action.INSERT_PROJECT, Action.SHOW_PROJECT_PARTICIPATION, Action.EDIT_PROJECT_PARTICIPATION, Action.INSERT_SUB_PROJECT, Action.EDIT_SUB_PROJECT, Action.DELETE_SUB_PROJECT, Action.ADMINISTRATE_AS_BUILT_DOCUMENTS, Action.ADMINISTRATE_AS_BUILT_SUB_PROJECT, Action.OBJECT_LISTS_OVERVIEW, Action.REVIEW_CYCLE_INSTANCES_OVERVIEW, Action.PLAN_DELIVER_CATALOGUE_OVERVIEW, Action.DOCUMENT_VERSIONS_OVERVIEW);
        for (ProjectInfo projectInfo : projectInfos) {
            Long projectId = projectInfo.getProjectId();
            Long networkId = projectInfo.getNetworkId();
            ProjectStatus projectStatus = projectInfo.getProjectStatus();
            Set<Object> projectActions = projectIdToActions.containsKey(projectId) ? projectIdToActions.get(projectId) : new HashSet();
            Set<Object> networkActions = networkIdToActions.containsKey(networkId) ? networkIdToActions.get(networkId) : new HashSet();
            projectInfo.setMayChangeAccess(projectActions.contains(Action.CHANGE_PROJECT_ACCESS_MODE));
            projectInfo.setMayMakeProjectAdmin(networkActions.contains(Action.ADMINISTRATE_NETWORK_PROJECT));
            projectInfo.setMayDeleteProject(projectActions.contains(Action.DELETE_PROJECT));
            projectInfo.setMayEditProject(projectStatus == ProjectStatus.UNFINISHED ? projectActions.contains(Action.INSERT_PROJECT) : projectActions.contains(Action.EDIT_PROJECT));
            projectInfo.setMayShowProject(projectActions.contains(Action.SHOW_PROJECT));
            projectInfo.setMayShowParticipations(projectActions.contains(Action.SHOW_PROJECT_PARTICIPATION) || projectActions.contains(Action.EDIT_PROJECT_PARTICIPATION));
            projectInfo.setMayAddSubProject(projectActions.contains(Action.INSERT_SUB_PROJECT));
            projectInfo.setMayEditSubProject(projectActions.contains(Action.EDIT_SUB_PROJECT));
            projectInfo.setMayDeleteSubProject(projectActions.contains(Action.DELETE_SUB_PROJECT));
            projectInfo.setMayReadWriteSubProject(projectActions.contains(Action.EDIT_SUB_PROJECT));
            projectInfo.setMayOpenObjectList(projectActions.contains(Action.OBJECT_LISTS_OVERVIEW));
            projectInfo.setMayOpenReviewCycleInstancesOverview(projectActions.contains(Action.REVIEW_CYCLE_INSTANCES_OVERVIEW));
            projectInfo.setMayOpenPlanDeliverCatalogue(projectActions.contains(Action.PLAN_DELIVER_CATALOGUE_OVERVIEW));
            projectInfo.setMayOpenDocumentList(projectActions.contains(Action.DOCUMENT_VERSIONS_OVERVIEW));
            projectInfo.setHasAsBuiltDocuments(projectActions.contains(Action.ADMINISTRATE_AS_BUILT_DOCUMENTS));
            projectInfo.setHasAsBuiltSubProject(projectActions.contains(Action.ADMINISTRATE_AS_BUILT_SUB_PROJECT));
        }
        return projectInfos;
    }

    public ProjectPageSearchInfo getProjectPageSearchInfo(Long organisationPersonId) {
        ProjectPageSearchInfo ret = new ProjectPageSearchInfo();
        List<ProjectSearchJoin> searchJoins = this.projectDAO.getProjectSearchJoins();
        ret.setNetworks(searchJoins.stream().filter(a -> a.getUnionClause() == 3).map(ProjectSearchJoin::getNetwork).collect(Collectors.toList()));
        ret.setProjectsByNetwork(searchJoins.stream().filter(a -> a.getUnionClause() == 0).collect(Collectors.groupingBy(ProjectSearchJoin::getNetworkId, Collectors.mapping(ProjectSearchJoin::getProject, Collectors.toList()))));
        ret.setSubProjectsByProject(searchJoins.stream().filter(a -> a.getUnionClause() == 1).collect(Collectors.groupingBy(ProjectSearchJoin::getProjectId, Collectors.mapping(ProjectSearchJoin::getSubProject, Collectors.toList()))));
        HashMap networkIdToProjectLeaderJoins = new HashMap();
        for (ProjectSearchJoin searchJoin : searchJoins) {
            if (searchJoin.getUnionClause() != 2) continue;
            Long networkId = searchJoin.getNetworkId();
            if (!networkIdToProjectLeaderJoins.containsKey(networkId)) {
                networkIdToProjectLeaderJoins.put(networkId, new ArrayList());
            }
            ((List)networkIdToProjectLeaderJoins.get(networkId)).add(searchJoin);
        }
        ret.setProjectLeadersByNetwork(networkIdToProjectLeaderJoins);
        return ret;
    }

    public SubProjectEditInfo getSubProjectEditInfo(Long organisationPersonId, Long projectId, Long subProjectId) {
        List<DocumentRelease> documentsReleased;
        SubProject subProject;
        Project project;
        Long networkId;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (subProjectId != null) {
            SubProject subProject2 = (SubProject)this.subProjectDAO.get(subProjectId);
            projectId = subProject2.getProjectId();
        }
        if (!ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId = (project = (Project)this.projectDAO.get(projectId)).getNetworkId(), Action.PROJECTS_OVERVIEW)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to query project related data for network [" + networkId + "], it does not have privilege [" + Action.PROJECTS_OVERVIEW + "]");
        }
        HashSet<String> existingCodeNumbers = new HashSet<String>();
        List<SubProject> existingSubProjects = this.subProjectDAO.getByProject(projectId);
        for (SubProject existingSubProject : existingSubProjects) {
            String currCodeNumber = this.getSubProjectCodeNumber(existingSubProject);
            if (subProjectId != null && subProjectId.longValue() == existingSubProject.getId().longValue()) continue;
            existingCodeNumbers.add(currCodeNumber);
        }
        List<SubProjectType> subProjectTypes = subProjectId != null ? this.subProjectTypeDAO.getValidBySubProject(subProjectId) : this.subProjectTypeDAO.getValidByProject(projectId);
        if (subProjectId != null) {
            subProject = (SubProject)this.subProjectDAO.get(subProjectId);
        } else {
            subProject = new SubProject();
            subProject.setProjectId(projectId);
            subProject.setInvalidated(Boolean.valueOf(false));
            subProject.setWithAdditionalRoleTypes(Boolean.valueOf(false));
            subProject.setReadOnly(Boolean.valueOf(false));
        }
        List<Document> documents = this.documentDAO.getBySubProject(subProjectId);
        boolean isEditabel = true;
        for (Document document : documents) {
            if (document.isInvalidated().booleanValue()) continue;
            isEditabel = false;
            break;
        }
        if (isEditabel && (isEditabel = (documentsReleased = this.documentReleaseDAO.getActiveBySubProject(subProjectId)).isEmpty())) {
            List<DocumentVersion> documentVersions = this.documentVersionDAO.getBySubProjectViaInstance(subProjectId);
            isEditabel = documentVersions.isEmpty();
        }
        SubProjectEditInfo subProjectEditInfo = new SubProjectEditInfo();
        subProjectEditInfo.setExistingCodeNumbers(existingCodeNumbers);
        subProjectEditInfo.setSubProjectTypes(subProjectTypes);
        subProjectEditInfo.setSubProject(subProject);
        subProjectEditInfo.setIsTypeEditable(Boolean.valueOf(isEditabel));
        return subProjectEditInfo;
    }

    private String getSubProjectCodeNumber(SubProject subProject) {
        return (subProject.getCode() != null ? subProject.getCode() : "") + (subProject.getNumber() != null ? subProject.getNumber().toString() : "");
    }

    public SubProject saveSubProject(Long organisationPersonId, SubProject subProject) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        SubProject original = null;
        if (subProject.getId() != null) {
            original = (SubProject)this.subProjectDAO.get(subProject.getId());
        }
        Set<Action> actions = this.actionDAO.getActionsForProject(organisationPersonId, original != null ? original.getProjectId() : subProject.getProjectId(), Action.EDIT_SUB_PROJECT, Action.INSERT_SUB_PROJECT);
        if (subProject.getId() != null && !actions.contains(Action.EDIT_SUB_PROJECT)) {
            throw new SecurityException("the organisation person " + organisationPersonId + " does not have the editSubProject permission.");
        }
        if (subProject.getId() == null && !actions.contains(Action.INSERT_SUB_PROJECT)) {
            throw new SecurityException("the organisation person " + organisationPersonId + " does not have the insertSubProject permission.");
        }
        Long projectId = subProject.getProjectId();
        List<SubProject> existingSubProjects = this.subProjectDAO.getByProject(projectId);
        String ourCodeNumber = this.getSubProjectCodeNumber(subProject);
        for (SubProject existingSubProject : existingSubProjects) {
            String currCodeNumber = this.getSubProjectCodeNumber(existingSubProject);
            if (!ourCodeNumber.equals(currCodeNumber) || subProject.getId() != null && subProject.getId().longValue() == existingSubProject.getId().longValue()) continue;
            throw new IllegalArgumentException("Trying to supply duplicate code/number [" + ourCodeNumber + "] for subProject [" + subProject.getId() + "]; already exists for subProject [" + existingSubProject.getId() + "]");
        }
        SubProjectType type = (SubProjectType)this.subProjectTypeDAO.get(subProject.getSubProjectTypeId());
        SubProject toInsert = original == null ? subProject : original;
        toInsert.setCode(type.getCode());
        toInsert.setComment(subProject.getComment());
        toInsert.setName(subProject.getName());
        toInsert.setNumber(subProject.getNumber());
        toInsert.setSubProjectTypeId(subProject.getSubProjectTypeId());
        if (subProject.getId() == null) {
            log.info("inserting subProject.");
            toInsert = (SubProject)this.subProjectDAO.save(toInsert);
            ObjectList objectList = new ObjectList();
            objectList.setSubProjectId(toInsert.getId());
            objectList.setVersion(Integer.valueOf(0));
            objectList = (ObjectList)this.objectListDAO.save(objectList);
            toInsert.setObjectListId(objectList.getId());
            DocumentList documentList = new DocumentList();
            documentList.setSubProjectId(toInsert.getId());
            documentList.setVersion(Integer.valueOf(0));
            documentList = (DocumentList)this.documentListDAO.save(documentList);
            toInsert.setDocumentListId(documentList.getId());
            this.subProjectDAO.update(toInsert);
            return toInsert;
        }
        log.info("updating subProject.");
        this.subProjectDAO.update(toInsert);
        return toInsert;
    }

    private List<ObjectPlannerDefinitionInfo> getObjectPlannerDefinitionInfosByNetworkId(Long networkId) {
        List<ObjectPlannerDefinitionTemplateJoin> templateJoins = this.objectPlannerDefinitionTemplateDAO.getTemplateJoinsByNetwork(networkId);
        HashMap templateIdToJoins = new HashMap();
        for (ObjectPlannerDefinitionTemplateJoin templateJoin : templateJoins) {
            Long templateId = templateJoin.getObjectPlannerDefinitionTemplateId();
            if (!templateIdToJoins.containsKey(templateId)) {
                templateIdToJoins.put(templateId, new ArrayList());
            }
            ((List)templateIdToJoins.get(templateId)).add(templateJoin);
        }
        ArrayList<ObjectPlannerDefinitionInfo> definitionInfos = new ArrayList<ObjectPlannerDefinitionInfo>();
        for (Long templateId : templateIdToJoins.keySet()) {
            List currTemplateJoins = (List)templateIdToJoins.get(templateId);
            ObjectPlannerDefinitionTemplateJoin someJoin = (ObjectPlannerDefinitionTemplateJoin)currTemplateJoins.get(0);
            ObjectPlannerDefinition definition = new ObjectPlannerDefinition();
            definition.setId(null);
            definition.setName(someJoin.getObjectPlannerDefinitionTemplateName());
            definition.setTemplateId(templateId);
            ObjectPlannerDefinitionInfo definitionInfo = new ObjectPlannerDefinitionInfo();
            definitionInfo.setObjectPlannerDefinition(definition);
            ArrayList<ObjectPlannerPositionDefinitionInfo> positionInfos = new ArrayList<ObjectPlannerPositionDefinitionInfo>();
            for (ObjectPlannerDefinitionTemplateJoin currTemplateJoin : currTemplateJoins) {
                ObjectPlannerPositionDefinitionInfo positionInfo = new ObjectPlannerPositionDefinitionInfo();
                ObjectPlannerPositionDefinition positionDefinition = new ObjectPlannerPositionDefinition();
                positionDefinition.setId(null);
                positionDefinition.setDefinitionId(null);
                positionDefinition.setName(currTemplateJoin.getObjectPlannerPositionDefinitionTemplateName());
                positionDefinition.setRoleTypeId(currTemplateJoin.getObjectPlannerPositionDefinitionTemplateRoleTypeId());
                positionDefinition.setStatusNotification(currTemplateJoin.getObjectPlannerPositionDefinitionTemplateStatusNotification());
                Integer notificationBitMap = positionDefinition.getStatusNotification();
                positionInfo.setNotificateReleasedPositiv(Boolean.valueOf((notificationBitMap >> 0) % 2 == 1));
                positionInfo.setNotificateReleasedNegative(Boolean.valueOf((notificationBitMap >> 1) % 2 == 1));
                positionInfo.setNotificateInvalidatedVersion(Boolean.valueOf((notificationBitMap >> 2) % 2 == 1));
                positionInfo.setNotificateInvalidatedAll(Boolean.valueOf((notificationBitMap >> 3) % 2 == 1));
                positionInfo.setNotificateDeleted(Boolean.valueOf((notificationBitMap >> 4) % 2 == 1));
                positionInfo.setNotificateRevised(Boolean.valueOf((notificationBitMap >> 5) % 2 == 1));
                positionInfo.setObjectPlannerPositionDefinition(positionDefinition);
                positionInfo.setRoleType(currTemplateJoin.getRoleType());
                positionInfos.add(positionInfo);
            }
            definitionInfo.setPositionInfos(positionInfos);
            definitionInfos.add(definitionInfo);
        }
        return definitionInfos;
    }

    public ProjectPageInfo getProjectCreateInfo(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkActions(organisationPersonId, Action.INSERT_PROJECT);
        if (networkIdToActions.isEmpty()) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.INSERT_PROJECT + "] needed for getProjectCreateInfo");
        }
        OrganisationPersonJoin callingOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String userLocale = callingOrganisationPersonJoin.getPersonVariablesUserLocale();
        OrganisationPerson organisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(organisationPersonId);
        Long organisationId = organisationPerson.getOrganisationId();
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        Person person = (Person)this.personDAO.get(personId);
        List<Object> definitionInfos = networkId != null ? this.getObjectPlannerDefinitionInfosByNetworkId(networkId) : new ArrayList();
        List<Object> documentNumberPartGroups = networkId != null ? this.getDocumentNumberPartGroups(networkId) : new ArrayList();
        List<Object> reviewCycleResultOptions = networkId != null ? this.getReviewCycleResultOptions(networkId) : new ArrayList();
        for (ReviewCycleResultOption reviewCycleResultOption : reviewCycleResultOptions) {
            String name = reviewCycleResultOption.getName();
            name = I18nHelper.getLocaleStringFromDatabase(name, userLocale);
            reviewCycleResultOption.setName(name);
        }
        List<Localisation> localisations = this.getLocalisations();
        List<OrganisationPersonSelectionJoin> list = this.organisationPersonDAO.getOrganisationPersonSelectionJoinsByOrganisation(organisationId);
        List roleTypes = this.roleTypeDAO.getAll();
        HashMap<Long, Integer> partGroupIdToMaxProjectCodeLength = new HashMap<Long, Integer>();
        for (DocumentNumberPartGroup documentNumberPartGroup : documentNumberPartGroups) {
            List<DocumentNumberPart> documentNumberParts = this.documentNumberPartDAO.getByGroup(documentNumberPartGroup.getId());
            for (DocumentNumberPart documentNumberPart : documentNumberParts) {
                String ognlRule = documentNumberPart.getOgnlRule();
                Integer length = documentNumberPart.getLength();
                if (!ognlRule.contains(".project.code")) continue;
                partGroupIdToMaxProjectCodeLength.put(documentNumberPartGroup.getId(), length);
            }
        }
        ProjectPageInfo pageInfo = new ProjectPageInfo();
        List list2 = this.networkDAO.getAll();
        ArrayList<Network> networksForClient = new ArrayList<Network>();
        for (Network network : list2) {
            if (!networkIdToActions.containsKey(network.getId()) || !networkIdToActions.get(network.getId()).contains(Action.INSERT_PROJECT)) continue;
            networksForClient.add(network);
        }
        pageInfo.setNetworks(networksForClient);
        Project project = new Project();
        project.setCreatedById(personId);
        project.setStatus(Integer.valueOf(ProjectStatus.ACTIVE.getValue()));
        project.setAccess(Integer.valueOf(ProjectAccess.READ_WRITE.getValue()));
        project.setWithParticipantsSubProjectRestriction(Boolean.valueOf(false));
        project.setIgnorePlotOrderReceivedSteps(Boolean.valueOf(false));
        project.setUsePDCStartDateForTasks(Boolean.valueOf(false));
        pageInfo.setProject(project);
        pageInfo.setProjectHolidays(new ArrayList());
        pageInfo.setCreatedBy(person);
        pageInfo.setProjectLeaders(new ArrayList());
        pageInfo.setObjectPlannerDefinitionInfos(definitionInfos);
        pageInfo.setRoleTypes(roleTypes);
        pageInfo.setDocumentNumberPartGroups(documentNumberPartGroups);
        pageInfo.setPartGroupIdToMaxProjectCodeLength(partGroupIdToMaxProjectCodeLength);
        pageInfo.setReviewCycleResultOptions(reviewCycleResultOptions);
        pageInfo.setLocalisations(localisations);
        pageInfo.setOrganisationPersonSelectionJoins(list);
        List<Object> existingProjects = networkId != null ? this.projectDAO.getByNetwork(networkId) : new ArrayList();
        pageInfo.setExistingProjects(existingProjects);
        pageInfo.setHasExistingDocuments(Boolean.valueOf(false));
        return pageInfo;
    }

    public ProjectPageInfo getProjectEditInfo(Long organisationPersonId, Long projectId) {
        List<Object> definitionInfos;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.EDIT_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.EDIT_PROJECT + "] needed for getProjectEditInfo; for project [" + projectId + "]");
        }
        OrganisationPerson organisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(organisationPersonId);
        Long organisationId = organisationPerson.getOrganisationId();
        Project project = (Project)this.projectDAO.get(projectId);
        List<ProjectHoliday> holidays = this.projectHolidayDAO.getByProject(projectId);
        Person createdBy = (Person)this.personDAO.get(((OrganisationPerson)this.organisationPersonDAO.get(project.getCreatedById())).getPersonId());
        List<Person> projectLeaders = this.personDAO.getProjectLeaders(projectId);
        List<ProjectEditJoin> projectEditJoins = this.projectDAO.getProjectEditJoins(projectId);
        ObjectPlannerDefinition objectPlannerDefinition = null;
        ArrayList<ObjectPlannerPositionDefinitionInfo> positionInfos = new ArrayList<ObjectPlannerPositionDefinitionInfo>();
        for (ProjectEditJoin projectEditJoin : projectEditJoins) {
            Long currentObjectPlannerDefinitionId = projectEditJoin.getObjectPlannerDefinitionId();
            if (objectPlannerDefinition == null) {
                objectPlannerDefinition = projectEditJoin.getObjectPlannerDefinition();
            } else if (objectPlannerDefinition.getId().longValue() != currentObjectPlannerDefinitionId.longValue()) {
                throw new RuntimeException("Did not find unique ObjectPlannerDefinition for projectId [" + projectId + "]");
            }
            ObjectPlannerPositionDefinitionInfo positionInfo = new ObjectPlannerPositionDefinitionInfo();
            ObjectPlannerPositionDefinition definition = projectEditJoin.getObjectPlannerPositionDefinition();
            positionInfo.setObjectPlannerPositionDefinition(definition);
            RoleType roleType = projectEditJoin.getRoleType();
            positionInfo.setRoleType(roleType);
            Integer notificationBitMap = definition.getStatusNotification();
            positionInfo.setNotificateReleasedPositiv(Boolean.valueOf((notificationBitMap >> 0) % 2 == 1));
            positionInfo.setNotificateReleasedNegative(Boolean.valueOf((notificationBitMap >> 1) % 2 == 1));
            positionInfo.setNotificateInvalidatedVersion(Boolean.valueOf((notificationBitMap >> 2) % 2 == 1));
            positionInfo.setNotificateInvalidatedAll(Boolean.valueOf((notificationBitMap >> 3) % 2 == 1));
            positionInfo.setNotificateDeleted(Boolean.valueOf((notificationBitMap >> 4) % 2 == 1));
            positionInfo.setNotificateRevised(Boolean.valueOf((notificationBitMap >> 5) % 2 == 1));
            positionInfos.add(positionInfo);
        }
        Long networkId = project.getNetworkId();
        Network network = (Network)this.networkDAO.get(networkId);
        List<DocumentNumberPartGroup> documentNumberPartGroups = this.getDocumentNumberPartGroups(networkId);
        List<ReviewCycleResultOption> reviewCycleResultOptions = this.getReviewCycleResultOptions(networkId);
        List<Localisation> localisations = this.getLocalisations();
        List<OrganisationPersonSelectionJoin> organisationPersonSelectionJoins = this.organisationPersonDAO.getOrganisationPersonSelectionJoinsByOrganisation(organisationId);
        ObjectPlannerDefinitionInfo definitionInfo = new ObjectPlannerDefinitionInfo();
        definitionInfo.setObjectPlannerDefinition(objectPlannerDefinition);
        definitionInfo.setPositionInfos(positionInfos);
        if (objectPlannerDefinition != null) {
            definitionInfos = new ArrayList();
            definitionInfos.add(definitionInfo);
        } else {
            definitionInfos = this.getObjectPlannerDefinitionInfosByNetworkId(networkId);
        }
        HashMap<Long, Integer> partGroupIdToMaxProjectCodeLength = new HashMap<Long, Integer>();
        List<DocumentNumberPart> documentNumberParts = this.documentNumberPartDAO.getByGroup(project.getDocumentNumberPartGroupId());
        for (DocumentNumberPart documentNumberPart : documentNumberParts) {
            String ognlRule = documentNumberPart.getOgnlRule();
            Integer length = documentNumberPart.getLength();
            if (!ognlRule.contains(".project.code")) continue;
            partGroupIdToMaxProjectCodeLength.put(project.getDocumentNumberPartGroupId(), length);
        }
        List roleTypes = this.roleTypeDAO.getAll();
        ProjectPageInfo pageInfo = new ProjectPageInfo();
        pageInfo.setCreatedBy(createdBy);
        pageInfo.setNetwork(network);
        pageInfo.setProject(project);
        pageInfo.setProjectHolidays(holidays);
        pageInfo.setProjectLeaders(projectLeaders);
        pageInfo.setObjectPlannerDefinitionInfos(definitionInfos);
        pageInfo.setHasObjectPlannerDefinition(Boolean.valueOf(objectPlannerDefinition != null));
        pageInfo.setRoleTypes(roleTypes);
        pageInfo.setDocumentNumberPartGroups(documentNumberPartGroups);
        pageInfo.setPartGroupIdToMaxProjectCodeLength(partGroupIdToMaxProjectCodeLength);
        pageInfo.setReviewCycleResultOptions(reviewCycleResultOptions);
        pageInfo.setLocalisations(localisations);
        pageInfo.setOrganisationPersonSelectionJoins(organisationPersonSelectionJoins);
        List<Project> existingProjects = this.projectDAO.getByNetwork(networkId);
        pageInfo.setExistingProjects(existingProjects);
        Boolean hasExistingDocuments = !this.documentDAO.getByProject(projectId).isEmpty();
        pageInfo.setHasExistingDocuments(hasExistingDocuments);
        return pageInfo;
    }

    public List<DocumentNumberPartGroup> getDocumentNumberPartGroups(Long networkId) {
        return this.documentNumberPartGroupDAO.getByNetwork(networkId);
    }

    public List<Localisation> getLocalisations() {
        return this.localisationDAO.getAll();
    }

    public List<ReviewCycleResultOption> getReviewCycleResultOptions(Long networkId) {
        return this.reviewCycleResultOptionDAO.getByNetwork(networkId);
    }

    public Project saveProject(Long organisationPersonId, ProjectSaveInfo info) {
        Project newProject;
        Network network;
        Long networkId;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Project original = null;
        if (info.getProject().getId() != null) {
            original = (Project)this.projectDAO.get(info.getProject().getId());
        }
        info.getProject().setId(original != null ? original.getId() : null);
        Long l = networkId = original != null ? original.getNetworkId() : info.getProject().getNetworkId();
        if (info.getProject().getId() == null) {
            if (!ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId, Action.INSERT_PROJECT)) {
                throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.INSERT_PROJECT + "] needed for saveProject; for network [" + networkId + "]");
            }
        } else if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, original.getId(), Action.EDIT_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.EDIT_PROJECT + "] needed for saveProject; for project [" + original.getId() + "]");
        }
        if (!(network = (Network)this.networkDAO.get(networkId)).isAmbiguousProjectCodes().booleanValue()) {
            boolean buekProject = info.getProject().getStatus().intValue() == ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue();
            List<Project> networkProjects = this.projectDAO.getByNetwork(networkId);
            HashSet<String> forbiddenCodes = new HashSet<String>();
            for (Project currProject : networkProjects) {
                if (info.getProject().getId() != null && info.getProject().getId().longValue() == currProject.getId().longValue() || (!buekProject || currProject.getStatus().intValue() != ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) && (buekProject || currProject.getStatus().intValue() != ProjectStatus.ACTIVE.getValue())) continue;
                forbiddenCodes.add(currProject.getCode());
            }
            if (forbiddenCodes.contains(info.getProject().getCode())) {
                throw new RuntimeException("Duplicate project code.");
            }
        }
        double nowEpochSeconds = (double)Instant.now().toEpochMilli() / 1000.0;
        if (original != null) {
            original.setCode(info.getProject().getCode());
            original.setName(info.getProject().getName());
            original.setComment(info.getProject().getComment());
            original.setRouteName(info.getProject().getRouteName());
            original.setStretchName(info.getProject().getStretchName());
            original.setStretchKmFrom(info.getProject().getStretchKmFrom());
            original.setStretchKmTo(info.getProject().getStretchKmTo());
            original.setLocalisationId(info.getProject().getLocalisationId());
            original.setDocumentNumberPartGroupId(info.getProject().getDocumentNumberPartGroupId());
            original.setWithParticipantsSubProjectRestriction(info.getProject().getWithParticipantsSubProjectRestriction());
            original.setIgnorePlotOrderReceivedSteps(info.getProject().getIgnorePlotOrderReceivedSteps());
            original.setAllowedResultOptionId(info.getProject().getAllowedResultOptionId());
            original.setPrincipalProject(info.getProject().getPrincipalProject());
            original.setModified(Double.valueOf((double)Instant.now().toEpochMilli() / 1000.0));
            original.setModifiedById(organisationPersonId);
            this.projectDAO.update(original);
            newProject = original;
        } else {
            newProject = info.getProject();
            newProject.setModified(Double.valueOf(nowEpochSeconds));
            newProject.setModifiedById(organisationPersonId);
            newProject.setCreated(Double.valueOf(nowEpochSeconds));
            newProject.setCreatedById(organisationPersonId);
            newProject.setAccess(Integer.valueOf(ProjectAccess.READ_WRITE.getValue()));
            newProject = (Project)this.projectDAO.save(newProject);
            List<CdesRole> adminRoles = this.cdesRoleDAO.getByAttributes(newProject.getNetworkId(), ProjectFlag.PROJECT_ADMIN_ROLE.getValue());
            List<CdesRole> leaderRoles = this.cdesRoleDAO.getByAttributes(newProject.getNetworkId(), ProjectFlag.PROJECT_MANAGER_ROLE.getValue());
            if (adminRoles.size() < 1) {
                throw new RuntimeException("Could not find a project administrator role.");
            }
            if (leaderRoles.size() < 1) {
                throw new RuntimeException("Could not find a project leader role.");
            }
            OrganisationPerson creatorOrganisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(organisationPersonId);
            if (info.getProjectLeaderOrganisationPersonId() != null) {
                OrganisationPerson leaderOrganisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(info.getProjectLeaderOrganisationPersonId());
                if (!creatorOrganisationPerson.getOrganisationId().equals(leaderOrganisationPerson.getOrganisationId())) {
                    throw new SecurityException("The project leader is not a part of the same organisation as the project creator.");
                }
                if (leaderOrganisationPerson != null) {
                    ProjectParticipation projectLeaderParticipation = new ProjectParticipation();
                    projectLeaderParticipation.setProjectId(newProject.getId());
                    projectLeaderParticipation.setRoleId(leaderRoles.get(0).getId());
                    projectLeaderParticipation.setOrganisationId(leaderOrganisationPerson.getOrganisationId());
                    projectLeaderParticipation.setMailFlag(Boolean.valueOf(false));
                    projectLeaderParticipation.setInvalidated(Integer.valueOf(0));
                    this.projectParticipationDAO.save(projectLeaderParticipation);
                    ProjectParticipant leaderParticipant = new ProjectParticipant();
                    leaderParticipant.setParticipationId(projectLeaderParticipation.getId());
                    leaderParticipant.setMainParticipantFlag(Boolean.valueOf(true));
                    leaderParticipant.setOrganisationPersonId(leaderOrganisationPerson.getId());
                    leaderParticipant.setInactiveFlag(Boolean.valueOf(false));
                    this.projectParticipantDAO.save(leaderParticipant);
                }
            }
            ProjectParticipation adminParticipation = new ProjectParticipation();
            adminParticipation.setProjectId(newProject.getId());
            adminParticipation.setRoleId(adminRoles.get(0).getId());
            adminParticipation.setOrganisationId(creatorOrganisationPerson.getOrganisationId());
            adminParticipation.setMailFlag(Boolean.valueOf(false));
            adminParticipation.setInvalidated(Integer.valueOf(0));
            this.projectParticipationDAO.save(adminParticipation);
            ProjectParticipant adminParticipant = new ProjectParticipant();
            adminParticipant.setParticipationId(adminParticipation.getId());
            adminParticipant.setMainParticipantFlag(Boolean.valueOf(true));
            adminParticipant.setOrganisationPersonId(creatorOrganisationPerson.getId());
            adminParticipant.setInactiveFlag(Boolean.valueOf(false));
            this.projectParticipantDAO.save(adminParticipant);
            this.copyRealmTemplates(newProject.getId(), nowEpochSeconds);
        }
        for (ProjectHoliday newHoliday : info.getProjectHolidays()) {
            newHoliday.setProjectId(newProject.getId());
        }
        List<ProjectHoliday> originalHolidays = this.projectHolidayDAO.getByProject(newProject);
        QueryHelper.syncWithDatabase(this.projectHolidayDAO, info.getProjectHolidays(), originalHolidays);
        List<ObjectPlannerDefinition> prevObjectPlannerDefinitions = this.objectPlannerDefinitionDAO.getByProject(newProject.getId());
        ObjectPlannerDefinition objectPlannerDefinition = info.getObjectPlannerDefinition();
        List positionDefinitions = info.getPositionDefinitions();
        Long objectPlannerDefinitionId = null;
        if (prevObjectPlannerDefinitions.size() == 0 && objectPlannerDefinition != null) {
            objectPlannerDefinition.setProjectId(newProject.getId());
            objectPlannerDefinition = (ObjectPlannerDefinition)this.objectPlannerDefinitionDAO.save(objectPlannerDefinition);
            objectPlannerDefinitionId = objectPlannerDefinition.getId();
        } else {
            objectPlannerDefinitionId = prevObjectPlannerDefinitions.get(0).getId();
        }
        for (ObjectPlannerPositionDefinition positionDefinition : positionDefinitions) {
            positionDefinition.setDefinitionId(objectPlannerDefinitionId);
        }
        Long projectId = newProject.getId();
        List<ObjectPlannerPositionDefinition> originalPositionDefinitions = this.objectPlannerPositionDefinitionDAO.getByProjectId(projectId);
        QueryHelper.syncWithDatabase(this.objectPlannerPositionDefinitionDAO, positionDefinitions, originalPositionDefinitions);
        return newProject;
    }

    public SubProject setSubProjectAccess(Long organisationPersonId, Long subProjectId, boolean readOnly) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        SubProject subProject = (SubProject)this.subProjectDAO.get(subProjectId);
        Long projectId = subProject.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.EDIT_SUB_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.EDIT_SUB_PROJECT + "] needed for setSubProjectAccess; for project [" + projectId + "]");
        }
        subProject.setReadOnly(Boolean.valueOf(readOnly));
        this.subProjectDAO.update(subProject);
        return subProject;
    }

    public void deleteSubProject(Long organisationPersonId, Long subProjectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        SubProject subProject = (SubProject)this.subProjectDAO.get(subProjectId);
        Long projectId = subProject.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_SUB_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.DELETE_SUB_PROJECT + "] needed for deleteSubProject; for project [" + projectId + "]");
        }
        List<PlotOrderDeleteJoin> allDeleteJoins = this.plotOrderDAO.getPlotOrderDeleteJoinByProjectOfSubProject(subProjectId);
        List<PlotOrderDeleteJoin> nonDeletableJoins = this.plotUtils.getPlotOrderDeleteJoinsPreventingSubProjectInvalidate(allDeleteJoins, false, subProjectId);
        if (nonDeletableJoins.size() > 0) {
            throw new RuntimeException("Cannot invalidate subProject [" + subProjectId + "]; there are [" + nonDeletableJoins.size() + "] PlotOrderDeleteJoins preventing this (accepted but not completed; items in more than one SubProject). Hint: The client should prevent us from ending up here.");
        }
        this.doDeleteSubProject(subProjectId);
    }

    private boolean doDeleteSubProject(Long subProjectId) {
        List<ObjectListRelease> objectListReleases = this.objectListReleaseDAO.getBySubProject(subProjectId);
        if (objectListReleases.size() > 0) {
            log.info("Released object lists exist, invalidating sub project [" + subProjectId + "]");
            List<PlotOrderDeleteJoin> allDeleteJoins = this.plotOrderDAO.getPlotOrderDeleteJoinByProjectOfSubProject(subProjectId);
            this.plotUtils.deletePlotOrdersForSubProjectInvalidate(allDeleteJoins);
            this.objectUtils.invalidateObjectListBySubProject(subProjectId);
            this.projectUtils.deleteTasksForSubProjectDelete(subProjectId);
            SubProject subProject = (SubProject)this.subProjectDAO.get(subProjectId);
            subProject.setInvalidated(Boolean.valueOf(true));
            this.subProjectDAO.update(subProject);
            return false;
        }
        log.info("No released object lists exist, deleting sub project [" + subProjectId + "]");
        this.planDeliverUtils.deleteNeverReleasedDocumentListBySubProjectId(subProjectId);
        this.objectUtils.deleteNeverReleasedObjectListBySubProject(subProjectId);
        this.reviewUtils.deleteNeverReleasedReviewCycleInstanceBySubProject(subProjectId);
        this.projectParticipationSubProjectRestrictionDAO.deleteBySubProject(subProjectId);
        this.subProjectDAO.delete(subProjectId);
        return true;
    }

    public void deleteProject(Long organisationPersonId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT);
        if (!actions.contains(Action.SUPER_ADMIN_RIGHT) && !ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.DELETE_PROJECT + "] or SUPER_ADMIN_RIGHT needed for deleting project [" + projectId + "]");
        }
        boolean deletable = true;
        Project project = (Project)this.projectDAO.get(projectId);
        List<SubProject> subProjects = this.subProjectDAO.getByProject(projectId);
        for (SubProject subProject : subProjects) {
            List<PlotOrderDeleteJoin> allDeleteJoins = this.plotOrderDAO.getPlotOrderDeleteJoinByProjectOfSubProject(subProject.getId());
            List<PlotOrderDeleteJoin> nonDeletableJoins = this.plotUtils.getPlotOrderDeleteJoinsPreventingSubProjectInvalidate(allDeleteJoins, true, subProject.getId());
            if (nonDeletableJoins.size() > 0) {
                throw new RuntimeException("Cannot invalidate subProject [" + subProject.getId() + "]; there are [" + nonDeletableJoins.size() + "] PlotOrderDeleteJoins preventing this (accepted but not completed; items in more than one SubProject). Hint: The client should prevent us from ending up here.");
            }
            deletable &= this.doDeleteSubProject(subProject.getId());
        }
        if (deletable) {
            this.projectUtils.deleteParticipationsByProjectId(projectId);
            this.reviewUtils.deleteRealmsByProjectId(projectId);
            this.projectUtils.deleteProjectHolidaysByProjectId(projectId);
            this.objectUtils.deleteObjectPlannerDefinitionByProjectId(projectId);
            this.projectDAO.delete(projectId);
            this.projectUtils.deleteProjectConfigById(project.getProjectConfigId());
        } else {
            project.setAccess(Integer.valueOf(ProjectAccess.INVISIBLE.getValue()));
            project.setStatus(Integer.valueOf(ProjectStatus.ACTIVE.getValue()));
            this.projectDAO.update(project);
        }
    }

    public void makeProjectAdmin(Long organisationPersonId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Project project = (Project)this.projectDAO.get(projectId);
        Long networkId = project.getNetworkId();
        if (!ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId, Action.ADMINISTRATE_NETWORK_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.ADMINISTRATE_NETWORK_PROJECT + "] needed for making it admin of project [" + projectId + "] in network [" + networkId + "]");
        }
        ProjectParticipation participation = new ProjectParticipation();
        participation.setProjectId(projectId);
        ProjectStatus projectStatus = ProjectStatus.fromValue((int)project.getStatus());
        boolean buek = projectStatus == ProjectStatus.PLANNING_NOTIFICATION_PROJECT;
        ProjectFlag projectFlag = buek ? ProjectFlag.PROJECT_ADMIN_PLANNING_NOTIFICATION : ProjectFlag.PROJECT_ADMIN_ROLE;
        List<CdesRole> roles = this.cdesRoleDAO.getByNetworkAndProjectFlag(networkId, projectFlag.getValue());
        if (roles.size() == 0) {
            throw new RuntimeException("Did not find the project administrator role for networkId [" + networkId + "]");
        }
        participation.setRoleId(roles.get(0).getId());
        OrganisationPerson organisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(organisationPersonId);
        participation.setOrganisationId(organisationPerson.getOrganisationId());
        participation.setMailFlag(Boolean.valueOf(false));
        participation.setInvalidated(Integer.valueOf(0));
        participation = (ProjectParticipation)this.projectParticipationDAO.save(participation);
        ProjectParticipant participant = new ProjectParticipant();
        participant.setMainParticipantFlag(Boolean.valueOf(true));
        participant.setParticipationId(participation.getId());
        participant.setOrganisationPersonId(organisationPersonId);
        participant.setInactiveFlag(Boolean.valueOf(false));
        this.projectParticipantDAO.save(participant);
    }

    public void setProjectAccess(Long organisationPersonId, Long projectId, ProjectAccess projectAccess) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.CHANGE_PROJECT_ACCESS_MODE)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.CHANGE_PROJECT_ACCESS_MODE + "] needed for changing project access mode of project [" + projectId + "] to [" + projectAccess + "]");
        }
        Project project = (Project)this.projectDAO.get(projectId);
        project.setAccess(Integer.valueOf(projectAccess.getValue()));
        this.projectDAO.update(project);
    }

    private void copyRealmTemplates(Long projectId, double nowEpochSeconds) {
        List<Realm> templates = this.realmDAO.getTemplates(projectId);
        this.realmDAO.saveBatch(templates.stream().map(template -> {
            Realm realm = new Realm(template);
            realm.setId(null);
            realm.setProjectId(projectId);
            realm.setValidFromDate(Double.valueOf(nowEpochSeconds));
            return realm;
        }).collect(Collectors.toList()));
    }

    public List<Project> getByCode(String code, Long networkId) {
        return this.projectDAO.getByCode(code, networkId);
    }

    public List<Project> getByMasterDataSet(Long organisationPersonId, Long masterDataSetId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        return this.projectDAO.getByMasterDataSet(masterDataSetId);
    }

    public boolean hasDocuments(Long projectId) {
        return !this.documentDAO.getByProject(projectId).isEmpty();
    }

    public String triggerExportParticipationPdf(Long organisationPersonId, ParticipationPageSearchModel searchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List columnSortSpecs = ColumnSortSpec.getFromClient(sortColumns);
        ParticipationPdfCallable job = new ParticipationPdfCallable(this.participationPdfExporter, this, organisationPersonId, searchModel, columnToWidth, columnSortSpecs, this.enableCustomerLogo);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public Project getById(Long projectId) {
        return (Project)this.projectDAO.get(projectId);
    }

    @FunctionalInterface
    private static interface QuadConsumer<A, B, C, D> {
        public void consume(A var1, B var2, C var3, D var4);
    }

    private static class SaveParticipationsRet {
        public Supplier<Stream<ParticipationEditInfo>> editInfos;
        public Supplier<Stream<ProjectParticipation>> participations;

        public SaveParticipationsRet(Supplier<Stream<ParticipationEditInfo>> editInfos, Supplier<Stream<ProjectParticipation>> participations) {
            this.editInfos = editInfos;
            this.participations = participations;
        }
    }
}

