/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.DocumentTypeLabelContent;
import at.cdes.api.dto.LabelContent;
import at.cdes.impl.dao.DocumentTypeLabelContentDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcDocumentTypeLabelContentDAO
extends AbstrIdDAO<DocumentTypeLabelContent>
implements DocumentTypeLabelContentDAO {
    public JdbcDocumentTypeLabelContentDAO() {
        super(DocumentTypeLabelContent.class, "documentTypeId", "document_type_label_content", new String[]{"document_type_id", "label_content_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcDocumentTypeLabelContentDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "label_content_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcDocumentTypeLabelContentDAO.getSelectClauseForDto("document_type_label_content", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcDocumentTypeLabelContentDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".document_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_type_id") + "," + entityLocalName + ".label_content_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "label_content_id") + " ";
    }

    protected DocumentTypeLabelContent fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        DocumentTypeLabelContent documentTypeLabelContent = new DocumentTypeLabelContent();
        documentTypeLabelContent.setDocumentTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentTypeLabelContent.setLabelContentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return documentTypeLabelContent;
    }

    public static DocumentTypeLabelContent fillDocumentTypeLabelContentFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        DocumentTypeLabelContent documentTypeLabelContent = new DocumentTypeLabelContent();
        documentTypeLabelContent.setDocumentTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentTypeLabelContent.setLabelContentId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return documentTypeLabelContent;
    }

    public static DocumentTypeLabelContent fillDocumentTypeLabelContentFromResultSet(ResultSet rs) throws SQLException {
        return JdbcDocumentTypeLabelContentDAO.fillDocumentTypeLabelContentFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteByDocumentTypeAndLabelContent(final Long documentTypeId, final Long labelContentId) {
        String sql = "DELETE FROM document_type_label_content WHERE document_type_id = ? AND label_content_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, documentTypeId);
                statement.setLong(currIndex++, labelContentId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(DocumentTypeLabelContent dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<DocumentTypeLabelContent> dtos) {
        Iterator<DocumentTypeLabelContent> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, DocumentTypeLabelContent documentTypeLabelContent) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentTypeLabelContent.getDocumentTypeId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)documentTypeLabelContent.getLabelContentId());
    }

    @Override
    public List<DocumentTypeLabelContent> getByDocumentType(DocumentType documentType) {
        return this.getByDocumentType(documentType.getId());
    }

    @Override
    public List<DocumentTypeLabelContent> getByDocumentType(final Long documentTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentTypeId);
            }
        });
    }

    @Override
    public List<DocumentTypeLabelContent> getByLabelContent(LabelContent labelContent) {
        return this.getByLabelContent(labelContent.getId());
    }

    @Override
    public List<DocumentTypeLabelContent> getByLabelContent(final Long labelContentId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"label_content_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, labelContentId);
            }
        });
    }

    @Override
    public List<DocumentTypeLabelContent> getByDocumentTypes(Collection<Long> documentTypeId) {
        if (documentTypeId.isEmpty()) {
            return new ArrayList<DocumentTypeLabelContent>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentTypeId.size()];
        int n = 0;
        Iterator<Long> it = documentTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentTypeLabelContent> getByLabelContents(Collection<Long> labelContentId) {
        if (labelContentId.isEmpty()) {
            return new ArrayList<DocumentTypeLabelContent>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[labelContentId.size()];
        int n = 0;
        Iterator<Long> it = labelContentId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"label_content_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

