/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtil {
    public static <A, B, C> Stream<C> zip(Stream<? extends A> a, Stream<? extends B> b, final BiFunction<? super A, ? super B, ? extends C> zipper) {
        Objects.requireNonNull(zipper);
        Spliterator aSpliterator = Objects.requireNonNull(a).spliterator();
        Spliterator bSpliterator = Objects.requireNonNull(b).spliterator();
        int characteristics = aSpliterator.characteristics() & bSpliterator.characteristics() & 0xFFFFFEFA;
        long zipSize = (characteristics & 0x40) != 0 ? Math.min(aSpliterator.getExactSizeIfKnown(), bSpliterator.getExactSizeIfKnown()) : -1L;
        final Iterator aIterator = Spliterators.iterator(aSpliterator);
        final Iterator bIterator = Spliterators.iterator(bSpliterator);
        Iterator cIterator = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return aIterator.hasNext() && bIterator.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(aIterator.next(), bIterator.next());
            }
        };
        Spliterator split = Spliterators.spliterator(cIterator, zipSize, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.stream(split, true) : StreamSupport.stream(split, false);
    }
}

