/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.compositeDto.MasterDataInfo;
import at.cdes.api.compositeDto.PageContext;
import at.cdes.api.compositeDto.VersionInfo;
import at.cdes.api.dto.ActionInfo;
import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.SubProject;
import at.cdes.api.dto.SubProjectType;
import at.cdes.api.guiService.ContextService;
import at.cdes.api.joinDto.DocumentNumberSpecJoinDto;
import at.cdes.api.joinDto.MasterDataJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.ProjectHolidayJoin;
import at.cdes.api.joinDto.SubProjectJoinDto;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.sec.PasswordStatus;
import at.cdes.api.sec.PasswordStatusChecker;
import at.cdes.api.sec.UserPolicyStatus;
import at.cdes.api.sec.UserPolicyStatusChecker;
import at.cdes.api.service.CdesWebConfigService;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.DocumentNumberPartDAO;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.MasterDataSetDAO;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.util.ActionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.ThreadLocalManager;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextServiceImpl
implements ContextService {
    private static final Logger log = LoggerFactory.getLogger(ContextServiceImpl.class);
    private ActionDAO actionDAO;
    private Bundle bundle;
    private CdesWebConfigService cdesWebConfigService;
    private DocumentNumberPartDAO documentNumberPartDAO;
    private DocumentTypeDAO documentTypeDAO;
    private MasterDataSetDAO masterDataSetDAO;
    private NetworkDAO networkDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private PersonVariablesDAO personVariablesDAO;
    private ProjectDAO projectDAO;
    private SubProjectDAO subProjectDAO;
    private UserPolicyStatusChecker userPolicyStatusChecker;
    private PasswordStatusChecker passwordStatusChecker;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setCdesWebConfigService(CdesWebConfigService cdesWebConfigService) {
        this.cdesWebConfigService = cdesWebConfigService;
    }

    public void setDocumentNumberPartDAO(DocumentNumberPartDAO documentNumberPartDAO) {
        this.documentNumberPartDAO = documentNumberPartDAO;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public void setMasterDataSetDAO(MasterDataSetDAO masterDataSetDAO) {
        this.masterDataSetDAO = masterDataSetDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setUserPolicyStatusChecker(UserPolicyStatusChecker userPolicyStatusChecker) {
        this.userPolicyStatusChecker = userPolicyStatusChecker;
    }

    public void setPasswordStatusChecker(PasswordStatusChecker passwordStatusChecker) {
        this.passwordStatusChecker = passwordStatusChecker;
    }

    public PageContext getPageContext(Long networkId, Long projectId, Long subProjectId, Long pnNetworkId, Long pnProjectId, Long organisationPersonId) {
        PageContext pageContext = new PageContext();
        ArrayList<Long> networkIds = new ArrayList<Long>();
        if (networkId != null) {
            networkIds.add(networkId);
        }
        if (pnNetworkId != null) {
            networkIds.add(pnNetworkId);
        }
        List networks = this.networkDAO.getBatch(networkIds);
        for (Network network : networks) {
            if (network.getId().equals(networkId)) {
                pageContext.setNetwork(network);
            }
            if (!network.getId().equals(pnNetworkId)) continue;
            pageContext.setPlanningNotificationNetwork(network);
        }
        if (pageContext.getNetwork() == null) {
            projectId = null;
        }
        if (pageContext.getPlanningNotificationNetwork() == null) {
            pnProjectId = null;
        }
        if (projectId != null) {
            Project project = null;
            List<ProjectHolidayJoin> projectHolidayJoins = this.projectDAO.getHolidayJoin(projectId);
            ArrayList<ProjectHoliday> projectHolidays = new ArrayList<ProjectHoliday>();
            for (ProjectHolidayJoin projectHolidayJoin : projectHolidayJoins) {
                if (project == null) {
                    project = projectHolidayJoin.getProject();
                }
                if (projectHolidayJoin.getProjectHolidayId() == null) continue;
                projectHolidays.add(projectHolidayJoin.getProjectHoliday());
            }
            if (project != null && project.getNetworkId().longValue() != networkId.longValue()) {
                project = null;
                projectHolidays = null;
            }
            pageContext.setProject(project);
            pageContext.setProjectHolidays(projectHolidays);
        } else {
            pageContext.setProject(null);
            pageContext.setProjectHolidays(new ArrayList());
        }
        if (pnProjectId != null) {
            Project pnProject = (Project)this.projectDAO.get(pnProjectId);
            if (pnProject != null && pnProject.getNetworkId().longValue() != pnNetworkId.longValue()) {
                pnProject = null;
            }
            pageContext.setPlanningNotificationProject(pnProject);
        } else {
            pageContext.setPlanningNotificationProject(null);
        }
        if (pageContext.getProject() == null) {
            subProjectId = null;
        }
        if (subProjectId != null) {
            SubProjectType subProjectType;
            List<SubProjectJoinDto> subProjectJoinDtos = this.subProjectDAO.getSubProjectJoin(subProjectId);
            SubProject subProject = subProjectJoinDtos.size() > 0 ? subProjectJoinDtos.get(0).getSubProject() : null;
            SubProjectType subProjectType2 = subProjectType = subProjectJoinDtos.size() > 0 ? subProjectJoinDtos.get(0).getSubProjectType() : null;
            if (subProject != null && subProject.getProjectId().longValue() != pageContext.getProject().getId().longValue()) {
                subProject = null;
                subProjectType = null;
            }
            pageContext.setSubProject(subProject);
            pageContext.setSubProjectType(subProjectType);
        } else {
            pageContext.setSubProject(null);
            pageContext.setSubProjectType(null);
        }
        List<OrganisationPersonJoin> organisationPersonJoinDtos = this.organisationPersonDAO.getOrganisationPersonJoin(organisationPersonId);
        if (organisationPersonJoinDtos.size() == 0) {
            log.warn("Found no organisationPersonJoin for organisationPersonId = [" + organisationPersonId + "]");
        }
        OrganisationPersonJoin organisationPersonJoinDto = organisationPersonJoinDtos.get(0);
        OrganisationPerson organisationPerson = organisationPersonJoinDto.getOrganisationPerson();
        Organisation organisation = organisationPersonJoinDto.getOrganisation();
        Person person = organisationPersonJoinDto.getPerson();
        pageContext.setOrganisationPerson(organisationPerson);
        pageContext.setOrganisation(organisation);
        pageContext.setPerson(person);
        pageContext.setPersonVariablesUserLocale(organisationPersonJoinDto.getPersonVariablesUserLocale());
        long beforeMillis = System.currentTimeMillis();
        Map<Action, ActionInfo> actionsForProject = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, new Action[0]);
        pageContext.setActionsAllowedForProject(ActionHelper.convertEnumToActionInfoToString(actionsForProject));
        if (log.isDebugEnabled()) {
            long afterMillis = System.currentTimeMillis();
            log.debug("Queries " + actionsForProject.size() + " allowed actions for orgPerson [" + organisationPersonId + "] and project [" + projectId + "] in " + (afterMillis - beforeMillis) + "ms");
        }
        Long gridCellLimit = this.cdesWebConfigService.getGridCellLimit();
        pageContext.setGridCellLimit(gridCellLimit);
        pageContext.setCdesDojoImplBundleVersion(this.bundle.getVersion().toString());
        pageContext.setPasswordExpired(Boolean.valueOf(this.passwordStatusChecker.checkPasswordStatus(person.getId(), null) != PasswordStatus.VALID));
        pageContext.setUserPolicyExpired(Boolean.valueOf(this.userPolicyStatusChecker.checkStatus(person.getId()) != UserPolicyStatus.UP_TO_DATE));
        return pageContext;
    }

    public Network getNetwork(Long networkId) {
        return (Network)this.networkDAO.get(networkId);
    }

    public List<DocumentNumberSpecJoinDto> getDocumentNumberSpec(Long documentNumberPartGroupId) {
        List<DocumentNumberSpecJoinDto> dtos = this.documentNumberPartDAO.getDocumentNumberSpecJoin(documentNumberPartGroupId);
        Collections.sort(dtos, new Comparator<DocumentNumberSpecJoinDto>(){

            @Override
            public int compare(DocumentNumberSpecJoinDto dto1, DocumentNumberSpecJoinDto dto2) {
                return dto1.getPartPosition() - dto2.getPartPosition();
            }
        });
        return dtos;
    }

    public List<DocumentType> getAllDocumentTypes() {
        return this.documentTypeDAO.getAll();
    }

    public Map<Long, MasterDataInfo> getMasterData(Long networkId) {
        Object masterData;
        Long masterDataSetId;
        List<MasterDataJoin> masterDataJoins = this.masterDataSetDAO.getMasterData(networkId);
        HashMap<Long, MasterDataInfo> masterDataInfos = new HashMap<Long, MasterDataInfo>();
        for (MasterDataJoin masterDataJoin : masterDataJoins) {
            if (masterDataInfos.containsKey(masterDataJoin.getMasterDataSetId())) continue;
            MasterDataInfo masterDataInfo = new MasterDataInfo();
            masterDataInfo.setGroupIdToDocumentNumberGroup(new HashMap());
            masterDataInfo.setGroupIdToDocumentNumberParts(new HashMap());
            masterDataInfo.setIdToDocumentType(new HashMap());
            masterDataInfo.setIdToDocumentTypeChildren(new HashMap());
            masterDataInfo.setIdToObjectType(new HashMap());
            masterDataInfo.setIdToSubProjectType(new HashMap());
            masterDataInfo.setMasterDataSet(masterDataJoin.getMasterDataSet());
            masterDataInfos.put(masterDataJoin.getMasterDataSetId(), masterDataInfo);
        }
        for (MasterDataJoin masterDataJoin : masterDataJoins) {
            Long masterDataSetId2;
            MasterDataInfo masterData2;
            Map groupIdToDocumentNumberGroup;
            Long groupId = masterDataJoin.getDocumentNumberGroupId();
            if (groupId == null || (groupIdToDocumentNumberGroup = (masterData2 = (MasterDataInfo)masterDataInfos.get(masterDataSetId2 = masterDataJoin.getMasterDataSetId())).getGroupIdToDocumentNumberGroup()).containsKey(groupId)) continue;
            groupIdToDocumentNumberGroup.put(groupId, masterDataJoin.getDocumentNumberGroup());
            masterData2.getGroupIdToDocumentNumberParts().put(groupId, new ArrayList());
        }
        for (MasterDataJoin masterDataJoin : masterDataJoins) {
            if (masterDataJoin.getDocumentNumberPartId() == null) continue;
            masterDataSetId = masterDataJoin.getMasterDataSetId();
            masterData = (MasterDataInfo)masterDataInfos.get(masterDataSetId);
            Long groupId = masterDataJoin.getDocumentNumberGroupId();
            ((List)masterData.getGroupIdToDocumentNumberParts().get(groupId)).add(masterDataJoin.getDocumentNumberPart());
        }
        for (MasterDataInfo masterData3 : masterDataInfos.values()) {
            Map groupIdToNumberParts = masterData3.getGroupIdToDocumentNumberParts();
            for (Long groupId : groupIdToNumberParts.keySet()) {
                List parts = (List)groupIdToNumberParts.get(groupId);
                Collections.sort(parts, new Comparator<DocumentNumberPart>(){

                    @Override
                    public int compare(DocumentNumberPart partOne, DocumentNumberPart partTwo) {
                        if (partOne.getPosition() == null) {
                            return -1;
                        }
                        if (partTwo.getPosition() == null) {
                            return 1;
                        }
                        return partOne.getPosition() - partTwo.getPosition();
                    }
                });
            }
        }
        for (MasterDataJoin masterDataJoin : masterDataJoins) {
            Long subProjectTypeId;
            Long objectTypeId;
            Long documentTypeGroupId;
            masterDataSetId = masterDataJoin.getMasterDataSetId();
            masterData = (MasterDataInfo)masterDataInfos.get(masterDataSetId);
            Long documentTypeId = masterDataJoin.getDocumentTypeId();
            if (documentTypeId != null) {
                masterData.getIdToDocumentType().put(documentTypeId, masterDataJoin.getDocumentType());
            }
            if ((documentTypeGroupId = masterDataJoin.getDocumentTypeDocumentTypeGroupId()) != null) {
                Map idToDocumentTypeChildren = masterData.getIdToDocumentTypeChildren();
                if (!idToDocumentTypeChildren.containsKey(documentTypeGroupId)) {
                    idToDocumentTypeChildren.put(documentTypeGroupId, new ArrayList());
                }
                ((List)idToDocumentTypeChildren.get(documentTypeGroupId)).add(masterDataJoin.getDocumentType());
            }
            if ((objectTypeId = masterDataJoin.getObjectTypeId()) != null) {
                masterData.getIdToObjectType().put(objectTypeId, masterDataJoin.getObjectType());
            }
            if ((subProjectTypeId = masterDataJoin.getSubProjectTypeId()) == null) continue;
            masterData.getIdToSubProjectType().put(subProjectTypeId, masterDataJoin.getSubProjectType());
        }
        return masterDataInfos;
    }

    public VersionInfo getVersionInfo() {
        VersionInfo versionInfo = new VersionInfo();
        versionInfo.setBundleVersion(this.bundle.getVersion().toString());
        String buildTimeHeader = (String)this.bundle.getHeaders().get("X-BuildNumber");
        int slashIndex = buildTimeHeader.indexOf("/");
        String svnVersion = buildTimeHeader.substring(0, slashIndex);
        String buildTimeStamp = buildTimeHeader.substring(slashIndex + 1);
        versionInfo.setSvnVersion(svnVersion);
        versionInfo.setBuildTimeStamp(buildTimeStamp);
        return versionInfo;
    }

    public void setPnNetworkIdToPersonVariables(Long networkId) {
        CdesPrincipal principal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(principal.getPersonId());
        if (personVariablesList.size() != 1) {
            throw new RuntimeException("PersonVariables must exist exactly once, found [" + personVariablesList.size() + "] instances for person [" + principal.getPersonId() + "]");
        }
        PersonVariables personVariables = personVariablesList.get(0);
        log.info("Loaded personVariables, old pnNetworkId = [" + personVariables.getActivePnNetworkId() + "]; new pnNetworkId = [" + networkId + "]; for personId = [" + principal.getPersonId() + "]");
        personVariables.setActivePnNetworkId(networkId);
        personVariables.setPreselectedTab(Integer.valueOf(7));
        this.personVariablesDAO.update(personVariables);
    }
}

