/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.review;

import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.task.dto.Task;
import at.cdes.api.task.voc.TaskSearchMode;
import at.cdes.api.task.voc.TaskStatus;
import at.cdes.api.task.voc.TaskType;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.i18n.I18nHelper;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.w3c.dom.Node;

public class ReviewTaskExportHelper {
    public static FancyOdfTableColumn<Task> constructNameColumn(final ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, final String personVariablesUserLocale) {
        return new FancyOdfTableColumn<Task>("name", resourceBundle.getString("reviewTaskNameColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                String convertedName = this.getStringForFilter(task);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, convertedName);
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, I18nHelper.getLocaleStringFromDatabase(taskOne.getName(), personVariablesUserLocale), I18nHelper.getLocaleStringFromDatabase(taskTwo.getName(), personVariablesUserLocale), descending);
            }

            private String getStringForFilter(Task task) {
                TaskType taskType = task.getTaskType();
                if (taskType == TaskType.SELECT_CELL_CONNECTION_TASK) {
                    return resourceBundle.getString("reviewTaskTaskRevision");
                }
                return I18nHelper.getLocaleStringFromDatabase(task.getName(), personVariablesUserLocale);
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructDocumentColumn(final ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>("document", resourceBundle.getString("reviewTaskDocumentColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                TaskType taskType = task.getTaskType();
                if (taskType == TaskType.PLOT_ORDER_ACCEPTANCE_TASK || taskType == TaskType.REVIEW_CYCLE_PLOT_TASK) {
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, resourceBundle.getString("plotOrderListJobNumberCaption") + ":\n" + task.getPlotOrderJobNumber());
                } else {
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, task.getDocumentName() + "\n" + task.getDocumentContent());
                }
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                String s1 = taskOne.getDocumentName() + taskOne.getDocumentContent();
                String s2 = taskTwo.getDocumentName() + taskTwo.getDocumentContent();
                return CompareHelper.defaultStringCompare(collator, s1, s2, descending);
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructResponsibleColumn(final ResourceBundle resourceBundle, final Collator collator, Long loginPersonId, OrganisationPersonJoin organisationPersonJoin, final TaskSearchMode searchMode, final String dataCellStyle, final String dataTextStyle) {
        String columnHeader = searchMode == TaskSearchMode.DONE ? resourceBundle.getString("reviewTaskResponsibleDONEColumnCaption") : resourceBundle.getString("reviewTaskResponsibleColumnCaption");
        return new FancyOdfTableColumn<Task>("responsible", columnHeader){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getContent(task));
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getContent(taskOne), this.getContent(taskTwo), descending);
            }

            private String getContent(Task task) {
                String mainPersonString = PersonHelper.getCommonNameAndOrganisation(task.getMainParticipantOrganisation(), task.getMainParticipantPerson());
                if (searchMode != TaskSearchMode.DONE) {
                    return mainPersonString;
                }
                String ownPersonString = PersonHelper.getCommonNameAndOrganisation(task.getSignerOrganisation(), task.getSignerPerson());
                String pattern = resourceBundle.getString("reviewTaskForeignResponsibleDONEString");
                return MessageFormat.format(pattern, mainPersonString, ownPersonString);
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructObjectColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>("object", resourceBundle.getString("reviewTaskObjectColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, task.getObjectCode() + "\n" + task.getObjectName());
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                String s1 = taskOne.getObjectCode() + taskOne.getObjectName();
                String s2 = taskTwo.getObjectCode() + taskTwo.getObjectName();
                return CompareHelper.defaultStringCompare(collator, s1, s2, descending);
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructProjectColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>("project", resourceBundle.getString("reviewTaskProjectColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, task.getProjectCode() + "\n" + task.getProjectName());
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                String s1 = taskOne.getProjectCode() + taskOne.getProjectName();
                String s2 = taskTwo.getProjectCode() + taskTwo.getProjectName();
                return CompareHelper.defaultStringCompare(collator, s1, s2, descending);
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructNetworkColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>("network", resourceBundle.getString("reviewTaskNetworkColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, task.getNetworkName());
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                String s1 = taskOne.getNetworkName();
                String s2 = taskTwo.getNetworkName();
                return CompareHelper.defaultStringCompare(collator, s1, s2, descending);
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructTaskStatusColumn(ResourceBundle resourceBundle, Collator collator, TaskSearchMode searchMode, String dataCellStyle, String dataTextStyle) {
        return ReviewTaskExportHelper.constructTaskStatusColumn(resourceBundle, collator, searchMode, "taskStatus", resourceBundle.getString("reviewTaskTaskStatusColumnCaption"), true, true, dataCellStyle, dataTextStyle);
    }

    public static FancyOdfTableColumn<Task> constructTaskStatusColumn(final ResourceBundle resourceBundle, Collator collator, final TaskSearchMode searchMode, String id, String caption, final boolean outputStatus, final boolean outputDeadline, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>(id, caption){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                Long taskDelay = task.getTaskDelay();
                if (taskDelay != null) {
                    if (outputStatus) {
                        String formattedTaskDelay = ReviewTaskExportHelper.formatTaskDelay(resourceBundle, taskDelay);
                        TextFactory.constructTextNode((Node)cellElement, (String)formattedTaskDelay, (String)dataTextStyle);
                        if (searchMode != TaskSearchMode.LATE && task.getTaskType() == TaskType.REVIEW_TASK && task.getTaskStatus() == TaskStatus.IN_SIGNATURE_FOLDER.getValue()) {
                            TextFactory.constructTextNode((Node)cellElement, (String)resourceBundle.getString("reviewTaskInSignatureFolder"), (String)dataTextStyle);
                        }
                    }
                    if (outputDeadline && task.getEndDate() != null) {
                        String deadlineString = DateHelper.formatUtcSeconds(task.getEndDate(), "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
                        String formattedDeadline = outputStatus ? MessageFormat.format(resourceBundle.getString("reviewTaskDeadline"), deadlineString) : deadlineString;
                        TextFactory.constructTextNode((Node)cellElement, (String)formattedDeadline, (String)dataTextStyle);
                    }
                }
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                long taskDelayTwo;
                long taskDelayOne = taskOne.getTaskDelay() != null ? taskOne.getTaskDelay() : 0L;
                long l = taskDelayTwo = taskTwo.getTaskDelay() != null ? taskTwo.getTaskDelay() : 0L;
                if (taskDelayOne < taskDelayTwo) {
                    return -1;
                }
                if (taskDelayOne > taskDelayTwo) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructUploadedColumn(final ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>("uploaded", resourceBundle.getString("reviewTaskUploadedColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getContent(task));
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getContent(taskOne), this.getContent(taskTwo), descending);
            }

            private String getContent(Task task) {
                Double uploaded = task.getUploadedDate();
                if (uploaded != null) {
                    return DateHelper.formatUtcSeconds(uploaded, "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
                }
                return "";
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructDoneDateColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>("doneDate", resourceBundle.getString("reviewTaskDoneDateColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getContent(task));
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                Double doneDateOne = taskOne.getDoneDate();
                Double doneDateTwo = taskTwo.getDoneDate();
                return CompareHelper.defaultDoubleCompare(doneDateOne, doneDateTwo, descending);
            }

            private String getContent(Task task) {
                Double doneDate = task.getDoneDate();
                if (doneDate != null) {
                    return DateHelper.formatUtcSeconds(doneDate, "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
                }
                return "";
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructDoneResultColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, final String personVariablesUserLocale) {
        return new FancyOdfTableColumn<Task>("doneResult", resourceBundle.getString("reviewTaskResultColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                if (task.getTaskType() == TaskType.REVIEW_TASK_DONE || task.getTaskType() == TaskType.REVIEW_CYCLE_ENTRY_TASK_DONE) {
                    String rawRealmCode = I18nHelper.getLocaleStringFromDatabase(task.getRealmCode(), personVariablesUserLocale);
                    String rawRealmName = I18nHelper.getLocaleStringFromDatabase(task.getRealmName(), personVariablesUserLocale);
                    String rawResultOptionName = I18nHelper.getLocaleStringFromDatabase(task.getResultOptionName(), personVariablesUserLocale);
                    String realmCode = rawRealmCode != null ? rawRealmCode : "";
                    String realmName = rawRealmName != null ? rawRealmName : "";
                    String resultOptionName = rawResultOptionName != null ? rawResultOptionName : "";
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                    TextFactory.constructTextNode((Node)cellElement, (String)(realmCode + " " + realmName), (String)dataTextStyle);
                    TextFactory.constructTextNode((Node)cellElement, (String)resultOptionName, (String)dataTextStyle);
                } else {
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                    TextFactory.constructTextNode((Node)cellElement, (String)"", (String)dataTextStyle);
                }
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getCompareString(taskOne), this.getCompareString(taskTwo), descending);
            }

            private String getCompareString(Task task) {
                String rawRealmCode = I18nHelper.getLocaleStringFromDatabase(task.getRealmCode(), personVariablesUserLocale);
                String rawRealmName = I18nHelper.getLocaleStringFromDatabase(task.getRealmName(), personVariablesUserLocale);
                String rawResultOptionName = I18nHelper.getLocaleStringFromDatabase(task.getResultOptionName(), personVariablesUserLocale);
                String realmCode = rawRealmCode != null ? rawRealmCode : "";
                String realmName = rawRealmName != null ? rawRealmName : "";
                String resultOptionName = rawResultOptionName != null ? rawResultOptionName : "";
                return realmCode + realmName + resultOptionName;
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructReviewStatusColumn(ResourceBundle resourceBundle, Collator collator, String dataCellStyle, String dataTextStyle) {
        return ReviewTaskExportHelper.constructReviewStatusColumn(resourceBundle, collator, "reviewStatus", resourceBundle.getString("reviewTaskReviewStatusColumnCaption"), true, true, dataCellStyle, dataTextStyle);
    }

    public static FancyOdfTableColumn<Task> constructReviewStatusColumn(final ResourceBundle resourceBundle, Collator collator, String id, String caption, final boolean outputStatus, final boolean outputDeadline, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>(id, caption){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                Long reviewCycleDelay = task.getReviewCycleDelay();
                if (reviewCycleDelay != null) {
                    if (outputStatus) {
                        String formattedReviewCycleDelay = ReviewTaskExportHelper.formatTaskDelay(resourceBundle, reviewCycleDelay);
                        TextFactory.constructTextNode((Node)cellElement, (String)formattedReviewCycleDelay, (String)dataTextStyle);
                    }
                    if (outputDeadline) {
                        String rawPattern;
                        if (task.getDocumentEndDate() != null) {
                            rawPattern = resourceBundle.getString("reviewTaskContractualDeadline");
                            String deadlineString = DateHelper.formatUtcSeconds(task.getDocumentEndDate(), "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
                            String formattedString = MessageFormat.format(rawPattern, deadlineString);
                            TextFactory.constructTextNode((Node)cellElement, (String)formattedString, (String)dataTextStyle);
                        } else if (task.getOverallEndDate() != null) {
                            rawPattern = resourceBundle.getString("reviewTaskComputedDeadline");
                            String deadlineString = DateHelper.formatUtcSeconds(task.getOverallEndDate(), "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
                            String formattedString = outputStatus ? MessageFormat.format(rawPattern, deadlineString) : deadlineString;
                            TextFactory.constructTextNode((Node)cellElement, (String)formattedString, (String)dataTextStyle);
                        }
                    }
                }
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                long taskDelayTwo;
                long taskDelayOne = taskOne.getReviewCycleDelay() != null ? taskOne.getReviewCycleDelay() : 0L;
                long l = taskDelayTwo = taskTwo.getReviewCycleDelay() != null ? taskTwo.getReviewCycleDelay() : 0L;
                if (taskDelayOne < taskDelayTwo) {
                    return -1;
                }
                if (taskDelayOne > taskDelayTwo) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructReviewDateColumn(final ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<Task>("reviewDate", resourceBundle.getString("reviewTaskReviewDateColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getContent(task));
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getContent(taskOne), this.getContent(taskTwo), descending);
            }

            private String getContent(Task task) {
                Double reviewDate = task.getReviewDate();
                if (reviewDate != null) {
                    return DateHelper.formatUtcSeconds(reviewDate, "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
                }
                return "";
            }
        };
    }

    public static FancyOdfTableColumn<Task> constructReviewResultColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, final String personVariablesUserLocale) {
        return new FancyOdfTableColumn<Task>("reviewResult", resourceBundle.getString("reviewTaskResultColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, Task task) {
                String rawRealmCode = I18nHelper.getLocaleStringFromDatabase(task.getRealmCode(), personVariablesUserLocale);
                String rawRealmName = I18nHelper.getLocaleStringFromDatabase(task.getRealmName(), personVariablesUserLocale);
                String rawResultOptionName = I18nHelper.getLocaleStringFromDatabase(task.getResultOptionName(), personVariablesUserLocale);
                String realmCode = rawRealmCode != null ? rawRealmCode : "";
                String realmName = rawRealmName != null ? rawRealmName : "";
                String resultOptionName = rawResultOptionName != null ? rawResultOptionName : "";
                String organisationName = task.getPositionResultOrganisationName();
                String personGivenName = task.getPositionResultPersonGivenName();
                String personSurName = task.getPositionResultPersonSurName();
                String reviewerString = personGivenName + " " + personSurName + " (" + organisationName + ")";
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                TextFactory.constructTextNode((Node)cellElement, (String)(realmCode + " " + realmName), (String)dataTextStyle);
                TextFactory.constructTextNode((Node)cellElement, (String)resultOptionName, (String)dataTextStyle);
                TextFactory.constructTextNode((Node)cellElement, (String)reviewerString, (String)dataTextStyle);
            }

            public int compare(Task taskOne, Task taskTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getCompareString(taskOne), this.getCompareString(taskTwo), descending);
            }

            private String getCompareString(Task task) {
                String rawRealmCode = I18nHelper.getLocaleStringFromDatabase(task.getRealmCode(), personVariablesUserLocale);
                String rawRealmName = I18nHelper.getLocaleStringFromDatabase(task.getRealmName(), personVariablesUserLocale);
                String rawResultOptionName = I18nHelper.getLocaleStringFromDatabase(task.getResultOptionName(), personVariablesUserLocale);
                String realmCode = rawRealmCode != null ? rawRealmCode : "";
                String realmName = rawRealmName != null ? rawRealmName : "";
                String resultOptionName = rawResultOptionName != null ? rawResultOptionName : "";
                return realmCode + realmName + resultOptionName;
            }
        };
    }

    private static String formatTaskDelay(ResourceBundle resourceBundle, Long taskDelay) {
        if (taskDelay == 0L) {
            return resourceBundle.getString("reviewTaskDelayToday");
        }
        if (taskDelay == 1L) {
            return resourceBundle.getString("reviewTaskDelayYesterday");
        }
        if (taskDelay == -1L) {
            return resourceBundle.getString("reviewTaskDelayTomorrow");
        }
        if (taskDelay > 1L) {
            return MessageFormat.format(resourceBundle.getString("reviewTaskDelayPast"), taskDelay.toString());
        }
        return MessageFormat.format(resourceBundle.getString("reviewTaskDelayFuture"), Math.abs(taskDelay)).toString();
    }
}

