/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import at.cdes.api.voc.PaperFormat;
import at.cdes.api.voc.PaperOrientation;

public class UnitHelper {
    public static double convertPtToMM(double pt) {
        return pt * 0.35277777777777775;
    }

    public static double convertMMToPt(double mm) {
        return mm / 0.35277777777777775;
    }

    public static double convertRadiansToDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    public static double convertDegreesToRadians(double degrees) {
        return degrees / 57.29577951308232;
    }

    public static double getPaperFormatMArea(String paperFormatName) {
        PaperFormat paperFormat = PaperFormat.getByName((String)paperFormatName);
        return UnitHelper.getPaperFormatMArea(paperFormat);
    }

    public static double getPaperFormatMArea(PaperFormat paperFormat) {
        return paperFormat.getMmHeight() / 1000.0 * (paperFormat.getMmWidth() / 1000.0);
    }

    public static double getPaperFormatMMWidth(PaperFormat paperFormat, PaperOrientation orientation) {
        if (orientation == PaperOrientation.LANDSCAPE) {
            return paperFormat.getMmHeight();
        }
        if (orientation == PaperOrientation.PORTRAIT) {
            return paperFormat.getMmWidth();
        }
        throw new IllegalArgumentException("Illegal paper orientation: " + orientation);
    }

    public static double getPaperFormatMMHeight(PaperFormat paperFormat, PaperOrientation orientation) {
        if (orientation == PaperOrientation.LANDSCAPE) {
            return paperFormat.getMmWidth();
        }
        if (orientation == PaperOrientation.PORTRAIT) {
            return paperFormat.getMmHeight();
        }
        throw new IllegalArgumentException("Illegal paper orientation: " + orientation);
    }

    public static double getPaperFormatPtWidth(PaperFormat paperFormat, PaperOrientation orientation) {
        if (orientation == PaperOrientation.LANDSCAPE) {
            return paperFormat.getPtHeight();
        }
        if (orientation == PaperOrientation.PORTRAIT) {
            return paperFormat.getPtWidth();
        }
        throw new IllegalArgumentException("Illegal paper orientation: " + orientation);
    }

    public static double getPaperFormatPtHeight(PaperFormat paperFormat, PaperOrientation orientation) {
        if (orientation == PaperOrientation.LANDSCAPE) {
            return paperFormat.getPtWidth();
        }
        if (orientation == PaperOrientation.PORTRAIT) {
            return paperFormat.getPtHeight();
        }
        throw new IllegalArgumentException("Illegal paper orientation: " + orientation);
    }
}

