/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.WorkflowNodePosition;
import at.cdes.api.dto.WorkflowToken;
import at.cdes.impl.dao.GenWorkflowTokenDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcWorkflowTokenDAO
extends AbstrIdDAO<WorkflowToken>
implements GenWorkflowTokenDAO {
    public AbstractJdbcWorkflowTokenDAO() {
        super(WorkflowToken.class, "id", "workflow_token", new String[]{"id", "initiator_position_id", "owner_position_id", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcWorkflowTokenDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "initiator_position_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "owner_position_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcWorkflowTokenDAO.getSelectClauseForDto("workflow_token", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcWorkflowTokenDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".initiator_position_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "initiator_position_id") + "," + entityLocalName + ".owner_position_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "owner_position_id") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected WorkflowToken fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        WorkflowToken workflowToken = new WorkflowToken();
        workflowToken.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowToken.setInitiatorPositionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowToken.setOwnerPositionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowToken.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowToken.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowToken.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return workflowToken;
    }

    public static WorkflowToken fillWorkflowTokenFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        WorkflowToken workflowToken = new WorkflowToken();
        workflowToken.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowToken.setInitiatorPositionId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowToken.setOwnerPositionId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowToken.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowToken.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowToken.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return workflowToken;
    }

    public static WorkflowToken fillWorkflowTokenFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcWorkflowTokenDAO.fillWorkflowTokenFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 6;
    }

    public int update(WorkflowToken dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<WorkflowToken> dtos) {
        Iterator<WorkflowToken> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, WorkflowToken workflowToken) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)workflowToken.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)workflowToken.getInitiatorPositionId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)workflowToken.getOwnerPositionId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)(workflowToken.getCreateTrx() != null ? workflowToken.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)System.currentTimeMillis());
    }

    @Override
    public List<WorkflowToken> getByInitiatorPosition(WorkflowNodePosition workflowNodePosition) {
        return this.getByInitiatorPosition(workflowNodePosition.getId());
    }

    @Override
    public List<WorkflowToken> getByInitiatorPosition(final Long workflowNodePositionId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"initiator_position_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, workflowNodePositionId);
            }
        });
    }

    @Override
    public List<WorkflowToken> getByOwnerPosition(WorkflowNodePosition workflowNodePosition) {
        return this.getByOwnerPosition(workflowNodePosition.getId());
    }

    @Override
    public List<WorkflowToken> getByOwnerPosition(final Long workflowNodePositionId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"owner_position_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, workflowNodePositionId);
            }
        });
    }

    @Override
    public List<WorkflowToken> getByInitiatorPositions(Collection<Long> workflowNodePositionId) {
        if (workflowNodePositionId.isEmpty()) {
            return new ArrayList<WorkflowToken>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[workflowNodePositionId.size()];
        int n = 0;
        Iterator<Long> it = workflowNodePositionId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"initiator_position_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<WorkflowToken> getByOwnerPositions(Collection<Long> workflowNodePositionId) {
        if (workflowNodePositionId.isEmpty()) {
            return new ArrayList<WorkflowToken>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[workflowNodePositionId.size()];
        int n = 0;
        Iterator<Long> it = workflowNodePositionId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"owner_position_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

