/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec.login;

import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.dto.Person;
import at.cdes.api.sec.CdesChallengeLoginPrincipal;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.PersonDAO;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.sec.DomainGroup;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.DomainPrincipal;

public class ChallengeLoginService
implements DomainPasswordLoginService {
    private CertificateRequestDAO certificateRequestDAO;
    private PersonDAO personDAO;

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public int getSupportedFeatures(String domain) {
        return 0;
    }

    public String getDefaultDomain() {
        return "CDESChallenge";
    }

    public List<String> getDomains() {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("CDESChallenge");
        return domains;
    }

    public DomainPrincipal tryLogin(String domain, String username, String password) {
        if (username == null || password == null) {
            throw new SecurityException("No sufficient login credentials given, challenge1 = [" + username + "], challenge2 = [" + password + "]");
        }
        CertificateRequest certificateRequest = this.certificateRequestDAO.getByChallengeLoginOne(username);
        if (certificateRequest == null) {
            throw new SecurityException("No CertificateRequest with challenge1 = [" + username + "] found.");
        }
        if (!password.equals(certificateRequest.getChallenge2())) {
            throw new SecurityException("Given challenge2 = [" + password + "] does not match expected challenge2 = [" + certificateRequest.getChallenge2() + "], for challenge1 = [" + username + "]");
        }
        Person person = this.personDAO.getPersonByChallengeLoginOne(username);
        if (person == null) {
            throw new SecurityException("No person for challenge1 = [" + username + "] could be found.");
        }
        return new CdesChallengeLoginPrincipal(username, person.getGivenName() + " " + person.getSurName());
    }

    public void changePassword(String domain, String username, String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public void sendPassword(String domain, String username) {
        throw new UnsupportedOperationException();
    }

    public DomainPrincipal searchUser(String domain, String username) {
        throw new UnsupportedOperationException();
    }

    public void deactivateUser(String domain, String username, String reason) {
        throw new UnsupportedOperationException();
    }

    public List<DomainGroup> getGroups(String domain, String userName) {
        throw new UnsupportedOperationException();
    }

    public List<DomainPrincipal> getGroupMembers(String domain, String groupName) {
        throw new UnsupportedOperationException();
    }
}

