/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentList;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.SubProject;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.GenSelectCellTaskConnectionJoin;
import at.cdes.api.joinDto.GenSelectCellTaskVersionJoin;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentListDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ReviewCycleCellDAO;
import at.cdes.impl.dao.ReviewCycleNodeDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleResultOptionDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.reviewCycle.ReviewCycleHelper;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewOgnlHelper {
    private DocumentDAO documentDAO;
    private DocumentVersionDAO documentVersionDAO;
    private DocumentListDAO documentListDAO;
    private SubProjectDAO subProjectDAO;
    private ProjectDAO projectDAO;
    private ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO;
    private ReviewCycleNodeDAO reviewCycleNodeDAO;
    private ReviewCycleCellDAO reviewCycleCellDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private static final Logger log = LoggerFactory.getLogger(ReviewOgnlHelper.class);

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setReviewCycleNodeInstanceReleasedDAO(ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO) {
        this.reviewCycleNodeInstanceReleasedDAO = reviewCycleNodeInstanceReleasedDAO;
    }

    public void setReviewCycleNodeDAO(ReviewCycleNodeDAO reviewCycleNodeDAO) {
        this.reviewCycleNodeDAO = reviewCycleNodeDAO;
    }

    public void setReviewCycleCellDAO(ReviewCycleCellDAO reviewCycleCellDAO) {
        this.reviewCycleCellDAO = reviewCycleCellDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public boolean verifyReviewCycleNodeSkippingRule(Long reviewCycleNodeInstanceReleasedId, Long documentVersionId, OrganisationPerson asBuiltContractorOrganisationPerson) {
        DocumentVersion dv = (DocumentVersion)this.documentVersionDAO.get(documentVersionId);
        Long dvAsBuiltReferenceId = dv.getAsBuiltReference();
        DocumentVersion asBuiltReference = dvAsBuiltReferenceId != null ? (DocumentVersion)this.documentVersionDAO.get(dvAsBuiltReferenceId) : null;
        ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
        Network network = contextJoin.getNetwork();
        DocumentToNetworkPath documentToNetworkPath = new DocumentToNetworkPath(network.getId());
        OrganisationPerson plannerOrgPerson = this.organisationPersonDAO.getPlannerMainParticipantOrgPersonByDocumentVersionId(documentVersionId);
        ReviewCycleNodeInstanceReleased nodeInstanceRel = (ReviewCycleNodeInstanceReleased)this.reviewCycleNodeInstanceReleasedDAO.get(reviewCycleNodeInstanceReleasedId);
        return this.doVerifyReviewCycleNodeSkippingRule(nodeInstanceRel.getReviewCycleNodeId(), null, dv, asBuiltReference, null, plannerOrgPerson, asBuiltContractorOrganisationPerson, documentToNetworkPath);
    }

    public boolean verifyReviewCycleNodeSkippingRuleForDocument(Long reviewCycleNodeInstanceReleasedId, Long documentId, OrganisationPerson asBuiltContractorOrganisationPerson) {
        OrganisationPerson plannerOrgPerson = this.organisationPersonDAO.getPlannerMainParticipantOrgPersonByDocumentId(documentId);
        Document document = (Document)this.documentDAO.get(documentId);
        ContextJoin contextJoin = this.documentDAO.getContextJoin(documentId);
        Network network = contextJoin.getNetwork();
        DocumentToNetworkPath documentToNetworkPath = new DocumentToNetworkPath(network.getId());
        ReviewCycleNodeInstanceReleased nodeInstanceRel = (ReviewCycleNodeInstanceReleased)this.reviewCycleNodeInstanceReleasedDAO.get(reviewCycleNodeInstanceReleasedId);
        return this.doVerifyReviewCycleNodeSkippingRule(nodeInstanceRel.getReviewCycleNodeId(), null, null, null, document, plannerOrgPerson, asBuiltContractorOrganisationPerson, documentToNetworkPath);
    }

    public boolean verifyReviewCycleNodeSkippingRuleForNode(Long subProjectId, Long reviewCycleNodeId) {
        return this.doVerifyReviewCycleNodeSkippingRule(reviewCycleNodeId, subProjectId, null, null, null, null, null, null);
    }

    private boolean doVerifyReviewCycleNodeSkippingRule(Long nodeId, Long subProjectId, DocumentVersion documentVersion, DocumentVersion asBuiltReference, Document document, OrganisationPerson plannerOrgPerson, OrganisationPerson asBuiltContractorOrganisationPerson, DocumentToNetworkPath documentToNetworkPath) {
        ReviewCycleNode node = (ReviewCycleNode)this.reviewCycleNodeDAO.get(nodeId);
        if (documentVersion != null && document == null) {
            document = (Document)this.documentDAO.get(documentVersion.getDocumentId());
        }
        if (subProjectId == null) {
            DocumentList documentList = (DocumentList)this.documentListDAO.get(document.getDocumentListId());
            subProjectId = documentList.getSubProjectId();
        }
        SubProject subProject = (SubProject)this.subProjectDAO.get(subProjectId);
        Project project = (Project)this.projectDAO.get(subProject.getProjectId());
        String ognlRule = node.getSkippingRule();
        if (ognlRule == null || ognlRule.isEmpty() || ognlRule.trim().isEmpty()) {
            return false;
        }
        ognlRule = "#key=\"moveNode\", #key=\"showNode\", " + ognlRule;
        try {
            Object expression = Ognl.parseExpression(ognlRule);
        }
        catch (OgnlException e) {
            throw new RuntimeException("Ognl parse error in expression [" + ognlRule + "]", e);
        }
        OgnlContext context = new OgnlContext();
        ognlRule = ognlRule.replaceAll("documentVersion\\.document\\.documentList\\.subProject\\.project", "project");
        ognlRule = ognlRule.replaceAll("documentVersion\\.document\\.documentList\\.subProject", "subProject");
        if (documentVersion == null && document != null) {
            ognlRule = ognlRule.replaceAll("document\\.documentList\\.subProject\\.project", "project");
            ognlRule = ognlRule.replaceAll("document\\.documentList\\.subProject", "subProject");
        }
        context.put("project", project);
        context.put("documentVersion", documentVersion);
        context.put("document", document);
        context.put("asBuiltReference", asBuiltReference);
        context.put("plannerOrgPerson", plannerOrgPerson);
        context.put("asBuiltContractorOrgPerson", asBuiltContractorOrganisationPerson);
        Boolean result = ReviewCycleHelper.evaluateBooleanOgnlRule(ognlRule, context, true);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean verifyCellConnectionRule(GenSelectCellTaskVersionJoin versionJoin, GenSelectCellTaskConnectionJoin connectionJoin) {
        String ognlRule = connectionJoin.getReviewCycleCellConnectionOgnlRule();
        if (ognlRule == null || ognlRule.isEmpty() || ognlRule.trim().isEmpty()) {
            return false;
        }
        ognlRule = this.replaceIdentifiersInCellConnectionRule(ognlRule, versionJoin);
        return this.doVerifyCellConnectionRule(ognlRule);
    }

    private boolean doVerifyCellConnectionRule(String ognlRule) {
        try {
            Object result = Ognl.getValue(ognlRule, null);
            return Boolean.parseBoolean(String.valueOf(result));
        }
        catch (OgnlException e) {
            throw new RuntimeException(e);
        }
    }

    private String replaceIdentifiersInCellConnectionRule(String ognlRule, GenSelectCellTaskVersionJoin versionJoin) {
        Integer reviewCycleResultOptionValue = versionJoin.getReviewCycleResultOptionValue() != null ? versionJoin.getReviewCycleResultOptionValue() : -1003;
        ognlRule = ognlRule.replace("sourceResult.reviewCycleResultOption.value", String.valueOf(reviewCycleResultOptionValue));
        ognlRule = ognlRule.replace("sourceResult.reviewCycleResultOption != null", Boolean.valueOf(versionJoin.getReviewCycleResultOptionId() != null).toString());
        Integer resultOptionFiveValue = versionJoin.getNodeResultOptionFiveValue() != null ? versionJoin.getNodeResultOptionFiveValue() : -1002;
        ognlRule = ognlRule.replace("sourceResult.getNodeResultByPosition(5).reviewCycleResultOption.value", String.valueOf(resultOptionFiveValue));
        ognlRule = ognlRule.replace("sourceResult.getNodeResultByPosition(5)!=null", Boolean.valueOf(versionJoin.getNodeResultOptionFiveId() != null).toString());
        Long reviewCycleResultOptionId = versionJoin.getReviewCycleResultOptionId() != null ? versionJoin.getReviewCycleResultOptionId() : -1001L;
        if ((ognlRule = ognlRule.replace("sourceResult.reviewCycleResultOption.id", String.valueOf(reviewCycleResultOptionId))).contains("sourceResult")) {
            throw new IllegalArgumentException("Found unexpected content in ognlRule --- all sourceResult occurrences should be replaced at this point.");
        }
        ognlRule = ognlRule.replace("documentVersion.id", String.valueOf(versionJoin.getDocumentVersionId()));
        Long allowedResultOptionId = versionJoin.getProjectAllowedResultOptionId() != null ? versionJoin.getProjectAllowedResultOptionId() : -1000L;
        ognlRule = ognlRule.replace("documentVersion.document.documentList.subProject.project.allowedFinalReviewCycleResultOption.id", String.valueOf(allowedResultOptionId));
        if ((ognlRule = ognlRule.replace("documentVersion.document.documentList.subProject.project.allowedFinalReviewCycleResultOption !=null", Boolean.valueOf(versionJoin.getProjectAllowedResultOptionId() != null).toString())).contains("documentVersion")) {
            throw new IllegalArgumentException("Found unexpected content in ognlRule --- all documentVersion occurrences should be replaced at this point.");
        }
        return ognlRule;
    }

    public boolean verifyCellConnectionRule(ReviewCycleCellResult reviewCycleCellResult, ReviewCycleCellConnection reviewCycleCellConnection) {
        String ognlRule = reviewCycleCellConnection.getOgnlRule();
        if (ognlRule == null || ognlRule.isEmpty() || ognlRule.trim().isEmpty()) {
            return false;
        }
        return this.doVerifyCellConnectionRuleByObjects(ognlRule, reviewCycleCellResult, reviewCycleCellConnection);
    }

    private boolean doVerifyCellConnectionRuleByObjects(String ognlRule, ReviewCycleCellResult reviewCycleCellResult, ReviewCycleCellConnection reviewCycleCellConnection) {
        Object expression;
        try {
            expression = Ognl.parseExpression(ognlRule);
        }
        catch (OgnlException e) {
            throw new RuntimeException("Ognl parse error in expression [" + ognlRule + "]", e);
        }
        OgnlContext context = new OgnlContext();
        Long cellId = reviewCycleCellResult.getReviewCycleCellId();
        DocumentVersion documentVersion = (DocumentVersion)this.documentVersionDAO.get(reviewCycleCellResult.getDocumentVersionId());
        Boolean cellResultFinished = reviewCycleCellResult.getFinished();
        ReviewCycleResultOption resultOption = (ReviewCycleResultOption)this.reviewCycleResultOptionDAO.get(reviewCycleCellResult.getReviewCycleResultOptionId());
        Long sourceCellId = reviewCycleCellResult.getPreviousReviewCycleCellId();
        ReviewCycleCell sourceCell = (ReviewCycleCell)this.reviewCycleCellDAO.get(sourceCellId);
        Long destinationCellId = reviewCycleCellResult.getNextReviewCycleCellId();
        ReviewCycleCell destinationCell = (ReviewCycleCell)this.reviewCycleCellDAO.get(destinationCellId);
        ognlRule = ognlRule.replaceAll("sourceResult\\.reviewCycleResultOption", "resultOption");
        ognlRule = ognlRule.replaceAll("sourceResult\\.getNodeResultByPosition\\.reviewCycleResultOption", "nodeResultResultOption");
        context.put("sourceResult", reviewCycleCellResult);
        context.put("documentVersion", documentVersion);
        context.put("connection", reviewCycleCellConnection);
        context.put("sourceCell", sourceCell);
        context.put("destinationCell", destinationCell);
        context.put("resultOption", resultOption);
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("OGNL evaluation: expression [" + ognlRule + "], res [" + res + "].");
            }
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            throw new RuntimeException("OGNL evaluation error in expression [" + ognlRule + "]", e);
        }
    }

    private static class NetworkPath {
        private Long id;

        NetworkPath(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }
    }

    private static class ProjectToNetworkPath {
        private NetworkPath networkPath;

        ProjectToNetworkPath(Long networkId) {
            this.networkPath = new NetworkPath(networkId);
        }

        public NetworkPath getNetwork() {
            return this.networkPath;
        }
    }

    private static class SubProjectToNetworkPath {
        private ProjectToNetworkPath projectToNetworkPath;

        SubProjectToNetworkPath(Long networkId) {
            this.projectToNetworkPath = new ProjectToNetworkPath(networkId);
        }

        public ProjectToNetworkPath getProject() {
            return this.projectToNetworkPath;
        }
    }

    private static class DocumentListToNetworkPath {
        private SubProjectToNetworkPath subProjectToNetworkPath;

        DocumentListToNetworkPath(Long networkId) {
            this.subProjectToNetworkPath = new SubProjectToNetworkPath(networkId);
        }

        public SubProjectToNetworkPath getSubProject() {
            return this.subProjectToNetworkPath;
        }
    }

    private static class DocumentToNetworkPath {
        private DocumentListToNetworkPath documentListToNetworkPath;

        DocumentToNetworkPath(Long networkId) {
            this.documentListToNetworkPath = new DocumentListToNetworkPath(networkId);
        }

        public DocumentListToNetworkPath getDocumentList() {
            return this.documentListToNetworkPath;
        }
    }
}

