/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.odf;

import java.util.List;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.text.TextFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdfFromHtmlConverter {
    private static final Logger log = LoggerFactory.getLogger(OdfFromHtmlConverter.class);

    public static void convert(org.w3c.dom.Node parentNode, String html, String baseTextStyle, Styles styles) {
        String[] lines;
        for (String line : lines = html.split("<br>")) {
            Document document = Jsoup.parse((String)line);
            Element body = document.body();
            TextPElement odfBaseNode = TextFactory.constructTextNode((org.w3c.dom.Node)parentNode, (String)"", (String)baseTextStyle);
            boolean allSupported = OdfFromHtmlConverter.constructChildNodes((org.w3c.dom.Node)odfBaseNode, body.childNodes(), baseTextStyle, styles);
            if (allSupported) continue;
            parentNode.removeChild((org.w3c.dom.Node)odfBaseNode);
            TextFactory.constructTextNode((org.w3c.dom.Node)parentNode, (String)line, (String)baseTextStyle);
        }
    }

    private static boolean constructChildNodes(org.w3c.dom.Node node, List<Node> jsoupNodes, String baseTextStyle, Styles styles) {
        boolean allSupported = true;
        for (Node jsoupNode : jsoupNodes) {
            String style;
            StyleTextPropertiesElement textProperties;
            String style2;
            if (jsoupNode instanceof TextNode) {
                TextNode textNode = (TextNode)jsoupNode;
                TextFactory.constructTextSpan((org.w3c.dom.Node)node, (String)textNode.getWholeText(), (String)baseTextStyle);
                continue;
            }
            if (!(jsoupNode instanceof Element)) continue;
            Element jsoupElement = (Element)jsoupNode;
            String tag = jsoupElement.tagName();
            TextSpanElement span = TextFactory.constructTextSpan((org.w3c.dom.Node)node, (String)"", (String)baseTextStyle);
            if ("b".equals(tag)) {
                style2 = styles.getTextStyle(new OdfStylePropertiesBase[]{styles.constructTextPropertiesWithFontWeight("bold")});
                allSupported &= OdfFromHtmlConverter.constructChildNodes((org.w3c.dom.Node)span, jsoupElement.childNodes(), style2, styles);
                continue;
            }
            if ("i".equals(tag)) {
                style2 = styles.getTextStyle(new OdfStylePropertiesBase[]{styles.constructTextPropertiesWithFontWeight("italic")});
                allSupported &= OdfFromHtmlConverter.constructChildNodes((org.w3c.dom.Node)span, jsoupElement.childNodes(), style2, styles);
                continue;
            }
            if ("u".equals(tag)) {
                textProperties = styles.constructTextProperties();
                textProperties.setStyleTextUnderlineStyleAttribute("solid");
                textProperties.setStyleTextUnderlineWidthAttribute("auto");
                textProperties.setStyleTextUnderlineColorAttribute("font-color");
                style = styles.getTextStyle(new OdfStylePropertiesBase[]{textProperties});
                allSupported &= OdfFromHtmlConverter.constructChildNodes((org.w3c.dom.Node)span, jsoupElement.childNodes(), style, styles);
                continue;
            }
            if ("strike".equals(tag)) {
                textProperties = styles.constructTextProperties();
                textProperties.setStyleTextLineThroughStyleAttribute("solid");
                textProperties.setStyleTextLineThroughTypeAttribute("single");
                style = styles.getTextStyle(new OdfStylePropertiesBase[]{textProperties});
                allSupported &= OdfFromHtmlConverter.constructChildNodes((org.w3c.dom.Node)span, jsoupElement.childNodes(), style, styles);
                continue;
            }
            if ("sub".equals(tag)) {
                textProperties = styles.constructTextProperties();
                textProperties.setStyleTextPositionAttribute("sub 58%");
                style = styles.getTextStyle(new OdfStylePropertiesBase[]{textProperties});
                allSupported &= OdfFromHtmlConverter.constructChildNodes((org.w3c.dom.Node)span, jsoupElement.childNodes(), style, styles);
                continue;
            }
            if ("sup".equals(tag)) {
                textProperties = styles.constructTextProperties();
                textProperties.setStyleTextPositionAttribute("super 58%");
                style = styles.getTextStyle(new OdfStylePropertiesBase[]{textProperties});
                allSupported &= OdfFromHtmlConverter.constructChildNodes((org.w3c.dom.Node)span, jsoupElement.childNodes(), style, styles);
                continue;
            }
            textProperties = styles.constructTextProperties();
            style = styles.getTextStyle(new OdfStylePropertiesBase[]{textProperties});
            allSupported &= OdfFromHtmlConverter.constructChildNodes((org.w3c.dom.Node)span, jsoupElement.childNodes(), style, styles);
        }
        return allSupported;
    }
}

