/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.document.context;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.EmailSnippet;
import at.cdes.api.dto.FutureEmail;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.TaskEmailSnippet;
import at.cdes.api.email.compositeDto.NewFutureEmailInfo;
import at.cdes.api.joinDto.GenerateTaskEmailSnippetJoin;
import at.cdes.api.joinDto.ReviewCycleContextJoin;
import at.cdes.api.voc.EntityVoc;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.TaskEmailSnippetDAO;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.document.context.GenerateTaskEmailSnippetsContext;
import at.cdes.impl.reviewCycle.ReducedWriteOnlyTaskEmailContext;
import at.cdes.impl.util.DBChanges;
import at.cdes.impl.util.ObjectCriteria;
import java.util.ArrayList;
import java.util.List;

public class GenerateTaskEmailSnippetsContextImpl
implements GenerateTaskEmailSnippetsContext,
ReducedWriteOnlyTaskEmailContext {
    private GenerateTaskEmailSnippetJoin baseJoin;
    private List<ProjectHoliday> projectHolidays;
    private DBChanges<EmailSnippet> emailSnippetChanges = new DBChanges();
    private DBChanges<TaskEmailSnippet> taskEmailSnippetChanges = new DBChanges();
    private DBChanges<FutureEmail> futureEmailChanges = new DBChanges();
    private List<NewFutureEmailInfo> newFutureEmailInfos = new ArrayList<NewFutureEmailInfo>();

    public GenerateTaskEmailSnippetsContextImpl(List<ProjectHoliday> projectHolidays) {
        this.projectHolidays = projectHolidays;
    }

    public GenerateTaskEmailSnippetsContextImpl(List<ProjectHoliday> projectHolidays, List<? extends ReviewCycleContextJoin> projectRoleJoins) {
        this.projectHolidays = projectHolidays;
    }

    public GenerateTaskEmailSnippetsContextImpl(GenerateTaskEmailSnippetJoin baseJoin, List<ProjectHoliday> projectHolidays) {
        this.baseJoin = baseJoin;
        this.projectHolidays = projectHolidays;
    }

    public GenerateTaskEmailSnippetJoin getBaseJoin() {
        return this.baseJoin;
    }

    @Override
    public List<ProjectHoliday> getAllProjectHolidays() {
        return this.projectHolidays;
    }

    @Override
    public List<FutureEmail> getFutureEmailsForTask(Long taskId) {
        return new ArrayList<FutureEmail>();
    }

    @Override
    public void registerNewTaskEmailSnippet(EmailSnippet emailSnippet, TaskEmailSnippet taskEmailSnippet) {
        this.emailSnippetChanges.registerNew(emailSnippet);
        this.taskEmailSnippetChanges.registerNew(taskEmailSnippet);
    }

    @Override
    public void registerNewFutureEmail(FutureEmail futureEmail, BaseTask refTask) {
        this.futureEmailChanges.registerNew(futureEmail);
        this.newFutureEmailInfos.add(new NewFutureEmailInfo(futureEmail, refTask));
    }

    @Override
    public void registerFutureEmailForDelete(FutureEmail futureEmail) {
        this.futureEmailChanges.registerForDelete(futureEmail.getId());
    }

    @Override
    public void registerFutureEmailsForDelete(ObjectCriteria<FutureEmail> criteria) {
        this.futureEmailChanges.registerForDelete(criteria);
    }

    public void commitAll(DebugContext debugContext, EmailSnippetDAO emailSnippetDAO, TaskEmailSnippetDAO taskEmailSnippetDAO, FutureEmailDAO futureEmailDAO) {
        debugContext.openDebugNode("GenerateTaskEmailSnippetContextImpl.commitAll");
        List<EmailSnippet> justInsertedEmailSnippets = this.emailSnippetChanges.saveBatch(emailSnippetDAO, EntityVoc.EMAIL_SNIPPET, null);
        for (int n = 0; n < justInsertedEmailSnippets.size(); ++n) {
            TaskEmailSnippet taskEmailSnippet = this.taskEmailSnippetChanges.getNewInstance(n);
            if (taskEmailSnippet == null) continue;
            taskEmailSnippet.setEmailSnippetId(justInsertedEmailSnippets.get(n).getId());
        }
        List<TaskEmailSnippet> taskEmailSnippets = this.taskEmailSnippetChanges.saveBatch(taskEmailSnippetDAO, EntityVoc.TASK_EMAIL_SNIPPET, null);
        for (TaskEmailSnippet taskEmailSnippet : taskEmailSnippets) {
            debugContext.addSaveTaskEmailSnippetMessage(taskEmailSnippet);
        }
        for (int n = 0; n < this.futureEmailChanges.getNumberOfNewInstances(); ++n) {
            FutureEmail newFutureEmail = this.futureEmailChanges.getNewInstance(n);
            if (newFutureEmail == null) continue;
            for (NewFutureEmailInfo newFutureEmailInfo : this.newFutureEmailInfos) {
                if (newFutureEmailInfo.getFutureEmail() != newFutureEmail) continue;
                newFutureEmail.setTaskId(newFutureEmailInfo.getTask().getId());
            }
        }
        List<FutureEmail> futureEmails = this.futureEmailChanges.saveBatch(futureEmailDAO, EntityVoc.FUTURE_EMAIL, null);
        for (FutureEmail futureEmail : futureEmails) {
            debugContext.addSaveFutureEmailMessage(futureEmail);
        }
        this.futureEmailChanges.updateDeleteBatch(futureEmailDAO, EntityVoc.FUTURE_EMAIL, null);
        for (FutureEmail futureEmail : this.futureEmailChanges.getUpdateInstances()) {
            debugContext.addUpdateFutureEmailMessage(futureEmail);
        }
        for (Long futureEmailId : this.futureEmailChanges.getDeleteInstanceIds()) {
            debugContext.addDeleteMessage(futureEmailId, "FutureEmail", "");
        }
        this.taskEmailSnippetChanges.updateDeleteBatch(taskEmailSnippetDAO, EntityVoc.TASK_EMAIL_SNIPPET, null);
        for (TaskEmailSnippet taskEmailSnippet : this.taskEmailSnippetChanges.getUpdateInstances()) {
            debugContext.addUpdateTaskEmailSnippetMessage(taskEmailSnippet);
        }
        for (Long emailSnippetId : this.taskEmailSnippetChanges.getDeleteInstanceIds()) {
            debugContext.addDeleteMessage(emailSnippetId, "TaskEmailSnippet", "");
        }
        this.emailSnippetChanges.updateDeleteBatch(emailSnippetDAO, EntityVoc.EMAIL_SNIPPET, null);
        for (EmailSnippet emailSnippet : this.emailSnippetChanges.getUpdateInstances()) {
            debugContext.addUpdateEmailSnippetMessage(emailSnippet);
        }
        for (Long emailSnippetId : this.emailSnippetChanges.getDeleteInstanceIds()) {
            debugContext.addDeleteMessage(emailSnippetId, "EmailSnippet", "");
        }
        debugContext.closeDebugNode();
    }
}

