/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.document.compositeDto.DocumentListOtherVersionCellResultInfo;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionNodeResultInfo;
import at.cdes.api.document.compositeDto.DocumentListRow;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.joinDto.DocumentListJoin;
import at.cdes.api.review.compositeDto.ReviewCycleCellInstanceReleasedInfo;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.api.review.compositeDto.ReviewCycleNodeInstanceReleasedInfo;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.TaskUrgency;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.reviewCycle.ReviewProtocolSvgCalculator;
import at.cdes.impl.reviewCycle.ReviewProtocolSvgRenderer;
import at.cdes.impl.reviewCycle.SmallReviewCycleSvgGeometry;
import at.cdes.impl.reviewCycle.SvgCorner;
import at.cdes.impl.util.holiday.HolidayCalculator;
import at.cdes.impl.util.svg.SvgHelper;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.clazzes.util.lang.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmallReviewCycleSvgRenderer {
    private static final XMLOutputFactory XOF = XMLOutputFactory.newFactory();
    private static final NamespaceContext SVG_NAMESPACE_CONTEXT;
    private Boolean reversePreduration;
    private static final double HEIGHT = 60.0;
    private static final Logger log;
    private static final double height_bar = 20.0;
    private ResourceBundle resourceBundle = null;

    public void setReversePreduration(Boolean reversePreduration) {
        this.reversePreduration = reversePreduration;
    }

    public Triple<String, String, Integer> render(DocumentListRow documentListRow, ReviewCycleInfo cycleInfo, double totalWidth, double totalHeight, boolean withNodeDurationLabel, boolean showOnlyCurrentNode, boolean withNodeDelayLabelExtended, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        boolean isPreReviewed;
        RenderInfo renderInfo = new RenderInfo();
        this.resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        Long documentVersionId = documentListRow.getDocumentVersionId();
        boolean hasDocumentVersions = documentListRow.getDocumentHasDocumentVersions();
        Long documentReleaseId = documentListRow.getDocumentReleaseId();
        Double startDate = documentListRow.getDocumentReleaseStartDate();
        DocumentVersionStatus documentVersionStatus = documentListRow.getDocumentVersionStatus();
        boolean isReleasedOrInvalidatedAll = documentVersionStatus == DocumentVersionStatus.RELEASEDPOSITIV || documentVersionStatus == DocumentVersionStatus.INVALIDATEDALL;
        boolean bl = isPreReviewed = documentVersionStatus == DocumentVersionStatus.PREREVIEWED;
        if (documentVersionId == null && !hasDocumentVersions && (documentReleaseId == null || documentReleaseId != null && startDate == null) || isReleasedOrInvalidatedAll || isPreReviewed) {
            return new Triple(null, null, null);
        }
        Integer actualHeight = null;
        StringWriter stringWriter = new StringWriter();
        XMLStreamWriter xsw = null;
        StringWriter popupStringWriter = new StringWriter();
        XMLStreamWriter popupWriter = null;
        try {
            xsw = XOF.createXMLStreamWriter(stringWriter);
            xsw.setNamespaceContext(SVG_NAMESPACE_CONTEXT);
            xsw.writeStartElement("svg");
            xsw.writeAttribute("xmlns", "http://www.w3.org/2000/svg");
            xsw.writeAttribute("width", String.valueOf(totalWidth));
            xsw.writeAttribute("height", String.valueOf(totalHeight));
            popupWriter = XOF.createXMLStreamWriter(popupStringWriter);
            xsw.writeAttribute("viewBox", "0.0 0.0 " + String.valueOf(totalWidth + 10.0) + " " + String.valueOf(totalHeight + 10.0));
            actualHeight = this.doRender(xsw, renderInfo, popupWriter, documentListRow, cycleInfo, totalWidth, totalHeight, showOnlyCurrentNode, withNodeDelayLabelExtended, withNodeDurationLabel, personVariablesUserLocale, holidayCalculator);
            xsw.writeEndElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (xsw != null) {
                    xsw.close();
                }
                if (popupWriter != null) {
                    popupWriter.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing XMLStreamWriter", e);
            }
        }
        String result = stringWriter.toString();
        String toolTip = popupStringWriter.toString();
        if (log.isDebugEnabled()) {
            log.debug("Rendered svg: [" + result + "]");
        }
        return new Triple((Object)result, (Object)toolTip, (Object)renderInfo.delay);
    }

    private int doRender(XMLStreamWriter xsw, RenderInfo renderInfo, XMLStreamWriter popupWriter, DocumentListRow documentListRow, ReviewCycleInfo cycleInfo, double totalWidth, double totalHeight, boolean showOnlyCurrentNode, boolean withNodeDelayLabelExtended, boolean withNodeDurationLabel, String personVariablesUserLocale, HolidayCalculator holidayCalculator) throws Exception {
        boolean noTask;
        SmallReviewCycleSvgGeometry geometry = this.constructGeometry(totalWidth, totalHeight, showOnlyCurrentNode, withNodeDelayLabelExtended, withNodeDurationLabel, true, holidayCalculator);
        Double xStart = geometry.getxStart();
        Double yStart = geometry.getyStart();
        Double width = geometry.getWidth();
        Double xToday = geometry.getxToday();
        Double bottom = geometry.getBottom();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
        String startString = SmallReviewCycleSvgRenderer.formatDate(dateFormat, geometry.getAxisStart());
        String endString = SmallReviewCycleSvgRenderer.formatDate(dateFormat, geometry.getAxisEnd());
        String todayString = SmallReviewCycleSvgRenderer.formatDate(dateFormat, geometry.getToday());
        if (log.isDebugEnabled()) {
            log.debug("Drawing timeline: xStart [" + xStart + "], yStart [" + yStart + "], width [" + width + "]");
            log.debug("... startAxis [" + geometry.getAxisStart() + "] --> formatted to [" + startString + "]");
            log.debug("... endAxis [" + geometry.getAxisEnd() + "] --> formatted to [" + endString + "]");
        }
        SvgHelper.addLineWithStroke(xsw, xStart, yStart + 12.0, xStart + width, yStart + 12.0, "black", 0.5);
        SvgHelper.addText(xsw, 0.0, yStart + 10.0, startString, "font-family", "verdana", "font-size", "8px");
        SvgHelper.addText(xsw, xStart + width, yStart + 10.0, endString, "font-family", "verdana", "font-size", "8px", "text-anchor", "end");
        if (log.isDebugEnabled()) {
            log.debug("Drawing line to indicate today: xtoDay [" + xToday + "], bottom [" + bottom + "]");
            log.debug("... toDay [" + geometry.getToday() + "] --> formatted to [" + todayString + "]");
        }
        SvgHelper.addLineWithStroke(xsw, xToday, yStart + 12.0, xToday, bottom, "black", 0.5);
        SvgHelper.addText(xsw, width / 2.0 - 10.0, yStart + 10.0, todayString, "font-family", "verdana", "font-size", "8px");
        this.drawBackground(xsw, documentListRow, geometry);
        DocumentVersionStatus documentVersionStatus = documentListRow.getDocumentVersionStatus();
        boolean isReleasedOrInvalidatedAll = documentVersionStatus == DocumentVersionStatus.RELEASEDPOSITIV || documentVersionStatus == DocumentVersionStatus.INVALIDATEDALL;
        boolean isInvalidatedOrDeleted = documentVersionStatus == DocumentVersionStatus.DELETED || documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION;
        Double earliestEndDate = null;
        DocumentListOtherVersionNodeResultInfo actualNodeResultJoin = null;
        if (!isReleasedOrInvalidatedAll && documentListRow.getAllCellResultInfos().size() > 0) {
            actualNodeResultJoin = this.drawDoneCells(xsw, renderInfo, popupWriter, documentListRow, cycleInfo, geometry);
            earliestEndDate = this.drawRemainingCells(xsw, actualNodeResultJoin, documentListRow, cycleInfo, geometry.getLastNodeEnd(), geometry.getCurrentXNodeEnd(), geometry);
        } else if (documentListRow.hasDocumentRelease()) {
            this.drawEntryNode(xsw, popupWriter, documentListRow, cycleInfo, geometry);
        }
        Double plannedEnd = geometry.getPlannedEnd();
        Integer preDuration = documentListRow.getReviewCycleInstanceReleasedDurationPre();
        if (plannedEnd != null && earliestEndDate != null && documentListRow.getAllOtherVersionsCellResultCount() > 0) {
            boolean withCycleDelayLabel;
            if (preDuration > 0 && this.reversePreduration != null && this.reversePreduration.booleanValue()) {
                earliestEndDate = holidayCalculator.addWorkingDays(earliestEndDate, preDuration);
            }
            int reviewCycleDelay = holidayCalculator.getWorkingDaysBetween(earliestEndDate, plannedEnd);
            if (log.isDebugEnabled()) {
                log.debug("review cycle's delay " + reviewCycleDelay);
            }
            if ((withCycleDelayLabel = geometry.isWithCycleDelayLabel()) && !isInvalidatedOrDeleted) {
                Double xEnd = geometry.getxEnd();
                if (log.isDebugEnabled()) {
                    log.debug("Drawing text, case withCycleDelayLabel and not isInvalidatedOrDeleted");
                    log.debug("... xEnd [" + xEnd + "], bottom [" + bottom + "], height_bar [" + 20.0 + "], reviewCycleDelay [" + reviewCycleDelay + "]");
                }
                SvgHelper.addText(xsw, xEnd, bottom - 20.0 - 8.0, Integer.toString(reviewCycleDelay), "font-family", "verdana", "font-size", "10px", "text-anchor", "end", "stroke", "red");
            }
            boolean noTask2 = true;
            this.evalPopupCycleProgress(popupWriter, documentListRow, reviewCycleDelay, noTask2, isInvalidatedOrDeleted);
        }
        if ((noTask = true) && documentListRow.hasDocumentVersion()) {
            this.evalPopupDocumentVersionStatus(popupWriter, documentListRow, cycleInfo);
        }
        return 0;
    }

    private Map<Long, DocumentListJoin> groupByNodeResultId(List<DocumentListJoin> documentListJoins) {
        HashMap<Long, DocumentListJoin> nodeResultIdToJoin = new HashMap<Long, DocumentListJoin>();
        for (DocumentListJoin documentListJoin : documentListJoins) {
            Long nodeResultId = documentListJoin.getReviewCycleNodeResultId();
            nodeResultIdToJoin.put(nodeResultId, documentListJoin);
        }
        return nodeResultIdToJoin;
    }

    private Map<Long, DocumentListJoin> groupByNodeInstanceReleased(List<DocumentListJoin> documentListJoins) {
        HashMap<Long, DocumentListJoin> nodeInstanceReleasedIdToJoin = new HashMap<Long, DocumentListJoin>();
        for (DocumentListJoin documentListJoin : documentListJoins) {
            Long nodeInstanceReleasedId = documentListJoin.getReviewCycleNodeInstanceReleasedId();
            nodeInstanceReleasedIdToJoin.put(nodeInstanceReleasedId, documentListJoin);
        }
        return nodeInstanceReleasedIdToJoin;
    }

    private SmallReviewCycleSvgGeometry constructGeometry(double totalWidth, double totalHeight, boolean showOnlyCurrentNode, boolean withNodeDelayLabelExtended, boolean withNodeDurationLabel, boolean withCycleDelayLabel, HolidayCalculator holidayCalculator) {
        SmallReviewCycleSvgGeometry geometry = new SmallReviewCycleSvgGeometry();
        geometry.setHolidayCalculator(holidayCalculator);
        geometry.setShowOnlyCurrentNode(showOnlyCurrentNode);
        geometry.setWithNodeDelayLabelExtended(withNodeDelayLabelExtended);
        geometry.setWithNodeDurationLabel(withNodeDurationLabel);
        geometry.setWithCycleDelayLabel(withCycleDelayLabel);
        double axisEndUtcSeconds = ReviewProtocolSvgCalculator.jumpByDays((double)System.currentTimeMillis() / 1000.0, 30);
        geometry.setAxisEnd(axisEndUtcSeconds);
        double axisStartUtcSeconds = ReviewProtocolSvgCalculator.jumpByDays(axisEndUtcSeconds, -60);
        geometry.setAxisStart(axisStartUtcSeconds);
        int daysToDraw = ReviewProtocolSvgCalculator.calculateDaysToDraw(axisStartUtcSeconds, axisEndUtcSeconds);
        geometry.setNumberOfDaysToDraw(daysToDraw);
        geometry.setHeight(60.0);
        double xStart = 0.0;
        geometry.setxStart(xStart);
        geometry.setyStart(0.0);
        geometry.setBottom(60.0);
        double placePerUnit = totalWidth / (double)daysToDraw;
        geometry.setPlacePerUnit(placePerUnit);
        geometry.setWidth(placePerUnit * (double)daysToDraw);
        geometry.setxEnd(xStart + totalWidth);
        geometry.setCurrentXNodeEnd(0.0);
        geometry.setToday((double)System.currentTimeMillis() / 1000.0);
        double xToday = SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStartUtcSeconds, (double)System.currentTimeMillis() / 1000.0, placePerUnit) + xStart;
        geometry.setxToday(xToday);
        return geometry;
    }

    private static double getXPositionFromDate(double startDate, double actualDate, double spacePerDay) {
        if (actualDate < startDate) {
            return -1.0;
        }
        int days = 0;
        days = ReviewProtocolSvgCalculator.calculateDaysToDraw(startDate, actualDate);
        return (double)days * spacePerDay;
    }

    private static String formatDate(SimpleDateFormat df, Double utcSeconds) {
        String ret = "null";
        if (utcSeconds != null && df != null) {
            ret = df.format(utcSeconds * 1000.0);
        }
        return ret;
    }

    private void drawBackground(XMLStreamWriter xsw, DocumentListRow documentListRow, SmallReviewCycleSvgGeometry geometry) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("====================================");
            log.debug("Called drawBackground");
            log.debug("====================================");
        }
        Long documentReleaseId = documentListRow.getDocumentReleaseId();
        Double startDate = documentListRow.getDocumentReleaseStartDate();
        Double endDate = documentListRow.getDocumentReleaseEndDate();
        Double xStart = geometry.getxStart();
        Double xEnd = geometry.getxEnd();
        Double yStart = geometry.getyStart();
        Double width = geometry.getWidth();
        Double height = geometry.getHeight();
        if (documentReleaseId != null && (startDate != null || endDate != null)) {
            Integer durationMin;
            Double plannedEnd = endDate;
            geometry.setPlannedEnd(plannedEnd);
            if (plannedEnd == null) {
                return;
            }
            Integer duration = documentListRow.getReviewCycleInstanceReleasedDuration();
            if (duration == null) {
                duration = 0;
            }
            if ((durationMin = documentListRow.getReviewCycleInstanceReleasedDurationMin()) == null) {
                durationMin = 0;
            }
            HolidayCalculator holidayCalculator = geometry.getHolidayCalculator();
            Double plannedStart = null;
            plannedStart = startDate != null ? startDate : holidayCalculator.addWorkingDays(plannedEnd, -duration.intValue());
            geometry.setPlannedStart(plannedStart);
            Double extraTime = null;
            int addBuffer = duration - durationMin;
            if (addBuffer > 0) {
                extraTime = holidayCalculator.addWorkingDays(plannedEnd, -addBuffer);
            }
            Double axisStart = geometry.getAxisStart();
            Double axisEnd = geometry.getAxisEnd();
            Double placePerUnit = geometry.getPlacePerUnit();
            double XplannedEnd = SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, plannedEnd, placePerUnit) + xStart;
            double XextraTimeStart = -1.0;
            if (extraTime != null) {
                XextraTimeStart = SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, extraTime, placePerUnit) + xStart;
            }
            Double nowSeconds = (double)System.currentTimeMillis() / 1000.0;
            if (plannedEnd < axisStart) {
                if (log.isDebugEnabled()) {
                    log.debug("red rectangle, plannedEnd before beginn of time axis");
                    log.debug("... xStart [" + xStart + "], yStart [" + yStart + "], width [" + width + "], height [" + height + "]");
                }
                SvgHelper.addRect(xsw, xStart, yStart, width, height, null, "fill", "#ff0000", "opacity", "0.1");
                geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_HOPELESS);
            } else if (extraTime == null) {
                if (plannedEnd < axisEnd) {
                    if (log.isDebugEnabled()) {
                        log.debug("green + red, planned End within axis, extraTime not defined");
                        log.debug("... xStart [" + xStart + "], yStart [" + yStart + "], width [" + width + "], height [" + height + "]");
                        log.debug("... XplannedEnd [" + XplannedEnd + "]");
                    }
                    SvgHelper.addRect(xsw, xStart, yStart, XplannedEnd - xStart, height, null, "fill", "#00ff00", "opacity", "0.1");
                    SvgHelper.addRect(xsw, XplannedEnd, yStart, width - (XplannedEnd - xStart), height, null, "fill", "#ff0000", "opacity", "0.1");
                    geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_HOPELESS);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("green");
                        log.debug("... xStart [" + xStart + "], yStart [" + yStart + "], width [" + width + "], height [" + height + "]");
                    }
                    SvgHelper.addRect(xsw, xStart, yStart, width, height, null, "fill", "#00ff00", "opacity", "0.1");
                    geometry.setTaskUrgency(TaskUrgency.URGENCY_NORMAL);
                }
            } else if (plannedEnd > axisEnd && extraTime < axisEnd) {
                if (log.isDebugEnabled()) {
                    log.debug("green + yellow, extraTime within timeaxis, planned end not");
                    log.debug("... xStart [" + xStart + "], yStart [" + yStart + ", XextraTimeStart [" + XextraTimeStart + "], width [" + width + "], height [" + height + "]");
                }
                SvgHelper.addRect(xsw, xStart, yStart, XextraTimeStart - xStart, height, null, "fill", "#00ff00", "opacity", "0.1");
                SvgHelper.addRect(xsw, XextraTimeStart, yStart, width - (XextraTimeStart - xStart), height, null, "fill", "#ffff00", "opacity", "0.1");
                if (extraTime < nowSeconds) {
                    geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_NODE);
                } else {
                    geometry.setTaskUrgency(TaskUrgency.URGENCY_NORMAL);
                }
            } else if (extraTime < axisEnd) {
                if (log.isDebugEnabled()) {
                    log.debug("extraTime before ending of time axis");
                }
                if (plannedEnd < axisEnd) {
                    if (extraTime > axisStart) {
                        if (log.isDebugEnabled()) {
                            log.debug("green+yellow+red, xStart [" + xStart + "], yStart [" + yStart + "], XextraTimeStart [" + XextraTimeStart + "], XplannedEnd [" + XplannedEnd + "], width [" + width + "], height [" + height + "]");
                        }
                        SvgHelper.addRect(xsw, xStart, yStart, XextraTimeStart - xStart, height, null, "fill", "#00ff00", "opacity", "0.1");
                        SvgHelper.addRect(xsw, XextraTimeStart, yStart, XextraTimeStart - XplannedEnd, height, null, "fill", "#00ff00", "opacity", "0.1");
                        SvgHelper.addRect(xsw, XplannedEnd, yStart, width - (XplannedEnd - xStart), height, null, "fill", "#ff0000", "opacity", "0.1");
                        if (extraTime < nowSeconds && plannedEnd < nowSeconds) {
                            geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_HOPELESS);
                        } else if (extraTime < nowSeconds && plannedEnd > nowSeconds) {
                            geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_NODE);
                        } else {
                            geometry.setTaskUrgency(TaskUrgency.URGENCY_NORMAL);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("yellow+red, xStart [" + xStart + "], yStart [" + yStart + "], XplannedEnd [" + XplannedEnd + "], width [" + width + "], height [" + height + "]");
                        }
                        SvgHelper.addRect(xsw, xStart, yStart, XplannedEnd - xStart, height, null, "fill", "#ffff00", "opacity", "0.1");
                        SvgHelper.addRect(xsw, XplannedEnd, yStart, width - (XplannedEnd - xStart), height, null, "fill", "#ff0000", "opacity", "0.1");
                        if (plannedEnd > nowSeconds) {
                            geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_NODE);
                        } else {
                            geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_HOPELESS);
                        }
                    }
                } else if (extraTime > axisStart) {
                    if (log.isDebugEnabled()) {
                        log.debug("green+yellow: xStart [" + xStart + "], yStart [" + yStart + "], XextraTimeStart [" + XextraTimeStart + "], width [" + width + "], height [" + height + "]");
                    }
                    SvgHelper.addRect(xsw, xStart, yStart, XextraTimeStart - xStart, height, null, "fill", "#00ff00", "opacity", "0.1");
                    SvgHelper.addRect(xsw, XextraTimeStart, yStart, width - (XextraTimeStart - xStart), height, null, "fill", "#ffff00", "opacity", "0.1");
                    if (extraTime < nowSeconds) {
                        geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_NODE);
                    } else {
                        geometry.setTaskUrgency(TaskUrgency.URGENCY_NORMAL);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("yellow: xStart [" + xStart + "], yStart [" + yStart + "], width [" + width + "], height [" + height + "]");
                    }
                    SvgHelper.addRect(xsw, xStart, yStart, width, height, null, "fill", "#ffff00", "opacity", "0.1");
                    geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_NODE);
                }
            } else if (extraTime > axisEnd) {
                if (log.isDebugEnabled()) {
                    log.debug("green, extraTime after time axis");
                    log.debug("... xStart [" + xStart + "], yStart [" + yStart + "], width [" + width + "], height [" + height + "]");
                }
                SvgHelper.addRect(xsw, xStart, yStart, width, height, null, "fill", "#00ff00", "opacity", "0.1");
                geometry.setTaskUrgency(TaskUrgency.URGENCY_NORMAL);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("extraTime and planned end within timeaxis");
                    log.debug("... green+yellow+red, xStart [" + xStart + "], yStart [" + yStart + "], XextraTimeStart [" + XextraTimeStart + "], XplannedEnd [" + XplannedEnd + "], width [" + width + "], height [" + height + "]");
                }
                SvgHelper.addRect(xsw, xStart, yStart, XextraTimeStart - xStart, height, null, "fill", "#00ff00", "opacity", "0.1");
                SvgHelper.addRect(xsw, XextraTimeStart, yStart, XextraTimeStart - XplannedEnd, height, null, "fill", "#ffff00", "opacity", "0.1");
                SvgHelper.addRect(xsw, XplannedEnd, yStart, width - (XplannedEnd - xStart), height, null, "fill", "#ff0000", "opacity", "0.1");
                if (extraTime < nowSeconds && plannedEnd < nowSeconds) {
                    geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_HOPELESS);
                } else if (extraTime < nowSeconds && plannedEnd > nowSeconds) {
                    geometry.setTaskUrgency(TaskUrgency.URGENCY_DELAYED_NODE);
                } else {
                    geometry.setTaskUrgency(TaskUrgency.URGENCY_NORMAL);
                }
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Case reldoc == null");
                log.debug("... xStart [" + xStart + "], yStart [" + yStart + "], width [" + width + "], height [" + height + "]");
            }
            SvgHelper.addRect(xsw, xStart, yStart, width, height, null, "fill", "#ffffff", "opacity", "0.1");
        }
    }

    private DocumentListOtherVersionNodeResultInfo drawDoneCells(XMLStreamWriter xsw, RenderInfo renderInfo, XMLStreamWriter popupWriter, DocumentListRow documentListRow, ReviewCycleInfo cycleInfo, SmallReviewCycleSvgGeometry geometry) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("================================================");
            log.debug("drawDoneCells");
            log.debug("================================================");
        }
        DocumentListOtherVersionNodeResultInfo lastNodeResult = null;
        Double lastContractualDeadline = null;
        int lastNodeDelay = 0;
        boolean firstNotEmptyNode = true;
        boolean lastDocumentVersionHasCellResult = false;
        int otherVersionCellResultCount = documentListRow.getAllOtherVersionsCellResultCount();
        if (otherVersionCellResultCount > 0) {
            DocumentListOtherVersionCellResultInfo possibleLastVersion = documentListRow.getLastOtherVersionActualCellResultInfo();
            lastDocumentVersionHasCellResult = possibleLastVersion != null && documentListRow.isLastOtherVersionId(possibleLastVersion.getCellResultDocumentVersionId());
            DocumentListOtherVersionCellResultInfo firstCellResultInfo = documentListRow.getFirstOtherVersionActualCellResultInfo();
            Double actualStartOfReviewCycle = firstCellResultInfo != null ? firstCellResultInfo.getCellResultArrivalDate() : null;
            geometry.setActualStartOfReviewCycle(actualStartOfReviewCycle);
        }
        boolean usePdcStartDate = documentListRow.isUsePDCStartDateForTasks();
        Double plannedStart = geometry.getPlannedStart();
        if (plannedStart == null || geometry.getActualStartOfReviewCycle() != null && plannedStart <= geometry.getActualStartOfReviewCycle()) {
            usePdcStartDate = false;
        }
        geometry.setUsePdcStartDate(usePdcStartDate);
        List cellResultInfos = documentListRow.getAllCellResultInfos();
        for (int n = 0; n < cellResultInfos.size(); ++n) {
            DocumentListOtherVersionCellResultInfo cellResultInfo = (DocumentListOtherVersionCellResultInfo)cellResultInfos.get(n);
            Long cellResultId = cellResultInfo.getCellResultId();
            if (log.isDebugEnabled()) {
                log.debug("... Processing cellResultId [" + cellResultId + "]");
            }
            Boolean cellResultFinished = cellResultInfo.isCellResultFinished();
            Long previousReviewCycleCellId = cellResultInfo.getCellResultPreviousCellId();
            Long nextReviewCycleCellId = cellResultInfo.getCellResultNextCellId();
            if ((cellResultFinished == null || !cellResultFinished.booleanValue()) && previousReviewCycleCellId == null && nextReviewCycleCellId == null && cellResultInfos.size() > 1) continue;
            boolean lastCellResult = n == cellResultInfos.size() - 1;
            String cellColor = cellResultInfo.getCellSvgColor();
            Long emptyNodeOptionId = cellResultInfo.getCycleEmptyNodeResultOptionId();
            Long invalidateNodeOptionId = cellResultInfo.getCycleDocumentVersionInvalidationResultOptionId();
            Long deletedNodeOptionId = cellResultInfo.getCycleDocumentVersionDeletedOptionId();
            HolidayCalculator holidayCalculator = geometry.getHolidayCalculator();
            Double departureDate = cellResultInfo.getCellResultDepartureDate();
            if (departureDate == null || departureDate > geometry.getAxisStart()) {
                List nodeResultInfos = cellResultInfo.getAllNodeResultInfos();
                for (int z = 0; z < nodeResultInfos.size(); ++z) {
                    Long resultOptionId;
                    boolean lastCellResultIsInvalidated;
                    boolean isLastNodeResult;
                    DocumentListOtherVersionNodeResultInfo nodeResultInfo = (DocumentListOtherVersionNodeResultInfo)nodeResultInfos.get(z);
                    if (log.isDebugEnabled()) {
                        log.debug("...... Processing nodeResult [" + nodeResultInfo.getNodeResultId() + "]");
                    }
                    if (nodeResultInfo.getNodeInstanceReleasedId() == null) continue;
                    boolean bl = isLastNodeResult = z == nodeResultInfos.size() - 1;
                    if (nodeResultInfo.isNodeFree()) continue;
                    Long nodeResultResultOptionId = nodeResultInfo.getNodeResultResultOptionId();
                    boolean bl2 = lastCellResultIsInvalidated = lastCellResult && nodeResultResultOptionId != null && (nodeResultResultOptionId.longValue() == invalidateNodeOptionId.longValue() || nodeResultResultOptionId.longValue() == deletedNodeOptionId.longValue()) || lastCellResult && !lastDocumentVersionHasCellResult;
                    if ((nodeResultResultOptionId == null || nodeResultResultOptionId.longValue() != emptyNodeOptionId.longValue()) && (departureDate == null || departureDate > geometry.getAxisStart()) || lastCellResultIsInvalidated) {
                        double XnodeEnd;
                        double XnodeStart;
                        Integer nodesDelay = 0;
                        Double nodeStart = nodeResultInfo.getNodeResultArrivalDate();
                        boolean nodeResultFinished = nodeResultInfo.isNodeResultFinished();
                        if (!nodeResultFinished && firstNotEmptyNode && geometry.isUsePdcStartDate()) {
                            nodeStart = geometry.getPlannedStart();
                        }
                        firstNotEmptyNode = false;
                        Double actualNodeEnd = ReviewProtocolSvgRenderer.verifyDocumentDepartureDate(nodeResultInfo);
                        Double nodeEnd = null;
                        ReviewProtocolSvgRenderer.DelayInfo nodesData = ReviewProtocolSvgRenderer.calculateDelayOfActualNode(holidayCalculator, nodeResultInfo, nodeStart);
                        Double contractualDeadline = nodesData.getContractualDeadline();
                        nodesDelay = nodesData.getNodesDelay();
                        Integer duration = nodesData.getNodesDuration();
                        if (contractualDeadline == null || nodesDelay == null || duration == null) {
                            log.warn("For nodeResultId [" + nodeResultInfo.getNodeResultId() + "]: Found null value in DelayInfo.  contractualDeadline [" + contractualDeadline + "], nodesDelay [" + nodesDelay + "], duration [" + duration + "]");
                            continue;
                        }
                        Double today = geometry.getToday();
                        if (lastCellResultIsInvalidated && isLastNodeResult) {
                            nodeEnd = nodesDelay < 0 ? contractualDeadline : actualNodeEnd;
                            Double axisStart = geometry.getAxisStart();
                            Double placePerUnit = geometry.getPlacePerUnit();
                            Double xStart = geometry.getxStart();
                            Double xToday = geometry.getxToday();
                            XnodeStart = nodeStart != null && nodeStart > geometry.getAxisStart() ? SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, nodeStart, placePerUnit) + xStart : xStart;
                            XnodeEnd = nodeEnd != null ? SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, nodeEnd, placePerUnit) + xStart : xToday;
                            geometry.setCurrentXNodeEnd(XnodeEnd);
                            if (log.isDebugEnabled()) {
                                log.debug("......... axisStart [" + axisStart + "], placePerUnit [" + placePerUnit + "], xStart [" + xStart + "], xToday [" + xToday + "], XnodeStart [" + XnodeStart + "] ==> Setting XnodeEnd [" + XnodeEnd + "]");
                            }
                            int typeOfEdges = ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeResultInfo, cycleInfo, nodesDelay < 0 || actualNodeEnd == null);
                            boolean showOnlyCurrentNode = geometry.isShowOnlyCurrentNode();
                            if (XnodeStart != xToday && actualNodeEnd != null && !showOnlyCurrentNode) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Clause 'draw done nodes checking the showOnlyCurrentNode flag', if-clause");
                                    log.debug("... XnodeStart [" + XnodeStart + "], nodeEnd [" + nodeEnd + "], toDay [" + today + "], height_bar [" + 20.0 + "], cellColor [" + cellColor + "], duration [" + duration + "], typeOfEdges [" + typeOfEdges + "]");
                                }
                                this.drawNode(xsw, geometry, XnodeStart, nodeEnd != null ? nodeEnd : today, 10.0, 20.0, cellColor, false, duration, typeOfEdges);
                            } else if (XnodeStart != xToday && actualNodeEnd == null) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Clause 'draw done nodes checking the showOnlyCurrentNode flag', else-clause");
                                    log.debug("... XnodeStart [" + XnodeStart + "], nodeEnd [" + nodeEnd + "], toDay [" + today + "], height_bar [" + 20.0 + "], cellColor [" + cellColor + "], duration [" + duration + "], typeOfEdges [" + typeOfEdges + "]");
                                }
                                this.drawNode(xsw, geometry, XnodeStart, nodeEnd != null ? nodeEnd : today, 10.0, 20.0, cellColor, false, duration, typeOfEdges);
                            }
                            XnodeStart = XnodeEnd;
                            if (actualNodeEnd != null && nodesDelay < 0) {
                                nodeEnd = actualNodeEnd;
                                int typeOfEdges2 = ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeResultInfo, cycleInfo, false);
                                if (!showOnlyCurrentNode) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("draw the delayed not section of done nodes");
                                        log.debug("... XnodeStart [" + XnodeStart + "], nodeEnd [" + nodeEnd + "], toDay [" + today + "], height_bar [" + 20.0 + "]");
                                    }
                                    this.drawNode(xsw, geometry, XnodeStart, nodeEnd != null ? nodeEnd : today, 10.0, 20.0, "#ff0000; opacity:0.5", false, nodesDelay, typeOfEdges2 - typeOfEdges);
                                }
                            }
                            nodeStart = nodeEnd;
                            contractualDeadline = holidayCalculator.addWorkingDays(actualNodeEnd, duration);
                            nodesDelay = holidayCalculator.getWorkingDaysBetween(today, contractualDeadline);
                        }
                        lastContractualDeadline = contractualDeadline;
                        lastNodeDelay = nodesDelay;
                        boolean usePDCStartDate = geometry.isUsePdcStartDate();
                        boolean withNodeDelayLabelExtended = geometry.isWithNodeDelayLabelExtended();
                        if (actualNodeEnd == null || lastCellResultIsInvalidated && isLastNodeResult) {
                            Double bottom;
                            nodeEnd = nodesDelay < 0 || usePDCStartDate ? contractualDeadline : today;
                            if (withNodeDelayLabelExtended) {
                                String color;
                                String nodesDelayStr = "";
                                if (nodesDelay < -1 || nodesDelay > 1) {
                                    String greaterOnePastString = MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgPastGreaterOne"), String.valueOf(Math.abs(nodesDelay)));
                                    String greaterOneFutureString = MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgFutureGreaterOne"), String.valueOf(Math.abs(nodesDelay)));
                                    nodesDelayStr = nodesDelayStr + (nodesDelay < -1 ? greaterOnePastString : greaterOneFutureString);
                                } else {
                                    String pastOneString = this.resourceBundle.getString("smallReviewCycleSvgPastOne");
                                    String futureOneString = this.resourceBundle.getString("smallReviewCycleSvgFutureOne");
                                    String todayString = this.resourceBundle.getString("smallReviewCycleSvgToday");
                                    nodesDelayStr = nodesDelayStr + (nodesDelay == -1 ? pastOneString : (nodesDelay == 1 ? futureOneString : todayString));
                                }
                                bottom = geometry.getBottom();
                                Double xToday = geometry.getxToday();
                                String string = color = nodesDelay < 0 ? "stroke:red;" : "stroke:black;";
                                if (log.isDebugEnabled()) {
                                    log.debug("Drawing text, case withNodeDelayLabelExtended");
                                    log.debug("... xtoDay [" + xToday + "], withNodeDelayLabelExtended [" + withNodeDelayLabelExtended + "], bottom [" + bottom + "], height_bar [" + 20.0 + "], nodesDelay [" + nodesDelay + "], nodesDelayStr [" + nodesDelayStr + "]");
                                }
                                SvgHelper.addTextWithFillFontFamilyWeightAndSize(xsw, xToday - (double)(withNodeDelayLabelExtended ? 40 : 20), bottom - 20.0 - 8.0, nodesDelayStr, color, "verdana", null, 12.0);
                            } else {
                                String color = nodesDelay < 0 ? "red;" : "black;";
                                bottom = geometry.getBottom();
                                Double xToday = geometry.getxToday();
                                if (log.isDebugEnabled()) {
                                    log.debug("Drawing text, case NOT withNodeDelayLabelExtended");
                                    log.debug("... xtoDay [" + xToday + "], bottom [" + bottom + "], height_bar [" + 20.0 + "], nodesDelayStr [" + Integer.toString(nodesDelay) + "]");
                                }
                                renderInfo.delay = nodesDelay;
                                SvgHelper.addTextWithFillFontFamilyWeightAndSize(xsw, xToday - 20.0, bottom - 20.0 - 8.0, Integer.toString(nodesDelay), color, "verdana", null, 12.0);
                            }
                        } else {
                            nodeEnd = nodesDelay < 0 ? contractualDeadline : actualNodeEnd;
                        }
                        Double axisStart = geometry.getAxisStart();
                        Double placePerUnit = geometry.getPlacePerUnit();
                        Double xStart = geometry.getxStart();
                        Double xToday = geometry.getxToday();
                        XnodeStart = nodeStart != null && nodeStart > axisStart ? SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, nodeStart, placePerUnit) + xStart : xStart;
                        XnodeEnd = nodeEnd != null ? SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, nodeEnd, placePerUnit) + xStart : xToday;
                        geometry.setCurrentXNodeEnd(XnodeEnd);
                        int typeOfEdges = ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeResultInfo, cycleInfo, nodesDelay < 0 || actualNodeEnd == null || lastCellResultIsInvalidated && isLastNodeResult && nodesDelay >= 0);
                        if (log.isDebugEnabled()) {
                            log.debug("draw done nodes checking the showOnlyCurrentNode flag");
                            log.debug("XnodeStart [" + XnodeStart + "], nodeEnd [" + nodeEnd + "], toDay [" + today + "], height_bar [" + 20.0 + "], duration [" + duration + "], typeOfEdges [" + typeOfEdges + "]");
                        }
                        if (Math.abs(XnodeStart - xToday) > 1.0E-9 && actualNodeEnd != null && !geometry.isShowOnlyCurrentNode()) {
                            this.drawNode(xsw, geometry, XnodeStart, nodeEnd != null ? nodeEnd : today, 10.0, 20.0, cellColor, false, nodesDelay, typeOfEdges);
                        } else if (actualNodeEnd == null || lastCellResultIsInvalidated && isLastNodeResult) {
                            this.drawNode(xsw, geometry, XnodeStart, nodeEnd != null ? nodeEnd : today, 10.0, 20.0, cellColor, false, duration, typeOfEdges);
                        }
                        XnodeStart = XnodeEnd;
                        boolean showOnlyCurrentNode = geometry.isShowOnlyCurrentNode();
                        if (actualNodeEnd != null && nodesDelay < 0 && !showOnlyCurrentNode) {
                            nodeEnd = lastCellResultIsInvalidated && isLastNodeResult ? today : actualNodeEnd;
                            int typeOfEdges2 = ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeResultInfo, cycleInfo, false);
                            if (log.isDebugEnabled()) {
                                log.debug("draw the delayed node section of done nodes");
                                log.debug("XnodeStart [" + XnodeStart + "], nodeEnd [" + nodeEnd + "], toDay [" + today + "], height_bar [" + 20.0 + "], duration [" + duration + "], typeOfEdges [" + typeOfEdges + "]");
                            }
                            this.drawNode(xsw, geometry, XnodeStart, nodeEnd != null ? nodeEnd : today, 10.0, 20.0, "#ff0000; opacity:0.5", false, nodesDelay, typeOfEdges2 - typeOfEdges);
                        }
                        lastNodeResult = nodeResultInfo;
                        geometry.setLastNodeEnd(nodeEnd);
                    }
                    if ((resultOptionId = nodeResultInfo.getNodeResultResultOptionId()) == null || resultOptionId.longValue() == emptyNodeOptionId.longValue()) continue;
                    firstNotEmptyNode = false;
                }
            }
            firstNotEmptyNode = false;
        }
        if (lastContractualDeadline != null) {
            this.evalPopupTaskNodeProgress(popupWriter, lastContractualDeadline, lastNodeDelay);
        }
        return lastNodeResult;
    }

    private void evalPopupDocumentNodeProgress(XMLStreamWriter popupWriter, Double deadline, int remainingTime, int preDuration) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
        popupWriter.writeStartElement("small");
        popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgDeadline") + " ");
        popupWriter.writeEndElement();
        popupWriter.writeCharacters(dateFormat.format(deadline * 1000.0));
        popupWriter.writeStartElement("br");
        if (remainingTime < 0 || remainingTime >= 0 && remainingTime <= 3) {
            popupWriter.writeStartElement("span");
            popupWriter.writeAttribute("style", remainingTime < 0 ? "color:red;" : "font-weight:bold;");
            if (remainingTime == 1) {
                popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgTaskToBeDoneTomorrow"));
            } else if (remainingTime == -1) {
                popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgTaskDelayedOneDay"));
            } else if (remainingTime < 1) {
                popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgTaskDelayedMultipleDays"), Math.abs(remainingTime)));
            } else {
                popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgTaskToBeDoneXDays"), Math.abs(remainingTime)));
            }
            popupWriter.writeEndElement();
        } else {
            popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgTaskToBeDoneXDays"), Math.abs(remainingTime)));
        }
        if (preDuration != 0) {
            popupWriter.writeStartElement("br");
            if (this.reversePreduration == null || !this.reversePreduration.booleanValue()) {
                if (preDuration == 1) {
                    popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgPreDurationOne"));
                } else {
                    popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgPreDuration"), Math.abs(preDuration)));
                }
            } else if (preDuration == 1) {
                popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgNegativePreDurationOne"));
            } else {
                popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgNegativePreDuration"), Math.abs(preDuration)));
            }
        }
    }

    private void evalPopupTaskNodeProgress(XMLStreamWriter popupWriter, Double deadline, int remainingTime) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
        popupWriter.writeStartElement("small");
        popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgDeadline") + " ");
        popupWriter.writeEndElement();
        popupWriter.writeCharacters(dateFormat.format(deadline * 1000.0));
        popupWriter.writeStartElement("br");
        if (remainingTime < 0) {
            popupWriter.writeStartElement("span");
            popupWriter.writeAttribute("style", "color:red;");
            if (Math.abs(remainingTime) == 1) {
                popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgDelayedOneDay"));
            } else {
                popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgDelayedMultipleDays"), Math.abs(remainingTime)));
            }
            popupWriter.writeEndElement();
        } else if (remainingTime == 0) {
            popupWriter.writeStartElement("span");
            popupWriter.writeAttribute("style", "font-weight:bold;");
            popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgToBeDoneToday"));
            popupWriter.writeEndElement();
        } else {
            popupWriter.writeStartElement("span");
            popupWriter.writeAttribute("style", "font-weight:bold");
            if (remainingTime == 1) {
                popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgToBeDoneTomorrow"));
            } else {
                popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgToBeDoneXDays"), remainingTime));
            }
            popupWriter.writeEndElement();
        }
    }

    private void evalPopupCycleProgress(XMLStreamWriter popupWriter, DocumentListRow documentListRow, int overallDelay, boolean showCurrentPosition, boolean showOnlyPDCSchedule) throws Exception {
        Double docStartDate = documentListRow.getDocumentReleaseStartDate();
        Double docEndDate = documentListRow.getDocumentReleaseEndDate();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
        String targetDeadline = this.resourceBundle.getString("smallReviewCycleSvgNotDefined");
        if (docStartDate != null) {
            targetDeadline = dateFormat.format(docStartDate * 1000.0);
        }
        targetDeadline = docEndDate != null ? targetDeadline + " " + this.resourceBundle.getString("smallReviewCycleSvgTo") + " " + dateFormat.format(docEndDate * 1000.0) : targetDeadline + " " + this.resourceBundle.getString("smallReviewCycleSvgToUndefined");
        popupWriter.writeStartElement("br");
        popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgPLKDeadlines"));
        popupWriter.writeStartElement("br");
        popupWriter.writeCharacters("" + targetDeadline);
        if (showOnlyPDCSchedule) {
            return;
        }
        if (docEndDate != null) {
            popupWriter.writeStartElement("br");
            if (overallDelay == 0) {
                popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgPLKToBeDoneToday"));
            } else if (overallDelay == -1) {
                popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgPLKDelayedOneDay"));
            } else if (overallDelay == 1) {
                popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgPLKToBeDoneTomorrow"));
            } else if (overallDelay < -1) {
                popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgPLKDelayedMultipleDays"), Math.abs(overallDelay)));
            } else {
                popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgPLKToBeDoneXDays"), Math.abs(overallDelay)));
            }
        } else {
            popupWriter.writeStartElement("br");
            popupWriter.writeCharacters("\n" + this.resourceBundle.getString("smallReviewCycleSvgPLKNoDate"));
        }
    }

    private void evalPopupDocumentVersionStatus(XMLStreamWriter popupWriter, DocumentListRow documentListRow, ReviewCycleInfo reviewCycleInfo) throws Exception {
        popupWriter.writeStartElement("hr");
        popupWriter.writeStartElement("small");
        popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgCurrentLocation"));
        popupWriter.writeEndElement();
        popupWriter.writeStartElement("br");
        Long nodeId = documentListRow.getReviewCycleNodeInstanceNodeId();
        Long cellId = reviewCycleInfo.getNodeCellId(nodeId);
        String cellName = reviewCycleInfo.getCellName(cellId);
        String nodeName = reviewCycleInfo.getNodeName(nodeId);
        popupWriter.writeCharacters(cellName + " - " + nodeName);
        int openPositionCount = documentListRow.getOpenPositionCount();
        int signedPositionResultCount = documentListRow.getSignedPositionResultCount();
        int totalCount = openPositionCount + signedPositionResultCount;
        if (!reviewCycleInfo.isEndNode(nodeId)) {
            if (openPositionCount > 0 || signedPositionResultCount > 0) {
                popupWriter.writeStartElement("br");
                if (openPositionCount == totalCount) {
                    if (totalCount == 1) {
                        popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgOneReviewOpen"));
                    } else {
                        popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgAllReviewsOpen"), openPositionCount));
                    }
                } else {
                    popupWriter.writeCharacters(MessageFormat.format(this.resourceBundle.getString("smallReviewCycleSvgSomeReviewsOpen"), openPositionCount, totalCount));
                }
            } else {
                popupWriter.writeCharacters(" (-) ");
            }
        }
        if (openPositionCount > 0) {
            this.evalReviewers(popupWriter, documentListRow);
        }
    }

    private void evalReviewers(XMLStreamWriter popupWriter, DocumentListRow documentListRow) throws Exception {
        popupWriter.writeStartElement("br");
        popupWriter.writeStartElement("small");
        popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgOpenPositionCaption"));
        popupWriter.writeEndElement();
        Set participationStringsSet = documentListRow.getOpenPositionParticipationStrings();
        ArrayList participationStrings = new ArrayList();
        participationStrings.addAll(participationStringsSet);
        Collections.sort(participationStrings);
        for (String s : participationStrings) {
            popupWriter.writeStartElement("br");
            popupWriter.writeCharacters("- " + s);
        }
    }

    private void evalPlanner(XMLStreamWriter popupWriter, DocumentListRow documentListRow) throws Exception {
        popupWriter.writeStartElement("br");
        popupWriter.writeStartElement("small");
        popupWriter.writeCharacters(this.resourceBundle.getString("smallReviewCycleSvgPlannerCaption"));
        popupWriter.writeEndElement();
        popupWriter.writeCharacters(" " + documentListRow.getPlannerOrganisationName() + " (" + documentListRow.getPlannerMainPersonGivenName() + " " + documentListRow.getPlannerMainPersonSurName() + ")");
    }

    private Double drawRemainingCells(XMLStreamWriter xsw, DocumentListOtherVersionNodeResultInfo lastNodeResultInfo, DocumentListRow documentListRow, ReviewCycleInfo reviewCycleInfo, Double lastNodeEnd, double lastXnodeEnd, SmallReviewCycleSvgGeometry geometry) throws Exception {
        ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo;
        boolean isEndNode;
        if (log.isDebugEnabled()) {
            log.debug("================================================");
            log.debug("drawRemainingCells");
            log.debug("================================================");
        }
        HolidayCalculator holidayCalculator = geometry.getHolidayCalculator();
        Double desiredNodeEnd = lastNodeEnd;
        if (log.isDebugEnabled()) {
            log.debug("... lastNodeEnd [" + lastNodeEnd + "], lastXnodeEnd [" + lastXnodeEnd + "]");
        }
        double XnodeStart = lastXnodeEnd;
        String cellColor = null;
        int nodeDelay = 0;
        int typeOfEdges = 0;
        Double today = geometry.getToday();
        DocumentListOtherVersionCellResultInfo lastCellResultInfo = null;
        DocumentListOtherVersionCellResultInfo lastNodeResultCellResultInfo = null;
        if (lastNodeResultInfo != null) {
            lastCellResultInfo = documentListRow.getLastOtherVersionActualCellResultInfo();
            Long lastNodeResultCellResultId = lastNodeResultInfo.getNodeResultCellResultId();
            boolean lastCellResult = lastCellResultInfo != null && lastNodeResultCellResultId != null && lastCellResultInfo.getCellResultId().longValue() == lastNodeResultCellResultId.longValue();
            lastNodeResultCellResultInfo = documentListRow.getByCellResultId(lastNodeResultCellResultId);
            Long emptyNodeOptionId = lastNodeResultCellResultInfo.getCycleEmptyNodeResultOptionId();
            Long invalidateNodeOptionId = lastNodeResultCellResultInfo.getCycleDocumentVersionInvalidationResultOptionId();
            Long deletedNodeOptionId = lastNodeResultCellResultInfo.getCycleDocumentVersionDeletedOptionId();
            Long lastResultOptionId = lastNodeResultInfo.getNodeResultResultOptionId();
            boolean lastCellResultIsInvalidated = lastCellResult && lastResultOptionId != null && (invalidateNodeOptionId != null && lastResultOptionId.longValue() == invalidateNodeOptionId.longValue() || deletedNodeOptionId != null && lastResultOptionId.longValue() == deletedNodeOptionId.longValue());
            cellColor = lastNodeResultCellResultInfo.getCellSvgColor();
            boolean allPreviousNodesAreNotEmpty = true;
            List reviewCycleNodeResults = lastNodeResultCellResultInfo.getAllNodeResultInfos();
            for (DocumentListOtherVersionNodeResultInfo reviewCycleNodeResult : reviewCycleNodeResults) {
                boolean finished = reviewCycleNodeResult.isNodeResultFinished();
                isEndNode = reviewCycleNodeResult.isEndNode();
                if (!finished || isEndNode) continue;
                Long nodeResultOptionId = reviewCycleNodeResult.getNodeResultResultOptionId();
                allPreviousNodesAreNotEmpty &= nodeResultOptionId == null || emptyNodeOptionId != null && nodeResultOptionId.longValue() != emptyNodeOptionId.longValue();
            }
            if (lastCellResultIsInvalidated) {
                Double actualNodeEnd = ReviewProtocolSvgRenderer.verifyDocumentDepartureDate(lastNodeResultInfo);
                int duration = lastNodeResultInfo.getNodeInstanceReleasedDuration();
                Double contractualDeadline = holidayCalculator.addWorkingDays(actualNodeEnd, duration);
                nodeDelay = holidayCalculator.getWorkingDaysBetween(today, contractualDeadline);
            } else {
                ReviewProtocolSvgRenderer.DelayInfo nodesData = ReviewProtocolSvgRenderer.calculateDelayOfActualNode(holidayCalculator, lastNodeResultInfo, null);
                nodeDelay = nodesData.getNodesDelay();
            }
            boolean endOfCell = reviewCycleInfo.isNodeEndOfCell(lastNodeResultInfo.getNodeId());
            int n = typeOfEdges = endOfCell ? 1 : 0;
        }
        if (lastNodeResultInfo != null && !lastNodeResultInfo.isNodeFree()) {
            if (nodeDelay >= 0) {
                boolean usePDCStartDate;
                if (log.isDebugEnabled()) {
                    log.debug("node in time, delay=" + nodeDelay);
                }
                if (!(usePDCStartDate = geometry.isUsePdcStartDate())) {
                    desiredNodeEnd = holidayCalculator.addWorkingDays(desiredNodeEnd, nodeDelay);
                    if (log.isDebugEnabled()) {
                        log.debug("Finish actual node, if-clause");
                        log.debug("XnodeStart [" + XnodeStart + "], desiredNodeEnd [" + desiredNodeEnd + "], height_bar [" + 20.0 + "], cellColor [" + cellColor + "], nodeDelay [" + nodeDelay + "], typeOfEdges [" + typeOfEdges + "]");
                    }
                    XnodeStart = this.drawNode(xsw, geometry, XnodeStart, desiredNodeEnd, 10.0, 20.0, cellColor + "; opacity:0.7", true, nodeDelay, typeOfEdges);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("node delayed, delay=" + nodeDelay);
                }
                desiredNodeEnd = today;
                if (log.isDebugEnabled()) {
                    log.debug("Finish actual node, else-clause");
                    log.debug("XnodeStart [" + XnodeStart + "], desiredNodeEnd [" + desiredNodeEnd + "], height_bar [" + 20.0 + "], cellColor [" + cellColor + "], nodeDelay [" + nodeDelay + "], typeOfEdges [" + typeOfEdges + "]");
                }
                XnodeStart = this.drawNode(xsw, geometry, XnodeStart, desiredNodeEnd, 10.0, 20.0, "#ff0000; opacity:0.5", false, nodeDelay, typeOfEdges);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("About to enter section 'finish actual cell'");
        }
        boolean showOnlyCurrentNode = geometry.isShowOnlyCurrentNode();
        Long lastCellId = lastCellResultInfo != null ? lastCellResultInfo.getCellId() : null;
        ReviewCycleCellInstanceReleasedInfo reviewCycleCellInstanceReleasedInfo = cellInstanceReleasedInfo = lastCellId != null ? documentListRow.getCellInstanceReleasedInfoByCellId(lastCellId) : null;
        if (lastNodeResultInfo != null && cellInstanceReleasedInfo != null) {
            int lastNodeResultPosition = lastNodeResultInfo.getNodePosition();
            List nodeInstanceReleasedInfos = cellInstanceReleasedInfo.getAllNodeInstanceReleasedInfos();
            if (log.isDebugEnabled()) {
                log.debug("... Having lastNodeResult and cellInstanceRelease; found [" + nodeInstanceReleasedInfos.size() + "] nodeInstances.");
            }
            for (ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo : nodeInstanceReleasedInfos) {
                int position = nodeInstanceReleasedInfo.getNodePosition();
                if (position > lastNodeResultPosition) {
                    if (log.isDebugEnabled()) {
                        log.debug("...... Processing nodeInstanceRel [" + nodeInstanceReleasedInfo.getNodeInstanceReleasedId() + "], position [" + position + "], lastNodeResult.node.position [" + lastNodeResultPosition + "], count [" + nodeInstanceReleasedInfos.size() + "]");
                    }
                    boolean positionsExist = nodeInstanceReleasedInfo.hasNodePositionReleasedInfos();
                    boolean isEndCell = cellInstanceReleasedInfo.isEndCell();
                    Integer duration = nodeInstanceReleasedInfo.getNodeInstanceReleasedDuration();
                    Long nodeId = nodeInstanceReleasedInfo.getNodeId();
                    isEndNode = reviewCycleInfo.isEndNode(nodeId);
                    if (log.isDebugEnabled()) {
                        log.debug("......... Position count [" + nodeInstanceReleasedInfo.getNodePositionReleasedCount() + "] positionExists [" + positionsExist + "], isEndCell [" + isEndCell + "], duration [" + duration + "], nodeId [" + nodeId + "], isEndNode [" + isEndNode + "]");
                    }
                    if (!positionsExist && (isEndCell || !isEndNode)) continue;
                    desiredNodeEnd = holidayCalculator.addWorkingDays(desiredNodeEnd, duration);
                    if (log.isDebugEnabled()) {
                        log.debug("......... desiredNodeEnd [" + desiredNodeEnd + "], showOnlyCurrentNode [" + showOnlyCurrentNode + "]");
                    }
                    if (showOnlyCurrentNode) continue;
                    int n = typeOfEdges = reviewCycleInfo.isNodeEndOfCell(nodeInstanceReleasedInfo.getNodeId()) ? 1 : 0;
                    if (log.isDebugEnabled()) {
                        log.debug("......... FinishActualCell");
                        log.debug("......... XnodeStart [" + XnodeStart + "], desiredNodeEnd [" + desiredNodeEnd + "], height_bar [" + 20.0 + "], cellColor [" + cellColor + "], nodeDelay [" + nodeDelay + "], typeOfEdges [" + typeOfEdges + "]");
                    }
                    XnodeStart = this.drawNode(xsw, geometry, XnodeStart, desiredNodeEnd, 10.0, 20.0, cellColor + "; opacity:0.3", true, duration, typeOfEdges);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("...... Ignoring nodeInstanceRel [" + nodeInstanceReleasedInfo.getNodeInstanceReleasedId() + "], position [" + position + "], lastNodeResult.node.position [" + lastNodeResultPosition + "], count [" + nodeInstanceReleasedInfos.size() + "]");
            }
            List restOfCells = documentListRow.getAllCellInstanceReleasedInfos();
            boolean start = false;
            Long prevCellId = null;
            for (ReviewCycleCellInstanceReleasedInfo restCellInstRel : restOfCells) {
                if (log.isDebugEnabled()) {
                    log.debug("Processing restCellInstRel [" + restCellInstRel.getCellInstanceReleasedId() + "], start [" + start + "]");
                }
                Long cellId = restCellInstRel.getCellId();
                boolean defaultWay = false;
                if (start) {
                    cellColor = restCellInstRel.getCellSvgColor();
                    List nodeInstances = restCellInstRel.getAllNodeInstanceReleasedInfos();
                    List connections = reviewCycleInfo.getIncomingConnectionsForCell(cellId);
                    for (ReviewCycleCellConnection connection : connections) {
                        if (log.isDebugEnabled()) {
                            log.debug("... evaluating ReviewCycleCellConnection [" + connection.getId() + "]");
                        }
                        if (prevCellId == null || connection.getSourceCellId().longValue() != prevCellId.longValue() || connection.getIsDefaultConnection() == null || !connection.getIsDefaultConnection().booleanValue()) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("...... defaultWay = true since sourceCell = [" + prevCellId + "] and defaultConnection");
                        }
                        defaultWay = true;
                        break;
                    }
                    prevCellId = restCellInstRel.getCellId();
                    if (!defaultWay) {
                        if (log.isDebugEnabled()) {
                            log.debug("... returning desiredNodeEnd [" + desiredNodeEnd + "] because of !defaultWay");
                        }
                        return desiredNodeEnd;
                    }
                    for (ReviewCycleNodeInstanceReleasedInfo restNodeInstanceRel : nodeInstances) {
                        if (log.isDebugEnabled()) {
                            log.debug("... Processing restNodeInstanceRel [" + restNodeInstanceRel.getNodeInstanceReleasedId() + "] with isFree = [" + restNodeInstanceRel.isNodeFree() + "]");
                        }
                        if (restNodeInstanceRel.isNodeFree()) continue;
                        Long nodeId = restNodeInstanceRel.getNodeId();
                        boolean isEndNode2 = reviewCycleInfo.isEndNode(nodeId);
                        if (log.isDebugEnabled()) {
                            log.debug("...... #positions [" + restNodeInstanceRel.getNodePositionReleasedCount() + "]; cellIsEndCell [" + restCellInstRel.isEndCell() + "]; nodeIsEndNode [" + isEndNode2 + "]");
                        }
                        if (!restNodeInstanceRel.hasNodePositionReleasedInfos() && (restCellInstRel.isEndCell() || !isEndNode2)) continue;
                        Integer duration = restNodeInstanceRel.getNodeInstanceReleasedDuration();
                        desiredNodeEnd = holidayCalculator.addWorkingDays(desiredNodeEnd, duration);
                        if (log.isDebugEnabled()) {
                            log.debug("......... duration [" + duration + "], desiredNodeEnd [" + desiredNodeEnd + "], showOnlyCurrentNode [" + showOnlyCurrentNode + "]");
                        }
                        if (showOnlyCurrentNode) continue;
                        typeOfEdges = ReviewProtocolSvgCalculator.calculateTypeOfEdges(restNodeInstanceRel, reviewCycleInfo, false);
                        if (log.isDebugEnabled()) {
                            log.debug("analyse remaining cells and nodes");
                            log.debug("XnodeStart [" + XnodeStart + "], desiredNodeEnd [" + desiredNodeEnd + "], height_bar [" + 20.0 + "], cellColor [" + cellColor + "], nodeDelay [" + nodeDelay + "], typeOfEdges [" + typeOfEdges + "]");
                        }
                        XnodeStart = this.drawNode(xsw, geometry, XnodeStart, desiredNodeEnd, 10.0, 20.0, cellColor + "; opacity:0.3", true, duration, typeOfEdges);
                    }
                }
                if (lastNodeResultCellResultInfo == null || restCellInstRel.getCellId().longValue() != lastNodeResultCellResultInfo.getCellId().longValue()) continue;
                start = true;
                prevCellId = lastNodeResultCellResultInfo.getCellId();
            }
        }
        return desiredNodeEnd;
    }

    private void drawEntryNode(XMLStreamWriter xsw, XMLStreamWriter popupWriter, DocumentListRow documentListRow, ReviewCycleInfo cycleInfo, SmallReviewCycleSvgGeometry geometry) throws Exception {
        Double popupDeadline;
        double XnodeStart;
        if (log.isDebugEnabled()) {
            log.debug("====================================");
            log.debug("Called drawEntryNode");
            log.debug("====================================");
        }
        int nodesDelay = 0;
        Double now = new Double((double)System.currentTimeMillis() / 1000.0);
        Double nodeStart = documentListRow.getDocumentReleaseStartDate();
        if (nodeStart == null) {
            return;
        }
        int preDuration = documentListRow.getReviewCycleInstanceReleasedDurationPre();
        HolidayCalculator holidayCalculator = geometry.getHolidayCalculator();
        Double axisStart = geometry.getAxisStart();
        Double placePerUnit = geometry.getPlacePerUnit();
        Double xStart = geometry.getxStart();
        if (!(preDuration == 0 || this.reversePreduration != null && this.reversePreduration.booleanValue())) {
            Double nodePreStart = holidayCalculator.addWorkingDays(nodeStart, -preDuration);
            double d = XnodeStart = nodePreStart > axisStart ? SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, nodePreStart, placePerUnit) + xStart : xStart;
            if (log.isDebugEnabled()) {
                log.debug("Sonderbalken Vorlaufdauer am Anfang des Pr\u00fcflaufs");
                log.debug("XnodeStart [" + XnodeStart + "], nodeStart [" + nodeStart + "], height_bar [" + 20.0 + "], preDuration [" + preDuration + "]");
            }
            this.drawNode(xsw, geometry, XnodeStart, nodeStart, 10.0, 10.0, "#ffff00; opacity:0.8;", false, preDuration, -3);
            nodesDelay = holidayCalculator.getWorkingDaysBetween(now, nodePreStart);
            popupDeadline = nodePreStart;
        } else {
            nodesDelay = holidayCalculator.getWorkingDaysBetween(now, nodeStart);
            popupDeadline = nodeStart;
        }
        XnodeStart = nodeStart > axisStart ? SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, nodeStart, placePerUnit) + xStart : xStart;
        Double bottom = geometry.getBottom();
        Double height = geometry.getHeight();
        if (preDuration != 0 && !this.reversePreduration.booleanValue() && nodeStart > axisStart) {
            SvgHelper.addMilestone(xsw, XnodeStart, bottom - height / 2.0 + 20.0, 15.0, 7.5, "fill:#000077;stroke:black;stroke-width:0.5px;");
        }
        if (nodesDelay < 0 && preDuration == 0) {
            if (log.isDebugEnabled()) {
                log.debug("entryNode is delayed");
                log.debug("XnodeStart [" + XnodeStart + "], now [" + now + "], height_bar [" + 20.0 + "], nodesDelay [" + nodesDelay + "], xStart [" + xStart + "]");
            }
            XnodeStart = this.drawNode(xsw, geometry, XnodeStart + (XnodeStart > xStart ? 3.75 : 0.0), now, 10.0, 15.0, "#ff0000; opacity:0.5", true, nodesDelay, XnodeStart > xStart ? 3 : 1);
            nodeStart = now;
        }
        List cellInstanceReleasedInfos = documentListRow.getAllCellInstanceReleasedInfos();
        for (ReviewCycleCellInstanceReleasedInfo cellInst : cellInstanceReleasedInfos) {
            String color = cellInst.getCellSvgColor();
            List nodeInstances = cellInst.getAllNodeInstanceReleasedInfos();
            for (ReviewCycleNodeInstanceReleasedInfo nodeInstanceRel : nodeInstances) {
                if (nodeInstanceRel == null) continue;
                Long nodeId = nodeInstanceRel.getNodeId();
                boolean isEndNode = cycleInfo.isEndNode(nodeId);
                if (!nodeInstanceRel.hasNodePositionReleasedInfos() && (cellInst.isEndCell() || !isEndNode)) continue;
                Double nodeEnd = holidayCalculator.addWorkingDays(nodeStart, nodeInstanceRel.getNodeInstanceReleasedDuration());
                int typeOfEdges = !geometry.isShowOnlyCurrentNode() ? ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeInstanceRel, cycleInfo, false) : 3;
                if (log.isDebugEnabled()) {
                    log.debug("analyse remaining cells and nodes");
                    log.debug("XnodeStart [" + XnodeStart + "], nodeEnd [" + nodeEnd + "], height_bar [" + 20.0 + "], duration [" + nodeInstanceRel.getNodeInstanceReleasedDuration() + "], typeOfEdges [" + typeOfEdges + "]");
                }
                XnodeStart = this.drawNode(xsw, geometry, XnodeStart, nodeEnd, 10.0, 20.0, color + "; opacity:0.3", true, nodeInstanceRel.getNodeInstanceReleasedDuration(), typeOfEdges);
                nodeStart = nodeEnd;
                if (!geometry.isShowOnlyCurrentNode()) continue;
                break;
            }
            if (!geometry.isShowOnlyCurrentNode()) continue;
            break;
        }
        Double xToday = geometry.getxToday();
        boolean withNodeDelayLabelExtended = geometry.isWithNodeDelayLabelExtended();
        if (geometry.isWithNodeDelayLabelExtended()) {
            String drawColor;
            String i18nSymbol;
            String nodesDelayStr = "";
            if (nodesDelay < -1 || nodesDelay > 1) {
                i18nSymbol = nodesDelay < -1 ? "smallReviewCycleSvgPastGreaterOne" : "smallReviewCycleSvgFutureGreaterOne";
                String text = MessageFormat.format(this.resourceBundle.getString(i18nSymbol), Math.abs(nodesDelay));
                nodesDelayStr = nodesDelayStr + text;
            } else {
                i18nSymbol = nodesDelay == -1 ? "smallReviewCycleSvgPastOne" : (nodesDelay == 1 ? "smallReviewCycleSvgFutureOne" : "smallReviewCycleSvgToday");
                nodesDelayStr = nodesDelayStr + this.resourceBundle.getString(i18nSymbol);
            }
            String string = drawColor = nodesDelay < 0 ? "red" : "blue";
            if (log.isDebugEnabled()) {
                log.debug("Case withNodeDelayLabelExtended, xtoDay [" + xToday + "], bottom [" + bottom + "], height_bar [" + 20.0 + "], nodesDelay [" + nodesDelay + "], nodesDelayStr [" + nodesDelayStr + "]");
            }
            SvgHelper.addTextWithFillFontFamilyWeightAndSize(xsw, xToday - (double)(withNodeDelayLabelExtended ? 40 : 20), bottom - 20.0 - 8.0, nodesDelayStr, drawColor, "verdana", null, 12.0);
        } else {
            String drawColor;
            String string = drawColor = nodesDelay < 0 ? "red" : "black";
            if (log.isDebugEnabled()) {
                log.debug("Case NOT withNodeDelayLabelExtended, xtoDay [" + xToday + "], bottom [" + bottom + "], height_bar [" + 20.0 + "], nodesDelay [" + nodesDelay + "], nodesDelayString [" + Integer.toString(nodesDelay) + "]");
            }
            SvgHelper.addTextWithFillFontFamilyWeightAndSize(xsw, xToday - (double)(withNodeDelayLabelExtended ? 40 : 20), bottom - 20.0 - 8.0, Integer.toString(nodesDelay), drawColor, "verdana", null, 12.0);
        }
        boolean showDocumentStatus = true;
        if (showDocumentStatus) {
            this.evalPopupDocumentNodeProgress(popupWriter, popupDeadline, nodesDelay, preDuration);
            this.evalPlanner(popupWriter, documentListRow);
        } else {
            this.evalPopupTaskNodeProgress(popupWriter, popupDeadline, nodesDelay);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double drawNode(XMLStreamWriter xsw, SmallReviewCycleSvgGeometry geometry, double XstartNode, Double endNode, double posCenter, double bHight, String fill, boolean dashed, int duration, int typeEdges) throws Exception {
        Double axisStart = geometry.getAxisStart();
        Double placePerUnit = geometry.getPlacePerUnit();
        Double xStart = geometry.getxStart();
        Double width = geometry.getWidth();
        Double height = geometry.getHeight();
        Double bottom = geometry.getBottom();
        double XendNode = SmallReviewCycleSvgRenderer.getXPositionFromDate(axisStart, endNode, placePerUnit) + xStart;
        if (log.isDebugEnabled()) {
            log.debug("............ drawNode, XendNode now [" + XendNode + "], input startAxis [" + axisStart + "], endNode [" + endNode + "], placePerUnit [" + placePerUnit + "]");
        }
        if (XendNode > xStart + width) {
            XendNode = xStart + width;
        }
        if (!(XendNode > xStart) || !(XstartNode < xStart + width)) return XendNode;
        if (XstartNode != XendNode) {
            String style = "fill:" + fill + ";stroke:black;" + (dashed ? "stroke-width:1px;stroke-dasharray:3,2;" : "stroke-width:0.5px;");
            if (typeEdges == SvgCorner.NOCORNER.getValue()) {
                SvgHelper.addRectWithEdges(xsw, XstartNode, bottom - posCenter - bHight / 2.0, 0.0, 0.0, 0.0, 0.0, XendNode - XstartNode, bHight, true, true, style);
            } else if (typeEdges == SvgCorner.CORNER_LINEAR_LEFT.getValue()) {
                SvgHelper.addRectWithEdges(xsw, XstartNode, bottom - posCenter - bHight / 2.0, -bHight / 4.0, bHight / 2.0, 0.0, 0.0, XendNode - XstartNode, bHight, false, true, style);
            } else if (typeEdges == SvgCorner.CORNER_LINEAR_RIGHT.getValue()) {
                SvgHelper.addRectWithEdges(xsw, XstartNode, bottom - posCenter - bHight / 2.0, 0.0, 0.0, bHight / 4.0, bHight / 2.0, XendNode - XstartNode, bHight, true, false, style);
            } else if (typeEdges == SvgCorner.CORNER_LINEAR_BOTH.getValue()) {
                SvgHelper.addRectWithEdges(xsw, XstartNode, bottom - posCenter - bHight / 2.0, -bHight / 4.0, bHight / 2.0, bHight / 4.0, bHight / 2.0, XendNode - XstartNode, bHight, false, false, style);
            } else {
                if (typeEdges != SvgCorner.CORNER_LINEAR_BOTH_INV.getValue()) throw new IllegalArgumentException("Unsuppported TypeOfEdges: [" + typeEdges + "]");
                SvgHelper.addRectWithEdges(xsw, XstartNode, bottom - posCenter - bHight / 2.0, -bHight / 4.0, bHight / 2.0, -bHight / 4.0, bHight / 2.0, XendNode - XstartNode, bHight, false, false, style);
            }
        } else {
            SvgHelper.addCircle(xsw, XstartNode, bottom - posCenter, 2.0, "fill:black;");
        }
        boolean withNodeDurationLabel = geometry.isWithNodeDurationLabel();
        if (!withNodeDurationLabel) return XendNode;
        SvgHelper.addTextWithFillFontFamilyWeightAndSize(xsw, XstartNode, bottom - posCenter - bHight / 2.0, Integer.toString(duration), null, "verdana", null, 8.0);
        return XendNode;
    }

    static {
        XOF.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        SVG_NAMESPACE_CONTEXT = SvgHelper.constructSvgNamespaceContext();
        log = LoggerFactory.getLogger(SmallReviewCycleSvgRenderer.class);
    }

    private class RenderInfo {
        Integer delay = null;

        private RenderInfo() {
        }
    }
}

