/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.RoleActionRule;
import at.cdes.api.dto.role.RoleActionEditInfo;
import at.cdes.api.dto.role.RoleEditInfo;
import at.cdes.api.dto.role.RolePageInfo;
import at.cdes.api.guiService.RoleService;
import at.cdes.api.joinDto.ActionRuleJoin;
import at.cdes.api.joinDto.RoleListJoin;
import at.cdes.api.voc.ProjectFlag;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.ActionRuleDAO;
import at.cdes.impl.dao.CdesRoleDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.RoleActionRuleDAO;
import at.cdes.impl.dao.RoleTypeDAO;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ContainerHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class RoleServiceImpl
implements RoleService {
    private ActionDAO actionDAO;
    private ActionRuleDAO actionRuleDAO;
    private CdesRoleDAO cdesRoleDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private RoleActionRuleDAO roleActionRuleDAO;
    private RoleTypeDAO roleTypeDAO;
    private ProjectDAO projectDAO;
    private Boolean enablePlanningNotificationModul;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setActionRuleDAO(ActionRuleDAO actionRuleDAO) {
        this.actionRuleDAO = actionRuleDAO;
    }

    public void setCdesRoleDAO(CdesRoleDAO cdesRoleDAO) {
        this.cdesRoleDAO = cdesRoleDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setRoleActionRuleDAO(RoleActionRuleDAO roleActionRuleDAO) {
        this.roleActionRuleDAO = roleActionRuleDAO;
    }

    public void setRoleTypeDAO(RoleTypeDAO roleTypeDAO) {
        this.roleTypeDAO = roleTypeDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setEnablePlanningNotificationModul(Boolean enablePlanningNotificationModul) {
        this.enablePlanningNotificationModul = enablePlanningNotificationModul;
    }

    public RolePageInfo getRolesByNetwork(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ROLES_OVERVIEW, Action.INSERT_ROLE, Action.EDIT_ROLE_ACTIONS, Action.SHOW_ROLE, Action.DELETE_ROLE, Action.EDIT_ROLE, Action.PLANNING_NOTIFICATION_SECTION_OVERVIEW);
        if (!globalActions.contains(Action.ROLES_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not view roles since privilege [" + Action.ROLES_OVERVIEW + "] is missing.");
        }
        RolePageInfo rolePageInfo = new RolePageInfo();
        boolean mayShowBuek = false;
        List allProjects = this.projectDAO.getAll();
        List<Long> projectIds = ContainerHelper.getPersistentIdsList(allProjects);
        mayShowBuek |= globalActions.contains(Action.PLANNING_NOTIFICATION_SECTION_OVERVIEW);
        Map<Long, Set<Action>> projectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.PLANNING_NOTIFICATION_OVERVIEW);
        for (Long projectId : projectIdToActions.keySet()) {
            mayShowBuek |= projectIdToActions.get(projectId).contains(Action.PLANNING_NOTIFICATION_OVERVIEW);
        }
        List<RoleListJoin> roleListJoins = this.cdesRoleDAO.getRoleListJoinsByNetwork(networkId, mayShowBuek &= this.enablePlanningNotificationModul.booleanValue());
        rolePageInfo.setRoleListJoins(roleListJoins);
        rolePageInfo.setMayInsertRole(globalActions.contains(Action.INSERT_ROLE));
        rolePageInfo.setMayShowRoleActions(globalActions.contains(Action.SHOW_ROLE));
        rolePageInfo.setMayEditRoleActions(globalActions.contains(Action.EDIT_ROLE_ACTIONS));
        rolePageInfo.setMayShowRole(globalActions.contains(Action.SHOW_ROLE));
        rolePageInfo.setMayEditRole(globalActions.contains(Action.EDIT_ROLE));
        rolePageInfo.setMayDeleteRole(globalActions.contains(Action.DELETE_ROLE));
        return rolePageInfo;
    }

    public RoleEditInfo getRoleEditInfo(Long organisationPersonId, Long roleId, Long networkId) {
        CdesRole role;
        boolean newMode;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        boolean bl = newMode = roleId == null;
        if (newMode) {
            role = new CdesRole();
            role.setNetworkId(networkId);
            role.setContextDefaultRoleFlag(Integer.valueOf(0));
        } else {
            role = (CdesRole)this.cdesRoleDAO.get(roleId);
            networkId = role.getNetworkId();
        }
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.INSERT_ROLE, Action.SHOW_ROLE, Action.EDIT_ROLE);
        boolean hasInsertRole = globalActions.contains(Action.INSERT_ROLE);
        boolean hasShowRole = globalActions.contains(Action.SHOW_ROLE);
        boolean hasEditRole = globalActions.contains(Action.EDIT_ROLE);
        if (newMode) {
            if (!hasInsertRole) {
                throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] may not insert a role into network [" + networkId + "], privilege [" + Action.INSERT_ROLE + "] is missing.");
            }
        } else if (!hasShowRole && !hasEditRole) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] may not show/edit a role in network [" + networkId + "], privileges [" + Action.EDIT_ROLE + "] and [" + Action.SHOW_ROLE + "] are both missing.");
        }
        List roleTypes = this.roleTypeDAO.getAll();
        RoleEditInfo roleEditInfo = new RoleEditInfo();
        roleEditInfo.setRole(role);
        roleEditInfo.setRoleTypes(roleTypes);
        roleEditInfo.setHasEditRole(hasEditRole);
        roleEditInfo.setHasInsertRole(hasInsertRole);
        roleEditInfo.setHasShowRole(hasShowRole);
        return roleEditInfo;
    }

    public RoleActionEditInfo getActionEditInfoByRoleId(Long organisationPersonId, Long roleId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        CdesRole role = (CdesRole)this.cdesRoleDAO.get(roleId);
        Long networkId = role.getNetworkId();
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_ROLE_ACTIONS);
        boolean hasEditRoleActions = globalActions.contains(Action.EDIT_ROLE_ACTIONS);
        if (!hasEditRoleActions) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not show/edit role actions for role [" + roleId + "] in network [" + networkId + "]; privilege [" + Action.EDIT_ROLE_ACTIONS + "] is missing.");
        }
        RoleActionEditInfo editInfo = new RoleActionEditInfo();
        List<ActionRuleJoin> actionRuleJoins = this.actionRuleDAO.getActionRuleJoinByRoleId(roleId);
        editInfo.setActionRuleJoins(actionRuleJoins);
        editInfo.setMayEditActions(hasEditRoleActions);
        return editInfo;
    }

    private boolean isSystemAdminAndActionNameSuperAdminRight(Long organisationPersonId) {
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT);
        return globalActions.contains(Action.SUPER_ADMIN_RIGHT);
    }

    public void saveRole(Long organisationPersonId, CdesRole role) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (role.getId() == null) {
            Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.INSERT_ROLE);
            if (!globalActions.contains(Action.INSERT_ROLE)) {
                throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not insert new role, privilege [" + Action.INSERT_ROLE + "] is missing.");
            }
        } else {
            Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_ROLE);
            if (!globalActions.contains(Action.EDIT_ROLE)) {
                throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not save edited role [" + role.getId() + "] in network [" + role.getNetworkId() + "], privilege [" + Action.EDIT_ROLE + "] is missing.");
            }
        }
        if (role.getTypeId() == null) {
            role.setProjectFlag(Integer.valueOf(ProjectFlag.GLOBAL_ROLE.getValue()));
        }
        if (role.getId() == null) {
            this.cdesRoleDAO.save(role);
        } else {
            this.cdesRoleDAO.update(role);
        }
    }

    public void saveRoleActions(Long organisationPersonId, Long roleId, Set<Long> permittedActionIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_ROLE_ACTIONS);
        CdesRole role = (CdesRole)this.cdesRoleDAO.get(roleId);
        Long networkId = role.getNetworkId();
        if (!globalActions.contains(Action.EDIT_ROLE_ACTIONS)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to edit actions of role [" + roleId + "] in network [" + networkId + "]; privilege [" + Action.EDIT_ROLE_ACTIONS + "is missing.");
        }
        List<ActionRuleJoin> actionRuleJoins = this.actionRuleDAO.getActionRuleJoinByRoleId(roleId);
        HashSet<Long> actionRuleIdsToAdd = new HashSet<Long>();
        HashSet<Long> actionRuleIdsToRemove = new HashSet<Long>();
        for (ActionRuleJoin actionRuleJoin : actionRuleJoins) {
            Long actionId = actionRuleJoin.getActionId();
            if (permittedActionIds.contains(actionId)) {
                if (actionRuleJoin.getRoleActionRuleActionRuleId() != null) continue;
                actionRuleIdsToAdd.add(actionRuleJoin.getActionRuleId());
                continue;
            }
            if (actionRuleJoin.getRoleActionRuleActionRuleId() == null) continue;
            actionRuleIdsToRemove.add(actionRuleJoin.getActionRuleId());
        }
        for (Long actionRuleIdToRemove : actionRuleIdsToRemove) {
            this.roleActionRuleDAO.deleteByRoleAndRule(roleId, actionRuleIdToRemove);
        }
        ArrayList<RoleActionRule> roleActionRulesToAdd = new ArrayList<RoleActionRule>();
        for (Long actionRuleIdToAdd : actionRuleIdsToAdd) {
            RoleActionRule roleActionRule = new RoleActionRule();
            roleActionRule.setActionRuleId(actionRuleIdToAdd);
            roleActionRule.setCdesRoleId(roleId);
            roleActionRulesToAdd.add(roleActionRule);
        }
        this.roleActionRuleDAO.saveBatch(roleActionRulesToAdd);
    }

    public String deleteRole(Long organisationPersonId, Long roleId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.DELETE_ROLE);
        CdesRole role = (CdesRole)this.cdesRoleDAO.get(roleId);
        Long networkId = role.getNetworkId();
        if (!globalActions.contains(Action.DELETE_ROLE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to delete role [" + roleId + "] in network [" + networkId + "]; privilege [" + Action.DELETE_ROLE + "is missing.");
        }
        try {
            this.roleActionRuleDAO.deleteByCdesRoleId(roleId);
            this.cdesRoleDAO.delete(roleId);
        }
        catch (Exception e) {
            ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
            String msgRaw = resourceBundle.getString("roleDeleteExistingRefsErrorMessage");
            return MessageFormat.format(msgRaw, role.getName());
        }
        return null;
    }
}

