/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.servlet;

import at.cdes.api.guiService.DocumentService;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.clazzes.util.http.ResponseHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadTemporaryDocumentVersionServlet
extends HttpServlet {
    private static final long serialVersionUID = 8043672375014248787L;
    private static final Logger log = LoggerFactory.getLogger(UploadTemporaryDocumentVersionServlet.class);
    private DocumentService documentService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean multipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        if (multipart) {
            try {
                boolean res = this.handleMultiPartUpload(req);
                ResponseHelper.setNoCacheHeaders((HttpServletResponse)resp);
                resp.setContentType("text/html");
                if (res) {
                    resp.getWriter().write("<html><body>OK</body></html>");
                }
                resp.getWriter().write("<html><body>Cancelled</body></html>");
            }
            catch (FileUploadException e) {
                throw new IOException("Error processing multipart request", e);
            }
        } else {
            resp.sendError(400, "Only multiupart uploads are possibble");
        }
    }

    protected boolean handleMultiPartUpload(HttpServletRequest req) throws FileUploadException, IOException {
        UUID id = null;
        Long organisationPersonId = null;
        String fileName = null;
        String planNumber = null;
        String versionPartA = null;
        String versionPartB = null;
        Long unreleasedDocumentVersion = null;
        Long taskId = null;
        Object folderId = null;
        Object uploadID = null;
        long sizeEst = -1L;
        try {
            sizeEst = Long.parseLong(req.getHeader("Content-Length")) - 100L;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean tryReplace = false;
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileIt = upload.getItemIterator(req);
        Object token = null;
        while (fileIt.hasNext()) {
            FileItemStream item = fileIt.next();
            if (item.isFormField()) {
                String v = Streams.asString((InputStream)item.openStream());
                String fieldName = item.getFieldName();
                if ("fileName".equals(fieldName)) {
                    fileName = v;
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = UUID.fromString(v);
                    continue;
                }
                if ("organisationPersonId".equals(fieldName)) {
                    organisationPersonId = Long.parseLong(v);
                    continue;
                }
                if ("planNumber".equals(fieldName)) {
                    planNumber = v;
                    continue;
                }
                if ("versionPartA".equals(fieldName)) {
                    versionPartA = v;
                    continue;
                }
                if ("versionPartB".equals(fieldName)) {
                    versionPartB = v;
                    continue;
                }
                if ("unreleasedDocumentVersion".equals(fieldName)) {
                    unreleasedDocumentVersion = Long.parseLong(v);
                    continue;
                }
                if (!"taskId".equals(fieldName)) continue;
                taskId = Long.parseLong(v);
                continue;
            }
            String filename = item.getName();
            if (filename == null || filename.isEmpty()) {
                log.warn("Received empty filename for upload ID [{}] in folder [{}], request was cancelled by the webapplication.", uploadID, folderId);
                return false;
            }
            byte[] data = IOUtils.toByteArray((InputStream)item.openStream());
            this.documentService.uploadTemporayDocumentVersion(id, organisationPersonId, filename, planNumber, versionPartA, versionPartB, unreleasedDocumentVersion, taskId, data);
        }
        return true;
    }
}

