/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.joinDto.CertificateOrgPersonJoin;
import at.cdes.api.joinDto.CertificateRequestPersonJoin;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcCertificateRequestDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcCertificateRequestDAO
extends AbstractJdbcCertificateRequestDAO
implements CertificateRequestDAO {
    @Override
    public int[] updateCertificateRequestToNetworkMapping(final Map<Long, Long> certificateRequestIdToNetworkId) {
        String sql = "UPDATE certificate_request SET network_id = ? WHERE id = ?";
        return (int[])this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<int[]>(){

            public int[] perform(PreparedStatement statement) throws Exception {
                for (Long certificateRequestId : certificateRequestIdToNetworkId.keySet()) {
                    Long networkId = (Long)certificateRequestIdToNetworkId.get(certificateRequestId);
                    JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)networkId);
                    JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)certificateRequestId);
                    statement.addBatch();
                }
                return statement.executeBatch();
            }
        });
    }

    @Override
    public CertificateRequest getByChallengeLoginOne(final String challengeLoginOne) {
        String sql = "SELECT " + JdbcCertificateRequestDAO.getSelectClauseForDto() + " FROM certificate_request WHERE certificate_request.challenge1 = ?";
        return (CertificateRequest)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<CertificateRequest>(){

            public CertificateRequest perform(PreparedStatement statement) throws Exception {
                statement.setString(1, challengeLoginOne);
                ResultSet rs = statement.executeQuery();
                CertificateRequest certificateRequest = null;
                while (rs.next()) {
                    if (certificateRequest == null) {
                        certificateRequest = JdbcCertificateRequestDAO.this.fillDtoFromResultSet(rs);
                        continue;
                    }
                    throw new DAOException("Found multiple occurrences of CertificateRequest with challenge1 = [" + challengeLoginOne + "], expected zero or one.");
                }
                return certificateRequest;
            }
        });
    }

    @Override
    public CertificateRequestPersonJoin getPersonJoinByChallengeOne(final String challengeOne) {
        String sql = "SELECT " + JdbcCertificateRequestDAO.getCertificateRequestPersonJoinSelectClause() + "FROM ((((((((certificate_request JOIN organisation_person created_for_org_person               ON certificate_request.created_for = created_for_org_person.id) JOIN organisation_person created_by_org_person                ON certificate_request.created_by_id = created_by_org_person.id) LEFT JOIN person created_for_person                                ON created_for_org_person.person_id = created_for_person.id) LEFT JOIN organisation created_for_organisation                    ON created_for_org_person.organisation_id = created_for_organisation.id) LEFT JOIN countries created_for_country                            ON created_for_org_person.country_id = created_for_country.id) LEFT JOIN person created_by_person                                 ON created_by_org_person.person_id = created_by_person.id) LEFT JOIN organisation created_by_organisation                     ON created_by_org_person.organisation_id = created_by_organisation.id) LEFT JOIN countries created_by_country                             ON created_by_org_person.country_id = created_by_country.id) WHERE certificate_request.challenge1 = ? ";
        return (CertificateRequestPersonJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<CertificateRequestPersonJoin>(){

            public CertificateRequestPersonJoin perform(PreparedStatement statement) throws Exception {
                statement.setString(1, challengeOne);
                ResultSet rs = statement.executeQuery();
                CertificateRequestPersonJoin join = null;
                while (rs.next()) {
                    if (join == null) {
                        join = AbstractJdbcCertificateRequestDAO.fillCertificateRequestPersonJoinFromResultSet(rs);
                        continue;
                    }
                    throw new DAOException("Found multiple occurrences of CertificateRequestPersonJoin with challenge1 = [" + challengeOne + "], expected zero or one.");
                }
                return join;
            }
        });
    }

    @Override
    public Integer getMostRecentSignedUserPolicyVersionForPerson(Long personId) {
        boolean useTop;
        try {
            useTop = "Microsoft SQL Server".equals(this.getConnection().getMetaData().getDatabaseProductName());
        }
        catch (SQLException e) {
            throw new DAOException((Throwable)e);
        }
        String sql = "SELECT " + (useTop ? "TOP(1)" : "") + " certificate_request.request_pdf_upload_version\n     FROM organisation_person\n     JOIN certificate_request ON certificate_request.created_for = organisation_person.id\nWHERE organisation_person.person_id = ?\nORDER BY certificate_request.request_pdf_upload_version DESC\n" + (!useTop ? "LIMIT 1\n" : "") + "";
        return (Integer)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex, (Number)personId);
            ResultSet rs = statement.executeQuery();
            if (!rs.next()) {
                return null;
            }
            int columnIndex = 1;
            return JDBCHelper.getInt((ResultSet)rs, (int)columnIndex++);
        });
    }

    @Override
    public List<CertificateOrgPersonJoin> getSignedUserPolicyVersionsForPerson(final Long personId) {
        String sql = "SELECT " + JdbcCertificateRequestDAO.getCertificateOrgPersonJoinSelectClause() + "     FROM organisation_person\n     JOIN certificate ON certificate.organisation_person_id = organisation_person.id\n     LEFT JOIN certificate_request ON certificate_request.id = certificate.certificate_request_id\nWHERE organisation_person.person_id = ?\nAND certificate.may_login = 1 AND certificate.may_sign = 1\nAND certificate.cert_valid_to > CAST(CURRENT_TIMESTAMP - 30 AS DATE)\nORDER BY certificate_request.request_pdf_upload_version DESC\n";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<CertificateOrgPersonJoin>>(){

            public List<CertificateOrgPersonJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<CertificateOrgPersonJoin> ret = new ArrayList<CertificateOrgPersonJoin>();
                while (rs.next()) {
                    CertificateOrgPersonJoin certificateRequest = JdbcCertificateRequestDAO.fillCertificateOrgPersonJoinFromResultSet(rs);
                    ret.add(certificateRequest);
                }
                return ret;
            }
        });
    }
}

