/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Workflow;
import at.cdes.api.dto.WorkflowActivity;
import at.cdes.impl.dao.WorkflowActivityDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcWorkflowActivityDAO
extends AbstrIdDAO<WorkflowActivity>
implements WorkflowActivityDAO {
    public JdbcWorkflowActivityDAO() {
        super(WorkflowActivity.class, "id", "workflow_activity", new String[]{"id", "workflow_id", "issued", "description", "workflow_node_name", "token_owner", "token_initiator", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcWorkflowActivityDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "issued") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_node_name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "token_owner") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "token_initiator") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcWorkflowActivityDAO.getSelectClauseForDto("workflow_activity", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcWorkflowActivityDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".workflow_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_id") + "," + entityLocalName + ".issued" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "issued") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".workflow_node_name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_node_name") + "," + entityLocalName + ".token_owner" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "token_owner") + "," + entityLocalName + ".token_initiator" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "token_initiator") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected WorkflowActivity fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        WorkflowActivity workflowActivity = new WorkflowActivity();
        workflowActivity.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowActivity.setWorkflowId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowActivity.setIssued(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        workflowActivity.setDescription(JdbcWorkflowActivityDAO.getStringWithoutException(rs.getBytes(++columnIndex)));
        workflowActivity.setWorkflowNodeName(rs.getString(++columnIndex));
        workflowActivity.setTokenOwner(rs.getString(++columnIndex));
        workflowActivity.setTokenInitiator(rs.getString(++columnIndex));
        workflowActivity.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowActivity.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowActivity.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return workflowActivity;
    }

    public static WorkflowActivity fillWorkflowActivityFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        WorkflowActivity workflowActivity = new WorkflowActivity();
        workflowActivity.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivity.setWorkflowId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivity.setIssued(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivity.setDescription(JdbcWorkflowActivityDAO.getStringWithoutException(rs.getBytes(columnIndex.incrementAndGet())));
        workflowActivity.setWorkflowNodeName(rs.getString(columnIndex.incrementAndGet()));
        workflowActivity.setTokenOwner(rs.getString(columnIndex.incrementAndGet()));
        workflowActivity.setTokenInitiator(rs.getString(columnIndex.incrementAndGet()));
        workflowActivity.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivity.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivity.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return workflowActivity;
    }

    public static WorkflowActivity fillWorkflowActivityFromResultSet(ResultSet rs) throws SQLException {
        return JdbcWorkflowActivityDAO.fillWorkflowActivityFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 10;
    }

    public int update(WorkflowActivity dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<WorkflowActivity> dtos) {
        Iterator<WorkflowActivity> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, WorkflowActivity workflowActivity) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)workflowActivity.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)workflowActivity.getWorkflowId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)3, (Double)workflowActivity.getIssued());
        statement.setBytes(4, workflowActivity.getDescription() == null ? null : JdbcWorkflowActivityDAO.getBytesWithoutException(workflowActivity.getDescription()));
        statement.setString(5, workflowActivity.getWorkflowNodeName());
        statement.setString(6, workflowActivity.getTokenOwner());
        statement.setString(7, workflowActivity.getTokenInitiator());
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)(workflowActivity.getCreateTrx() != null ? workflowActivity.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)9, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)10, (Number)System.currentTimeMillis());
    }

    @Override
    public List<WorkflowActivity> getByWorkflow(Workflow workflow) {
        return this.getByWorkflow(workflow.getId());
    }

    @Override
    public List<WorkflowActivity> getByWorkflow(final Long workflowId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"workflow_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, workflowId);
            }
        });
    }

    @Override
    public List<WorkflowActivity> getByWorkflows(Collection<Long> workflowId) {
        if (workflowId.isEmpty()) {
            return new ArrayList<WorkflowActivity>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[workflowId.size()];
        int n = 0;
        Iterator<Long> it = workflowId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"workflow_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

