/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.digest;

import at.cdes.api.dto.IHashedObject;
import at.cdes.impl.digest.DigestWriter;
import at.cdes.impl.digest.DigesterException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bouncycastle.util.encoders.Base64;

public abstract class AbstractDigester {
    protected MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA1", "BC");
        }
        catch (Exception e) {
            throw new DigesterException(e);
        }
    }

    protected String digestListToString(List<String> digestList) {
        StringBuffer sb = new StringBuffer();
        for (int n = 0; n < digestList.size(); ++n) {
            sb.append(n + " = " + digestList.get(n) + "\n");
        }
        return sb.toString();
    }

    protected String getHash(DigestWriter digestWriter) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        FilterOutputStream dos = null;
        try {
            String res;
            dos = new DigestOutputStream(osd, this.getMessageDigest());
            digestWriter.write((DigestOutputStream)dos);
            String string = res = new String(Base64.encode((byte[])((DigestOutputStream)dos).getMessageDigest().digest()));
            return string;
        }
        catch (IOException e) {
            throw new DigesterException(e);
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {
                throw new DigesterException(e);
            }
        }
    }

    protected <T extends IHashedObject> String getSignableContentHelper(T object, Function<T, String> hasher) {
        return this.getSignableContentHelper(object, () -> (String)hasher.apply(object));
    }

    protected <T extends IHashedObject> String getSignableContentHelper(T object, Supplier<String> hasher) {
        return this.digestListToString(Arrays.asList(object.getDigest() != null ? object.getDigest() : hasher.get()));
    }
}

