/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ActionRule;
import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.RoleActionRule;
import at.cdes.impl.dao.GenRoleActionRuleDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcRoleActionRuleDAO
extends AbstrIdDAO<RoleActionRule>
implements GenRoleActionRuleDAO {
    public AbstractJdbcRoleActionRuleDAO() {
        super(RoleActionRule.class, "actionRuleId", "role_action_rule", new String[]{"action_rule_id", "cdes_role_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcRoleActionRuleDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "action_rule_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cdes_role_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcRoleActionRuleDAO.getSelectClauseForDto("role_action_rule", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcRoleActionRuleDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".action_rule_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "action_rule_id") + "," + entityLocalName + ".cdes_role_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cdes_role_id") + " ";
    }

    protected RoleActionRule fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        RoleActionRule roleActionRule = new RoleActionRule();
        roleActionRule.setActionRuleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleActionRule.setCdesRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return roleActionRule;
    }

    public static RoleActionRule fillRoleActionRuleFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        RoleActionRule roleActionRule = new RoleActionRule();
        roleActionRule.setActionRuleId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        roleActionRule.setCdesRoleId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return roleActionRule;
    }

    public static RoleActionRule fillRoleActionRuleFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcRoleActionRuleDAO.fillRoleActionRuleFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteByCdesRoleId(final Long cdesRoleId) {
        String sql = "DELETE FROM role_action_rule WHERE cdes_role_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, cdesRoleId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteByRoleAndRule(final Long cdesRoleId, final Long actionRuleId) {
        String sql = "DELETE FROM role_action_rule WHERE cdes_role_id = ? AND action_rule_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, cdesRoleId);
                statement.setLong(currIndex++, actionRuleId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(RoleActionRule dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<RoleActionRule> dtos) {
        Iterator<RoleActionRule> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, RoleActionRule roleActionRule) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)roleActionRule.getActionRuleId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)roleActionRule.getCdesRoleId());
    }

    @Override
    public List<RoleActionRule> getByActionRule(ActionRule actionRule) {
        return this.getByActionRule(actionRule.getId());
    }

    @Override
    public List<RoleActionRule> getByActionRule(final Long actionRuleId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"action_rule_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, actionRuleId);
            }
        });
    }

    @Override
    public List<RoleActionRule> getByCdesRole(CdesRole cdesRole) {
        return this.getByCdesRole(cdesRole.getId());
    }

    @Override
    public List<RoleActionRule> getByCdesRole(final Long cdesRoleId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"cdes_role_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, cdesRoleId);
            }
        });
    }

    @Override
    public List<RoleActionRule> getByActionRules(Collection<Long> actionRuleId) {
        if (actionRuleId.isEmpty()) {
            return new ArrayList<RoleActionRule>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[actionRuleId.size()];
        int n = 0;
        Iterator<Long> it = actionRuleId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"action_rule_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<RoleActionRule> getByCdesRoles(Collection<Long> cdesRoleId) {
        if (cdesRoleId.isEmpty()) {
            return new ArrayList<RoleActionRule>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[cdesRoleId.size()];
        int n = 0;
        Iterator<Long> it = cdesRoleId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"cdes_role_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

