/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.CdesRole;
import at.cdes.api.joinDto.RoleListJoin;
import at.cdes.api.voc.RoleTypeEnum;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.CdesRoleDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcCdesRoleDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcCdesRoleDAO
extends AbstractJdbcCdesRoleDAO
implements CdesRoleDAO {
    @Override
    public List<CdesRole> getWithoutNetwork() {
        String sql = "SELECT " + JdbcCdesRoleDAO.getSelectClauseForDto() + "FROM cdes_role WHERE cdes_role.network_id IS NULL";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<CdesRole>>(){

            public List<CdesRole> perform(PreparedStatement statement) throws Exception {
                ResultSet rs = statement.executeQuery();
                ArrayList<CdesRole> ret = new ArrayList<CdesRole>();
                while (rs.next()) {
                    CdesRole cdesRole = JdbcCdesRoleDAO.fillCdesRoleFromResultSet(rs);
                    ret.add(cdesRole);
                }
                return ret;
            }
        });
    }

    @Override
    public List<CdesRole> getByAttributes(final Long networkId, final Integer projectFlag) {
        String sql = "SELECT " + JdbcCdesRoleDAO.getSelectClauseForDto() + "FROM         cdes_role WHERE 1=1 ";
        if (networkId != null) {
            sql = sql + "AND cdes_role.network_id = ? ";
        }
        if (projectFlag != null) {
            sql = sql + "AND cdes_role.project_flag = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<CdesRole>>(){

            public List<CdesRole> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                if (projectFlag != null) {
                    JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)projectFlag);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<CdesRole> ret = new ArrayList<CdesRole>();
                while (rs.next()) {
                    CdesRole cdesRole = JdbcCdesRoleDAO.fillCdesRoleFromResultSet(rs);
                    ret.add(cdesRole);
                }
                return ret;
            }
        });
    }

    @Override
    public boolean hasTypeAndAction(final Long cdesRoleId, final RoleTypeEnum roleType, final Action actionName) {
        String sql = "SELECT role_type.type, action.name FROM ((((cdes_role JOIN role_type             ON cdes_role.type_id = role_type.id) JOIN role_action_rule      ON role_action_rule.cdes_role_id = cdes_role.id) JOIN action_rule           ON role_action_rule.action_rule_id = action_rule.id) JOIN action                ON action_rule.action_id = action.id) WHERE cdes_role.id = ? ";
        boolean found = (Boolean)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Boolean>(){

            public Boolean perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)cdesRoleId);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    Integer currRoleType = JDBCHelper.getInt((ResultSet)rs, (int)1);
                    String currActionName = rs.getString(2);
                    if (currRoleType == null || currRoleType.intValue() != roleType.getValue() || currActionName == null || !currActionName.equals(actionName.getName())) continue;
                    return true;
                }
                return false;
            }
        });
        return found;
    }

    @Override
    public List<CdesRole> getByPersonViaParticipations(final Long personId) {
        String sql = "SELECT " + JdbcCdesRoleDAO.getSelectClauseForDto() + "FROM ((( organisation_person JOIN project_participant   ON project_participant.organisation_person_id = organisation_person.id) JOIN project_participation ON project_participant.participation_id = project_participation.id) JOIN cdes_role             ON project_participation.role_id = cdes_role.id) WHERE (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) AND organisation_person.person_id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<CdesRole>>(){

            public List<CdesRole> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<CdesRole> ret = new ArrayList<CdesRole>();
                while (rs.next()) {
                    CdesRole cdesRole = JdbcCdesRoleDAO.fillCdesRoleFromResultSet(rs);
                    ret.add(cdesRole);
                }
                return ret;
            }
        });
    }

    @Override
    public List<CdesRole> getByNetworkAndProjectFlag(Long networkId, Integer projectFlag) {
        String sql = "SELECT " + JdbcCdesRoleDAO.getSelectClauseForDto() + "FROM cdes_role WHERE 1=1 ";
        if (networkId != null) {
            sql = sql + "AND network_id = ? ";
        }
        if (projectFlag != null) {
            sql = sql + "AND project_flag = ? ";
        }
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            if (networkId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
            }
            if (projectFlag != null) {
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)projectFlag);
            }
        });
    }

    @Override
    public List<RoleListJoin> getRoleListJoinsByNetwork(Long networkId, Boolean showBuekRoles) {
        String sql = "SELECT " + JdbcCdesRoleDAO.getRoleListJoinSelectClause() + "FROM cdes_role LEFT JOIN role_type ON cdes_role.type_id = role_type.id WHERE cdes_role.network_id = ? " + (showBuekRoles != false ? "" : " AND (role_type.code < 1000 OR cdes_role.type_id is null)");
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcCdesRoleDAO::fillRoleListJoinFromResultSet, statement -> {
            int currIndex = 1;
            if (networkId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
            }
        });
    }

    @Override
    public CdesRole getByNetworkAndDefaultId(Long networkId, Long cdesRoleDefaultId) {
        String sql = "SELECT " + JdbcCdesRoleDAO.getSelectClauseForDto() + "FROM cdes_role WHERE network_id = ? AND cdes_role_default_id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)cdesRoleDefaultId);
        });
    }
}

