/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import at.cdes.api.dto.Country;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.i18n.CdesImplMessages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.util.aop.ThreadLocalManager;

public class PersonHelper {
    public static boolean isMale(Person person) {
        return "m".equals(person.getGender());
    }

    public static boolean isFemale(Person person) {
        return "f".equals(person.getGender());
    }

    public static String getCommonNameWithTitle(ResourceBundle resourceBundle, Person person) {
        if (person == null) {
            return "";
        }
        String titleWithCommonNameRaw = resourceBundle.getString("titleWithPerson");
        String title = person.getTitle();
        String commonName = PersonHelper.getCommonName(person);
        String titleWithCommonName = null;
        titleWithCommonName = title != null ? (commonName != null ? MessageFormat.format(titleWithCommonNameRaw, title, commonName) : title) : (commonName != null ? commonName : null);
        return titleWithCommonName;
    }

    public static String getCommonName(Person person) {
        if (person == null) {
            return "";
        }
        if (person.getGivenName() == null) {
            return person.getSurName();
        }
        if (person.getSurName() == null) {
            return person.getGivenName();
        }
        String commonName = person.getGivenName().length() > 0 && person.getSurName().length() > 0 ? person.getGivenName() + " " + person.getSurName() : person.getGivenName() + person.getSurName();
        return commonName;
    }

    public static String getInverseCommonName(Person person) {
        if (person == null) {
            return "";
        }
        if (person.getGivenName() == null) {
            return person.getSurName();
        }
        if (person.getSurName() == null) {
            return person.getGivenName();
        }
        String commonName = person.getGivenName().length() > 0 && person.getSurName().length() > 0 ? person.getSurName() + " " + person.getGivenName() : person.getSurName() + person.getGivenName();
        return commonName;
    }

    public static String getOrganisationAndCommonName(Organisation organisation, Person person) {
        return (organisation != null ? organisation.getName() : "") + " (" + PersonHelper.getCommonName(person) + ")";
    }

    public static String getCommonNameAndOrganisation(Organisation organisation, Person person) {
        return PersonHelper.getCommonName(person) + (organisation != null ? " (" + organisation.getName() + ")" : "");
    }

    public static String getOrganisationAndInverseCommonName(Organisation organisation, Person person) {
        return (organisation != null ? organisation.getName() : "") + " (" + PersonHelper.getInverseCommonName(person) + ")";
    }

    public static String getSalutation(Person person, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            resourceBundle = CdesImplMessages.getResourceBundle();
        }
        String salutationStringRaw = null;
        salutationStringRaw = PersonHelper.isMale(person) ? resourceBundle.getString("salutationMale") : (PersonHelper.isFemale(person) ? resourceBundle.getString("salutationFemale") : resourceBundle.getString("salutationGenderless"));
        String title = person.getTitle() != null && !person.getTitle().trim().isEmpty() ? person.getTitle() + " " : "";
        String formattedSalutationString = MessageFormat.format(salutationStringRaw, title, PersonHelper.getCommonName(person));
        return formattedSalutationString;
    }

    public static String getAddressString(OrganisationPerson organisationPerson, Organisation organisation, Person person, Country country) {
        String title = person.getTitle() != null && !person.getTitle().trim().isEmpty() ? person.getTitle() + " " : null;
        return (title != null ? title + "\n" : "") + PersonHelper.getCommonName(person) + "\n" + organisation.getName() + "\n" + organisationPerson.getPostalAddress() + "\n" + organisationPerson.getPostalCode() + " " + organisationPerson.getLocalityName() + "\n" + country.getDescDe();
    }

    public static String getSignature(Organisation organisation, Person person, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            resourceBundle = CdesImplMessages.getResourceBundle();
        }
        String contextPersonTitle = person.getTitle() != null ? person.getTitle() + " " : "";
        String contextPersonName = PersonHelper.getCommonName(person);
        String contextOrganisationName = organisation.getName();
        String signature = MessageFormat.format(resourceBundle.getString("signature"), contextPersonTitle, contextPersonName, contextOrganisationName);
        return signature;
    }

    public static Map<Long, OrganisationPersonJoin> groupById(List<OrganisationPersonJoin> organisationPersonJoins) {
        HashMap<Long, OrganisationPersonJoin> idToOrganisationPersonJoin = new HashMap<Long, OrganisationPersonJoin>();
        for (OrganisationPersonJoin organisationPersonJoin : organisationPersonJoins) {
            idToOrganisationPersonJoin.put(organisationPersonJoin.getOrganisationPersonId(), organisationPersonJoin);
        }
        return idToOrganisationPersonJoin;
    }

    public static ResourceBundle getResourceBundleByPrincipal(PersonVariablesDAO personVariablesDAO) {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        List<PersonVariables> personVariablesList = personVariablesDAO.getByPerson(personId);
        PersonVariables personVariables = personVariablesList.get(0);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariables.getUserLocale());
        return resourceBundle;
    }

    public static Person removeSecurityPersonData(Person person) {
        person.setAnswerPassword(null);
        person.setLastPasswordChangeTs(null);
        person.setLogin(null);
        person.setPassword(null);
        person.setQuestion(null);
        return person;
    }

    public static OrganisationPersonJoin removeSecurityPersonData(OrganisationPersonJoin organisationPersonJoin) {
        Person person = organisationPersonJoin.getPerson();
        PersonHelper.removeSecurityPersonData(person);
        organisationPersonJoin.setPerson(person);
        return organisationPersonJoin;
    }
}

