/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.action;

import at.cdes.api.joinDto.ObjectPlannerAction;
import at.cdes.api.joinDto.ProjectAction;
import at.cdes.api.joinDto.ShortObjectPlannerAction;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.action.ActionDAOHelper;
import at.cdes.impl.dao.jdbc.AbstractJdbcActionDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.clazzes.util.sql.helper.JDBCHelper;

public class ProjectActionHelper {
    public static String getProjectRuleClauseForProject(Integer numberOfProjectIds, int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        String sql = "SELECT DISTINCT " + AbstractJdbcActionDAO.getSelectClauseForDto() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, network.id, org_role.id, project.id, project.access, project_participant.id, project_participant.inactive_flag FROM (((((((((project JOIN  network                       ON     project.network_id = network.id) JOIN  action_rule dest_action_rule  ON    (dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) JOIN  action                        ON     dest_action_rule.action_id = action.id) JOIN  action_rule                   ON     action_rule.action_id = action.id) JOIN  role_action_rule              ON     role_action_rule.action_rule_id = action_rule.id) CROSS JOIN  organisation_person ) JOIN  project_participant           ON     project_participant.organisation_person_id = organisation_person.id) JOIN  project_participation         ON     project_participant.participation_id = project_participation.id AND project_participation.project_id = project.id) JOIN  cdes_role org_role            ON     project_participation.role_id = org_role.id AND role_action_rule.cdes_role_id = org_role.id) WHERE 1=1 ";
        if (numberOfProjectIds != null) {
            sql = sql + "AND project.id IN (" + QueryHelper.getPlaceHolderSequence(numberOfProjectIds) + ") ";
        }
        sql = sql + "AND dest_action_rule.destination_context_id >= 3 AND dest_action_rule.destination_context_id <= 4 AND (     project.access = 2 OR (project.access = 1 AND action.read_only IN (1, 2)) OR (project.access = 0 AND action.read_only = 2)) AND organisation_person.id = ? AND organisation_person.person_id = ? AND project_participant.inactive_flag = 0 " + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
        return sql;
    }

    public static String getProjectRuleClauseForObjectPlanner(int numberOfActionNames) {
        return ProjectActionHelper.getProjectRuleSelectClauseWithObjectPlanner() + ProjectActionHelper.getProjectRuleFromClauseWithObjectPlanner() + ProjectActionHelper.getProjectRuleWhereClauseGivenSubProject(numberOfActionNames);
    }

    public static String getProjectRuleClauseForObjectPlanner(int numberOfObjectPlanners, int numberOfActionNames) {
        return ProjectActionHelper.getProjectRuleSelectClauseWithObjectPlanner() + ProjectActionHelper.getProjectRuleFromClauseWithObjectPlanner() + ProjectActionHelper.getProjectRuleWhereClauseGivenObjectPlanners(numberOfObjectPlanners, numberOfActionNames);
    }

    private static String getProjectRuleSelectClauseWithObjectPlanner() {
        return "SELECT DISTINCT " + AbstractJdbcActionDAO.getShortObjectPlannerActionSelectClause() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, network.id, org_role.id, project.id, project.access, project_participant.id, project_participant.inactive_flag ";
    }

    private static String getProjectRuleFromClauseWithObjectPlanner() {
        return "FROM (((((((((((((((object_planner JOIN object                        ON object_planner.object_id = object.id) JOIN object_list                   ON object.object_list_id = object_list.id) JOIN object_list_release           ON       object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1) JOIN object_release                ON       object_release.object_id = object.id AND object_release.object_list_release_id = object_list_release.id) JOIN object_planner_release        ON       object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) JOIN sub_project                   ON object_list.sub_project_id = sub_project.id) JOIN project                       ON sub_project.project_id = project.id) JOIN network                       ON project.network_id = network.id) CROSS JOIN action) JOIN action_rule dest_action_rule  ON       dest_action_rule.action_id = action.id AND (    dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) CROSS JOIN organisation_person) JOIN project_participant           ON     project_participant.organisation_person_id = organisation_person.id) JOIN project_participation         ON     project_participant.participation_id = project_participation.id AND project_participation.project_id = project.id) JOIN cdes_role org_role            ON     project_participation.role_id = org_role.id) JOIN (action_rule JOIN role_action_rule ON role_action_rule.action_rule_id = action_rule.id) ON     action_rule.action_id = action.id AND role_action_rule.cdes_role_id = org_role.id) ";
    }

    private static String getProjectRuleCoreWhereClause() {
        return "WHERE dest_action_rule.destination_context_id >= 3 AND dest_action_rule.destination_context_id <= 4 AND ((project.access = 2 AND sub_project.read_only = 0) OR ((project.access = 1 OR sub_project.read_only = 1) AND action.read_only IN (1, 2)) OR (project.access = 0 AND action.read_only = 2)) AND organisation_person.id = ? AND organisation_person.person_id = ? AND project_participant.inactive_flag = 0 ";
    }

    private static String getProjectRuleWhereClauseGivenSubProject(int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return ProjectActionHelper.getProjectRuleCoreWhereClause() + "AND sub_project.id = ? " + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    private static String getProjectRuleWhereClauseGivenObjectPlanners(int numberOfObjectPlanners, int numberOfActionNames) {
        String objectPlannerWhereClause = ActionDAOHelper.getInClauseWithPlaceHolders("object_planner.id", numberOfObjectPlanners);
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return ProjectActionHelper.getProjectRuleCoreWhereClause() + (objectPlannerWhereClause.length() > 0 ? "AND " + objectPlannerWhereClause : "AND 1=0 ") + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    public static int populateProjectRuleClauseForProject(PreparedStatement statement, int currIndex, Long organisationPersonId, Collection<Long> projectIds, Action ... actionNames) throws SQLException {
        if (projectIds != null) {
            for (Long projectId : projectIds) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
            }
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateProjectRuleClauseForObjectPlanner(PreparedStatement statement, int currIndex, Long organisationPersonId, Long subProjectId, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateProjectRuleClauseForObjectPlanner(PreparedStatement statement, int currIndex, Long organisationPersonId, Collection<Long> objectPlannerIds, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Long objectPlannerId : objectPlannerIds) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
        }
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static ProjectAction fillProjectActionFromResultSet(ResultSet resultSet) throws SQLException {
        ProjectAction projectAction = new ProjectAction();
        projectAction.setActionId(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
        projectAction.setActionName(resultSet.getString(2));
        projectAction.setActionDescription(resultSet.getString(3));
        projectAction.setActionReadOnly(JDBCHelper.getBoolean((ResultSet)resultSet, (int)4));
        projectAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)5));
        projectAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        projectAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)7));
        projectAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)8));
        projectAction.setOrgRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        projectAction.setProjectId(JDBCHelper.getLong((ResultSet)resultSet, (int)10));
        projectAction.setProjectAccess(JDBCHelper.getInt((ResultSet)resultSet, (int)11));
        projectAction.setProjectParticipantId(JDBCHelper.getLong((ResultSet)resultSet, (int)12));
        projectAction.setProjectParticipantInactiveFlag(JDBCHelper.getBoolean((ResultSet)resultSet, (int)13));
        return projectAction;
    }

    public static ObjectPlannerAction fillObjectPlannerActionFromResultSet(ResultSet resultSet) throws SQLException {
        ShortObjectPlannerAction shortObjectPlannerAction = AbstractJdbcActionDAO.fillShortObjectPlannerActionFromResultSet(resultSet);
        ObjectPlannerAction objectPlannerAction = new ObjectPlannerAction();
        objectPlannerAction.setAction(shortObjectPlannerAction.getAction());
        objectPlannerAction.setObjectPlannerId(shortObjectPlannerAction.getObjectPlannerId());
        objectPlannerAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        objectPlannerAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)7));
        objectPlannerAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)8));
        objectPlannerAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        objectPlannerAction.setOrgRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)10));
        objectPlannerAction.setProjectId(JDBCHelper.getLong((ResultSet)resultSet, (int)11));
        objectPlannerAction.setProjectAccess(JDBCHelper.getInt((ResultSet)resultSet, (int)12));
        objectPlannerAction.setProjectParticipantId(JDBCHelper.getLong((ResultSet)resultSet, (int)13));
        objectPlannerAction.setProjectParticipantInactiveFlag(JDBCHelper.getBoolean((ResultSet)resultSet, (int)14));
        return objectPlannerAction;
    }

    public static void popuplateActionsForProjectStatement(PreparedStatement statement, Long organisationPersonId, Long projectId, String ... actionNames) throws SQLException {
        int currIndex = 1;
        if (actionNames != null) {
            for (String actionName : actionNames) {
                statement.setString(currIndex++, actionName);
            }
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
    }
}

