/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Realm;
import at.cdes.impl.dao.RealmDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcRealmDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRealmDAO
extends AbstractJdbcRealmDAO
implements RealmDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcRealmDAO.class);

    @Override
    public List<Realm> getTemplates(Long projectId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\n     FROM project\n     JOIN network                      ON network.id = project.network_id\n     JOIN network_review_cycle         ON network_review_cycle.network_id = network.id\n     JOIN review_cycle                 ON review_cycle.id = network_review_cycle.review_cycle_id\n     JOIN review_cycle_cell            ON review_cycle_cell.review_cycle_id = review_cycle.id\n     JOIN review_cycle_node            ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id\n     JOIN realm                        ON realm.review_cycle_position_type_id = review_cycle_node.review_cycle_position_type_id\n                                      AND (realm.project_id IS NULL)\nWHERE project.id = ?\nUNION\nSELECT " + this.getSelectClauseForDto() + "\n     FROM project\n     JOIN network                      ON network.id = project.network_id\n     JOIN network_review_cycle         ON network_review_cycle.network_id = network.id\n     JOIN review_cycle                 ON review_cycle.id = network_review_cycle.review_cycle_id\n     JOIN review_cycle_cell            ON review_cycle_cell.review_cycle_id = review_cycle.id\n     JOIN review_cycle_cell_connection ON review_cycle_cell_connection.source_cell_id = review_cycle_cell.id\n     JOIN realm                        ON realm.review_cycle_position_type_id = review_cycle_cell_connection.review_cycle_position_type_id\n                                      AND (realm.project_id IS NULL)\nWHERE project.id = ?\n";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        });
    }

    @Override
    public List<Realm> getByType(Long projectId, Long reviewCyclePositionTypeId) {
        String sql = "SELECT " + JdbcRealmDAO.getSelectClauseForDto() + "\nFROM realm\nWHERE 1=1 ";
        sql = projectId != null ? sql + "AND realm.project_id = ? " : sql + "AND realm.project_id is null ";
        if (reviewCyclePositionTypeId != null) {
            sql = sql + "AND realm.review_cycle_position_type_id = ? ";
        }
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            if (projectId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
            }
            if (reviewCyclePositionTypeId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCyclePositionTypeId);
            }
        });
    }

    @Override
    public Map<Long, List<Realm>> getNodeInstanceIdToRealmsByInstanceId(final Long instanceId) {
        String sql = "SELECT " + JdbcRealmDAO.getSelectClauseForDto() + ", review_cycle_node_instance.id FROM review_cycle_instance JOIN sub_project                         ON review_cycle_instance.sub_project_id = sub_project.id JOIN project                             ON sub_project.project_id = project.id JOIN review_cycle_cell_instance          ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id JOIN review_cycle_node_instance          ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id LEFT JOIN review_cycle_node                   ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id LEFT JOIN realm                               ON      realm.project_id = project.id AND realm.review_cycle_position_type_id = review_cycle_node.review_cycle_position_type_id WHERE review_cycle_instance.id = ? AND review_cycle_node_instance.free = 0 AND (   (realm.valid_from_date IS NULL AND realm.valid_to_date IS NULL) OR (realm.valid_from_date IS NULL AND ? <= realm.valid_to_date) OR (? >= realm.valid_from_date AND realm.valid_to_date IS NULL) OR (? >= realm.valid_from_date AND ? <= realm.valid_to_date)) UNION ALL SELECT " + JdbcRealmDAO.getSelectClauseForDto() + ", review_cycle_node_instance.id FROM review_cycle_instance JOIN review_cycle_cell_instance          ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id JOIN review_cycle_node_instance          ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_node_position          ON review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN realm                               ON review_cycle_node_position.realm_id = realm.id WHERE review_cycle_instance.id = ? AND review_cycle_node_instance.free = 1 AND (   (realm.valid_from_date IS NULL AND realm.valid_to_date IS NULL) OR (realm.valid_from_date IS NULL AND ? <= realm.valid_to_date) OR (? >= realm.valid_from_date AND realm.valid_to_date IS NULL) OR (? >= realm.valid_from_date AND ? <= realm.valid_to_date)) ";
        log.info("getNodeInstanceIdToRealmsByInstanceId: Will query sql for instanceId [" + instanceId + "] {" + sql + "}");
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, List<Realm>>>(){

            public Map<Long, List<Realm>> perform(PreparedStatement statement) throws Exception {
                Double currentUtcSeconds = (double)System.currentTimeMillis() / 1000.0;
                int currIndex = 1;
                for (int n = 0; n < 2; ++n) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)instanceId);
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                }
                ResultSet rs = statement.executeQuery();
                HashMap<Long, List<Realm>> nodeInstanceIdToRealms = new HashMap<Long, List<Realm>>();
                HashMap nodeInstanceIdToRealmIds = new HashMap();
                HashMap<Long, Realm> idToRealm = new HashMap<Long, Realm>();
                while (rs.next()) {
                    int numberOfDtoAttributes = JdbcRealmDAO.getNumberOfDtoAttributes();
                    Long nodeInstanceId = JDBCHelper.getLong((ResultSet)rs, (int)(numberOfDtoAttributes + 1));
                    Realm realm = JdbcRealmDAO.this.fillDtoFromResultSet(rs);
                    if (realm.getId() == null) continue;
                    if (!nodeInstanceIdToRealmIds.containsKey(nodeInstanceId)) {
                        nodeInstanceIdToRealmIds.put(nodeInstanceId, new HashSet());
                    }
                    ((Set)nodeInstanceIdToRealmIds.get(nodeInstanceId)).add(realm.getId());
                    idToRealm.put(realm.getId(), realm);
                }
                for (Long nodeInstanceId : nodeInstanceIdToRealmIds.keySet()) {
                    ArrayList<Realm> realms = new ArrayList<Realm>();
                    for (Long realmId : (Set)nodeInstanceIdToRealmIds.get(nodeInstanceId)) {
                        realms.add((Realm)idToRealm.get(realmId));
                    }
                    nodeInstanceIdToRealms.put(nodeInstanceId, realms);
                }
                return nodeInstanceIdToRealms;
            }
        });
    }

    @Override
    public Map<Long, List<Realm>> getNodeInstanceReleasedIdToRealmsByObjectVersion(final Long objectId, final Integer version) {
        String sql = "SELECT " + JdbcRealmDAO.getSelectClauseForDto() + ", review_cycle_node_instance_released.id FROM object JOIN object_list                         ON object.object_list_id = object_list.id JOIN object_list_release                 ON object_list_release.object_list_id = object_list.id JOIN signature                           ON object_list_release.signature_id = signature.id JOIN object_release                      ON      object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id JOIN sub_project                         ON object_list.sub_project_id = sub_project.id JOIN project                             ON sub_project.project_id = project.id LEFT JOIN object_planner_release              ON object_planner_release.object_id = object_release.id LEFT JOIN review_cycle_instance_released      ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id LEFT JOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id LEFT JOIN review_cycle_node                   ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id LEFT JOIN realm                               ON      realm.project_id = project.id AND realm.review_cycle_position_type_id = review_cycle_node.review_cycle_position_type_id WHERE object.id = ? AND object_list_release.version = ? AND review_cycle_node_instance_released.free = 0 AND (   (realm.valid_from_date IS NULL AND realm.valid_to_date IS NULL) OR (realm.valid_from_date IS NULL AND signature.time <= realm.valid_to_date) OR (signature.time >= realm.valid_from_date AND realm.valid_to_date IS NULL) OR (signature.time >= realm.valid_from_date AND signature.time <= realm.valid_to_date)) UNION ALL SELECT " + JdbcRealmDAO.getSelectClauseForDto() + ", review_cycle_node_instance_released.id FROM object JOIN object_list                         ON object.object_list_id = object_list.id JOIN object_list_release                 ON object_list_release.object_list_id = object_list.id JOIN signature                           ON object_list_release.signature_id = signature.id JOIN object_release                      ON      object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id JOIN sub_project                         ON object_list.sub_project_id = sub_project.id JOIN project                             ON sub_project.project_id = project.id LEFT JOIN object_planner_release              ON object_planner_release.object_id = object_release.id LEFT JOIN review_cycle_instance_released      ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id LEFT JOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id LEFT JOIN review_cycle_node_position_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id LEFT JOIN realm                               ON review_cycle_node_position_released.realm_id = realm.id WHERE object.id = ? AND object_list_release.version = ? AND review_cycle_node_instance_released.free = 1 AND (   (realm.valid_from_date IS NULL AND realm.valid_to_date IS NULL) OR (realm.valid_from_date IS NULL AND signature.time <= realm.valid_to_date) OR (signature.time >= realm.valid_from_date AND realm.valid_to_date IS NULL) OR (signature.time >= realm.valid_from_date AND signature.time <= realm.valid_to_date)) ";
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, List<Realm>>>(){

            public Map<Long, List<Realm>> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)version);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)version);
                ResultSet rs = statement.executeQuery();
                HashMap<Long, List<Realm>> nodeInstanceReleasedIdToRealms = new HashMap<Long, List<Realm>>();
                HashMap nodeInstanceReleasedIdToRealmIds = new HashMap();
                HashMap<Long, Realm> idToRealm = new HashMap<Long, Realm>();
                while (rs.next()) {
                    int numberOfDtoAttributes = JdbcRealmDAO.getNumberOfDtoAttributes();
                    Long nodeInstanceReleasedId = JDBCHelper.getLong((ResultSet)rs, (int)(numberOfDtoAttributes + 1));
                    Realm realm = JdbcRealmDAO.this.fillDtoFromResultSet(rs);
                    if (realm.getId() == null) continue;
                    if (!nodeInstanceReleasedIdToRealmIds.containsKey(nodeInstanceReleasedId)) {
                        nodeInstanceReleasedIdToRealmIds.put(nodeInstanceReleasedId, new HashSet());
                    }
                    ((Set)nodeInstanceReleasedIdToRealmIds.get(nodeInstanceReleasedId)).add(realm.getId());
                    idToRealm.put(realm.getId(), realm);
                }
                for (Long nodeInstanceReleasedId : nodeInstanceReleasedIdToRealmIds.keySet()) {
                    ArrayList<Realm> realms = new ArrayList<Realm>();
                    for (Long realmId : (Set)nodeInstanceReleasedIdToRealmIds.get(nodeInstanceReleasedId)) {
                        realms.add((Realm)idToRealm.get(realmId));
                    }
                    nodeInstanceReleasedIdToRealms.put(nodeInstanceReleasedId, realms);
                }
                return nodeInstanceReleasedIdToRealms;
            }
        });
    }
}

