/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.mimeSource;

import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.SupportContactDAO;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.odf.OdfHelper;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang.NotImplementedException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFMergerUtility;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.ConversionHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfGraphicProperties;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfTextProperties;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPolicyMimeSource
implements VisitlessMimeSource {
    private static Logger log = LoggerFactory.getLogger(UserPolicyMimeSource.class);
    private String userPolicyPath;
    private String userPolicyEmail;
    private String exportTempDir;
    private OrganisationPersonDAO organisationPersonDAO;
    private CertificateDAO certificateDAO;
    private CertificateRequestDAO certificateRequestDAO;
    private SupportContactDAO supportContactDAO;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine;
    private Boolean enableCustomerLogo;
    private String costumerLabel;
    private Boolean certificateAdministrationGlobal;
    private String odfStylePrefix;
    private String LOEXT = "urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0";
    private double logoAspectRatio = 2.0262172284644193;
    private double logoHeight = 1.5;
    private double headerPadding = 0.1;

    public void setUserPolicyPath(String userPolicyPath) {
        this.userPolicyPath = userPolicyPath;
    }

    public void setUserPolicyEmail(String userPolicyEmail) {
        this.userPolicyEmail = userPolicyEmail;
    }

    public void setExportTempDir(String exportTempDir) {
        this.exportTempDir = exportTempDir;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void setSupportContactDAO(SupportContactDAO supportContactDAO) {
        this.supportContactDAO = supportContactDAO;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public void setCertificateAdministrationGlobal(Boolean certificateAdministrationGlobal) {
        this.certificateAdministrationGlobal = certificateAdministrationGlobal;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public String getActionName() {
        throw new NotImplementedException();
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        throw new NotImplementedException();
    }

    private LocalStyles constructStyles(OdfDocument document, ResourceBundle resourceBundle, OdfOfficeAutomaticStyles automaticStyles, OdfOfficeAutomaticStyles stylesAutomaticStyles) throws Exception {
        LocalStyles ret = new LocalStyles();
        ret.signatureBoxStyle = automaticStyles.newStyle(OdfStyleFamily.Graphic);
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.MarginLeft, "0cm");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.MarginRight, "0cm");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.MarginBottom, "0cm");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.MarginTop, "0cm");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.VerticalPos, "top");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.VerticalRel, "baseline");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.HorizontalPos, "center");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.HorizontalRel, "paragraph-content");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.RelWidth, "100%");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.Padding, "0cm");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.Border, "none");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.TextareaVerticalAlign, "bottom");
        ret.signatureBoxStyle.setProperty(OdfGraphicProperties.WrapInfluenceOnPosition, "once-concurrent");
        ret.signatureBoxStyle.getOrCreatePropertiesElement(OdfStylePropertiesSet.GraphicProperties).setAttributeNS(this.LOEXT, "loext:rel-width-rel", "paragraph");
        ret.signatureBoxStyle.getOrCreatePropertiesElement(OdfStylePropertiesSet.GraphicProperties).setAttributeNS(this.LOEXT, "loext:allow-overlap", "true");
        ret.signatureBoxStyle.setStyleParentStyleNameAttribute("Frame");
        ret.innerSignatureBoxStyle = automaticStyles.newStyle(OdfStyleFamily.Graphic);
        ret.innerSignatureBoxStyle.setProperty(OdfTextProperties.FontFamily, "Arial");
        ret.innerSignatureBoxStyle.setProperty(OdfTextProperties.FontName, "Arial");
        ret.innerSignatureBoxStyle.setProperty(OdfTextProperties.FontSize, "10pt");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.MarginLeft, "0cm");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.MarginRight, "0cm");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.MarginBottom, "0cm");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.MarginTop, "0cm");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.VerticalPos, "top");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.VerticalRel, "frame");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.RelWidth, "50%");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.HorizontalPos, "right");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.HorizontalRel, "frame");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.Padding, "0cm");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.Border, "none");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.TextareaVerticalAlign, "bottom");
        ret.innerSignatureBoxStyle.setProperty(OdfGraphicProperties.WrapInfluenceOnPosition, "once-concurrent");
        ret.innerSignatureBoxStyle.getOrCreatePropertiesElement(OdfStylePropertiesSet.GraphicProperties).setAttributeNS(this.LOEXT, "loext:rel-width-rel", "paragraph");
        ret.innerSignatureBoxStyle.getOrCreatePropertiesElement(OdfStylePropertiesSet.GraphicProperties).setAttributeNS(this.LOEXT, "loext:allow-overlap", "true");
        ret.innerSignatureBoxStyle.setStyleParentStyleNameAttribute("Frame");
        return ret;
    }

    private OdfTextDocument constructLastPage(OrganisationPersonJoin recipient, String supportContact, int numberOfPages, boolean isOebb) throws Exception {
        Locale locale = new Locale(recipient.getPersonVariablesUserLocale());
        if (log.isDebugEnabled()) {
            log.info("recipient = {}, locale = {}", (Object)recipient, (Object)locale);
        }
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale.toString());
        OdfTextDocument a = null;
        a = isOebb ? DocumentFactory.constructTextDocument((String)"export/emptyUserPolicyTemplate_oebb.odt", UserPolicyMimeSource.class, (Locale)locale) : DocumentFactory.constructTextDocument((String)"export/emptyUserPolicyTemplate.odt", UserPolicyMimeSource.class, (Locale)locale);
        OdfContext context = new OdfContext((OdfDocument)a, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        OdfOfficeAutomaticStyles odfContentAutomaticStyles = a.getContentDom().getOrCreateAutomaticStyles();
        OdfOfficeAutomaticStyles odfStylesAutomaticStyles = a.getStylesDom().getOrCreateAutomaticStyles();
        LocalStyles localStyles = this.constructStyles((OdfDocument)a, resourceBundle, odfContentAutomaticStyles, odfStylesAutomaticStyles);
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        String standardParagraphBoldStyle = OdfHelper.constructStandardParagraphBoldStyle(stylesOfficeStyles);
        String standardParagraphCenterStyle = OdfHelper.constructStandardParagraphCenterStyle(stylesOfficeStyles);
        a.newParagraph().addStyledContent(standardParagraphBoldStyle, resourceBundle.getString("userPolicyFooterRequestLine"));
        a.newParagraph();
        a.newParagraph();
        a.newParagraph().addStyledContentWhitespace(standardParagraphBoldStyle, PersonHelper.getAddressString(recipient.getOrganisationPerson(), recipient.getOrganisation(), recipient.getPerson(), recipient.getOpCountry()));
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        if (isOebb) {
            a.newParagraph().addStyledContent(standardParagraphStyle, resourceBundle.getString("userPolicyFooterExplanationLine_oebb"));
        } else {
            a.newParagraph().addStyledContent(standardParagraphStyle, resourceBundle.getString("userPolicyFooterExplanationLine"));
        }
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        OdfDrawFrame signatureFrame = (OdfDrawFrame)a.newParagraph().newDrawFrameElement();
        signatureFrame.setDrawNameAttribute("Frame1");
        signatureFrame.setDrawStyleNameAttribute(localStyles.signatureBoxStyle.getStyleNameAttribute());
        signatureFrame.setTextAnchorTypeAttribute("as-char");
        signatureFrame.setStyleRelWidthAttribute("100%");
        signatureFrame.setDrawZIndexAttribute(Integer.valueOf(0));
        signatureFrame.setSvgWidthAttribute("18.461cm");
        DrawTextBoxElement signatureTextBox = signatureFrame.newDrawTextBoxElement();
        signatureTextBox.setFoMinHeightAttribute("0.34cm");
        signatureTextBox.newTextPElement();
        ((OdfTextParagraph)signatureTextBox.newTextPElement()).addStyledContent(standardParagraphStyle, String.format(resourceBundle.getString("userPolicyFooterAt"), recipient.getOrganisationPersonLocalityName(), DateTimeFormatter.ofPattern(resourceBundle.getString("yearToDayFormat")).format(ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("Europe/Vienna")))));
        OdfDrawFrame innerSignatureFrame = (OdfDrawFrame)signatureTextBox.newDrawFrameElement();
        innerSignatureFrame.setDrawNameAttribute("Frame2");
        innerSignatureFrame.setDrawStyleNameAttribute(localStyles.innerSignatureBoxStyle.getStyleNameAttribute());
        innerSignatureFrame.setTextAnchorTypeAttribute("frame");
        innerSignatureFrame.setStyleRelWidthAttribute("50%");
        innerSignatureFrame.setDrawZIndexAttribute(Integer.valueOf(1));
        innerSignatureFrame.setSvgWidthAttribute("10cm");
        DrawTextBoxElement innerSignatureTextBox = innerSignatureFrame.newDrawTextBoxElement();
        innerSignatureTextBox.setFoMinHeightAttribute("0.34cm");
        ((OdfTextParagraph)innerSignatureTextBox.newTextPElement()).addStyledContent(standardParagraphCenterStyle, "________________________________");
        ((OdfTextParagraph)innerSignatureTextBox.newTextPElement()).addStyledContent(standardParagraphCenterStyle, PersonHelper.getCommonName(recipient.getPerson()));
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph();
        a.newParagraph().addStyledContent(standardParagraphStyle, resourceBundle.getString("userPolicyFooterPleaseSignLine"));
        a.newParagraph().addStyledContent(standardParagraphBoldStyle, supportContact);
        return a;
    }

    private String writeUserPolicyFile(OrganisationPersonJoin recipient, String supportContact) throws Exception {
        PDFMergerUtility mergerUtility = new PDFMergerUtility();
        int userPolicyPages = 1;
        boolean isOebb = this.enableCustomerLogo;
        if (this.userPolicyPath != null && this.userPolicyPath.length() > 0) {
            mergerUtility.addSource(this.userPolicyPath);
            PDDocument document = PDDocument.load((File)new File(this.userPolicyPath));
            userPolicyPages = document.getNumberOfPages();
        }
        OdfTextDocument lastPage = this.constructLastPage(recipient, supportContact, userPolicyPages, isOebb);
        File lastPageFile = new File(Files.createTempFile(Paths.get(this.exportTempDir, new String[0]), "userPolicyLastPage", ".odt", new FileAttribute[0]).toString());
        lastPageFile.deleteOnExit();
        lastPage.save(lastPageFile);
        String mergedUserPolicyTempName = Files.createTempFile(Paths.get(this.exportTempDir, new String[0]), "userPolicy", ".pdf", new FileAttribute[0]).toString();
        String lastPageFileFileName = ConversionHelper.convert((File)lastPageFile, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout);
        mergerUtility.addSource(lastPageFileFileName);
        mergerUtility.setDestinationFileName(mergedUserPolicyTempName);
        mergerUtility.mergeDocuments();
        return mergedUserPolicyTempName;
    }

    private IMimeInputStream getMimeStreamImpl(Object[] parameters) throws Exception {
        List supportContacts = this.supportContactDAO.getAll();
        String supportContact = this.userPolicyEmail;
        if (parameters.length == 0) {
            throw new IllegalArgumentException("No organisationPersonId given.");
        }
        if (parameters.length == 1) {
            Long organisationPersonId = (Long)parameters[0];
            OrganisationPersonJoin recipient = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
            CertificateRequest recipientsCertificateRequest = null;
            if (!this.certificateAdministrationGlobal.booleanValue()) {
                Certificate recipientsCertificate = this.certificateDAO.getSignerCertificate(recipient.getOrganisationPersonId());
                if (recipientsCertificate != null) {
                    recipientsCertificateRequest = (CertificateRequest)this.certificateRequestDAO.get(recipientsCertificate.getCertificateRequestId());
                } else {
                    List<CertificateRequest> recipientsCertificateRequests = this.certificateRequestDAO.getByCreatedFor(organisationPersonId);
                    recipientsCertificateRequests.sort(new Comparator<CertificateRequest>(){

                        @Override
                        public int compare(CertificateRequest req1, CertificateRequest req2) {
                            Long comp1 = req1.getId();
                            Long comp2 = req2.getId();
                            return (comp1 != null ? comp1.intValue() : 0) - (comp2 != null ? comp2.intValue() : 0);
                        }
                    });
                    recipientsCertificateRequest = recipientsCertificateRequests.get(0);
                }
                OrganisationPerson createdBy = (OrganisationPerson)this.organisationPersonDAO.get(recipientsCertificateRequest.getCreatedById());
                supportContact = createdBy.getEmailAddress();
            }
            String userPolicyTempName = this.writeUserPolicyFile(recipient, supportContact);
            FileMimeInputStream userPolicyMimeInputStream = new FileMimeInputStream(userPolicyTempName, "Benutzerrichtlinie.pdf", "application/pdf");
            return userPolicyMimeInputStream;
        }
        String zipTempFileName = Files.createTempFile(Paths.get(this.exportTempDir, new String[0]), "userPolicyZipTemp", ".zip", new FileAttribute[0]).toString();
        try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipTempFileName));){
            FileMimeInputStream userPolicyMimeInputStream;
            zipOutputStream.setEncoding("UTF-8");
            zipOutputStream.setUseZip64(Zip64Mode.Always);
            for (Object parameter : parameters) {
                Certificate recipientsCertificate;
                Long recipientOrgPersonId = (Long)parameter;
                OrganisationPersonJoin recipient = this.organisationPersonDAO.getOrganisationPersonJoinById(recipientOrgPersonId);
                if (!this.certificateAdministrationGlobal.booleanValue() && (recipientsCertificate = this.certificateDAO.getSignerCertificate(recipient.getOrganisationPersonId())) != null) {
                    CertificateRequest recipientsCertificateRequest = (CertificateRequest)this.certificateRequestDAO.get(recipientsCertificate.getCertificateRequestId());
                    OrganisationPerson createdBy = (OrganisationPerson)this.organisationPersonDAO.get(recipientsCertificateRequest.getCreatedById());
                    supportContact = createdBy.getEmailAddress();
                }
                String currFileName = this.writeUserPolicyFile(recipient, supportContact);
                try (FileInputStream currStream = new FileInputStream(currFileName);){
                    byte[] dataAsByteArray = IOUtils.toByteArray((InputStream)currStream);
                    String organisationName = recipient.getOrganisationName().replace('/', '-');
                    organisationName = organisationName.replace('\\', '-');
                    ZipArchiveEntry ze = new ZipArchiveEntry(organisationName + ".pdf");
                    zipOutputStream.putArchiveEntry((ArchiveEntry)ze);
                    zipOutputStream.write(dataAsByteArray);
                    zipOutputStream.closeArchiveEntry();
                }
            }
            FileMimeInputStream fileMimeInputStream = userPolicyMimeInputStream = new FileMimeInputStream(zipTempFileName, "Benutzerrichtlinien.zip", "application/zip");
            return fileMimeInputStream;
        }
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        try {
            return this.getMimeStreamImpl(parameters);
        }
        catch (Exception e) {
            throw new PreviewException((Throwable)e);
        }
    }

    private class LocalStyles {
        OdfStyle signatureBoxStyle;
        OdfStyle innerSignatureBoxStyle;

        private LocalStyles() {
        }
    }
}

