/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DigestCalculator;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkType;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.SignatureCalculator;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.NetworkJoin;
import at.cdes.impl.dao.GenNetworkDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcNetworkDAO
extends AbstrIdDAO<Network>
implements GenNetworkDAO {
    public AbstractJdbcNetworkDAO() {
        super(Network.class, "id", "network", new String[]{"id", "name", "network_type_id", "description", "maintainer_id", "digest_calculator_id", "signature_calculator_id", "ambiguous_project_codes"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcNetworkDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "maintainer_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_calculator_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "ambiguous_project_codes") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcNetworkDAO.getSelectClauseForDto("network", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcNetworkDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".network_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".maintainer_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "maintainer_id") + "," + entityLocalName + ".digest_calculator_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + "," + entityLocalName + ".signature_calculator_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_calculator_id") + "," + entityLocalName + ".ambiguous_project_codes" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "ambiguous_project_codes") + " ";
    }

    protected Network fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Network network = new Network();
        network.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        network.setName(rs.getString(++columnIndex));
        network.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        network.setDescription(rs.getString(++columnIndex));
        network.setMaintainerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        network.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        network.setSignatureCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        network.setAmbiguousProjectCodes(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        return network;
    }

    public static Network fillNetworkFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Network network = new Network();
        network.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        network.setName(rs.getString(columnIndex.incrementAndGet()));
        network.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        network.setDescription(rs.getString(columnIndex.incrementAndGet()));
        network.setMaintainerId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        network.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        network.setSignatureCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        network.setAmbiguousProjectCodes(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return network;
    }

    public static Network fillNetworkFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcNetworkDAO.fillNetworkFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 8;
    }

    public static ContextJoin fillContextJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ContextJoin contextJoin = new ContextJoin();
        contextJoin.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setNetworkName(rs.getString(++columnIndex));
        contextJoin.setObjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setObjectCode(rs.getString(++columnIndex));
        contextJoin.setObjectName(rs.getString(++columnIndex));
        contextJoin.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setObjectPlannerCode(rs.getString(++columnIndex));
        contextJoin.setObjectPlannerArea(rs.getString(++columnIndex));
        contextJoin.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setProjectCode(rs.getString(++columnIndex));
        contextJoin.setProjectName(rs.getString(++columnIndex));
        contextJoin.setProjectComment(rs.getString(++columnIndex));
        contextJoin.setProjectStretchName(rs.getString(++columnIndex));
        contextJoin.setProjectStretchKmFrom(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setProjectStretchKmTo(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setProjectLocalisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setProjectStatus(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setProjectAccess(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setProjectUsePDCStartDateForTasks(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setProjectCountryId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setProjectCountryCode2(rs.getString(++columnIndex));
        contextJoin.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setSubProjectCode(rs.getString(++columnIndex));
        contextJoin.setSubProjectName(rs.getString(++columnIndex));
        contextJoin.setSubProjectNumber(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setSubProjectObjectListId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setSubProjectSubProjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setSubProjectAsBuiltReference(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setSubProjectReadOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setSubProjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        contextJoin.setSubProjectTypeCode(rs.getString(++columnIndex));
        contextJoin.setSubProjectTypeName(rs.getString(++columnIndex));
        contextJoin.setSubProjectTypeIsAsBuiltType(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        return contextJoin;
    }

    public static int getNumberOfContextJoinAttributes() {
        return 33;
    }

    public static NetworkJoin fillNetworkJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        NetworkJoin networkJoin = new NetworkJoin();
        networkJoin.setMaintainerOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setMaintainerOrganisationName(rs.getString(++columnIndex));
        networkJoin.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkName(rs.getString(++columnIndex));
        networkJoin.setNetworkNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkDescription(rs.getString(++columnIndex));
        networkJoin.setNetworkMaintainerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkSignatureCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkAmbiguousProjectCodes(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkPersonNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkPersonOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkPersonRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setNetworkPersonMainPerson(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setOrganisationName(rs.getString(++columnIndex));
        networkJoin.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkJoin.setPersonGivenName(rs.getString(++columnIndex));
        networkJoin.setPersonSurName(rs.getString(++columnIndex));
        return networkJoin;
    }

    public static int getNumberOfNetworkJoinAttributes() {
        return 21;
    }

    protected String getSelectClauseForContextJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("network") ? result + "network.id, network.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("object") ? result + "object.id, object.code, object.name" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlanner") ? result + "object_planner.id, object_planner.code, object_planner.area" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("project") ? result + "project.id, project.code, project.name, project.comment, project.stretch_name, project.stretch_km_from, project.stretch_km_to, project.localisation_id, project.status, project.access, project.use_PDCStartDate_For_Tasks" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("projectCountry") ? result + "project_country.id, project_country.code2" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("subProject") ? result + "sub_project.id, sub_project.code, sub_project.name, sub_project.number, sub_project.object_list_id, sub_project.sub_project_type_id, sub_project.as_built_reference, sub_project.read_only" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("subProjectType") ? result + "sub_project_type.id, sub_project_type.code, sub_project_type.name, sub_project_type.is_as_built_type" : result + "NULL, NULL, NULL, NULL";
        return result;
    }

    protected String getSelectClauseForNetworkJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("maintainerOrganisation") ? result + "maintainer_organisation.id, maintainer_organisation.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("network") ? result + "network.id, network.name, network.network_type_id, network.description, network.maintainer_id, network.digest_calculator_id, network.signature_calculator_id, network.ambiguous_project_codes" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("networkPerson") ? result + "network_person.id, network_person.network_id, network_person.organisation_person_id, network_person.role_id, network_person.isMain" : result + "NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisation") ? result + "organisation.id, organisation.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisationPerson") ? result + "organisation_person.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        return result;
    }

    public int update(Network dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Network> dtos) {
        Iterator<Network> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getContextJoinSelectClause() {
        return "network.id, network.name, object.id, object.code, object.name, object_planner.id, object_planner.code, object_planner.area, project.id, project.code, project.name, project.comment, project.stretch_name, project.stretch_km_from, project.stretch_km_to, project.localisation_id, project.status, project.access, project.use_PDCStartDate_For_Tasks, project_country.id, project_country.code2, sub_project.id, sub_project.code, sub_project.name, sub_project.number, sub_project.object_list_id, sub_project.sub_project_type_id, sub_project.as_built_reference, sub_project.read_only, sub_project_type.id, sub_project_type.code, sub_project_type.name, sub_project_type.is_as_built_type ";
    }

    public static String getPrefixedContextJoinSelectClause() {
        return "network.id AS network_id, network.name AS network_name, object.id AS object_id, object.code AS object_code, object.name AS object_name, object_planner.id AS object_planner_id, object_planner.code AS object_planner_code, object_planner.area AS object_planner_area, project.id AS project_id, project.code AS project_code, project.name AS project_name, project.comment AS project_comment, project.stretch_name AS project_stretch_name, project.stretch_km_from AS project_stretch_km_from, project.stretch_km_to AS project_stretch_km_to, project.localisation_id AS project_localisation_id, project.status AS project_status, project.access AS project_access, project.use_PDCStartDate_For_Tasks AS project_use_PDCStartDate_For_Tasks, project_country.id AS project_country_id, project_country.code2 AS project_country_code2, sub_project.id AS sub_project_id, sub_project.code AS sub_project_code, sub_project.name AS sub_project_name, sub_project.number AS sub_project_number, sub_project.object_list_id AS sub_project_object_list_id, sub_project.sub_project_type_id AS sub_project_sub_project_type_id, sub_project.as_built_reference AS sub_project_as_built_reference, sub_project.read_only AS sub_project_read_only, sub_project_type.id AS sub_project_type_id, sub_project_type.code AS sub_project_type_code, sub_project_type.name AS sub_project_type_name, sub_project_type.is_as_built_type AS sub_project_type_is_as_built_type ";
    }

    public static String getNetworkJoinSelectClause() {
        return "maintainer_organisation.id, maintainer_organisation.name, network.id, network.name, network.network_type_id, network.description, network.maintainer_id, network.digest_calculator_id, network.signature_calculator_id, network.ambiguous_project_codes, network_person.id, network_person.network_id, network_person.organisation_person_id, network_person.role_id, network_person.isMain, organisation.id, organisation.name, organisation_person.id, person.id, person.givenName, person.surName ";
    }

    public static String getPrefixedNetworkJoinSelectClause() {
        return "maintainer_organisation.id AS maintainer_organisation_id, maintainer_organisation.name AS maintainer_organisation_name, network.id AS network_id, network.name AS network_name, network.network_type_id AS network_network_type_id, network.description AS network_description, network.maintainer_id AS network_maintainer_id, network.digest_calculator_id AS network_digest_calculator_id, network.signature_calculator_id AS network_signature_calculator_id, network.ambiguous_project_codes AS network_ambiguous_project_codes, network_person.id AS network_person_id, network_person.network_id AS network_person_network_id, network_person.organisation_person_id AS network_person_organisation_person_id, network_person.role_id AS network_person_role_id, network_person.isMain AS network_person_isMain, organisation.id AS organisation_id, organisation.name AS organisation_name, organisation_person.id AS organisation_person_id, person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Network network) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)network.getId());
        statement.setString(2, network.getName());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)network.getNetworkTypeId());
        statement.setString(4, network.getDescription());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)network.getMaintainerId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)network.getDigestCalculatorId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)network.getSignatureCalculatorId());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)8, (Boolean)network.getAmbiguousProjectCodes());
    }

    @Override
    public List<Network> getByNetworkType(NetworkType networkType) {
        return this.getByNetworkType(networkType.getId());
    }

    @Override
    public List<Network> getByNetworkType(final Long networkTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkTypeId);
            }
        });
    }

    @Override
    public List<Network> getByMaintainer(Organisation organisation) {
        return this.getByMaintainer(organisation.getId());
    }

    @Override
    public List<Network> getByMaintainer(final Long organisationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"maintainer_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationId);
            }
        });
    }

    @Override
    public List<Network> getByDigestCalculator(DigestCalculator digestCalculator) {
        return this.getByDigestCalculator(digestCalculator.getId());
    }

    @Override
    public List<Network> getByDigestCalculator(final Long digestCalculatorId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, digestCalculatorId);
            }
        });
    }

    @Override
    public List<Network> getBySignatureCalculator(SignatureCalculator signatureCalculator) {
        return this.getBySignatureCalculator(signatureCalculator.getId());
    }

    @Override
    public List<Network> getBySignatureCalculator(final Long signatureCalculatorId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_calculator_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, signatureCalculatorId);
            }
        });
    }

    @Override
    public List<Network> getByNetworkTypes(Collection<Long> networkTypeId) {
        if (networkTypeId.isEmpty()) {
            return new ArrayList<Network>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkTypeId.size()];
        int n = 0;
        Iterator<Long> it = networkTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Network> getByMaintainers(Collection<Long> organisationId) {
        if (organisationId.isEmpty()) {
            return new ArrayList<Network>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationId.size()];
        int n = 0;
        Iterator<Long> it = organisationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"maintainer_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Network> getByDigestCalculators(Collection<Long> digestCalculatorId) {
        if (digestCalculatorId.isEmpty()) {
            return new ArrayList<Network>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[digestCalculatorId.size()];
        int n = 0;
        Iterator<Long> it = digestCalculatorId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Network> getBySignatureCalculators(Collection<Long> signatureCalculatorId) {
        if (signatureCalculatorId.isEmpty()) {
            return new ArrayList<Network>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[signatureCalculatorId.size()];
        int n = 0;
        Iterator<Long> it = signatureCalculatorId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_calculator_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

