/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectSearchModel;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ProjectEditJoin;
import at.cdes.api.joinDto.ProjectHolidayJoin;
import at.cdes.api.joinDto.ProjectJoin;
import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.api.joinDto.ProjectPageJoin;
import at.cdes.api.joinDto.ProjectSearchJoin;
import at.cdes.api.project.searchModel.ProjectPageSearchModel;
import at.cdes.api.voc.ProjectFlag;
import at.cdes.api.voc.ProjectStatus;
import at.cdes.api.voc.project.ProjectAccess;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcProjectDAO;
import at.cdes.impl.dao.jdbc.JdbcNetworkDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcProjectDAO
extends AbstractJdbcProjectDAO
implements ProjectDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcProjectDAO.class);
    private NetworkDAO networkDAO;

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    @Override
    public List<ProjectHolidayJoin> getHolidayJoin(final Long projectId) {
        String sql = "SELECT " + JdbcProjectDAO.getProjectHolidayJoinSelectClause() + "FROM ((project  LEFT JOIN localisation          ON     project.localisation_id = localisation.id) LEFT JOIN countries             ON     localisation.country_id = countries.id) LEFT JOIN project_holiday       ON     project_holiday.project_id = project.id WHERE project.id = ?";
        List projectHolidays = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectHolidayJoin>>(){

            public List<ProjectHolidayJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)projectId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ProjectHolidayJoin> ret = new ArrayList<ProjectHolidayJoin>();
                while (resultSet.next()) {
                    ret.add(AbstractJdbcProjectDAO.fillProjectHolidayJoinFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return projectHolidays;
    }

    @Override
    public ProjectJoin getProjectJoin(final Long projectId) {
        String sql = "SELECT " + JdbcProjectDAO.getProjectJoinSelectClause() + "FROM project LEFT JOIN project_config              ON project.project_config_id = project_config.id WHERE project.id = ? ";
        ProjectJoin projectJoin = (ProjectJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ProjectJoin>(){

            public ProjectJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList ret = new ArrayList();
                if (resultSet.next()) {
                    return AbstractJdbcProjectDAO.fillProjectJoinFromResultSet(resultSet);
                }
                return null;
            }
        });
        return projectJoin;
    }

    @Override
    public ContextJoin getProjectContextJoin(final Long projectId) {
        String sql = "SELECT " + JdbcNetworkDAO.getContextJoinSelectClause() + "FROM ((((((( project JOIN network                             ON project.network_id = network.id) JOIN localisation project_localisation   ON project.localisation_id = project_localisation.id) LEFT JOIN countries project_country      ON project_localisation.country_id = project_country.id) LEFT JOIN object_planner     ON 1=0) LEFT JOIN object             ON 1=0) LEFT JOIN sub_project        ON 1=0) LEFT JOIN sub_project_type   ON 1=0) WHERE project.id = ? ";
        return (ContextJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ContextJoin>(){

            public ContextJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    ContextJoin contextJoin = JdbcNetworkDAO.fillContextJoinFromResultSet(rs);
                    return contextJoin;
                }
                return null;
            }
        });
    }

    @Override
    public List<ProjectJoin> getProjects(final ProjectSearchModel searchModel) {
        String sql = "SELECT " + JdbcProjectDAO.getProjectJoinSelectClause() + "FROM project WHERE 1=1 ";
        if (searchModel.getNetworkId() != null) {
            sql = sql + "AND project.network_id = ? ";
        }
        if (searchModel.getStatus() != null) {
            sql = sql + "AND project.status = ? ";
        }
        List projectJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectJoin>>(){

            public List<ProjectJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (searchModel.getNetworkId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getNetworkId());
                }
                if (searchModel.getStatus() != null) {
                    JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getStatus());
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ProjectJoin> ret = new ArrayList<ProjectJoin>();
                while (resultSet.next()) {
                    ret.add(AbstractJdbcProjectDAO.fillProjectJoinFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return projectJoins;
    }

    @Override
    public List<Project> getUserVisibleByStatesAndNetwork(final Long networkId, final Integer ... states) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM project WHERE 1=1 ";
        sql = sql + "AND project.access IN (" + QueryHelper.getPlaceHolderSequence(3) + ") ";
        if (states != null && states.length > 0) {
            sql = sql + "AND project.status IN (" + QueryHelper.getPlaceHolderSequence(states.length) + ") ";
        }
        if (networkId != null) {
            sql = sql + "AND project.network_id = ? ";
        }
        List projects = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Project>>(){

            public List<Project> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectAccess.READ_ONLY.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectAccess.READ_WRITE.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectAccess.READ_ONLY_FORNONADMIN.getValue());
                if (states != null && states.length > 0) {
                    for (Integer state : states) {
                        JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)state);
                    }
                }
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<Project> ret = new ArrayList<Project>();
                while (resultSet.next()) {
                    ret.add(JdbcProjectDAO.this.fillDtoFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return projects;
    }

    @Override
    public List<ContextJoin> getContextJoinsByState(final Integer state) {
        String sql = "SELECT " + this.networkDAO.getContextJoinUnionSelectClause("network", "project") + " FROM project JOIN network              ON project.network_id = network.id WHERE 1=1 ";
        if (state != null) {
            sql = sql + "AND project.status = ? ";
        }
        List contextJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ContextJoin>>(){

            public List<ContextJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (state != null) {
                    JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)state);
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ContextJoin> ret = new ArrayList<ContextJoin>();
                while (resultSet.next()) {
                    ret.add(JdbcNetworkDAO.fillContextJoinFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return contextJoins;
    }

    @Override
    public Set<Long> getProjectIdsByOrganisationPerson(final Long organisationPersonId) {
        String sql = "SELECT DISTINCT project_participation.project_id FROM project_participant JOIN project_participation  ON project_participant.participation_id = project_participation.id WHERE project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND project_participant.organisation_person_id = ? ";
        Set projectIds = (Set)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Set<Long>>(){

            public Set<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                ResultSet resultSet = statement.executeQuery();
                HashSet<Long> ret = new HashSet<Long>();
                while (resultSet.next()) {
                    ret.add(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
                }
                return ret;
            }
        });
        return projectIds;
    }

    @Override
    public List<Long> getProjectIdsByProjectParticipations(final List<Long> projectParticipationIds) {
        if (projectParticipationIds.size() == 0) {
            return new ArrayList<Long>();
        }
        String sql = "SELECT DISTINCT project_participation.project_id FROM project_participation WHERE project_participation.id IN (" + QueryHelper.getPlaceHolderSequence(projectParticipationIds.size()) + ")";
        List projectIds = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Long>>(){

            public List<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long projectParticipationId : projectParticipationIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectParticipationId);
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<Long> ret = new ArrayList<Long>();
                while (resultSet.next()) {
                    ret.add(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
                }
                return ret;
            }
        });
        return projectIds;
    }

    @Override
    public List<Long> getProjectIdsByMetaInformations(final List<Long> metaInformationIds) {
        if (metaInformationIds.size() == 0) {
            return new ArrayList<Long>();
        }
        String sql = "SELECT DISTINCT planning_notification_project_map.project_id FROM ((             planning_notification_project_map JOIN planning_notification                         ON planning_notification_project_map.planning_notification_id = planning_notification.id) JOIN planning_notification_meta_information        ON planning_notification_meta_information.planning_notification_id = planning_notification.id) WHERE planning_notification_meta_information.meta_information_id IN (" + QueryHelper.getPlaceHolderSequence(metaInformationIds.size()) + ")";
        List projectIds = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Long>>(){

            public List<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long metaInformationId : metaInformationIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)metaInformationId);
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<Long> ret = new ArrayList<Long>();
                while (resultSet.next()) {
                    ret.add(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
                }
                return ret;
            }
        });
        return projectIds;
    }

    @Override
    public List<Long> getProjectIdsByWorkflowNodePositionIds(final List<Long> workflowNodePositionIds) {
        if (workflowNodePositionIds.size() == 0) {
            return new ArrayList<Long>();
        }
        String sql = "SELECT DISTINCT planning_notification_project_map.project_id FROM ((((((         planning_notification_project_map JOIN planning_notification           ON planning_notification_project_map.planning_notification_id = planning_notification.id) JOIN planning_notification_order     ON planning_notification_order.planning_notification_id = planning_notification.id) JOIN workflow_entity                 ON planning_notification_order.workflow_entity_id = workflow_entity.id) JOIN workflow                        ON workflow_entity.workflow_id = workflow.id) JOIN workflow_node                   ON workflow_node.workflow_id = workflow.id) JOIN workflow_node_position          ON workflow_node_position.workflow_node_id = workflow_node.id) WHERE workflow_node_position.id IN (" + QueryHelper.getPlaceHolderSequence(workflowNodePositionIds.size()) + ")";
        List projectIds = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Long>>(){

            public List<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long workflowNodePositionId : workflowNodePositionIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)workflowNodePositionId);
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<Long> ret = new ArrayList<Long>();
                while (resultSet.next()) {
                    ret.add(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
                }
                return ret;
            }
        });
        return projectIds;
    }

    @Override
    public List<Long> getProjectIdsByWorkflowIds(final List<Long> workflowIds) {
        if (workflowIds.size() == 0) {
            return new ArrayList<Long>();
        }
        String sql = "SELECT DISTINCT planning_notification_project_map.project_id FROM ((((           planning_notification_project_map JOIN planning_notification           ON planning_notification_project_map.planning_notification_id = planning_notification.id) JOIN planning_notification_order     ON planning_notification_order.planning_notification_id = planning_notification.id) JOIN workflow_entity                 ON planning_notification_order.workflow_entity_id = workflow_entity.id) JOIN workflow                        ON workflow_entity.workflow_id = workflow.id) WHERE workflow.id IN (" + QueryHelper.getPlaceHolderSequence(workflowIds.size()) + ")";
        List projectIds = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Long>>(){

            public List<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long workflowId : workflowIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)workflowId);
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<Long> ret = new ArrayList<Long>();
                while (resultSet.next()) {
                    ret.add(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
                }
                return ret;
            }
        });
        return projectIds;
    }

    @Override
    public List<Long> getProjectIdsByPlanningNotificationAttachmentIds(final Long ... planningNotificationAttachmentIds) {
        if (planningNotificationAttachmentIds.length == 0) {
            return new ArrayList<Long>();
        }
        String sql = "SELECT DISTINCT planning_notification_project_map.project_id FROM ((((((         planning_notification_project_map JOIN planning_notification                 ON planning_notification_project_map.planning_notification_id = planning_notification.id) JOIN planning_notification_order           ON planning_notification_order.planning_notification_id = planning_notification.id) JOIN workflow_entity                       ON planning_notification_order.workflow_entity_id = workflow_entity.id) JOIN workflow                              ON workflow_entity.workflow_id = workflow.id) JOIN workflow_activity                     ON workflow_activity.workflow_id = workflow.id) JOIN workflow_activity_position_result_map ON workflow_activity_position_result_map.result_id = workflow_activity.id) WHERE workflow_activity_position_result_map.attachment_id IN (" + QueryHelper.getPlaceHolderSequence(planningNotificationAttachmentIds.length) + ")";
        List projectIds = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Long>>(){

            public List<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long planningNotificationAttachmentId : planningNotificationAttachmentIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)planningNotificationAttachmentId);
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<Long> ret = new ArrayList<Long>();
                while (resultSet.next()) {
                    ret.add(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
                }
                return ret;
            }
        });
        return projectIds;
    }

    @Override
    public List<Project> getByPlanningNotification(final Long planningNotificationId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM (        project JOIN planning_notification_project_map                        ON planning_notification_project_map.project_id = project.id) WHERE planning_notification_project_map.planning_notification_id = ? ";
        List projects = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Project>>(){

            public List<Project> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)planningNotificationId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<Project> ret = new ArrayList<Project>();
                while (resultSet.next()) {
                    ret.add(JdbcProjectDAO.this.fillDtoFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return projects;
    }

    @Override
    public Project getBySubProject(final Long subProjectId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM (         sub_project JOIN project        ON sub_project.project_id = project.id)WHERE sub_project.id = ?";
        Project project = (Project)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Project>(){

            public Project perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    return JdbcProjectDAO.this.fillDtoFromResultSet(resultSet);
                }
                return null;
            }
        });
        return project;
    }

    @Override
    public Project getByParticipation(final Long projectParticipationId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM (         project_participation JOIN project                ON project_participation.project_id = project.id)WHERE project_participation.id = ?";
        Project project = (Project)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Project>(){

            public Project perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectParticipationId);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    return JdbcProjectDAO.this.fillDtoFromResultSet(resultSet);
                }
                return null;
            }
        });
        return project;
    }

    @Override
    public Project getByParticipant(Long participantId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM project_participant JOIN project_participation ON project_participant.participation_id = project_participation.id JOIN project               ON project_participation.project_id = project.id WHERE project_participant.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participantId);
        });
    }

    @Override
    public Project getByDocumentVersionTask(Long documentVersionTaskId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM document_version_task JOIN document_version ON document_version_task.document_version_id = document_version.id JOIN document         ON document_version.document_id = document.id JOIN object_planner   ON document.object_planner_id = object_planner.id JOIN object           ON object_planner.object_id = object.id JOIN object_list      ON object.object_list_id = object_list.id JOIN sub_project      ON object_list.sub_project_id = sub_project.id JOIN project          ON sub_project.project_id = project.id WHERE document_version_task.task_id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionTaskId);
        });
    }

    @Override
    public Project getByDocumentVersion(Long documentVersionId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM document_version JOIN document         ON document_version.document_id = document.id JOIN object_planner   ON document.object_planner_id = object_planner.id JOIN object           ON object_planner.object_id = object.id JOIN object_list      ON object.object_list_id = object_list.id JOIN sub_project      ON object_list.sub_project_id = sub_project.id JOIN project          ON sub_project.project_id = project.id WHERE document_version.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
        });
    }

    @Override
    public Project getByDocument(Long documentId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM document JOIN object_planner   ON document.object_planner_id = object_planner.id JOIN object           ON object_planner.object_id = object.id JOIN object_list      ON object.object_list_id = object_list.id JOIN sub_project      ON object_list.sub_project_id = sub_project.id JOIN project          ON sub_project.project_id = project.id WHERE document.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
        });
    }

    @Override
    public Project getByDocumentTask(Long documentTaskId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM document_task JOIN document         ON document_task.document_id = document.id JOIN object_planner   ON document.object_planner_id = object_planner.id JOIN object           ON object_planner.object_id = object.id JOIN object_list      ON object.object_list_id = object_list.id JOIN sub_project      ON object_list.sub_project_id = sub_project.id JOIN project          ON sub_project.project_id = project.id WHERE document_version_task.task_id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentTaskId);
        });
    }

    @Override
    public Project getByOriginalDocumentOrder(Long originalDocumentOrderId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM original_document_order JOIN sub_project              ON original_document_order.sub_project_id = sub_project.id JOIN project                  ON sub_project.project_id = project.id WHERE original_document_order.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)originalDocumentOrderId);
        });
    }

    @Override
    public List<Project> getByMasterDataSet(Long masterDataSetId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM document_number_part_group JOIN project                    ON project.document_number_part_group_id = document_number_part_group.id WHERE document_number_part_group.master_data_set_id = ? ORDER BY project.code ASC ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)masterDataSetId);
        });
    }

    @Override
    public ProjectLocalisationJoin getLocalisationJoinByProject(final Long projectId) {
        String sql = "SELECT " + JdbcProjectDAO.getProjectLocalisationJoinSelectClause() + "FROM (((      project JOIN localisation      ON project.localisation_id = localisation.id) JOIN countries country ON localisation.country_id = country.id) LEFT JOIN project_config    ON project.project_config_id = project_config.id) WHERE project.id = ?";
        ProjectLocalisationJoin localisationJoin = (ProjectLocalisationJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ProjectLocalisationJoin>(){

            public ProjectLocalisationJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    return AbstractJdbcProjectDAO.fillProjectLocalisationJoinFromResultSet(resultSet);
                }
                return null;
            }
        });
        return localisationJoin;
    }

    @Override
    public ProjectLocalisationJoin getLocalisationJoinBySubProject(final Long subProjectId) {
        String sql = "SELECT " + JdbcProjectDAO.getProjectLocalisationJoinSelectClause() + "FROM (((( sub_project JOIN project           ON sub_project.project_id = project.id) JOIN localisation      ON project.localisation_id = localisation.id) JOIN countries country ON localisation.country_id = country.id) LEFT JOIN project_config    ON project.project_config_id = project_config.id) WHERE sub_project.id = ?";
        ProjectLocalisationJoin localisationJoin = (ProjectLocalisationJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ProjectLocalisationJoin>(){

            public ProjectLocalisationJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    return AbstractJdbcProjectDAO.fillProjectLocalisationJoinFromResultSet(resultSet);
                }
                return null;
            }
        });
        return localisationJoin;
    }

    @Override
    public List<ProjectSearchJoin> getProjectSearchJoins() {
        String sql = "SELECT " + this.getSelectClauseForProjectSearchJoinUnion("network") + "\nFROM network\nUNION ALL SELECT " + this.getSelectClauseForProjectSearchJoinUnion("network", "project") + "\nFROM network\nJOIN project ON project.network_id = network.id AND project.status != " + ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue() + "\nUNION ALL SELECT " + this.getSelectClauseForProjectSearchJoinUnion("network", "project", "subProject") + "\nFROM network\nJOIN project ON project.network_id = network.id AND project.status != " + ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue() + "\nJOIN sub_project ON sub_project.project_id = project.id\nWHERE sub_project.invalidated = 0\nUNION ALL SELECT " + this.getSelectClauseForProjectSearchJoinUnion("network", "projectLeader", "organisation") + "\nFROM network\nJOIN project ON project.network_id = network.id AND project.status != " + ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue() + "\nJOIN project_participation ON project_participation.project_id = project.id\nJOIN cdes_role ON cdes_role.id = project_participation.role_id\nJOIN project_participant ON project_participant.participation_id = project_participation.id\n                        AND project_participant.main_participant_flag = 1\n                        AND project_participant.inactive_flag = 0\nJOIN organisation_person ON organisation_person.id = project_participant.organisation_person_id\nJOIN person project_leader ON project_leader.id = organisation_person.person_id\nJOIN organisation          ON organisation_person.organisation_id = organisation.id\nWHERE project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND cdes_role.project_flag = 2\n";
        return (List)this.performWithPreparedStatement(sql, statement -> {
            ResultSet resultSet = statement.executeQuery();
            ArrayList<ProjectSearchJoin> ret = new ArrayList<ProjectSearchJoin>();
            while (resultSet.next()) {
                ProjectSearchJoin join = JdbcProjectDAO.fillProjectSearchJoinFromResultSet(resultSet);
                if (join.getProjectId() != null && join.getSubProjectId() == null) {
                    join.setUnionClause(Integer.valueOf(0));
                } else if (join.getSubProjectId() != null) {
                    join.setUnionClause(Integer.valueOf(1));
                } else if (join.getProjectLeaderId() != null) {
                    join.setUnionClause(Integer.valueOf(2));
                } else {
                    join.setUnionClause(Integer.valueOf(3));
                }
                ret.add(join);
            }
            return ret;
        });
    }

    private static String escapeLike(String str) {
        return str.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
    }

    @Override
    public List<ProjectPageJoin> getProjectPageJoins(Long organisationPersonId, ProjectPageSearchModel searchModel) {
        String sql = "SELECT " + this.getProjectPageJoinSelectClause() + "\n     FROM network\n     JOIN project               ON project.network_id = network.id AND project.status != " + ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue() + "\nLEFT JOIN (     project_participation\n           JOIN cdes_role ON project_participation.role_id = cdes_role.id)\nON project_participation.project_id = project.id\nAND project_participation.invalidated = 0\nAND cdes_role.project_flag = 2\nLEFT JOIN project_participant project_leader\n                                ON project_leader.participation_id = project_participation.id\n                               AND project_leader.inactive_flag = 0\n                               AND project_leader.main_participant_flag = 1\nLEFT JOIN organisation_person  project_leader_organisation_person__\n                                ON project_leader_organisation_person__.id = project_leader.organisation_person_id\nLEFT JOIN organisation project_leader_organisation__\n                                ON project_leader_organisation_person__.organisation_id = project_leader_organisation__.id\nLEFT JOIN person project_leader_person__\n                                ON project_leader_person__.id = project_leader_organisation_person__.person_id\nLEFT JOIN organisation_person project_creator_organisation_person\n                                ON project.created_by_id = project_creator_organisation_person.id\nLEFT JOIN person project_creator_person\nON project_creator_organisation_person.person_id = project_creator_person.id\nLEFT JOIN sub_project           ON sub_project.project_id = project.id\n                               AND sub_project.invalidated = 0\nLEFT JOIN sub_project_type      ON sub_project.sub_project_type_id = sub_project_type.id\nWHERE 1=1\n";
        Long networkId = searchModel.getNetworkId();
        String networkString = searchModel.getNetworkString();
        Long projectId = searchModel.getProjectId();
        String projectString = searchModel.getProjectString();
        Long subProjectId = searchModel.getSubProjectId();
        String subProjectString = searchModel.getSubProjectString();
        Long projectLeaderPersonId = searchModel.getProjectLeaderPersonId();
        String projectLeaderPersonString = searchModel.getProjectLeaderString();
        List projectStati = searchModel.getStatus();
        if (networkId != null) {
            sql = sql + "AND network.id = ?\n";
        }
        if (networkString != null && networkString.length() > 0) {
            sql = sql + "AND network.name LIKE (CONCAT('%', ?, '%'))\n";
        }
        if (projectId != null) {
            sql = sql + "AND project.id = ?\n";
        }
        if (projectString != null && projectString.length() > 0) {
            sql = sql + "AND project.name LIKE (CONCAT('%', ?, '%'))\n";
        }
        if (subProjectId != null) {
            sql = sql + "AND EXISTS (SELECT 1 as t\nFROM sub_project local_sub_project\nWHERE local_sub_project.id = ?\nAND local_sub_project.project_id = project.id)\n";
        }
        if (subProjectString != null && subProjectString.length() > 0) {
            sql = sql + "AND EXISTS (SELECT 1 as t\nFROM sub_project local_sub_project\nWHERE CONCAT('(', local_sub_project.code, COALESCE(local_sub_project.number, ''), ') ', local_sub_project.name) LIKE (CONCAT('%', ?, '%'))\nAND local_sub_project.project_id = project.id)\n";
        }
        if (projectLeaderPersonId != null) {
            sql = sql + "AND project_leader_person__.id = ?\n";
        }
        if (projectLeaderPersonString != null && projectLeaderPersonString.length() > 0) {
            sql = sql + "AND CONCAT(project_leader_person__.given_name, ' ', project_leader_person__.sur_name) LIKE (CONCAT('%', ?, '%'))\n";
        }
        if (projectStati != null && projectStati.size() > 0) {
            sql = sql + "AND project.status IN (" + QueryHelper.getPlaceHolderSequence(searchModel.getStatus().size()) + ")\n";
        }
        if (log.isDebugEnabled()) {
            log.debug(sql);
        }
        return (List)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            if (networkId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getNetworkId());
                if (log.isDebugEnabled()) {
                    log.debug("Set networkId [" + searchModel.getNetworkId() + "] to statement.");
                }
            }
            if (networkString != null && networkString.length() > 0) {
                statement.setString(currIndex++, JdbcProjectDAO.escapeLike(searchModel.getNetworkString()));
                if (log.isDebugEnabled()) {
                    log.debug("Set networkString [" + searchModel.getNetworkString() + "] to statement.");
                }
            }
            if (projectId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getProjectId());
                if (log.isDebugEnabled()) {
                    log.debug("Set projectId [" + searchModel.getProjectId() + "] to statement.");
                }
            }
            if (projectString != null && projectString.length() > 0) {
                statement.setString(currIndex++, JdbcProjectDAO.escapeLike(searchModel.getProjectString()));
                if (log.isDebugEnabled()) {
                    log.debug("Set projectString [" + searchModel.getProjectString() + "] to statement.");
                }
            }
            if (subProjectId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getSubProjectId());
                if (log.isDebugEnabled()) {
                    log.debug("Set subProjectId [" + searchModel.getSubProjectId() + "] to statement.");
                }
            }
            if (subProjectString != null && subProjectString.length() > 0) {
                statement.setString(currIndex++, JdbcProjectDAO.escapeLike(searchModel.getSubProjectString()));
                if (log.isDebugEnabled()) {
                    log.debug("Set subProjectString [" + searchModel.getSubProjectString() + "] to statement.");
                }
            }
            if (projectLeaderPersonId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getProjectLeaderPersonId());
                if (log.isDebugEnabled()) {
                    log.debug("Set projectLeaderPersonId [" + searchModel.getProjectLeaderPersonId() + "] to statement.");
                }
            }
            if (projectLeaderPersonString != null && projectLeaderPersonString.length() > 0) {
                statement.setString(currIndex++, JdbcProjectDAO.escapeLike(searchModel.getProjectLeaderString()));
                if (log.isDebugEnabled()) {
                    log.debug("Set projectLeaderString [" + searchModel.getProjectLeaderString() + "] to statement.");
                }
            }
            if (projectStati != null && projectStati.size() > 0) {
                for (ProjectStatus status : searchModel.getStatus()) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)status.getValue());
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Set status [" + status + "] to statement.");
                }
            }
            ResultSet resultSet = statement.executeQuery();
            ArrayList<ProjectPageJoin> ret = new ArrayList<ProjectPageJoin>();
            while (resultSet.next()) {
                ProjectPageJoin join = JdbcProjectDAO.fillProjectPageJoinFromResultSet(resultSet);
                ret.add(join);
            }
            return ret;
        });
    }

    @Override
    public List<Project> getByCode(String code, Long networkId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM project\nWHERE project.code = ? AND project.network_id = ?\n";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            statement.setString(currIndex++, code);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        });
    }

    @Override
    public List<ProjectEditJoin> getProjectEditJoins(Long projectId) {
        String sql = "SELECT " + JdbcProjectDAO.getProjectEditJoinSelectClause() + "FROM object_planner_definition LEFT JOIN object_planner_position_definition ON object_planner_position_definition.definition_id = object_planner_definition.id LEFT JOIN role_type                          ON object_planner_position_definition.role_type_id = role_type.id WHERE object_planner_definition.project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcProjectDAO::fillProjectEditJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        });
    }

    @Override
    public Set<Long> getLeadedProjectIdsByProjectFlags(Long organisationPersonId, ProjectFlag ... projectFlags) {
        String sql = "SELECT project_participation.project_id FROM project_participant JOIN project_participation        ON project_participant.participation_id = project_participation.id JOIN cdes_role                    ON project_participation.role_id = cdes_role.id WHERE project_participant.inactive_flag = 0 AND project_participant.organisation_person_id = ? AND project_participation.invalidated = 0 AND cdes_role.project_flag IN (" + QueryHelper.getPlaceHolderSequence(projectFlags.length) + ") ";
        return (Set)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
            for (ProjectFlag projectFlag : projectFlags) {
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)projectFlag.getValue());
            }
            ResultSet resultSet = statement.executeQuery();
            HashSet<Long> leadedProjectIds = new HashSet<Long>();
            while (resultSet.next()) {
                Long projectId = JDBCHelper.getLong((ResultSet)resultSet, (int)1);
                leadedProjectIds.add(projectId);
            }
            return leadedProjectIds;
        });
    }

    @Override
    public List<Project> getActiveProjectsByMasterDataSetId(Long masterDataSetId) {
        String sql = "SELECT " + JdbcProjectDAO.getSelectClauseForDto() + "FROM document_number_part_group JOIN project                     ON project.document_number_part_group_id = document_number_part_group.id WHERE document_number_part_group.master_data_set_id = ? AND project.access != ? AND project.status = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)masterDataSetId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ProjectAccess.INVISIBLE.getValue());
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ProjectStatus.ACTIVE.getValue());
        });
    }
}

