/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.joinDto.ParticipationDeleteJoin;
import at.cdes.api.joinDto.ParticipationInvalidatableJoin;
import at.cdes.api.joinDto.ParticipationListJoin;
import at.cdes.api.joinDto.ParticipationPageEditJoin;
import at.cdes.api.joinDto.ParticipationPageSearchJoin;
import at.cdes.api.joinDto.ParticipationSelectionJoin;
import at.cdes.api.joinDto.ProjectParticipationJoin;
import at.cdes.api.project.searchModel.ParticipationPageSearchModel;
import at.cdes.api.project.searchModel.ProjectParticipationSearchModel;
import at.cdes.api.voc.OrderStepMode;
import at.cdes.api.voc.ProjectFlag;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcProjectParticipationDAO;
import at.cdes.impl.dao.unionComponent.ParticipationDeleteComponent;
import at.cdes.impl.dao.unionComponent.ParticipationInvalidatableComponent;
import at.cdes.impl.dao.unionComponent.ParticipationPageEditUnionComponent;
import at.cdes.impl.dao.unionComponent.ParticipationPageSearchUnionComponent;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcProjectParticipationDAO
extends AbstractJdbcProjectParticipationDAO
implements ProjectParticipationDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcProjectParticipationDAO.class);

    @Override
    public Set<Long> getActiveParticipationIdsByOrganisationPerson(final Long organisationPersonId) {
        String sql = "SELECT project_participation.id FROM project_participation JOIN project_participant      ON project_participant.participation_id = project_participation.id WHERE project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND project_participant.organisation_person_id = ? ";
        Set participationIds = (Set)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Set<Long>>(){

            public Set<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                ResultSet rs = statement.executeQuery();
                HashSet<Long> participationIds = new HashSet<Long>();
                while (rs.next()) {
                    participationIds.add(JDBCHelper.getLong((ResultSet)rs, (int)1));
                }
                return participationIds;
            }
        });
        return participationIds;
    }

    @Override
    public Set<Long> getActiveParticipationIdsByByProjectAndOrganisationPerson(final Long projectId, final Long organisationPersonId) {
        String sql = "SELECT project_participation.id FROM project_participation JOIN project_participant      ON project_participant.participation_id = project_participation.id WHERE project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND project_participant.organisation_person_id = ? AND project_participation.project_id = ? ";
        Set participationIds = (Set)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Set<Long>>(){

            public Set<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                HashSet<Long> participationIds = new HashSet<Long>();
                while (rs.next()) {
                    participationIds.add(JDBCHelper.getLong((ResultSet)rs, (int)1));
                }
                return participationIds;
            }
        });
        return participationIds;
    }

    @Override
    public List<ProjectParticipation> getParticipationsByOrganisationPerson(final Long organisationPersonId) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participant JOIN project_participation ON project_participant.participation_id = project_participation.id WHERE project_participant.organisation_person_id = ? ";
        List projectParticipants = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipation>>(){

            public List<ProjectParticipation> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipation> ret = new ArrayList<ProjectParticipation>();
                while (rs.next()) {
                    ret.add(JdbcProjectParticipationDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        return projectParticipants;
    }

    @Override
    public List<ProjectParticipation> getActiveParticipationsByProjectAndOrganisation(Long projectId, Long organisationId) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation WHERE project_participation.invalidated = 0 AND project_participation.project_id = ? AND project_participation.organisation_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
        });
    }

    @Override
    public Map<Long, ProjectParticipation> getMainOrOtherParticipationByOrganisationPersons(final Long projectId, final Collection<Long> organisationPersonIds) {
        String selectClauseForDto = JdbcProjectParticipationDAO.getSelectClauseForDto();
        int numberOfCommas = 0;
        Integer currCommaIndex = null;
        while (currCommaIndex == null || currCommaIndex != -1) {
            if ((currCommaIndex = Integer.valueOf(selectClauseForDto.indexOf(44, currCommaIndex == null ? 0 : currCommaIndex + 1))) == -1) continue;
            ++numberOfCommas;
        }
        final int numberOfDtoAttributes = numberOfCommas + 1;
        String sql = "SELECT " + selectClauseForDto + ", organisation_person.id FROM ((( organisation_person LEFT JOIN project_participant main_participant     ON main_participant.id = (SELECT max(local_main_participant.id) FROM project_participant local_main_participant, project_participation local_main_participation WHERE       local_main_participation.project_id = ? AND local_main_participant.participation_id = local_main_participation.id AND local_main_participant.organisation_person_id = organisation_person.id AND local_main_participant.inactive_flag = 0 AND local_main_participant.main_participant_flag = 1)) LEFT JOIN project_participant other_participant    ON other_participant.id = (SELECT max(local_other_participant.id) FROM project_participant local_other_participant, project_participation local_other_participation WHERE       local_other_participation.project_id = ? AND local_other_participant.participation_id = local_other_participation.id AND local_other_participant.organisation_person_id = organisation_person.id AND local_other_participant.inactive_flag = 0)) LEFT JOIN project_participation ON       (     main_participant.id IS NOT NULL AND main_participant.participation_id = project_participation.id) OR (     main_participant.id IS NULL AND other_participant.id IS NOT NULL AND other_participant.participation_id = project_participation.id)) WHERE organisation_person.id IN (" + QueryHelper.getPlaceHolderSequence(organisationPersonIds.size()) + ") AND project_participation.project_id = ? ";
        Map organisationPersonIdToProjectParticipation = (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, ProjectParticipation>>(){

            public Map<Long, ProjectParticipation> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                for (Long organisationPersonId : organisationPersonIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                }
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                HashMap<Long, ProjectParticipation> organisationPersonIdToProjectParticipation = new HashMap<Long, ProjectParticipation>();
                while (rs.next()) {
                    ProjectParticipation projectParticipation = JdbcProjectParticipationDAO.this.fillDtoFromResultSet(rs);
                    Long organisationPersonId = JDBCHelper.getLong((ResultSet)rs, (int)(numberOfDtoAttributes + 1));
                    organisationPersonIdToProjectParticipation.put(organisationPersonId, projectParticipation);
                }
                return organisationPersonIdToProjectParticipation;
            }
        });
        return organisationPersonIdToProjectParticipation;
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoins(final Long roleTypeId, final Collection<Long> projectIds) {
        if (projectIds.size() == 0) {
            return new ArrayList<ProjectParticipationJoin>();
        }
        String sql = "SELECT " + JdbcProjectParticipationDAO.getProjectParticipationJoinSelectClause() + "FROM ((((((((      project_participation JOIN project_participant          ON (     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1)) JOIN organisation_person          ON project_participant.organisation_person_id = organisation_person.id) JOIN organisation                 ON organisation_person.organisation_id = organisation.id) JOIN organisation op_organisation ON op_organisation.id = organisation.id) JOIN person                       ON organisation_person.person_id = person.id) JOIN cdes_role                    ON project_participation.role_id = cdes_role.id) JOIN project                      ON project_participation.project_id = project.id) LEFT JOIN person_variables             ON person_variables.person_id = person.id) WHERE (project_participation.invalidated IS NULL OR project_participation.invalidated = 0) AND (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) AND project_participation.project_id IN (" + QueryHelper.getPlaceHolderSequence(projectIds.size()) + ") ";
        if (roleTypeId != null) {
            sql = sql + "AND cdes_role.type_id = ? ";
        }
        List joins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipationJoin>>(){

            public List<ProjectParticipationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long projectId : projectIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                }
                if (roleTypeId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)roleTypeId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipationJoin> projectParticipationJoins = new ArrayList<ProjectParticipationJoin>();
                while (rs.next()) {
                    projectParticipationJoins.add(AbstractJdbcProjectParticipationDAO.fillProjectParticipationJoinFromResultSet(rs));
                }
                ArrayList<ProjectParticipationJoin> ret = new ArrayList<ProjectParticipationJoin>();
                HashSet<Long> projectParticipationIdsAlreadyProcessed = new HashSet<Long>();
                for (ProjectParticipationJoin projectParticipationJoin : projectParticipationJoins) {
                    Long projectParticipationId = projectParticipationJoin.getProjectParticipationId();
                    if (projectParticipationIdsAlreadyProcessed.contains(projectParticipationId)) continue;
                    ret.add(projectParticipationJoin);
                    projectParticipationIdsAlreadyProcessed.add(projectParticipationId);
                }
                return ret;
            }
        });
        return joins;
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoinsByPerson(final Long personId, boolean restrictToMainParticipants) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getProjectParticipationJoinSelectClause() + "FROM  ((((((((     project_participation JOIN project_participant          ON (     project_participant.participation_id = project_participation.id " + (restrictToMainParticipants ? "AND project_participant.main_participant_flag = 1 " : "") + "AND project_participant.inactive_flag != 1)) JOIN organisation_person          ON project_participant.organisation_person_id = organisation_person.id) JOIN organisation                 ON organisation_person.organisation_id = organisation.id) JOIN organisation op_organisation ON op_organisation.id = organisation.id) JOIN person                       ON organisation_person.person_id = person.id) JOIN cdes_role                    ON project_participation.role_id = cdes_role.id) JOIN project                      ON project_participation.project_id = project.id) JOIN person_variables             ON person_variables.person_id = person.id) WHERE person.id = ?";
        List joins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipationJoin>>(){

            public List<ProjectParticipationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipationJoin> ret = new ArrayList<ProjectParticipationJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcProjectParticipationDAO.fillProjectParticipationJoinFromResultSet(rs));
                }
                return ret;
            }
        });
        return joins;
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoinsByProjectAndOrganisation(final Long projectId, final Long organisationId) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getProjectParticipationJoinSelectClause() + "FROM project_participation JOIN project_participant          ON (     project_participant.participation_id = project_participation.id AND project_participant.inactive_flag != 1) JOIN organisation_person          ON project_participant.organisation_person_id = organisation_person.id JOIN organisation                 ON organisation_person.organisation_id = organisation.id JOIN organisation op_organisation ON op_organisation.id = organisation.id JOIN person                       ON organisation_person.person_id = person.id JOIN cdes_role                    ON project_participation.role_id = cdes_role.id JOIN project                      ON project_participation.project_id = project.id JOIN person_variables             ON person_variables.person_id = person.id WHERE project_participation.project_id = ? AND organisation.id = ? ";
        List joins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipationJoin>>(){

            public List<ProjectParticipationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipationJoin> ret = new ArrayList<ProjectParticipationJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcProjectParticipationDAO.fillProjectParticipationJoinFromResultSet(rs));
                }
                return ret;
            }
        });
        return joins;
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoins(List<Long> projectParticipationIds) {
        return this.getParticipationJoins(projectParticipationIds, false);
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoins(Long projectParticipationId) {
        return this.getParticipationJoins(projectParticipationId, false);
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoins(Long projectParticipationId, boolean restrictToMainParticipant) {
        ArrayList<Long> projectParticipationIds = new ArrayList<Long>();
        projectParticipationIds.add(projectParticipationId);
        return this.getParticipationJoins(projectParticipationIds, restrictToMainParticipant);
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoins(final List<Long> projectParticipationIds, boolean restrictToMainParticipants) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getProjectParticipationJoinSelectClause() + "FROM  ((((((((      project_participation JOIN project_participant          ON (     project_participant.participation_id = project_participation.id " + (restrictToMainParticipants ? "AND project_participant.main_participant_flag = 1 " : "") + "AND project_participant.inactive_flag != 1)) JOIN organisation_person          ON project_participant.organisation_person_id = organisation_person.id) JOIN organisation                 ON organisation_person.organisation_id = organisation.id) JOIN organisation op_organisation ON op_organisation.id = organisation.id) JOIN person                       ON organisation_person.person_id = person.id) JOIN cdes_role                    ON project_participation.role_id = cdes_role.id) JOIN project                      ON project_participation.project_id = project.id) JOIN person_variables             ON person_variables.person_id = person.id) WHERE project_participation.id IN (" + QueryHelper.getPlaceHolderSequence(projectParticipationIds.size()) + ")";
        List joins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipationJoin>>(){

            public List<ProjectParticipationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long projectParticipationId : projectParticipationIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectParticipationId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipationJoin> ret = new ArrayList<ProjectParticipationJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcProjectParticipationDAO.fillProjectParticipationJoinFromResultSet(rs));
                }
                return ret;
            }
        });
        return joins;
    }

    @Override
    public ProjectParticipationJoin getParticipationJoin(Long projectParticipationId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(projectParticipationId);
        List<ProjectParticipationJoin> joins = this.getParticipationJoins(ids, true);
        return joins.size() > 0 ? joins.get(0) : null;
    }

    public static Map<Long, List<ProjectParticipationJoin>> groupParticipationJoinsByOrganisationPersonId(List<ProjectParticipationJoin> joins) {
        HashMap<Long, List<ProjectParticipationJoin>> organisationPersonIdToJoins = new HashMap<Long, List<ProjectParticipationJoin>>();
        for (ProjectParticipationJoin join : joins) {
            Long organisationPersonId = join.getOrganisationPersonId();
            if (!organisationPersonIdToJoins.containsKey(organisationPersonId)) {
                organisationPersonIdToJoins.put(organisationPersonId, new ArrayList());
            }
            ((List)organisationPersonIdToJoins.get(organisationPersonId)).add(join);
        }
        return organisationPersonIdToJoins;
    }

    public static List<Long> getParticipationIdsFromJoins(List<ProjectParticipationJoin> joins) {
        ArrayList<Long> participationIds = new ArrayList<Long>();
        for (ProjectParticipationJoin join : joins) {
            participationIds.add(join.getProjectParticipationId());
        }
        return participationIds;
    }

    @Override
    public List<ParticipationInvalidatableJoin> getInvalidatableJoin(final Long personId) {
        final String sql = "SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.OBJECT_PLANNER, "organisationPerson", "organisation", "network", "project", "subProject", "object", "objectPlanner") + "FROM (((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN object_planner                       ON    object_planner.planner_id = project_participation.id) JOIN object                               ON    object_planner.object_id = object.id) JOIN object_list                          ON    object.object_list_id = object_list.id) JOIN sub_project                          ON    object_list.sub_project_id = sub_project.id) JOIN project                              ON    sub_project.project_id = project.id) JOIN network                              ON    project.network_id = network.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.OBJECT_PLANNER_POSITION, "organisationPerson", "organisation", "network", "project", "subProject", "object", "objectPlanner", "objectPlannerPositionDefinition", "cdesRole") + "FROM ((((((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN object_planner_position              ON    object_planner_position.project_participation_id = project_participation.id) JOIN object_planner_position_definition   ON    object_planner_position.definition_id = object_planner_position_definition.id) JOIN object_planner                       ON    object_planner_position.object_planner_id = object_planner.id) JOIN object                               ON    object_planner.object_id = object.id) JOIN object_list                          ON    object.object_list_id = object_list.id) JOIN sub_project                          ON    object_list.sub_project_id = sub_project.id) JOIN project                              ON    sub_project.project_id = project.id) JOIN network                              ON    project.network_id = network.id) LEFT JOIN cdes_role                            ON    object_planner_position.role_id = cdes_role.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.OBJECT_PLANNER_RELEASE, "organisationPerson", "organisation", "network", "project", "subProject", "objectRelease", "objectPlannerRelease") + "FROM (((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN object_planner_release               ON    object_planner_release.planner_id = project_participation.id) JOIN object_release                       ON    object_planner_release.object_id = object_release.id) JOIN object_list_release                  ON    object_release.object_list_release_id = object_list_release.id) JOIN sub_project                          ON    object_list_release.sub_project_id = sub_project.id) JOIN project                              ON    sub_project.project_id = project.id) JOIN network                              ON    project.network_id = network.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) AND object_list_release.version = (SELECT MAX(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = sub_project.id) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.OBJECT_PLANNER_POSITION_RELEASE, "organisationPerson", "organisation", "network", "project", "subProject", "objectListRelease", "objectRelease", "objectPlannerRelease", "objectPlannerPositionDefinition", "cdesRole") + "FROM ((((((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN object_planner_position_release      ON    object_planner_position_release.project_participation_id = project_participation.id) JOIN object_planner_position_definition   ON    object_planner_position_release.definition_id = object_planner_position_definition.id) JOIN object_planner_release               ON    object_planner_position_release.object_planner_id = object_planner_release.id) JOIN object_release                       ON    object_planner_release.object_id = object_release.id) JOIN object_list_release                  ON    object_release.object_list_release_id = object_list_release.id) JOIN sub_project                          ON    object_list_release.sub_project_id = sub_project.id) JOIN project                              ON    sub_project.project_id = project.id) JOIN network                              ON    project.network_id = network.id) LEFT JOIN cdes_role                            ON    object_planner_position_release.role_id = cdes_role.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) AND object_list_release.version = (SELECT MAX(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = sub_project.id) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.REVIEW_CYCLE_NODE_POSITION, "organisationPerson", "organisation", "network", "project", "subProject", "reviewCycleInstance", "reviewCycleCell", "realm") + "FROM ((((((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN review_cycle_node_position           ON    review_cycle_node_position.project_participation_id = project_participation.id) JOIN review_cycle_node_instance           ON    review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_cell_instance           ON    review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id) JOIN review_cycle_instance                ON    review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id) JOIN review_cycle_cell                    ON    review_cycle_cell_instance.review_cycle_cell_id = review_cycle_cell.id) JOIN realm                                ON    review_cycle_node_position.realm_id = realm.id) JOIN sub_project                          ON    review_cycle_instance.sub_project_id = sub_project.id) JOIN project                              ON    sub_project.project_id = project.id) JOIN network                              ON    project.network_id = network.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.REVIEW_CYCLE_NODE_INSTANCE_NOTIFICATION, "organisationPerson", "organisation", "network", "project", "subProject", "reviewCycleInstance", "reviewCycle", "reviewCycleCell", "reviewCycleNode", "reviewCycleNodeListener", "reviewCyclePositionType") + "FROM ((((((((((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN review_cycle_node_project_participations_notification ON    review_cycle_node_project_participations_notification.project_participation_id = project_participation.id) JOIN review_cycle_node_instance_notification ON review_cycle_node_project_participations_notification.notification_id = review_cycle_node_instance_notification.id) JOIN review_cycle_node_listener           ON    review_cycle_node_instance_notification.review_cycle_node_listener_id = review_cycle_node_listener.id) JOIN review_cycle_node                    ON    review_cycle_node_listener.review_cycle_node_id = review_cycle_node.id) JOIN review_cycle_cell                    ON    review_cycle_node.review_cycle_cell_id = review_cycle_cell.id) JOIN review_cycle                         ON    review_cycle_cell.review_cycle_id = review_cycle.id) JOIN review_cycle_position_type           ON    review_cycle_node.review_cycle_position_type_id = review_cycle_position_type.id) JOIN review_cycle_node_instance           ON    review_cycle_node_instance_notification.review_cycle_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_cell_instance           ON    review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id) JOIN review_cycle_instance                ON    review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id) JOIN sub_project                          ON    review_cycle_instance.sub_project_id = sub_project.id) JOIN project                              ON    sub_project.project_id = project.id) JOIN network                              ON    project.network_id = network.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.PLOT_ORDER_TEMPLATE, "organisationPerson", "organisation", "network", "project", "plottOrderTemplate") + "FROM ((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN plott_order_template                 ON    plott_order_template.plotter_id = project_participation.id) JOIN project                              ON    plott_order_template.project_id = project.id) JOIN network                              ON    project.network_id = network.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) AND (plott_order_template.invalidated IS NULL OR plott_order_template.invalidated = 0) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.PLOT_ORDER_ITEM_TEMPLATE, "organisationPerson", "organisation", "network", "project", "plottOrderTemplate") + "FROM (((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN plott_order_item_template            ON    plott_order_item_template.delivery_address_id = project_participation.id) JOIN plott_order_template                 ON    plott_order_item_template.order_contract_id = plott_order_template.id) JOIN project                              ON    plott_order_template.project_id = project.id) JOIN network                              ON    project.network_id = network.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) AND (plott_order_item_template.invalidated IS NULL OR plott_order_item_template.invalidated = 0) AND (plott_order_template.invalidated IS NULL OR plott_order_template.invalidated = 0) UNION ALL SELECT DISTINCT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.PLOT_ORDER_ITEM, "organisationPerson", "organisation", "network", "project", "plottOrderTemplate", "plottOrder") + "FROM ((((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN plott_order_item                     ON    plott_order_item.receiver_id = project_participation.id) JOIN plott_order                          ON    plott_order_item.order_contract_id = plott_order.id) JOIN plott_order_template                 ON    plott_order.template_id = plott_order_template.id) JOIN project                              ON    plott_order_template.project_id = project.id) JOIN network                              ON    project.network_id = network.id) LEFT JOIN order_step acceptance_step           ON    plott_order.acceptance_id = acceptance_step.id) LEFT JOIN order_step completed_step            ON    plott_order.completed_id = completed_step.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) AND plott_order_template.template_resolver = ? AND (acceptance_step.id IS NULL OR acceptance_step.accepted_mode IS NULL OR acceptance_step.accepted_mode != ?) AND (completed_step.id IS NULL OR completed_step.accepted_mode IS NULL OR completed_step.accepted_mode != ?) AND NOT EXISTS (SELECT 1 FROM (       received_plott_order_step JOIN order_step local_order_step ON received_plott_order_step.order_step_id = local_order_step.id) WHERE    received_plott_order_step.order_id = plott_order.id AND local_order_step.finished IS NULL) AND (    (NOT EXISTS (SELECT 1 FROM received_plott_order_step WHERE received_plott_order_step.order_id = plott_order.id)) OR (    EXISTS (SELECT 1 FROM order_step local_order_step WHERE local_order_step.order_item_id = plott_order_item.id AND local_order_step.finished IS NULL))) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.REVIEW_CYCLE_NODE_POSITION_RELEASED, "organisationPerson", "organisation", "network", "project", "subProject", "objectListRelease", "reviewCycleInstanceReleased", "reviewCycleCell", "realm") + "FROM (((((((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN review_cycle_node_position_released  ON    review_cycle_node_position_released.project_participation_id = project_participation.id) JOIN review_cycle_node_instance_released  ON    review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id) JOIN review_cycle_cell_instance_released  ON    review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id) JOIN review_cycle_instance_released       ON    review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id) JOIN object_list_release                  ON    review_cycle_instance_released.object_list_id = object_list_release.id) JOIN review_cycle_cell                    ON    review_cycle_cell_instance_released.review_cycle_cell_id = review_cycle_cell.id) JOIN realm                                ON    review_cycle_node_position_released.realm_id = realm.id) JOIN sub_project                          ON    review_cycle_instance_released.sub_project_id = sub_project.id) JOIN project                              ON    sub_project.project_id = project.id) JOIN network                              ON    project.network_id = network.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) AND object_list_release.version = (SELECT MAX(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = sub_project.id) UNION ALL SELECT " + this.getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent.WORKFLOW_NODE_POSITION, "organisationPerson", "organisation", "network", "planningNotification", "planningNotificationOrder", "workflowNodeTemplate") + "FROM ((((((((((organisation_person JOIN organisation                         ON    organisation_person.organisation_id = organisation.id) JOIN project_participant                  ON    project_participant.organisation_person_id = organisation_person.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN project_participation                ON    project_participant.participation_id = project_participation.id) JOIN workflow_node_position               ON    workflow_node_position.project_participation_id = project_participation.id) JOIN workflow_node                        ON    workflow_node_position.workflow_node_id = workflow_node.id) JOIN workflow_node_template               ON    workflow_node.workflow_node_template_id = workflow_node_template.id) JOIN workflow_entity                      ON    workflow_node.workflow_id = workflow_entity.workflow_id) JOIN planning_notification_order          ON    planning_notification_order.workflow_entity_id = workflow_entity.id) JOIN planning_notification                ON    planning_notification_order.planning_notification_id = planning_notification.id) JOIN network                              ON    planning_notification.network_id = network.id) WHERE    organisation_person.person_id = ? AND (organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ParticipationInvalidatableJoin>>(){

            public List<ParticipationInvalidatableJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                statement.setString(currIndex++, "ManualPlotTemplate");
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)OrderStepMode.DECLINED.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)OrderStepMode.DECLINED.getValue());
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                QueryHelper.checkNumberOfWildcards(sql, currIndex);
                if (log.isDebugEnabled()) {
                    log.debug("Will query sql for person_id [" + personId + "]: " + sql);
                }
                ArrayList<ParticipationInvalidatableJoin> results = new ArrayList<ParticipationInvalidatableJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    ParticipationInvalidatableJoin joinDto = AbstractJdbcProjectParticipationDAO.fillParticipationInvalidatableJoinFromResultSet(rs);
                    currIndex = AbstractJdbcProjectParticipationDAO.getNumberOfParticipationInvalidatableJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getInvalidatableUnionSelectClause(ParticipationInvalidatableComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForParticipationInvalidatableJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoinsByProject(final Long projectId, boolean restrictToMainParticipants) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getProjectParticipationJoinSelectClause() + "FROM  ((((((((     project_participation JOIN project_participant          ON (     project_participant.participation_id = project_participation.id " + (restrictToMainParticipants ? "AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1)) " : ")) ") + "JOIN organisation_person          ON project_participant.organisation_person_id = organisation_person.id) JOIN organisation                 ON organisation_person.organisation_id = organisation.id) JOIN organisation op_organisation ON op_organisation.id = organisation.id) JOIN person                       ON organisation_person.person_id = person.id) JOIN cdes_role                    ON project_participation.role_id = cdes_role.id) JOIN project                      ON project_participation.project_id = project.id) JOIN person_variables             ON person_variables.person_id = person.id) WHERE project_participation.project_id = ?";
        List joins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipationJoin>>(){

            public List<ProjectParticipationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipationJoin> ret = new ArrayList<ProjectParticipationJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcProjectParticipationDAO.fillProjectParticipationJoinFromResultSet(rs));
                }
                return ret;
            }
        });
        return joins;
    }

    @Override
    public List<ParticipationListJoin> getParticipationListJoins(ProjectParticipationSearchModel searchModel) {
        final Long basePersonId = searchModel.getBasePersonId();
        final Boolean mainParticipantFlag = searchModel.getMainParticipantFlag();
        final Long personId = searchModel.getPersonId();
        final String personName = searchModel.getPersonName();
        final Long organisationId = searchModel.getOrganisationId();
        final String organisationName = searchModel.getOrganisationName();
        final Long cdesRoleId = searchModel.getCdesRoleId();
        final String cdesRoleName = searchModel.getCdesRoleName();
        final Long networkId = searchModel.getNetworkId();
        final String networkName = searchModel.getNetworkName();
        final Long projectId = searchModel.getProjectId();
        final String projectCodeName = searchModel.getProjectCodeName();
        final Long subProjectId = searchModel.getSubProjectId();
        final String subProjectCodeName = searchModel.getSubProjectCodeName();
        final Long objectReleaseId = searchModel.getObjectReleaseId();
        final String objectReleaseCodeName = searchModel.getObjectReleaseCodeName();
        final Long objectPlannerReleaseId = searchModel.getObjectPlannerReleaseId();
        final String objectPlannerReleaseCodeArea = searchModel.getObjectPlannerReleaseCodeArea();
        final Long objectPlannerPositionDefinitionId = searchModel.getObjectPlannerPositionDefinitionId();
        final String objectPlannerPositionDefinitionName = searchModel.getObjectPlannerPositionDefinitionName();
        final Long reviewCycleInstanceReleasedId = searchModel.getReviewCycleInstanceReleasedId();
        final String reviewCycleInstanceReleasedName = searchModel.getReviewCycleInstanceReleasedName();
        final Long reviewCycleId = searchModel.getReviewCycleId();
        final String reviewCycleName = searchModel.getReviewCycleName();
        final Long reviewCycleCellId = searchModel.getReviewCycleCellId();
        final String reviewCycleCellName = searchModel.getReviewCycleCellName();
        final Long reviewCycleNodeId = searchModel.getReviewCycleNodeId();
        final String reviewCycleNodeName = searchModel.getReviewCycleNodeName();
        final Long realmId = searchModel.getRealmId();
        final String realmName = searchModel.getRealmName();
        StringBuffer sql = new StringBuffer("SELECT " + JdbcProjectParticipationDAO.getParticipationListJoinSelectClause() + "FROM ((((((((((((((((((((((((( (((((person base_person JOIN organisation_person base_organisation_person ON base_organisation_person.person_id = base_person.id) JOIN project_participant base_participant ON base_participant.organisation_person_id = base_organisation_person.id) JOIN project_participation ON base_participant.participation_id = project_participation.id) LEFT JOIN project_participant ON project_participant.participation_id = project_participation.id AND (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) AND project_participant.main_participant_flag = 1) LEFT JOIN organisation_person ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person              ON organisation_person.person_id = person.id) LEFT JOIN project             ON project_participation.project_id = project.id) LEFT JOIN network             ON project.network_id = network.id) LEFT JOIN organisation        ON project_participation.organisation_id = organisation.id) LEFT JOIN cdes_role           ON project_participation.role_id = cdes_role.id) LEFT JOIN object_planner_position_release ON object_planner_position_release.project_participation_id = project_participation.id) LEFT JOIN object_planner_position_definition ON object_planner_position_release.definition_id = object_planner_position_definition.id) LEFT JOIN review_cycle_node_position_released ON review_cycle_node_position_released.project_participation_id = project_participation.id) LEFT JOIN realm               ON review_cycle_node_position_released.realm_id = realm.id) LEFT JOIN review_cycle_node_instance_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id) LEFT JOIN review_cycle_node   ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_cell_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id) LEFT JOIN review_cycle_cell   ON review_cycle_cell_instance_released.review_cycle_cell_id = review_cycle_cell.id) LEFT JOIN review_cycle_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN review_cycle        ON review_cycle_instance_released.review_cycle_id = review_cycle.id) LEFT JOIN object_planner_release object_planner_release_position ON object_planner_position_release.object_planner_id = object_planner_release_position.id) LEFT JOIN object_release object_release_position ON object_planner_release_position.object_id = object_release_position.id) LEFT JOIN object_list_release object_list_release_position ON object_release_position.object_list_release_id = object_list_release_position.id) LEFT JOIN object_list object_list_position ON object_list_release_position.object_list_id = object_list_position.id) LEFT JOIN sub_project sub_project_position ON object_list_release_position.sub_project_id = sub_project_position.id) LEFT JOIN object_planner_release ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN object_release      ON object_planner_release.object_id = object_release.id) LEFT JOIN object_list_release ON object_release.object_list_release_id = object_list_release.id) LEFT JOIN object_list         ON object_list_release.object_list_id = object_list.id) LEFT JOIN sub_project         ON object_list_release.sub_project_id = sub_project.id) WHERE base_person.id = ? AND (base_participant.inactive_flag IS NULL OR base_participant.inactive_flag = 0) AND (object_list_release_position.id IS NULL OR object_list_release_position.version = object_list_position.version - 1) AND (object_list_release.id IS NULL OR object_list_release.version = object_list.version - 1) ");
        this.appendMainParticipantFlagClause(sql, mainParticipantFlag);
        this.appendPersonIdClause(sql, personId);
        this.appendPersonNameClause(sql, personName);
        this.appendOrganisationIdClause(sql, organisationId);
        this.appendOrganisationNameClause(sql, organisationName);
        this.appendCdesRoleIdClause(sql, cdesRoleId);
        this.appendCdesRoleNameClause(sql, cdesRoleName);
        this.appendNetworkIdClause(sql, networkId);
        this.appendNetworkNameClause(sql, networkName);
        this.appendProjectIdClause(sql, projectId);
        this.appendProjectCodeNameClause(sql, projectCodeName);
        this.appendSubProjectIdClause(sql, subProjectId);
        this.appendSubProjectCodeNameClause(sql, subProjectCodeName);
        this.appendObjectReleaseIdClause(sql, objectReleaseId);
        this.appendObjectReleaseCodeNameClause(sql, objectReleaseCodeName);
        this.appendObjectPlannerReleaseIdClause(sql, objectPlannerReleaseId);
        this.appendObjectPlannerReleaseCodeAreaClause(sql, objectPlannerReleaseCodeArea);
        this.appendObjectPlannerPositionDefinitionIdClause(sql, objectPlannerPositionDefinitionId);
        this.appendObjectPlannerPositionDefinitionNameClause(sql, objectPlannerPositionDefinitionName);
        this.appendReviewCycleInstanceReleasedIdClause(sql, reviewCycleInstanceReleasedId);
        this.appendReviewCycleInstanceReleasedNameClause(sql, reviewCycleInstanceReleasedName);
        this.appendReviewCycleIdClause(sql, reviewCycleId);
        this.appendReviewCycleNameClause(sql, reviewCycleName);
        this.appendReviewCycleCellIdClause(sql, reviewCycleCellId);
        this.appendReviewCycleCellNameClause(sql, reviewCycleCellName);
        this.appendReviewCycleNodeIdClause(sql, reviewCycleNodeId);
        this.appendReviewCycleNodeNameClause(sql, reviewCycleNodeName);
        this.appendRealmIdClause(sql, realmId);
        this.appendRealmNameClause(sql, realmName);
        List joins = (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ParticipationListJoin>>(){

            public List<ParticipationListJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)basePersonId);
                currIndex = JdbcProjectParticipationDAO.this.setMainParticipantFlagToStatement(statement, currIndex, mainParticipantFlag);
                currIndex = JdbcProjectParticipationDAO.this.setPersonIdToStatement(statement, currIndex, personId);
                currIndex = JdbcProjectParticipationDAO.this.setPersonNameToStatement(statement, currIndex, personName);
                currIndex = JdbcProjectParticipationDAO.this.setOrganisationIdToStatement(statement, currIndex, organisationId);
                currIndex = JdbcProjectParticipationDAO.this.setOrganisationNameToStatement(statement, currIndex, organisationName);
                currIndex = JdbcProjectParticipationDAO.this.setCdesRoleIdToStatement(statement, currIndex, cdesRoleId);
                currIndex = JdbcProjectParticipationDAO.this.setCdesRoleNameToStatement(statement, currIndex, cdesRoleName);
                currIndex = JdbcProjectParticipationDAO.this.setNetworkIdToStatement(statement, currIndex, networkId);
                currIndex = JdbcProjectParticipationDAO.this.setNetworkNameToStatement(statement, currIndex, networkName);
                currIndex = JdbcProjectParticipationDAO.this.setProjectIdToStatement(statement, currIndex, projectId);
                currIndex = JdbcProjectParticipationDAO.this.setProjectCodeNameToStatement(statement, currIndex, projectCodeName);
                currIndex = JdbcProjectParticipationDAO.this.setSubProjectIdToStatement(statement, currIndex, subProjectId);
                currIndex = JdbcProjectParticipationDAO.this.setSubProjectCodeNameToStatement(statement, currIndex, subProjectCodeName);
                currIndex = JdbcProjectParticipationDAO.this.setObjectReleaseIdToStatement(statement, currIndex, objectReleaseId);
                currIndex = JdbcProjectParticipationDAO.this.setObjectReleaseCodeNameToStatement(statement, currIndex, objectReleaseCodeName);
                currIndex = JdbcProjectParticipationDAO.this.setObjectPlannerReleaseIdToStatement(statement, currIndex, objectPlannerReleaseId);
                currIndex = JdbcProjectParticipationDAO.this.setObjectPlannerReleaseCodeAreaToStatement(statement, currIndex, objectPlannerReleaseCodeArea);
                currIndex = JdbcProjectParticipationDAO.this.setObjectPlannerPositionDefinitionIdToStatement(statement, currIndex, objectPlannerPositionDefinitionId);
                currIndex = JdbcProjectParticipationDAO.this.setObjectPlannerPositionDefinitionNameToStatement(statement, currIndex, objectPlannerPositionDefinitionName);
                currIndex = JdbcProjectParticipationDAO.this.setReviewCycleInstanceReleasedIdToStatement(statement, currIndex, reviewCycleInstanceReleasedId);
                currIndex = JdbcProjectParticipationDAO.this.setReviewCycleInstanceReleasedNameToStatement(statement, currIndex, reviewCycleInstanceReleasedName);
                currIndex = JdbcProjectParticipationDAO.this.setReviewCycleIdToStatement(statement, currIndex, reviewCycleId);
                currIndex = JdbcProjectParticipationDAO.this.setReviewCycleNameToStatement(statement, currIndex, reviewCycleName);
                currIndex = JdbcProjectParticipationDAO.this.setReviewCycleCellIdToStatement(statement, currIndex, reviewCycleCellId);
                currIndex = JdbcProjectParticipationDAO.this.setReviewCycleCellNameToStatement(statement, currIndex, reviewCycleCellName);
                currIndex = JdbcProjectParticipationDAO.this.setReviewCycleNodeIdToStatement(statement, currIndex, reviewCycleNodeId);
                currIndex = JdbcProjectParticipationDAO.this.setReviewCycleNodeNameToStatement(statement, currIndex, reviewCycleNodeName);
                currIndex = JdbcProjectParticipationDAO.this.setRealmIdToStatement(statement, currIndex, realmId);
                currIndex = JdbcProjectParticipationDAO.this.setRealmNameToStatement(statement, currIndex, realmName);
                ResultSet rs = statement.executeQuery();
                ArrayList<ParticipationListJoin> ret = new ArrayList<ParticipationListJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcProjectParticipationDAO.fillParticipationListJoinFromResultSet(rs));
                }
                return ret;
            }
        });
        return joins;
    }

    private void appendPersonIdClause(StringBuffer sql, Long personId) {
        if (personId != null) {
            sql.append("AND CONCAT(person.givenName, person.surName) = (SELECT CONCAT(local_person.givenName, local_person.surName) FROM person local_person WHERE local_person.id = ?) ");
        }
    }

    private int setPersonIdToStatement(PreparedStatement statement, int currIndex, Long personId) throws SQLException {
        if (personId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
        }
        return currIndex;
    }

    private void appendPersonNameClause(StringBuffer sql, String personName) {
        if (SearchHelper.isStringFilled(personName)) {
            sql.append("AND CONCAT(person.givenName, ' ', person.surName) LIKE ? ");
        }
    }

    private int setPersonNameToStatement(PreparedStatement statement, int currIndex, String personName) throws SQLException {
        if (SearchHelper.isStringFilled(personName)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(personName));
        }
        return currIndex;
    }

    private void appendNetworkIdClause(StringBuffer sql, Long networkId) {
        if (networkId != null) {
            sql.append("AND network.id = ? ");
        }
    }

    private int setNetworkIdToStatement(PreparedStatement statement, int currIndex, Long networkId) throws SQLException {
        if (networkId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        }
        return currIndex;
    }

    private void appendNetworkNameClause(StringBuffer sql, String networkName) {
        if (SearchHelper.isStringFilled(networkName)) {
            sql.append("AND network.name LIKE ? ");
        }
    }

    private int setNetworkNameToStatement(PreparedStatement statement, int currIndex, String networkName) throws SQLException {
        if (SearchHelper.isStringFilled(networkName)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(networkName));
        }
        return currIndex;
    }

    private void appendProjectIdClause(StringBuffer sql, Long projectId) {
        if (projectId != null) {
            sql.append("AND project.id = ? ");
        }
    }

    private int setProjectIdToStatement(PreparedStatement statement, int currIndex, Long projectId) throws SQLException {
        if (projectId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        }
        return currIndex;
    }

    private void appendProjectCodeNameClause(StringBuffer sql, String projectCodeName) {
        if (SearchHelper.isStringFilled(projectCodeName)) {
            sql.append("AND CONCAT(project.code, ' ', project.name) LIKE ? ");
        }
    }

    private int setProjectCodeNameToStatement(PreparedStatement statement, int currIndex, String projectCodeName) throws SQLException {
        if (SearchHelper.isStringFilled(projectCodeName)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(projectCodeName));
        }
        return currIndex;
    }

    private void appendOrganisationIdClause(StringBuffer sql, Long organisationId) {
        if (organisationId != null) {
            sql.append("AND organisation.id = ? ");
        }
    }

    private int setOrganisationIdToStatement(PreparedStatement statement, int currIndex, Long organisationId) throws SQLException {
        if (organisationId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
        }
        return currIndex;
    }

    private void appendOrganisationNameClause(StringBuffer sql, String organisationName) {
        if (SearchHelper.isStringFilled(organisationName)) {
            sql.append("AND organisation.name LIKE ? ");
        }
    }

    private int setOrganisationNameToStatement(PreparedStatement statement, int currIndex, String organisationName) throws SQLException {
        if (SearchHelper.isStringFilled(organisationName)) {
            statement.setString(currIndex++, organisationName);
        }
        return currIndex;
    }

    private void appendCdesRoleIdClause(StringBuffer sql, Long cdesRoleId) {
        if (cdesRoleId != null) {
            sql.append("AND cdes_role.name = (SELECT local_role.name FROM cdes_role local_role WHERE local_role.id = ?) ");
        }
    }

    private int setCdesRoleIdToStatement(PreparedStatement statement, int currIndex, Long cdesRoleId) throws SQLException {
        if (cdesRoleId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)cdesRoleId);
        }
        return currIndex;
    }

    private void appendCdesRoleNameClause(StringBuffer sql, String cdesRoleName) {
        if (SearchHelper.isStringFilled(cdesRoleName)) {
            sql.append("AND cdes_role.name LIKE ? ");
        }
    }

    private int setCdesRoleNameToStatement(PreparedStatement statement, int currIndex, String cdesRoleName) throws SQLException {
        if (SearchHelper.isStringFilled(cdesRoleName)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(cdesRoleName));
        }
        return currIndex;
    }

    private void appendMainParticipantFlagClause(StringBuffer sql, Boolean mainParticipantFlag) {
        if (mainParticipantFlag != null) {
            if (mainParticipantFlag.booleanValue()) {
                sql.append("AND base_participant.main_participant_flag = 1 ");
            } else {
                sql.append("AND (base_participant.main_participant_flag IS NULL OR base_participant.main_participant_flag = 0) ");
            }
        }
    }

    private int setMainParticipantFlagToStatement(PreparedStatement statement, int currIndex, Boolean mainParticipantFlag) throws SQLException {
        return currIndex;
    }

    private void appendSubProjectIdClause(StringBuffer sql, Long subProjectId) {
        if (subProjectId != null) {
            sql.append("AND CONCAT(sub_project.code, COALESCE(sub_project.number, ''), sub_project.name) = (SELECT CONCAT(local_sub_project.code, COALESCE(local_sub_project.number, ''), local_sub_project.name) FROM sub_project local_sub_project WHERE local_sub_project.id = ?) ");
        }
    }

    private int setSubProjectIdToStatement(PreparedStatement statement, int currIndex, Long subProjectId) throws SQLException {
        if (subProjectId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        }
        return currIndex;
    }

    private void appendSubProjectCodeNameClause(StringBuffer sql, String subProjectCodeName) {
        if (SearchHelper.isStringFilled(subProjectCodeName)) {
            sql.append("AND CONCAT(sub_project.code, COALESCE(sub_project.number, ''),' ', sub_project.name) LIKE ? ");
        }
    }

    private int setSubProjectCodeNameToStatement(PreparedStatement statement, int currIndex, String subProjectCodeName) throws SQLException {
        if (SearchHelper.isStringFilled(subProjectCodeName)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(subProjectCodeName));
        }
        return currIndex;
    }

    private void appendObjectReleaseIdClause(StringBuffer sql, Long objectReleaseId) {
        if (objectReleaseId != null) {
            sql.append("AND CONCAT(object_release.code, object_release.name) = (SELECT CONCAT(local_object_release.code, local_object_release.name) FROM object_release local_object_release WHERE local_object_release.id = ?) ");
        }
    }

    private int setObjectReleaseIdToStatement(PreparedStatement statement, int currIndex, Long objectReleaseId) throws SQLException {
        if (objectReleaseId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectReleaseId);
        }
        return currIndex;
    }

    private void appendObjectReleaseCodeNameClause(StringBuffer sql, String objectReleaseCodeName) {
        if (SearchHelper.isStringFilled(objectReleaseCodeName)) {
            sql.append("AND CONCAT(object_release.code, ' ', object_release.name) LIKE ? ");
        }
    }

    private int setObjectReleaseCodeNameToStatement(PreparedStatement statement, int currIndex, String objectReleaseCodeName) throws SQLException {
        if (SearchHelper.isStringFilled(objectReleaseCodeName)) {
            statement.setString(currIndex++, objectReleaseCodeName);
        }
        return currIndex;
    }

    private void appendObjectPlannerReleaseIdClause(StringBuffer sql, Long objectPlannerReleaseId) {
        if (objectPlannerReleaseId != null) {
            sql.append("AND CONCAT(object_planner_release.code, object_planner_release.area) = (SELECT CONCAT(local_object_planner_release.code, local_object_planner_release.area) FROM object_planner_release local_object_planner_release WHERE local_object_planner_release.id = ?) ");
        }
    }

    private int setObjectPlannerReleaseIdToStatement(PreparedStatement statement, int currIndex, Long objectPlannerReleaseId) throws SQLException {
        if (objectPlannerReleaseId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerReleaseId);
        }
        return currIndex;
    }

    private void appendObjectPlannerReleaseCodeAreaClause(StringBuffer sql, String objectPlannerReleaseCodeArea) {
        if (SearchHelper.isStringFilled(objectPlannerReleaseCodeArea)) {
            sql.append("AND CONCAT(object_planner_release.code, ' ', object_planner_release.area) LIKE ? ");
        }
    }

    private int setObjectPlannerReleaseCodeAreaToStatement(PreparedStatement statement, int currIndex, String objectPlannerReleaseCodeArea) throws SQLException {
        if (SearchHelper.isStringFilled(objectPlannerReleaseCodeArea)) {
            statement.setString(currIndex++, objectPlannerReleaseCodeArea);
        }
        return currIndex;
    }

    private void appendObjectPlannerPositionDefinitionIdClause(StringBuffer sql, Long objectPlannerPositionDefinitionId) {
        if (objectPlannerPositionDefinitionId != null) {
            sql.append("AND object_planner_position_definition.name = (SELECT local_object_planner_position_definition.name FROM object_planner_position_definition local_object_planner_position_definition WHERE local_object_planner_position_definition.id = ?) ");
        }
    }

    private int setObjectPlannerPositionDefinitionIdToStatement(PreparedStatement statement, int currIndex, Long objectPlannerPositionDefinitionId) throws SQLException {
        if (objectPlannerPositionDefinitionId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerPositionDefinitionId);
        }
        return currIndex;
    }

    private void appendObjectPlannerPositionDefinitionNameClause(StringBuffer sql, String objectPlannerPositionDefinitionName) {
        if (SearchHelper.isStringFilled(objectPlannerPositionDefinitionName)) {
            sql.append("AND object_planner_position_definition.name LIKE ? ");
        }
    }

    private int setObjectPlannerPositionDefinitionNameToStatement(PreparedStatement statement, int currIndex, String objectPlannerPositionDefinitionName) throws SQLException {
        if (SearchHelper.isStringFilled(objectPlannerPositionDefinitionName)) {
            statement.setString(currIndex++, objectPlannerPositionDefinitionName);
        }
        return currIndex;
    }

    private void appendReviewCycleInstanceReleasedIdClause(StringBuffer sql, Long reviewCycleInstanceReleasedId) {
        if (reviewCycleInstanceReleasedId != null) {
            sql.append("AND review_cycle_instance_released.name = (SELECT local_review_cycle_instance_released.name FROM review_cycle_instance_released local_review_cycle_instance_released WHERE local_review_cycle_instance_released.id = ?) ");
        }
    }

    private int setReviewCycleInstanceReleasedIdToStatement(PreparedStatement statement, int currIndex, Long reviewCycleInstanceReleasedId) throws SQLException {
        if (reviewCycleInstanceReleasedId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleInstanceReleasedId);
        }
        return currIndex;
    }

    private void appendReviewCycleInstanceReleasedNameClause(StringBuffer sql, String reviewCycleInstanceReleasedName) {
        if (SearchHelper.isStringFilled(reviewCycleInstanceReleasedName)) {
            sql.append("AND review_cycle_instance_released.name LIKE ? ");
        }
    }

    private int setReviewCycleInstanceReleasedNameToStatement(PreparedStatement statement, int currIndex, String reviewCycleInstanceReleasedName) throws SQLException {
        if (SearchHelper.isStringFilled(reviewCycleInstanceReleasedName)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(reviewCycleInstanceReleasedName));
        }
        return currIndex;
    }

    private void appendReviewCycleIdClause(StringBuffer sql, Long reviewCycleId) {
        if (reviewCycleId != null) {
            sql.append("AND review_cycle.id = ? ");
        }
    }

    private int setReviewCycleIdToStatement(PreparedStatement statement, int currIndex, Long reviewCycleId) throws SQLException {
        if (reviewCycleId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleId);
        }
        return currIndex;
    }

    private void appendReviewCycleNameClause(StringBuffer sql, String reviewCycleName) {
        if (SearchHelper.isStringFilled(reviewCycleName)) {
            sql.append("AND review_cycle.name LIKE ? ");
        }
    }

    private int setReviewCycleNameToStatement(PreparedStatement statement, int currIndex, String reviewCycleName) throws SQLException {
        if (SearchHelper.isStringFilled(reviewCycleName)) {
            statement.setString(currIndex++, SearchHelper.convertForLocaleAwareSearch(reviewCycleName));
        }
        return currIndex;
    }

    private void appendReviewCycleCellIdClause(StringBuffer sql, Long reviewCycleCellId) {
        if (reviewCycleCellId != null) {
            sql.append("AND review_cycle_cell.name = (SELECT local_review_cycle_cell.name FROM review_cycle_cell local_review_cycle_cell WHERE local_review_cycle_cell.id = ?) ");
        }
    }

    private int setReviewCycleCellIdToStatement(PreparedStatement statement, int currIndex, Long reviewCycleCellId) throws SQLException {
        if (reviewCycleCellId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleCellId);
        }
        return currIndex;
    }

    private void appendReviewCycleCellNameClause(StringBuffer sql, String reviewCycleCellName) {
        if (SearchHelper.isStringFilled(reviewCycleCellName)) {
            sql.append("AND review_cycle_cell.name LIKE ? ");
        }
    }

    private int setReviewCycleCellNameToStatement(PreparedStatement statement, int currIndex, String reviewCycleCellName) throws SQLException {
        if (SearchHelper.isStringFilled(reviewCycleCellName)) {
            statement.setString(currIndex++, SearchHelper.convertForLocaleAwareSearch(reviewCycleCellName));
        }
        return currIndex;
    }

    private void appendReviewCycleNodeIdClause(StringBuffer sql, Long reviewCycleNodeId) {
        if (reviewCycleNodeId != null) {
            sql.append("AND review_cycle_node.name = (SELECT local_review_cycle_node.name FROM review_cycle_node local_review_cycle_node WHERE local_review_cycle_node.id = ?) ");
        }
    }

    private int setReviewCycleNodeIdToStatement(PreparedStatement statement, int currIndex, Long reviewCycleNodeId) throws SQLException {
        if (reviewCycleNodeId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeId);
        }
        return currIndex;
    }

    private void appendReviewCycleNodeNameClause(StringBuffer sql, String reviewCycleNodeName) {
        if (SearchHelper.isStringFilled(reviewCycleNodeName)) {
            sql.append("AND review_cycle_node.name LIKE ? ");
        }
    }

    private int setReviewCycleNodeNameToStatement(PreparedStatement statement, int currIndex, String reviewCycleNodeName) throws SQLException {
        if (SearchHelper.isStringFilled(reviewCycleNodeName)) {
            statement.setString(currIndex++, SearchHelper.convertForLocaleAwareSearch(reviewCycleNodeName));
        }
        return currIndex;
    }

    private void appendRealmIdClause(StringBuffer sql, Long realmId) {
        if (realmId != null) {
            sql.append("AND realm.name = (SELECT local_realm.name FROM realm local_realm WHERE local_realm.id = ?) ");
        }
    }

    private int setRealmIdToStatement(PreparedStatement statement, int currIndex, Long realmId) throws SQLException {
        if (realmId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)realmId);
        }
        return currIndex;
    }

    private void appendRealmNameClause(StringBuffer sql, String realmName) {
        if (SearchHelper.isStringFilled(realmName)) {
            sql.append("AND realm.name LIKE ? ");
        }
    }

    private int setRealmNameToStatement(PreparedStatement statement, int currIndex, String realmName) throws SQLException {
        if (SearchHelper.isStringFilled(realmName)) {
            statement.setString(currIndex++, SearchHelper.convertForLocaleAwareSearch(realmName));
        }
        return currIndex;
    }

    @Override
    public List<ProjectParticipationJoin> getParticipationJoinsByPageSearchModel(ParticipationPageSearchModel searchModel) {
        final Long projectId = searchModel.getProjectId();
        final Long organisationId = searchModel.getOrganisationId();
        final Long cdesRoleId = searchModel.getCdesRoleId();
        final Long subProjectId = searchModel.getSubProjectId();
        final Long mainParticipantPersonId = searchModel.getMainParticipantPersonId();
        final Long deputyParticipantPersonId = searchModel.getDeputyParticipantPersonId();
        if (projectId == null) {
            throw new IllegalArgumentException("Please specify a projectId");
        }
        String sql = "SELECT " + JdbcProjectParticipationDAO.getProjectParticipationJoinSelectClause() + "FROM project_participation\nJOIN organisation                 ON project_participation.organisation_id = organisation.id\nJOIN project_participant          ON project_participant.participation_id = project_participation.id\nJOIN organisation_person          ON project_participant.organisation_person_id = organisation_person.id\nJOIN organisation op_organisation ON organisation_person.organisation_id = op_organisation.id\nJOIN person                       ON organisation_person.person_id = person.id\nJOIN cdes_role                    ON project_participation.role_id = cdes_role.id\nJOIN project                      ON project_participation.project_id = project.id\nJOIN person_variables             ON person_variables.person_id = person.id\nWHERE project.id = ?\nAND project_participation.invalidated = 0\nAND project_participant.inactive_flag = 0\nAND organisation_person.retired_flag = 0\n";
        if (organisationId != null) {
            sql = sql + "AND project_participation.organisation_id = ? ";
        }
        if (cdesRoleId != null) {
            sql = sql + "AND cdes_role.id = ? ";
        }
        if (subProjectId != null) {
            sql = sql + "AND NOT EXISTS (SELECT *      FROM project_participation_sub_project_restrictions      WHERE project_participation_sub_project_restrictions.project_participation_id = project_participation.id      AND project_participation_sub_project_restrictions.sub_project_id = ?) ";
        }
        if (mainParticipantPersonId != null) {
            sql = sql + "AND EXISTS (SELECT *      FROM project_participant      JOIN organisation_person ON project_participant.organisation_person_id = organisation_person.id      WHERE project_participant.participation_id = project_participation.id      AND project_participant.main_participant_flag = 1      AND project_participant.inactive_flag = 0      AND organisation_person.retired_flag = 0      AND organisation_person.person_id = ?) ";
        }
        if (deputyParticipantPersonId != null) {
            sql = sql + "AND EXISTS (SELECT *      FROM project_participant      JOIN organisation_person ON project_participant.organisation_person_id = organisation_person.id      WHERE project_participant.participation_id = project_participation.id      AND project_participant.main_participant_flag = 0      AND project_participant.inactive_flag = 0      AND organisation_person.retired_flag = 0      AND organisation_person.person_id = ?) ";
        }
        if (log.isDebugEnabled()) {
            log.debug("sql = {}", (Object)sql);
        }
        List joins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipationJoin>>(){

            public List<ProjectParticipationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                if (organisationId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                }
                if (cdesRoleId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)cdesRoleId);
                }
                if (subProjectId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                }
                if (mainParticipantPersonId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)mainParticipantPersonId);
                }
                if (deputyParticipantPersonId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)deputyParticipantPersonId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipationJoin> ret = new ArrayList<ProjectParticipationJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcProjectParticipationDAO.fillProjectParticipationJoinFromResultSet(rs));
                }
                return ret;
            }
        });
        return joins;
    }

    @Override
    public List<ParticipationPageSearchJoin> getParticipationPageSearchJoins(final Long projectId) {
        String sql = "SELECT DISTINCT " + this.getParticipationPageSearchUnionSelectClause(ParticipationPageSearchUnionComponent.ORGANISATION, "organisation") + "FROM      project_participation JOIN organisation            ON project_participation.organisation_id = organisation.id WHERE project_participation.project_id = ? AND project_participation.invalidated = 0 UNION ALL SELECT DISTINCT " + this.getParticipationPageSearchUnionSelectClause(ParticipationPageSearchUnionComponent.CDES_ROLE, "cdesRole") + "FROM      project_participation JOIN cdes_role               ON project_participation.role_id = cdes_role.id WHERE project_participation.project_id = ? AND project_participation.invalidated = 0 UNION ALL SELECT DISTINCT " + this.getParticipationPageSearchUnionSelectClause(ParticipationPageSearchUnionComponent.SUB_PROJECT, "subProject") + "FROM     project JOIN sub_project             ON project.id = sub_project.project_id WHERE project.id = ? UNION ALL SELECT " + this.getParticipationPageSearchUnionSelectClause(ParticipationPageSearchUnionComponent.PARTICIPANT, "organisationPerson", "person", "organisation", "projectParticipant") + "FROM     project_participation JOIN project_participant     ON project_participant.participation_id = project_participation.id JOIN organisation_person     ON project_participant.organisation_person_id = organisation_person.id JOIN organisation            ON organisation_person.organisation_id = organisation.id JOIN person                  ON organisation_person.person_id = person.id WHERE project_participation.project_id = ? AND project_participation.invalidated = 0 AND organisation_person.retired_flag = 0 AND person.invalidated = 0 ";
        List participationPageSearchJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ParticipationPageSearchJoin>>(){

            public List<ParticipationPageSearchJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ParticipationPageSearchJoin> ret = new ArrayList<ParticipationPageSearchJoin>();
                while (rs.next()) {
                    ParticipationPageSearchJoin joinDto = AbstractJdbcProjectParticipationDAO.fillParticipationPageSearchJoinFromResultSet(rs);
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)(AbstractJdbcProjectParticipationDAO.getNumberOfParticipationPageSearchJoinAttributes() + 1)));
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        return participationPageSearchJoins;
    }

    private String getParticipationPageSearchUnionSelectClause(ParticipationPageSearchUnionComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForParticipationPageSearchJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<ParticipationPageEditJoin> getParticipationPageEditJoins(final Long projectId) {
        String sql = "SELECT DISTINCT " + this.getParticipationPageEditUnionSelectClause(ParticipationPageEditUnionComponent.ORGANISATION, "organisation", "consortium") + "FROM      project JOIN network_organisation    ON project.network_id = network_organisation.network_id JOIN organisation consortium ON network_organisation.organisation_id = consortium.id LEFT JOIN consortium_member       ON consortium.consortium_flag = 1 AND consortium_member.consortium_id = consortium.id LEFT JOIN organisation            ON consortium_member.organisation_id = organisation.id WHERE project.id = ? UNION ALL SELECT " + this.getParticipationPageEditUnionSelectClause(ParticipationPageEditUnionComponent.PROJECT, "project") + "FROM      project WHERE project.id = ? UNION ALL SELECT DISTINCT " + this.getParticipationPageEditUnionSelectClause(ParticipationPageEditUnionComponent.CDES_ROLE, "cdesRole") + "FROM      project JOIN cdes_role               ON project.network_id = cdes_role.network_id WHERE project.id = ? AND ((cdes_role.project_flag >= 7 AND project.status = 10) OR (cdes_role.project_flag < 7 AND project.status != 10)) UNION ALL SELECT DISTINCT " + this.getParticipationPageEditUnionSelectClause(ParticipationPageEditUnionComponent.SUB_PROJECT, "subProject") + "FROM     project JOIN sub_project             ON project.id = sub_project.project_id WHERE project.id = ? AND sub_project.invalidated = 0 UNION ALL SELECT DISTINCT " + this.getParticipationPageEditUnionSelectClause(ParticipationPageEditUnionComponent.PARTICIPANT, "organisationPerson", "person", "organisation", "consortium") + "FROM     project JOIN network_organisation         ON project.network_id = network_organisation.network_id LEFT JOIN organisation consortium ON network_organisation.organisation_id = consortium.id AND consortium.consortium_flag = 1 LEFT JOIN consortium_member       ON consortium_member.consortium_id = consortium.id JOIN organisation                 ON (network_organisation.organisation_id = organisation.id AND organisation.consortium_flag = 0) OR organisation.id = consortium_member.organisation_id JOIN organisation_person          ON organisation.id = organisation_person.organisation_id JOIN person                       ON organisation_person.person_id = person.id WHERE project.id = ? AND person.invalidated = 0 AND organisation_person.retired_flag = 0 ";
        List participationPageEditJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ParticipationPageEditJoin>>(){

            public List<ParticipationPageEditJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ParticipationPageEditJoin> ret = new ArrayList<ParticipationPageEditJoin>();
                while (rs.next()) {
                    ParticipationPageEditJoin joinDto = AbstractJdbcProjectParticipationDAO.fillParticipationPageEditJoinFromResultSet(rs);
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)(AbstractJdbcProjectParticipationDAO.getNumberOfParticipationPageEditJoinAttributes() + 1)));
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        return participationPageEditJoins;
    }

    private String getParticipationPageEditUnionSelectClause(ParticipationPageEditUnionComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForParticipationPageEditJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public void invalidateBatch(Collection<Long> ids) {
        String sql = "UPDATE project_participation SET invalidated = 1 WHERE project_participant.id IN (" + QueryHelper.getPlaceHolderSequence(ids.size()) + ")";
        this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            for (Long id : ids) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)id);
            }
            statement.execute();
            return null;
        });
    }

    @Override
    public ProjectParticipationJoin getContractor(Long objectPlannerId) {
        String sql = "SELECT " + this.getProjectParticipationJoinSelectClause() + "\nFROM object_planner\nJOIN object_planner_position            ON object_planner_position.object_planner_id = object_planner.id\nJOIN object_planner_position_definition ON object_planner_position_definition.id = object_planner_position.definition_id\nJOIN cdes_role position_role            ON position_role.id = object_planner_position.role_id\nJOIN project_participation              ON project_participation.id = object_planner_position.project_participation_id\nJOIN project_participant                ON (project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN organisation_person                ON project_participant.organisation_person_id = organisation_person.id JOIN organisation                       ON organisation_person.organisation_id = organisation.id JOIN organisation op_organisation       ON op_organisation.id = organisation.id JOIN person                             ON organisation_person.person_id = person.id JOIN cdes_role                          ON project_participation.role_id = cdes_role.id JOIN project                            ON project_participation.project_id = project.id WHERE position_role.project_flag = 4\nORDER BY object_planner_position_definition.name\nOFFSET 0 ROWS\nFETCH NEXT 1 ROWS ONLY\n";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, AbstractJdbcProjectParticipationDAO::fillProjectParticipationJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
        });
    }

    private int setDeleteIds(PreparedStatement statement, int currIndex, Long projectId, Long organisationId, Long participationId) throws SQLException {
        if (projectId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        }
        if (organisationId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
        }
        if (participationId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
        }
        return currIndex;
    }

    @Override
    public List<ParticipationDeleteJoin> getParticipationDeleteJoins(final Long projectId, final Long organisationId, final Long participationId) {
        String whereClauses = "";
        if (projectId != null) {
            whereClauses = whereClauses + "AND project_participation.project_id = ? ";
        }
        if (organisationId != null) {
            whereClauses = whereClauses + "AND project_participation.organisation_id = ? ";
        }
        if (participationId != null) {
            whereClauses = whereClauses + "AND project_participation.id = ? ";
        }
        String sql = "SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.REVIEW_CYCLE_NODE_POSITION, "projectParticipation", "organisation", "cdesRole", "reviewCycleNodePosition", "reviewCycleInstance", "reviewCycleCell", "reviewCycleNode", "subProject", "realm") + "FROM project_participation JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN review_cycle_node_position ON review_cycle_node_position.project_participation_id = project_participation.id JOIN realm                      ON review_cycle_node_position.realm_id = realm.id JOIN review_cycle_node_instance ON review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_node          ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id JOIN review_cycle_cell_instance ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_cell          ON review_cycle_cell_instance.review_cycle_cell_id = review_cycle_cell.id JOIN review_cycle_instance      ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id JOIN sub_project                ON review_cycle_instance.sub_project_id = sub_project.id WHERE 1=1 " + whereClauses + "UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.REVIEW_CYCLE_NODE_INSTANCE_NOTIFICATION, "projectParticipation", "organisation", "cdesRole", "reviewCycleNodeInstanceNotification", "reviewCycleInstance", "reviewCycleCell", "reviewCycleNode", "subProject") + "FROM review_cycle_node_project_participations_notification JOIN project_participation      ON review_cycle_node_project_participations_notification.project_participation_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN review_cycle_node_instance_notification ON review_cycle_node_project_participations_notification.notification_id = review_cycle_node_instance_notification.id JOIN review_cycle_node_instance ON review_cycle_node_instance_notification.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_node          ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id JOIN review_cycle_cell_instance ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_cell          ON review_cycle_cell_instance.review_cycle_cell_id = review_cycle_cell.id JOIN review_cycle_instance      ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id JOIN sub_project                ON review_cycle_instance.sub_project_id = sub_project.id WHERE 1=1 " + whereClauses + "UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.REVIEW_CYCLE_NODE_INSTANCE_PLOTT_ORDER_LISTENER, "projectParticipation", "organisation", "cdesRole", "reviewCycleNodeInstancePlottOrderListener", "reviewCycleInstance", "reviewCycleCell", "reviewCycleNode", "subProject") + "FROM plott_order_item_template JOIN project_participation      ON plott_order_item_template.delivery_address_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN plott_order_template       ON plott_order_item_template.order_contract_id = plott_order_template.id JOIN review_cycle_node_instance_plott_order_listener ON review_cycle_node_instance_plott_order_listener.reference_id = plott_order_template.id JOIN review_cycle_node_instance ON review_cycle_node_instance_plott_order_listener.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_node          ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id JOIN review_cycle_cell_instance ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_cell          ON review_cycle_cell_instance.review_cycle_cell_id = review_cycle_cell.id JOIN review_cycle_instance      ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id JOIN sub_project                ON review_cycle_instance.sub_project_id = sub_project.id WHERE 1=1 " + whereClauses + "AND plott_order_template.template_resolver = ? AND plott_order_item_template.invalidated = 0 UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.OBJECT_PLANNER, "projectParticipation", "organisation", "cdesRole", "objectPlanner", "object", "subProject") + "FROM object_planner JOIN project_participation      ON object_planner.planner_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN object                     ON object_planner.object_id = object.id JOIN object_list                ON object.object_list_id = object_list.id JOIN sub_project                ON object_list.sub_project_id = sub_project.id WHERE 1=1 " + whereClauses + "AND object.inactive_flag = 0 AND object_planner.inactive = 0 UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.OBJECT_PLANNER_POSITION, "projectParticipation", "organisation", "cdesRole", "objectPlannerPosition", "objectPlanner", "object", "subProject") + "FROM object_planner_position JOIN project_participation      ON object_planner_position.project_participation_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN object_planner             ON object_planner_position.object_planner_id = object_planner.id JOIN object                     ON object_planner.object_id = object.id JOIN object_list                ON object.object_list_id = object_list.id JOIN sub_project                ON object_list.sub_project_id = sub_project.id WHERE 1=1 " + whereClauses + "AND object.inactive_flag = 0 AND object_planner.inactive = 0 UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.PLOT_ORDER_TEMPLATE, "projectParticipation", "organisation", "cdesRole", "plottOrderTemplate") + "FROM plott_order_template JOIN project_participation      ON plott_order_template.plotter_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id WHERE 1=1 " + whereClauses + "AND plott_order_template.invalidated = 0 UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.PLOT_ORDER_ITEM_TEMPLATE, "projectParticipation", "organisation", "cdesRole", "plottOrderTemplate") + "FROM plott_order_item_template JOIN project_participation      ON plott_order_item_template.delivery_address_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN plott_order_template       ON plott_order_item_template.order_contract_id = plott_order_template.id WHERE 1=1 " + whereClauses + "AND plott_order_template.invalidated = 0 AND plott_order_item_template.invalidated = 0 UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.ATTACHED_REVIEW_TASK, "projectParticipation", "organisation", "cdesRole", "attachedReviewTask", "documentVersion") + "FROM attached_review_task JOIN document_version_task      ON attached_review_task.task_id = document_version_task.task_id JOIN document_version           ON document_version_task.document_version_id = document_version.id JOIN project_participation      ON document_version_task.project_participation_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id WHERE 1=1 " + whereClauses + "UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.REVIEW_CYCLE_NODE_POSITION_RELEASED, "projectParticipation", "organisation", "cdesRole", "subProject") + "FROM review_cycle_node_position_released JOIN project_participation      ON review_cycle_node_position_released.project_participation_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN review_cycle_node_instance_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id JOIN review_cycle_cell_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id JOIN review_cycle_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id JOIN sub_project                ON review_cycle_instance_released.sub_project_id = sub_project.id WHERE 1=1 " + whereClauses + "UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.OBJECT_PLANNER_POSITION_RELEASE, "projectParticipation", "organisation", "cdesRole", "subProject") + "FROM object_planner_position_release JOIN project_participation      ON object_planner_position_release.project_participation_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN object_planner_release     ON object_planner_position_release.object_planner_id = object_planner_release.id JOIN object_release             ON object_planner_release.object_id = object_release.id JOIN object_list_release        ON object_release.object_list_release_id = object_list_release.id JOIN sub_project                ON object_list_release.sub_project_id = sub_project.id WHERE 1=1 " + whereClauses + "UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.OBJECT_PLANNER_RELEASE, "projectParticipation", "organisation", "cdesRole", "subProject") + "FROM object_planner_release JOIN project_participation      ON object_planner_release.planner_id = project_participation.id JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN object_release             ON object_planner_release.object_id = object_release.id JOIN object_list_release        ON object_release.object_list_release_id = object_list_release.id JOIN sub_project                ON object_list_release.sub_project_id = sub_project.id WHERE 1=1 " + whereClauses + "UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.OPEN_PLOT_ORDERS, "projectParticipation", "organisation", "cdesRole") + "FROM project_participation JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN project_participant        ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 JOIN organisation_person       ON project_participant.organisation_person_id = organisation_person.id JOIN plott_order_item          ON     plott_order_item.receiver_id = project_participant.id AND plott_order_item.receiver_organisation_person_id = organisation_person.id JOIN plott_order               ON     plott_order_item.order_contract_id = plott_order.id LEFT JOIN order_step item_step      ON     item_step.order_item_id = plott_order_item.id LEFT JOIN order_step accepted_step  ON     plott_order.acceptance_id = accepted_step.id LEFT JOIN order_step completed_step ON     plott_order.completed_id = completed_step.id WHERE 1=1 " + whereClauses + "AND ( NOT EXISTS (SELECT 1 FROM received_plott_order_step WHERE received_plott_order_step.order_id = plott_order.id) OR (  EXISTS (SELECT 1 FROM received_plott_order_step JOIN order_step received_step ON received_plott_order_step.order_step_id = received_step.id WHERE received_plott_order_step.order_id = plott_order.id AND received_step.finished IS NULL) AND item_step.finished IS NULL)) UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.REMAINING_ADMIN_NON_BUEK, "projectParticipation", "organisation", "cdesRole") + "FROM project_participation JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id WHERE 1=1 " + whereClauses + "AND cdes_role.project_flag IN (?, ?) AND NOT EXISTS (SELECT 1 FROM project_participation local_participation JOIN cdes_role local_role ON local_role.id = local_participation.role_id WHERE local_participation.project_id = project_participation.project_id AND local_participation.id != project_participation.id " + (organisationId != null ? "AND local_participation.organisation_id != project_participation.organisation_id " : "") + "AND local_participation.invalidated = 0 AND local_role.project_flag IN (?, ?) GROUP BY local_participation.id) UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.REMAINING_ADMIN_BUEK, "projectParticipation", "organisation", "cdesRole") + "FROM project_participation JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id WHERE 1=1 " + whereClauses + "AND cdes_role.project_flag = ? AND NOT EXISTS (SELECT 1 FROM project_participation local_participation JOIN cdes_role local_role ON local_role.id = local_participation.role_id WHERE local_participation.project_id = project_participation.project_id AND local_participation.id != project_participation.id " + (organisationId != null ? "AND local_participation.organisation_id != project_participation.organisation_id " : "") + "AND local_participation.invalidated = 0 AND local_role.project_flag = ? GROUP BY local_participation.id) UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.REMAINING_ADMIN_NON_BUEK, "projectParticipation", "organisation", "cdesRole") + "FROM project_participation JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN document_version_task      ON document_version_task.project_participation_id = project_participation.id LEFT JOIN review_cycle_plott_task    ON review_cycle_plott_task.task_id = document_version_task.task_id LEFT JOIN plot_order_acceptance_task ON plot_order_acceptance_task.task_id = document_version_task.task_id WHERE 1=1 " + whereClauses + "AND (   review_cycle_plott_task.task_id IS NOT NULL OR plot_order_acceptance_task.task_id IS NOT NULL) UNION ALL SELECT " + this.getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent.REMAINING_ADMIN_NON_BUEK, "projectParticipation", "organisation", "cdesRole") + "FROM project_participation JOIN organisation               ON project_participation.organisation_id = organisation.id JOIN cdes_role                  ON project_participation.role_id = cdes_role.id JOIN plott_order_item           ON plott_order_item.receiver_id = project_participation.id JOIN order_step                 ON order_step.order_item_id = plott_order_item.id WHERE 1=1 " + whereClauses + "AND order_step.finished IS NULL ";
        if (log.isDebugEnabled()) {
            log.debug(sql);
        }
        List participationDeleteJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ParticipationDeleteJoin>>(){

            public List<ParticipationDeleteJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                statement.setString(currIndex++, "ProjectParticipationPlotTemplate");
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectFlag.PROJECT_MANAGER_ROLE.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectFlag.PROJECT_ADMIN_ROLE.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectFlag.PROJECT_MANAGER_ROLE.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectFlag.PROJECT_ADMIN_ROLE.getValue());
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectFlag.PROJECT_ADMIN_PLANNING_NOTIFICATION.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectFlag.PROJECT_ADMIN_PLANNING_NOTIFICATION.getValue());
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                currIndex = JdbcProjectParticipationDAO.this.setDeleteIds(statement, currIndex, projectId, organisationId, participationId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ParticipationDeleteJoin> ret = new ArrayList<ParticipationDeleteJoin>();
                while (rs.next()) {
                    ParticipationDeleteJoin joinDto = AbstractJdbcProjectParticipationDAO.fillParticipationDeleteJoinFromResultSet(rs);
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)(AbstractJdbcProjectParticipationDAO.getNumberOfParticipationDeleteJoinAttributes() + 1)));
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        return participationDeleteJoins;
    }

    private String getParticipationDeleteJoinUnionSelectClause(ParticipationDeleteComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForParticipationDeleteJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<ProjectParticipation> mayInvalidateParticipation(Long participationId) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN object_planner_position ON object_planner_position.project_participation_id = project_participation.id WHERE project_participation.id = ? UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN object_planner ON object_planner.planner_id = project_participation.id WHERE project_participation.id = ? UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN object_planner_position_release ON object_planner_position_release.project_participation_id = project_participation.id WHERE project_participation.id = ? UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN object_planner_release ON object_planner_release.planner_id = project_participation.id WHERE project_participation.id = ? UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN review_cycle_node_position ON review_cycle_node_position.project_participation_id = project_participation.id WHERE project_participation.id = ? UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN review_cycle_node_project_participations_notification ON review_cycle_node_project_participations_notification.project_participation_id = project_participation.id WHERE project_participation.id = ? UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN plott_order_item_template ON plott_order_item_template.delivery_address_id = project_participation.id JOIN plott_order_template      ON plott_order_item_template.order_contract_id = plott_order_template.id WHERE project_participation.id = ? AND plott_order_item_template.invalidated = 0 AND plott_order_template.invalidated = 0 UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN plott_order_template      ON plott_order_template.plotter_id = plott_order_template.id WHERE project_participation.id = ? AND plott_order_template.invalidated = 0 UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN review_cycle_node_position_released ON review_cycle_node_position_released.project_participation_id = project_participation.id WHERE project_participation.id = ? UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN project_participant       ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 JOIN organisation_person       ON project_participant.organisation_person_id = organisation_person.id JOIN plott_order_item          ON     plott_order_item.receiver_id = project_participant.id AND plott_order_item.receiver_organisation_person_id = organisation_person.id JOIN plott_order               ON     plott_order_item.order_contract_id = plott_order.id LEFT JOIN order_step item_step      ON     item_step.order_item_id = plott_order_item.id LEFT JOIN order_step accepted_step  ON     plott_order.acceptance_id = accepted_step.id LEFT JOIN order_step completed_step ON     plott_order.completed_id = completed_step.id WHERE ( NOT EXISTS (SELECT 1 FROM received_plott_order_step WHERE received_plott_order_step.order_id = plott_order.id) OR (  EXISTS (SELECT 1 FROM received_plott_order_step JOIN order_step received_step ON received_plott_order_step.order_step_id = received_step.id WHERE received_plott_order_step.order_id = plott_order.id AND received_step.finished IS NULL) AND item_step.finished IS NULL)) AND project_participation.id = ? UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN plott_order_template    ON plott_order_template.plotter_id = project_participation.id WHERE project_participation.id = ? AND plott_order_template.invalidated = 0 UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN plott_order_item_template    ON plott_order_item_template.delivery_address_id = project_participation.id WHERE project_participation.id = ? AND plott_order_item_template.invalidated = 0 UNION ALL SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN workflow_node_position ON workflow_node_position.project_participation_id = project_participation.id WHERE project_participation.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            for (int n = 0; n < 13; ++n) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
            }
        });
    }

    @Override
    public boolean mayRestrictParticipation(final Long participationId, final Long subProjectId) {
        String sql = "SELECT 1 FROM project_participation JOIN object_planner_position        ON object_planner_position.project_participation_id = project_participation.id JOIN object_planner                 ON object_planner_position.object_planner_id = object_planner.id JOIN object                         ON object_planner.object_id = object.id JOIN object_list                    ON object.object_list_id = object_list.id WHERE project_participation.id = ? AND object_list.sub_project_id = ? UNION ALL SELECT 1 FROM project_participation JOIN object_planner                 ON object_planner.planner_id = project_participation.id JOIN object                         ON object_planner.object_id = object.id JOIN object_list                    ON object.object_list_id = object_list.id WHERE project_participation.id = ? AND object_list.sub_project_id = ? UNION ALL SELECT 1 FROM project_participation JOIN object_planner_position_release ON object_planner_position_release.project_participation_id = project_participation.id JOIN object_planner_release          ON object_planner_position_release.object_planner_id = object_planner_release.id JOIN object_planner                  ON object_planner_release.object_planner_id = object_planner.id JOIN object                          ON object_planner.object_id = object.id JOIN object_list                     ON object.object_list_id = object_list.id WHERE project_participation.id = ? AND object_list.sub_project_id = ? UNION ALL SELECT 1 FROM project_participation JOIN object_planner_release          ON object_planner_release.planner_id = project_participation.id JOIN object_planner                  ON object_planner_release.object_planner_id = object_planner.id JOIN object                          ON object_planner.object_id = object.id JOIN object_list                     ON object.object_list_id = object_list.id WHERE project_participation.id = ? AND object_list.sub_project_id = ? UNION ALL SELECT 1 FROM project_participation JOIN review_cycle_node_position      ON review_cycle_node_position.project_participation_id = project_participation.id JOIN review_cycle_node_instance      ON review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_cell_instance      ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_instance           ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id WHERE project_participation.id = ? AND review_cycle_instance.sub_project_id = ? UNION ALL SELECT 1 FROM project_participation JOIN review_cycle_node_position_released ON review_cycle_node_position_released.project_participation_id = project_participation.id JOIN review_cycle_node_instance_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id JOIN review_cycle_cell_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id JOIN review_cycle_instance_released      ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id WHERE project_participation.id = ? AND review_cycle_instance_released.sub_project_id = ? UNION ALL SELECT 1 FROM project_participation JOIN review_cycle_node_project_participations_notification ON review_cycle_node_project_participations_notification.project_participation_id = project_participation.id JOIN review_cycle_node_instance_notification ON review_cycle_node_project_participations_notification.notification_id = review_cycle_node_instance_notification.id JOIN review_cycle_node_instance      ON review_cycle_node_instance_notification.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_cell_instance      ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_instance           ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id WHERE project_participation.id = ? AND review_cycle_instance.sub_project_id = ? UNION ALL SELECT 1 FROM project_participation JOIN plott_order_item_template       ON plott_order_item_template.delivery_address_id = project_participation.id JOIN plott_order_template            ON plott_order_item_template.order_contract_id = plott_order_template.id JOIN review_cycle_node_instance_plott_order_listener ON review_cycle_node_instance_plott_order_listener.reference_id = plott_order_template.id JOIN review_cycle_node_instance      ON review_cycle_node_instance_plott_order_listener.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_cell_instance      ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_instance           ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id WHERE project_participation.id = ? AND review_cycle_instance.sub_project_id = ? ";
        boolean found = (Boolean)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Boolean>(){

            public Boolean perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (int n = 0; n < 8; ++n) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                }
                ResultSet rs = statement.executeQuery();
                return rs.next();
            }
        });
        return !found;
    }

    @Override
    public List<ProjectParticipation> getParticipationsByProjectAndRoleTypeAndAction(Long projectId, Integer roleType, String actionName) {
        String sql = "SELECT DISTINCT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM project_participation JOIN cdes_role                                  ON project_participation.role_id = cdes_role.id JOIN role_type                                  ON cdes_role.type_id = role_type.id JOIN role_action_rule                           ON role_action_rule.cdes_role_id = cdes_role.id JOIN action_rule                                ON role_action_rule.action_rule_id = action_rule.id JOIN action                                     ON action_rule.action_id = action.id WHERE project_participation.project_id = ? AND role_type.type = ? AND action.name = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)roleType);
            statement.setString(currIndex++, actionName);
        });
    }

    @Override
    public List<ProjectParticipation> getByReviewCycleNodeInstanceReleasedAndRoleType(Long reviewCycleNodeInstanceReleasedId, Long roleTypeId) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getSelectClauseForDto() + "FROM review_cycle_node_instance_released JOIN review_cycle_cell_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id JOIN review_cycle_instance_released      ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id JOIN sub_project                         ON review_cycle_instance_released.sub_project_id = sub_project.id JOIN project                             ON sub_project.project_id = project.id JOIN project_participation               ON project_participation.project_id = project.id AND project_participation.invalidated = 0 JOIN cdes_role                           ON project_participation.role_id = cdes_role.id WHERE review_cycle_node_instance_released.id = ? AND cdes_role.type_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeInstanceReleasedId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)roleTypeId);
        });
    }

    @Override
    public List<ParticipationSelectionJoin> getSelectionJoinsWithParticipationOrganisationsBySubProjectAndRoleTypeId(Long subProjectId, Long roleTypeId) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getParticipationSelectionJoinSelectClause() + "FROM sub_project JOIN project               ON sub_project.project_id = project.id JOIN project_participation ON project_participation.project_id = project.id JOIN project_participant   ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 JOIN organisation_person   ON project_participant.organisation_person_id = organisation_person.id JOIN organisation          ON project_participation.organisation_id = organisation.id JOIN person                ON organisation_person.person_id = person.id JOIN cdes_role             ON project_participation.role_id = cdes_role.id WHERE sub_project.id = ? AND project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND organisation_person.retired_flag = 0 AND NOT (project.with_participants_sub_project_restriction = 1 AND EXISTS ( SELECT 1 FROM project_participation_sub_project_restrictions restriction WHERE restriction.project_participation_id = project_participation.id AND restriction.sub_project_id = sub_project.id)) ";
        if (roleTypeId != null) {
            sql = sql + "AND cdes_role.type_id = ? ";
        }
        log.info("getSelectionJoinsWithParticipationOrganisationsBySubProjectAndRoleTypeId: Will query sql for subProjectId [" + subProjectId + "]: and roleTypeId [" + roleTypeId + "] {" + sql + "}");
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcProjectParticipationDAO::fillParticipationSelectionJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
            if (roleTypeId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)roleTypeId);
            }
        });
    }

    @Override
    public List<ParticipationSelectionJoin> getSelectionJoinsBySubProjectAndRoleTypeId(Long subProjectId, Long roleTypeId) {
        String sql = "SELECT " + JdbcProjectParticipationDAO.getParticipationSelectionJoinSelectClause() + "FROM sub_project JOIN project               ON sub_project.project_id = project.id JOIN project_participation ON project_participation.project_id = project.id JOIN project_participant   ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 JOIN organisation_person   ON project_participant.organisation_person_id = organisation_person.id JOIN organisation          ON organisation_person.organisation_id = organisation.id JOIN person                ON organisation_person.person_id = person.id JOIN cdes_role             ON project_participation.role_id = cdes_role.id WHERE sub_project.id = ? AND project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND organisation_person.retired_flag = 0 AND NOT (project.with_participants_sub_project_restriction = 1 AND EXISTS ( SELECT 1 FROM project_participation_sub_project_restrictions restriction WHERE restriction.project_participation_id = project_participation.id AND restriction.sub_project_id = sub_project.id)) ";
        if (roleTypeId != null) {
            sql = sql + "AND cdes_role.type_id = ? ";
        }
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcProjectParticipationDAO::fillParticipationSelectionJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
            if (roleTypeId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)roleTypeId);
            }
        });
    }
}

