/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Label;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.joinDto.LabelJoin;
import at.cdes.impl.dao.GenLabelDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcLabelDAO
extends AbstrIdDAO<Label>
implements GenLabelDAO {
    public AbstractJdbcLabelDAO() {
        super(Label.class, "id", "label", new String[]{"id", "organisation_id", "review_cycle_id", "name", "comment", "active", "active_modified"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcLabelDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "active") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "active_modified") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcLabelDAO.getSelectClauseForDto("label", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcLabelDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".organisation_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_id") + "," + entityLocalName + ".review_cycle_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + "," + entityLocalName + ".active" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "active") + "," + entityLocalName + ".active_modified" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "active_modified") + " ";
    }

    protected Label fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Label label = new Label();
        label.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        label.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        label.setReviewCycleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        label.setName(rs.getString(++columnIndex));
        label.setComment(rs.getString(++columnIndex));
        label.setActive(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        label.setActiveModified(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        return label;
    }

    public static Label fillLabelFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Label label = new Label();
        label.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        label.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        label.setReviewCycleId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        label.setName(rs.getString(columnIndex.incrementAndGet()));
        label.setComment(rs.getString(columnIndex.incrementAndGet()));
        label.setActive(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        label.setActiveModified(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return label;
    }

    public static Label fillLabelFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcLabelDAO.fillLabelFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 7;
    }

    public static LabelJoin fillLabelJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        LabelJoin labelJoin = new LabelJoin();
        labelJoin.setLabelId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelReviewCycleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelName(rs.getString(++columnIndex));
        labelJoin.setLabelComment(rs.getString(++columnIndex));
        labelJoin.setLabelActive(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelActiveModified(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelContentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelContentLabelId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelContentDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelContentName(rs.getString(++columnIndex));
        labelJoin.setLabelContentFilename(rs.getString(++columnIndex));
        labelJoin.setLabelContentFiletype(rs.getString(++columnIndex));
        labelJoin.setLabelContentFiledigest(rs.getString(++columnIndex));
        labelJoin.setLabelContentOrigFilename(rs.getString(++columnIndex));
        labelJoin.setLabelContentOrigFiletype(rs.getString(++columnIndex));
        labelJoin.setLabelContentOrigFiledigest(rs.getString(++columnIndex));
        labelJoin.setLabelContentComment(rs.getString(++columnIndex));
        labelJoin.setLabelContentRotationAngle(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelContentIsDefault(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelContentIsAsBuiltUnchangedDestination(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setLabelContentIsRenderableOutside(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleName(rs.getString(++columnIndex));
        labelJoin.setReviewCycleDocumentVersionNumberId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleDescription(rs.getString(++columnIndex));
        labelJoin.setReviewCycleDocumentVersionInvalidationResultOptionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleDocumentInvalidationResultOptionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleEmptyNodeResultOptionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleDocumentVersionDeletedOptionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleDocumentVersionAbortedResultOptionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleIsLabelMandatory(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        labelJoin.setReviewCycleIsDefaultCycle(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        return labelJoin;
    }

    public static int getNumberOfLabelJoinAttributes() {
        return 33;
    }

    protected String getSelectClauseForLabelJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("label") ? result + "label.id, label.organisation_id, label.review_cycle_id, label.name, label.comment, label.active, label.active_modified" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("labelContent") ? result + "label_content.id, label_content.label_id, label_content.digest_calculator_id, label_content.name, label_content.filename, label_content.filetype, label_content.filedigest, label_content.orig_filename, label_content.orig_filetype, label_content.orig_filedigest, label_content.comment, label_content.rotation_angle, label_content.is_default, label_content.is_as_built_unchanged_destination, label_content.is_renderable_outside" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycle") ? result + "review_cycle.id, review_cycle.name, review_cycle.document_version_number_id, review_cycle.description, review_cycle.document_version_invalidation_result_option_id, review_cycle.document_invalidation_result_option_id, review_cycle.empty_node_result_option_id, review_cycle.document_version_deleted_option_id, review_cycle.document_version_aborted_result_option_id, review_cycle.is_label_mandatory, review_cycle.is_default_cycle" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        return result;
    }

    public int update(Label dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Label> dtos) {
        Iterator<Label> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getLabelJoinSelectClause() {
        return "label.id, label.organisation_id, label.review_cycle_id, label.name, label.comment, label.active, label.active_modified, label_content.id, label_content.label_id, label_content.digest_calculator_id, label_content.name, label_content.filename, label_content.filetype, label_content.filedigest, label_content.orig_filename, label_content.orig_filetype, label_content.orig_filedigest, label_content.comment, label_content.rotation_angle, label_content.is_default, label_content.is_as_built_unchanged_destination, label_content.is_renderable_outside, review_cycle.id, review_cycle.name, review_cycle.document_version_number_id, review_cycle.description, review_cycle.document_version_invalidation_result_option_id, review_cycle.document_invalidation_result_option_id, review_cycle.empty_node_result_option_id, review_cycle.document_version_deleted_option_id, review_cycle.document_version_aborted_result_option_id, review_cycle.is_label_mandatory, review_cycle.is_default_cycle ";
    }

    public static String getPrefixedLabelJoinSelectClause() {
        return "label.id AS label_id, label.organisation_id AS label_organisation_id, label.review_cycle_id AS label_review_cycle_id, label.name AS label_name, label.comment AS label_comment, label.active AS label_active, label.active_modified AS label_active_modified, label_content.id AS label_content_id, label_content.label_id AS label_content_label_id, label_content.digest_calculator_id AS label_content_digest_calculator_id, label_content.name AS label_content_name, label_content.filename AS label_content_filename, label_content.filetype AS label_content_filetype, label_content.filedigest AS label_content_filedigest, label_content.orig_filename AS label_content_orig_filename, label_content.orig_filetype AS label_content_orig_filetype, label_content.orig_filedigest AS label_content_orig_filedigest, label_content.comment AS label_content_comment, label_content.rotation_angle AS label_content_rotation_angle, label_content.is_default AS label_content_is_default, label_content.is_as_built_unchanged_destination AS label_content_is_as_built_unchanged_destination, label_content.is_renderable_outside AS label_content_is_renderable_outside, review_cycle.id AS review_cycle_id, review_cycle.name AS review_cycle_name, review_cycle.document_version_number_id AS review_cycle_document_version_number_id, review_cycle.description AS review_cycle_description, review_cycle.document_version_invalidation_result_option_id AS review_cycle_document_version_invalidation_result_option_id, review_cycle.document_invalidation_result_option_id AS review_cycle_document_invalidation_result_option_id, review_cycle.empty_node_result_option_id AS review_cycle_empty_node_result_option_id, review_cycle.document_version_deleted_option_id AS review_cycle_document_version_deleted_option_id, review_cycle.document_version_aborted_result_option_id AS review_cycle_document_version_aborted_result_option_id, review_cycle.is_label_mandatory AS review_cycle_is_label_mandatory, review_cycle.is_default_cycle AS review_cycle_is_default_cycle ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Label label) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)label.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)label.getOrganisationId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)label.getReviewCycleId());
        statement.setString(4, label.getName());
        statement.setString(5, label.getComment());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)6, (Boolean)label.getActive());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)7, (Double)label.getActiveModified());
    }

    @Override
    public List<Label> getByOrganisation(Organisation organisation) {
        return this.getByOrganisation(organisation.getId());
    }

    @Override
    public List<Label> getByOrganisation(final Long organisationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationId);
            }
        });
    }

    @Override
    public List<Label> getByReviewCycle(ReviewCycle reviewCycle) {
        return this.getByReviewCycle(reviewCycle.getId());
    }

    @Override
    public List<Label> getByReviewCycle(final Long reviewCycleId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, reviewCycleId);
            }
        });
    }

    @Override
    public List<Label> getByOrganisations(Collection<Long> organisationId) {
        if (organisationId.isEmpty()) {
            return new ArrayList<Label>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationId.size()];
        int n = 0;
        Iterator<Long> it = organisationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Label> getByReviewCycles(Collection<Long> reviewCycleId) {
        if (reviewCycleId.isEmpty()) {
            return new ArrayList<Label>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[reviewCycleId.size()];
        int n = 0;
        Iterator<Long> it = reviewCycleId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

