/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Attachment;
import at.cdes.api.dto.PositionResultAttachmentMap;
import at.cdes.api.dto.ReviewCyclePositionResult;
import at.cdes.impl.dao.PositionResultAttachmentMapDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcPositionResultAttachmentMapDAO
extends AbstrIdDAO<PositionResultAttachmentMap>
implements PositionResultAttachmentMapDAO {
    public JdbcPositionResultAttachmentMapDAO() {
        super(PositionResultAttachmentMap.class, "resultId", "position_result_attachment_map", new String[]{"result_id", "attachment_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcPositionResultAttachmentMapDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "result_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcPositionResultAttachmentMapDAO.getSelectClauseForDto("position_result_attachment_map", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcPositionResultAttachmentMapDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".result_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "result_id") + "," + entityLocalName + ".attachment_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_id") + " ";
    }

    protected PositionResultAttachmentMap fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        PositionResultAttachmentMap positionResultAttachmentMap = new PositionResultAttachmentMap();
        positionResultAttachmentMap.setResultId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        positionResultAttachmentMap.setAttachmentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return positionResultAttachmentMap;
    }

    public static PositionResultAttachmentMap fillPositionResultAttachmentMapFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        PositionResultAttachmentMap positionResultAttachmentMap = new PositionResultAttachmentMap();
        positionResultAttachmentMap.setResultId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        positionResultAttachmentMap.setAttachmentId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return positionResultAttachmentMap;
    }

    public static PositionResultAttachmentMap fillPositionResultAttachmentMapFromResultSet(ResultSet rs) throws SQLException {
        return JdbcPositionResultAttachmentMapDAO.fillPositionResultAttachmentMapFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteInstance(final Long resultId, final Long attachmentId) {
        String sql = "DELETE FROM position_result_attachment_map WHERE result_id = ? AND attachment_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, resultId);
                statement.setLong(currIndex++, attachmentId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteByPositionResultId(final Long resultId) {
        String sql = "DELETE FROM position_result_attachment_map WHERE result_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, resultId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteByAttachmentId(final Long attachmentId) {
        String sql = "DELETE FROM position_result_attachment_map WHERE attachment_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, attachmentId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(PositionResultAttachmentMap dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<PositionResultAttachmentMap> dtos) {
        Iterator<PositionResultAttachmentMap> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, PositionResultAttachmentMap positionResultAttachmentMap) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)positionResultAttachmentMap.getResultId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)positionResultAttachmentMap.getAttachmentId());
    }

    @Override
    public List<PositionResultAttachmentMap> getByResult(ReviewCyclePositionResult reviewCyclePositionResult) {
        return this.getByResult(reviewCyclePositionResult.getId());
    }

    @Override
    public List<PositionResultAttachmentMap> getByResult(final Long reviewCyclePositionResultId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"result_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, reviewCyclePositionResultId);
            }
        });
    }

    @Override
    public List<PositionResultAttachmentMap> getByAttachment(Attachment attachment) {
        return this.getByAttachment(attachment.getId());
    }

    @Override
    public List<PositionResultAttachmentMap> getByAttachment(final Long attachmentId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"attachment_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, attachmentId);
            }
        });
    }

    @Override
    public List<PositionResultAttachmentMap> getByResults(Collection<Long> reviewCyclePositionResultId) {
        if (reviewCyclePositionResultId.isEmpty()) {
            return new ArrayList<PositionResultAttachmentMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[reviewCyclePositionResultId.size()];
        int n = 0;
        Iterator<Long> it = reviewCyclePositionResultId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"result_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<PositionResultAttachmentMap> getByAttachments(Collection<Long> attachmentId) {
        if (attachmentId.isEmpty()) {
            return new ArrayList<PositionResultAttachmentMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[attachmentId.size()];
        int n = 0;
        Iterator<Long> it = attachmentId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"attachment_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

