/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.document.compositeDto.DocumentListOtherVersionNodeResultInfo;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionPositionResultInfo;
import at.cdes.api.joinDto.ReviewProtocolBaseJoin;
import at.cdes.api.joinDto.ReviewProtocolVersionJoin;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.batik.BatikSvgException;
import at.cdes.batik.BatikSvgRendererOperations;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.reviewCycle.ReviewProtocolContext;
import at.cdes.impl.reviewCycle.ReviewProtocolGeometry;
import at.cdes.impl.reviewCycle.ReviewProtocolSvgCalculator;
import at.cdes.impl.reviewCycle.SvgCorner;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.holiday.HolidayCalculator;
import at.cdes.impl.util.i18n.I18nHelper;
import at.cdes.impl.util.svg.SvgHelper;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.clazzes.util.lang.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewProtocolSvgRenderer {
    private BatikSvgRendererOperations batikSvgRenderer;
    private String personVariablesUserLocale;
    private Boolean reversePreduration;
    private ReviewProtocolSvgCalculator reviewProtocolSvgCalculator;
    private static final XMLOutputFactory XOF = XMLOutputFactory.newFactory();
    private static final NamespaceContext SVG_NAMESPACE_CONTEXT;
    private ArrayList<TextWithPosition> cellsVersionString;
    private static final Logger log;
    public static final double DEFAULT_HEIGHT = 250.0;
    public static final String SCALE_Y_KEY = "__iemeeg0omudo8ieW__scaleY__";
    public static final String TRANSLATE_Y_KEY = "__iemeeg0omudo8ieW__translateY__";

    public void setBatikSvgRenderer(BatikSvgRendererOperations batikSvgRenderer) {
        this.batikSvgRenderer = batikSvgRenderer;
    }

    public void setReversePreduration(Boolean reversePreduration) {
        this.reversePreduration = reversePreduration;
    }

    public void setReviewProtocolSvgCalculator(ReviewProtocolSvgCalculator reviewProtocolSvgCalculator) {
        this.reviewProtocolSvgCalculator = reviewProtocolSvgCalculator;
    }

    public Pair<String, Integer> render(ReviewProtocolContext context, double totalWidth, double totalHeight, String personVariablesUserLocale) {
        Integer actualHeight = null;
        StringWriter stringWriter = new StringWriter();
        XMLStreamWriter xsw = null;
        this.personVariablesUserLocale = personVariablesUserLocale;
        try {
            xsw = XOF.createXMLStreamWriter(stringWriter);
            xsw.setNamespaceContext(SVG_NAMESPACE_CONTEXT);
            xsw.writeStartElement("svg");
            xsw.writeAttribute("xmlns", "http://www.w3.org/2000/svg");
            xsw.writeAttribute("width", String.valueOf(totalWidth));
            xsw.writeAttribute("height", String.valueOf(totalHeight));
            actualHeight = this.doRender(xsw, context, totalWidth, totalHeight);
            xsw.writeEndElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (xsw != null) {
                    xsw.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing XMLStreamWriter", e);
            }
        }
        String result = stringWriter.toString();
        return new Pair((Object)result, (Object)actualHeight);
    }

    private int doRender(XMLStreamWriter xsw, ReviewProtocolContext context, double totalWidth, double totalHeight) throws Exception {
        this.drawBoxDefinition(xsw);
        xsw.writeStartElement("g");
        xsw.writeAttribute("transform", "scale(1 __iemeeg0omudo8ieW__scaleY__) translate(0 __iemeeg0omudo8ieW__translateY__)");
        ReviewProtocolGeometry geometry = this.reviewProtocolSvgCalculator.calculateAxis(context, totalWidth, totalHeight);
        this.drawRealAxis(xsw, context, geometry);
        int spaceForRealReviewCycle = this.drawRealReviewCycle(xsw, context, geometry);
        int actualHeight = geometry.getAxisHeight() + spaceForRealReviewCycle;
        geometry.setYBasic(geometry.getTotalHeight() - (double)actualHeight);
        double plannedHeight = 0.0;
        boolean drawPlannedReviewCycle = geometry.isDrawPlannedReviewCycle();
        ReviewProtocolBaseJoin baseJoin = context.getBaseJoin();
        Long releasedDocumentId = baseJoin.getDocumentReleaseId();
        if (drawPlannedReviewCycle && releasedDocumentId != null) {
            plannedHeight = this.drawPlannedReviewCycle(xsw, context, geometry);
            actualHeight = (int)((double)actualHeight + plannedHeight);
        }
        this.drawOuterLabel(xsw, geometry, plannedHeight, actualHeight);
        xsw.writeEndElement();
        return actualHeight;
    }

    private void drawBoxDefinition(XMLStreamWriter xsw) throws Exception {
        xsw.writeStartElement("defs");
        SvgHelper.addRect(xsw, 0.0, 0.0, 10.0, 10.0, "box", "stroke", "black", "stroke-width", "1px", "fill", "white");
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "posBox");
        SvgHelper.addUse(xsw, "#box");
        SvgHelper.addLineWithStroke(xsw, 2.5, 5.0, 7.5, 5.0, "green", 1.0);
        SvgHelper.addLineWithStroke(xsw, 5.0, 2.5, 5.0, 7.5, "green", 1.0);
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "negBox");
        SvgHelper.addUse(xsw, "#box");
        SvgHelper.addLineWithStroke(xsw, 2.5, 5.0, 7.5, 5.0, "red", 1.0);
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "okBox");
        SvgHelper.addUse(xsw, "#box");
        SvgHelper.addLineWithStroke(xsw, 7.5, 2.5, 3.8, 7.5, "green", 1.0);
        SvgHelper.addLineWithStroke(xsw, 3.8, 7.5, 2.5, 5.0, "green", 1.0);
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "cancelBox");
        SvgHelper.addUse(xsw, "#box");
        SvgHelper.addLineWithStroke(xsw, 2.5, 2.5, 7.5, 7.5, "red", 1.0);
        SvgHelper.addLineWithStroke(xsw, 2.5, 7.5, 7.5, 2.5, "red", 1.0);
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "xBox");
        SvgHelper.addUse(xsw, "#box");
        SvgHelper.addLineWithStroke(xsw, 2.5, 2.5, 7.5, 7.5, "blue", 1.0);
        SvgHelper.addLineWithStroke(xsw, 2.5, 7.5, 7.5, 2.5, "blue", 1.0);
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "uploadBox");
        SvgHelper.addUse(xsw, "#box");
        SvgHelper.addCircleWithStrokeAndFill(xsw, 5.0, 5.0, 2.5, "blue", 2.0, "none");
        SvgHelper.addRectWithFill(xsw, 3.75, 0.5, 1.2, 4.3349, "white");
        SvgHelper.addPolygonWithFill(xsw, new double[]{4.85, 1.3359, 8.15, 1.3349, 4.85, 4.3349, 4.85, 1.3359}, "blue");
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "deletedBox");
        SvgHelper.addUse(xsw, "#box");
        SvgHelper.addCircleWithStrokeAndFill(xsw, 5.0, 5.0, 2.5, "red", 2.0, "none");
        SvgHelper.addRectWithFill(xsw, 3.75, 0.5, 1.2, 4.3349, "white");
        SvgHelper.addPolygonWithFill(xsw, new double[]{4.85, 1.3359, 8.15, 1.3349, 4.85, 4.3349, 4.85, 1.3359}, "red");
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "firstUploadBox");
        SvgHelper.addUse(xsw, "#box");
        SvgHelper.addRectWithFill(xsw, 4.0, 5.0, 2.0, 3.0, "blue");
        SvgHelper.addPolygonWithFill(xsw, new double[]{5.0, 2.0, 8.0, 5.0, 2.0, 5.0, 5.0, 2.0}, "blue");
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "arrow");
        SvgHelper.addPolygonWithFill(xsw, new double[]{0.0, 2.5, 0.0, 7.5, 7.5, 5.0, 0.0, 2.5}, "black");
        xsw.writeEndElement();
        xsw.writeStartElement("symbol");
        xsw.writeAttribute("id", "stopArrow");
        SvgHelper.addUse(xsw, "#arrow");
        SvgHelper.addLineWithStroke(xsw, 8.5, 0.0, 8.5, 10.0, "black", 2.0);
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    private void drawRealAxis(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry) throws Exception {
        Double axisStart;
        geometry.printToLog();
        boolean drawWeeks = geometry.isDoDrawWeeks();
        if (drawWeeks) {
            axisStart = geometry.getAxisStart();
            Double totalWidth = geometry.getTotalWidth();
            Double totalHeight = geometry.getTotalHeight();
            this.drawDateWeeksAxis(xsw, context, geometry, axisStart, ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, 0.0, totalWidth, totalHeight);
        } else {
            axisStart = geometry.getAxisStart();
            Double totalWidth = geometry.getTotalWidth();
            Double totalHeight = geometry.getTotalHeight();
            this.drawDateAxis(xsw, geometry, axisStart, ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, 0.0, totalWidth, totalHeight);
        }
        double yBasic = geometry.getTotalHeight() - (double)ReviewProtocolSvgCalculator.SIZE_OF_VERSION_LABEL - (double)geometry.getAxisHeight();
        geometry.setYBasic(yBasic);
    }

    private void drawPlannedAxis(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry) throws Exception {
        boolean drawWeeks = geometry.isDoDrawWeeks();
        boolean calculateNewAxis = geometry.isCalculateNewAxis();
        double yBasic = geometry.getYBasic();
        Double axisStart = calculateNewAxis ? geometry.getAxisStartTwo() : geometry.getAxisStart();
        Double totalWidth = geometry.getTotalWidth();
        if (drawWeeks) {
            this.drawDateWeeksAxis(xsw, context, geometry, axisStart, ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, 0.0, totalWidth, yBasic);
        } else {
            this.drawDateAxis(xsw, geometry, axisStart, ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, 0.0, totalWidth, yBasic);
        }
        geometry.setYBasic(yBasic -= (double)geometry.getAxisHeight());
    }

    private void drawDateWeeksAxis(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry, Double start, double x1, double y1, double x2, double y2) throws Exception {
        double toDayPos;
        ReviewProtocolBaseJoin baseJoin = context.getBaseJoin();
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        SimpleDateFormat simpleDateFormat = this.constructSimpleDateFormat(baseJoin);
        double graphWidth = geometry.getGraphWidth();
        int projectDurationInWeeks = geometry.getProjectDurationInWeeks();
        int placeForAxis = 30;
        double basic = Math.floor(graphWidth / (double)projectDurationInWeeks);
        Double startDate = ReviewProtocolSvgCalculator.jumpToStartOfWeek(start);
        Double endDate = ReviewProtocolSvgCalculator.jumpByDays(startDate, 7 * projectDurationInWeeks);
        Collection<Calendar> holidays = holidayCalculator.getHolidaysBetween(ReviewProtocolSvgCalculator.getAsCalendar(startDate), ReviewProtocolSvgCalculator.getAsCalendar(endDate));
        double totalHeight = geometry.getTotalHeight();
        for (Calendar holiday : holidays) {
            Double holidayUtcSeconds;
            double holidayXPosition;
            if (holiday.get(7) == 7 || holiday.get(7) == 1 || !((holidayXPosition = ReviewProtocolSvgCalculator.getXPositionFromStart(true, startDate, holidayUtcSeconds = ReviewProtocolSvgCalculator.getAsUtcSeconds(holiday), basic)) < basic * (double)projectDurationInWeeks)) continue;
            SvgHelper.addRectWithFillAndOpacity(xsw, x1 + holidayXPosition, y2 - 30.0, basic / 7.0, 30.0, "#96bbdf", ".3");
        }
        long currentTimeMillis = System.currentTimeMillis();
        Double currentTimeUtcSeconds = new Double(currentTimeMillis) / 1000.0;
        if (endDate > currentTimeUtcSeconds && (toDayPos = ReviewProtocolSvgCalculator.getXPositionFromStart(true, startDate, currentTimeUtcSeconds, basic)) < basic * (double)projectDurationInWeeks) {
            SvgHelper.addRectWithFill(xsw, x1 + toDayPos, y2 - 30.0, basic / 7.0, 30.0, "#ffffff");
            SvgHelper.addRectWithFillAndOpacity(xsw, x1 + toDayPos, y2 - 30.0, basic / 7.0, 30.0, "#ff0000", ".3");
        }
        Calendar startDateCalendar = ReviewProtocolSvgCalculator.getAsCalendar(startDate);
        int weekOfYear = startDateCalendar.get(3);
        for (int i = 1; i <= projectDurationInWeeks; ++i) {
            String weekOfYearString;
            SvgHelper.addRectWithFillAndOpacity(xsw, x1 + (double)i * basic - 2.0 * (basic / 7.0), y2 - 30.0, 2.0 * (basic / 7.0), 30.0, "#96bbdf", ".3");
            if (i <= projectDurationInWeeks - 1) {
                SvgHelper.addLineWithStroke(xsw, x1 + (double)i * basic, y2 - 30.0, x1 + (double)i * basic, y2 - 15.0, "black", 1.0);
            } else {
                SvgHelper.addLineWithStroke(xsw, x1 + (double)i * basic, y2 - 30.0, x1 + (double)i * basic, y2, "black", 1.0);
            }
            double dayBasic = x1 + (double)(i - 1) * basic;
            for (int j = 1; j < 7; ++j) {
                SvgHelper.addLineWithStroke(xsw, dayBasic + (double)j * basic / 7.0, y2 - 30.0, dayBasic + (double)j * basic / 7.0, y2 - 27.5, "black", 1.0);
            }
            double shiftToLeft = 0.0;
            String string = weekOfYearString = basic > 50.0 ? "KW " + weekOfYear : String.valueOf(weekOfYear);
            if (weekOfYearString.length() > 4) {
                shiftToLeft = 2.5;
            }
            SvgHelper.addTextWithFontFamilyAndSize(xsw, x1 + (basic / 2.0 - 10.0) + (double)(i - 1) * basic - shiftToLeft, y2 - 17.5, weekOfYearString, "verdana", 10.0);
            if (weekOfYear == startDateCalendar.getActualMaximum(3)) {
                weekOfYear = 1;
                continue;
            }
            ++weekOfYear;
        }
        SvgHelper.addLineWithStroke(xsw, x1, y2 - 30.0, x1 + basic * (double)projectDurationInWeeks, y2 - 30.0, "black", 1.0);
        SvgHelper.addLineWithStroke(xsw, x1, y2 - 30.0, x1, y2, "black", 1.0);
        SvgHelper.addLineWithStroke(xsw, x1, y2 - 15.0, x1 + basic * (double)projectDurationInWeeks, y2 - 15.0, "black", 1.0);
        SvgHelper.addLineWithStroke(xsw, x1, y2, x1 + basic * (double)projectDurationInWeeks, y2, "black", 1.0);
        int days = ReviewProtocolSvgCalculator.calculateDaysToDraw(startDate, endDate);
        int startDay = 1;
        int countWeeks = 0;
        boolean justStarted = true;
        double xposition = x1;
        for (int i = 0; i < days; ++i) {
            int day;
            if (startDay % 7 == 0) {
                ++countWeeks;
            }
            if ((day = startDateCalendar.get(5)) == 1 || justStarted) {
                double size;
                int d = 0;
                if (justStarted) {
                    d = startDateCalendar.getActualMaximum(5) - day;
                    justStarted = false;
                } else {
                    d = startDateCalendar.getActualMaximum(5);
                    xposition = basic / 7.0 * (double)(startDay % 7 - 1) + basic * (double)countWeeks + x1;
                }
                double spaceForText = basic / 7.0 * (double)d;
                if (xposition + spaceForText > x1 + basic * (double)projectDurationInWeeks) {
                    spaceForText = x1 + basic * (double)projectDurationInWeeks - xposition;
                }
                String timeString = simpleDateFormat.format(startDateCalendar.getTime());
                try {
                    size = this.batikSvgRenderer.getTextWidth("Verdana", timeString) * 10.0;
                }
                catch (BatikSvgException e) {
                    throw new RuntimeException("error calculating text width", e);
                }
                if (spaceForText > size) {
                    double tmp = spaceForText / 2.0 - size / 2.0;
                    SvgHelper.addTextWithFontFamilyAndSize(xsw, xposition + tmp, y2 - 2.5, timeString, "verdana", 10.0);
                }
                if (xposition < x2) {
                    SvgHelper.addLineWithStroke(xsw, xposition, y2 - 15.0, xposition, y2, "black", 1.0);
                }
            }
            startDay = startDay == 7 ? 1 : ++startDay;
            startDateCalendar.set(5, day + 1);
            startDate = ReviewProtocolSvgCalculator.getAsUtcSeconds(startDateCalendar);
        }
        geometry.setAxisHeight(placeForAxis);
    }

    private void drawDateAxis(XMLStreamWriter xsw, ReviewProtocolGeometry geometry, Double startDate, double x1, double y1, double x2, double y2) throws Exception {
        int projectDurationInDays = geometry.getProjectDurationInDays();
        Double stopDate = ReviewProtocolSvgCalculator.jumpByDays(startDate, projectDurationInDays);
        double width = x2 - x1;
        double basic = width / (double)projectDurationInDays;
        double bottom = y2;
        boolean vertical = basic * 31.0 < 40.0;
        int placeForAxis = vertical ? 40 : 20;
        SvgHelper.addLineWithStroke(xsw, x1, bottom - (double)placeForAxis, x2, bottom - (double)placeForAxis, "black", 1.0);
        SvgHelper.addLineWithStroke(xsw, x1, bottom, x2, bottom, "black", 1.0);
        SvgHelper.addLineWithStroke(xsw, x1, bottom - (double)placeForAxis, x1, bottom, "black", 1.0);
        double stepBasis = x1;
        Double currDate = startDate;
        while (currDate < stopDate) {
            Calendar currDateCalendar = ReviewProtocolSvgCalculator.getAsCalendar(currDate);
            double spaceThisMonth = basic * (double)currDateCalendar.getActualMaximum(5);
            double x = spaceThisMonth + stepBasis;
            if (x > x2) {
                x = x2;
                spaceThisMonth = x - stepBasis;
            }
            SvgHelper.addLineWithStroke(xsw, x, bottom - (double)placeForAxis, x, bottom, "black", 1.0);
            if (vertical && spaceThisMonth > 10.0 || spaceThisMonth > 30.0) {
                double xText = stepBasis;
                xText = spaceThisMonth < 40.0 && vertical ? (xText += spaceThisMonth / 2.0) : (spaceThisMonth > 40.0 ? (xText += spaceThisMonth / 2.0 - 10.0) : (xText += 2.0));
                String monthString = ReviewProtocolSvgRenderer.getMonthString(currDateCalendar.get(2) + 1);
                String yearString = ReviewProtocolSvgRenderer.getYearString(currDateCalendar.get(1));
                SvgHelper.addTextWithTransform(xsw, xText, bottom - 5.0, monthString + "/" + yearString, vertical ? "rotate(-90," + xText + "," + (bottom - 2.0) + ")" : null, "font-family", "verdana", "font-size", "10px");
            }
            stepBasis = x;
            currDateCalendar.add(2, 1);
            currDate = ReviewProtocolSvgCalculator.getAsUtcSeconds(currDateCalendar);
        }
        geometry.setAxisHeight(placeForAxis);
    }

    private static String getMonthString(int i) {
        if (i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    private static String getYearString(int firstYearInt) {
        String year = String.valueOf(firstYearInt);
        return year.substring(2);
    }

    private SimpleDateFormat constructSimpleDateFormat(ReviewProtocolBaseJoin baseJoin) {
        SimpleDateFormat simpleDateFormat = null;
        if (baseJoin.getCountryCode2() != null) {
            String localeString = baseJoin.getCountryCode2();
            Locale locale = Locale.ENGLISH;
            if ("AT".equals(localeString) || "DE".equals(localeString)) {
                locale = Locale.GERMAN;
            }
            if ("IT".equals(localeString)) {
                locale = Locale.ITALIAN;
            }
            simpleDateFormat = new SimpleDateFormat("MMMMM yy", locale);
        } else {
            simpleDateFormat = new SimpleDateFormat("MMMMM yy");
        }
        return simpleDateFormat;
    }

    private int drawRealReviewCycle(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry) throws Exception {
        double startCycleX;
        int widthOfNodesToDraw = this.reviewProtocolSvgCalculator.getVAreaOfNodesToDraw(context, 20);
        double spacePerTimeUnit = geometry.getSpacePerTimeUnit();
        int heightOfAxis = geometry.getAxisHeight();
        int yPositionOfCell = widthOfNodesToDraw;
        ArrayList<SeparateBoxLabel> separateBoxLabels = new ArrayList<SeparateBoxLabel>();
        this.cellsVersionString = new ArrayList();
        int nodeLabel = 1;
        boolean firstOpenNode = true;
        boolean endOfReviewCycleReached = false;
        boolean drawWeeks = geometry.isDoDrawWeeks();
        Double axisStart = geometry.getAxisStart();
        Double actualReviewCycleStart = geometry.getActualReviewCycleStart();
        double nodeStartX = startCycleX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, actualReviewCycleStart, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
        double nodeEndX = -1.0;
        boolean isNodeResultInvalidatedAll = false;
        boolean lastCellResultIsInvalidated = false;
        ReviewProtocolVersionJoin lastNodeResultJoin = null;
        List<ReviewProtocolVersionJoin> cellResultJoinsSortedByUploaded = context.getCellResultJoinsSortedByUploaded();
        boolean lastDocumentVersionHasCellResult = this.hasLastDocumentVersionCellResult(context, cellResultJoinsSortedByUploaded);
        int numberOfDeletedCells = 0;
        for (int cellResultIndex = 0; cellResultIndex < cellResultJoinsSortedByUploaded.size(); ++cellResultIndex) {
            boolean deleted;
            ReviewProtocolVersionJoin cellResultJoin = cellResultJoinsSortedByUploaded.get(cellResultIndex);
            boolean bl = deleted = DocumentVersionStatus.getByValue((Integer)cellResultJoin.getDocumentVersionStatus()) == DocumentVersionStatus.DELETED;
            if (deleted) {
                ++numberOfDeletedCells;
            }
            if (deleted || this.isCellResultInconsistent(cellResultJoin, cellResultJoinsSortedByUploaded, 1 + numberOfDeletedCells)) continue;
            Long cellResultId = cellResultJoin.getReviewCycleCellResultId();
            Long documentVersionId = cellResultJoin.getDocumentVersionId();
            ReviewProtocolVersionJoin versionJoin = context.getVersionJoinByDocumentVersion(documentVersionId);
            endOfReviewCycleReached = false;
            if (versionJoin.getEntryResultPersonId() != null) {
                this.addEntryResultPersonBoxLabel(versionJoin, geometry, yPositionOfCell, nodeStartX, separateBoxLabels);
            } else if (versionJoin.getDestVersionCellConnectionResultResultDate() != null) {
                this.addConnectionResultPersonBoxLabel(versionJoin, geometry, yPositionOfCell, separateBoxLabels);
            }
            String color = cellResultJoin.getReviewCycleCellSvgColor();
            TextWithPosition versionString = this.initializeVersionString(versionJoin, nodeStartX, color);
            List<ReviewProtocolVersionJoin> nodeResultJoins = context.getNodeResultJoinsSortedByPosition(cellResultId);
            for (int nodeResultIndex = 0; nodeResultIndex < nodeResultJoins.size(); ++nodeResultIndex) {
                ReviewProtocolVersionJoin nodeResultJoin = nodeResultJoins.get(nodeResultIndex);
                if (this.skipNodeResultLoop(nodeResultJoin, context, endOfReviewCycleReached |= this.isEndOfReviewCycleReached(nodeResultJoin, context))) continue;
                isNodeResultInvalidatedAll = this.isNodeResultInvalidatedAll(nodeResultJoin);
                Long nodeResultId = nodeResultJoin.getReviewCycleNodeResultId();
                List<ReviewProtocolVersionJoin> unfilteredPositionResultJoins = context.getPositionResultJoinsSortedByResultDate(nodeResultId);
                ArrayList<ReviewProtocolVersionJoin> positionResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
                for (ReviewProtocolVersionJoin positionResultJoin : unfilteredPositionResultJoins) {
                    if (positionResultJoin.getReviewCyclePositionResultCommentReferenceId() != null) continue;
                    positionResultJoins.add(positionResultJoin);
                }
                if (nodeResultJoin.isReviewCycleNodeFree().booleanValue()) {
                    for (ReviewProtocolVersionJoin positionResultJoin : positionResultJoins) {
                        Double actualDate = positionResultJoin.getReviewCyclePositionResultResultDate();
                        double xPosition = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, actualDate, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                        Long positionResultResultOptionId = positionResultJoin.getReviewCyclePositionResultReviewCycleResultOptionId();
                        Long positionResultSignatureId = positionResultJoin.getReviewCyclePositionResultSignatureId();
                        if (positionResultResultOptionId == null || positionResultSignatureId == null) continue;
                        this.addPositionResultPersonBoxLabel(context, geometry, positionResultJoin, nodeStartX, xPosition, yPositionOfCell, separateBoxLabels);
                    }
                    continue;
                }
                boolean isEndOfReviewCycleInvalidated = this.isEndOfReviewCycleInvalidated(nodeResultJoin, context);
                Double nodeStart = nodeResultJoin.getReviewCycleNodeResultArrivalDate();
                double nodeInvalidatedStartX = -1.0;
                if (isEndOfReviewCycleInvalidated) {
                    for (ReviewProtocolVersionJoin positionResultJoin : positionResultJoins) {
                        if (!this.isInvalidatedPositionResultOption(positionResultJoin)) continue;
                        if (nodeStart != null) {
                            nodeInvalidatedStartX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, nodeStart, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                            nodeStart = positionResultJoin.getReviewCyclePositionResultResultDate();
                            continue;
                        }
                        nodeInvalidatedStartX = ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                    }
                }
                Double actualNodeEnd = ReviewProtocolSvgRenderer.verifyDocumentDepartureDate(nodeResultJoin, positionResultJoins);
                DelayInfo delayInfo = ReviewProtocolSvgRenderer.calculateDelayOfActualNode(context, nodeResultJoin, nodeStart);
                Double nodeEnd = this.calculateNodeEnd(delayInfo, actualNodeEnd);
                int daysInNode = this.calculateDaysInNode(context, nodeStart, actualNodeEnd);
                nodeStartX = this.calculateNodeStartX(nodeStart, drawWeeks, axisStart, spacePerTimeUnit);
                nodeEndX = this.calculateNodeEndX(context, geometry, firstOpenNode, nodeStartX, nodeEnd, drawWeeks, axisStart, actualNodeEnd, spacePerTimeUnit);
                this.drawSeparateInvalidationLineIfNecessary(xsw, geometry, nodeInvalidatedStartX, nodeStartX, yPositionOfCell);
                boolean delayed = delayInfo.getNodesDelay() < 0 || actualNodeEnd == null;
                int typeOfEdges = ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeResultJoin, delayed);
                if (nodeEnd != null) {
                    double yBasic = geometry.getYBasic();
                    double posCenter = yBasic - (double)yPositionOfCell + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2);
                    ReviewProtocolSvgRenderer.drawNode(xsw, nodeStartX, nodeEndX, posCenter, ReviewProtocolSvgCalculator.HEIGHT_OF_NODE, color, null, false, delayInfo.getNodesDuration(), typeOfEdges);
                }
                nodeStartX = nodeEndX;
                if (delayInfo.getNodesDelay() < 0) {
                    if (actualNodeEnd != null) {
                        nodeEnd = actualNodeEnd;
                    } else {
                        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
                        nodeEnd = holidayCalculator.addWorkingDays(DateHelper.getCurrentUtcSeconds(), 1);
                    }
                    nodeEndX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, nodeEnd, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                    int typeOfEdges2 = ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeResultJoin, false);
                    nodeStartX = ReviewProtocolSvgRenderer.drawNode(xsw, nodeStartX, nodeEndX, geometry.getYBasic() - (double)yPositionOfCell + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), ReviewProtocolSvgCalculator.HEIGHT_OF_NODE, "#ff0000", "0.7", false, delayInfo.getNodesDelay(), typeOfEdges2 - typeOfEdges);
                }
                boolean isLastNodeResult = nodeResultIndex == nodeResultJoins.size() - 1;
                boolean lastCellResult = cellResultIndex == cellResultJoinsSortedByUploaded.size() - 1;
                boolean bl2 = lastCellResultIsInvalidated = lastCellResult && (this.isCellResultInvalidated(nodeResultJoin) || !lastDocumentVersionHasCellResult);
                if (lastCellResultIsInvalidated && isLastNodeResult) {
                    nodeStart = nodeEnd;
                    HolidayCalculator holidayCalculator = context.getHolidayCalculator();
                    double newContractualDeadline = holidayCalculator.addWorkingDays(actualNodeEnd, delayInfo.getNodesDuration());
                    int newNodesDelay = holidayCalculator.getWorkingDaysBetween(DateHelper.getCurrentUtcSeconds(), newContractualDeadline);
                    delayInfo.setContractualDeadline(newContractualDeadline);
                    delayInfo.setNodesDelay(newNodesDelay);
                    nodeEnd = newNodesDelay < 0 ? Double.valueOf(newContractualDeadline) : holidayCalculator.addWorkingDays(DateHelper.getCurrentUtcSeconds(), 1);
                    nodeEndX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, nodeEnd, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                    double yBasic = geometry.getYBasic();
                    nodeStartX = ReviewProtocolSvgRenderer.drawNode(xsw, nodeStartX, nodeEndX, yBasic - (double)yPositionOfCell + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), ReviewProtocolSvgCalculator.HEIGHT_OF_NODE, color, null, false, delayInfo.getNodesDuration(), typeOfEdges);
                    if (newNodesDelay < 0) {
                        nodeEnd = holidayCalculator.addWorkingDays(DateHelper.getCurrentUtcSeconds(), 1);
                        nodeEndX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, nodeEnd, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                        int typeOfEdges2 = ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeResultJoin, false);
                        nodeStartX = ReviewProtocolSvgRenderer.drawNode(xsw, nodeStartX, nodeEndX, yBasic - (double)yPositionOfCell + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), ReviewProtocolSvgCalculator.HEIGHT_OF_NODE, "#ff0000", "0.7", false, delayInfo.getNodesDelay(), typeOfEdges2 - typeOfEdges);
                    }
                }
                nodeLabel = this.drawNodeStatusText(xsw, geometry, nodeResultJoin, delayInfo, daysInNode, nodeLabel, startCycleX, yPositionOfCell, nodeStartX);
                this.addPositionResultBoxLabels(context, positionResultJoins, geometry, drawWeeks, axisStart, nodeEndX, Double.valueOf(yPositionOfCell), spacePerTimeUnit, separateBoxLabels);
                yPositionOfCell -= 20;
                if (nodeEndX - nodeStartX >= 2.0) {
                    nodeStartX = nodeEndX;
                }
                if ((nodeStart = actualNodeEnd) != null) {
                    nodeStart = ReviewProtocolSvgCalculator.jumpByDays(nodeStart, 1);
                }
                lastNodeResultJoin = nodeResultJoin;
                if (isNodeResultInvalidatedAll) break;
            }
            versionString.xEndOfCell = nodeStartX;
            this.cellsVersionString.add(versionString);
        }
        Double axisEnd = geometry.getAxisEnd();
        if (!endOfReviewCycleReached && DateHelper.getCurrentUtcSeconds() < axisEnd && !isNodeResultInvalidatedAll) {
            this.drawRemainingCells(xsw, context, lastNodeResultJoin, geometry, drawWeeks, axisStart, spacePerTimeUnit, nodeEndX, lastCellResultIsInvalidated);
        }
        double yBasic = geometry.getYBasic();
        double axisWidth = geometry.getAxisWidth();
        SvgHelper.addRectWithStrokeFillAndFillOpacity(xsw, Double.valueOf(ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL), yBasic, startCycleX - (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL, 20.0, "none", "grey", ".1");
        SvgHelper.addLineWithStroke(xsw, Double.valueOf(ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL), yBasic, axisWidth + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, yBasic, "black", 1.0);
        SvgHelper.addTextWithFontFamilyAndSize(xsw, (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL + 5.0, yBasic + 15.0, "Version", "verdana", 10.0);
        this.drawStatusBar(xsw, this.cellsVersionString, yBasic);
        int spaceForSeparateLabels = 0;
        if (separateBoxLabels.size() > 0) {
            double totalWidth = geometry.getTotalWidth();
            double totalHeight = geometry.getTotalHeight();
            int axisHeight = geometry.getAxisHeight();
            spaceForSeparateLabels = this.calculateSeparateBoxLabels(xsw, geometry, separateBoxLabels, ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, totalHeight - (double)(widthOfNodesToDraw + axisHeight + 30), totalWidth, totalHeight - (double)axisHeight - 20.0);
        }
        int actualheight = widthOfNodesToDraw;
        actualheight += spaceForSeparateLabels;
        return actualheight += 50;
    }

    private double drawPlannedReviewCycle(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry) throws Exception {
        double plannedNodeStartX;
        this.drawPlannedAxis(xsw, context, geometry);
        ArrayList<TextWithPosition> versionStrings = new ArrayList<TextWithPosition>();
        ArrayList<SeparateBoxLabel> boxLabels = new ArrayList<SeparateBoxLabel>();
        double nodeStartX = plannedNodeStartX = ReviewProtocolSvgCalculator.getPlannedNodeStartX(geometry);
        ReviewProtocolBaseJoin baseJoin = context.getBaseJoin();
        double yBasic = geometry.getYBasic();
        double yValue = yBasic - (double)ReviewProtocolSvgCalculator.SIZE_OF_VERSION_LABEL - 20.0;
        int preduration = baseJoin.getReviewCycleInstanceReleasedDurationPre();
        if (!(preduration <= 0 || this.reversePreduration != null && this.reversePreduration.booleanValue())) {
            this.drawPredurationNode(xsw, context, geometry, nodeStartX, yValue);
        }
        boolean firstNode = true;
        List<ReviewProtocolVersionJoin> cellInstanceReleasedJoins = this.getReviewCycleCellInstancesReleasedDefault(context);
        for (ReviewProtocolVersionJoin cellInstanceReleasedJoin : cellInstanceReleasedJoins) {
            if (cellInstanceReleasedJoin.getReviewCycleCellPosition() == null) continue;
            TextWithPosition versionString = this.initializeCellReleaseVersionString(cellInstanceReleasedJoin, nodeStartX);
            Long reviewCycleCellInstanceReleasedId = cellInstanceReleasedJoin.getReviewCycleCellInstanceReleasedId();
            List<ReviewProtocolVersionJoin> nodeInstanceReleasedJoins = context.getNodeInstanceReleasedJoinsSortedByPosition(reviewCycleCellInstanceReleasedId);
            for (ReviewProtocolVersionJoin nodeInstanceReleasedJoin : nodeInstanceReleasedJoins) {
                Long positionTypeId = nodeInstanceReleasedJoin.getReviewCycleNodeReviewCyclePositionTypeId();
                if (nodeInstanceReleasedJoin.getNonEmptyNodeInstanceReleasedId() != null || !nodeInstanceReleasedJoin.isReviewCycleCellIsEndCell().booleanValue() && context.isEndPositionType(positionTypeId)) {
                    nodeStartX = this.addPlannedNodeInstanceReleasedBoxLabel(xsw, context, geometry, nodeInstanceReleasedJoin, firstNode, nodeStartX, yValue, boxLabels);
                    firstNode = false;
                    continue;
                }
                this.drawEndOfCycleNode(xsw, context, geometry, nodeInstanceReleasedJoin, nodeStartX, yValue);
            }
            versionString.xEndOfCell = nodeStartX;
            versionStrings.add(versionString);
        }
        Double endX = this.drawPlannedEndDate(xsw, context, geometry, yValue);
        this.drawPlannedStartDate(xsw, context, geometry, endX, yValue);
        double axisWidth = geometry.getAxisWidth();
        double axisHeight = geometry.getAxisHeight();
        int labelsize = this.calculateSeparateBoxLabels(xsw, geometry, boxLabels, ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, yValue - 25.0 - axisHeight, axisWidth + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, yValue);
        this.drawPlannedStatusBar(xsw, geometry, plannedNodeStartX);
        this.drawStatusBar(xsw, versionStrings, yBasic - (double)ReviewProtocolSvgCalculator.SIZE_OF_VERSION_LABEL);
        double plannedHeight = 50.0 + axisHeight + (double)labelsize;
        return plannedHeight;
    }

    private void drawOuterLabel(XMLStreamWriter xsw, ReviewProtocolGeometry geometry, double plannedHeight, double actualHeight) throws Exception {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        boolean drawPlannedReviewCycle = geometry.isDrawPlannedReviewCycle();
        double totalHeight = geometry.getTotalHeight();
        double axisHeight = geometry.getAxisHeight();
        if (drawPlannedReviewCycle) {
            double underPlanned = totalHeight - actualHeight + plannedHeight;
            int subText = 10;
            if (axisHeight <= 20.0) {
                subText = 5;
            }
            double height = underPlanned - (totalHeight - actualHeight + 5.0);
            SvgHelper.addRectWithStrokeStrokeSizeAndFill(xsw, 0.0, totalHeight - actualHeight + 5.0, Double.valueOf(ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL), height, "grey", 1.0, "grey");
            SvgHelper.addRectWithStrokeStrokeSizeAndFill(xsw, (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL - 1.0, totalHeight - actualHeight + 5.0 + height - axisHeight, (double)(ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL - ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL) + 1.0, axisHeight, "grey", 1.0, "grey");
            double yText = underPlanned - (double)subText;
            String expectedLabel = resourceBundle.getString("reviewProtocolSvgExpectedLabel");
            SvgHelper.addTextWithFillFontFamilyWeightAndSize(xsw, (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL + 5.0, yText, expectedLabel, "white", "verdana", "bold", 12.0);
            height = totalHeight - (underPlanned + 10.0);
            SvgHelper.addRectWithStrokeStrokeSizeAndFill(xsw, 0.0, underPlanned + 10.0, Double.valueOf(ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL), height, "grey", 1.0, "grey");
            SvgHelper.addRectWithStrokeStrokeSizeAndFill(xsw, (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL - 1.0, totalHeight - axisHeight, (double)(ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL - ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL) + 1.0, axisHeight, "grey", 1.0, "grey");
            yText = totalHeight - (double)subText;
            String actualLabel = resourceBundle.getString("reviewProtocolSvgActualLabel");
            SvgHelper.addTextWithFillFontFamilyWeightAndSize(xsw, (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL + 5.0, yText, actualLabel, "white", "verdana", "bold", 12.0);
        } else {
            double height = totalHeight - (totalHeight - actualHeight + 5.0);
            SvgHelper.addRectWithStrokeStrokeSizeAndFill(xsw, 0.0, totalHeight - actualHeight + 5.0, Double.valueOf(ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL), height, "grey", 1.0, "grey");
            SvgHelper.addRectWithStrokeStrokeSizeAndFill(xsw, (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL - 1.0, totalHeight - axisHeight, (double)(ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL - ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL) + 1.0, axisHeight, "grey", 1.0, "grey");
            String actualLabel = resourceBundle.getString("reviewProtocolSvgActualLabel");
            SvgHelper.addTextWithFillFontFamilyWeightAndSize(xsw, (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL + 5.0, totalHeight - (axisHeight <= 20.0 ? 5.0 : 10.0), actualLabel, "white", "verdana", "bold", 12.0);
        }
    }

    private boolean isLastDocumentVersion(ReviewProtocolContext context, ReviewProtocolVersionJoin candidate) {
        ReviewProtocolVersionJoin lastVersionJoin = context.getLastDocumentVersionJoin();
        if (lastVersionJoin != null && lastVersionJoin.getDocumentVersionReactivatedDocumentVersionId() != null) {
            lastVersionJoin = context.getVersionJoinByDocumentVersion(lastVersionJoin.getDocumentVersionReactivatedDocumentVersionId());
        }
        return lastVersionJoin != null && candidate.getDocumentVersionId().longValue() == lastVersionJoin.getDocumentVersionId().longValue();
    }

    private boolean hasLastDocumentVersionCellResult(ReviewProtocolContext context, List<ReviewProtocolVersionJoin> cellResultJoinsSortedByUploaded) {
        if (cellResultJoinsSortedByUploaded.size() == 0) {
            return false;
        }
        ReviewProtocolVersionJoin lastCellResult = cellResultJoinsSortedByUploaded.get(cellResultJoinsSortedByUploaded.size() - 1);
        return this.isLastDocumentVersion(context, lastCellResult);
    }

    private boolean isCellResultInconsistent(ReviewProtocolVersionJoin cellResultJoin, List<ReviewProtocolVersionJoin> cellResultJoinsSortedByUploaded, int numberOfcellResultsToCheck) {
        boolean inconsistent = cellResultJoin.isReviewCycleCellResultFinished() == false && cellResultJoin.getReviewCycleCellResultPreviousReviewCycleCellId() == null && cellResultJoin.getReviewCycleCellResultNextReviewCycleCellId() == null && cellResultJoinsSortedByUploaded.size() > numberOfcellResultsToCheck;
        return inconsistent;
    }

    private boolean isEndOfReviewCycleReached(ReviewProtocolVersionJoin nodeResultJoin, ReviewProtocolContext context) {
        boolean isEndOfReviewCycle = ReviewProtocolSvgCalculator.isEndOfReviewCycle(nodeResultJoin, context);
        boolean isLastDocumentVersion = this.isLastDocumentVersion(context, nodeResultJoin);
        return isEndOfReviewCycle && isLastDocumentVersion;
    }

    private boolean skipNodeResultLoop(ReviewProtocolVersionJoin nodeResultJoin, ReviewProtocolContext context, boolean endOfReviewCycleReached) {
        Long emptyNodeResultOptionId = nodeResultJoin.getReviewCycleEmptyNodeResultOptionId();
        Long cellResultResultOptionId = nodeResultJoin.getReviewCycleCellResultReviewCycleResultOptionId();
        ReviewProtocolVersionJoin resultOptionJoin = cellResultResultOptionId != null ? context.getResultOptionJoin(cellResultResultOptionId) : null;
        Long nodeResultOptionId = nodeResultJoin.getReviewCycleNodeResultReviewCycleResultOptionId();
        return endOfReviewCycleReached && (cellResultResultOptionId == null || cellResultResultOptionId != null && resultOptionJoin.isReviewCycleResultOptionFinishCellFlag() == false) || nodeResultOptionId != null && nodeResultOptionId.longValue() == emptyNodeResultOptionId.longValue();
    }

    private boolean isEndOfReviewCycleInvalidated(ReviewProtocolVersionJoin nodeResultJoin, ReviewProtocolContext context) {
        boolean isEndOfReviewCycle = ReviewProtocolSvgCalculator.isEndOfReviewCycle(nodeResultJoin, context);
        Long nodeResultOptionId = nodeResultJoin.getReviewCycleNodeResultReviewCycleResultOptionId();
        Long documentInvalidationResultOptionId = nodeResultJoin.getReviewCycleDocumentInvalidationResultOptionId();
        Long documentVersionDeletedOptionId = nodeResultJoin.getReviewCycleDocumentVersionDeletedOptionId();
        Long documentVersionInvalidationResultOptionId = nodeResultJoin.getReviewCycleDocumentVersionInvalidationResultOptionId();
        return isEndOfReviewCycle && nodeResultOptionId != null && (documentVersionInvalidationResultOptionId != null && nodeResultOptionId.longValue() == documentVersionInvalidationResultOptionId.longValue() || documentInvalidationResultOptionId != null && nodeResultOptionId.longValue() == documentInvalidationResultOptionId.longValue() || documentVersionDeletedOptionId != null && nodeResultOptionId.longValue() == documentVersionDeletedOptionId.longValue());
    }

    private boolean isNodeResultInvalidatedAll(ReviewProtocolVersionJoin nodeResultJoin) {
        Long nodeResultOptionId = nodeResultJoin.getReviewCycleNodeResultReviewCycleResultOptionId();
        Long documentInvalidationResultOptionId = nodeResultJoin.getReviewCycleDocumentInvalidationResultOptionId();
        return nodeResultOptionId != null && documentInvalidationResultOptionId != null && nodeResultOptionId.longValue() == documentInvalidationResultOptionId.longValue();
    }

    private boolean isInvalidatedPositionResultOption(ReviewProtocolVersionJoin positionResultJoin) {
        Long positionResultOptionId = positionResultJoin.getReviewCyclePositionResultReviewCycleResultOptionId();
        Long documentInvalidationResultOptionId = positionResultJoin.getReviewCycleDocumentInvalidationResultOptionId();
        Long documentVersionDeletedOptionId = positionResultJoin.getReviewCycleDocumentVersionDeletedOptionId();
        Long documentVersionInvalidationResultOptionId = positionResultJoin.getReviewCycleDocumentVersionInvalidationResultOptionId();
        return positionResultOptionId != null && (documentVersionInvalidationResultOptionId != null && positionResultOptionId.longValue() == documentVersionInvalidationResultOptionId.longValue() || documentInvalidationResultOptionId != null && positionResultOptionId.longValue() == documentInvalidationResultOptionId.longValue() || documentVersionDeletedOptionId != null && positionResultOptionId.longValue() == documentVersionDeletedOptionId.longValue());
    }

    private static Double verifyDocumentDepartureDate(ReviewProtocolVersionJoin nodeResultJoin, List<ReviewProtocolVersionJoin> positionResultJoins) {
        Double departureObjectListReleaseTime = nodeResultJoin.getDepartureObjectListSignatureTime();
        Double nodeResultDepartureDate = nodeResultJoin.getReviewCycleNodeResultDepartureDate();
        Double lastPositionResultResultDate = null;
        if (positionResultJoins.size() > 0) {
            ReviewProtocolVersionJoin lastPositionResultJoin = positionResultJoins.get(positionResultJoins.size() - 1);
            lastPositionResultResultDate = lastPositionResultJoin.getReviewCyclePositionResultResultDate();
        }
        return ReviewProtocolSvgRenderer.verifyDocumentDepartureDate(departureObjectListReleaseTime, nodeResultDepartureDate, lastPositionResultResultDate);
    }

    public static Double verifyDocumentDepartureDate(DocumentListOtherVersionNodeResultInfo nodeResultInfo) {
        DocumentListOtherVersionPositionResultInfo lastPositionResultInfo = nodeResultInfo.getLastPositionResultInfo();
        Double departureObjectListReleaseTime = nodeResultInfo.getDepartureObjectListReleaseSignatureTime();
        Double nodeResultDepartureTime = nodeResultInfo.getNodeResultDepartureDate();
        Double lastPositionResultResultDate = lastPositionResultInfo != null ? lastPositionResultInfo.getPositionResultResultDate() : null;
        return ReviewProtocolSvgRenderer.verifyDocumentDepartureDate(departureObjectListReleaseTime, nodeResultDepartureTime, lastPositionResultResultDate);
    }

    private static Double verifyDocumentDepartureDate(Double departureObjectListReleaseTime, Double nodeResultDepartureDate, Double lastPositionResultResultDate) {
        if (nodeResultDepartureDate != null) {
            if (lastPositionResultResultDate != null && lastPositionResultResultDate < nodeResultDepartureDate && departureObjectListReleaseTime != null && lastPositionResultResultDate > departureObjectListReleaseTime) {
                return lastPositionResultResultDate;
            }
            return nodeResultDepartureDate;
        }
        return null;
    }

    private Double calculateNodeEnd(DelayInfo delayInfo, Double actualNodeEnd) {
        int nodesDelay = delayInfo.getNodesDelay();
        if (actualNodeEnd == null) {
            if (nodesDelay < 0) {
                return delayInfo.getContractualDeadline();
            }
            return DateHelper.getCurrentUtcSeconds();
        }
        if (nodesDelay < 0) {
            return delayInfo.getContractualDeadline();
        }
        return actualNodeEnd;
    }

    private int calculateDaysInNode(ReviewProtocolContext context, Double nodeStart, Double actualNodeEnd) {
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        if (actualNodeEnd == null) {
            Double now = DateHelper.getCurrentUtcSeconds();
            return holidayCalculator.getWorkingDaysBetween(nodeStart, now);
        }
        return holidayCalculator.getWorkingDaysBetween(nodeStart, actualNodeEnd);
    }

    private double calculateNodeStartX(Double nodeStart, boolean drawWeeks, Double axisStart, Double spacePerTimeUnit) {
        return nodeStart != null ? ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, nodeStart, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL : (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
    }

    private double calculateNodeEndX(ReviewProtocolContext context, ReviewProtocolGeometry geometry, boolean firstOpenNode, Double nodeStartX, Double nodeEnd, boolean drawWeeks, Double axisStart, Double actualNodeEnd, Double spacePerTimeUnit) {
        double nodeEndX;
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        double d = nodeEndX = nodeEnd != null ? ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, nodeEnd, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL : geometry.getAxisWidth();
        if (this.calculateNodeEndExtraCase(firstOpenNode, nodeEndX, nodeStartX, actualNodeEnd)) {
            nodeEndX = nodeEnd != null ? ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, holidayCalculator.addWorkingDays(nodeEnd, 1), spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL : geometry.getAxisWidth();
        }
        return nodeEndX;
    }

    private boolean calculateNodeEndExtraCase(boolean firstOpenNode, Double nodeEndX, Double nodeStartX, Double actualNodeEnd) {
        return firstOpenNode && actualNodeEnd == null;
    }

    private boolean isCellResultInvalidated(ReviewProtocolVersionJoin nodeResultJoin) {
        Long documentVersionDeletedOptionId = nodeResultJoin.getReviewCycleDocumentVersionDeletedOptionId();
        Long documentVersionInvalidationResultOptionId = nodeResultJoin.getReviewCycleDocumentVersionInvalidationResultOptionId();
        Long nodeResultOptionId = nodeResultJoin.getReviewCycleNodeResultReviewCycleResultOptionId();
        return nodeResultOptionId != null && (documentVersionInvalidationResultOptionId != null && documentVersionInvalidationResultOptionId.longValue() == nodeResultOptionId.longValue() || documentVersionDeletedOptionId != null && documentVersionDeletedOptionId.longValue() == nodeResultOptionId.longValue());
    }

    private List<ReviewProtocolVersionJoin> getReviewCycleCellInstancesReleasedDefault(ReviewProtocolContext context) {
        ArrayList<ReviewProtocolVersionJoin> result = new ArrayList<ReviewProtocolVersionJoin>();
        List<ReviewProtocolVersionJoin> cellInstanceReleasedJoins = context.getAllCellInstanceReleasedJoinsSortedByPosition();
        Iterator<ReviewProtocolVersionJoin> cellInstanceReleasedIterator = cellInstanceReleasedJoins.iterator();
        ReviewProtocolVersionJoin nextCellInstanceReleasedJoin = null;
        if (cellInstanceReleasedIterator != null && cellInstanceReleasedIterator.hasNext()) {
            nextCellInstanceReleasedJoin = cellInstanceReleasedIterator.next();
        }
        while (nextCellInstanceReleasedJoin != null) {
            result.add(nextCellInstanceReleasedJoin);
            Long nextCellId = nextCellInstanceReleasedJoin.getDestCellId();
            nextCellInstanceReleasedJoin = null;
            for (ReviewProtocolVersionJoin cellInstanceReleasedJoin : cellInstanceReleasedJoins) {
                Long candidateReviewCycleCellId = cellInstanceReleasedJoin.getReviewCycleCellInstanceReleasedReviewCycleCellId();
                if (nextCellId == null || candidateReviewCycleCellId.longValue() != nextCellId.longValue()) continue;
                nextCellInstanceReleasedJoin = cellInstanceReleasedJoin;
            }
        }
        return result;
    }

    private String getPositionTypeBoxName(ReviewProtocolContext context, ReviewProtocolVersionJoin positionResultJoin) {
        int resultOptionCount;
        Long resultOptionId = positionResultJoin.getReviewCyclePositionResultReviewCycleResultOptionId();
        Long documentInvalidationResultOptionId = positionResultJoin.getReviewCycleDocumentInvalidationResultOptionId();
        Long documentVersionInvalidationResultOptionId = positionResultJoin.getReviewCycleDocumentVersionInvalidationResultOptionId();
        Long documentVersionDeletedOptionId = positionResultJoin.getReviewCycleDocumentVersionDeletedOptionId();
        if (documentInvalidationResultOptionId != null && resultOptionId.longValue() == documentInvalidationResultOptionId.longValue()) {
            return "#cancelBox";
        }
        if (documentVersionInvalidationResultOptionId != null && resultOptionId.longValue() == documentVersionInvalidationResultOptionId.longValue()) {
            return "#xBox";
        }
        if (documentVersionDeletedOptionId != null && resultOptionId.longValue() == documentVersionDeletedOptionId.longValue()) {
            return "#deletedBox";
        }
        ReviewProtocolVersionJoin resultOptionJoin = context.getResultOptionJoin(resultOptionId);
        Long positionTypeId = resultOptionJoin.getReviewCycleResultOptionReviewCyclePositionTypeId();
        int n = resultOptionCount = positionTypeId != null ? context.getNumberOfPositionTypeResultOptions(positionTypeId) : 0;
        if (resultOptionCount == 0) {
            if (resultOptionJoin.isReviewCycleResultOptionFinishCellFlag().booleanValue()) {
                return "#negBox";
            }
            return "#posBox";
        }
        if (resultOptionCount == 1) {
            return "#okBox";
        }
        Integer resultOptionValue = resultOptionJoin.getReviewCycleResultOptionValue();
        boolean isSampleControlReview = resultOptionJoin.isReviewCycleResultOptionSampleControlReview();
        if (resultOptionValue != null && resultOptionValue == 1 || isSampleControlReview) {
            return "#posBox";
        }
        return "#negBox";
    }

    private void addEntryResultPersonBoxLabel(ReviewProtocolVersionJoin versionJoin, ReviewProtocolGeometry geometry, int yPositionOfCell, double xNodeStart, List<SeparateBoxLabel> boxLabels) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String pattern = resourceBundle.getString("reviewProtocolYearToDayBracketFormat");
        double yBasic = geometry.getYBasic();
        SeparateBoxLabel boxLabel = new SeparateBoxLabel();
        boxLabel.drawCircle = true;
        boxLabel.UrxNode = -1.0;
        boxLabel.LlyNode = yBasic - (double)yPositionOfCell;
        String name = versionJoin.getEntryResultPersonSurName();
        Double resultDate = versionJoin.getReviewCycleEntryResultResultDate();
        String formattedResultDate = resultDate != null ? DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", pattern) : "";
        boxLabel.text = name != null ? name + " " + formattedResultDate : "";
        boxLabel.boxName = "#firstUploadBox";
        boxLabel.xPositionOfBox = xNodeStart;
        boxLabel.yPositionOfBox = yBasic - (double)(yPositionOfCell - 10);
        boxLabels.add(boxLabel);
    }

    private void addConnectionResultPersonBoxLabel(ReviewProtocolVersionJoin versionJoin, ReviewProtocolGeometry geometry, int yPositionOfCell, List<SeparateBoxLabel> separateBoxLabels) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String pattern = resourceBundle.getString("reviewProtocolYearToDayBracketFormat");
        double yBasic = geometry.getYBasic();
        boolean drawWeeks = geometry.isDoDrawWeeks();
        double axisStart = geometry.getAxisStart();
        double spacePerTimeUnit = geometry.getSpacePerTimeUnit();
        SeparateBoxLabel boxLabel = new SeparateBoxLabel();
        boxLabel.UrxNode = -1.0;
        boxLabel.drawCircle = true;
        boxLabel.LlyNode = yBasic - (double)yPositionOfCell + 20.0;
        String name = versionJoin.getConnectionResultPersonSurName();
        Double resultDate = versionJoin.getDestVersionCellConnectionResultResultDate();
        String formattedResultDate = resultDate != null ? DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", pattern) : "";
        boxLabel.text = name != null ? name + " " + formattedResultDate : "";
        boxLabel.boxName = "#uploadBox";
        boxLabel.xPositionOfBox = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, resultDate, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
        boxLabel.yPositionOfBox = yBasic - (double)(yPositionOfCell - 10 + 20);
        separateBoxLabels.add(boxLabel);
    }

    private void addPositionResultPersonBoxLabel(ReviewProtocolContext context, ReviewProtocolGeometry geometry, ReviewProtocolVersionJoin positionResultJoin, double xNodeStart, double xPosition, int yPositionOfCell, List<SeparateBoxLabel> separateBoxLabels) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String pattern = resourceBundle.getString("reviewProtocolYearToDayBracketFormat");
        String positionTypeBoxName = this.getPositionTypeBoxName(context, positionResultJoin);
        double yBasic = geometry.getYBasic();
        SeparateBoxLabel boxLabel = new SeparateBoxLabel();
        boxLabel.drawCircle = true;
        boxLabel.UrxNode = xNodeStart;
        boxLabel.LlyNode = yBasic - (double)yPositionOfCell;
        String surName = positionResultJoin.getPositionPersonSurName();
        Double resultDate = positionResultJoin.getReviewCyclePositionResultResultDate();
        String resultDateString = resultDate != null ? DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", pattern) : "";
        boxLabel.text = (surName != null ? surName : "") + " " + (resultDateString != null ? resultDateString : "");
        boxLabel.boxName = positionTypeBoxName;
        boxLabel.xPositionOfBox = xPosition;
        boxLabel.yPositionOfBox = yBasic - (double)(yPositionOfCell - 10);
        separateBoxLabels.add(boxLabel);
    }

    private void addPositionResultBoxLabels(ReviewProtocolContext context, List<ReviewProtocolVersionJoin> positionResultJoins, ReviewProtocolGeometry geometry, boolean drawWeeks, Double axisStart, Double nodeEndX, Double positionOfCellY, Double spacePerTimeUnit, List<SeparateBoxLabel> separateBoxLabels) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String pattern = resourceBundle.getString("reviewProtocolYearToDayBracketFormat");
        double yBasic = geometry.getYBasic();
        for (ReviewProtocolVersionJoin positionResultJoin : positionResultJoins) {
            Double positionResultDate = positionResultJoin.getReviewCyclePositionResultResultDate();
            double positionX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, positionResultDate, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
            if (positionResultJoin.getReviewCyclePositionResultReviewCycleResultOptionId() == null || positionResultJoin.getReviewCyclePositionResultSignatureId() == null) continue;
            String labelType = this.getPositionTypeBoxName(context, positionResultJoin);
            SeparateBoxLabel boxLabel = new SeparateBoxLabel();
            boxLabel.drawCircle = true;
            boxLabel.UrxNode = nodeEndX;
            boxLabel.LlyNode = yBasic - positionOfCellY;
            String personSurName = positionResultJoin.getPositionPersonSurName();
            Double resultDate = positionResultJoin.getReviewCyclePositionResultResultDate();
            String resultDateString = resultDate != null ? DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", pattern) : "";
            boxLabel.text = personSurName + " " + resultDateString;
            boxLabel.boxName = labelType;
            boxLabel.xPositionOfBox = positionX;
            boxLabel.yPositionOfBox = yBasic - (positionOfCellY - 10.0);
            separateBoxLabels.add(boxLabel);
        }
        if (positionResultJoins.size() <= 0) {
            SeparateBoxLabel boxLabel = new SeparateBoxLabel();
            boxLabel.UrxNode = nodeEndX;
            boxLabel.LlyNode = yBasic - positionOfCellY;
            boxLabel.text = null;
            separateBoxLabels.add(boxLabel);
        }
    }

    private Double addPlannedNodeInstanceReleasedBoxLabel(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry, ReviewProtocolVersionJoin nodeInstanceReleasedJoin, boolean firstNode, Double nodeStartX, Double yValue, List<SeparateBoxLabel> boxLabels) throws Exception {
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        int addDelta = 0;
        Integer duration = nodeInstanceReleasedJoin.getReviewCycleNodeInstanceReleasedDuration();
        if (firstNode && duration > 0) {
            addDelta = 1;
            firstNode = false;
        }
        Double plannedStart = holidayCalculator.addWorkingDays(geometry.getPlannedStart(), duration + addDelta);
        geometry.setPlannedStart(plannedStart);
        boolean drawWeeks = geometry.isDoDrawWeeks();
        boolean calculateNewAxis = geometry.isCalculateNewAxis();
        double yBasic = geometry.getYBasic();
        Double axisStart = geometry.getAxisStart();
        Double axisStartTwo = geometry.getAxisStartTwo();
        double spacePerTimeUnit = geometry.getSpacePerTimeUnit();
        double nodeEndX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, calculateNewAxis ? axisStartTwo : axisStart, plannedStart, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
        String color = nodeInstanceReleasedJoin.getReviewCycleCellSvgColor();
        double cellSize = this.drawCycleNode(xsw, nodeStartX, nodeEndX, yValue, yBasic - yValue, color, nodeInstanceReleasedJoin);
        firstNode = false;
        if (cellSize > 10.0) {
            SvgHelper.addTextWithFontFamilyAndSize(xsw, nodeStartX + 5.0, yValue + 10.0, String.valueOf(duration), "verdana", 8.0);
        }
        SeparateBoxLabel boxLabel = new SeparateBoxLabel();
        boxLabel.text = I18nHelper.getLocaleString(nodeInstanceReleasedJoin.getReviewCycleNodeName(), this.personVariablesUserLocale);
        boxLabel.boxName = "#arrow";
        boxLabel.xPositionOfBox = nodeStartX;
        boxLabel.yPositionOfBox = yValue;
        boxLabel.drawCircle = false;
        boxLabels.add(boxLabel);
        return nodeEndX;
    }

    private void drawSeparateInvalidationLineIfNecessary(XMLStreamWriter xsw, ReviewProtocolGeometry geometry, Double nodeInvalidatedStartX, Double nodeStartX, int yPositionOfCell) throws Exception {
        Double yBasic = geometry.getYBasic();
        if (nodeInvalidatedStartX != -1.0 && nodeInvalidatedStartX < nodeStartX) {
            SvgHelper.addLineWithStroke(xsw, nodeInvalidatedStartX, yBasic - (double)yPositionOfCell, nodeInvalidatedStartX, yBasic - (double)yPositionOfCell + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), "black", 1.0);
            SvgHelper.addLineWithStroke(xsw, nodeInvalidatedStartX, yBasic - (double)yPositionOfCell + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), nodeStartX, yBasic - (double)yPositionOfCell + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), "black", 1.0);
        }
    }

    public static double drawNode(XMLStreamWriter xsw, double startNodeX, double endNodeX, double posCenter, double height, String fill, String opacity, boolean dashed, int duration, int typeOfEdge) throws Exception {
        if (endNodeX - startNodeX < 2.0) {
            SvgHelper.addRectWithStrokeAndFill(xsw, startNodeX - 5.0, posCenter - height / 2.0, 10.0, 20.0, "none", "white");
            SvgHelper.addRectWithStrokeFillAndOpacity(xsw, startNodeX - 5.0, posCenter - height / 2.0, 10.0, 20.0, "none", fill, opacity != null ? opacity : ".4");
            SvgHelper.addLineWithStroke(xsw, startNodeX, posCenter - height / 2.0, startNodeX, posCenter - height / 2.0 + 20.0, "black", 1.0);
        } else if (typeOfEdge == SvgCorner.NOCORNER.getValue()) {
            SvgHelper.addRectWithRxyStrokeFillAndOpacity(xsw, startNodeX, posCenter - height / 2.0, 0.0, 0.0, endNodeX - startNodeX, height, "black", fill, opacity != null ? opacity : "1.0");
        } else if (typeOfEdge == SvgCorner.CORNER_LINEAR_LEFT.getValue()) {
            SvgHelper.addRectWithEdgesStrokeFillAndOpacity(xsw, startNodeX, posCenter - height / 2.0, -height / 4.0, height / 2.0, 0.0, 0.0, endNodeX - startNodeX, height, false, false, "black", fill, opacity != null ? opacity : "1.0");
        } else if (typeOfEdge == SvgCorner.CORNER_LINEAR_RIGHT.getValue()) {
            SvgHelper.addRectWithEdgesStrokeFillAndOpacity(xsw, startNodeX, posCenter - height / 2.0, 0.0, 0.0, height / 4.0, height / 2.0, endNodeX - startNodeX, height, false, false, "black", fill, opacity != null ? opacity : "1.0");
        } else if (typeOfEdge == SvgCorner.CORNER_LINEAR_BOTH.getValue()) {
            SvgHelper.addRectWithEdgesStrokeFillAndOpacity(xsw, startNodeX, posCenter - height / 2.0, -height / 4.0, height / 2.0, height / 4.0, height / 2.0, endNodeX - startNodeX, height, false, false, "black", fill, opacity != null ? opacity : "1.0");
        } else if (typeOfEdge == SvgCorner.CORNER_LINEAR_BOTH_INV.getValue()) {
            SvgHelper.addRectWithEdgesStrokeFillAndOpacity(xsw, startNodeX, posCenter - height / 2.0, -height / 4.0, height / 2.0, -height / 4.0, height / 2.0, endNodeX - startNodeX, height, false, false, "black", fill, opacity != null ? opacity : "1.0");
        }
        SvgHelper.addTextWithFontFamilyAndSize(xsw, startNodeX + 5.0, posCenter, Integer.toString(duration), "verdana", 8.0);
        return endNodeX;
    }

    private double drawCycleNode(XMLStreamWriter xsw, double nodeStartX, double nodeEndX, double nodeY, double height, String color, ReviewProtocolVersionJoin nodeInstanceReleasedJoin) throws Exception {
        double width = 0.0;
        if (nodeEndX - nodeStartX < 2.0) {
            SvgHelper.addRectWithStrokeAndFill(xsw, nodeStartX - 5.0, nodeY, 10.0, 20.0, "none", "white");
            SvgHelper.addRectWithStrokeFillAndOpacity(xsw, nodeStartX - 5.0, nodeY, 10.0, 20.0, "none", color, ".4");
            SvgHelper.addLineWithStroke(xsw, nodeStartX, nodeY, nodeStartX, nodeY + 20.0, "black", 1.0);
        } else {
            width = nodeEndX - nodeStartX;
            int position = nodeInstanceReleasedJoin.getReviewCycleNodePosition();
            int styleOfEdges = position == 1 ? 1 : 0;
            this.switchNodeStyle(xsw, styleOfEdges += nodeInstanceReleasedJoin.getEndNodeId() != null ? 2 : 0, nodeStartX, nodeY, width, "black", 0.5, color);
        }
        return width;
    }

    private void drawEndOfCycleNode(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry, ReviewProtocolVersionJoin nodeInstanceReleasedJoin, Double nodeStartX, Double yValue) throws Exception {
        ReviewProtocolBaseJoin baseJoin = context.getBaseJoin();
        int preduration = baseJoin.getReviewCycleInstanceReleasedDurationPre();
        if (preduration > 0 && this.reversePreduration != null && this.reversePreduration.booleanValue() && nodeInstanceReleasedJoin.getEndNodeId() != null) {
            HolidayCalculator holidayCalculator = context.getHolidayCalculator();
            Double plannedStart = geometry.getPlannedStart();
            Double predurationStart = holidayCalculator.addWorkingDays(plannedStart, preduration);
            boolean drawWeeks = geometry.isDoDrawWeeks();
            Double startDate = this.getPlannedAxisStartDate(geometry);
            double spacePerTimeUnit = geometry.getSpacePerTimeUnit();
            double predurationEndX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, startDate, predurationStart, spacePerTimeUnit);
            ReviewProtocolSvgRenderer.drawNode(xsw, nodeStartX, predurationEndX, yValue + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), (double)ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2.0, "#ffffff", null, true, preduration, SvgCorner.CORNER_LINEAR_BOTH.getValue());
        }
    }

    private Double getPlannedAxisStartDate(ReviewProtocolGeometry geometry) {
        boolean calculateNewAxis = geometry.isCalculateNewAxis();
        Double axisStart = geometry.getAxisStart();
        Double axisStartTwo = geometry.getAxisStartTwo();
        Double startDate = calculateNewAxis ? axisStartTwo : axisStart;
        return startDate;
    }

    private void drawPlannedStartDate(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry, Double endX, Double yValue) throws Exception {
        double spacePerTimeUnit;
        Double axisStartDate;
        boolean drawWeeks;
        double sx;
        Double startDate;
        ReviewProtocolBaseJoin baseJoin = context.getBaseJoin();
        if (baseJoin.getDocumentReleaseId() != null && (startDate = baseJoin.getDocumentReleaseStartDate()) != null && ((sx = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks = geometry.isDoDrawWeeks(), axisStartDate = this.getPlannedAxisStartDate(geometry), startDate, spacePerTimeUnit = geometry.getSpacePerTimeUnit()) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL) < endX - 5.0 || sx > endX + 5.0)) {
            SvgHelper.addRectWithEdgesFillAndOpacity(xsw, sx, yValue + 21.0, -spacePerTimeUnit / 7.0, 9.0, 0.0, 0.0, spacePerTimeUnit / 7.0, 18.0, false, false, "#000000", ".5");
            ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
            String pattern = resourceBundle.getString("reviewProtocolYearToDayFormat");
            String startDateString = DateHelper.formatUtcSeconds(startDate, "Europe/Vienna", pattern);
            String startLabel = resourceBundle.getString("reviewProtocolSvgStartLabel");
            SvgHelper.addTextWithFontFamilyAndSize(xsw, sx - 40.0, yValue + 29.0, startDateString, "verdana", 8.0);
            SvgHelper.addTextWithFontFamilyAndSize(xsw, sx - 23.0, yValue + 37.0, startLabel, "verdana", 8.0);
        }
    }

    private Double drawPlannedEndDate(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry, double yValue) throws Exception {
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        int delta = 0;
        Double plannedEnd = geometry.getPlannedEnd();
        Calendar plannedEndCalendar = ReviewProtocolSvgCalculator.getAsCalendar(plannedEnd);
        if (holidayCalculator.isHolidayOrWeekend(plannedEndCalendar)) {
            ++delta;
        }
        boolean drawWeeks = geometry.isDoDrawWeeks();
        Double startDate = this.getPlannedAxisStartDate(geometry);
        Double actualDate = holidayCalculator.addWorkingDays(plannedEnd, delta);
        double spacePerTimeUnit = geometry.getSpacePerTimeUnit();
        double x = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, startDate, actualDate, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
        SvgHelper.addRectWithEdgesFillAndOpacity(xsw, x, yValue + 21.0, 0.0, 0.0, -spacePerTimeUnit / 7.0, 9.0, spacePerTimeUnit / 7.0, 18.0, false, false, "#000000", ".5;");
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String pattern = resourceBundle.getString("reviewProtocolYearToDayFormat");
        String plannedEndString = plannedEnd != null ? DateHelper.formatUtcSeconds(plannedEnd, "Europe/Vienna", pattern) : "";
        String endLabel = resourceBundle.getString("reviewProtocolSvgEndLabel");
        SvgHelper.addTextWithFontFamilyAndSize(xsw, x - 40.0, yValue + 29.0, plannedEndString, "verdana", 8.0);
        SvgHelper.addTextWithFontFamilyAndSize(xsw, x - 23.0, yValue + 37.0, endLabel, "verdana", 8.0);
        return x;
    }

    private void drawPlannedStatusBar(XMLStreamWriter xsw, ReviewProtocolGeometry geometry, Double plannedNodeStartX) throws Exception {
        double yBasic = geometry.getYBasic();
        double axisWidth = geometry.getAxisWidth();
        SvgHelper.addRectWithStrokeFillAndOpacity(xsw, Double.valueOf(ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL), yBasic - (double)ReviewProtocolSvgCalculator.SIZE_OF_VERSION_LABEL, plannedNodeStartX - (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL, 20.0, "none", "grey", ".1");
        SvgHelper.addLineWithStroke(xsw, Double.valueOf(ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL), yBasic - (double)ReviewProtocolSvgCalculator.SIZE_OF_VERSION_LABEL, axisWidth + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL, yBasic - (double)ReviewProtocolSvgCalculator.SIZE_OF_VERSION_LABEL, "black", 1.0);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String statusLabel = resourceBundle.getString("reviewProtocolSvgStatusLabel");
        SvgHelper.addTextWithFontFamilyAndSize(xsw, ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL + 5, yBasic - (double)ReviewProtocolSvgCalculator.SIZE_OF_VERSION_LABEL + 15.0, statusLabel, "verdana", 10.0);
    }

    private void switchNodeStyle(XMLStreamWriter xsw, int styleOfEdges, double x, double y, double width, String stroke, double strokeSize, String fill) throws Exception {
        double HEIGHT_OF_NODE = ReviewProtocolSvgCalculator.HEIGHT_OF_NODE;
        switch (styleOfEdges) {
            case 0: {
                SvgHelper.addRectWithStrokeStrokeSizeAndFill(xsw, x, y, width, HEIGHT_OF_NODE, stroke, strokeSize, fill);
                break;
            }
            case 1: {
                SvgHelper.addRectWithEdgesStrokeStrokeSizeAndFill(xsw, x, y, -HEIGHT_OF_NODE / 4.0, HEIGHT_OF_NODE / 2.0, 0.0, 0.0, width, HEIGHT_OF_NODE, false, true, stroke, strokeSize, fill);
                break;
            }
            case 2: {
                SvgHelper.addRectWithEdgesStrokeStrokeSizeAndFill(xsw, x, y, 0.0, 0.0, HEIGHT_OF_NODE / 4.0, HEIGHT_OF_NODE / 2.0, width, HEIGHT_OF_NODE, true, false, stroke, strokeSize, fill);
                break;
            }
            case 3: {
                SvgHelper.addRectWithEdgesStrokeStrokeSizeAndFill(xsw, x, y, -HEIGHT_OF_NODE / 4.0, HEIGHT_OF_NODE / 2.0, HEIGHT_OF_NODE / 4.0, HEIGHT_OF_NODE / 2.0, width, HEIGHT_OF_NODE, false, false, stroke, strokeSize, fill);
            }
        }
    }

    private void drawPredurationNode(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolGeometry geometry, Double nodeStartX, Double yValue) throws Exception {
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        ReviewProtocolBaseJoin baseJoin = context.getBaseJoin();
        int preduration = baseJoin.getReviewCycleInstanceReleasedDurationPre();
        Double plannedStart = geometry.getPlannedStart();
        boolean drawWeeks = geometry.isDoDrawWeeks();
        boolean calculateNewAxis = geometry.isCalculateNewAxis();
        Double axisStart = calculateNewAxis ? geometry.getAxisStartTwo() : geometry.getAxisStart();
        double spacePerTimeUnit = geometry.getSpacePerTimeUnit();
        Double predurationStart = holidayCalculator.addWorkingDays(plannedStart, -preduration);
        double predurationStartX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, predurationStart, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
        double predurationEndX = nodeStartX;
        ReviewProtocolSvgRenderer.drawNode(xsw, predurationStartX, predurationEndX, yValue + (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2, "#ffff00", null, false, preduration, SvgCorner.CORNER_LINEAR_BOTH.getValue());
    }

    private Double drawRemainingCells(XMLStreamWriter xsw, ReviewProtocolContext context, ReviewProtocolVersionJoin lastNodeResultJoin, ReviewProtocolGeometry geometry, boolean drawWeeks, Double axisStart, Double spacePerTimeUnit, Double lastNodeEndX, boolean lastCellResultIsInvalidated) throws Exception {
        Double nodeEndX;
        TextWithPosition versionString;
        int typeOfEdges;
        int nodeDelay;
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        Double plannedNodeEnd = holidayCalculator.addWorkingDays(DateHelper.getCurrentUtcSeconds(), 1);
        double nodeStartX = lastNodeEndX;
        String cellColor = null;
        if (lastNodeResultJoin != null) {
            cellColor = lastNodeResultJoin.getNodeResultCellSvgColor();
            if (lastCellResultIsInvalidated) {
                Long lastNodeResultId = lastNodeResultJoin.getReviewCycleNodeResultId();
                List<ReviewProtocolVersionJoin> unfilteredLastNodeResultPositionJoins = context.getPositionResultJoinsSortedByResultDate(lastNodeResultId);
                ArrayList<ReviewProtocolVersionJoin> lastNodeResultPositionJoins = new ArrayList<ReviewProtocolVersionJoin>();
                for (ReviewProtocolVersionJoin positionResultJoin : unfilteredLastNodeResultPositionJoins) {
                    if (positionResultJoin.getReviewCyclePositionResultCommentReferenceId() != null) continue;
                    lastNodeResultPositionJoins.add(positionResultJoin);
                }
                Double actualNodeEnd = ReviewProtocolSvgRenderer.verifyDocumentDepartureDate(lastNodeResultJoin, lastNodeResultPositionJoins);
                int duration = lastNodeResultJoin.getReviewCycleNodeInstanceReleasedDuration();
                Double contractualDeadline = holidayCalculator.addWorkingDays(actualNodeEnd, duration);
                nodeDelay = holidayCalculator.getWorkingDaysBetween(DateHelper.getCurrentUtcSeconds(), contractualDeadline);
            } else {
                DelayInfo delayInfo = ReviewProtocolSvgRenderer.calculateDelayOfActualNode(context, lastNodeResultJoin, null);
                nodeDelay = delayInfo.getNodesDelay();
            }
            typeOfEdges = lastNodeResultJoin.getEndNodeId() != null ? 1 : 0;
        } else {
            nodeDelay = 0;
            typeOfEdges = 0;
        }
        double yBasic = geometry.getYBasic();
        if (lastNodeResultJoin != null && !lastNodeResultJoin.isReviewCycleNodeFree().booleanValue()) {
            versionString = new TextWithPosition();
            versionString.text = "";
            versionString.xStartOfCell = nodeStartX;
            versionString.color = cellColor;
            if (nodeDelay >= 0) {
                plannedNodeEnd = holidayCalculator.addWorkingDays(plannedNodeEnd, nodeDelay);
                nodeEndX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, plannedNodeEnd, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                nodeStartX = ReviewProtocolSvgRenderer.drawNode(xsw, nodeStartX, nodeEndX, yBasic - (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), ReviewProtocolSvgCalculator.HEIGHT_OF_NODE, cellColor, "0.7", true, nodeDelay, typeOfEdges);
            }
            versionString.xEndOfCell = nodeStartX;
            this.cellsVersionString.add(versionString);
        }
        if (lastNodeResultJoin != null && lastNodeResultJoin.getReviewCycleCellInstanceReleasedId() != null) {
            versionString = new TextWithPosition();
            versionString.text = "";
            versionString.xStartOfCell = nodeStartX;
            versionString.color = cellColor;
            Long reviewCycleCellInstanceReleasedId = lastNodeResultJoin.getReviewCycleCellInstanceReleasedId();
            List<ReviewProtocolVersionJoin> nodeInstanceReleaseJoins = context.getNodeInstanceReleasedJoinsSortedByPosition(reviewCycleCellInstanceReleasedId);
            for (int i = lastNodeResultJoin.getReviewCycleNodePosition().intValue(); i < nodeInstanceReleaseJoins.size(); ++i) {
                ReviewProtocolVersionJoin nodeInstanceReleaseJoin = nodeInstanceReleaseJoins.get(i);
                Long positionTypeId = nodeInstanceReleaseJoin.getReviewCycleNodeReviewCyclePositionTypeId();
                if (nodeInstanceReleaseJoin.getNonEmptyNodeInstanceReleasedId() == null && (nodeInstanceReleaseJoin.isReviewCycleCellIsEndCell().booleanValue() || !context.isEndPositionType(positionTypeId))) continue;
                plannedNodeEnd = holidayCalculator.addWorkingDays(plannedNodeEnd, nodeInstanceReleaseJoin.getReviewCycleNodeInstanceReleasedDuration());
                typeOfEdges = nodeInstanceReleaseJoin.getEndNodeId() != null ? 1 : 0;
                nodeEndX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, plannedNodeEnd, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                Integer duration = nodeInstanceReleaseJoin.getReviewCycleNodeInstanceReleasedDuration();
                nodeStartX = ReviewProtocolSvgRenderer.drawNode(xsw, nodeStartX, nodeEndX, yBasic - (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), ReviewProtocolSvgCalculator.HEIGHT_OF_NODE, cellColor, "0.3", true, duration, typeOfEdges);
            }
            versionString.xEndOfCell = nodeStartX;
            this.cellsVersionString.add(versionString);
        }
        List<ReviewProtocolVersionJoin> remainingCellJoins = this.getReviewCycleCellInstancesReleasedDefault(context);
        boolean start = false;
        for (ReviewProtocolVersionJoin remainingCellJoin : remainingCellJoins) {
            TextWithPosition versionString2 = new TextWithPosition();
            if (start) {
                cellColor = remainingCellJoin.getReviewCycleCellSvgColor();
                versionString2.text = remainingCellJoin.getReviewCycleCell().getCode();
                versionString2.xStartOfCell = nodeStartX;
                versionString2.color = cellColor;
                Long reviewCycleCellInstanceReleasedId = remainingCellJoin.getReviewCycleCellInstanceReleasedId();
                List<ReviewProtocolVersionJoin> nodeInstanceReleasedJoins = context.getNodeInstanceReleasedJoinsSortedByPosition(reviewCycleCellInstanceReleasedId);
                for (ReviewProtocolVersionJoin nodeInstanceReleasedJoin : nodeInstanceReleasedJoins) {
                    if (nodeInstanceReleasedJoin.isReviewCycleNodeFree().booleanValue()) continue;
                    Long positionTypeId = nodeInstanceReleasedJoin.getReviewCycleNodeReviewCyclePositionTypeId();
                    if (nodeInstanceReleasedJoin.getNonEmptyNodeInstanceReleasedId() == null && (nodeInstanceReleasedJoin.isReviewCycleCellIsEndCell().booleanValue() || !context.isEndPositionType(positionTypeId))) continue;
                    int duration = nodeInstanceReleasedJoin.getReviewCycleNodeInstanceReleasedDuration();
                    plannedNodeEnd = holidayCalculator.addWorkingDays(plannedNodeEnd, duration);
                    typeOfEdges = ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodeInstanceReleasedJoin, false);
                    nodeEndX = ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, axisStart, plannedNodeEnd, spacePerTimeUnit) + (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL;
                    nodeStartX = ReviewProtocolSvgRenderer.drawNode(xsw, nodeStartX, nodeEndX, yBasic - (double)(ReviewProtocolSvgCalculator.HEIGHT_OF_NODE / 2), ReviewProtocolSvgCalculator.HEIGHT_OF_NODE, cellColor, "0.3", true, duration, typeOfEdges);
                }
                versionString2.xEndOfCell = nodeStartX;
                this.cellsVersionString.add(versionString2);
            }
            if (remainingCellJoin.getReviewCycleCellInstanceReleasedId() == null || lastNodeResultJoin == null || lastNodeResultJoin.getReviewCycleCellInstanceReleasedId() == null || remainingCellJoin.getReviewCycleCellInstanceReleasedId().longValue() != lastNodeResultJoin.getReviewCycleCellInstanceReleasedId().longValue()) continue;
            start = true;
        }
        return plannedNodeEnd;
    }

    public static DelayInfo calculateDelayOfActualNode(ReviewProtocolContext context, ReviewProtocolVersionJoin nodeResultJoin, Double startDate) {
        Integer reviewCycleNodeInstanceReleasedDuration = nodeResultJoin.getReviewCycleNodeResultDepartureObjectListId() != null ? nodeResultJoin.getDepartureReviewCycleNodeInstanceReleasedDuration() : nodeResultJoin.getReviewCycleNodeInstanceReleasedDuration();
        Double nodeResultArrivalDate = nodeResultJoin.getReviewCycleNodeResultArrivalDate();
        Double nodeResultDepartureDate = nodeResultJoin.getReviewCycleNodeResultDepartureDate();
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        return ReviewProtocolSvgRenderer.calculateDelayOfActualNode(reviewCycleNodeInstanceReleasedDuration, nodeResultArrivalDate, nodeResultDepartureDate, startDate, holidayCalculator);
    }

    public static DelayInfo calculateDelayOfActualNode(HolidayCalculator holidayCalculator, DocumentListOtherVersionNodeResultInfo nodeResultInfo, Double startDate) {
        Long allNodeDepartureSignatureId = nodeResultInfo.getDepartureObjectListReleaseSignatureId();
        Integer allNodeDepartureNodeInstanceDuration = nodeResultInfo.getDepartureNodeInstanceReleasedDuration();
        Integer nodeInstanceDuration = nodeResultInfo.getNodeInstanceReleasedDuration();
        Integer duration = allNodeDepartureSignatureId != null ? allNodeDepartureNodeInstanceDuration : nodeInstanceDuration;
        Double nodeResultArrivalDate = nodeResultInfo.getNodeResultArrivalDate();
        Double nodeResultDepartureDate = nodeResultInfo.getNodeResultDepartureDate();
        return ReviewProtocolSvgRenderer.calculateDelayOfActualNode(duration, nodeResultArrivalDate, nodeResultDepartureDate, startDate, holidayCalculator);
    }

    public static DelayInfo calculateDelayOfActualNode(Integer reviewCycleNodeInstanceReleasedDuration, Double nodeResultArrivalDate, Double nodeResultDepartureDate, Double startDate, HolidayCalculator holidayCalculator) {
        Integer nodesDelay;
        if (startDate == null) {
            startDate = nodeResultArrivalDate;
        }
        Double endDate = nodeResultDepartureDate;
        Double contractualDeadline = holidayCalculator.addWorkingDays(startDate, reviewCycleNodeInstanceReleasedDuration);
        if (endDate == null) {
            Double now = DateHelper.getCurrentUtcSeconds();
            nodesDelay = holidayCalculator.getWorkingDaysBetween(now, contractualDeadline);
        } else {
            nodesDelay = holidayCalculator.getWorkingDaysBetween(endDate, contractualDeadline);
        }
        return new DelayInfo(contractualDeadline, nodesDelay, reviewCycleNodeInstanceReleasedDuration);
    }

    private TextWithPosition initializeVersionString(ReviewProtocolVersionJoin versionJoin, double xNodeStart, String color) {
        String versionPartA = versionJoin.getDocumentVersionVersionParta();
        String versionPartSeparator = versionJoin.getDocumentVersionVersionPartSeperator();
        String versionPartB = versionJoin.getDocumentVersionVersionPartb();
        String versionPart = (versionPartA != null ? versionPartA : "") + (versionPartSeparator != null ? versionPartSeparator : "") + (versionPartB != null ? versionPartB : "");
        TextWithPosition versionString = new TextWithPosition();
        versionString.text = versionPart;
        versionString.xStartOfCell = xNodeStart;
        versionString.color = color;
        return versionString;
    }

    private TextWithPosition initializeCellReleaseVersionString(ReviewProtocolVersionJoin cellInstanceReleasedJoin, double nodeStartX) {
        String color = cellInstanceReleasedJoin.getReviewCycleCellSvgColor();
        String code = cellInstanceReleasedJoin.getReviewCycleCellCode();
        String name = cellInstanceReleasedJoin.getReviewCycleCellName();
        TextWithPosition versionString = new TextWithPosition();
        versionString.text = code != null ? code : name;
        versionString.xStartOfCell = nodeStartX;
        versionString.color = color;
        return versionString;
    }

    private int drawNodeStatusText(XMLStreamWriter xsw, ReviewProtocolGeometry geometry, ReviewProtocolVersionJoin nodeResultJoin, DelayInfo delayInfo, int daysInNode, int nodeLabel, double startCycleX, double yPositionOfCell, double nodeStartX) throws Exception {
        double size;
        double yBasic = geometry.getYBasic();
        if (nodeLabel % 2 == 0) {
            SvgHelper.addRectWithStrokeFillAndOpacity(xsw, startCycleX, yBasic - yPositionOfCell, nodeStartX - startCycleX, 20.0, "none", "white", ".3");
        } else {
            SvgHelper.addRectWithStrokeFillAndOpacity(xsw, Double.valueOf(ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL), yBasic - yPositionOfCell, startCycleX - (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL, 20.0, "none", "grey", ".1");
        }
        String nodeStatusText = I18nHelper.getLocaleString(nodeResultJoin.getReviewCycleNodeName(), this.personVariablesUserLocale);
        int duration = delayInfo.getNodesDuration();
        String wt = " (" + (daysInNode >= 0 ? Integer.valueOf(daysInNode) : "0") + "/" + duration + " WT)";
        try {
            size = this.batikSvgRenderer.getTextWidth("Verdana", nodeStatusText) * 10.0;
            size += this.batikSvgRenderer.getTextWidth("Verdana", wt) * 10.0;
        }
        catch (BatikSvgException e) {
            throw new RuntimeException("error getting text width", e);
        }
        if (size > startCycleX - (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL) {
            int diff = (int)(Math.floor(size - (startCycleX - (double)ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL)) / 5.0);
            nodeStatusText = nodeStatusText.substring(0, nodeStatusText.length() - diff);
            nodeStatusText = nodeStatusText + "... ";
        }
        nodeStatusText = nodeStatusText + wt;
        SvgHelper.addTextWithFontFamilyAndSize(xsw, ReviewProtocolSvgCalculator.HEIGHT_OUTER_LABEL + 5, yBasic - yPositionOfCell + 15.0, nodeStatusText, "verdana", 8.0);
        return ++nodeLabel;
    }

    private void drawStatusBar(XMLStreamWriter xsw, List<TextWithPosition> textWithPositions, double topLine) throws Exception {
        int position = 0;
        for (int n = 0; n < textWithPositions.size(); ++n) {
            boolean fitsIntoCellWidth;
            double textWidth;
            TextWithPosition textWithPosition = textWithPositions.get(n);
            try {
                textWidth = this.batikSvgRenderer.getTextWidth("Verdana", textWithPosition.text) * 10.0;
            }
            catch (BatikSvgException e) {
                throw new RuntimeException("error getting text width", e);
            }
            boolean bl = fitsIntoCellWidth = textWithPosition.xEndOfCell - (textWithPosition.xStartOfCell + 5.0) > textWidth;
            if (fitsIntoCellWidth && position == 0) {
                SvgHelper.addTextWithFontFamilyAndSize(xsw, textWithPosition.xStartOfCell + 5.0, topLine + 15.0, textWithPosition.text, "verdana", 10.0);
            } else if (fitsIntoCellWidth && position > 0) {
                SvgHelper.addTextWithFontFamilyAndSize(xsw, textWithPosition.xStartOfCell + 5.0, topLine + (double)(position == 1 ? 18 : 9), textWithPosition.text, "verdana", 10.0);
                position = 0;
            } else if (!fitsIntoCellWidth) {
                SvgHelper.addTextWithFontFamilyAndSize(xsw, textWithPosition.xStartOfCell + 5.0, topLine + (double)(position == 1 ? 18 : 9), textWithPosition.text, "verdana", 10.0);
                position = position == 1 ? 2 : 1;
            }
            SvgHelper.addRectWithStrokeFillAndOpacity(xsw, textWithPosition.xStartOfCell, topLine + 1.0, textWithPosition.xEndOfCell - textWithPosition.xStartOfCell, 18.0, "none", textWithPosition.color, ".3");
            SvgHelper.addLineWithStroke(xsw, textWithPosition.xStartOfCell, topLine, textWithPosition.xStartOfCell, topLine + 5.0, "black", 1.0);
            if (n != textWithPositions.size() - 1) continue;
            SvgHelper.addLineWithStroke(xsw, textWithPosition.xEndOfCell, topLine, textWithPosition.xEndOfCell, topLine + 5.0, "black", 1.0);
        }
    }

    private int calculateSeparateBoxLabels(XMLStreamWriter xsw, ReviewProtocolGeometry geometry, List<SeparateBoxLabel> separateBoxLabels, double x1, double y1, double x2, double y2) throws Exception {
        if (log.isDebugEnabled()) {
            for (SeparateBoxLabel boxLabel : separateBoxLabels) {
                log.debug("SeparateBoxLabel: " + boxLabel.text);
            }
        }
        int STEP_HEIGHT = 13;
        int STEP_WIDTH = 25;
        int maxAmountOfNeededPlaces = this.findMaxNeededPlaces(geometry, separateBoxLabels);
        double width = x2 - x1;
        double height = y2 - y1 + (double)(maxAmountOfNeededPlaces * 13);
        int canvasColumns = (int)Math.ceil(width / 25.0);
        int canvasRows = (int)Math.floor(height / 13.0);
        double yStartOfCanvas = y2 - height;
        double xStartOfCanvas = x1;
        int[][] canvas = new int[canvasRows][canvasColumns];
        int highestNodeRow = canvasRows;
        int lastColumnEnd = 0;
        for (SeparateBoxLabel label : separateBoxLabels) {
            double endOfNodeX;
            int columnEnd;
            if (log.isTraceEnabled()) {
                log.trace("Processing label [" + label.text + "] with urxnode = [" + label.UrxNode + "]");
            }
            if (!(label.UrxNode > 0.0) || (columnEnd = (int)Math.ceil((endOfNodeX = label.UrxNode - xStartOfCanvas) / 25.0)) == lastColumnEnd) continue;
            double endOfNodeY = label.LlyNode - yStartOfCanvas;
            int rowEnd = (int)Math.floor(endOfNodeY / 13.0);
            if (rowEnd < highestNodeRow) {
                highestNodeRow = rowEnd;
            }
            if (columnEnd > canvasColumns) {
                columnEnd = canvasColumns;
            }
            for (int row = rowEnd; row < canvasRows; ++row) {
                for (int column = lastColumnEnd; column < columnEnd; ++column) {
                    if (log.isTraceEnabled()) {
                        log.trace("First loop: Canvas [" + row + "][" + column + "] = 1 for label [" + label.text + "]");
                    }
                    canvas[row][column] = 1;
                }
            }
            lastColumnEnd = columnEnd;
        }
        int highestSeparateLabelRow = canvasRows;
        for (int i = separateBoxLabels.size() - 1; i >= 0; --i) {
            int j;
            int k;
            int rowStart;
            int columnStart;
            int columnEnd;
            double lengthOfText;
            SeparateBoxLabel label = separateBoxLabels.get(i);
            if (label.text == null) continue;
            try {
                lengthOfText = this.batikSvgRenderer.getTextWidth("Verdana", label.text) * 8.0;
            }
            catch (BatikSvgException e) {
                throw new RuntimeException("error getting text width", e);
            }
            label.lengthOfText = lengthOfText;
            if (label.boxName != null) {
                lengthOfText += 12.0;
            }
            if ((columnEnd = (int)Math.ceil((label.xPositionOfBox + lengthOfText - xStartOfCanvas) / 25.0)) > canvasColumns - 1) {
                columnEnd = canvasColumns - 1;
                columnStart = columnEnd - (int)Math.ceil(lengthOfText / 25.0);
            } else {
                columnStart = (int)Math.max(0.0, Math.ceil((label.xPositionOfBox - xStartOfCanvas) / 25.0));
            }
            int rowEnd = rowStart = (int)Math.ceil((label.yPositionOfBox - yStartOfCanvas) / 13.0);
            if (label.additionalText == null) {
                if (rowStart >= canvasRows - 1) {
                    rowEnd = rowStart = canvasRows - 1;
                }
            } else if (++rowEnd >= canvasRows - 1) {
                rowEnd = canvasRows - 1;
                rowStart = rowEnd - 1;
            }
            boolean notFree = true;
            while (notFree) {
                notFree = false;
                if (rowStart < 0) {
                    rowStart = 0;
                    break;
                }
                block8: for (k = rowStart; k <= rowEnd; ++k) {
                    for (j = columnStart; j <= columnEnd; ++j) {
                        if (canvas[k][j] != 1) continue;
                        notFree = true;
                        --rowStart;
                        --rowEnd;
                        continue block8;
                    }
                }
            }
            if (highestSeparateLabelRow > rowStart) {
                highestSeparateLabelRow = rowStart;
            }
            label.row = rowStart;
            label.column = columnStart;
            if (log.isDebugEnabled()) {
                log.debug("Will place label [" + label.text + "] to row = [" + label.row + "] and column = [" + label.column + "]");
            }
            for (k = rowStart; k <= rowEnd; ++k) {
                for (j = columnStart; j <= columnEnd; ++j) {
                    canvas[k][j] = 1;
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Marking canvas [" + k + "][" + j + "] occupied for label = [" + label.text);
                }
            }
        }
        double rememberLastXPos = 0.0;
        double rememberLastYPos = 0.0;
        int rememberLastAddToBox = 0;
        for (SeparateBoxLabel label : separateBoxLabels) {
            if (label.text == null) continue;
            if (label.xPositionOfBox == rememberLastXPos && rememberLastYPos != label.yPositionOfBox) {
                label.addToXBox = rememberLastAddToBox + 3;
            }
            String ls = "stroke:black; stroke-width:0.5px;";
            double xStart = xStartOfCanvas + (double)(label.column * 25);
            double yStart = yStartOfCanvas + (double)((label.row + 1) * 13);
            int placeForNode = 2;
            if (label.boxName != null) {
                placeForNode = 12;
                SvgHelper.addUse(xsw, label.boxName, "translate(" + xStart + "," + (yStart - 10.0) + ") ");
            }
            if (label.drawCircle) {
                SvgHelper.addCircle(xsw, label.xPositionOfBox, label.yPositionOfBox, 2.0, new String[0]);
            }
            SvgHelper.addRectWithStrokeFillAndOpacity(xsw, xStart + (double)placeForNode, yStart - 10.0, label.lengthOfText, 10.0, "none", "white", "0.6");
            SvgHelper.addTextWithFontFamilyAndSize(xsw, xStart + (double)placeForNode, yStart, label.text, "verdana", 8.0);
            if (label.additionalText != null) {
                SvgHelper.addTextWithFontFamilyAndSize(xsw, xStart, yStart + 13.0 - 3.0, label.additionalText, "verdana", 8.0);
            }
            if (label.xPositionOfBox > xStart && label.xPositionOfBox < xStart + (double)placeForNode + label.lengthOfText) {
                SvgHelper.addLineWithStroke(xsw, label.xPositionOfBox + (double)label.addToXBox, label.yPositionOfBox, label.xPositionOfBox + (double)label.addToXBox, yStart, "black", 0.5);
            } else {
                SvgHelper.addLineWithStroke(xsw, label.xPositionOfBox + (double)label.addToXBox, yStart - 5.0, xStart + (double)placeForNode + label.lengthOfText < label.xPositionOfBox ? xStart + (double)placeForNode + label.lengthOfText : xStart, yStart - 5.0, "black", 0.5);
                SvgHelper.addLineWithStroke(xsw, label.xPositionOfBox + (double)label.addToXBox, label.yPositionOfBox, label.xPositionOfBox + (double)label.addToXBox, yStart - 5.0, "black", 0.5);
            }
            if (label.addToXBox > 0) {
                SvgHelper.addLineWithStroke(xsw, label.xPositionOfBox, label.yPositionOfBox, label.xPositionOfBox + (double)label.addToXBox, label.yPositionOfBox, "black", 0.5);
            }
            rememberLastXPos = label.xPositionOfBox;
            rememberLastYPos = label.yPositionOfBox;
            rememberLastAddToBox = label.addToXBox;
        }
        return highestSeparateLabelRow < highestNodeRow ? (highestNodeRow - highestSeparateLabelRow + 1) * 13 : 0;
    }

    private int findMaxNeededPlaces(ReviewProtocolGeometry geometry, List<SeparateBoxLabel> separateBoxLabels) {
        int STEP_WIDTH = 150;
        double width = geometry.getTotalWidth();
        int places = (int)(width - (double)ReviewProtocolSvgCalculator.SPACE_FOR_XAXIS_LABEL) / 150 + 1;
        int[] position = new int[places];
        for (int i = 0; i < places; ++i) {
            position[i] = 150 * i;
        }
        int[] neededPlaces = new int[places];
        block1: for (SeparateBoxLabel label : separateBoxLabels) {
            int add;
            if (label.text == null) continue;
            int n = add = label.additionalText != null ? 2 : 1;
            if (label.xPositionOfBox >= (double)position[places - 2]) {
                int n2 = places - 1;
                neededPlaces[n2] = neededPlaces[n2] + add;
                continue;
            }
            for (int i = 0; i < places - 2; ++i) {
                if (!(label.xPositionOfBox > (double)position[i]) || !(label.xPositionOfBox <= (double)position[i + 1])) continue;
                int n3 = i + 1;
                neededPlaces[n3] = neededPlaces[n3] + add;
                continue block1;
            }
        }
        int ret = 0;
        for (int i = 0; i < neededPlaces.length; ++i) {
            if (neededPlaces[i] <= ret) continue;
            ret = neededPlaces[i];
        }
        return ret;
    }

    static {
        XOF.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        SVG_NAMESPACE_CONTEXT = SvgHelper.constructSvgNamespaceContext();
        log = LoggerFactory.getLogger(ReviewProtocolSvgRenderer.class);
    }

    public static class DelayInfo {
        private Double contractualDeadline;
        private Integer nodesDelay;
        private Integer nodesDuration;

        public DelayInfo(Double contractualDeadline, Integer nodesDelay, Integer nodesDuration) {
            this.contractualDeadline = contractualDeadline;
            this.nodesDelay = nodesDelay;
            this.nodesDuration = nodesDuration;
        }

        public Double getContractualDeadline() {
            return this.contractualDeadline;
        }

        public Integer getNodesDelay() {
            return this.nodesDelay;
        }

        public Integer getNodesDuration() {
            return this.nodesDuration;
        }

        public void setContractualDeadline(Double contractualDeadline) {
            this.contractualDeadline = contractualDeadline;
        }

        public void setNodesDelay(Integer nodesDelay) {
            this.nodesDelay = nodesDelay;
        }
    }

    private static class TextWithPosition {
        String text;
        double xStartOfCell;
        double xEndOfCell;
        double x;
        double y;
        String rotate;
        String color;

        private TextWithPosition() {
        }
    }

    private static class SeparateBoxLabel {
        double UrxNode;
        double LlyNode;
        public String additionalText;
        String text;
        double lengthOfText;
        String boxName;
        double xPositionOfBox;
        double yPositionOfBox;
        int addToXBox = 0;
        boolean drawCircle;
        int row;
        int column;

        private SeparateBoxLabel() {
        }
    }
}

