/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.action;

import at.cdes.api.joinDto.NetworkAction;
import at.cdes.api.joinDto.ObjectPlannerAction;
import at.cdes.api.joinDto.ProjectAction;
import at.cdes.api.joinDto.ShortObjectPlannerAction;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.action.ActionDAOHelper;
import at.cdes.impl.dao.jdbc.AbstractJdbcActionDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.clazzes.util.sql.helper.JDBCHelper;

public class NetworkActionHelper {
    private static String getNetworkSelectClause() {
        return "SELECT DISTINCT " + AbstractJdbcActionDAO.getSelectClauseForDto() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, default_role.id, admin_role.id, network.id, network_organisation.organisation_id, network_person.id ";
    }

    private static String getNetworkFromClause() {
        return "FROM (((((((((((network JOIN  action_rule dest_action_rule       ON    (dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) JOIN  action                             ON     dest_action_rule.action_id = action.id) JOIN  action_rule                        ON     action_rule.action_id = action.id) JOIN  role_action_rule                   ON     role_action_rule.action_rule_id = action_rule.id) CROSS JOIN  organisation_person ) JOIN  person                             ON     organisation_person.person_id = person.id) JOIN  organisation                       ON     organisation_person.organisation_id = organisation.id) LEFT JOIN  cdes_role default_role             ON     role_action_rule.cdes_role_id = default_role.id AND default_role.network_id = network.id) LEFT JOIN  network_person                     ON     network_person.organisation_person_id = organisation_person.id AND network_person.network_id = network.id) LEFT JOIN  cdes_role admin_role               ON     role_action_rule.cdes_role_id = admin_role.id AND network_person.role_id = admin_role.id) LEFT JOIN  network_organisation               ON     network_organisation.organisation_id = organisation.id AND network_organisation.network_id = network.id) ";
    }

    private static String getNetworkRuleCoreWhereClause(int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return "dest_action_rule.destination_context_id = 2 AND organisation_person.id = ? AND person.id = ? " + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "") + "AND (      admin_role.id IS NOT NULL OR (default_role.id IS NOT NULL AND default_role.context_default_role_flag = 1)) AND (      dest_action_rule.check_member = 0 OR network_organisation.organisation_id IS NOT NULL)";
    }

    public static String getNetworkRuleClauseForNetwork(int numberOfNetworks, int numberOfActionNames) {
        String networkIdWhereClause = ActionDAOHelper.getInClauseWithPlaceHolders("network.id", numberOfNetworks);
        return NetworkActionHelper.getNetworkSelectClause() + NetworkActionHelper.getNetworkFromClause() + "WHERE " + networkIdWhereClause + " AND " + NetworkActionHelper.getNetworkRuleCoreWhereClause(numberOfActionNames);
    }

    public static String getNetworkRuleClauseForProject(Integer numberOfProjectIds, int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        String sql = "SELECT DISTINCT " + AbstractJdbcActionDAO.getSelectClauseForDto() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, default_role.id, admin_role.id, network.id, network_organisation.organisation_id, network_person.id, project.id, project.access FROM ((((((((((((project  JOIN  network                            ON     project.network_id = network.id) JOIN  action_rule dest_action_rule       ON    (dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) JOIN  action                             ON     dest_action_rule.action_id = action.id) JOIN  action_rule                        ON     action_rule.action_id = action.id) JOIN  role_action_rule                   ON     role_action_rule.action_rule_id = action_rule.id) CROSS JOIN  organisation_person ) JOIN  person                             ON     organisation_person.person_id = person.id) JOIN  organisation                       ON     organisation_person.organisation_id = organisation.id) LEFT JOIN  cdes_role default_role             ON     role_action_rule.cdes_role_id = default_role.id AND default_role.network_id = network.id) LEFT JOIN  network_person                     ON     network_person.organisation_person_id = organisation_person.id AND network_person.network_id = network.id) LEFT JOIN  cdes_role admin_role               ON     role_action_rule.cdes_role_id = admin_role.id AND network_person.role_id = admin_role.id) LEFT JOIN  network_organisation               ON     network_organisation.organisation_id = organisation.id AND network_organisation.network_id = network.id) WHERE 1=1 ";
        if (numberOfProjectIds != null) {
            sql = sql + "AND project.id IN ( " + QueryHelper.getPlaceHolderSequence(numberOfProjectIds) + ") ";
        }
        sql = sql + "AND (    dest_action_rule.destination_context_id = 2  OR (     (dest_action_rule.destination_context_id = 3 OR dest_action_rule.destination_context_id = 4) AND (     project.access = 2 OR (     project.access IN (0, 1) AND action.read_only = 1)))) AND dest_action_rule.destination_context_id <= 4 AND organisation_person.id = ? AND person.id = ? " + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "") + "AND (       admin_role.id IS NOT NULL OR (default_role.id IS NOT NULL AND default_role.context_default_role_flag = 1)) AND (      dest_action_rule.check_member = 0 OR network_organisation.organisation_id IS NOT NULL) ";
        return sql;
    }

    public static String getNetworkRuleClauseForAllNetworks(int numberOfActionNames) {
        return NetworkActionHelper.getNetworkSelectClause() + NetworkActionHelper.getNetworkFromClause() + "WHERE " + NetworkActionHelper.getNetworkRuleCoreWhereClause(numberOfActionNames);
    }

    public static String getNetworkRuleClauseForObjectPlanner(int numberOfActionNames) {
        return NetworkActionHelper.getNetworkRuleSelectClauseWithObjectPlanner() + NetworkActionHelper.getNetworkRuleFromClauseWithObjectPlanner() + NetworkActionHelper.getNetworkRuleWhereClauseGivenSubProject(numberOfActionNames);
    }

    public static String getNetworkRuleClauseForObjectPlannerGivenObjectPlanners(int numberOfObjectPlanners, int numberOfActionNames) {
        return NetworkActionHelper.getNetworkRuleSelectClauseWithObjectPlanner() + NetworkActionHelper.getNetworkRuleFromClauseWithObjectPlanner() + NetworkActionHelper.getNetworkRuleWhereClauseGivenObjectPlanners(numberOfObjectPlanners, numberOfActionNames);
    }

    private static String getNetworkRuleSelectClauseWithObjectPlanner() {
        return "SELECT DISTINCT " + AbstractJdbcActionDAO.getShortObjectPlannerActionSelectClause() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, default_role.id, admin_role.id, network.id, network_organisation.organisation_id, network_person.id, project.id, project.access ";
    }

    private static String getNetworkRuleFromClauseWithObjectPlanner() {
        return "FROM ((((((((((((((((( object_planner JOIN object                        ON object_planner.object_id = object.id) JOIN object_list                   ON object.object_list_id = object_list.id) JOIN object_list_release           ON       object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1) JOIN object_release                ON       object_release.object_id = object.id AND object_release.object_list_release_id = object_list_release.id) JOIN object_planner_release        ON       object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) JOIN sub_project                   ON object_list.sub_project_id = sub_project.id) JOIN project                       ON sub_project.project_id = project.id) JOIN network                       ON project.network_id = network.id) CROSS JOIN action) JOIN action_rule dest_action_rule  ON      dest_action_rule.action_id = action.id AND (   dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) CROSS JOIN organisation_person) JOIN  person                       ON     organisation_person.person_id = person.id) JOIN  organisation                 ON     organisation_person.organisation_id = organisation.id) LEFT JOIN  network_person               ON     network_person.organisation_person_id = organisation_person.id AND network_person.network_id = network.id) LEFT JOIN  network_organisation         ON     network_organisation.organisation_id = organisation.id AND network_organisation.network_id = network.id) LEFT JOIN  cdes_role admin_role         ON     network_person.role_id = admin_role.id AND EXISTS (SELECT 1 FROM     role_action_rule JOIN action_rule ON role_action_rule.action_rule_id = action_rule.id WHERE role_action_rule.cdes_role_id = admin_role.id AND action_rule.action_id = action.id)) LEFT JOIN  cdes_role default_role       ON     default_role.network_id = network.id AND EXISTS (SELECT 1 FROM     role_action_rule JOIN action_rule ON role_action_rule.action_rule_id = action_rule.id WHERE     role_action_rule.cdes_role_id = default_role.id AND action_rule.action_id = action.id)) ";
    }

    private static String getNetworkRuleCoreWhereClause() {
        return "WHERE dest_action_rule.destination_context_id >= 2 AND dest_action_rule.destination_context_id <= 4 AND organisation_person.id = ? AND person.id = ? AND (       (    admin_role.id IS NOT NULL AND network_person.id IS NOT NULL) OR (    default_role.id IS NOT NULL AND network_organisation.organisation_id IS NOT NULL AND default_role.context_default_role_flag = 1)) AND (      dest_action_rule.check_member = 0 OR network_organisation.organisation_id IS NOT NULL)";
    }

    private static String getNetworkRuleWhereClauseGivenSubProject(int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return NetworkActionHelper.getNetworkRuleCoreWhereClause() + "AND sub_project.id = ? " + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    private static String getNetworkRuleWhereClauseGivenObjectPlanners(int numberOfObjectPlanners, int numberOfActionNames) {
        String objectPlannerWhereClause = ActionDAOHelper.getInClauseWithPlaceHolders("object_planner.id", numberOfObjectPlanners);
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return NetworkActionHelper.getNetworkRuleCoreWhereClause() + (objectPlannerWhereClause.length() > 0 ? "AND " + objectPlannerWhereClause : "AND 1=0 ") + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    public static int populateNetworkRuleClauseForNetwork(PreparedStatement statement, int currIndex, Long organisationPersonId, List<Long> networkIds, Action ... actionNames) throws SQLException {
        for (Long networkId : networkIds) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateNetworkRuleClauseForAllNetworks(PreparedStatement statement, int currIndex, Long organisationPersonId, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateNetworkRuleClauseForProject(PreparedStatement statement, int currIndex, Long organisationPersonId, Collection<Long> projectIds, Action ... actionNames) throws SQLException {
        if (projectIds != null) {
            for (Long projectId : projectIds) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
            }
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateNetworkRuleClauseForObjectPlanner(PreparedStatement statement, int currIndex, Long organisationPersonId, Long subProjectId, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateNetworkRuleClauseForObjectPlanner(PreparedStatement statement, int currIndex, Long organisationPersonId, Collection<Long> objectPlannerIds, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Long objectPlannerId : objectPlannerIds) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
        }
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static NetworkAction fillNetworkActionFromResultSet(ResultSet resultSet) throws SQLException {
        NetworkAction networkAction = new NetworkAction();
        networkAction.setActionId(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
        networkAction.setActionName(resultSet.getString(2));
        networkAction.setActionDescription(resultSet.getString(3));
        networkAction.setActionReadOnly(JDBCHelper.getBoolean((ResultSet)resultSet, (int)4));
        networkAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)5));
        networkAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        networkAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)7));
        networkAction.setDefaultRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)8));
        networkAction.setAdminRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        networkAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)10));
        networkAction.setNetworkOrganisationOrganisationId(JDBCHelper.getLong((ResultSet)resultSet, (int)11));
        networkAction.setNetworkPersonId(JDBCHelper.getLong((ResultSet)resultSet, (int)12));
        return networkAction;
    }

    public static ProjectAction fillProjectActionFromResultSet(ResultSet resultSet) throws SQLException {
        ProjectAction projectAction = new ProjectAction();
        projectAction.setActionId(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
        projectAction.setActionName(resultSet.getString(2));
        projectAction.setActionDescription(resultSet.getString(3));
        projectAction.setActionReadOnly(JDBCHelper.getBoolean((ResultSet)resultSet, (int)4));
        projectAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)5));
        projectAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        projectAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)7));
        projectAction.setDefaultRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)8));
        projectAction.setAdminRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        projectAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)10));
        projectAction.setNetworkOrganisationOrganisationId(JDBCHelper.getLong((ResultSet)resultSet, (int)11));
        projectAction.setNetworkPersonId(JDBCHelper.getLong((ResultSet)resultSet, (int)12));
        projectAction.setProjectId(JDBCHelper.getLong((ResultSet)resultSet, (int)13));
        projectAction.setProjectAccess(JDBCHelper.getInt((ResultSet)resultSet, (int)14));
        return projectAction;
    }

    public static ObjectPlannerAction fillObjectPlannerActionFromResultSet(ResultSet resultSet) throws SQLException {
        ShortObjectPlannerAction shortObjectPlannerAction = AbstractJdbcActionDAO.fillShortObjectPlannerActionFromResultSet(resultSet);
        ObjectPlannerAction objectPlannerAction = new ObjectPlannerAction();
        objectPlannerAction.setAction(shortObjectPlannerAction.getAction());
        objectPlannerAction.setObjectPlannerId(shortObjectPlannerAction.getObjectPlannerId());
        objectPlannerAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        objectPlannerAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)7));
        objectPlannerAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)8));
        objectPlannerAction.setDefaultRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        objectPlannerAction.setAdminRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)10));
        objectPlannerAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)11));
        objectPlannerAction.setNetworkOrganisationOrganisationId(JDBCHelper.getLong((ResultSet)resultSet, (int)12));
        objectPlannerAction.setNetworkPersonId(JDBCHelper.getLong((ResultSet)resultSet, (int)13));
        objectPlannerAction.setProjectId(JDBCHelper.getLong((ResultSet)resultSet, (int)14));
        objectPlannerAction.setProjectAccess(JDBCHelper.getInt((ResultSet)resultSet, (int)15));
        return objectPlannerAction;
    }
}

