/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.dto.ReviewCycleCellInstance;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.joinDto.ReviewCycleContextJoin;
import at.cdes.impl.reviewCycle.DurationCalcContext;
import at.cdes.impl.util.ContainerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReviewCycleContext
implements DurationCalcContext {
    private Map<Long, ReviewCycleCell> idToCell = new HashMap<Long, ReviewCycleCell>();
    private Map<Long, ReviewCycleCellInstance> idToCellInstance = new HashMap<Long, ReviewCycleCellInstance>();
    private Map<Long, ReviewCycleCellInstanceReleased> idToCellInstanceReleased = new HashMap<Long, ReviewCycleCellInstanceReleased>();
    private Map<Long, ReviewCycleInstanceReleased> idToInstanceReleased = new HashMap<Long, ReviewCycleInstanceReleased>();
    private Map<Long, ReviewCycleNode> idToNode = new HashMap<Long, ReviewCycleNode>();
    private Map<Long, ReviewCycleNodeInstance> idToNodeInstance = new HashMap<Long, ReviewCycleNodeInstance>();
    private Map<Long, ReviewCycleNodeInstanceReleased> idToNodeInstanceReleased = new HashMap<Long, ReviewCycleNodeInstanceReleased>();
    private Map<Long, List<ReviewCycleNodePositionReleased>> nodeInstanceReleasedIdToPositionReleased = new HashMap<Long, List<ReviewCycleNodePositionReleased>>();
    private Map<Long, List<ReviewCycleNodeInstanceReleased>> cellInstanceReleasedIdToNodeInstancesReleased = new HashMap<Long, List<ReviewCycleNodeInstanceReleased>>();
    private Map<Long, List<ReviewCycleCellConnection>> cellIdToLeavingConnections = new HashMap<Long, List<ReviewCycleCellConnection>>();
    private Map<Long, ReviewCycleResultOption> idToResultOption = new HashMap<Long, ReviewCycleResultOption>();

    public ReviewCycleContext(List<? extends ReviewCycleContextJoin> reviewCycleJoins) {
        for (ReviewCycleContextJoin reviewCycleContextJoin : reviewCycleJoins) {
            if (reviewCycleContextJoin.getCellId() != null) {
                this.idToCell.put(reviewCycleContextJoin.getCellId(), reviewCycleContextJoin.getCell());
            }
            if (reviewCycleContextJoin.getCellInstanceId() != null) {
                this.idToCellInstance.put(reviewCycleContextJoin.getCellInstanceId(), reviewCycleContextJoin.getCellInstance());
            }
            if (reviewCycleContextJoin.getCellInstanceReleasedId() != null) {
                this.idToCellInstanceReleased.put(reviewCycleContextJoin.getCellInstanceReleasedId(), reviewCycleContextJoin.getCellInstanceReleased());
            }
            if (reviewCycleContextJoin.getInstanceReleasedId() != null) {
                this.idToInstanceReleased.put(reviewCycleContextJoin.getInstanceReleasedId(), reviewCycleContextJoin.getInstanceReleased());
            }
            if (reviewCycleContextJoin.getNodeId() != null) {
                this.idToNode.put(reviewCycleContextJoin.getNodeId(), reviewCycleContextJoin.getNode());
            }
            if (reviewCycleContextJoin.getNodeInstanceId() != null) {
                this.idToNodeInstance.put(reviewCycleContextJoin.getNodeInstanceId(), reviewCycleContextJoin.getNodeInstance());
            }
            if (reviewCycleContextJoin.getNodeInstanceReleasedId() != null) {
                this.idToNodeInstanceReleased.put(reviewCycleContextJoin.getNodeInstanceReleasedId(), reviewCycleContextJoin.getNodeInstanceReleased());
            }
            if (reviewCycleContextJoin.getResultOptionId() != null) {
                this.idToResultOption.put(reviewCycleContextJoin.getResultOptionId(), reviewCycleContextJoin.getResultOption());
            }
            ContainerHelper.registerChildInstance(reviewCycleContextJoin.getNodeInstanceReleasedId(), reviewCycleContextJoin.getNodePositionReleasedId(), reviewCycleContextJoin.getNodePositionReleased(), this.nodeInstanceReleasedIdToPositionReleased);
            ContainerHelper.registerChildInstance(reviewCycleContextJoin.getCellInstanceReleasedId(), reviewCycleContextJoin.getNodeInstanceReleasedId(), reviewCycleContextJoin.getNodeInstanceReleased(), this.cellInstanceReleasedIdToNodeInstancesReleased);
            if (reviewCycleContextJoin.getCellId() == null || reviewCycleContextJoin.getCellConnectionId() == null || reviewCycleContextJoin.getCellConnectionSourceCellId() == null || reviewCycleContextJoin.getCellConnectionSourceCellId().longValue() != reviewCycleContextJoin.getCellId().longValue()) continue;
            ContainerHelper.registerChildInstanceInner(reviewCycleContextJoin.getCellId(), reviewCycleContextJoin.getCellConnection(), this.cellIdToLeavingConnections);
        }
    }

    @Override
    public ReviewCycleCell getCellById(Long cellId) {
        return this.idToCell.get(cellId);
    }

    public ReviewCycleCellInstance getCellInstance(Long cellInstanceId) {
        return this.idToCellInstance.get(cellInstanceId);
    }

    @Override
    public ReviewCycleCellInstanceReleased getCellInstanceReleasedById(Long cellInstanceReleasedId) {
        return this.idToCellInstanceReleased.get(cellInstanceReleasedId);
    }

    @Override
    public ReviewCycleInstanceReleased getInstanceReleasedById(Long instanceReleasedId) {
        return this.idToInstanceReleased.get(instanceReleasedId);
    }

    @Override
    public ReviewCycleNode getNodeById(Long nodeId) {
        return this.idToNode.get(nodeId);
    }

    @Override
    public boolean isEndNode(Long nodeId) {
        ReviewCycleNode node = this.getNodeById(nodeId);
        return !this.hasResultOptions(node.getReviewCyclePositionTypeId());
    }

    public ReviewCycleNodeInstance getNodeInstance(Long nodeInstanceId) {
        return this.idToNodeInstance.get(nodeInstanceId);
    }

    public ReviewCycleNodeInstanceReleased getNodeInstanceReleased(Long nodeInstanceReleased) {
        return this.idToNodeInstanceReleased.get(nodeInstanceReleased);
    }

    public ReviewCycleResultOption getResultOption(Long resultOptionId) {
        return this.idToResultOption.get(resultOptionId);
    }

    public Collection<ReviewCycleNodeInstanceReleased> getAllNodeInstancesReleased() {
        return this.idToNodeInstanceReleased.values();
    }

    @Override
    public Collection<ReviewCycleCellInstanceReleased> getAllCellInstancesReleased() {
        return this.idToCellInstanceReleased.values();
    }

    @Override
    public List<ReviewCycleNodeInstanceReleased> getNodeInstanceReleasedsByCellInstanceReleasedId(Long cellInstanceReleasedId) {
        return this.cellInstanceReleasedIdToNodeInstancesReleased.containsKey(cellInstanceReleasedId) ? this.cellInstanceReleasedIdToNodeInstancesReleased.get(cellInstanceReleasedId) : new ArrayList<ReviewCycleNodeInstanceReleased>();
    }

    @Override
    public List<ReviewCycleCellConnection> getLeavingConnectionsForCell(Long cellId) {
        return this.cellIdToLeavingConnections.containsKey(cellId) ? this.cellIdToLeavingConnections.get(cellId) : new ArrayList<ReviewCycleCellConnection>();
    }

    @Override
    public boolean hasNodePositionReleased(Long nodeInstanceReleasedId) {
        return this.nodeInstanceReleasedIdToPositionReleased.containsKey(nodeInstanceReleasedId);
    }

    public boolean hasResultOptions(Long positionTypeId) {
        for (ReviewCycleResultOption resultOption : this.idToResultOption.values()) {
            if (resultOption.getReviewCyclePositionTypeId() == null || resultOption.getReviewCyclePositionTypeId().longValue() != positionTypeId.longValue()) continue;
            return true;
        }
        return false;
    }
}

