/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Project;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCyclePositionType;
import at.cdes.impl.dao.GenRealmDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcRealmDAO
extends AbstrIdDAO<Realm>
implements GenRealmDAO {
    public AbstractJdbcRealmDAO() {
        super(Realm.class, "id", "realm", new String[]{"id", "review_cycle_position_type_id", "project_id", "code", "name", "description", "redlining_color", "signature_on_label", "label_text", "valid_from_date", "valid_to_date"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcRealmDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_position_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "redlining_color") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_on_label") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "label_text") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "valid_from_date") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "valid_to_date") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcRealmDAO.getSelectClauseForDto("realm", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcRealmDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".review_cycle_position_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_position_type_id") + "," + entityLocalName + ".project_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_id") + "," + entityLocalName + ".code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".redlining_color" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "redlining_color") + "," + entityLocalName + ".signature_on_label" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_on_label") + "," + entityLocalName + ".label_text" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "label_text") + "," + entityLocalName + ".valid_from_date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "valid_from_date") + "," + entityLocalName + ".valid_to_date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "valid_to_date") + " ";
    }

    protected Realm fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Realm realm = new Realm();
        realm.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        realm.setReviewCyclePositionTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        realm.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        realm.setCode(rs.getString(++columnIndex));
        realm.setName(rs.getString(++columnIndex));
        realm.setDescription(rs.getString(++columnIndex));
        realm.setRedliningColor(rs.getString(++columnIndex));
        realm.setSignatureOnLabel(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        realm.setLabelText(rs.getString(++columnIndex));
        realm.setValidFromDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        realm.setValidToDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        return realm;
    }

    public static Realm fillRealmFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Realm realm = new Realm();
        realm.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        realm.setReviewCyclePositionTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        realm.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        realm.setCode(rs.getString(columnIndex.incrementAndGet()));
        realm.setName(rs.getString(columnIndex.incrementAndGet()));
        realm.setDescription(rs.getString(columnIndex.incrementAndGet()));
        realm.setRedliningColor(rs.getString(columnIndex.incrementAndGet()));
        realm.setSignatureOnLabel(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        realm.setLabelText(rs.getString(columnIndex.incrementAndGet()));
        realm.setValidFromDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        realm.setValidToDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return realm;
    }

    public static Realm fillRealmFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcRealmDAO.fillRealmFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 11;
    }

    public int update(Realm dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Realm> dtos) {
        Iterator<Realm> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Realm realm) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)realm.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)realm.getReviewCyclePositionTypeId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)realm.getProjectId());
        statement.setString(4, realm.getCode());
        statement.setString(5, realm.getName());
        statement.setString(6, realm.getDescription());
        statement.setString(7, realm.getRedliningColor());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)8, (Boolean)realm.getSignatureOnLabel());
        statement.setString(9, realm.getLabelText());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)10, (Double)realm.getValidFromDate());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)11, (Double)realm.getValidToDate());
    }

    @Override
    public List<Realm> getByReviewCyclePositionType(ReviewCyclePositionType reviewCyclePositionType) {
        return this.getByReviewCyclePositionType(reviewCyclePositionType.getId());
    }

    @Override
    public List<Realm> getByReviewCyclePositionType(final Long reviewCyclePositionTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_position_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, reviewCyclePositionTypeId);
            }
        });
    }

    @Override
    public List<Realm> getByProject(Project project) {
        return this.getByProject(project.getId());
    }

    @Override
    public List<Realm> getByProject(final Long projectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectId);
            }
        });
    }

    @Override
    public List<Realm> getByReviewCyclePositionTypes(Collection<Long> reviewCyclePositionTypeId) {
        if (reviewCyclePositionTypeId.isEmpty()) {
            return new ArrayList<Realm>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[reviewCyclePositionTypeId.size()];
        int n = 0;
        Iterator<Long> it = reviewCyclePositionTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_position_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Realm> getByProjects(Collection<Long> projectId) {
        if (projectId.isEmpty()) {
            return new ArrayList<Realm>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectId.size()];
        int n = 0;
        Iterator<Long> it = projectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

