/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.digest.impl;

import at.cdes.api.dto.Attachment;
import at.cdes.api.dto.Persistent;
import at.cdes.api.dto.ReviewCyclePositionResult;
import at.cdes.impl.digest.AbstractDigester;
import at.cdes.impl.digest.ReviewResultDigester;
import java.util.Comparator;
import java.util.List;

public class ReviewResultDigesterImpl
extends AbstractDigester
implements ReviewResultDigester {
    @Override
    public String getSignableContent(ReviewCyclePositionResult result, List<Attachment> attachments) {
        return this.getSignableContentHelper(result, () -> this.getDigest(result, attachments));
    }

    @Override
    public String getDigest(ReviewCyclePositionResult result, List<Attachment> _attachments) {
        return this.getHash(stream -> {
            stream.write(("id=" + result.getId()).getBytes());
            stream.write(("comment=" + result.getComment()).getBytes());
            stream.write(("documentVersionId=" + result.getId()).getBytes());
            if (result.getActiveDocumentListId() != null) {
                stream.write(("activeDocumentListId=" + result.getActiveDocumentListId()).getBytes());
            }
            stream.write(("activeObjectListId=" + result.getActiveObjectListId()).getBytes());
            stream.write(("projectParticipantId=" + result.getProjectParticipantId()).getBytes());
            if (result.getRealmId() != null) {
                stream.write(("realmId=" + result.getRealmId()).getBytes());
            }
            if (result.getCommentReferenceId() == null || result.getReviewCycleNodeResultId() != null) {
                stream.write(("reviewCycleNodeResultId=" + result.getReviewCycleNodeResultId()).getBytes());
            }
            if (result.getReviewCycleResultOptionId() != null) {
                stream.write(("reviewCycleResultOptionId=" + result.getReviewCycleResultOptionId()).getBytes());
            }
            if (result.getReviewCycleCommentOptionId() != null) {
                stream.write(("reviewCycleCommentOptionId=" + result.getReviewCycleCommentOptionId()).getBytes());
            }
            stream.write(("resultDate=" + result.getResultDate()).getBytes());
            if (_attachments != null) {
                Iterable attachments = () -> _attachments.stream().sorted(Comparator.comparingLong(Persistent::getId)).iterator();
                for (Attachment attachment : attachments) {
                    if (attachment.getDigest() == null || attachment.getDigest().isEmpty()) continue;
                    stream.write(attachment.getId().toString().getBytes());
                    stream.write("=".getBytes());
                    stream.write(attachment.getDigest().getBytes());
                    stream.write("\n".getBytes());
                }
            }
            stream.write(("reviewCycleNodeId=" + result.getReviewCycleNodeId()).getBytes());
        });
    }
}

