/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec;

import at.cdes.api.certificate.CertificateGenerator;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.OldPassword;
import at.cdes.api.dto.Persistent;
import at.cdes.api.dto.Person;
import at.cdes.api.person.PasswordUtils;
import at.cdes.api.person.PersonPasswordChanger;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.OldPasswordDAO;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.sec.util.PasswordEncryption;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.clazzes.util.sec.BCryptPasswordHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonPasswordChangerImpl
implements PersonPasswordChanger {
    private static final Logger log = LoggerFactory.getLogger(PersonPasswordChangerImpl.class);
    private CertificateDAO certificateDAO;
    private CertificateGenerator certificateGenerator;
    private PasswordUtils passwordUtils;
    private PersonDAO personDAO;
    private OldPasswordDAO oldPasswordDAO;
    private Long maximumNumberOfOldPasswords;

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setCertificateGenerator(CertificateGenerator certificateGenerator) {
        this.certificateGenerator = certificateGenerator;
    }

    public void setPasswordUtils(PasswordUtils passwordUtils) {
        this.passwordUtils = passwordUtils;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setOldPasswordDAO(OldPasswordDAO oldPasswordDAO) {
        this.oldPasswordDAO = oldPasswordDAO;
    }

    public void setMaximumNumberOfOldPasswords(Long maximumNumberOfOldPasswords) {
        this.maximumNumberOfOldPasswords = maximumNumberOfOldPasswords;
    }

    public Person setPassword(Long personId, String newPassword) {
        Person person = (Person)this.personDAO.get(personId);
        return this.setPersonPassword(person, newPassword);
    }

    private Person setPersonPassword(Person person, String newPassword) {
        Long personId = person.getId();
        OldPassword oldPassword = new OldPassword();
        oldPassword.setPersonId(personId);
        oldPassword.setPassword(person.getPassword());
        oldPassword.setSetTs(person.getLastPasswordChangeTs());
        BCryptPasswordHasher pwhasher = new BCryptPasswordHasher();
        String hashed = pwhasher.hashPassword(newPassword);
        person.setLastPasswordChangeTs(Long.valueOf(Instant.now().toEpochMilli()));
        person.setPassword(hashed);
        this.personDAO.update(person);
        int maximumNumberOfOldPasswordsToStore = 0;
        if (oldPassword.getPassword() != null && !oldPassword.getPassword().isEmpty()) {
            this.oldPasswordDAO.save(oldPassword);
            if (this.maximumNumberOfOldPasswords != null && this.maximumNumberOfOldPasswords > 0L) {
                maximumNumberOfOldPasswordsToStore = this.maximumNumberOfOldPasswords.intValue() - 1;
            }
            List<OldPassword> allOldPasswords = this.oldPasswordDAO.getByPerson(personId);
            Collections.sort(allOldPasswords, new Comparator<OldPassword>(){

                @Override
                public int compare(OldPassword o1, OldPassword o2) {
                    Long tsTwo;
                    Long tsOne = o1.getSetTs();
                    long diff = (tsOne != null ? tsOne : 0L) - ((tsTwo = o2.getSetTs()) != null ? tsTwo : 0L);
                    if (diff < 0L) {
                        return -1;
                    }
                    if (diff > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (allOldPasswords.size() > maximumNumberOfOldPasswordsToStore) {
                List<OldPassword> oldPasswordsToRemove = allOldPasswords.subList(0, allOldPasswords.size() - maximumNumberOfOldPasswordsToStore);
                this.oldPasswordDAO.deleteBatch(oldPasswordsToRemove.stream().map(Persistent::getId).collect(Collectors.toList()));
            }
        }
        return person;
    }

    public Person changePersonPasswordAndSecurityQuestion(Long personId, String newPassword, String oldPassword, String question, String answer) {
        Person person = (Person)this.personDAO.get(personId);
        log.info("Called PersonPasswordChangerImpl.changePersonPasswordAndSecurityQuestion for person [" + personId + "] with name [" + person.getGivenName() + " " + person.getSurName() + "]");
        if (newPassword != null && newPassword.length() > 0) {
            log.info("Received a new password, will proceed...");
            List<Certificate> certificates = this.certificateDAO.getCertificatesByPerson(person.getId());
            for (Certificate cert : certificates) {
                if (cert.getPrivateKey() == null || cert.getPrivateKey().length <= 0) continue;
                try {
                    cert = this.certificateGenerator.changePassword(newPassword, oldPassword, cert);
                    this.certificateDAO.update(cert);
                }
                catch (SecurityException e) {
                    if (cert.isMaySign().booleanValue() && cert.getCertValidTo() != null) {
                        Double d = new Double(System.currentTimeMillis());
                        if (cert.getCertValidTo() > d / 1000.0) {
                            log.error("Error changing password of active certificate[id=" + cert.getId() + "].", (Throwable)e);
                            throw e;
                        }
                    }
                    log.warn("Error changing password of inactive certificate[id=" + cert.getId() + "].", (Throwable)e);
                }
            }
            person = this.setPersonPassword(person, newPassword);
        } else {
            log.warn("Received NO password, did nothing.");
        }
        if (question != null && question.length() > 0 && answer != null && answer.length() > 0) {
            log.info("Received security question and answer, will continue");
            String passwordToBeEncypted = oldPassword;
            if (newPassword != null && newPassword.length() > 0) {
                passwordToBeEncypted = newPassword;
            }
            person.setQuestion(question);
            PasswordEncryption enc = new PasswordEncryption();
            String hashed = this.passwordUtils.encryptSecurityAnswer(passwordToBeEncypted, answer);
            person.setAnswerPassword(hashed);
        } else {
            log.info("Received NO security question and answer, will do NOTHING about it.");
        }
        this.personDAO.update(person);
        return person;
    }
}

