/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.dto.ActionInfo;
import at.cdes.api.dto.ActionRule;
import at.cdes.api.dto.ActionRuleDefault;
import at.cdes.api.dto.Ca;
import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.CdesRoleDefault;
import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentNumberPartDefault;
import at.cdes.api.dto.DocumentNumberPartGroup;
import at.cdes.api.dto.DocumentNumberPartGroupDefault;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.DocumentTypeDefault;
import at.cdes.api.dto.Job;
import at.cdes.api.dto.Localisation;
import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkObjectPlannerDefinition;
import at.cdes.api.dto.NetworkPerson;
import at.cdes.api.dto.NetworkReviewCycle;
import at.cdes.api.dto.NetworkType;
import at.cdes.api.dto.ObjectPlannerDefinitionTemplate;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.ObjectTypeDefault;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Persistent;
import at.cdes.api.dto.PersonInCharge;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectConfig;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.RoleActionRule;
import at.cdes.api.dto.RoleDefaultActionRule;
import at.cdes.api.dto.StatutoryDuty;
import at.cdes.api.dto.SubProjectType;
import at.cdes.api.dto.SubProjectTypeDefault;
import at.cdes.api.dto.SubjectArea;
import at.cdes.api.guiService.NetworkService;
import at.cdes.api.guiService.OrganisationService;
import at.cdes.api.guiService.ProjectService;
import at.cdes.api.job.core.JobHandle;
import at.cdes.api.job.core.JobInfo;
import at.cdes.api.job.core.JobSearchModel;
import at.cdes.api.joinDto.CaJoin;
import at.cdes.api.joinDto.JobJoin;
import at.cdes.api.joinDto.NetworkJoin;
import at.cdes.api.joinDto.OrganisationJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.OrganisationPersonSelectionJoin;
import at.cdes.api.joinDto.ProjectJoin;
import at.cdes.api.masterData.CopyDocumentNumberPartDefaultInfo;
import at.cdes.api.masterData.DocumentTypeEditInfo;
import at.cdes.api.masterData.MasterDataItem;
import at.cdes.api.masterData.MasterDataPageInfo;
import at.cdes.api.network.dto.NetworkInfo;
import at.cdes.api.network.dto.NetworkListSearchInfo;
import at.cdes.api.network.dto.NetworkPersonInfo;
import at.cdes.api.network.dto.NetworkSearchModel;
import at.cdes.api.voc.ProjectFlag;
import at.cdes.api.voc.ProjectStatus;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.ActionRuleDAO;
import at.cdes.impl.dao.ActionRuleDefaultDAO;
import at.cdes.impl.dao.CaDAO;
import at.cdes.impl.dao.CdesRoleDAO;
import at.cdes.impl.dao.CdesRoleDefaultDAO;
import at.cdes.impl.dao.DocumentNumberPartDAO;
import at.cdes.impl.dao.DocumentNumberPartDefaultDAO;
import at.cdes.impl.dao.DocumentNumberPartGroupDAO;
import at.cdes.impl.dao.DocumentNumberPartGroupDefaultDAO;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.DocumentTypeDefaultDAO;
import at.cdes.impl.dao.JobDAO;
import at.cdes.impl.dao.LocalisationDAO;
import at.cdes.impl.dao.MasterDataSetDAO;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.NetworkObjectPlannerDefinitionDAO;
import at.cdes.impl.dao.NetworkOrganisationDAO;
import at.cdes.impl.dao.NetworkPersonDAO;
import at.cdes.impl.dao.NetworkReviewCycleDAO;
import at.cdes.impl.dao.NetworkTypeDAO;
import at.cdes.impl.dao.ObjectPlannerDefinitionTemplateDAO;
import at.cdes.impl.dao.ObjectTypeDAO;
import at.cdes.impl.dao.ObjectTypeDefaultDAO;
import at.cdes.impl.dao.OrganisationDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonInChargeDAO;
import at.cdes.impl.dao.ProjectConfigDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ReviewCycleDAO;
import at.cdes.impl.dao.RoleActionRuleDAO;
import at.cdes.impl.dao.RoleDefaultActionRuleDAO;
import at.cdes.impl.dao.StatutoryDutyDAO;
import at.cdes.impl.dao.SubProjectTypeDAO;
import at.cdes.impl.dao.SubProjectTypeDefaultDAO;
import at.cdes.impl.dao.SubjectAreaDAO;
import at.cdes.impl.export.masterData.MasterDataPdfCallable;
import at.cdes.impl.export.masterData.MasterDataPdfExporter;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.job.core.JobRegistry;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.i18n.I18nHelper;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkServiceImpl
implements NetworkService {
    private ActionDAO actionDAO;
    private ActionRuleDAO actionRuleDAO;
    private ActionRuleDefaultDAO actionRuleDefaultDAO;
    private CaDAO caDAO;
    private CdesRoleDAO cdesRoleDAO;
    private CdesRoleDefaultDAO cdesRoleDefaultDAO;
    private DocumentNumberPartDAO documentNumberPartDAO;
    private DocumentNumberPartGroupDAO documentNumberPartGroupDAO;
    private DocumentNumberPartDefaultDAO documentNumberPartDefaultDAO;
    private DocumentNumberPartGroupDefaultDAO documentNumberPartGroupDefaultDAO;
    private DocumentTypeDAO documentTypeDAO;
    private DocumentTypeDefaultDAO documentTypeDefaultDAO;
    private Boolean enableCustomerLogo;
    private String costumerLabel;
    private JobDAO jobDAO;
    private JobRegistry jobRegistry;
    private LocalisationDAO localisationDAO;
    private MasterDataPdfExporter masterDataPdfExporter;
    private MasterDataSetDAO masterDataSetDAO;
    private NetworkDAO networkDAO;
    private NetworkObjectPlannerDefinitionDAO networkObjectPlannerDefinitionDAO;
    private NetworkOrganisationDAO networkOrganisationDAO;
    private NetworkPersonDAO networkPersonDAO;
    private NetworkReviewCycleDAO networkReviewCycleDAO;
    private NetworkTypeDAO networkTypeDAO;
    private ObjectPlannerDefinitionTemplateDAO objectPlannerDefinitionTemplateDAO;
    private ObjectTypeDAO objectTypeDAO;
    private ObjectTypeDefaultDAO objectTypeDefaultDAO;
    private IOneTimeScheduler oneTimeScheduler;
    private OrganisationDAO organisationDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private PersonInChargeDAO personInChargeDAO;
    private ProjectDAO projectDAO;
    private ProjectConfigDAO projectConfigDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private RoleActionRuleDAO roleActionRuleDAO;
    private RoleDefaultActionRuleDAO roleDefaultActionRuleDAO;
    private StatutoryDutyDAO statutoryDutyDAO;
    private SubjectAreaDAO subjectAreaDAO;
    private SubProjectTypeDAO subProjectTypeDAO;
    private SubProjectTypeDefaultDAO subProjectTypeDefaultDAO;
    private Long useDocumentSubtypes;
    private ProjectService projectService;
    private OrganisationService organisationService;
    private static final Logger log = LoggerFactory.getLogger(NetworkServiceImpl.class);

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setActionRuleDAO(ActionRuleDAO actionRuleDAO) {
        this.actionRuleDAO = actionRuleDAO;
    }

    public void setActionRuleDefaultDAO(ActionRuleDefaultDAO actionRuleDefaultDAO) {
        this.actionRuleDefaultDAO = actionRuleDefaultDAO;
    }

    public void setCaDAO(CaDAO caDAO) {
        this.caDAO = caDAO;
    }

    public void setCdesRoleDAO(CdesRoleDAO cdesRoleDAO) {
        this.cdesRoleDAO = cdesRoleDAO;
    }

    public void setCdesRoleDefaultDAO(CdesRoleDefaultDAO cdesRoleDefaultDAO) {
        this.cdesRoleDefaultDAO = cdesRoleDefaultDAO;
    }

    public void setDocumentNumberPartDAO(DocumentNumberPartDAO documentNumberPartDAO) {
        this.documentNumberPartDAO = documentNumberPartDAO;
    }

    public void setDocumentNumberPartGroupDAO(DocumentNumberPartGroupDAO documentNumberPartGroupDAO) {
        this.documentNumberPartGroupDAO = documentNumberPartGroupDAO;
    }

    public void setDocumentNumberPartDefaultDAO(DocumentNumberPartDefaultDAO documentNumberPartDefaultDAO) {
        this.documentNumberPartDefaultDAO = documentNumberPartDefaultDAO;
    }

    public void setDocumentNumberPartGroupDefaultDAO(DocumentNumberPartGroupDefaultDAO documentNumberPartGroupDefaultDAO) {
        this.documentNumberPartGroupDefaultDAO = documentNumberPartGroupDefaultDAO;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public void setDocumentTypeDefaultDAO(DocumentTypeDefaultDAO documentTypeDefaultDAO) {
        this.documentTypeDefaultDAO = documentTypeDefaultDAO;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public void setJobDAO(JobDAO jobDAO) {
        this.jobDAO = jobDAO;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setLocalisationDAO(LocalisationDAO localisationDAO) {
        this.localisationDAO = localisationDAO;
    }

    public void setMasterDataPdfExporter(MasterDataPdfExporter masterDataPdfExporter) {
        this.masterDataPdfExporter = masterDataPdfExporter;
    }

    public void setMasterDataSetDAO(MasterDataSetDAO masterDataSetDAO) {
        this.masterDataSetDAO = masterDataSetDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setNetworkObjectPlannerDefinitionDAO(NetworkObjectPlannerDefinitionDAO networkObjectPlannerDefinitionDAO) {
        this.networkObjectPlannerDefinitionDAO = networkObjectPlannerDefinitionDAO;
    }

    public void setNetworkOrganisationDAO(NetworkOrganisationDAO networkOrganisationDAO) {
        this.networkOrganisationDAO = networkOrganisationDAO;
    }

    public void setNetworkPersonDAO(NetworkPersonDAO networkPersonDAO) {
        this.networkPersonDAO = networkPersonDAO;
    }

    public void setNetworkReviewCycleDAO(NetworkReviewCycleDAO networkReviewCycleDAO) {
        this.networkReviewCycleDAO = networkReviewCycleDAO;
    }

    public void setNetworkTypeDAO(NetworkTypeDAO networkTypeDAO) {
        this.networkTypeDAO = networkTypeDAO;
    }

    public void setObjectPlannerDefinitionTemplateDAO(ObjectPlannerDefinitionTemplateDAO objectPlannerDefinitionTemplateDAO) {
        this.objectPlannerDefinitionTemplateDAO = objectPlannerDefinitionTemplateDAO;
    }

    public void setObjectTypeDAO(ObjectTypeDAO objectTypeDAO) {
        this.objectTypeDAO = objectTypeDAO;
    }

    public void setObjectTypeDefaultDAO(ObjectTypeDefaultDAO objectTypeDefaultDAO) {
        this.objectTypeDefaultDAO = objectTypeDefaultDAO;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonInChargeDAO(PersonInChargeDAO personInChargeDAO) {
        this.personInChargeDAO = personInChargeDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectConfigDAO(ProjectConfigDAO projectConfigDAO) {
        this.projectConfigDAO = projectConfigDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    public void setRoleActionRuleDAO(RoleActionRuleDAO roleActionRuleDAO) {
        this.roleActionRuleDAO = roleActionRuleDAO;
    }

    public void setRoleDefaultActionRuleDAO(RoleDefaultActionRuleDAO roleDefaultActionRuleDAO) {
        this.roleDefaultActionRuleDAO = roleDefaultActionRuleDAO;
    }

    public void setStatutoryDutyDAO(StatutoryDutyDAO statutoryDutyDAO) {
        this.statutoryDutyDAO = statutoryDutyDAO;
    }

    public void setSubjectAreaDAO(SubjectAreaDAO subjectAreaDAO) {
        this.subjectAreaDAO = subjectAreaDAO;
    }

    public void setSubProjectTypeDAO(SubProjectTypeDAO subProjectTypeDAO) {
        this.subProjectTypeDAO = subProjectTypeDAO;
    }

    public void setSubProjectTypeDefaultDAO(SubProjectTypeDefaultDAO subProjectTypeDefaultDAO) {
        this.subProjectTypeDefaultDAO = subProjectTypeDefaultDAO;
    }

    public void setUseDocumentSubtypes(Long useDocumentSubtypes) {
        this.useDocumentSubtypes = useDocumentSubtypes;
    }

    public void setProjectService(ProjectService projectService) {
        this.projectService = projectService;
    }

    public void setOrganisationService(OrganisationService organisationService) {
        this.organisationService = organisationService;
    }

    public List<Network> getAllNetworks() {
        return this.networkDAO.getAll();
    }

    public Project getProject(Long projectId) {
        return (Project)this.projectDAO.get(projectId);
    }

    public ProjectJoin getProjectJoin(Long projectId) {
        return this.projectDAO.getProjectJoin(projectId);
    }

    public void createProject(ProjectJoin projectJoin, Long creatorOrganisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, creatorOrganisationPersonId);
        Project project = projectJoin.getProject();
        Long networkId = project.getNetworkId();
        ProjectConfig givenProjectConfig = projectJoin.getProjectConfig();
        ProjectConfig projectConfig = new ProjectConfig();
        projectConfig.setPlanningNotificationOrderTagsEnabled(Boolean.valueOf(false));
        projectConfig.setWorkflowBaulosForAllNodes(givenProjectConfig.getWorkflowBaulosForAllNodes());
        projectConfig = (ProjectConfig)this.projectConfigDAO.save(projectConfig);
        if (project.getStatus().intValue() != ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) {
            throw new UnsupportedOperationException("Currently, only planningNotification projects can be created here.  Other projects need additional, not yet implemented code (especially related to copyRealmTemplatesToProject)");
        }
        Double currentTimeUtcSeconds = new Double(System.currentTimeMillis()) / 1000.0;
        project.setProjectConfigId(projectConfig.getId());
        project.setCreated(currentTimeUtcSeconds);
        project.setCreatedById(creatorOrganisationPersonId);
        project.setModified(currentTimeUtcSeconds);
        project.setModifiedById(creatorOrganisationPersonId);
        List<DocumentNumberPartGroup> documentNumberPartGroups = this.documentNumberPartGroupDAO.getByNetwork(project.getNetworkId());
        if (documentNumberPartGroups.size() == 0) {
            throw new RuntimeException("Did not find a DocumentNumberPartGroup for networkId [" + project.getNetworkId() + "]; something is wrong with that network; cannot create a project here.");
        }
        project.setDocumentNumberPartGroupId(documentNumberPartGroups.iterator().next().getId());
        List<Localisation> austrianLocalisations = this.localisationDAO.getByCountryCodeTwo("AT");
        if (austrianLocalisations.size() == 0) {
            throw new RuntimeException("Currently, projects are created hardcoded with the Austrian localisation.  However no Austrian localisation could be found, thus we cannot proceed here.");
        }
        project.setLocalisationId(austrianLocalisations.iterator().next().getId());
        project = (Project)this.projectDAO.save(project);
        this.makeProjectAdministratorWithProject(creatorOrganisationPersonId, networkId, project);
        if (project.getStatus().intValue() != ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) {
            // empty if block
        }
    }

    public void makeProjectAdministrator(Long organisationPersonId, Long networkId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId, Action.INSERT_PLANNING_NOTIFICATION_PROJECT)) {
            throw new SecurityException("No network privilege [insertPlanningNotificationProject] for organisationPerson [" + organisationPersonId + "] in network [" + networkId + "].  Thus making the organisationPerson a projectAdministrator is not allowed.");
        }
        Map<Action, ActionInfo> actionsForProject = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, Action.EDIT_PLANNING_NOTIFICATION_PROJECT);
        if (actionsForProject.containsKey(Action.EDIT_PLANNING_NOTIFICATION_PROJECT)) {
            throw new IllegalArgumentException("OrganisationPerson [" + organisationPersonId + "] already has project privilege [editPlanningNotificationProject] in project [" + projectId + "].  Thus the organisationPerson already seems to be a project administrator on that project, making it a second time doesn't make sense.");
        }
        Project project = (Project)this.projectDAO.get(projectId);
        this.makeProjectAdministratorWithProject(organisationPersonId, networkId, project);
    }

    private void makeProjectAdministratorWithProject(Long organisationPersonId, Long networkId, Project project) {
        CdesRole adminRole;
        OrganisationPersonJoin organisationPersonJoin;
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoin(organisationPersonId);
        OrganisationPersonJoin organisationPersonJoin2 = organisationPersonJoin = organisationPersonJoins.size() > 0 ? organisationPersonJoins.get(0) : null;
        if (organisationPersonJoin == null || organisationPersonJoin.getOrganisationId() == null) {
            throw new RuntimeException("Could not find organisation of for the new ProjectParticipation");
        }
        int projectFlag = project.getStatus().intValue() == ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue() ? ProjectFlag.PROJECT_ADMIN_PLANNING_NOTIFICATION.getValue() : ProjectFlag.PROJECT_ADMIN_ROLE.getValue();
        List<CdesRole> adminRoles = this.cdesRoleDAO.getByAttributes(networkId, projectFlag);
        CdesRole cdesRole = adminRole = adminRoles.size() > 0 ? adminRoles.get(0) : null;
        if (adminRole == null) {
            throw new RuntimeException("Could not find the CdesRole for networkId [" + networkId + "] and projectFlag = [" + projectFlag + "]");
        }
        ProjectParticipation projectParticipation = new ProjectParticipation();
        projectParticipation.setProjectId(project.getId());
        projectParticipation.setRoleId(adminRole.getId());
        projectParticipation.setOrganisationId(organisationPersonJoin.getOrganisationId());
        projectParticipation.setMailFlag(Boolean.valueOf(false));
        projectParticipation.setInvalidated(Integer.valueOf(0));
        projectParticipation = (ProjectParticipation)this.projectParticipationDAO.save(projectParticipation);
        if (log.isDebugEnabled()) {
            log.debug("Inserted ProjectParticipation [" + projectParticipation.getId() + "]");
        }
        ProjectParticipant projectParticipant = new ProjectParticipant();
        projectParticipant.setMainParticipantFlag(Boolean.valueOf(true));
        projectParticipant.setParticipationId(projectParticipation.getId());
        projectParticipant.setOrganisationPersonId(organisationPersonId);
        projectParticipant.setInactiveFlag(Boolean.valueOf(false));
        projectParticipant = (ProjectParticipant)this.projectParticipantDAO.save(projectParticipant);
        if (log.isDebugEnabled()) {
            log.debug("Inserted ProjectParticipant [" + projectParticipant.getId() + "]");
        }
    }

    public void updateProject(ProjectJoin projectJoin, Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Integer projectStatus = projectJoin.getProjectStatus();
        if (projectStatus != null && projectStatus.intValue() == ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) {
            Set<Action> actions = this.actionDAO.getActionsForProject(organisationPersonId, projectJoin.getProjectId(), Action.EDIT_PLANNING_NOTIFICATION_PROJECT);
            if (!actions.contains(Action.EDIT_PLANNING_NOTIFICATION_PROJECT)) {
                throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] needs privilege [editPlanningNotificationProject] to edit project [" + projectJoin.getProjectId() + "]");
            }
        } else {
            throw new UnsupportedOperationException("Currently, this function is only implemented for case PlanningNotification; for ordinary projects, please improve things here.");
        }
        Double currentTimeUtcSeconds = new Double(System.currentTimeMillis()) / 1000.0;
        Long projectId = projectJoin.getProjectId();
        ProjectJoin oldProjectJoin = this.projectDAO.getProjectJoin(projectId);
        ProjectConfig newProjectConfig = oldProjectJoin.getProjectConfig();
        if (newProjectConfig.getId() == null) {
            newProjectConfig = new ProjectConfig();
            newProjectConfig.setPlanningNotificationOrderTagsEnabled(Boolean.valueOf(false));
            newProjectConfig = (ProjectConfig)this.projectConfigDAO.save(newProjectConfig);
        }
        newProjectConfig.setWorkflowBaulosForAllNodes(projectJoin.getProjectConfigWorkflowBaulosForAllNodes());
        this.projectConfigDAO.update(newProjectConfig);
        Project newProject = oldProjectJoin.getProject();
        newProject.setProjectConfigId(newProjectConfig.getId());
        newProject.setCode(projectJoin.getProjectCode());
        newProject.setName(projectJoin.getProjectName());
        newProject.setComment(projectJoin.getProjectComment());
        newProject.setModified(currentTimeUtcSeconds);
        newProject.setModifiedById(organisationPersonId);
        this.projectDAO.update(newProject);
    }

    public List<JobJoin> getJobs(JobSearchModel searchModel) {
        Long contextOrganisationPersonId = searchModel.getOrganisationPersonId();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, contextOrganisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(contextOrganisationPersonId, Action.SUPER_ADMIN_RIGHT);
        if (!actions.contains(Action.SUPER_ADMIN_RIGHT)) {
            throw new SecurityException("OrganisationPersonId [" + contextOrganisationPersonId + "] is not allowed to retrieve the job list.  Reason: Missing privilege [" + Action.SUPER_ADMIN_RIGHT + "]");
        }
        List<Job> transientJobs = this.jobRegistry.getJobs(searchModel);
        HashSet<Long> organisationPersonIds = new HashSet<Long>();
        HashSet<Long> networkIds = new HashSet<Long>();
        for (Job job : transientJobs) {
            if (job.getOrganisationPersonId() != null) {
                organisationPersonIds.add(job.getOrganisationPersonId());
            }
            if (job.getNetworkId() == null) continue;
            networkIds.add(job.getNetworkId());
        }
        HashMap<Long, OrganisationPersonJoin> organisationPersonIdToJoin = new HashMap<Long, OrganisationPersonJoin>();
        HashMap<Long, Network> networkIdToNetwork = new HashMap<Long, Network>();
        if (organisationPersonIds.size() > 0) {
            List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoin(organisationPersonIds.toArray(new Long[0]));
            for (OrganisationPersonJoin organisationPersonJoin : organisationPersonJoins) {
                Long organisationPersonId = organisationPersonJoin.getOrganisationPersonId();
                organisationPersonIdToJoin.put(organisationPersonId, organisationPersonJoin);
            }
        }
        if (networkIds.size() > 0) {
            List networks = this.networkDAO.getBatch(networkIds);
            for (Network network : networks) {
                networkIdToNetwork.put(network.getId(), network);
            }
        }
        ArrayList<JobJoin> jobJoins = new ArrayList<JobJoin>();
        for (Job transientJob : transientJobs) {
            Long networkId;
            JobJoin jobJoin = new JobJoin();
            jobJoin.setJob(transientJob);
            Long organisationPersonId = transientJob.getOrganisationPersonId();
            if (organisationPersonId != null && organisationPersonIdToJoin.containsKey(organisationPersonId)) {
                OrganisationPersonJoin organisationPersonJoin = (OrganisationPersonJoin)organisationPersonIdToJoin.get(organisationPersonId);
                jobJoin.setOrganisationPerson(organisationPersonJoin.getOrganisationPerson());
                jobJoin.setPerson(organisationPersonJoin.getPerson());
            }
            if ((networkId = transientJob.getNetworkId()) != null && networkIdToNetwork.containsKey(networkId)) {
                Network network = (Network)networkIdToNetwork.get(networkId);
                jobJoin.setNetwork(network);
            }
            jobJoins.add(jobJoin);
        }
        List<JobJoin> persistentJobJoins = this.jobDAO.getBySearchModel(searchModel);
        for (JobJoin persistentJobJoin : persistentJobJoins) {
            jobJoins.add(persistentJobJoin);
        }
        return jobJoins;
    }

    public JobJoin getPersistentJobJoin(Long organisationPersonId, Long jobId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        JobJoin jobJoin = this.jobDAO.getById(jobId);
        if (jobJoin != null && (jobJoin.getOrganisationPersonId() == null || jobJoin.getOrganisationPersonId().longValue() != organisationPersonId.longValue())) {
            throw new SecurityException("May only return own jobs.");
        }
        return jobJoin;
    }

    public void destroyJob(Long organisationPersonId, String uuid) {
        log.info("About to destroy process with cdes uuid [" + uuid + "]");
        JobInfo jobInfo = this.jobRegistry.getJob(uuid);
        if (jobInfo == null) {
            log.info("Cannot destroy job [" + uuid + "] since it doesn't exist.");
            return;
        }
        JobHandle jobHandle = jobInfo.getJobHandle();
        if (jobHandle != null) {
            jobHandle.destroy();
        }
        UUID schedUtilUuid = this.jobRegistry.getSchedUtilUUID(uuid);
        this.oneTimeScheduler.cancelJob(schedUtilUuid, true);
        log.info("Destroying job with cdes uuid [" + uuid + "] and schedUtil uuid [" + schedUtilUuid.toString() + "] has finished.");
    }

    public void deleteJob(Long organisationPersonId, Long id) {
        this.jobDAO.delete(id);
    }

    public List<NetworkInfo> getNetworkInfos(Long organisationPersonId, NetworkSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.NETWORK_GLOBAL_OVERVIEW);
        if (!actions.contains(Action.NETWORK_GLOBAL_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to retrieve the job list.  Reason: Missing privilege [" + Action.NETWORK_GLOBAL_OVERVIEW + "]");
        }
        OrganisationPersonJoin callingOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String userLocale = callingOrganisationPersonJoin.getPersonVariablesUserLocale();
        List<NetworkJoin> networkJoins = this.networkDAO.getNetworkJoins(searchModel);
        HashMap networkIdToJoins = new HashMap();
        for (NetworkJoin networkJoin : networkJoins) {
            Long networkId = networkJoin.getNetworkId();
            if (!networkIdToJoins.containsKey(networkId)) {
                networkIdToJoins.put(networkId, new ArrayList());
            }
            ((List)networkIdToJoins.get(networkId)).add(networkJoin);
        }
        List reviewCycles = this.reviewCycleDAO.getAll();
        for (ReviewCycle cycle : reviewCycles) {
            String reviewCycleName = I18nHelper.convertDatabaseToJs(cycle.getName(), userLocale, null);
            cycle.setName(reviewCycleName);
        }
        Map map = ContainerHelper.groupById(reviewCycles);
        List objectPlannerDefinitionTemplates = this.objectPlannerDefinitionTemplateDAO.getAll();
        Map idToTemplate = ContainerHelper.groupById(objectPlannerDefinitionTemplates);
        HashMap networkIdToCycles = new HashMap();
        HashMap networkIdToTemplates = new HashMap();
        List networkReviewCycles = this.networkReviewCycleDAO.getAll();
        for (Object networkReviewCycle : networkReviewCycles) {
            Long networkId = networkReviewCycle.getNetworkId();
            Long cycleId = networkReviewCycle.getReviewCycleId();
            ReviewCycle cycle = (ReviewCycle)map.get(cycleId);
            if (!networkIdToCycles.containsKey(networkId)) {
                networkIdToCycles.put(networkId, new ArrayList());
            }
            ((List)networkIdToCycles.get(networkId)).add(cycle);
        }
        List networkObjectPlannerDefinitions = this.networkObjectPlannerDefinitionDAO.getAll();
        for (NetworkObjectPlannerDefinition networkObjectPlannerDefinition : networkObjectPlannerDefinitions) {
            Long networkId = networkObjectPlannerDefinition.getNetworkId();
            Long templateId = networkObjectPlannerDefinition.getObjectPlannerDefinitionId();
            ObjectPlannerDefinitionTemplate objectPlannerDefinitionTemplate = (ObjectPlannerDefinitionTemplate)idToTemplate.get(templateId);
            if (!networkIdToTemplates.containsKey(networkId)) {
                networkIdToTemplates.put(networkId, new ArrayList());
            }
            ((List)networkIdToTemplates.get(networkId)).add(objectPlannerDefinitionTemplate);
        }
        double currentUtcSeconds = (double)System.currentTimeMillis() / 1000.0;
        List<CaJoin> caJoins = this.caDAO.getAllCaJoins();
        for (CaJoin caJoin : caJoins) {
            Ca restrictedCa = new Ca();
            restrictedCa.setId(caJoin.getCaId());
            restrictedCa.setSubjectDn(caJoin.getCaSubjectDn());
            restrictedCa.setCertValidFrom(caJoin.getCaCertValidFrom());
            restrictedCa.setCertValidTo(caJoin.getCaCertValidTo());
            restrictedCa.setMayIssue(caJoin.getCaMayIssue());
            restrictedCa.setMayAuthenticate(caJoin.getCaMayAuthenticate());
            restrictedCa.setNetworkId(caJoin.getCaNetworkId());
            restrictedCa.setCaCertId(caJoin.getCaCaCertId());
            caJoin.setCa(restrictedCa);
        }
        HashMap<Long, CaJoin> networkIdToNewestUserCaJoin = new HashMap<Long, CaJoin>();
        for (CaJoin caJoin : caJoins) {
            boolean mayIssue;
            Double certValidFrom = caJoin.getCaCertValidFrom();
            Double certValidTo = caJoin.getCaCertValidTo();
            Long networkId = caJoin.getCaNetworkId();
            boolean bl = mayIssue = caJoin.getCaMayIssue() != null && caJoin.getCaMayIssue() != false;
            if (certValidFrom == null || certValidTo == null || !(certValidFrom < currentUtcSeconds) || !(certValidTo > currentUtcSeconds) || caJoin.getCaCaCertId() == null || !mayIssue) continue;
            if (networkIdToNewestUserCaJoin.containsKey(networkId)) {
                Double otherCertValidFrom = ((CaJoin)networkIdToNewestUserCaJoin.get(networkId)).getCaCertValidFrom();
                if (!(otherCertValidFrom < certValidFrom)) continue;
                networkIdToNewestUserCaJoin.put(networkId, caJoin);
                continue;
            }
            networkIdToNewestUserCaJoin.put(networkId, caJoin);
        }
        ArrayList<NetworkInfo> arrayList = new ArrayList<NetworkInfo>();
        for (Long networkId : networkIdToJoins.keySet()) {
            NetworkJoin someJoin = (NetworkJoin)((List)networkIdToJoins.get(networkId)).get(0);
            NetworkInfo networkInfo = new NetworkInfo();
            networkInfo.setId(someJoin.getNetworkId());
            networkInfo.setNetwork(someJoin.getNetwork());
            networkInfo.setMaintainerOrganisation(someJoin.getMaintainerOrganisation());
            ArrayList<NetworkPersonInfo> networkPersonInfos = new ArrayList<NetworkPersonInfo>();
            List networkPersonJoins = (List)networkIdToJoins.get(networkId);
            for (NetworkJoin networkPersonJoin : networkPersonJoins) {
                if (networkPersonJoin.getNetworkPersonId() == null) continue;
                NetworkPersonInfo networkPersonInfo = new NetworkPersonInfo();
                networkPersonInfo.setNetworkPerson(networkPersonJoin.getNetworkPerson());
                networkPersonInfo.setOrganisationPerson(networkPersonJoin.getOrganisationPerson());
                networkPersonInfo.setOrganisation(networkPersonJoin.getOrganisation());
                networkPersonInfo.setPerson(networkPersonJoin.getPerson());
                networkPersonInfos.add(networkPersonInfo);
            }
            networkInfo.setNetworkPersonInfos(networkPersonInfos);
            List cycles = networkIdToCycles.containsKey(networkId) ? (List)networkIdToCycles.get(networkId) : new ArrayList();
            List templates = networkIdToTemplates.containsKey(networkId) ? (List)networkIdToTemplates.get(networkId) : new ArrayList();
            networkInfo.setReviewCycles(cycles);
            networkInfo.setObjectPlannerDefinitionTemplates(templates);
            CaJoin caJoin = (CaJoin)networkIdToNewestUserCaJoin.get(someJoin.getNetworkId());
            if (caJoin != null) {
                networkInfo.setNewestUserCaId(caJoin.getCaId());
                networkInfo.setCertValidFrom(caJoin.getCaCertValidFrom());
                networkInfo.setCertValidTo(caJoin.getCaCertValidTo());
                networkInfo.setSubjectDn(caJoin.getCaSubjectDn());
                networkInfo.setNewestUserCaCreationPerson(caJoin.getPerson());
            }
            arrayList.add(networkInfo);
        }
        return arrayList;
    }

    public NetworkListSearchInfo getNetworkListSearchInfo(Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.NETWORK_GLOBAL_OVERVIEW);
        if (!actions.contains(Action.NETWORK_GLOBAL_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to retrieve the job list.  Reason: Missing privilege [" + Action.NETWORK_GLOBAL_OVERVIEW + "]");
        }
        OrganisationPersonJoin callingOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String userLocale = callingOrganisationPersonJoin.getPersonVariablesUserLocale();
        NetworkListSearchInfo searchInfo = new NetworkListSearchInfo();
        List networkTypes = this.networkTypeDAO.getAll();
        searchInfo.setNetworkTypes(networkTypes);
        List networks = this.networkDAO.getAll();
        searchInfo.setNetworks(networks);
        List<Organisation> maintainerOrganisations = this.organisationDAO.getAllMaintainerOrganisations();
        searchInfo.setOrganisations(maintainerOrganisations);
        List<OrganisationPersonSelectionJoin> administratorJoins = this.organisationPersonDAO.getAllNetworkPersonOrganisationPersonSelectionJoins();
        searchInfo.setAdministratorJoins(administratorJoins);
        List allOrganisations = this.organisationDAO.getAll();
        searchInfo.setAllOrganisations(allOrganisations);
        List reviewCycles = this.reviewCycleDAO.getAll();
        for (ReviewCycle reviewCycle : reviewCycles) {
            String name = reviewCycle.getName();
            name = I18nHelper.convertDatabaseToJs(name, userLocale, null);
            reviewCycle.setName(name);
        }
        searchInfo.setReviewCycles(reviewCycles);
        List objectPlannerDefinitionTemplates = this.objectPlannerDefinitionTemplateDAO.getAll();
        searchInfo.setObjectPlannerDefinitionTemplates(objectPlannerDefinitionTemplates);
        return searchInfo;
    }

    public boolean saveName(Long organisationPersonId, Long networkId, String name) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to save the name of network [" + networkId + "].  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        List existingNetworks = this.networkDAO.getAll();
        for (Network existingNetwork : existingNetworks) {
            if (existingNetwork.getId().longValue() == networkId.longValue() || !existingNetwork.getName().equals(name)) continue;
            return false;
        }
        Network network = (Network)this.networkDAO.get(networkId);
        network.setName(name);
        this.networkDAO.update(network);
        return true;
    }

    public boolean createNetwork(Long organisationPersonId, String name, Long maintainerOrganisationId) {
        Object documentType;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.INSERT_NETWORK);
        if (!actions.contains(Action.INSERT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to create network [" + name + "]. Reason: Missing privilege [" + Action.INSERT_NETWORK + "]");
        }
        List existingNetworks = this.networkDAO.getAll();
        for (Network network : existingNetworks) {
            if (!network.getName().equals(name)) continue;
            return false;
        }
        List networkTypes = this.networkTypeDAO.getAll();
        Long networkTypeId = null;
        for (NetworkType networkType : networkTypes) {
            if (networkType.getIsDefault() == null || !networkType.getIsDefault().booleanValue()) continue;
            networkTypeId = networkType.getId();
        }
        if (networkTypeId == null) {
            throw new RuntimeException("Cannot create Network, since no NetworkType is marked as default.");
        }
        Network network = new Network();
        network.setName(name);
        network.setSignatureCalculatorId(Long.valueOf(2L));
        network.setNetworkTypeId(networkTypeId);
        network.setMaintainerId(maintainerOrganisationId);
        network.setAmbiguousProjectCodes(Boolean.valueOf(false));
        network = (Network)this.networkDAO.save(network);
        Long networkId = network.getId();
        this.organisationService.addOrganisationToNetworks(organisationPersonId, maintainerOrganisationId, new ArrayList<Long>(Arrays.asList(networkId)));
        NetworkType networkType = (NetworkType)this.networkTypeDAO.get(networkTypeId);
        List<CdesRoleDefault> cdesRolesDefault = this.cdesRoleDefaultDAO.getByNetworkType(networkTypeId);
        HashMap<Long, ActionRule> actionRuleDefaultIdToActionRule = new HashMap<Long, ActionRule>();
        List actionRuleDefaults = this.actionRuleDefaultDAO.getAll();
        for (ActionRuleDefault actionRuleDefault : actionRuleDefaults) {
            ActionRule actionRule = new ActionRule();
            actionRule.setCheckMember(actionRuleDefault.getCheckMember());
            actionRule.setDestinationContextId(actionRuleDefault.getDestinationContextId());
            actionRule.setActionId(actionRuleDefault.getActionId());
            actionRule.setNetworkId(networkId);
            actionRule = (ActionRule)this.actionRuleDAO.save(actionRule);
            actionRuleDefaultIdToActionRule.put(actionRuleDefault.getId(), actionRule);
        }
        for (CdesRoleDefault cdesRoleDefault : cdesRolesDefault) {
            CdesRole cdesRole = new CdesRole();
            cdesRole.setName(cdesRoleDefault.getName());
            cdesRole.setDescription(cdesRoleDefault.getDescription());
            cdesRole.setNetworkId(networkId);
            cdesRole.setProjectFlag(cdesRoleDefault.getProjectFlag());
            cdesRole.setContextDefaultRoleFlag(Integer.valueOf(cdesRoleDefault.getContextDefaultRoleFlag() != null && cdesRoleDefault.getContextDefaultRoleFlag() != false ? 1 : 0));
            cdesRole.setCdesRoleDefaultId(cdesRoleDefault.getId());
            cdesRole.setTypeId(cdesRoleDefault.getRoleTypeId());
            cdesRole = (CdesRole)this.cdesRoleDAO.save(cdesRole);
            List<RoleDefaultActionRule> roleDefaultActionRules = this.roleDefaultActionRuleDAO.getByRoleDefault(cdesRoleDefault);
            for (RoleDefaultActionRule roleDefaultActionRule : roleDefaultActionRules) {
                RoleActionRule roleActionRule = new RoleActionRule();
                roleActionRule.setCdesRoleId(cdesRole.getId());
                Long actionDefaultRuleId = roleDefaultActionRule.getActionRuleDefaultId();
                roleActionRule.setActionRuleId(((ActionRule)actionRuleDefaultIdToActionRule.get(actionDefaultRuleId)).getId());
                roleActionRule = (RoleActionRule)this.roleActionRuleDAO.save(roleActionRule);
            }
        }
        MasterDataSet masterDataSet = new MasterDataSet();
        masterDataSet.setName("Standardsatz");
        masterDataSet.setDescription("Vorkonfigurierte Stammdaten");
        masterDataSet.setNetworkId(networkId);
        masterDataSet = (MasterDataSet)this.masterDataSetDAO.save(masterDataSet);
        Long masterDataSetId = masterDataSet.getId();
        List<ObjectTypeDefault> objectTypesDefault = this.objectTypeDefaultDAO.getByNetworkType(networkTypeId);
        List<Object> objectTypes = new ArrayList();
        for (ObjectTypeDefault objectTypeDefault : objectTypesDefault) {
            ObjectType objectType = new ObjectType();
            objectType.setCode(objectTypeDefault.getCode());
            objectType.setName(objectTypeDefault.getName());
            objectType.setComment(objectTypeDefault.getComment());
            objectType.setMasterDataSetId(masterDataSetId);
            objectType.setNetworkId(networkId);
            objectTypes.add(objectType);
        }
        objectTypes = this.objectTypeDAO.saveBatch(objectTypes);
        List<SubProjectTypeDefault> subProjectTypesDefault = this.subProjectTypeDefaultDAO.getByNetworkType(networkTypeId);
        List<Object> subProjectTypes = new ArrayList();
        for (SubProjectTypeDefault subProjectTypeDefault : subProjectTypesDefault) {
            SubProjectType subProjectType = new SubProjectType();
            subProjectType.setCode(subProjectTypeDefault.getCode());
            subProjectType.setName(subProjectTypeDefault.getName());
            subProjectType.setComment(subProjectTypeDefault.getComment());
            subProjectType.setIsAsBuiltType(subProjectTypeDefault.getIsAsBuiltType());
            subProjectType.setMasterDataSetId(masterDataSetId);
            subProjectType.setNetworkId(networkId);
            subProjectTypes.add(subProjectType);
        }
        subProjectTypes = this.subProjectTypeDAO.saveBatch(subProjectTypes);
        List<DocumentTypeDefault> documentTypesDefault = this.documentTypeDefaultDAO.getByNetworkType(networkTypeId);
        HashMap<Long, Object> groupIdToDocumentType = new HashMap<Long, Object>();
        for (DocumentTypeDefault documentTypeDefault : documentTypesDefault) {
            if (documentTypeDefault.getDocumentTypeGroupId() != null) continue;
            documentType = new DocumentType();
            documentType.setCode(documentTypeDefault.getCode());
            documentType.setName(documentTypeDefault.getName());
            documentType.setDescription(documentTypeDefault.getDescription());
            documentType.setNetworkId(networkId);
            documentType.setMasterDataSetId(masterDataSetId);
            documentType.setDocumentTypeGroupId(null);
            documentType = (DocumentType)this.documentTypeDAO.save(documentType);
            groupIdToDocumentType.put(documentTypeDefault.getId(), documentType);
        }
        for (DocumentTypeDefault documentTypeDefault : documentTypesDefault) {
            if (documentTypeDefault.getDocumentTypeGroupId() == null) continue;
            documentType = new DocumentType();
            documentType.setCode(documentTypeDefault.getCode());
            documentType.setName(documentTypeDefault.getName());
            documentType.setDescription(documentTypeDefault.getDescription());
            documentType.setNetworkId(networkId);
            documentType.setMasterDataSetId(masterDataSetId);
            documentType.setDocumentTypeGroupId(((DocumentType)groupIdToDocumentType.get(documentTypeDefault.getDocumentTypeGroupId())).getId());
            documentType = (DocumentType)this.documentTypeDAO.save(documentType);
        }
        List<PersonInCharge> oldPersonsInCharge = this.personInChargeDAO.getByNetworkType(networkTypeId);
        List<Object> newPersonsInCharge = new ArrayList();
        for (PersonInCharge personInCharge : oldPersonsInCharge) {
            PersonInCharge newPersonInCharge = new PersonInCharge();
            newPersonInCharge.setDescription(personInCharge.getDescription());
            newPersonInCharge.setName(personInCharge.getName());
            newPersonInCharge.setNetworkId(networkId);
            newPersonsInCharge.add(newPersonInCharge);
        }
        newPersonsInCharge = this.personInChargeDAO.saveBatch(newPersonsInCharge);
        List<StatutoryDuty> oldStatutoryDuties = this.statutoryDutyDAO.getByNetworkType(networkTypeId);
        List<Object> newStatutoryDuties = new ArrayList();
        for (StatutoryDuty statutoryDuty : oldStatutoryDuties) {
            StatutoryDuty newStatutoryDuty = new StatutoryDuty();
            newStatutoryDuty.setDescription(statutoryDuty.getDescription());
            newStatutoryDuty.setIsStatutoryDuty(statutoryDuty.getIsStatutoryDuty());
            newStatutoryDuty.setName(statutoryDuty.getName());
            newStatutoryDuty.setNetworkId(networkId);
            newStatutoryDuties.add(newStatutoryDuty);
        }
        newStatutoryDuties = this.statutoryDutyDAO.saveBatch(newStatutoryDuties);
        List<SubjectArea> oldSubjectAreas = this.subjectAreaDAO.getByNetworkType(networkTypeId);
        List<SubjectArea> newSubjectAreas = new ArrayList();
        for (SubjectArea subjectArea : oldSubjectAreas) {
            SubjectArea newSubjectArea = new SubjectArea();
            newSubjectArea.setDescription(subjectArea.getDescription());
            newSubjectArea.setName(subjectArea.getName());
            newSubjectArea.setNetworkId(networkId);
            newSubjectAreas.add(newSubjectArea);
        }
        newSubjectAreas = this.subjectAreaDAO.saveBatch(newSubjectAreas);
        List<DocumentNumberPartGroupDefault> documentNumberPartGroupsDefault = this.documentNumberPartGroupDefaultDAO.getByNetworkType(networkTypeId);
        for (DocumentNumberPartGroupDefault documentNumberPartGroupDefault : documentNumberPartGroupsDefault) {
            DocumentNumberPartGroup documentNumberPartGroup = new DocumentNumberPartGroup();
            documentNumberPartGroup.setName(documentNumberPartGroupDefault.getName());
            documentNumberPartGroup.setRendererName(documentNumberPartGroupDefault.getRendererName());
            documentNumberPartGroup.setNetworkId(networkId);
            documentNumberPartGroup.setMasterDataSetId(masterDataSetId);
            documentNumberPartGroup = (DocumentNumberPartGroup)this.documentNumberPartGroupDAO.save(documentNumberPartGroup);
            List<DocumentNumberPartDefault> documentNumberPartDefaults = this.documentNumberPartDefaultDAO.getByGroup(documentNumberPartGroupDefault.getId());
            for (DocumentNumberPartDefault documentNumberPartDefault : documentNumberPartDefaults) {
                DocumentNumberPart documentNumberPart = new DocumentNumberPart();
                documentNumberPart.setName(documentNumberPartDefault.getName());
                documentNumberPart.setSeperator(documentNumberPartDefault.getSeperator());
                documentNumberPart.setFormat(documentNumberPartDefault.getFormat());
                documentNumberPart.setOgnlRule(documentNumberPartDefault.getOgnlRule());
                documentNumberPart.setPosition(documentNumberPartDefault.getPosition());
                documentNumberPart.setLength(documentNumberPartDefault.getLength());
                documentNumberPart.setUniqueKey(documentNumberPartDefault.getUniqueKey());
                documentNumberPart.setFieldType(documentNumberPartDefault.getFieldType());
                documentNumberPart.setGroupId(documentNumberPartGroup.getId());
                documentNumberPart.setLength(documentNumberPartDefault.getLength());
                documentNumberPart = (DocumentNumberPart)this.documentNumberPartDAO.save(documentNumberPart);
            }
        }
        return true;
    }

    public void deleteNetwork(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.DELETE_NETWORK);
        if (!actions.contains(Action.DELETE_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to delete network [" + networkId + "]. Reason: Missing privilege [" + Action.DELETE_NETWORK + "]");
        }
        List<Project> projects = this.projectDAO.getByNetwork(networkId);
        for (Project project : projects) {
            this.projectService.deleteProject(organisationPersonId, project.getId());
        }
        this.networkPersonDAO.deleteByNetwork(networkId);
        this.networkOrganisationDAO.deleteByNetwork(networkId);
        List<DocumentNumberPart> documentNumberParts = this.documentNumberPartDAO.getByNetworkId(networkId);
        List<Long> documentNumberPartIds = ContainerHelper.getPersistentIdsList(documentNumberParts);
        this.documentNumberPartDAO.deleteBatch(documentNumberPartIds);
        this.documentNumberPartGroupDAO.deleteByNetwork(networkId);
        List<NetworkObjectPlannerDefinition> objectPlannerDefinitions = this.networkObjectPlannerDefinitionDAO.getByNetwork(networkId);
        for (NetworkObjectPlannerDefinition networkObjectPlannerDefinition : objectPlannerDefinitions) {
            this.networkObjectPlannerDefinitionDAO.deleteInstance(networkObjectPlannerDefinition.getObjectPlannerDefinitionId(), networkObjectPlannerDefinition.getNetworkId());
        }
        List<NetworkReviewCycle> networkReviewCycles = this.networkReviewCycleDAO.getByNetwork(networkId);
        for (NetworkReviewCycle networkReviewCycle : networkReviewCycles) {
            this.networkReviewCycleDAO.deleteInstance(networkReviewCycle.getReviewCycleId(), networkReviewCycle.getNetworkId());
        }
        this.subProjectTypeDAO.deleteByNetworkId(networkId);
        this.objectTypeDAO.deleteByNetworkId(networkId);
        this.documentTypeDAO.deleteByNetworkId(networkId);
        this.masterDataSetDAO.deleteByNetwork(networkId);
        List<RoleActionRule> list = this.roleActionRuleDAO.getByNetwork(networkId);
        for (RoleActionRule roleActionRule : list) {
            this.roleActionRuleDAO.deleteByRoleAndRule(roleActionRule.getCdesRoleId(), roleActionRule.getActionRuleId());
        }
        this.cdesRoleDAO.deleteByNetworkId(networkId);
        this.actionRuleDAO.deleteByNetworkId(networkId);
        this.personInChargeDAO.deleteByNetworkId(networkId);
        this.subjectAreaDAO.deleteByNetworkId(networkId);
        this.statutoryDutyDAO.deleteByNetworkId(networkId);
        this.networkDAO.delete(networkId);
    }

    public void addAdministrator(Long organisationPersonId, Long networkId, Long administratorOrganisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to add administrator [" + administratorOrganisationPersonId + "] to network [" + networkId + "].  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        CdesRoleDefault adminRoleDefault = this.cdesRoleDefaultDAO.getNetworkAdminCdesRoleDefault(networkId);
        Long adminRoleDefaultId = adminRoleDefault.getId();
        CdesRole adminRole = this.cdesRoleDAO.getByNetworkAndDefaultId(networkId, adminRoleDefaultId);
        if (adminRole == null) {
            adminRole = new CdesRole();
            adminRole.setDescription(adminRoleDefault.getDescription());
            adminRole.setName(adminRoleDefault.getName());
            adminRole.setProjectFlag(adminRoleDefault.getProjectFlag());
            adminRole.setCdesRoleDefaultId(adminRoleDefault.getId());
            adminRole.setTypeId(adminRoleDefault.getRoleTypeId());
            boolean contextDefaultRoleFlag = adminRoleDefault.getContextDefaultRoleFlag() != null && adminRoleDefault.getContextDefaultRoleFlag() != false;
            adminRole.setContextDefaultRoleFlag(Integer.valueOf(contextDefaultRoleFlag ? 1 : 0));
            adminRole.setNetworkId(networkId);
            adminRole = (CdesRole)this.cdesRoleDAO.save(adminRole);
        }
        List<NetworkPerson> networkPersons = this.networkPersonDAO.getByNetwork(networkId);
        boolean found = false;
        for (NetworkPerson networkPerson : networkPersons) {
            if (networkPerson.getRoleId() == null || networkPerson.getRoleId().longValue() != adminRole.getId().longValue() || networkPerson.getOrganisationPersonId() == null || networkPerson.getOrganisationPersonId().longValue() != administratorOrganisationPersonId.longValue()) continue;
            found = true;
        }
        if (!found) {
            NetworkPerson networkPerson = new NetworkPerson();
            networkPerson.setNetworkId(networkId);
            networkPerson.setMainPerson(Boolean.valueOf(false));
            networkPerson.setRoleId(adminRole.getId());
            networkPerson.setOrganisationPersonId(administratorOrganisationPersonId);
            networkPerson = (NetworkPerson)this.networkPersonDAO.save(networkPerson);
            OrganisationPerson administratorOrganisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(administratorOrganisationPersonId);
            Long administratorOrganisationPersonOrganisationId = administratorOrganisationPerson.getOrganisationId();
            List<OrganisationJoin> networkOrganisationJoins = this.organisationDAO.getNetworkOrganisationJoins(new ArrayList<Long>(Arrays.asList(networkId)), false);
            boolean isMember = false;
            for (OrganisationJoin networkOrganisationJoin : networkOrganisationJoins) {
                if (!networkOrganisationJoin.getOrganisationId().equals(administratorOrganisationPersonOrganisationId)) continue;
                isMember = true;
            }
            if (!isMember) {
                this.organisationService.addOrganisationToNetworks(organisationPersonId, administratorOrganisationPersonOrganisationId, new ArrayList<Long>(Arrays.asList(networkId)));
            }
        }
    }

    public void removeAdministrator(Long organisationPersonId, Long networkPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to remove administrator NetworkPerson [" + networkPersonId + "].  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        this.networkPersonDAO.delete(networkPersonId);
    }

    public void addCycle(Long organisationPersonId, Long networkId, Long cycleId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to add ReviewCycle [" + cycleId + "] to network [" + networkId + "].  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        List<NetworkReviewCycle> allNetworkReviewCycles = this.networkReviewCycleDAO.getByNetwork(networkId);
        boolean found = false;
        for (NetworkReviewCycle networkReviewCycle : allNetworkReviewCycles) {
            if (networkReviewCycle.getReviewCycleId().longValue() != cycleId.longValue()) continue;
            found = true;
        }
        if (!found) {
            NetworkReviewCycle networkReviewCycle = new NetworkReviewCycle();
            networkReviewCycle.setNetworkId(networkId);
            networkReviewCycle.setReviewCycleId(cycleId);
            this.networkReviewCycleDAO.save(networkReviewCycle);
        }
    }

    public void removeCycle(Long organisationPersonId, Long networkId, Long cycleId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to remove ReviewCycle [" + cycleId + "] from network [" + networkId + "].  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        this.networkReviewCycleDAO.deleteInstance(cycleId, networkId);
    }

    public void addObjectPlannerDefinitionTemplate(Long organisationPersonId, Long networkId, Long templateId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to add ObjectPlannerDefinitionTemplate [" + templateId + "] to network [" + networkId + "].  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        List<NetworkObjectPlannerDefinition> allNetworkObjectPlannerDefinitions = this.networkObjectPlannerDefinitionDAO.getByNetwork(networkId);
        boolean found = false;
        for (NetworkObjectPlannerDefinition networkObjectPlannerDefinition : allNetworkObjectPlannerDefinitions) {
            if (networkObjectPlannerDefinition.getObjectPlannerDefinitionId().longValue() != templateId.longValue()) continue;
            found = true;
        }
        if (!found) {
            NetworkObjectPlannerDefinition networkObjectPlannerDefinition = new NetworkObjectPlannerDefinition();
            networkObjectPlannerDefinition.setNetworkId(networkId);
            networkObjectPlannerDefinition.setObjectPlannerDefinitionId(templateId);
            this.networkObjectPlannerDefinitionDAO.save(networkObjectPlannerDefinition);
        }
    }

    public void removeObjectPlannerDefinitionTemplate(Long organisationPersonId, Long networkId, Long templateId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NETWORK);
        if (!actions.contains(Action.EDIT_NETWORK)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to remove ObjectPlannerDefinitionTemplate [" + templateId + "] from network [" + networkId + "].  Reason: Missing privilege [" + Action.EDIT_NETWORK + "]");
        }
        this.networkObjectPlannerDefinitionDAO.deleteInstance(templateId, networkId);
    }

    public MasterDataPageInfo getMasterDataPageInfo(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId, Action.DOCUMENT_TYPES_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not query MasterDataSet data, privilege [" + Action.DOCUMENT_TYPES_OVERVIEW + "] is missing.");
        }
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE, Action.EDIT_NUMBER_FORMAT);
        MasterDataPageInfo pageInfo = new MasterDataPageInfo();
        Map<Long, List<MasterDataItem>> msIdToDocumentTypeItems = this.getMsIdToDocumentTypeItems(networkId);
        pageInfo.setMsIdToDocumentTypeItems(msIdToDocumentTypeItems);
        Map<Long, List<MasterDataItem>> msIdToSubProjectTypeItems = this.getMsIdToSubProjectTypeItems(networkId);
        pageInfo.setMsIdToSubProjectTypeItems(msIdToSubProjectTypeItems);
        Map<Long, List<MasterDataItem>> msIdToObjectTypeItems = this.getMsIdToObjectTypeItems(networkId);
        pageInfo.setMsIdToObjectTypeItems(msIdToObjectTypeItems);
        Map<Long, List<MasterDataItem>> msIdToDocumentNumberPartItems = this.getMsIdToDocumentNumberPartItems(networkId);
        pageInfo.setMsIdToDocumentNumberPartItems(msIdToDocumentNumberPartItems);
        List<MasterDataItem> statutoryDutyItems = this.getStatutoryDutyItems(networkId);
        pageInfo.setStatutoryDutyItems(statutoryDutyItems);
        List<MasterDataItem> personInChargeItems = this.getPersonInChargeItems(networkId);
        pageInfo.setPersonInChargeItems(personInChargeItems);
        List<MasterDataItem> subjectAreaItems = this.getSubjectAreaItems(networkId);
        pageInfo.setSubjectAreaItems(subjectAreaItems);
        pageInfo.setEnableCustomerLogo(this.enableCustomerLogo);
        boolean mayEditDocumentTypes = this.useDocumentSubtypes == null || this.useDocumentSubtypes == 0L ? false : (this.useDocumentSubtypes == 1L ? true : this.useDocumentSubtypes.longValue() == networkId.longValue());
        List<MasterDataSet> masterDataSets = this.masterDataSetDAO.getByNetwork(networkId);
        pageInfo.setMasterDataSets(masterDataSets);
        pageInfo.setMayEditDocumentTypes(mayEditDocumentTypes);
        pageInfo.setMayEditDocumentNumberParts(actions.contains(Action.EDIT_NUMBER_FORMAT));
        pageInfo.setMayEditOthers(actions.contains(Action.EDIT_DOCUMENT_TYPE));
        return pageInfo;
    }

    private Map<Long, List<MasterDataItem>> getMsIdToDocumentTypeItems(Long networkId) {
        HashMap<Long, List<MasterDataItem>> msIdToDocumentTypeItems = new HashMap<Long, List<MasterDataItem>>();
        List<DocumentType> documentTypes = this.documentTypeDAO.getByNetwork(networkId);
        for (DocumentType documentType : documentTypes) {
            Long msId = documentType.getMasterDataSetId();
            if (!msIdToDocumentTypeItems.containsKey(msId)) {
                msIdToDocumentTypeItems.put(msId, new ArrayList());
            }
            MasterDataItem masterDataItem = this.constructMasterDataItemByDocumentType(documentType);
            ((List)msIdToDocumentTypeItems.get(msId)).add(masterDataItem);
        }
        return msIdToDocumentTypeItems;
    }

    private MasterDataItem constructMasterDataItemByDocumentType(DocumentType documentType) {
        MasterDataItem masterDataItem = new MasterDataItem();
        masterDataItem.setId(documentType.getId());
        masterDataItem.setCode(documentType.getCode());
        masterDataItem.setName(documentType.getName());
        masterDataItem.setDescription(documentType.getDescription());
        masterDataItem.setParentId(documentType.getDocumentTypeGroupId());
        return masterDataItem;
    }

    private List<MasterDataItem> getDocumentTypeItems(Long masterDataSetId) {
        ArrayList<MasterDataItem> masterDataItems = new ArrayList<MasterDataItem>();
        List<DocumentType> documentTypes = this.documentTypeDAO.getByMasterDataSet(masterDataSetId);
        for (DocumentType documentType : documentTypes) {
            MasterDataItem masterDataItem = this.constructMasterDataItemByDocumentType(documentType);
            masterDataItems.add(masterDataItem);
        }
        return masterDataItems;
    }

    private Map<Long, List<MasterDataItem>> getMsIdToSubProjectTypeItems(Long networkId) {
        HashMap<Long, List<MasterDataItem>> msIdToSubProjectTypeItems = new HashMap<Long, List<MasterDataItem>>();
        List<SubProjectType> subProjectTypes = this.subProjectTypeDAO.getByNetwork(networkId);
        for (SubProjectType subProjectType : subProjectTypes) {
            Long msId = subProjectType.getMasterDataSetId();
            if (!msIdToSubProjectTypeItems.containsKey(msId)) {
                msIdToSubProjectTypeItems.put(msId, new ArrayList());
            }
            MasterDataItem masterDataItem = this.constructMasterDataItemBySubProjectType(subProjectType);
            ((List)msIdToSubProjectTypeItems.get(msId)).add(masterDataItem);
        }
        return msIdToSubProjectTypeItems;
    }

    private MasterDataItem constructMasterDataItemBySubProjectType(SubProjectType subProjectType) {
        MasterDataItem masterDataItem = new MasterDataItem();
        masterDataItem.setId(subProjectType.getId());
        masterDataItem.setCode(subProjectType.getCode());
        masterDataItem.setName(subProjectType.getName());
        masterDataItem.setDescription(subProjectType.getComment());
        return masterDataItem;
    }

    private List<MasterDataItem> getSubProjectTypeItems(Long masterDataSetId) {
        ArrayList<MasterDataItem> masterDataItems = new ArrayList<MasterDataItem>();
        List<SubProjectType> subProjectTypes = this.subProjectTypeDAO.getByMasterDataSet(masterDataSetId);
        for (SubProjectType subProjectType : subProjectTypes) {
            MasterDataItem masterDataItem = this.constructMasterDataItemBySubProjectType(subProjectType);
            masterDataItems.add(masterDataItem);
        }
        return masterDataItems;
    }

    private Map<Long, List<MasterDataItem>> getMsIdToObjectTypeItems(Long networkId) {
        HashMap<Long, List<MasterDataItem>> msIdToObjectTypeItems = new HashMap<Long, List<MasterDataItem>>();
        List<ObjectType> objectTypes = this.objectTypeDAO.getByNetwork(networkId);
        for (ObjectType objectType : objectTypes) {
            Long msId = objectType.getMasterDataSetId();
            if (!msIdToObjectTypeItems.containsKey(msId)) {
                msIdToObjectTypeItems.put(msId, new ArrayList());
            }
            MasterDataItem masterDataItem = this.constructMasterDataItemByObjectType(objectType);
            ((List)msIdToObjectTypeItems.get(msId)).add(masterDataItem);
        }
        return msIdToObjectTypeItems;
    }

    private MasterDataItem constructMasterDataItemByObjectType(ObjectType objectType) {
        MasterDataItem masterDataItem = new MasterDataItem();
        masterDataItem.setId(objectType.getId());
        masterDataItem.setCode(objectType.getCode());
        masterDataItem.setName(objectType.getName());
        masterDataItem.setDescription(objectType.getComment());
        return masterDataItem;
    }

    private List<MasterDataItem> getObjectTypeItems(Long masterDataSetId) {
        ArrayList<MasterDataItem> masterDataItems = new ArrayList<MasterDataItem>();
        List<ObjectType> objectTypes = this.objectTypeDAO.getByMasterDataSet(masterDataSetId);
        for (ObjectType objectType : objectTypes) {
            MasterDataItem masterDataItem = this.constructMasterDataItemByObjectType(objectType);
            masterDataItems.add(masterDataItem);
        }
        return masterDataItems;
    }

    private Map<Long, List<MasterDataItem>> getMsIdToDocumentNumberPartItems(Long networkId) {
        HashMap<Long, List<MasterDataItem>> msIdToDocumentNumberPartItems = new HashMap<Long, List<MasterDataItem>>();
        List<DocumentNumberPartGroup> documentNumberPartGroups = this.documentNumberPartGroupDAO.getByNetwork(networkId);
        for (DocumentNumberPartGroup documentNumberPartGroup : documentNumberPartGroups) {
            Long msId = documentNumberPartGroup.getMasterDataSetId();
            if (!msIdToDocumentNumberPartItems.containsKey(msId)) {
                msIdToDocumentNumberPartItems.put(msId, new ArrayList());
            }
            MasterDataItem masterDataItem = new MasterDataItem();
            masterDataItem.setId(documentNumberPartGroup.getId());
            masterDataItem.setName(documentNumberPartGroup.getName());
            ((List)msIdToDocumentNumberPartItems.get(msId)).add(masterDataItem);
        }
        return msIdToDocumentNumberPartItems;
    }

    private List<MasterDataItem> getStatutoryDutyItems(Long networkId) {
        ArrayList<MasterDataItem> masterDataItems = new ArrayList<MasterDataItem>();
        List<StatutoryDuty> statutoryDuties = this.statutoryDutyDAO.getByNetwork(networkId);
        for (StatutoryDuty statutoryDuty : statutoryDuties) {
            MasterDataItem masterDataItem = new MasterDataItem();
            masterDataItem.setId(statutoryDuty.getId());
            masterDataItem.setName(statutoryDuty.getName());
            masterDataItem.setDescription(statutoryDuty.getDescription());
            masterDataItems.add(masterDataItem);
        }
        return masterDataItems;
    }

    private List<MasterDataItem> getPersonInChargeItems(Long networkId) {
        ArrayList<MasterDataItem> masterDataItems = new ArrayList<MasterDataItem>();
        List<PersonInCharge> personInCharges = this.personInChargeDAO.getByNetwork(networkId);
        for (PersonInCharge personInCharge : personInCharges) {
            MasterDataItem masterDataItem = new MasterDataItem();
            masterDataItem.setId(personInCharge.getId());
            masterDataItem.setName(personInCharge.getName());
            masterDataItem.setDescription(personInCharge.getDescription());
            masterDataItems.add(masterDataItem);
        }
        return masterDataItems;
    }

    private List<MasterDataItem> getSubjectAreaItems(Long networkId) {
        ArrayList<MasterDataItem> masterDataItems = new ArrayList<MasterDataItem>();
        List<SubjectArea> subjectAreas = this.subjectAreaDAO.getByNetwork(networkId);
        for (SubjectArea subjectArea : subjectAreas) {
            MasterDataItem masterDataItem = new MasterDataItem();
            masterDataItem.setId(subjectArea.getId());
            masterDataItem.setName(subjectArea.getName());
            masterDataItem.setDescription(subjectArea.getDescription());
            masterDataItems.add(masterDataItem);
        }
        return masterDataItems;
    }

    private void checkSaveMasterDataSecurity(Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("Saving master data is not allowed for organisationPersonId [" + organisationPersonId + "], privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
    }

    private Set<Long> getItemIdsFromClient(List<MasterDataItem> items) {
        HashSet<Long> itemIds = new HashSet<Long>();
        for (MasterDataItem item : items) {
            itemIds.add(item.getId());
        }
        return itemIds;
    }

    private Long getNetworkIdByMasterDataSetId(Long masterDataSetId) {
        MasterDataSet masterDataSet = (MasterDataSet)this.masterDataSetDAO.get(masterDataSetId);
        return masterDataSet.getNetworkId();
    }

    private Set<Long> getIdsToDelete(List<MasterDataItem> items, Map<Long, ? extends Persistent> idToPersistent) {
        HashSet<Long> toDelete = new HashSet<Long>();
        Set<Long> itemIdsFromClient = this.getItemIdsFromClient(items);
        for (Persistent persistent : idToPersistent.values()) {
            Long persistentId = persistent.getId();
            if (itemIdsFromClient.contains(persistentId)) continue;
            toDelete.add(persistentId);
        }
        return toDelete;
    }

    public void saveDocumentTypes(Long organisationPersonId, Long masterDataSetId, List<MasterDataItem> items) {
        this.checkSaveMasterDataSecurity(organisationPersonId);
        Long networkId = this.getNetworkIdByMasterDataSetId(masterDataSetId);
        List<DocumentType> oldDocumentTypes = this.documentTypeDAO.getByMasterDataSet(masterDataSetId);
        HashMap<Long, DocumentType> idToDocumentType = new HashMap<Long, DocumentType>();
        for (DocumentType oldDocumentType : oldDocumentTypes) {
            if (oldDocumentType.getDocumentTypeGroupId() != null) continue;
            idToDocumentType.put(oldDocumentType.getId(), oldDocumentType);
        }
        ArrayList<DocumentType> toSave = new ArrayList<DocumentType>();
        ArrayList<DocumentType> toUpdate = new ArrayList<DocumentType>();
        for (MasterDataItem item : items) {
            Long id = item.getId();
            DocumentType documentType = idToDocumentType.containsKey(id) ? (DocumentType)idToDocumentType.get(id) : new DocumentType();
            this.copyItemToDocumentType(item, documentType);
            if (idToDocumentType.containsKey(id)) {
                toUpdate.add(documentType);
                continue;
            }
            documentType.setMasterDataSetId(masterDataSetId);
            documentType.setNetworkId(networkId);
            toSave.add(documentType);
        }
        Set<Long> toDelete = this.getIdsToDelete(items, idToDocumentType);
        for (Long idToDelete : toDelete) {
            List<DocumentType> subTypes = this.documentTypeDAO.getByDocumentTypeGroup(idToDelete);
            for (DocumentType subType : subTypes) {
                this.documentTypeDAO.delete(subType.getId());
            }
        }
        this.documentTypeDAO.saveBatch(toSave);
        this.documentTypeDAO.updateBatch(toUpdate);
        this.documentTypeDAO.deleteBatch(toDelete);
    }

    private void copyItemToDocumentType(MasterDataItem item, DocumentType documentType) {
        documentType.setCode(item.getCode());
        documentType.setName(item.getName());
        documentType.setDescription(item.getDescription());
    }

    public void saveSubProjectTypes(Long organisationPersonId, Long masterDataSetId, List<MasterDataItem> items) {
        this.checkSaveMasterDataSecurity(organisationPersonId);
        Long networkId = this.getNetworkIdByMasterDataSetId(masterDataSetId);
        List<SubProjectType> oldSubProjectTypes = this.subProjectTypeDAO.getByMasterDataSet(masterDataSetId);
        Map<Long, SubProjectType> idToSubProjectType = ContainerHelper.groupById(oldSubProjectTypes);
        ArrayList<SubProjectType> toSave = new ArrayList<SubProjectType>();
        ArrayList<SubProjectType> toUpdate = new ArrayList<SubProjectType>();
        for (MasterDataItem item : items) {
            Long id = item.getId();
            SubProjectType subProjectType = idToSubProjectType.containsKey(id) ? idToSubProjectType.get(id) : new SubProjectType();
            this.copyItemToSubProjectType(item, subProjectType);
            if (idToSubProjectType.containsKey(id)) {
                toUpdate.add(subProjectType);
                continue;
            }
            subProjectType.setMasterDataSetId(masterDataSetId);
            subProjectType.setNetworkId(networkId);
            subProjectType.setIsAsBuiltType(Boolean.valueOf(false));
            toSave.add(subProjectType);
        }
        Set<Long> toDelete = this.getIdsToDelete(items, idToSubProjectType);
        this.subProjectTypeDAO.saveBatch(toSave);
        this.subProjectTypeDAO.updateBatch(toUpdate);
        this.subProjectTypeDAO.deleteBatch(toDelete);
    }

    private void copyItemToSubProjectType(MasterDataItem item, SubProjectType subProjectType) {
        subProjectType.setCode(item.getCode());
        subProjectType.setName(item.getName());
        subProjectType.setComment(item.getDescription());
    }

    public void saveObjectTypes(Long organisationPersonId, Long masterDataSetId, List<MasterDataItem> items) {
        this.checkSaveMasterDataSecurity(organisationPersonId);
        Long networkId = this.getNetworkIdByMasterDataSetId(masterDataSetId);
        List<ObjectType> oldObjectTypes = this.objectTypeDAO.getByMasterDataSet(masterDataSetId);
        Map<Long, ObjectType> idToObjectType = ContainerHelper.groupById(oldObjectTypes);
        ArrayList<ObjectType> toSave = new ArrayList<ObjectType>();
        ArrayList<ObjectType> toUpdate = new ArrayList<ObjectType>();
        for (MasterDataItem item : items) {
            Long id = item.getId();
            ObjectType objectType = idToObjectType.containsKey(id) ? idToObjectType.get(id) : new ObjectType();
            this.copyItemToObjectType(item, objectType);
            if (idToObjectType.containsKey(id)) {
                toUpdate.add(objectType);
                continue;
            }
            objectType.setMasterDataSetId(masterDataSetId);
            objectType.setNetworkId(networkId);
            toSave.add(objectType);
        }
        Set<Long> toDelete = this.getIdsToDelete(items, idToObjectType);
        this.objectTypeDAO.saveBatch(toSave);
        this.objectTypeDAO.updateBatch(toUpdate);
        this.objectTypeDAO.deleteBatch(toDelete);
    }

    private void copyItemToObjectType(MasterDataItem item, ObjectType objectType) {
        objectType.setCode(item.getCode());
        objectType.setName(item.getName());
        objectType.setComment(item.getDescription());
    }

    public void saveDocumentNumberPartGroups(Long organisationPersonId, Long masterDataSetId, List<MasterDataItem> items) {
        this.checkSaveMasterDataSecurity(organisationPersonId);
        Long networkId = this.getNetworkIdByMasterDataSetId(masterDataSetId);
        List<DocumentNumberPartGroup> oldDocumentNumberPartGroups = this.documentNumberPartGroupDAO.getByMasterDataSet(masterDataSetId);
        Map<Long, DocumentNumberPartGroup> idToDocumentNumberPartGroup = ContainerHelper.groupById(oldDocumentNumberPartGroups);
        ArrayList<DocumentNumberPartGroup> toSave = new ArrayList<DocumentNumberPartGroup>();
        ArrayList<DocumentNumberPartGroup> toUpdate = new ArrayList<DocumentNumberPartGroup>();
        for (MasterDataItem item : items) {
            Long id = item.getId();
            DocumentNumberPartGroup documentNumberPartGroup = idToDocumentNumberPartGroup.containsKey(id) ? idToDocumentNumberPartGroup.get(id) : new DocumentNumberPartGroup();
            this.copyItemToDocumentNumberPartGroup(item, documentNumberPartGroup);
            if (idToDocumentNumberPartGroup.containsKey(id)) {
                toUpdate.add(documentNumberPartGroup);
                continue;
            }
            documentNumberPartGroup.setMasterDataSetId(masterDataSetId);
            documentNumberPartGroup.setNetworkId(networkId);
            documentNumberPartGroup.setRendererName("Standard");
            toSave.add(documentNumberPartGroup);
        }
        Set<Long> toDelete = this.getIdsToDelete(items, idToDocumentNumberPartGroup);
        for (Long idToDelete : toDelete) {
            List<DocumentNumberPart> documentNumberParts = this.documentNumberPartDAO.getByGroup(idToDelete);
            for (DocumentNumberPart documentNumberPart : documentNumberParts) {
                this.documentNumberPartDAO.delete(documentNumberPart.getId());
            }
        }
        this.documentNumberPartGroupDAO.saveBatch(toSave);
        this.documentNumberPartGroupDAO.updateBatch(toUpdate);
        this.documentNumberPartGroupDAO.deleteBatch(toDelete);
    }

    private void copyItemToDocumentNumberPartGroup(MasterDataItem item, DocumentNumberPartGroup documentNumberPartGroup) {
        documentNumberPartGroup.setName(item.getName());
    }

    public void saveStatutoryDuties(Long organisationPersonId, Long networkId, List<MasterDataItem> items) {
        this.checkSaveMasterDataSecurity(organisationPersonId);
        List<StatutoryDuty> oldStatutoryDuties = this.statutoryDutyDAO.getByNetwork(networkId);
        Map<Long, StatutoryDuty> idToStatutoryDuty = ContainerHelper.groupById(oldStatutoryDuties);
        ArrayList<StatutoryDuty> toSave = new ArrayList<StatutoryDuty>();
        ArrayList<StatutoryDuty> toUpdate = new ArrayList<StatutoryDuty>();
        for (MasterDataItem item : items) {
            Long id = item.getId();
            StatutoryDuty statutoryDuty = idToStatutoryDuty.containsKey(id) ? idToStatutoryDuty.get(id) : new StatutoryDuty();
            this.copyItemToStatutoryDuty(item, statutoryDuty);
            if (idToStatutoryDuty.containsKey(id)) {
                toUpdate.add(statutoryDuty);
                continue;
            }
            statutoryDuty.setNetworkId(networkId);
            toSave.add(statutoryDuty);
        }
        Set<Long> toDelete = this.getIdsToDelete(items, idToStatutoryDuty);
        this.statutoryDutyDAO.saveBatch(toSave);
        this.statutoryDutyDAO.updateBatch(toUpdate);
        this.statutoryDutyDAO.deleteBatch(toDelete);
    }

    private void copyItemToStatutoryDuty(MasterDataItem item, StatutoryDuty statutoryDuty) {
        statutoryDuty.setName(item.getName());
        statutoryDuty.setDescription(item.getDescription());
    }

    public void saveSubjectAreas(Long organisationPersonId, Long networkId, List<MasterDataItem> items) {
        this.checkSaveMasterDataSecurity(organisationPersonId);
        List<SubjectArea> oldSubjectAreas = this.subjectAreaDAO.getByNetwork(networkId);
        Map<Long, SubjectArea> idToSubjectArea = ContainerHelper.groupById(oldSubjectAreas);
        ArrayList<SubjectArea> toSave = new ArrayList<SubjectArea>();
        ArrayList<SubjectArea> toUpdate = new ArrayList<SubjectArea>();
        for (MasterDataItem item : items) {
            Long id = item.getId();
            SubjectArea subjectArea = idToSubjectArea.containsKey(id) ? idToSubjectArea.get(id) : new SubjectArea();
            this.copyItemToSubjectArea(item, subjectArea);
            if (idToSubjectArea.containsKey(id)) {
                toUpdate.add(subjectArea);
                continue;
            }
            subjectArea.setNetworkId(networkId);
            toSave.add(subjectArea);
        }
        Set<Long> toDelete = this.getIdsToDelete(items, idToSubjectArea);
        this.subjectAreaDAO.saveBatch(toSave);
        this.subjectAreaDAO.updateBatch(toUpdate);
        this.subjectAreaDAO.deleteBatch(toDelete);
    }

    private void copyItemToSubjectArea(MasterDataItem item, SubjectArea subjectArea) {
        subjectArea.setName(item.getName());
        subjectArea.setDescription(item.getDescription());
    }

    public void savePersonInCharges(Long organisationPersonId, Long networkId, List<MasterDataItem> items) {
        this.checkSaveMasterDataSecurity(organisationPersonId);
        List<PersonInCharge> oldPersonInCharges = this.personInChargeDAO.getByNetwork(networkId);
        Map<Long, PersonInCharge> idToPersonInCharge = ContainerHelper.groupById(oldPersonInCharges);
        ArrayList<PersonInCharge> toSave = new ArrayList<PersonInCharge>();
        ArrayList<PersonInCharge> toUpdate = new ArrayList<PersonInCharge>();
        for (MasterDataItem item : items) {
            Long id = item.getId();
            PersonInCharge personInCharge = idToPersonInCharge.containsKey(id) ? idToPersonInCharge.get(id) : new PersonInCharge();
            this.copyItemToPersonInCharge(item, personInCharge);
            if (idToPersonInCharge.containsKey(id)) {
                toUpdate.add(personInCharge);
                continue;
            }
            personInCharge.setNetworkId(networkId);
            toSave.add(personInCharge);
        }
        Set<Long> toDelete = this.getIdsToDelete(items, idToPersonInCharge);
        this.personInChargeDAO.saveBatch(toSave);
        this.personInChargeDAO.updateBatch(toUpdate);
        this.personInChargeDAO.deleteBatch(toDelete);
    }

    private void copyItemToPersonInCharge(MasterDataItem item, PersonInCharge personInCharge) {
        personInCharge.setName(item.getName());
        personInCharge.setDescription(item.getDescription());
    }

    private void sortItemsByCode(List<MasterDataItem> items) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(items, new Comparator<MasterDataItem>(){

            @Override
            public int compare(MasterDataItem itemOne, MasterDataItem itemTwo) {
                String codeOne = itemOne.getCode();
                String codeTwo = itemTwo.getCode();
                return CompareHelper.defaultStringCompare(collator, codeOne, codeTwo, false);
            }
        });
    }

    private void sortItemsByName(List<MasterDataItem> items) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(items, new Comparator<MasterDataItem>(){

            @Override
            public int compare(MasterDataItem itemOne, MasterDataItem itemTwo) {
                String nameOne = itemOne.getName();
                String nameTwo = itemTwo.getName();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, false);
            }
        });
    }

    public void createMasterDataSet(Long organisationPersonId, Long networkId, String name, String description) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not create master data set, privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
        MasterDataSet masterDataSet = new MasterDataSet();
        masterDataSet.setName(name);
        masterDataSet.setDescription(description);
        masterDataSet.setNetworkId(networkId);
        masterDataSet = (MasterDataSet)this.masterDataSetDAO.save(masterDataSet);
    }

    public void createNewDefaultMasterDataSet(Long organisationPersonId, Long networkId, String name, String description) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not create master data set, privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
        MasterDataSet masterDataSet = new MasterDataSet();
        masterDataSet.setName(name);
        masterDataSet.setDescription(description);
        masterDataSet.setNetworkId(networkId);
        masterDataSet = (MasterDataSet)this.masterDataSetDAO.save(masterDataSet);
        Long masterDataSetId = masterDataSet.getId();
        Network network = (Network)this.networkDAO.get(networkId);
        Long networkTypeId = network.getNetworkTypeId();
        List<DocumentTypeDefault> documentTypesDefault = this.documentTypeDefaultDAO.getByNetworkType(networkTypeId);
        HashMap parentIdToTypes = new HashMap();
        for (DocumentTypeDefault documentTypeDefault : documentTypesDefault) {
            if (documentTypeDefault.getDocumentTypeGroupId() == null) continue;
            if (!parentIdToTypes.containsKey(documentTypeDefault.getId())) {
                parentIdToTypes.put(documentTypeDefault.getId(), new ArrayList());
            }
            ((List)parentIdToTypes.get(documentTypeDefault.getId())).add(documentTypeDefault);
        }
        for (DocumentTypeDefault documentTypeDefault : documentTypesDefault) {
            Long parentIdDefault = documentTypeDefault.getId();
            if (documentTypeDefault.getDocumentTypeGroupId() != null) continue;
            DocumentType parentDocumentType = this.constructDocumentTypeByDefault(documentTypeDefault, masterDataSet, network, null);
            List childDefaultTypes = parentIdToTypes.containsKey(parentIdDefault) ? (List)parentIdToTypes.get(parentIdDefault) : new ArrayList();
            for (DocumentTypeDefault childDefaultType : childDefaultTypes) {
                this.constructDocumentTypeByDefault(childDefaultType, masterDataSet, network, parentDocumentType.getId());
            }
        }
        List<SubProjectTypeDefault> subProjectTypesDefault = this.subProjectTypeDefaultDAO.getByNetworkType(networkTypeId);
        for (SubProjectTypeDefault subProjectTypeDefault : subProjectTypesDefault) {
            SubProjectType subProjectType = new SubProjectType();
            subProjectType.setCode(subProjectTypeDefault.getCode());
            subProjectType.setName(subProjectTypeDefault.getName());
            subProjectType.setComment(subProjectTypeDefault.getComment());
            subProjectType.setMasterDataSetId(masterDataSetId);
            subProjectType.setNetworkId(networkId);
            subProjectType.setIsAsBuiltType(subProjectTypeDefault.getIsAsBuiltType());
            subProjectType = (SubProjectType)this.subProjectTypeDAO.save(subProjectType);
        }
        List<ObjectTypeDefault> list = this.objectTypeDefaultDAO.getByNetworkType(networkTypeId);
        for (ObjectTypeDefault objectTypeDefault : list) {
            ObjectType objectType = new ObjectType();
            objectType.setCode(objectTypeDefault.getCode());
            objectType.setName(objectTypeDefault.getName());
            objectType.setComment(objectTypeDefault.getComment());
            objectType.setMasterDataSetId(masterDataSetId);
            objectType.setNetworkId(networkId);
            objectType = (ObjectType)this.objectTypeDAO.save(objectType);
        }
    }

    public MasterDataSet getMasterDataSet(Long organisationPersonId, Long masterDataSetId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not create master data set, privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
        return (MasterDataSet)this.masterDataSetDAO.get(masterDataSetId);
    }

    public void saveMasterDataSet(Long organisationPersonId, Long masterDataSetId, String name, String description) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not create master data set, privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
        MasterDataSet masterDataSet = (MasterDataSet)this.masterDataSetDAO.get(masterDataSetId);
        masterDataSet.setName(name);
        masterDataSet.setDescription(description);
        this.masterDataSetDAO.update(masterDataSet);
    }

    public String deleteMasterDataSet(Long organisationPersonId, Long masterDataSetId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not create master data set, privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        MasterDataSet masterDataSet = (MasterDataSet)this.masterDataSetDAO.get(masterDataSetId);
        Long networkId = masterDataSet.getNetworkId();
        List<MasterDataSet> allMasterDataSets = this.masterDataSetDAO.getByNetwork(networkId);
        if (allMasterDataSets.size() < 2) {
            return resourceBundle.getString("masterDataSetOnePerNetworkNeededError");
        }
        try {
            List<DocumentType> documentTypes = this.documentTypeDAO.getByMasterDataSet(masterDataSetId);
            List<ObjectType> objectTypes = this.objectTypeDAO.getByMasterDataSet(masterDataSetId);
            List<SubProjectType> subProjectTypes = this.subProjectTypeDAO.getByMasterDataSet(masterDataSetId);
            for (DocumentType documentType : documentTypes) {
                this.documentTypeDAO.delete(documentType.getId());
            }
            for (ObjectType objectType : objectTypes) {
                this.objectTypeDAO.delete(objectType.getId());
            }
            for (SubProjectType subProjectType : subProjectTypes) {
                this.subProjectTypeDAO.delete(subProjectType.getId());
            }
            this.masterDataSetDAO.delete(masterDataSetId);
            return null;
        }
        catch (Exception e) {
            return resourceBundle.getString("masterDataSetReferencesExistError");
        }
    }

    private DocumentType constructDocumentTypeByDefault(DocumentTypeDefault documentTypeDefault, MasterDataSet masterDataSet, Network network, Long parentId) {
        DocumentType documentType = new DocumentType();
        documentType.setCode(documentTypeDefault.getCode());
        documentType.setName(documentTypeDefault.getName());
        documentType.setDescription(documentTypeDefault.getDescription());
        documentType.setMasterDataSetId(masterDataSet.getId());
        documentType.setNetworkId(network.getId());
        documentType.setDocumentTypeGroupId(parentId);
        documentType = (DocumentType)this.documentTypeDAO.save(documentType);
        return documentType;
    }

    public String triggerExportDocumentTypes(Long organisationPersonId, Long masterDataSetId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<MasterDataItem> items = this.getDocumentTypeItems(masterDataSetId);
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        final HashMap<Long, MasterDataItem> idToItem = new HashMap<Long, MasterDataItem>();
        for (MasterDataItem item : items) {
            idToItem.put(item.getId(), item);
        }
        Collections.sort(items, new Comparator<MasterDataItem>(){

            @Override
            public int compare(MasterDataItem itemOne, MasterDataItem itemTwo) {
                MasterDataItem groupItemTwo;
                String codeTwo;
                Long groupIdOne = itemOne.getParentId() != null ? itemOne.getParentId() : itemOne.getId();
                Long groupIdTwo = itemTwo.getParentId() != null ? itemTwo.getParentId() : itemTwo.getId();
                MasterDataItem groupItemOne = (MasterDataItem)idToItem.get(groupIdOne);
                String codeOne = groupItemOne != null ? groupItemOne.getCode() : "";
                int groupCompareResult = CompareHelper.defaultStringCompare(collator, codeOne, codeTwo = (groupItemTwo = (MasterDataItem)idToItem.get(groupIdTwo)) != null ? groupItemTwo.getCode() : "", false);
                if (groupCompareResult != 0) {
                    return groupCompareResult;
                }
                Long parentIdOne = itemOne.getParentId();
                Long parentIdTwo = itemTwo.getParentId();
                if (parentIdOne == null) {
                    return -1;
                }
                if (parentIdTwo == null) {
                    return 1;
                }
                codeOne = itemOne.getCode();
                codeTwo = itemTwo.getCode();
                return CompareHelper.defaultStringCompare(collator, codeOne, codeTwo, false);
            }
        });
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        String caption = resourceBundle.getString("masterDataDocumentTypeTabCaption");
        MasterDataSet masterDataSet = (MasterDataSet)this.masterDataSetDAO.get(masterDataSetId);
        Long networkId = masterDataSet.getNetworkId();
        MasterDataPdfCallable callable = new MasterDataPdfCallable(this.masterDataPdfExporter, organisationPersonId, networkId, items, caption, masterDataSetId, true, true);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)callable));
        return uuid.toString();
    }

    public String triggerExportSubProjectTypes(Long organisationPersonId, Long masterDataSetId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<MasterDataItem> items = this.getSubProjectTypeItems(masterDataSetId);
        this.sortItemsByCode(items);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        String caption = resourceBundle.getString("masterDataSubProjectTypeTabCaption");
        MasterDataSet masterDataSet = (MasterDataSet)this.masterDataSetDAO.get(masterDataSetId);
        Long networkId = masterDataSet.getNetworkId();
        MasterDataPdfCallable callable = new MasterDataPdfCallable(this.masterDataPdfExporter, organisationPersonId, networkId, items, caption, masterDataSetId, true, true);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)callable));
        return uuid.toString();
    }

    public String triggerExportObjectTypes(Long organisationPersonId, Long masterDataSetId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<MasterDataItem> items = this.getObjectTypeItems(masterDataSetId);
        this.sortItemsByCode(items);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        String i18nSymbol = this.enableCustomerLogo != false ? "masterDataProjectTypeTabCaption" : "masterDataObjectTypeTabCaption";
        String caption = resourceBundle.getString(i18nSymbol);
        MasterDataSet masterDataSet = (MasterDataSet)this.masterDataSetDAO.get(masterDataSetId);
        Long networkId = masterDataSet.getNetworkId();
        MasterDataPdfCallable callable = new MasterDataPdfCallable(this.masterDataPdfExporter, organisationPersonId, networkId, items, caption, masterDataSetId, true, true);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)callable));
        return uuid.toString();
    }

    public String triggerExportStatutoryDuties(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<MasterDataItem> items = this.getStatutoryDutyItems(networkId);
        this.sortItemsByName(items);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        String caption = resourceBundle.getString("masterDataStatutoryDutyTabCaption");
        MasterDataPdfCallable callable = new MasterDataPdfCallable(this.masterDataPdfExporter, organisationPersonId, networkId, items, caption, null, false, true);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)callable));
        return uuid.toString();
    }

    public String triggerExportSubjectAreas(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<MasterDataItem> items = this.getSubjectAreaItems(networkId);
        this.sortItemsByName(items);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        String caption = resourceBundle.getString("masterDataSubjectAreaTabCaption");
        MasterDataPdfCallable callable = new MasterDataPdfCallable(this.masterDataPdfExporter, organisationPersonId, networkId, items, caption, null, false, true);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)callable));
        return uuid.toString();
    }

    public String triggerExportPersonInCharges(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<MasterDataItem> items = this.getPersonInChargeItems(networkId);
        this.sortItemsByName(items);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        String caption = resourceBundle.getString("masterDataPersonInChargeTabCaption");
        MasterDataPdfCallable callable = new MasterDataPdfCallable(this.masterDataPdfExporter, organisationPersonId, networkId, items, caption, null, false, true);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)callable));
        return uuid.toString();
    }

    public List<DocumentNumberPart> getDocumentNumberParts(Long organisationPersonId, Long groupId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NUMBER_FORMAT, Action.SHOW_NUMBER_FORMAT);
        if (!actions.contains(Action.EDIT_NUMBER_FORMAT) && !actions.contains(Action.SHOW_NUMBER_FORMAT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not load DocumentNumberParts, privileges [" + Action.EDIT_NUMBER_FORMAT + "] or [" + Action.SHOW_NUMBER_FORMAT + "] are missing.");
        }
        List<DocumentNumberPart> numberParts = this.documentNumberPartDAO.getByGroup(groupId);
        this.sortItemsByPosition(numberParts);
        return numberParts;
    }

    private void sortItemsByPosition(List<DocumentNumberPart> items) {
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(items, new Comparator<DocumentNumberPart>(){

            @Override
            public int compare(DocumentNumberPart itemOne, DocumentNumberPart itemTwo) {
                Integer positionOne = itemOne.getPosition();
                Integer getPositionTwo = itemTwo.getPosition();
                return CompareHelper.defaultIntCompare(positionOne, getPositionTwo, false);
            }
        });
    }

    public void saveDocumentNumberParts(Long organisationPersonId, Long groupId, List<DocumentNumberPart> parts) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NUMBER_FORMAT, Action.SHOW_NUMBER_FORMAT);
        if (!actions.contains(Action.EDIT_NUMBER_FORMAT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not save DocumentNumberParts, privilege [" + Action.EDIT_NUMBER_FORMAT + "] is missing.");
        }
        List<DocumentNumberPart> oldParts = this.documentNumberPartDAO.getByGroup(groupId);
        for (DocumentNumberPart part : parts) {
            part.setGroupId(groupId);
            if (part.getSeperator() != null) continue;
            part.setSeperator("");
        }
        QueryHelper.syncWithDatabase(this.documentNumberPartDAO, parts, oldParts);
    }

    public CopyDocumentNumberPartDefaultInfo getCopyDocumentNumberPartDefaultInfo(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NUMBER_FORMAT);
        if (!actions.contains(Action.EDIT_NUMBER_FORMAT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not copy DocumentNumberPartGroupDefaults, privilege [" + Action.EDIT_NUMBER_FORMAT + "] is missing.");
        }
        CopyDocumentNumberPartDefaultInfo info = new CopyDocumentNumberPartDefaultInfo();
        Network network = (Network)this.networkDAO.get(networkId);
        info.setNetwork(network);
        Long networkTypeId = network.getNetworkTypeId();
        List<DocumentNumberPartGroupDefault> documentNumberPartGroupsDefault = this.documentNumberPartGroupDefaultDAO.getByNetworkType(networkTypeId);
        info.setDocumentNumberPartGroupsDefault(documentNumberPartGroupsDefault);
        return info;
    }

    public void insertCopiesOfDefaultNumberPartGroupsIntoNetwork(Long organisationPersonId, Long networkId, Long masterDataSetId, List<Long> documentNumberPartGroupDefaultIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_NUMBER_FORMAT);
        if (!actions.contains(Action.EDIT_NUMBER_FORMAT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not copy DocumentNumberPartGroupDefaults, privilege [" + Action.EDIT_NUMBER_FORMAT + "] is missing.");
        }
        for (Long documentNumberPartGroupDefaultId : documentNumberPartGroupDefaultIds) {
            DocumentNumberPartGroupDefault documentNumberPartGroupDefault = (DocumentNumberPartGroupDefault)this.documentNumberPartGroupDefaultDAO.get(documentNumberPartGroupDefaultId);
            DocumentNumberPartGroup documentNumberPartGroup = new DocumentNumberPartGroup();
            documentNumberPartGroup.setMasterDataSetId(masterDataSetId);
            documentNumberPartGroup.setName(documentNumberPartGroupDefault.getName());
            documentNumberPartGroup.setNetworkId(networkId);
            documentNumberPartGroup.setRendererName(documentNumberPartGroupDefault.getRendererName());
            documentNumberPartGroup = (DocumentNumberPartGroup)this.documentNumberPartGroupDAO.save(documentNumberPartGroup);
            List<DocumentNumberPartDefault> documentNumberPartsDefault = this.documentNumberPartDefaultDAO.getByGroup(documentNumberPartGroupDefault);
            for (DocumentNumberPartDefault documentNumberPartDefault : documentNumberPartsDefault) {
                DocumentNumberPart documentNumberPart = new DocumentNumberPart();
                documentNumberPart.setName(documentNumberPartDefault.getName());
                documentNumberPart.setFormat(documentNumberPartDefault.getFormat());
                documentNumberPart.setLength(documentNumberPartDefault.getLength());
                documentNumberPart.setPosition(documentNumberPartDefault.getPosition());
                documentNumberPart.setOgnlRule(documentNumberPartDefault.getOgnlRule());
                documentNumberPart.setSeperator(documentNumberPartDefault.getSeperator());
                documentNumberPart.setUniqueKey(documentNumberPartDefault.isUniqueKey());
                documentNumberPart.setGroupId(documentNumberPartGroup.getId());
                documentNumberPart.setFieldType(documentNumberPartDefault.getFieldType());
                this.documentNumberPartDAO.save(documentNumberPart);
            }
        }
    }

    public DocumentTypeEditInfo getDocumentTypeEditInfo(Long organisationPersonId, Long documentTypeId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not edit DocumentTypes, privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
        DocumentType documentType = (DocumentType)this.documentTypeDAO.get(documentTypeId);
        List<DocumentType> subTypes = this.documentTypeDAO.getByDocumentTypeGroup(documentTypeId);
        MasterDataItem documentTypeItem = this.constructMasterDataItemByDocumentType(documentType);
        ArrayList<MasterDataItem> subTypeItems = new ArrayList<MasterDataItem>();
        for (DocumentType subType : subTypes) {
            subTypeItems.add(this.constructMasterDataItemByDocumentType(subType));
        }
        DocumentTypeEditInfo editInfo = new DocumentTypeEditInfo();
        editInfo.setDocumentTypeItem(documentTypeItem);
        editInfo.setSubTypeItems(subTypeItems);
        return editInfo;
    }

    public void saveDocumentTypeSubTypes(Long organisationPersonId, Long documentTypeId, List<MasterDataItem> subTypeItems) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not edit DocumentTypes, privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
        DocumentType documentType = (DocumentType)this.documentTypeDAO.get(documentTypeId);
        Long networkId = documentType.getNetworkId();
        Long masterDataSetId = documentType.getMasterDataSetId();
        ArrayList<DocumentType> subTypes = new ArrayList<DocumentType>();
        for (MasterDataItem subTypeItem : subTypeItems) {
            DocumentType subType = new DocumentType();
            subType.setId(subTypeItem.getId());
            subType.setCode(subTypeItem.getCode());
            subType.setName(subTypeItem.getName());
            subType.setDescription(subTypeItem.getDescription());
            subType.setDocumentTypeGroupId(documentTypeId);
            subType.setNetworkId(networkId);
            subType.setMasterDataSetId(masterDataSetId);
            subTypes.add(subType);
        }
        List<DocumentType> oldSubTypes = this.documentTypeDAO.getByDocumentTypeGroup(documentTypeId);
        QueryHelper.syncWithDatabase(this.documentTypeDAO, subTypes, oldSubTypes);
    }

    public List<Project> getProjectsAssignedToMasterDataSet(Long organisationPersonId, Long masterDataSetId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_DOCUMENT_TYPE);
        if (!actions.contains(Action.EDIT_DOCUMENT_TYPE)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not show assigned projects, privilege [" + Action.EDIT_DOCUMENT_TYPE + "] is missing.");
        }
        return this.projectDAO.getActiveProjectsByMasterDataSetId(masterDataSetId);
    }
}

