/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.PlanningNotification;
import at.cdes.api.dto.PlanningNotificationProjectMap;
import at.cdes.api.dto.Project;
import at.cdes.impl.dao.PlanningNotificationProjectMapDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcPlanningNotificationProjectMapDAO
extends AbstrIdDAO<PlanningNotificationProjectMap>
implements PlanningNotificationProjectMapDAO {
    public JdbcPlanningNotificationProjectMapDAO() {
        super(PlanningNotificationProjectMap.class, "planningNotificationId", "planning_notification_project_map", new String[]{"planning_notification_id", "project_id", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcPlanningNotificationProjectMapDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "planning_notification_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcPlanningNotificationProjectMapDAO.getSelectClauseForDto("planning_notification_project_map", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcPlanningNotificationProjectMapDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".planning_notification_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "planning_notification_id") + "," + entityLocalName + ".project_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_id") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected PlanningNotificationProjectMap fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        PlanningNotificationProjectMap planningNotificationProjectMap = new PlanningNotificationProjectMap();
        planningNotificationProjectMap.setPlanningNotificationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planningNotificationProjectMap.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planningNotificationProjectMap.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planningNotificationProjectMap.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planningNotificationProjectMap.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return planningNotificationProjectMap;
    }

    public static PlanningNotificationProjectMap fillPlanningNotificationProjectMapFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        PlanningNotificationProjectMap planningNotificationProjectMap = new PlanningNotificationProjectMap();
        planningNotificationProjectMap.setPlanningNotificationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        planningNotificationProjectMap.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        planningNotificationProjectMap.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        planningNotificationProjectMap.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        planningNotificationProjectMap.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return planningNotificationProjectMap;
    }

    public static PlanningNotificationProjectMap fillPlanningNotificationProjectMapFromResultSet(ResultSet rs) throws SQLException {
        return JdbcPlanningNotificationProjectMapDAO.fillPlanningNotificationProjectMapFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    @Override
    public void deleteInstance(final Long planningNotificationId, final Long projectId) {
        String sql = "DELETE FROM planning_notification_project_map WHERE planning_notification_id = ? AND project_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, planningNotificationId);
                statement.setLong(currIndex++, projectId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteByPlanningNotification(final Long planningNotificationId) {
        String sql = "DELETE FROM planning_notification_project_map WHERE planning_notification_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, planningNotificationId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(PlanningNotificationProjectMap dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<PlanningNotificationProjectMap> dtos) {
        Iterator<PlanningNotificationProjectMap> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, PlanningNotificationProjectMap planningNotificationProjectMap) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)planningNotificationProjectMap.getPlanningNotificationId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)planningNotificationProjectMap.getProjectId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)(planningNotificationProjectMap.getCreateTrx() != null ? planningNotificationProjectMap.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)System.currentTimeMillis());
    }

    @Override
    public List<PlanningNotificationProjectMap> getByPlanningNotification(PlanningNotification planningNotification) {
        return this.getByPlanningNotification(planningNotification.getId());
    }

    @Override
    public List<PlanningNotificationProjectMap> getByPlanningNotification(final Long planningNotificationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"planning_notification_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, planningNotificationId);
            }
        });
    }

    @Override
    public List<PlanningNotificationProjectMap> getByProject(Project project) {
        return this.getByProject(project.getId());
    }

    @Override
    public List<PlanningNotificationProjectMap> getByProject(final Long projectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectId);
            }
        });
    }

    @Override
    public List<PlanningNotificationProjectMap> getByPlanningNotifications(Collection<Long> planningNotificationId) {
        if (planningNotificationId.isEmpty()) {
            return new ArrayList<PlanningNotificationProjectMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[planningNotificationId.size()];
        int n = 0;
        Iterator<Long> it = planningNotificationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"planning_notification_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<PlanningNotificationProjectMap> getByProjects(Collection<Long> projectId) {
        if (projectId.isEmpty()) {
            return new ArrayList<PlanningNotificationProjectMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectId.size()];
        int n = 0;
        Iterator<Long> it = projectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

