/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkType;
import at.cdes.api.dto.SubjectArea;
import at.cdes.impl.dao.SubjectAreaDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcSubjectAreaDAO
extends AbstrIdDAO<SubjectArea>
implements SubjectAreaDAO {
    public JdbcSubjectAreaDAO() {
        super(SubjectArea.class, "id", "subject_area", new String[]{"id", "name", "description", "network_id", "network_type_id", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcSubjectAreaDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcSubjectAreaDAO.getSelectClauseForDto("subject_area", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcSubjectAreaDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".network_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected SubjectArea fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        SubjectArea subjectArea = new SubjectArea();
        subjectArea.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        subjectArea.setName(rs.getString(++columnIndex));
        subjectArea.setDescription(rs.getString(++columnIndex));
        subjectArea.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        subjectArea.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        subjectArea.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        subjectArea.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        subjectArea.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return subjectArea;
    }

    public static SubjectArea fillSubjectAreaFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        SubjectArea subjectArea = new SubjectArea();
        subjectArea.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        subjectArea.setName(rs.getString(columnIndex.incrementAndGet()));
        subjectArea.setDescription(rs.getString(columnIndex.incrementAndGet()));
        subjectArea.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        subjectArea.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        subjectArea.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        subjectArea.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        subjectArea.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return subjectArea;
    }

    public static SubjectArea fillSubjectAreaFromResultSet(ResultSet rs) throws SQLException {
        return JdbcSubjectAreaDAO.fillSubjectAreaFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 8;
    }

    @Override
    public void deleteByNetworkId(final Long networkId) {
        String sql = "DELETE FROM subject_area WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(SubjectArea dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<SubjectArea> dtos) {
        Iterator<SubjectArea> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, SubjectArea subjectArea) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subjectArea.getId());
        statement.setString(2, subjectArea.getName());
        statement.setString(3, subjectArea.getDescription());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)subjectArea.getNetworkId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)subjectArea.getNetworkTypeId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)(subjectArea.getCreateTrx() != null ? subjectArea.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)System.currentTimeMillis());
    }

    @Override
    public List<SubjectArea> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<SubjectArea> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<SubjectArea> getByNetworkType(NetworkType networkType) {
        return this.getByNetworkType(networkType.getId());
    }

    @Override
    public List<SubjectArea> getByNetworkType(final Long networkTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkTypeId);
            }
        });
    }

    @Override
    public List<SubjectArea> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<SubjectArea>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<SubjectArea> getByNetworkTypes(Collection<Long> networkTypeId) {
        if (networkTypeId.isEmpty()) {
            return new ArrayList<SubjectArea>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkTypeId.size()];
        int n = 0;
        Iterator<Long> it = networkTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

