/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DigestCalculator;
import at.cdes.api.dto.DocumentList;
import at.cdes.api.dto.DocumentListRelease;
import at.cdes.api.dto.Signature;
import at.cdes.api.dto.SubProject;
import at.cdes.api.joinDto.DocumentListReleaseVersion;
import at.cdes.api.joinDto.PlanDeliverSearchJoin;
import at.cdes.impl.dao.GenDocumentListReleaseDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcDocumentListReleaseDAO
extends AbstrIdDAO<DocumentListRelease>
implements GenDocumentListReleaseDAO {
    public AbstractJdbcDocumentListReleaseDAO() {
        super(DocumentListRelease.class, "id", "document_list_release", new String[]{"id", "document_list_id", "version", "sub_project_id", "digest", "digest_calculator_id", "signature_id", "has_document_versions"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcDocumentListReleaseDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_list_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "version") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "sub_project_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "has_document_versions") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcDocumentListReleaseDAO.getSelectClauseForDto("document_list_release", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcDocumentListReleaseDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".document_list_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_list_id") + "," + entityLocalName + ".version" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "version") + "," + entityLocalName + ".sub_project_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "sub_project_id") + "," + entityLocalName + ".digest" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + "," + entityLocalName + ".digest_calculator_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + "," + entityLocalName + ".signature_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_id") + "," + entityLocalName + ".has_document_versions" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "has_document_versions") + " ";
    }

    protected DocumentListRelease fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        DocumentListRelease documentListRelease = new DocumentListRelease();
        documentListRelease.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListRelease.setDocumentListId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListRelease.setVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        documentListRelease.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListRelease.setDigest(rs.getString(++columnIndex));
        documentListRelease.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListRelease.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListRelease.setHasDocumentVersions(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        return documentListRelease;
    }

    public static DocumentListRelease fillDocumentListReleaseFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        DocumentListRelease documentListRelease = new DocumentListRelease();
        documentListRelease.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentListRelease.setDocumentListId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentListRelease.setVersion(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentListRelease.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentListRelease.setDigest(rs.getString(columnIndex.incrementAndGet()));
        documentListRelease.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentListRelease.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentListRelease.setHasDocumentVersions(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return documentListRelease;
    }

    public static DocumentListRelease fillDocumentListReleaseFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcDocumentListReleaseDAO.fillDocumentListReleaseFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 8;
    }

    public static DocumentListReleaseVersion fillDocumentListReleaseVersionFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        DocumentListReleaseVersion documentListReleaseVersion = new DocumentListReleaseVersion();
        documentListReleaseVersion.setDocumentListId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListReleaseVersion.setDocumentListVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        documentListReleaseVersion.setDocumentListReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListReleaseVersion.setDocumentListReleaseVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        documentListReleaseVersion.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListReleaseVersion.setPersonGivenName(rs.getString(++columnIndex));
        documentListReleaseVersion.setPersonSurName(rs.getString(++columnIndex));
        documentListReleaseVersion.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentListReleaseVersion.setSignatureTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        return documentListReleaseVersion;
    }

    public static int getNumberOfDocumentListReleaseVersionAttributes() {
        return 9;
    }

    public static PlanDeliverSearchJoin fillPlanDeliverSearchJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        PlanDeliverSearchJoin planDeliverSearchJoin = new PlanDeliverSearchJoin();
        planDeliverSearchJoin.setCdesRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setCdesRoleName(rs.getString(++columnIndex));
        planDeliverSearchJoin.setDocumentListId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setDocumentListVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setDocumentListReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setDocumentListReleaseVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setObjectPlannerReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setObjectPlannerReleaseCode(rs.getString(++columnIndex));
        planDeliverSearchJoin.setObjectPlannerReleaseArea(rs.getString(++columnIndex));
        planDeliverSearchJoin.setObjectPlannerReleaseObjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setObjectPlannerReleaseObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setObjectReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setObjectReleaseCode(rs.getString(++columnIndex));
        planDeliverSearchJoin.setObjectReleaseName(rs.getString(++columnIndex));
        planDeliverSearchJoin.setObjectReleaseObjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setObjectReleaseObjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setObjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setObjectTypeCode(rs.getString(++columnIndex));
        planDeliverSearchJoin.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setOrganisationName(rs.getString(++columnIndex));
        planDeliverSearchJoin.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setPersonGivenName(rs.getString(++columnIndex));
        planDeliverSearchJoin.setPersonSurName(rs.getString(++columnIndex));
        planDeliverSearchJoin.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        planDeliverSearchJoin.setSignatureTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        return planDeliverSearchJoin;
    }

    public static int getNumberOfPlanDeliverSearchJoinAttributes() {
        return 26;
    }

    protected String getSelectClauseForDocumentListReleaseVersionUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("documentList") ? result + "document_list.id, document_list.version" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("documentListRelease") ? result + "document_list_release.id, document_list_release.version" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("signature") ? result + "signature.id, signature.time" : result + "NULL, NULL";
        return result;
    }

    protected String getSelectClauseForPlanDeliverSearchJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("cdesRole") ? result + "cdes_role.id, cdes_role.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("documentList") ? result + "document_list.id, document_list.version" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("documentListRelease") ? result + "document_list_release.id, document_list_release.version" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlannerRelease") ? result + "object_planner_release.id, object_planner_release.code, object_planner_release.area, object_planner_release.object_id, object_planner_release.object_planner_id" : result + "NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectRelease") ? result + "object_release.id, object_release.code, object_release.name, object_release.object_type_id, object_release.object_id" : result + "NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectType") ? result + "object_type.id, object_type.code" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisation") ? result + "organisation.id, organisation.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisationPerson") ? result + "organisation_person.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("signature") ? result + "signature.id, signature.time" : result + "NULL, NULL";
        return result;
    }

    public int update(DocumentListRelease dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<DocumentListRelease> dtos) {
        Iterator<DocumentListRelease> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getDocumentListReleaseVersionSelectClause() {
        return "document_list.id, document_list.version, document_list_release.id, document_list_release.version, person.id, person.givenName, person.surName, signature.id, signature.time ";
    }

    public static String getPrefixedDocumentListReleaseVersionSelectClause() {
        return "document_list.id AS document_list_id, document_list.version AS document_list_version, document_list_release.id AS document_list_release_id, document_list_release.version AS document_list_release_version, person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName, signature.id AS signature_id, signature.time AS signature_time ";
    }

    public static String getPlanDeliverSearchJoinSelectClause() {
        return "cdes_role.id, cdes_role.name, document_list.id, document_list.version, document_list_release.id, document_list_release.version, object_planner_release.id, object_planner_release.code, object_planner_release.area, object_planner_release.object_id, object_planner_release.object_planner_id, object_release.id, object_release.code, object_release.name, object_release.object_type_id, object_release.object_id, object_type.id, object_type.code, organisation.id, organisation.name, organisation_person.id, person.id, person.givenName, person.surName, signature.id, signature.time ";
    }

    public static String getPrefixedPlanDeliverSearchJoinSelectClause() {
        return "cdes_role.id AS cdes_role_id, cdes_role.name AS cdes_role_name, document_list.id AS document_list_id, document_list.version AS document_list_version, document_list_release.id AS document_list_release_id, document_list_release.version AS document_list_release_version, object_planner_release.id AS object_planner_release_id, object_planner_release.code AS object_planner_release_code, object_planner_release.area AS object_planner_release_area, object_planner_release.object_id AS object_planner_release_object_id, object_planner_release.object_planner_id AS object_planner_release_object_planner_id, object_release.id AS object_release_id, object_release.code AS object_release_code, object_release.name AS object_release_name, object_release.object_type_id AS object_release_object_type_id, object_release.object_id AS object_release_object_id, object_type.id AS object_type_id, object_type.code AS object_type_code, organisation.id AS organisation_id, organisation.name AS organisation_name, organisation_person.id AS organisation_person_id, person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName, signature.id AS signature_id, signature.time AS signature_time ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, DocumentListRelease documentListRelease) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentListRelease.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)documentListRelease.getDocumentListId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)3, (Number)documentListRelease.getVersion());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)documentListRelease.getSubProjectId());
        statement.setString(5, documentListRelease.getDigest());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)documentListRelease.getDigestCalculatorId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)documentListRelease.getSignatureId());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)8, (Boolean)documentListRelease.getHasDocumentVersions());
    }

    @Override
    public List<DocumentListRelease> getByDocumentList(DocumentList documentList) {
        return this.getByDocumentList(documentList.getId());
    }

    @Override
    public List<DocumentListRelease> getByDocumentList(final Long documentListId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_list_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentListId);
            }
        });
    }

    @Override
    public List<DocumentListRelease> getBySubProject(SubProject subProject) {
        return this.getBySubProject(subProject.getId());
    }

    @Override
    public List<DocumentListRelease> getBySubProject(final Long subProjectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"sub_project_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, subProjectId);
            }
        });
    }

    @Override
    public List<DocumentListRelease> getByDigestCalculator(DigestCalculator digestCalculator) {
        return this.getByDigestCalculator(digestCalculator.getId());
    }

    @Override
    public List<DocumentListRelease> getByDigestCalculator(final Long digestCalculatorId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, digestCalculatorId);
            }
        });
    }

    @Override
    public List<DocumentListRelease> getBySignature(Signature signature) {
        return this.getBySignature(signature.getId());
    }

    @Override
    public List<DocumentListRelease> getBySignature(final Long signatureId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, signatureId);
            }
        });
    }

    @Override
    public List<DocumentListRelease> getByDocumentLists(Collection<Long> documentListId) {
        if (documentListId.isEmpty()) {
            return new ArrayList<DocumentListRelease>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentListId.size()];
        int n = 0;
        Iterator<Long> it = documentListId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_list_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentListRelease> getBySubProjects(Collection<Long> subProjectId) {
        if (subProjectId.isEmpty()) {
            return new ArrayList<DocumentListRelease>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[subProjectId.size()];
        int n = 0;
        Iterator<Long> it = subProjectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"sub_project_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentListRelease> getByDigestCalculators(Collection<Long> digestCalculatorId) {
        if (digestCalculatorId.isEmpty()) {
            return new ArrayList<DocumentListRelease>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[digestCalculatorId.size()];
        int n = 0;
        Iterator<Long> it = digestCalculatorId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentListRelease> getBySignatures(Collection<Long> signatureId) {
        if (signatureId.isEmpty()) {
            return new ArrayList<DocumentListRelease>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[signatureId.size()];
        int n = 0;
        Iterator<Long> it = signatureId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

