/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.plot;

import at.cdes.api.compositeDto.PlotOrderItemData;
import at.cdes.api.dto.Country;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.OrderAddress;
import at.cdes.api.dto.PlottProperties;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.PlotServiceImpl;
import at.cdes.impl.util.UnitHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.xerces.dom.ParentNode;
import org.clazzes.odf.util.core.NodeHelper;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotOrderZipExporter {
    private static final Logger log = LoggerFactory.getLogger(PlotOrderZipExporter.class);
    private OrganisationPersonDAO organisationPersonDAO;
    private String odfStylePrefix;
    private OOoFileEngine oooFileEngine;
    private Long odfTimeout;
    private String tempDir;
    private Boolean enableCustomerLogo;
    private String costumerLabel;

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public ExportResult export(Long organisationPersonId, List<PlotOrderItemData> plotOrderItemDatas, String personVariablesUserLocale) throws Exception {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        String fileNamePrefix = "PlotOrderItems";
        File odsFile = OdfFileHelper.createTempFile((String)this.tempDir, (String)fileNamePrefix);
        OdfSpreadsheetDocument document = DocumentFactory.constructSpreadsheetDocument((String)"export/emptyOdsTemplate.ods", PlotServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        List tableElements = document.getTables();
        TableTableElement tableElement = (TableTableElement)tableElements.get(0);
        tableElement.setTableNameAttribute(resourceBundle.getString("plotOrderItemXlsTableName"));
        NodeHelper.removeChildNodes((ParentNode)tableElement, TableTableColumnElement.class);
        NodeHelper.removeChildNodes((ParentNode)tableElement, TableTableRowElement.class);
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"4.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"4.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.5cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"4.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.5cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.5cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"6.0cm");
        TableTableHeaderRowsElement headerRowsElement = tableElement.newTableTableHeaderRowsElement();
        TableTableRowElement headerRow = headerRowsElement.newTableTableRowElement();
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithFontSize("9pt", "bold")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemDocumentNumber")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemFileCaption")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemPaperCaption")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemColorCaption")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemFoldCaption")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemMirrorCaption")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemScaleCaption")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemAreaCaption")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemCountCaption")});
        TableFactory.appendCellStyledCell((String)headerCellStyle, (TableTableRowElement)headerRow, (String[])new String[]{resourceBundle.getString("plotOrderItemDestAddress")});
        String cellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[0]);
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructParagraphPropertiesWithVerticalAlign("auto", false), contentAutomaticStyles.constructTextPropertiesWithFontSize("9pt")});
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithAlwaysKeepTogether()});
        for (int n = 0; n < plotOrderItemDatas.size(); ++n) {
            PlotOrderItemData plotOrderItemData = plotOrderItemDatas.get(n);
            TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, (String)rowStyle);
            PlottProperties plotProperties = plotOrderItemData.getPlotProperties();
            DocumentVersion documentVersion = plotOrderItemData.getDocumentVersion();
            Document cdesDocument = plotOrderItemData.getDocument();
            String documentVersionName = documentVersion.getName();
            String documentContent = cdesDocument.getContent();
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{documentVersionName, documentContent});
            String fileName = MessageFormat.format(resourceBundle.getString("plotOrderItemFileContent"), new Integer(n + 1).toString());
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{fileName});
            String paperQuality = plotProperties.getPaperQuality();
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{paperQuality});
            Integer color = plotProperties.getIsInColor();
            String colorString = null;
            colorString = color == null ? resourceBundle.getString("plotOrderItemAsDisplayedLabel") : (color == 0 ? resourceBundle.getString("plotOrderItemBlackWhiteLabel") : (color == 1 ? resourceBundle.getString("plotOrderItemColorLabel") : resourceBundle.getString("plotOrderItemAsDisplayedLabel")));
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{colorString});
            String margin = plotProperties.getMargin();
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{margin});
            Boolean mirror = plotProperties.getMirror();
            String mirrorString = mirror == null || mirror == false ? resourceBundle.getString("no") : resourceBundle.getString("yes");
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{mirrorString});
            String scale = plotProperties.getScale();
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{scale});
            double area = this.getArea(plotProperties);
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMAN);
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            String areaString = numberFormat.format(area);
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{MessageFormat.format(resourceBundle.getString("plotOrderItemAreaLabel"), areaString)});
            Integer count = plotProperties.getCount();
            if (count != null) {
                TableFactory.appendCell(null, null, (TableTableRowElement)rowElement, (int)count);
            } else {
                TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{""});
            }
            OrderAddress deliveryAddress = plotOrderItemData.getDeliveryAddress();
            Country deliveryCountry = plotOrderItemData.getDeliveryCountry();
            String organisationName = deliveryAddress.getOrganisationName();
            String deliverDirectly = deliveryAddress.getGivenName() != null && deliveryAddress.getSurName() != null ? MessageFormat.format(resourceBundle.getString("deliverDirectly"), deliveryAddress.getGivenName() + " " + deliveryAddress.getSurName()) : null;
            String postalAddress = deliveryAddress.getPostalAddress();
            String locality = deliveryAddress.getPostalCode() + " " + deliveryAddress.getLocalityName();
            String country = deliveryCountry.getDescDe();
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{organisationName, deliverDirectly, postalAddress, locality, country});
        }
        String xlsxFileName = OdfFileHelper.saveAndConvert((String)this.tempDir, (String)"cdes_Plotauftraege_", (OdfSpreadsheetDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.MSEXCEL_2007_XML, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        return OdfHelper.constructExportResult(xlsxFileName);
    }

    private double getArea(PlottProperties plotProperties) {
        double area;
        if (plotProperties.getLlx() != null && plotProperties.getLly() != null && plotProperties.getUrx() != null && plotProperties.getUry() != null) {
            double llxMM = UnitHelper.convertPtToMM(plotProperties.getLlx());
            double llyMM = UnitHelper.convertPtToMM(plotProperties.getLly());
            double urxMM = UnitHelper.convertPtToMM(plotProperties.getUrx());
            double uryMM = UnitHelper.convertPtToMM(plotProperties.getUry());
            area = Math.abs(uryMM - llyMM) / 1000.0 * (Math.abs(urxMM - llxMM) / 1000.0);
        } else {
            area = plotProperties.getScale() != null ? UnitHelper.getPaperFormatMArea(plotProperties.getScale()) : 0.0;
        }
        if (plotProperties.getCount() != null) {
            area *= (double)plotProperties.getCount().intValue();
        }
        return area;
    }
}

