/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.job.util;

import at.cdes.api.dto.Job;
import at.cdes.api.job.core.JobHandle;
import at.cdes.api.job.core.JobInfo;
import at.cdes.api.voc.job.JobStartStrategy;
import at.cdes.api.voc.job.JobState;
import at.cdes.api.voc.job.JobType;
import at.cdes.impl.job.core.JobRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHelper {
    private static final Logger log = LoggerFactory.getLogger(JobHelper.class);

    public static String registerCallableJob(JobRegistry jobRegistry, JobType jobType, Long organisationPersonId, Long networkId, String parameters, String uuid, JobHandle jobHandle) {
        Job job = new Job();
        job.setType(Integer.valueOf(jobType.getValue()));
        job.setOrganisationPersonId(organisationPersonId);
        job.setNetworkId(networkId);
        job.setParameters(parameters);
        job.setStartStrategy(Integer.valueOf(JobStartStrategy.CALLABLE.getValue()));
        job.setState(Integer.valueOf(JobState.STARTED.getValue()));
        job.setUuid(uuid);
        job.setStartTimestamp(Long.valueOf(System.currentTimeMillis()));
        job.setEndTimestamp(null);
        job.setSize(null);
        job.setResult(null);
        job.setLog(null);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setJob(job);
        jobInfo.setJobHandle(jobHandle);
        jobRegistry.registerJob(uuid, jobInfo);
        return uuid;
    }

    public static String getFileNameFromDisposition(String disposition) {
        String FILE_NAME_TOKEN = "filename*=UTF-8''";
        int fileNameIndex = disposition.indexOf("filename*=UTF-8''");
        if (fileNameIndex == -1) {
            throw new IllegalArgumentException("Malformed disposition string: [" + disposition + "]");
        }
        String suffix = disposition.substring(fileNameIndex + "filename*=UTF-8''".length());
        return suffix;
    }
}

