/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerPosition;
import at.cdes.api.dto.ObjectPlannerPositionDefinition;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.joinDto.ObjectPlannerPositionJoin;
import at.cdes.impl.dao.GenObjectPlannerPositionDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcObjectPlannerPositionDAO
extends AbstrIdDAO<ObjectPlannerPosition>
implements GenObjectPlannerPositionDAO {
    public AbstractJdbcObjectPlannerPositionDAO() {
        super(ObjectPlannerPosition.class, "id", "object_planner_position", new String[]{"id", "role_id", "project_participation_id", "object_planner_id", "definition_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcObjectPlannerPositionDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "role_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_planner_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "definition_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcObjectPlannerPositionDAO.getSelectClauseForDto("object_planner_position", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcObjectPlannerPositionDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".role_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "role_id") + "," + entityLocalName + ".project_participation_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + "," + entityLocalName + ".object_planner_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_planner_id") + "," + entityLocalName + ".definition_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "definition_id") + " ";
    }

    protected ObjectPlannerPosition fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectPlannerPosition objectPlannerPosition = new ObjectPlannerPosition();
        objectPlannerPosition.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerPosition.setRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerPosition.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerPosition.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerPosition.setDefinitionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return objectPlannerPosition;
    }

    public static ObjectPlannerPosition fillObjectPlannerPositionFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ObjectPlannerPosition objectPlannerPosition = new ObjectPlannerPosition();
        objectPlannerPosition.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectPlannerPosition.setRoleId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectPlannerPosition.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectPlannerPosition.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectPlannerPosition.setDefinitionId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return objectPlannerPosition;
    }

    public static ObjectPlannerPosition fillObjectPlannerPositionFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcObjectPlannerPositionDAO.fillObjectPlannerPositionFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    public static ObjectPlannerPositionJoin fillObjectPlannerPositionJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectPlannerPositionJoin objectPlannerPositionJoin = new ObjectPlannerPositionJoin();
        objectPlannerPositionJoin.setCdesRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerPositionJoin.setCdesRoleName(rs.getString(++columnIndex));
        objectPlannerPositionJoin.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerPositionJoin.setObjectPlannerPositionDefinitionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerPositionJoin.setObjectPlannerPositionDefinitionName(rs.getString(++columnIndex));
        return objectPlannerPositionJoin;
    }

    public static int getNumberOfObjectPlannerPositionJoinAttributes() {
        return 5;
    }

    @Override
    public void deleteByObjectPlannerId(final Long objectPlannerId) {
        String sql = "DELETE FROM object_planner_position WHERE object_planner_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, objectPlannerId);
                statement.execute();
                return null;
            }
        });
    }

    protected String getSelectClauseForObjectPlannerPositionJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("cdesRole") ? result + "cdes_role.id, cdes_role.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlanner") ? result + "object_planner.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlannerPositionDefinition") ? result + "object_planner_position_definition.id, object_planner_position_definition.name" : result + "NULL, NULL";
        return result;
    }

    public int update(ObjectPlannerPosition dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ObjectPlannerPosition> dtos) {
        Iterator<ObjectPlannerPosition> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getObjectPlannerPositionJoinSelectClause() {
        return "cdes_role.id, cdes_role.name, object_planner.id, object_planner_position_definition.id, object_planner_position_definition.name ";
    }

    public static String getPrefixedObjectPlannerPositionJoinSelectClause() {
        return "cdes_role.id AS cdes_role_id, cdes_role.name AS cdes_role_name, object_planner.id AS object_planner_id, object_planner_position_definition.id AS object_planner_position_definition_id, object_planner_position_definition.name AS object_planner_position_definition_name ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ObjectPlannerPosition objectPlannerPosition) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)objectPlannerPosition.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)objectPlannerPosition.getRoleId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)objectPlannerPosition.getProjectParticipationId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)objectPlannerPosition.getObjectPlannerId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)objectPlannerPosition.getDefinitionId());
    }

    @Override
    public List<ObjectPlannerPosition> getByRole(CdesRole cdesRole) {
        return this.getByRole(cdesRole.getId());
    }

    @Override
    public List<ObjectPlannerPosition> getByRole(final Long cdesRoleId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"role_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, cdesRoleId);
            }
        });
    }

    @Override
    public List<ObjectPlannerPosition> getByProjectParticipation(ProjectParticipation projectParticipation) {
        return this.getByProjectParticipation(projectParticipation.getId());
    }

    @Override
    public List<ObjectPlannerPosition> getByProjectParticipation(final Long projectParticipationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectParticipationId);
            }
        });
    }

    @Override
    public List<ObjectPlannerPosition> getByObjectPlanner(ObjectPlanner objectPlanner) {
        return this.getByObjectPlanner(objectPlanner.getId());
    }

    @Override
    public List<ObjectPlannerPosition> getByObjectPlanner(final Long objectPlannerId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_planner_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, objectPlannerId);
            }
        });
    }

    @Override
    public List<ObjectPlannerPosition> getByDefinition(ObjectPlannerPositionDefinition objectPlannerPositionDefinition) {
        return this.getByDefinition(objectPlannerPositionDefinition.getId());
    }

    @Override
    public List<ObjectPlannerPosition> getByDefinition(final Long objectPlannerPositionDefinitionId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"definition_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, objectPlannerPositionDefinitionId);
            }
        });
    }

    @Override
    public List<ObjectPlannerPosition> getByRoles(Collection<Long> cdesRoleId) {
        if (cdesRoleId.isEmpty()) {
            return new ArrayList<ObjectPlannerPosition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[cdesRoleId.size()];
        int n = 0;
        Iterator<Long> it = cdesRoleId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"role_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ObjectPlannerPosition> getByProjectParticipations(Collection<Long> projectParticipationId) {
        if (projectParticipationId.isEmpty()) {
            return new ArrayList<ObjectPlannerPosition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectParticipationId.size()];
        int n = 0;
        Iterator<Long> it = projectParticipationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ObjectPlannerPosition> getByObjectPlanners(Collection<Long> objectPlannerId) {
        if (objectPlannerId.isEmpty()) {
            return new ArrayList<ObjectPlannerPosition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[objectPlannerId.size()];
        int n = 0;
        Iterator<Long> it = objectPlannerId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_planner_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ObjectPlannerPosition> getByDefinitions(Collection<Long> objectPlannerPositionDefinitionId) {
        if (objectPlannerPositionDefinitionId.isEmpty()) {
            return new ArrayList<ObjectPlannerPosition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[objectPlannerPositionDefinitionId.size()];
        int n = 0;
        Iterator<Long> it = objectPlannerPositionDefinitionId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"definition_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

