/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.document.searchModel.DocumentSearchModel;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.PlanDeliverSearchModel;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.DestinationJoin;
import at.cdes.api.joinDto.DocumentListJoin;
import at.cdes.api.joinDto.DocumentListSmallJoin;
import at.cdes.api.joinDto.DocumentNumberUniqueJoin;
import at.cdes.api.joinDto.DocumentSearchJoin;
import at.cdes.api.joinDto.PlanDeliverJoinDto;
import at.cdes.api.joinDto.PlanDeliverNewJoin;
import at.cdes.api.joinDto.PlanDeliverSaveJoin;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.ReviewCycleStatusSearchDelay;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcDocumentDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcNetworkDAO;
import at.cdes.impl.dao.jdbc.JdbcDocumentVersionDAO;
import at.cdes.impl.dao.jdbc.JdbcNetworkDAO;
import at.cdes.impl.dao.jdbc.JdbcProjectParticipantDAO;
import at.cdes.impl.dao.unionComponent.DocumentListComponent;
import at.cdes.impl.dao.unionComponent.DocumentSearchComponent;
import at.cdes.impl.dao.unionComponent.PlanDeliverNewComponent;
import at.cdes.impl.dao.unionComponent.PlanDeliverSaveComponent;
import at.cdes.impl.dao.util.RoleHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import at.cdes.impl.util.holiday.HolidayCalculator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDocumentDAO
extends AbstractJdbcDocumentDAO
implements DocumentDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcDocumentDAO.class);

    @Override
    public List<DocumentNumberUniqueJoin> getUniqueJoinByObjectPlanners(final Collection<Long> objectPlannerIds) {
        String sql = "SELECT " + JdbcDocumentDAO.getDocumentNumberUniqueJoinSelectClause() + "FROM ((     document JOIN object_planner           ON document.object_planner_id = object_planner.id) LEFT JOIN project_participation    ON object_planner.planner_id = project_participation.id) WHERE object_planner.id IN (" + QueryHelper.getPlaceHolderSequence(objectPlannerIds.size()) + ")";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentNumberUniqueJoin>>(){

            public List<DocumentNumberUniqueJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long objectPlannerId : objectPlannerIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentNumberUniqueJoin> ret = new ArrayList<DocumentNumberUniqueJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcDocumentDAO.fillDocumentNumberUniqueJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<Document> getByObject(final Long objectId) {
        String sql = "SELECT " + JdbcDocumentDAO.getSelectClauseForDto() + "FROM document WHERE document.object_planner_id IN (SELECT id from object_planner WHERE object_id = ?)";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Document>>(){

            public List<Document> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)objectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Document> ret = new ArrayList<Document>();
                while (rs.next()) {
                    ret.add(JdbcDocumentDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<DocumentNumberUniqueJoin> getByObjects(final Collection<Long> objectIds) {
        String sql = "SELECT " + JdbcDocumentDAO.getDocumentNumberUniqueJoinSelectClause() + "FROM ((      document JOIN object_planner        ON document.object_planner_id = object_planner.id) LEFT JOIN project_participation ON object_planner.planner_id = project_participation.id) WHERE object_planner.object_id IN (" + QueryHelper.getPlaceHolderSequence(objectIds.size()) + ")";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentNumberUniqueJoin>>(){

            public List<DocumentNumberUniqueJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long objectId : objectIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentNumberUniqueJoin> ret = new ArrayList<DocumentNumberUniqueJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcDocumentDAO.fillDocumentNumberUniqueJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<DocumentNumberUniqueJoin> getBySubproject(final Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentDAO.getDocumentNumberUniqueJoinSelectClause() + "FROM (((      document JOIN document_list ON document.document_list_id = document_list.id) JOIN object_planner        ON document.object_planner_id = object_planner.id) LEFT JOIN project_participation ON object_planner.planner_id = project_participation.id) WHERE document_list.sub_project_id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentNumberUniqueJoin>>(){

            public List<DocumentNumberUniqueJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentNumberUniqueJoin> ret = new ArrayList<DocumentNumberUniqueJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcDocumentDAO.fillDocumentNumberUniqueJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlanDeliverJoinDto> getPlanDeliverUnreleasedJoin(final PlanDeliverSearchModel searchModel) {
        String sql = "SELECT " + JdbcDocumentDAO.getPlanDeliverJoinDtoSelectClause() + ", (SELECT COUNT(1) FROM document_release WHERE document_release.document_id = document.id) FROM " + this.getUnreleasedPlanDeliverJoinFromClause(searchModel) + " WHERE " + this.getUnreleasedPlanDeliverJoinWhereClause(searchModel) + " ";
        if (log.isTraceEnabled()) {
            log.trace("Will query unreleased join SQL: " + sql);
        }
        if (log.isDebugEnabled()) {
            this.printSearchModelToDebug(searchModel);
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanDeliverJoinDto>>(){

            public List<PlanDeliverJoinDto> perform(PreparedStatement statement) throws Exception {
                JdbcDocumentDAO.this.populatePlanDeliverStatement(statement, searchModel, false);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanDeliverJoinDto> ret = new ArrayList<PlanDeliverJoinDto>();
                while (rs.next()) {
                    PlanDeliverJoinDto joinDto = AbstractJdbcDocumentDAO.fillPlanDeliverJoinDtoFromResultSet(rs);
                    int currIndex = AbstractJdbcDocumentDAO.getNumberOfPlanDeliverJoinDtoAttributes() + 1;
                    joinDto.setDerivedInfoNumberOfReleasedDocuments(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlanDeliverJoinDto> getPlanDeliverReleasedJoin(final PlanDeliverSearchModel searchModel) {
        String selectClause = JdbcDocumentDAO.getPlanDeliverJoinDtoSelectClause();
        String sql = "SELECT " + selectClause + ", (SELECT COUNT(1) FROM document_release WHERE document_release.document_id = document.id) FROM " + this.getReleasedPlanDeliverJoinFromClause(searchModel) + " WHERE " + this.getReleasedPlanDeliverJoinWhereClause(searchModel) + " ";
        sql = sql.replaceAll("document.name", "document_release.name");
        sql = sql.replaceAll("document.number", "document_release.number");
        sql = sql.replaceAll("document.startDate", "document_release.startDate");
        sql = sql.replaceAll("document.endDate", "document_release.endDate");
        sql = sql.replaceAll("document.duration", "document_release.duration");
        sql = sql.replaceAll("document.scale", "document_release.scale");
        sql = sql.replaceAll("document.content", "document_release.content");
        sql = sql.replaceAll("document.comment", "document_release.comment");
        sql = sql.replaceAll("document.modified", "document_release.modified");
        sql = sql.replaceAll("document.document_type_id", "document_release.document_type_id");
        sql = sql.replaceAll("document.object_planner_id", "document_release.object_planner_id");
        if (log.isTraceEnabled()) {
            log.trace("Will query released join SQL: " + sql);
        }
        if (log.isDebugEnabled()) {
            this.printSearchModelToDebug(searchModel);
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanDeliverJoinDto>>(){

            public List<PlanDeliverJoinDto> perform(PreparedStatement statement) throws Exception {
                JdbcDocumentDAO.this.populatePlanDeliverStatement(statement, searchModel, true);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanDeliverJoinDto> ret = new ArrayList<PlanDeliverJoinDto>();
                while (rs.next()) {
                    PlanDeliverJoinDto joinDto = AbstractJdbcDocumentDAO.fillPlanDeliverJoinDtoFromResultSet(rs);
                    int currIndex = AbstractJdbcDocumentDAO.getNumberOfPlanDeliverJoinDtoAttributes() + 1;
                    joinDto.setDerivedInfoNumberOfReleasedDocuments(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    private void printSearchModelToDebug(PlanDeliverSearchModel searchModel) {
        log.debug("subProjectId = [" + searchModel.getSubProjectId() + "]");
        log.debug("documentListId = [" + searchModel.getDocumentListId() + "]");
    }

    private String getUnreleasedPlanDeliverJoinFromClause(PlanDeliverSearchModel searchModel) {
        return "document_list LEFT JOIN document ON document.document_list_id = document_list.id " + this.getPlanDeliverJoinFromPostfix(searchModel);
    }

    private String getReleasedPlanDeliverJoinFromClause(PlanDeliverSearchModel searchModel) {
        return "document_release LEFT JOIN document                      ON document_release.document_id = document.id LEFT JOIN document_list                 ON document.document_list_id = document_list.id " + this.getPlanDeliverJoinFromPostfix(searchModel);
    }

    private String getPlanDeliverJoinFromPostfix(PlanDeliverSearchModel searchModel) {
        String sql = "LEFT JOIN document_type                ON document_type.id = document.document_type_id LEFT JOIN object_planner               ON document.object_planner_id = object_planner.id LEFT JOIN object                       ON object_planner.object_id = object.id LEFT JOIN object_list                  ON object.object_list_id = object_list.id LEFT JOIN sub_project                  ON object_list.sub_project_id = sub_project.id LEFT JOIN project                      ON sub_project.project_id = project.id LEFT JOIN object_planner_definition    ON object_planner_definition.project_id = project.id LEFT JOIN object_list_release          ON object_list_release.object_list_id = object_list.id LEFT JOIN object_release               ON object_release.object_id = object.id AND object_release.object_list_release_id = object_list_release.id LEFT JOIN object_planner_release       ON object_planner_release.object_planner_id = object_planner.id AND object_planner_release.object_id = object_release.id LEFT JOIN document_date_history_part   ON document_date_history_part.document_id = document.id LEFT JOIN project_participant history_project_participant ON document_date_history_part.project_participant_id = history_project_participant.id LEFT JOIN organisation_person history_organisation_person ON history_project_participant.organisation_person_id = history_organisation_person.id LEFT JOIN person history_person        ON history_organisation_person.person_id = history_person.id LEFT JOIN review_cycle_instance_released review_cycle_instance ON object_planner_release.review_cycle_instance_id = review_cycle_instance.id LEFT JOIN document_type document_type_group ON document_type_group.id = document_type.document_type_group_id LEFT JOIN object_type  ON object_release.object_type_id = object_type.id LEFT JOIN object_planner_position             ON object_planner_position.object_planner_id = object_planner.id LEFT JOIN project_participation search_project_participation ON (object_planner.planner_id = search_project_participation.id OR object_planner_position.project_participation_id = search_project_participation.id) AND (search_project_participation.invalidated IS NULL OR search_project_participation.invalidated = 0) LEFT JOIN cdes_role                           ON search_project_participation.role_id = cdes_role.id LEFT JOIN project_participation       ON object_planner_release.planner_id = project_participation.id AND (project_participation.invalidated IS NULL OR project_participation.invalidated = 0) LEFT JOIN organisation                ON project_participation.organisation_id = organisation.id LEFT JOIN project_participant         ON (project_participant.participation_id = project_participation.id) AND (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0)AND project_participant.main_participant_flag = 1 LEFT JOIN organisation_person         ON project_participant.organisation_person_id = organisation_person.id LEFT JOIN person                      ON organisation_person.person_id = person.id LEFT JOIN document_version first_version      ON first_version.document_id = document.id AND first_version.uploaded = (SELECT min(document_version_local.uploaded) FROM   document_version document_version_local WHERE  document_version_local.document_id = document.id) LEFT JOIN (((((document_version last_version LEFT JOIN document_version reactivated_version ON last_version.reactivated_document_version_id = reactivated_version.id) LEFT JOIN document_version revised_last_version ON last_version.revised_document_version_id = revised_last_version.id) LEFT JOIN review_cycle_node_instance node_instance ON node_instance.id = last_version.active_node_instance_id) LEFT JOIN review_cycle_node_result node_result ON node_result.review_cycle_node_id = node_instance.review_cycle_node_id AND node_result.document_version_id = last_version.id AND node_result.arrivalDate = (SELECT MAX(node_result_local.arrivalDate)  FROM review_cycle_node_result node_result_local  WHERE  node_result_local.review_cycle_node_id = node_instance.review_cycle_node_id  AND  node_result_local.document_version_id = last_version.id)) LEFT JOIN (review_cycle_position_result position_result JOIN review_cycle_result_option review_cycle_result_option ON position_result.review_cycle_result_option_id = review_cycle_result_option.id AND (   review_cycle_result_option.document_version_status = 2 OR review_cycle_result_option.document_version_status = 10)) ON position_result.document_version_id = last_version.id AND position_result.comment_reference_id IS NULL AND (last_version.status = 2 OR last_version.status = 10) AND position_result.result_date = (SELECT MAX(position_result_local.result_date)  FROM review_cycle_position_result position_result_local  WHERE position_result_local.document_version_id = last_version.id    AND position_result_local.comment_reference_id IS NULL)) ON last_version.document_id = document.id AND (last_version.status = 2 OR last_version.status = 10) AND last_version.uploaded = (SELECT MAX(document_version_local.uploaded) FROM   document_version document_version_local WHERE   document_version_local.document_id = document.id) ";
        if (searchModel.getPlannerOrgPersonId() != null || SearchHelper.isStringFilled(searchModel.getPlannerName())) {
            sql = sql + "LEFT JOIN organisation search_organisation    ON search_project_participation.organisation_id = search_organisation.id LEFT JOIN project_participant search_project_participant ON (search_project_participant.participation_id = search_project_participation.id) AND (search_project_participant.inactive_flag IS NULL OR search_project_participant.inactive_flag = 0)LEFT JOIN organisation_person search_organisation_person ON search_project_participant.organisation_person_id = search_organisation_person.id LEFT JOIN person search_person                ON search_organisation_person.person_id = search_person.id ";
        }
        return sql;
    }

    private String getUnreleasedPlanDeliverJoinWhereClause(PlanDeliverSearchModel searchModel) {
        return "document_list.sub_project_id = ? AND " + this.getPlanDeliverJoinWhereClause(searchModel, true);
    }

    private String getReleasedPlanDeliverJoinWhereClause(PlanDeliverSearchModel searchModel) {
        return "document_release.document_list_id = ? AND " + this.getPlanDeliverJoinWhereClause(searchModel, false);
    }

    private String getPlanDeliverJoinWhereClause(PlanDeliverSearchModel searchModel, boolean unreleased) {
        int n;
        String whereClause = "object_list_release.version = (SELECT MAX(object_list_release_local.version) FROM object_list_release object_list_release_local WHERE object_list_release_local.sub_project_id = ?) ";
        List<String> searchedNumbers = SearchHelper.extractAndConvertSearchTokens(searchModel.getDocumentNumber());
        List<String> searchedNames = SearchHelper.extractAndConvertSearchTokens(searchModel.getDocumentName());
        if (unreleased) {
            whereClause = whereClause + "AND (document.invalidated IS NULL OR document.invalidated = 0) ";
        }
        whereClause = whereClause + "AND (object_planner_release.id IS NOT NULL) ";
        if (searchModel.getCdesRoleId() != null) {
            whereClause = whereClause + "AND cdes_role.id = ? ";
        } else if (SearchHelper.isStringFilled(searchModel.getCdesRoleName())) {
            whereClause = whereClause + "AND cdes_role.name LIKE ? ";
        }
        if (searchModel.getPlannerOrgPersonId() != null) {
            whereClause = whereClause + "AND search_organisation_person.id = ? ";
        } else if (SearchHelper.isStringFilled(searchModel.getPlannerName())) {
            whereClause = whereClause + "AND CONCAT(search_organisation.name, ' (', search_person.givenName, ' ', search_person.surName, ')') LIKE ? ";
        }
        if (searchedNumbers.size() > 0) {
            whereClause = whereClause + "AND (0=1 ";
            for (n = 0; n < searchedNumbers.size(); ++n) {
                whereClause = whereClause + "OR document.name LIKE ? ";
            }
            whereClause = whereClause + ") ";
        }
        if (searchedNames.size() > 0) {
            whereClause = whereClause + "AND (0=1 ";
            for (n = 0; n < searchedNames.size(); ++n) {
                whereClause = whereClause + "OR document.content LIKE ? ";
            }
            whereClause = whereClause + ") ";
        }
        if (searchModel.getObjectReleaseId() != null) {
            whereClause = whereClause + "AND object_release.id = ? ";
        } else if (SearchHelper.isStringFilled(searchModel.getObjectReleaseString())) {
            whereClause = whereClause + "AND CONCAT(object_release.code, COALESCE(object_type.code, ''), ' ', object_release.name) LIKE ? ";
        }
        if (searchModel.getObjectPlannerReleaseId() != null) {
            whereClause = whereClause + "AND object_planner_release.id = ? ";
        } else if (SearchHelper.isStringFilled(searchModel.getObjectPlannerReleaseString())) {
            whereClause = whereClause + "AND CONCAT(object_planner_release.code, ' ', object_planner_release.area) LIKE ? ";
        }
        if (searchModel.getDocumentVersionFrom() != null) {
            whereClause = whereClause + "AND (document.startDate >= ? OR document.endDate >= ?) ";
        }
        if (searchModel.getDocumentVersionTo() != null) {
            whereClause = whereClause + "AND (document.startDate <= ? OR document.endDate <= ?) ";
        }
        return whereClause;
    }

    private void populatePlanDeliverStatement(PreparedStatement statement, PlanDeliverSearchModel searchModel, boolean released) throws SQLException {
        Timestamp timeStamp;
        Object searchString;
        List<String> searchedNumbers = SearchHelper.extractAndConvertSearchTokens(searchModel.getDocumentNumber());
        List<String> searchedNames = SearchHelper.extractAndConvertSearchTokens(searchModel.getDocumentName());
        if (released) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)searchModel.getDocumentListId());
            if (log.isDebugEnabled()) {
                log.debug("Setting query parameter 1: documentListId = [" + searchModel.getDocumentListId() + "]");
            }
        } else {
            JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)searchModel.getSubProjectId());
            if (log.isDebugEnabled()) {
                log.debug("Setting query parameter 1: subProjectId = [" + searchModel.getSubProjectId() + "]");
            }
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)searchModel.getSubProjectId());
        if (log.isDebugEnabled()) {
            log.debug("Setting query parameter 2: subProjectId = [" + searchModel.getSubProjectId() + "]");
        }
        int index = 3;
        if (searchModel.getCdesRoleId() != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)index++, (Number)searchModel.getCdesRoleId());
        } else if (SearchHelper.isStringFilled(searchModel.getCdesRoleName())) {
            statement.setString(index++, SearchHelper.convertForSearch(searchModel.getCdesRoleName()));
        }
        if (searchModel.getPlannerOrgPersonId() != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)index++, (Number)searchModel.getPlannerOrgPersonId());
        } else if (SearchHelper.isStringFilled(searchModel.getPlannerName())) {
            searchString = SearchHelper.convertForSearch(searchModel.getPlannerName());
            statement.setString(index++, (String)searchString);
        }
        if (searchedNumbers.size() > 0) {
            for (String searchedNumber : searchedNumbers) {
                statement.setString(index++, searchedNumber);
            }
        }
        if (searchedNames.size() > 0) {
            for (String searchedName : searchedNames) {
                statement.setString(index++, searchedName);
            }
        }
        if (searchModel.getObjectReleaseId() != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)index++, (Number)searchModel.getObjectReleaseId());
        } else if (SearchHelper.isStringFilled(searchModel.getObjectReleaseString())) {
            searchString = SearchHelper.convertForSearch(searchModel.getObjectReleaseString());
            statement.setString(index++, (String)searchString);
        }
        if (searchModel.getObjectPlannerReleaseId() != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)index++, (Number)searchModel.getObjectPlannerReleaseId());
        } else if (SearchHelper.isStringFilled(searchModel.getObjectPlannerReleaseString())) {
            searchString = SearchHelper.convertForSearch(searchModel.getObjectPlannerReleaseString());
            statement.setString(index++, (String)searchString);
        }
        if (searchModel.getDocumentVersionFrom() != null) {
            long utcMillis = (long)(searchModel.getDocumentVersionFrom() * 1000.0);
            timeStamp = new Timestamp(utcMillis);
            statement.setTimestamp(index++, timeStamp);
            statement.setTimestamp(index++, timeStamp);
        }
        if (searchModel.getDocumentVersionTo() != null) {
            long utcMillis = (long)(searchModel.getDocumentVersionTo() * 1000.0);
            timeStamp = new Timestamp(utcMillis);
            statement.setTimestamp(index++, timeStamp);
            statement.setTimestamp(index++, timeStamp);
        }
    }

    @Override
    public List<Document> getAllDocumentsForObjectPlanners(final List<Long> objectPlannerIds) {
        String sql = "SELECT " + JdbcDocumentDAO.getSelectClauseForDto() + "FROM document WHERE document.object_planner_id IN (";
        for (int n = 0; n < objectPlannerIds.size(); ++n) {
            sql = sql + "?" + (n < objectPlannerIds.size() - 1 ? ", " : ")");
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Document>>(){

            public List<Document> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long objectPlannerId : objectPlannerIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<Document> ret = new ArrayList<Document>();
                while (rs.next()) {
                    ret.add(JdbcDocumentDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlanDeliverNewJoin> getPlanDeliverNewJoin(final Long objectPlannerId) {
        String sql = "SELECT " + this.getNewUnionSelectClause(PlanDeliverNewComponent.OBJECT_PLANNER, "documentList", "object", "objectList", "objectPlanner", "objectRelease", "objectPlannerRelease", "organisation", "person", "project", "subProject", "projectParticipation", "reviewCycleInstance") + "FROM ((((((((((((( object_planner LEFT JOIN object                            ON object_planner.object_id = object.id) LEFT JOIN object_list                       ON object.object_list_id = object_list.id) LEFT JOIN sub_project                       ON object_list.sub_project_id = sub_project.id) LEFT JOIN project                           ON sub_project.project_id = project.id) LEFT JOIN document_list                     ON document_list.sub_project_id = sub_project.id) LEFT JOIN project_participation             ON object_planner.planner_id = project_participation.id) LEFT JOIN organisation                      ON project_participation.organisation_id = organisation.id) LEFT JOIN project_participant               ON project_participant.participation_id = project_participation.id) LEFT JOIN organisation_person               ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person                            ON organisation_person.person_id = person.id) LEFT JOIN object_list_release               ON object_list_release.sub_project_id = sub_project.id AND object_list_release.version = object_list.version - 1) LEFT JOIN (      object_release \t\t\tJOIN object_planner_release ON object_planner_release.object_id = object_release.id) ON object_release.object_list_release_id = object_list_release.id AND object_planner_release.object_planner_id = object_planner.id) LEFT JOIN review_cycle_instance_released review_cycle_instance ON object_planner_release.review_cycle_instance_id = review_cycle_instance.id) WHERE object_planner.id = ? UNION ALL SELECT " + this.getNewUnionSelectClause(PlanDeliverNewComponent.PROJECT_HOLIDAY, "projectHoliday") + "FROM ((((( object_planner  LEFT JOIN object                            ON object_planner.object_id = object.id) LEFT JOIN object_list                       ON object.object_list_id = object_list.id) LEFT JOIN sub_project                       ON object_list.sub_project_id = sub_project.id) LEFT JOIN project                           ON sub_project.project_id = project.id) LEFT JOIN project_holiday                   ON project_holiday.project_id = project.id) WHERE object_planner.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanDeliverNewJoin>>(){

            public List<PlanDeliverNewJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)objectPlannerId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)objectPlannerId);
                ArrayList<PlanDeliverNewJoin> results = new ArrayList<PlanDeliverNewJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PlanDeliverNewJoin joinDto = AbstractJdbcDocumentDAO.fillPlanDeliverNewJoinFromResultSet(rs);
                    int currIndex = AbstractJdbcDocumentDAO.getNumberOfPlanDeliverNewJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                HashMap<Long, Long> objectPlannerIdToDocumentListId = new HashMap<Long, Long>();
                for (PlanDeliverNewJoin dto : results) {
                    Long objectPlannerId2 = dto.getObjectPlannerId();
                    Long documentListId = dto.getDocumentListId();
                    if (objectPlannerId2 == null || documentListId == null) continue;
                    if (objectPlannerIdToDocumentListId.get(objectPlannerId2) != null && !documentListId.equals(objectPlannerIdToDocumentListId.get(objectPlannerId2))) {
                        throw new DAOException("More than one document list exists for subProject [" + dto.getSubProjectId() + "]; one of them has id [" + documentListId + "] for objectPlanner [" + objectPlannerId2 + "]");
                    }
                    objectPlannerIdToDocumentListId.put(objectPlannerId2, documentListId);
                }
                return results;
            }
        });
    }

    private String getNewUnionSelectClause(PlanDeliverNewComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForPlanDeliverNewJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<PlanDeliverSaveJoin> getPlanDeliverSaveJoin(final List<Long> documentIds, final Long organisationPersonId, final Long subProjectId, final Long projectId) {
        final String[] signerActionNames = new String[]{Action.EDIT_PLAN_DELIVER_CATALOGUE.getName(), Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES.getName(), Action.EDIT_PLAN_DELIVER_CATALOGUE_START_DATE.getName(), Action.EDIT_PLAN_DELIVER_CATALOGUE_END_DATE.getName(), Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES_PROJ_CONT.getName()};
        final String sql = "SELECT " + this.getSaveUnionSelectClause(PlanDeliverSaveComponent.DOCUMENT, "document", "lastVersion", "reactivatedVersion", "objectPlanner", "object", "objectList", "subProject", "project", "projectParticipation", "objectPlannerRelease", "objectRelease", "documentRelease") + "FROM ((((((((((((( document  LEFT JOIN document_version last_version ON          last_version.document_id = document.id AND (last_version.status = 2 OR last_version.status = 10) AND last_version.uploaded = (SELECT MAX(document_version_local.uploaded) FROM   document_version document_version_local WHERE   document_version_local.document_id = document.id)) LEFT JOIN document_version reactivated_version ON last_version.reactivated_document_version_id = reactivated_version.id) LEFT JOIN object_planner                ON document.object_planner_id = object_planner.id) LEFT JOIN project_participation         ON object_planner.planner_id = project_participation.id) LEFT JOIN object                        ON object_planner.object_id = object.id) LEFT JOIN object_list                   ON object.object_list_id = object_list.id) LEFT JOIN sub_project                   ON object_list.sub_project_id = sub_project.id) LEFT JOIN project                       ON sub_project.project_id = project.id) LEFT JOIN object_list_release           ON object_list_release.sub_project_id = sub_project.id AND object_list.version = object_list_release.version + 1) LEFT JOIN (       object_planner_release  JOIN object_release   ON object_planner_release.object_id = object_release.id) ON      object_planner_release.object_planner_id = object_planner.id AND object_release.object_list_release_id = object_list_release.id) LEFT JOIN document_list           ON document_list.sub_project_id = sub_project.id) LEFT JOIN document_list_release   ON document_list.version = document_list_release.version + 1) LEFT JOIN document_release        ON document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id) WHERE sub_project.id = ? AND document.id IN (" + QueryHelper.getPlaceHolderSequence(documentIds.size()) + ") UNION ALL SELECT " + this.getSaveUnionSelectClause(PlanDeliverSaveComponent.SIGNER, "person", "projectParticipant") + JdbcProjectParticipantDAO.getGetSignerFromWhereClause(signerActionNames.length) + "UNION ALL SELECT " + this.getSaveUnionSelectClause(PlanDeliverSaveComponent.PROJECT_HOLIDAY, "projectHoliday") + "FROM project_holiday WHERE project_holiday.project_id = ? UNION ALL SELECT " + this.getSaveUnionSelectClause(PlanDeliverSaveComponent.PROJECT_LOCALISATION, "project", "localisation", "country") + "FROM ((project  LEFT JOIN localisation                              ON project.localisation_id = localisation.id) LEFT JOIN countries                                 ON localisation.country_id = countries.id) WHERE project.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanDeliverSaveJoin>>(){

            public List<PlanDeliverSaveJoin> perform(PreparedStatement statement) throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug("organisationPerson = [" + organisationPersonId + "]; projectId = [" + projectId + "]; subProjectId = [" + subProjectId + "]; documentIds = ");
                    for (Object documentId : documentIds) {
                        log.debug("===> [" + documentId + "]");
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("Will execute sql: " + sql);
                }
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                for (Long documentId : documentIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
                }
                currIndex = JdbcProjectParticipantDAO.populateSignerClause(statement, currIndex, organisationPersonId, projectId, signerActionNames);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                QueryHelper.checkNumberOfWildcards(sql, currIndex);
                ArrayList<PlanDeliverSaveJoin> results = new ArrayList<PlanDeliverSaveJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PlanDeliverSaveJoin joinDto = AbstractJdbcDocumentDAO.fillPlanDeliverSaveJoinFromResultSet(rs);
                    currIndex = AbstractJdbcDocumentDAO.getNumberOfPlanDeliverSaveJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getSaveUnionSelectClause(PlanDeliverSaveComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForPlanDeliverSaveJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<DocumentSearchJoin> getDocumentSearchJoin(final Long subProjectId) {
        final String sql = "SELECT " + this.getDocumentSearchUnionSelectClause(DocumentSearchComponent.DOCUMENT_TYPE, "documentType") + "FROM ((( sub_project JOIN project              ON sub_project.project_id = project.id) JOIN document_number_part_group        ON project.document_number_part_group_id = document_number_part_group.id) JOIN document_type                     ON document_number_part_group.master_data_set_id = document_type.master_data_set_id) WHERE sub_project.id = ? UNION ALL SELECT " + this.getDocumentSearchUnionSelectClause(DocumentSearchComponent.NETWORK, "network", "subProject") + "FROM ((       sub_project JOIN project      ON sub_project.project_id = project.id) JOIN network      ON project.network_id = network.id) WHERE sub_project.id = ? UNION ALL SELECT " + this.getDocumentSearchUnionSelectClause(DocumentSearchComponent.OBJECT_RELEASE, "objectRelease", "objectType", "objectPlannerRelease") + "FROM (((      object_list_release JOIN object_release             ON object_release.object_list_release_id = object_list_release.id) JOIN object_planner_release     ON object_planner_release.object_id = object_release.id) LEFT JOIN object_type           ON object_release.object_type_id = object_type.id) WHERE object_list_release.sub_project_id = ? AND object_list_release.version = (SELECT MAX(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = ?) UNION ALL SELECT " + this.getDocumentSearchUnionSelectClause(DocumentSearchComponent.OBJECT_PLANNER_POSITION_PERSON, "cdesRole", "person", "organisation", "organisationPerson") + RoleHelper.getObjectPlannerPositionRoleClause() + "UNION ALL SELECT " + this.getDocumentSearchUnionSelectClause(DocumentSearchComponent.OBJECT_PLANNER_PERSON, "cdesRole", "person", "organisation", "organisationPerson") + RoleHelper.getObjectPlannerRoleClause() + "UNION ALL SELECT " + this.getDocumentSearchUnionSelectClause(DocumentSearchComponent.CDES_ROLE, "cdesRole") + "FROM (((    cdes_role JOIN network                 ON cdes_role.network_id = network.id) JOIN project                 ON project.network_id = network.id) JOIN sub_project             ON sub_project.project_id = project.id) WHERE sub_project.id = ? AND cdes_role.project_flag NOT IN (7, 8) UNION ALL SELECT " + this.getDocumentSearchUnionSelectClause(DocumentSearchComponent.REVIEW_CYCLE_INSTANCE_RELEASED, "reviewCycleInstanceReleased") + "FROM ((   review_cycle_instance_released JOIN object_list_release     ON review_cycle_instance_released.object_list_id = object_list_release.id) JOIN object_list             ON object_list_release.object_list_id = object_list.id) WHERE review_cycle_instance_released.sub_project_id = ? AND object_list_release.version = object_list.version - 1 ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentSearchJoin>>(){

            public List<DocumentSearchJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                QueryHelper.checkNumberOfWildcards(sql, currIndex);
                ArrayList<DocumentSearchJoin> results = new ArrayList<DocumentSearchJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    DocumentSearchJoin joinDto = AbstractJdbcDocumentDAO.fillDocumentSearchJoinFromResultSet(rs);
                    currIndex = AbstractJdbcDocumentDAO.getNumberOfDocumentSearchJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getDocumentSearchUnionSelectClause(DocumentSearchComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForDocumentSearchJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<DocumentListSmallJoin> getDocumentListSmallJoins(final DocumentSearchModel searchModel, final HolidayCalculator holidayCalculator) {
        final StringBuffer sql = new StringBuffer("SELECT " + this.getDocumentListSmallUnionSelectClause(DocumentListComponent.BASE, "document", "documentRelease", "documentVersion", "reviewCycleInstanceReleased", "reviewCycleCellResult", "reviewCycleNodeResult", "reviewCyclePositionResult", "object", "objectRelease", "objectPlanner", "objectPlannerRelease", "objectReleaseObjectType", "objectListRelease", "project", "subProject", "reviewCycleNodeInstance", "previewSupportDocumentVersion", "revisedDocumentVersion", "allNodeDepNodeInstanceReleased", "allNodeDepSignature", "plannerMainPerson", "plannerOrganisation") + "FROM (((( " + JdbcDocumentDAO.getDocumentListJoinBaseClause(true) + JdbcDocumentVersionDAO.getPreviewSupportDocumentVersionClause() + "LEFT JOIN project_participation  ON object_planner_release.planner_id = project_participation.id LEFT JOIN project_participant planner_participant ON planner_participant.participation_id = project_participation.id AND planner_participant.main_participant_flag = 1 AND planner_participant.inactive_flag = 0 LEFT JOIN organisation_person    ON planner_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation planner_organisation ON organisation_person.organisation_id = planner_organisation.id LEFT JOIN person planner_main_person ON organisation_person.person_id = planner_main_person.id LEFT JOIN sub_project            ON object_list.sub_project_id = sub_project.id\n LEFT JOIN project                ON sub_project.project_id = project.id\n LEFT JOIN document_version revised_document_version ON document_version.revised_document_version_id = revised_document_version.id LEFT JOIN review_cycle_position_result\n ON     review_cycle_position_result.document_version_id = document_version.id\n AND review_cycle_position_result.comment_reference_id IS NULL\n AND review_cycle_position_result.id =\n (SELECT max(local_position_result.id)\n FROM review_cycle_position_result local_position_result\n WHERE local_position_result.document_version_id = document_version.id\n AND local_position_result.comment_reference_id IS NULL\n AND local_position_result.result_date =\n (SELECT max(local_review_cycle_position_result.result_date)\n FROM review_cycle_position_result local_review_cycle_position_result\n JOIN review_cycle_node posres_review_cycle_node\n ON local_review_cycle_position_result.review_cycle_node_id = posres_review_cycle_node.id AND posres_review_cycle_node.free = 0\n WHERE local_review_cycle_position_result.document_version_id = document_version.id\n AND local_review_cycle_position_result.comment_reference_id IS NULL))\n LEFT JOIN review_cycle_cell_result ON review_cycle_cell_result.document_version_id = document_version.id LEFT JOIN review_cycle_node_result ON review_cycle_node_result.review_cycle_cell_result_id = review_cycle_cell_result.id LEFT JOIN object_list_release all_node_dep_object_list_release ON review_cycle_node_result.departure_object_list_id = all_node_dep_object_list_release.id\nLEFT JOIN object_release all_node_dep_object_release ON     all_node_dep_object_release.object_list_release_id = all_node_dep_object_list_release.id\nAND all_node_dep_object_release.object_id = object.id\nLEFT JOIN object_planner_release all_node_dep_object_planner_release ON     all_node_dep_object_planner_release.object_planner_id = object_planner.id AND all_node_dep_object_planner_release.object_id = all_node_dep_object_release.id\nLEFT JOIN review_cycle_instance_released all_node_dep_instance_released ON all_node_dep_object_planner_release.review_cycle_instance_id = all_node_dep_instance_released.id\nLEFT JOIN (     review_cycle_cell_instance_released all_node_dep_cell_instance_released JOIN review_cycle_node_instance_released all_node_dep_node_instance_released ON all_node_dep_node_instance_released.review_cycle_cell_instance_id = all_node_dep_cell_instance_released.id)\nON    all_node_dep_cell_instance_released.review_cycle_instance_id = all_node_dep_instance_released.id AND all_node_dep_node_instance_released.review_cycle_node_id = review_cycle_node_result.review_cycle_node_id\nLEFT JOIN signature all_node_dep_signature         ON all_node_dep_object_list_release.signature_id = all_node_dep_signature.id\nWHERE 1=1 ");
        this.appendSearchModelWhereClauses(sql, searchModel);
        sql.append("UNION ALL ");
        sql.append("SELECT " + this.getDocumentListSmallUnionSelectClause(DocumentListComponent.INSTANCE, "document", "documentVersion", "reviewCycleInstanceReleased", "reviewCycleCellInstanceReleased", "reviewCycleNodeInstanceReleased", "reviewCycleNodePositionReleased", "realm", "reviewerParticipant", "reviewerOrganisation", "reviewerMainPerson") + "FROM " + JdbcDocumentDAO.getDocumentListJoinBaseClause(true) + "LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id\nLEFT JOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id\nLEFT JOIN review_cycle_node_position_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id\nLEFT JOIN realm                               ON review_cycle_node_position_released.realm_id = realm.id\nLEFT JOIN project_participation               ON review_cycle_node_position_released.project_participation_id = project_participation.id LEFT JOIN project_participant reviewer_participant ON     reviewer_participant.participation_id = project_participation.id AND reviewer_participant.main_participant_flag = 1 LEFT JOIN organisation_person reviewer_op     ON reviewer_participant.organisation_person_id = reviewer_op.id LEFT JOIN person reviewer_main_person         ON reviewer_op.person_id = reviewer_main_person.id LEFT JOIN organisation reviewer_organisation  ON reviewer_op.organisation_id = reviewer_organisation.id WHERE 1=1\n");
        this.appendSearchModelWhereClauses(sql, searchModel);
        return (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentListSmallJoin>>(){

            public List<DocumentListSmallJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                currIndex = JdbcDocumentDAO.this.populateStatement(currIndex, statement, searchModel, holidayCalculator, true);
                currIndex = JdbcDocumentDAO.this.populateStatement(currIndex, statement, searchModel, holidayCalculator, false);
                QueryHelper.checkNumberOfWildcards(sql.toString(), currIndex);
                ArrayList<DocumentListSmallJoin> results = new ArrayList<DocumentListSmallJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    DocumentListSmallJoin joinDto = AbstractJdbcDocumentDAO.fillDocumentListSmallJoinFromResultSet(rs);
                    currIndex = AbstractJdbcDocumentDAO.getNumberOfDocumentListSmallJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    @Override
    public List<DocumentListJoin> getDocumentListJoinByIds(final List<Long> documentVersionIds) {
        if (documentVersionIds.size() == 0) {
            return new ArrayList<DocumentListJoin>();
        }
        String sql = "SELECT " + this.getSelectClauseForDocumentListJoinUnion("documentVersion", "document", "documentRelease", "documentType", "objectRelease", "project", "objectPlanner") + " FROM (((((((((((( document_version JOIN document                   ON document_version.document_id = document.id) JOIN object_planner             ON document.object_planner_id = object_planner.id) JOIN object                     ON object_planner.object_id = object.id) JOIN object_list                ON object.object_list_id = object_list.id) JOIN sub_project                ON object_list.sub_project_id = sub_project.id) JOIN project                    ON sub_project.project_id = project.id) LEFT JOIN object_list_release    ON     object_list_release.object_list_id = object_list.id AND object_list_release.version  = (SELECT max(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.object_list_id = object_list.id)) LEFT JOIN object_release         ON     object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id) JOIN document_list          ON document.document_list_id = document_list.id) LEFT JOIN document_list_release  ON     document_list_release.document_list_id = document_list.id AND document_list_release.version  = (SELECT max(local_document_list_release.version) FROM document_list_release local_document_list_release WHERE local_document_list_release.document_list_id = document_list.id)) LEFT JOIN document_release       ON     document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id) LEFT JOIN document_type          ON (     (document_release.id IS NOT NULL AND document_release.document_type_id = document_type.id) OR (document_release.id IS NULL AND document.document_type_id = document_type.id))) WHERE document_version.id IN (" + QueryHelper.getPlaceHolderSequence(documentVersionIds.size()) + ") ";
        return (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentListJoin>>(){

            public List<DocumentListJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long documentVersionId : documentVersionIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                }
                ArrayList<DocumentListJoin> results = new ArrayList<DocumentListJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    DocumentListJoin joinDto = AbstractJdbcDocumentDAO.fillDocumentListJoinFromResultSet(rs);
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private static final String getDocumentListJoinBaseClause(boolean onlyMaxVersion) {
        return "       document\nJOIN object_planner         ON document.object_planner_id = object_planner.id\n JOIN object                 ON object_planner.object_id = object.id\n JOIN object_list            ON object.object_list_id = object_list.id\n LEFT JOIN object_list_release ON     object_list_release.object_list_id = object_list.id\n AND object_list_release.version = object_list.version - 1\n LEFT JOIN object_release    ON     object_release.object_list_release_id = object_list_release.id\n AND object_release.object_id = object.id\n LEFT JOIN object_type object_release_object_type ON object_release.object_type_id = object_release_object_type.id LEFT JOIN object_planner_release ON     object_planner_release.object_id = object_release.id\n AND object_planner_release.object_planner_id = object_planner.id\n LEFT JOIN review_cycle_instance_released\n ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id\n JOIN document_list          ON document.document_list_id = document_list.id\n LEFT JOIN document_list_release  ON     document_list_release.document_list_id = document_list.id\n AND document_list_release.version = document_list.version - 1\n LEFT JOIN document_release       ON     document_release.document_id = document.id\n AND document_release.document_list_id = document_list_release.id\n LEFT JOIN document_version search_dv ON search_dv.document_id = document.id\n" + (onlyMaxVersion ? "AND search_dv.uploaded = (SELECT MAX(local_dv.uploaded) FROM document_version local_dv WHERE local_dv.document_id = document.id)\n" : "") + "LEFT JOIN document_version        ON document_version.document_id = search_dv.document_id\n LEFT JOIN review_cycle_node_instance\n ON document_version.active_node_instance_id = review_cycle_node_instance.id\n LEFT JOIN review_cycle_node      ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id\n LEFT JOIN review_cycle_cell      ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id\n LEFT JOIN review_cycle           ON review_cycle_cell.review_cycle_id = review_cycle.id\n ";
    }

    @Override
    public List<DocumentListJoin> getDocumentListJoin(final DocumentSearchModel searchModel, final HolidayCalculator holidayCalculator, final Set<DocumentListComponent> components, boolean restrictToMaxVersion) {
        boolean first = true;
        final StringBuffer sql = new StringBuffer("");
        if (components.contains((Object)DocumentListComponent.BASE)) {
            first = false;
            sql.append("SELECT " + this.getDocumentListUnionSelectClause(DocumentListComponent.BASE, "documentVersion", "document", "documentRelease", "project", "subProject", "object", "objectRelease", "objectListRelease", "objectPlanner", "objectPlannerRelease", "objectReleaseObjectType", "plannerParticipant", "plannerOrganisation", "plannerMainPerson", "reviewerParticipant", "reviewerOrganisation", "reviewerPerson", "reviewerMainPerson", "isAttachedResult", "realm", "reviewCycleNodeInstance", "reviewCycleInstanceReleased", "reviewCycleCellResult", "reviewCycleNodeResult", "reviewCyclePositionResult", "reviewCycleResultOption", "reviewCycleNode", "reviewCycleCell", "documentType", "firstVersion", "otherVersion", "asBuiltFirstVersion", "previewSupportDocumentVersion", "revisedDocumentVersion", "allNodeDepNodeInstanceReleased", "allNodeDepSignature") + " FROM ((((\n" + JdbcDocumentDAO.getDocumentListJoinBaseClause(restrictToMaxVersion) + "JOIN document_type          ON document.document_type_id = document_type.id\nJOIN sub_project            ON object_list.sub_project_id = sub_project.id\n JOIN project                ON project.id = sub_project.project_id\n LEFT JOIN project_participation  ON object_planner_release.planner_id = project_participation.id LEFT JOIN project_participant planner_participant ON planner_participant.participation_id = project_participation.id AND planner_participant.main_participant_flag = 1 LEFT JOIN organisation_person    ON planner_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation planner_organisation ON organisation_person.organisation_id = planner_organisation.id LEFT JOIN person planner_main_person ON organisation_person.person_id = planner_main_person.id LEFT JOIN document_version revised_document_version ON revised_document_version.id = document_version.revised_document_version_id\n" + JdbcDocumentVersionDAO.getPreviewSupportDocumentVersionClause() + "LEFT JOIN review_cycle_cell_result     ON review_cycle_cell_result.document_version_id = document_version.id\nLEFT JOIN review_cycle_node_result     ON review_cycle_node_result.review_cycle_cell_result_id = review_cycle_cell_result.id\nLEFT JOIN review_cycle_position_result ON review_cycle_position_result.review_cycle_node_result_id = review_cycle_node_result.id\nLEFT JOIN review_cycle_result_option   ON review_cycle_position_result.review_cycle_result_option_id = review_cycle_result_option.id\n LEFT JOIN review_cycle_position_result is_attached_result ON is_attached_result.id = review_cycle_position_result.id AND EXISTS (SELECT 1 FROM attached_review_task_done_results_map WHERE attached_review_task_done_results_map.review_cycle_position_result_id = review_cycle_position_result.id) LEFT JOIN realm                        ON review_cycle_position_result.realm_id = realm.id LEFT JOIN project_participant reviewer_participant ON review_cycle_position_result.project_participant_id = reviewer_participant.id LEFT JOIN organisation_person reviewer_op ON reviewer_participant.organisation_person_id = reviewer_op.id LEFT JOIN organisation reviewer_organisation ON reviewer_op.organisation_id = reviewer_organisation.id LEFT JOIN person reviewer_person       ON reviewer_op.person_id = reviewer_person.id LEFT JOIN project_participant reviewer_main_participant ON reviewer_main_participant.participation_id = reviewer_participant.participation_id AND reviewer_main_participant.main_participant_flag = 1 LEFT JOIN organisation_person reviewer_main_op ON reviewer_main_participant.organisation_person_id = reviewer_main_op.id LEFT JOIN person reviewer_main_person  ON reviewer_main_op.person_id = reviewer_main_person.id LEFT JOIN object_list_release all_node_dep_object_list_release ON review_cycle_node_result.departure_object_list_id = all_node_dep_object_list_release.id\nLEFT JOIN object_release all_node_dep_object_release ON     all_node_dep_object_release.object_list_release_id = all_node_dep_object_list_release.id\nAND all_node_dep_object_release.object_id = object.id\nLEFT JOIN object_planner_release all_node_dep_object_planner_release ON     all_node_dep_object_planner_release.object_planner_id = object_planner.id AND all_node_dep_object_planner_release.object_id = all_node_dep_object_release.id\nLEFT JOIN review_cycle_instance_released all_node_dep_instance_released ON all_node_dep_object_planner_release.review_cycle_instance_id = all_node_dep_instance_released.id\nLEFT JOIN (     review_cycle_cell_instance_released all_node_dep_cell_instance_released JOIN review_cycle_node_instance_released all_node_dep_node_instance_released ON all_node_dep_node_instance_released.review_cycle_cell_instance_id = all_node_dep_cell_instance_released.id)\nON    all_node_dep_cell_instance_released.review_cycle_instance_id = all_node_dep_instance_released.id AND all_node_dep_node_instance_released.review_cycle_node_id = review_cycle_node_result.review_cycle_node_id\nLEFT JOIN signature all_node_dep_signature         ON all_node_dep_object_list_release.signature_id = all_node_dep_signature.id\nWHERE 1=1\n ");
            this.appendSearchModelWhereClauses(sql, searchModel);
            if (log.isDebugEnabled()) {
                log.debug(sql.toString());
            }
        }
        if (components.contains((Object)DocumentListComponent.INSTANCE)) {
            if (!first) {
                sql.append("UNION ALL ");
            }
            first = false;
            sql.append("SELECT " + this.getDocumentListUnionSelectClause(DocumentListComponent.INSTANCE, "document", "documentVersion", "reviewCycleInstanceReleased", "reviewCycleCellInstanceReleased", "reviewCycleNodeInstanceReleased", "reviewCycleNodePositionReleased", "realm", "reviewerParticipant", "reviewerOrganisation", "reviewerMainPerson") + "FROM " + JdbcDocumentDAO.getDocumentListJoinBaseClause(restrictToMaxVersion) + "LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id\nLEFT JOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id\nLEFT JOIN review_cycle_node_position_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id\nLEFT JOIN realm                               ON review_cycle_node_position_released.realm_id = realm.id\nLEFT JOIN project_participation               ON review_cycle_node_position_released.project_participation_id = project_participation.id LEFT JOIN project_participant reviewer_participant ON     reviewer_participant.participation_id = project_participation.id AND reviewer_participant.main_participant_flag = 1 LEFT JOIN organisation_person reviewer_op     ON reviewer_participant.organisation_person_id = reviewer_op.id LEFT JOIN person reviewer_main_person         ON reviewer_op.person_id = reviewer_main_person.id LEFT JOIN organisation reviewer_organisation  ON reviewer_op.organisation_id = reviewer_organisation.id WHERE 1=1\n");
            this.appendSearchModelWhereClauses(sql, searchModel);
        }
        if (components.contains((Object)DocumentListComponent.CYCLE)) {
            if (!first) {
                sql.append("UNION ALL ");
            }
            first = false;
            sql.append("SELECT " + this.getDocumentListUnionSelectClause(DocumentListComponent.CYCLE, "reviewCycle", "reviewCycleCell", "reviewCycleNode", "endNode", "reviewCycleCellConnection") + "FROM review_cycle\nLEFT JOIN review_cycle_cell ON review_cycle_cell.review_cycle_id = review_cycle.id\nLEFT JOIN review_cycle_node ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id\nLEFT JOIN review_cycle_position_type\nON review_cycle_node.review_cycle_position_type_id = review_cycle_position_type.id\nLEFT JOIN review_cycle_node end_node ON end_node.id = review_cycle_node.id AND NOT EXISTS (SELECT 1 FROM review_cycle_result_option WHERE review_cycle_result_option.review_cycle_position_type_id = review_cycle_position_type.id)\nLEFT JOIN review_cycle_cell_connection ON review_cycle_cell_connection.destination_cell_id = review_cycle_cell.id\n");
        }
        if (components.contains((Object)DocumentListComponent.CELL_CONNECTION_RESULT)) {
            if (!first) {
                sql.append("UNION ALL ");
            }
            first = false;
            sql.append("SELECT " + this.getDocumentListUnionSelectClause(DocumentListComponent.CELL_CONNECTION_RESULT, "documentVersion", "reviewCycleCellConnectionResult", "reviewCycleCellConnectionStatementResult", "realm", "reviewCycleResultOption", "destCellResult", "plannerParticipant", "plannerOrganisation", "plannerMainPerson", "plannerPerson") + "FROM " + JdbcDocumentDAO.getDocumentListJoinBaseClause(restrictToMaxVersion) + "JOIN review_cycle_cell_connection_result       ON review_cycle_cell_connection_result.destination_document_version_id = document_version.id LEFT JOIN review_cycle_cell_connection_statement_result ON review_cycle_cell_connection_statement_result.review_cycle_cell_connection_result_id = review_cycle_cell_connection_result.id LEFT JOIN realm                                     ON review_cycle_cell_connection_statement_result.realm_id = realm.id LEFT JOIN review_cycle_result_option                ON review_cycle_cell_connection_statement_result.review_cycle_result_option_id = review_cycle_result_option.id LEFT JOIN project_participant planner_participant   ON review_cycle_cell_connection_result.project_participant_id = planner_participant.id LEFT JOIN organisation_person                       ON planner_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation planner_organisation         ON organisation_person.organisation_id = planner_organisation.id LEFT JOIN person planner_person                     ON organisation_person.person_id = planner_person.id LEFT JOIN project_participant main_participant      ON main_participant.participation_id = planner_participant.participation_id AND main_participant.main_participant_flag = 1 LEFT JOIN organisation_person main_op               ON main_participant.organisation_person_id = main_op.id LEFT JOIN person planner_main_person                ON main_op.person_id = planner_main_person.id LEFT JOIN review_cycle_cell_result dest_cell_result ON review_cycle_cell_connection_result.destination_review_cycle_cell_result_id = dest_cell_result.id WHERE 1=1\n");
            this.appendSearchModelWhereClauses(sql, searchModel);
        }
        if (components.contains((Object)DocumentListComponent.ENTRY_RESULT)) {
            if (!first) {
                sql.append("UNION ALL ");
            }
            first = false;
            sql.append("SELECT " + this.getDocumentListUnionSelectClause(DocumentListComponent.ENTRY_RESULT, "documentVersion", "reviewCycleEntryResult", "reviewCycleEntryStatementResult", "realm", "reviewCycleResultOption", "plannerParticipant", "plannerOrganisation", "plannerMainPerson", "plannerPerson") + "FROM " + JdbcDocumentDAO.getDocumentListJoinBaseClause(restrictToMaxVersion) + "JOIN review_cycle_entry_result               ON review_cycle_entry_result.document_version_id = document_version.id LEFT JOIN review_cycle_entry_statement_result     ON review_cycle_entry_statement_result.review_cycle_entry_result_id = review_cycle_entry_result.id LEFT JOIN realm                                   ON review_cycle_entry_statement_result.realm_id = realm.id LEFT JOIN review_cycle_result_option              ON review_cycle_entry_statement_result.review_cycle_result_option_id = review_cycle_result_option.id LEFT JOIN project_participant planner_participant ON review_cycle_entry_result.project_participant_id = planner_participant.id LEFT JOIN organisation_person                     ON planner_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation planner_organisation       ON organisation_person.organisation_id = planner_organisation.id LEFT JOIN person planner_person                   ON organisation_person.person_id = planner_person.id LEFT JOIN project_participant main_participant    ON main_participant.participation_id = planner_participant.participation_id AND main_participant.main_participant_flag = 1 LEFT JOIN organisation_person main_op             ON main_participant.organisation_person_id = main_op.id LEFT JOIN person planner_main_person              ON main_op.person_id = planner_main_person.id WHERE 1=1\n");
            this.appendSearchModelWhereClauses(sql, searchModel);
        }
        if (components.contains((Object)DocumentListComponent.ATTACHED_NODE_POSITION)) {
            if (!first) {
                sql.append("UNION ALL ");
            }
            first = false;
            sql.append("SELECT " + this.getDocumentListUnionSelectClause(DocumentListComponent.ATTACHED_NODE_POSITION, "documentVersion", "attachedReviewCycleNodePosition", "reviewerParticipant", "reviewerMainPerson", "reviewerOrganisation", "realm") + "FROM " + JdbcDocumentDAO.getDocumentListJoinBaseClause(restrictToMaxVersion) + "JOIN attached_review_cycle_node_position ON attached_review_cycle_node_position.document_version_id = document_version.id LEFT JOIN realm                               ON attached_review_cycle_node_position.realm_id = realm.id JOIN project_participation               ON attached_review_cycle_node_position.project_participation_id = project_participation.id JOIN project_participant reviewer_participant ON     reviewer_participant.participation_id = project_participation.id AND reviewer_participant.main_participant_flag = 1 JOIN organisation_person reviewer_op     ON reviewer_participant.organisation_person_id = reviewer_op.id JOIN person reviewer_main_person         ON reviewer_op.person_id = reviewer_main_person.id JOIN organisation reviewer_organisation  ON reviewer_op.organisation_id = reviewer_organisation.id WHERE 1=1 ");
            this.appendSearchModelWhereClauses(sql, searchModel);
        }
        if (log.isTraceEnabled()) {
            log.trace("Querying sql: " + sql);
        }
        return (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentListJoin>>(){

            public List<DocumentListJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (components.contains((Object)DocumentListComponent.BASE)) {
                    currIndex = JdbcDocumentDAO.this.populateStatement(currIndex, statement, searchModel, holidayCalculator, true);
                }
                if (components.contains((Object)DocumentListComponent.INSTANCE)) {
                    currIndex = JdbcDocumentDAO.this.populateStatement(currIndex, statement, searchModel, holidayCalculator, false);
                }
                if (components.contains((Object)DocumentListComponent.CELL_CONNECTION_RESULT)) {
                    currIndex = JdbcDocumentDAO.this.populateStatement(currIndex, statement, searchModel, holidayCalculator, false);
                }
                if (components.contains((Object)DocumentListComponent.ENTRY_RESULT)) {
                    currIndex = JdbcDocumentDAO.this.populateStatement(currIndex, statement, searchModel, holidayCalculator, false);
                }
                if (components.contains((Object)DocumentListComponent.ATTACHED_NODE_POSITION)) {
                    currIndex = JdbcDocumentDAO.this.populateStatement(currIndex, statement, searchModel, holidayCalculator, false);
                }
                QueryHelper.checkNumberOfWildcards(sql.toString(), currIndex);
                ArrayList<DocumentListJoin> results = new ArrayList<DocumentListJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    DocumentListJoin joinDto = AbstractJdbcDocumentDAO.fillDocumentListJoinFromResultSet(rs);
                    currIndex = AbstractJdbcDocumentDAO.getNumberOfDocumentListJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getDocumentListUnionSelectClause(DocumentListComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForDocumentListJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    private String getDocumentListSmallUnionSelectClause(DocumentListComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForDocumentListSmallJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    private void appendSearchModelWhereClauses(StringBuffer sql, DocumentSearchModel searchModel) {
        boolean searchForReviewCycleIds;
        Long documentVersionId = searchModel.getDocumentVersionId();
        List<String> searchedNames = SearchHelper.extractAndConvertSearchTokens(searchModel.getName());
        List<String> searchedContents = SearchHelper.extractAndConvertSearchTokens(searchModel.getContent());
        List searchedReviewCycleNodeIds = searchModel.getReviewCycleNodeIds();
        List searchedReviewCycleCellIds = searchModel.getReviewCycleCellIds();
        List searchedReviewCycleIds = searchModel.getReviewCycleIds();
        Integer searchedStatus = searchModel.getStatus();
        Integer searchedDelayOption = searchModel.getDelayOption();
        Long searchedDocumentTypeId = searchModel.getDocumentTypeId();
        Long reviewCycleInstanceReleasedId = searchModel.getReviewCycleInstanceReleasedId();
        String reviewCycleInstanceReleasedName = searchModel.getReviewCycleInstanceReleasedName();
        Long plannerOrgPersonId = searchModel.getPlannerOrgPersonId();
        String plannerName = searchModel.getPlannerName();
        Long cdesRoleId = searchModel.getCdesRoleId();
        String cdesRoleName = searchModel.getCdesRoleName();
        if (documentVersionId != null) {
            sql.append("AND search_dv.id = ?\n");
        }
        if (searchModel.getShowDeleted() == null || !searchModel.getShowDeleted().booleanValue()) {
            sql.append("AND document.invalidated != 1\n ");
        }
        if (reviewCycleInstanceReleasedId != null) {
            sql.append("AND review_cycle_instance_released.id = ? ");
        }
        if (reviewCycleInstanceReleasedName != null) {
            sql.append("AND review_cycle_instance_released.name LIKE ? ");
        }
        if (plannerOrgPersonId != null || SearchHelper.isStringFilled(plannerName) || cdesRoleId != null || SearchHelper.isStringFilled(cdesRoleName)) {
            String participationSelect = "AND EXISTS (SELECT 1\n FROM (((((\n project_participation search_participation\n JOIN cdes_role search_role                  ON search_participation.role_id = search_role.id)\n JOIN organisation search_organisation        ON search_participation.organisation_id = search_organisation.id)\n JOIN project_participant search_participant  ON      search_participant.participation_id = search_participation.id\n AND search_participant.inactive_flag = 0)\n JOIN organisation_person search_org_person   ON      search_participant.organisation_person_id = search_org_person.id\n AND search_org_person.retired_flag = 0)\n JOIN person search_person                    ON search_org_person.person_id = search_person.id)\n WHERE     search_participation.invalidated = 0\n AND (    object_planner_release.planner_id = search_participation.id\n OR EXISTS (SELECT 1\n FROM object_planner_position_release\n WHERE     object_planner_position_release.project_participation_id = search_participation.id\n AND object_planner_position_release.object_planner_id = object_planner_release.id))\n ";
            if (plannerOrgPersonId != null) {
                participationSelect = participationSelect + "AND search_org_person.id = ?\n ";
            } else if (SearchHelper.isStringFilled(plannerName)) {
                participationSelect = participationSelect + "AND CONCAT(search_organisation.name, ' (', search_person.givenName, ' ', search_person.surName, ')') LIKE ?\n ";
            }
            if (cdesRoleId != null) {
                participationSelect = participationSelect + "AND search_role.id = ?\n ";
            } else if (SearchHelper.isStringFilled(cdesRoleName)) {
                participationSelect = participationSelect + "AND search_role.name LIKE ?\n ";
            }
            participationSelect = participationSelect + ")\n ";
            sql.append(participationSelect);
        }
        if (searchModel.getObjectPlannerId() != null) {
            sql.append("AND object_planner.id = ?\n ");
        } else if (searchModel.getAsBuiltObjectPlannerIds() != null && searchModel.getAsBuiltObjectPlannerIds().size() > 0) {
            sql.append("AND object_planner.id IN (" + QueryHelper.getPlaceHolderSequence(searchModel.getAsBuiltObjectPlannerIds().size()) + ")\n ");
        }
        if (searchModel.getObjectId() != null) {
            sql.append("AND object.id = ?\n ");
        }
        if (documentVersionId == null && searchModel.getObjectPlannerId() == null && searchModel.getObjectId() == null) {
            sql.append("AND object_list.sub_project_id = ?\n ");
        }
        if (searchedStatus != null) {
            if (searchedStatus.intValue() == DocumentVersionStatus.NOTUPLOADED.getValue()) {
                sql.append("AND search_dv.id IS NULL\n");
            } else if (searchedStatus.intValue() == DocumentVersionStatus.NOTINREVIEW.getValue()) {
                sql.append("AND search_dv.status NOT IN (?, ?, ?, ?)\n ");
            } else if (searchedStatus.intValue() == DocumentVersionStatus.ACTIVE.getValue()) {
                sql.append("AND search_dv.status NOT IN (?, ?, ?)\n ");
            } else {
                sql.append("AND search_dv.status = ?\n ");
            }
        }
        if (searchedDelayOption != null) {
            String endDateClause = searchedDelayOption.intValue() == ReviewCycleStatusSearchDelay.NO_DELAY.getValue() ? "AND task.end_date > ?\n " : "AND task.end_date < ?\n ";
            sql.append("AND EXISTS (SELECT 1\n FROM ((((\n task\n JOIN document_version_task       ON document_version_task.task_id = task.id)\n LEFT JOIN review_task                 ON review_task.task_id = task.id)\n LEFT JOIN attached_review_task        ON attached_review_task.task_id = task.id)\n LEFT JOIN select_cell_connection_task ON select_cell_connection_task.task_id = task.id)\n WHERE document_version_task.document_version_id = search_dv.id\n AND (    review_task.task_id IS NOT NULL\n OR attached_review_task.task_id IS NOT NULL\n OR select_cell_connection_task.task_id IS NOT NULL)\n " + endDateClause + ")\n ");
        }
        if (searchedDocumentTypeId != null) {
            sql.append("AND (      (document_release.id IS NOT NULL AND document_release.document_type_id LIKE ?)\n OR (document_release.id IS NULL AND document.document_type_id LIKE ?))\n ");
        }
        if (searchedNames.size() > 0) {
            sql.append("AND (0=1\n ");
            for (int n = 0; n < searchedNames.size(); ++n) {
                sql.append("OR (   (search_dv.id IS NOT NULL AND search_dv.name LIKE ?)\n OR (search_dv.id IS NULL AND document_release.id IS NOT NULL AND document_release.name LIKE ?)\n OR (search_dv.id IS NULL AND document_release.id IS NULL AND document.name LIKE ?))\n ");
            }
            sql.append(")\n ");
        }
        if (searchedContents.size() > 0) {
            sql.append("AND (0=1\n ");
            for (int n = 0; n < searchedContents.size(); ++n) {
                sql.append("OR (   (document_release.id IS NOT NULL AND document_release.content LIKE ?)\n OR (document_release.id IS NULL AND document.content LIKE ?))\n ");
            }
            sql.append(")\n ");
        }
        if (searchModel.getUploadedFrom() != null) {
            sql.append("AND search_dv.uploaded >= ?\n ");
        }
        if (searchModel.getUploadedTo() != null) {
            sql.append("AND search_dv.uploaded <= ?\n ");
        }
        boolean searchForReviewCycleNodeIds = searchedReviewCycleNodeIds != null && searchedReviewCycleNodeIds.size() > 0;
        boolean searchForReviewCycleCellIds = searchedReviewCycleCellIds != null && searchedReviewCycleCellIds.size() > 0;
        boolean bl = searchForReviewCycleIds = searchedReviewCycleIds != null && searchedReviewCycleIds.size() > 0;
        if (searchForReviewCycleNodeIds || searchForReviewCycleCellIds || searchForReviewCycleIds) {
            sql.append("AND (0=1\n ");
            if (searchForReviewCycleNodeIds) {
                sql.append("OR review_cycle_node.id IN (" + QueryHelper.getPlaceHolderSequence(searchedReviewCycleNodeIds.size()) + ")\n ");
            }
            if (searchForReviewCycleCellIds) {
                sql.append("OR review_cycle_cell.id IN (" + QueryHelper.getPlaceHolderSequence(searchedReviewCycleCellIds.size()) + ")\n ");
            }
            if (searchForReviewCycleIds) {
                sql.append("OR review_cycle.id IN (" + QueryHelper.getPlaceHolderSequence(searchedReviewCycleIds.size()) + ")\n ");
            }
            sql.append(")\n ");
        }
    }

    private int populateStatement(int currIndex, PreparedStatement statement, DocumentSearchModel searchModel, HolidayCalculator holidayCalculator, boolean withPreviewSupport) throws Exception {
        boolean searchForReviewCycleIds;
        Long documentVersionId = searchModel.getDocumentVersionId();
        List<String> searchedNames = SearchHelper.extractAndConvertSearchTokens(searchModel.getName());
        List<String> searchedContents = SearchHelper.extractAndConvertSearchTokens(searchModel.getContent());
        List searchedReviewCycleNodeIds = searchModel.getReviewCycleNodeIds();
        List searchedReviewCycleCellIds = searchModel.getReviewCycleCellIds();
        List searchedReviewCycleIds = searchModel.getReviewCycleIds();
        Integer searchedStatus = searchModel.getStatus();
        Integer searchedDelayOption = searchModel.getDelayOption();
        Long searchedDocumentTypeId = searchModel.getDocumentTypeId();
        Long reviewCycleInstanceReleasedId = searchModel.getReviewCycleInstanceReleasedId();
        String reviewCycleInstanceReleasedName = searchModel.getReviewCycleInstanceReleasedName();
        Long plannerOrgPersonId = searchModel.getPlannerOrgPersonId();
        String plannerName = searchModel.getPlannerName();
        Long cdesRoleId = searchModel.getCdesRoleId();
        String cdesRoleName = searchModel.getCdesRoleName();
        boolean searchForReviewCycleNodeIds = searchedReviewCycleNodeIds != null && searchedReviewCycleNodeIds.size() > 0;
        boolean searchForReviewCycleCellIds = searchedReviewCycleCellIds != null && searchedReviewCycleCellIds.size() > 0;
        boolean bl = searchForReviewCycleIds = searchedReviewCycleIds != null && searchedReviewCycleIds.size() > 0;
        if (log.isDebugEnabled()) {
            log.debug("Will populate statement, currIndex is [" + currIndex + "]");
        }
        if (withPreviewSupport) {
            currIndex = JdbcDocumentVersionDAO.populatePreviewSupportDocumentVersionClause(statement, currIndex);
        }
        if (documentVersionId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
        }
        if (reviewCycleInstanceReleasedId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleInstanceReleasedId);
        }
        if (reviewCycleInstanceReleasedName != null) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(reviewCycleInstanceReleasedName));
        }
        if (plannerOrgPersonId != null) {
            if (log.isDebugEnabled()) {
                log.debug("... plannerOrgPersonId [" + plannerOrgPersonId + "]");
            }
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)plannerOrgPersonId);
        } else if (SearchHelper.isStringFilled(plannerName)) {
            if (log.isDebugEnabled()) {
                log.debug("... plannerName [" + plannerName + "]");
            }
            statement.setString(currIndex++, SearchHelper.convertForSearch(plannerName));
        }
        if (cdesRoleId != null) {
            if (log.isDebugEnabled()) {
                log.debug("... cdesRoleId [" + cdesRoleId + "]");
            }
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)cdesRoleId);
        } else if (SearchHelper.isStringFilled(cdesRoleName)) {
            if (log.isDebugEnabled()) {
                log.debug("... cdesRoleName [" + cdesRoleName + "]");
            }
            statement.setString(currIndex++, SearchHelper.convertForSearch(cdesRoleName));
        }
        if (searchModel.getObjectPlannerId() != null) {
            if (log.isDebugEnabled()) {
                log.debug("... objectPlannerId [" + searchModel.getObjectPlannerId() + "]");
            }
            JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getObjectPlannerId());
        } else if (searchModel.getAsBuiltObjectPlannerIds() != null && searchModel.getAsBuiltObjectPlannerIds().size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("... asBuiltObjectPlannerIds [" + searchModel.getAsBuiltObjectPlannerIds() + "]");
            }
            currIndex = QueryHelper.setIdsToStatement(statement, currIndex, searchModel.getAsBuiltObjectPlannerIds());
        }
        if (searchModel.getObjectId() != null) {
            if (log.isDebugEnabled()) {
                log.debug("... objectId [" + searchModel.getObjectId() + "]");
            }
            JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getObjectId());
        }
        if (documentVersionId == null && searchModel.getObjectId() == null && searchModel.getObjectPlannerId() == null) {
            if (log.isDebugEnabled()) {
                log.debug("... subProjectId [" + searchModel.getSubProjectId() + "]");
            }
            JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getSubProjectId());
        }
        if (searchedStatus != null && searchedStatus.intValue() != DocumentVersionStatus.NOTUPLOADED.getValue()) {
            if (searchedStatus.intValue() == DocumentVersionStatus.NOTINREVIEW.getValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("... case NOTINREVIEW, 4 times DocumentVersionStatus");
                }
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.RELEASEDPOSITIV.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.INVALIDATEDALL.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.DELETED.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.PREREVIEWED.getValue());
            } else if (searchedStatus.intValue() == DocumentVersionStatus.ACTIVE.getValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("... case ACTIVE, 3 times DocumentVersionStatus");
                }
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.DELETED.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.INVALIDATEDVERSION.getValue());
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.INVALIDATEDALL.getValue());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("... searchedStatus [" + searchedStatus + "]");
                }
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)searchedStatus);
            }
        }
        if (searchedDelayOption != null) {
            Double currTime = new Double(System.currentTimeMillis()) / 1000.0;
            if (searchedDelayOption.intValue() == ReviewCycleStatusSearchDelay.NO_DELAY.getValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("... case NO_DELAY, [" + (currTime - 86400.0) + "]");
                }
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)(currTime - 86400.0));
            } else if (searchedDelayOption.intValue() == ReviewCycleStatusSearchDelay.DELAY.getValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("... case DELAY, [" + (currTime - 86400.0) + "]");
                }
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)(currTime - 86400.0));
            } else if (searchedDelayOption.intValue() == ReviewCycleStatusSearchDelay.LONG_DELAY.getValue()) {
                Double threeDaysBefore = holidayCalculator.addWorkingDays(currTime, -3);
                if (log.isDebugEnabled()) {
                    log.debug("... case LONG_DELAY, [" + threeDaysBefore + "]");
                }
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)threeDaysBefore);
            } else {
                throw new IllegalArgumentException("Unsupported delay option [" + searchedDelayOption + "]");
            }
        }
        if (searchedDocumentTypeId != null) {
            if (log.isDebugEnabled()) {
                log.debug("... two times searchedDocumentTypeId [" + searchedDocumentTypeId + "]");
            }
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchedDocumentTypeId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchedDocumentTypeId);
        }
        if (searchedNames.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("... searchedNames [" + searchedNames + "]");
            }
            for (String searchedName : searchedNames) {
                statement.setString(currIndex++, searchedName);
                statement.setString(currIndex++, searchedName);
                statement.setString(currIndex++, searchedName);
            }
        }
        if (searchedContents.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("... searchedContents [" + searchedContents + "]");
            }
            for (String searchedContent : searchedContents) {
                statement.setString(currIndex++, searchedContent);
                statement.setString(currIndex++, searchedContent);
            }
        }
        if (searchModel.getUploadedFrom() != null) {
            if (log.isDebugEnabled()) {
                log.debug("... uploadedFrom [" + searchModel.getUploadedFrom() + "]");
            }
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getUploadedFrom());
        }
        if (searchModel.getUploadedTo() != null) {
            if (log.isDebugEnabled()) {
                log.debug("... uploadedTo [" + searchModel.getUploadedTo() + "]");
            }
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getUploadedTo());
        }
        if (searchForReviewCycleIds) {
            if (log.isDebugEnabled()) {
                log.debug("... searchedReviewCycleIds [" + searchedReviewCycleIds + "]");
            }
            currIndex = QueryHelper.setIdsToStatement(statement, currIndex, searchedReviewCycleIds);
        }
        if (searchForReviewCycleCellIds) {
            if (log.isDebugEnabled()) {
                log.debug("... searchedReviewCycleCellIds [" + searchedReviewCycleCellIds + "]");
            }
            currIndex = QueryHelper.setIdsToStatement(statement, currIndex, searchedReviewCycleCellIds);
        }
        if (searchForReviewCycleNodeIds) {
            if (log.isDebugEnabled()) {
                log.debug("... searchedReviewCycleNodeIds [" + searchedReviewCycleNodeIds + "]");
            }
            currIndex = QueryHelper.setIdsToStatement(statement, currIndex, searchedReviewCycleNodeIds);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning currIndex [" + currIndex + "]");
        }
        return currIndex;
    }

    @Override
    public Document getByDocumentVersion(final Long documentVersionId) {
        String sql = "SELECT " + JdbcDocumentDAO.getSelectClauseForDto() + "FROM      document_version JOIN document         ON document_version.document_id = document.id WHERE document_version.id = ? ";
        return (Document)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Document>(){

            public Document perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentVersionId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    return JdbcDocumentDAO.this.fillDtoFromResultSet(rs);
                }
                return null;
            }
        });
    }

    @Override
    public List<DestinationJoin> getCandidateDestinationsViaDocumentRelease(Long documentId, Long subProjectId) {
        String lengthFunctionName = QueryHelper.getLengthFunctionName((JdbcDAOSupport)this);
        String sql = "SELECT " + this.getDestinationJoinSelectClause() + "\n     FROM document\nLEFT JOIN document_list                  ON document_list.id = document.document_list_id\nLEFT JOIN document_list_release          ON document_list_release.document_list_id = document_list.id\n                                        AND document_list_release.version = (document_list.version - 1)\nLEFT JOIN document_release               ON document_release.document_id = document.id\n                                        AND document_release.document_list_id = document_list_release.id\n     JOIN sub_project                    ON sub_project.id = document_list_release.sub_project_id\n     JOIN object_list                    ON object_list.sub_project_id = sub_project.id\n     JOIN object_list_release            ON object_list_release.object_list_id = object_list.id\n                                        AND object_list_release.version = (object_list.version - 1)\n     JOIN object_planner_release         ON ((object_planner_release.object_planner_id = document.object_planner_id AND (document_release.id IS NULL)) OR object_planner_release.object_planner_id = document_release.object_planner_id )\n     JOIN object_release                 ON object_release.id = object_planner_release.object_id\n                                        AND object_release.object_list_release_id = object_list_release.id\n     JOIN review_cycle_instance_released ON review_cycle_instance_released.id = object_planner_release.review_cycle_instance_id\n     JOIN review_cycle                   ON review_cycle.id = review_cycle_instance_released.review_cycle_id\n     JOIN review_cycle_cell              ON review_cycle_cell.review_cycle_id = review_cycle.id\n     JOIN review_cycle_entry_condition   ON review_cycle_entry_condition.id = review_cycle_cell.review_cycle_entry_condition_id\n                                        AND " + lengthFunctionName + "(review_cycle_entry_condition.ognl_rule) > 0\n                                        AND " + lengthFunctionName + "(review_cycle_entry_condition.partb_rule) > 0\n     JOIN review_cycle_cell_instance_released\n                                         ON review_cycle_cell_instance_released.review_cycle_cell_id = review_cycle_cell.id\n                                        AND review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id\nWHERE document.id = ?\nORDER BY review_cycle_cell.position\n";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, AbstractJdbcDocumentDAO::fillDestinationJoinFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public List<DestinationJoin> getCandidateDestinationsViaDocument(Long documentId, Long subProjectId) {
        String lengthFunctionName = QueryHelper.getLengthFunctionName((JdbcDAOSupport)this);
        String sql = "SELECT " + this.getDestinationJoinSelectClause() + "\n     FROM document\nLEFT JOIN object_planner                 ON document.object_planner_id = object_planner.id\n     JOIN review_cycle_instance          ON object_planner.review_cycle_instance_id = review_cycle_instance.id\n     JOIN review_cycle                   ON review_cycle.id = review_cycle_instance.review_cycle_id\n     JOIN review_cycle_cell              ON review_cycle_cell.review_cycle_id = review_cycle.id\n     JOIN review_cycle_entry_condition   ON review_cycle_entry_condition.id = review_cycle_cell.review_cycle_entry_condition_id\n                                        AND " + lengthFunctionName + "(review_cycle_entry_condition.ognl_rule) > 0\n                                        AND " + lengthFunctionName + "(review_cycle_entry_condition.partb_rule) > 0\n     JOIN review_cycle_cell_instance\n                                         ON review_cycle_cell_instance.review_cycle_cell_id = review_cycle_cell.id\n                                        AND review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id\nWHERE document.id = ?\nORDER BY review_cycle_cell.position\n";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, AbstractJdbcDocumentDAO::fillDestinationJoinFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public List<Document> getByProject(Long projectId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM project\nJOIN sub_project ON sub_project.project_id = project.id\nJOIN document_list ON document_list.sub_project_id = sub_project.id\nJOIN document ON document.document_list_id = document_list.id\nWHERE project.id = ?\n";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        });
    }

    @Override
    public List<Document> getBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentDAO.getSelectClauseForDto() + "FROM document_list JOIN document ON document.document_list_id = document_list.id WHERE document_list.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public ContextJoin getContextJoin(Long documentId) {
        String sql = "SELECT " + JdbcNetworkDAO.getContextJoinSelectClause() + "FROM document JOIN object_planner            ON document.object_planner_id = object_planner.id JOIN object                    ON object_planner.object_id = object.id JOIN object_list               ON object.object_list_id = object_list.id JOIN sub_project               ON object_list.sub_project_id = sub_project.id JOIN sub_project_type          ON sub_project.sub_project_type_id = sub_project_type.id JOIN project                   ON sub_project.project_id = project.id JOIN network                   ON project.network_id = network.id LEFT JOIN localisation              ON project.localisation_id = localisation.id LEFT JOIN countries project_country ON localisation.country_id = project_country.id WHERE document.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, AbstractJdbcNetworkDAO::fillContextJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
        });
    }
}

