/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.compositeDto.WorkflowActivityResultInfo;
import at.cdes.api.guiService.PlanningNotificationService;
import at.cdes.impl.export.planning.PlanningReviewProtocolExporter;
import java.util.List;
import java.util.Map;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.util.sched.cache.ScratchFile;
import org.clazzes.util.sched.impl.HasLoggingCallable;

public class PlanningReviewProtocolPdfCallable
extends HasLoggingCallable<ScratchFile> {
    private PlanningNotificationService planningNotificationService;
    private PlanningReviewProtocolExporter planningReviewProtocolExporter;
    private Long organisationPersonId;
    private Long workflowEntityId;
    private Map<String, Double> orderColumnToWidth;
    private Map<String, Double> historyColumnToWidth;
    private List<ColumnSortSpec> orderSortSpecs;
    private List<ColumnSortSpec> historySortSpecs;
    private boolean enableCustomerLogo;

    public PlanningReviewProtocolPdfCallable(PlanningReviewProtocolExporter planningReviewProtocolExporter, PlanningNotificationService planningNotificationService, Long organisationPersonId, Long workflowEntityId, Map<String, Double> orderColumnToWidth, Map<String, Double> historyColumnToWidth, List<ColumnSortSpec> orderSortSpecs, List<ColumnSortSpec> historySortSpecs, Boolean enableCustomerLogo) {
        this.planningNotificationService = planningNotificationService;
        this.planningReviewProtocolExporter = planningReviewProtocolExporter;
        this.organisationPersonId = organisationPersonId;
        this.workflowEntityId = workflowEntityId;
        this.orderColumnToWidth = orderColumnToWidth;
        this.historyColumnToWidth = historyColumnToWidth;
        this.orderSortSpecs = orderSortSpecs;
        this.historySortSpecs = historySortSpecs;
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public ScratchFile call() throws Exception {
        WorkflowActivityResultInfo resultInfo = this.planningNotificationService.getTaskResultInfo(this.organisationPersonId, this.workflowEntityId);
        ScratchFile scratchFile = this.planningReviewProtocolExporter.export(resultInfo, this.orderColumnToWidth, this.historyColumnToWidth, this.orderSortSpecs, this.historySortSpecs, this.enableCustomerLogo);
        return scratchFile;
    }
}

