/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.job.core;

import at.cdes.api.dto.Job;
import at.cdes.api.job.core.JobInfo;
import at.cdes.api.job.core.JobSearchModel;
import at.cdes.api.voc.job.JobState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class JobRegistry {
    private Map<String, UUID> cdesUuidToSchedUtilUuid = Collections.synchronizedMap(new HashMap());
    private Map<String, JobInfo> uuidToJobInfo = Collections.synchronizedMap(new HashMap());

    public void registerSchedUtilUuid(String cdesUuid, UUID schedUtilUuid) {
        this.cdesUuidToSchedUtilUuid.put(cdesUuid, schedUtilUuid);
    }

    public UUID getSchedUtilUUID(String cdesUuid) {
        return this.cdesUuidToSchedUtilUuid.get(cdesUuid);
    }

    public void registerJob(String uuid, JobInfo jobInfo) {
        this.uuidToJobInfo.put(uuid, jobInfo);
    }

    public void clearJob(String uuid) {
        this.uuidToJobInfo.remove(uuid);
    }

    public JobInfo getJob(String uuid) {
        return this.uuidToJobInfo.get(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> getJobs(JobSearchModel searchModel) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        Set<String> uuids = this.uuidToJobInfo.keySet();
        Map<String, JobInfo> map = this.uuidToJobInfo;
        synchronized (map) {
            for (String uuid : uuids) {
                Job job = this.uuidToJobInfo.get(uuid).getJob();
                if (!(searchModel.getOrganisationPersonId() == null || job.getOrganisationPersonId().longValue() == searchModel.getOrganisationPersonId().longValue() || searchModel.getNetworkId() != null && job.getNetworkId() != null && job.getNetworkId().longValue() != searchModel.getNetworkId().longValue() || searchModel.getIncludeScheduled() != null && job.getState().intValue() != JobState.SCHEDULED.getValue() || searchModel.getIncludeStarted() != null && job.getState().intValue() != JobState.STARTED.getValue() || searchModel.getIncludeInterrupted() != null && job.getState().intValue() != JobState.INTERRUPTED.getValue() || searchModel.getIncludeFinished() != null && job.getState().intValue() != JobState.FINISHED.getValue()) && (searchModel.getIncludeFailed() == null || job.getState().intValue() == JobState.FAILED.getValue())) continue;
                jobs.add(job);
            }
        }
        return jobs;
    }
}

