/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.PlottOrder;
import at.cdes.api.dto.ReceivedPlottOrderStep;
import at.cdes.impl.dao.ReceivedPlottOrderStepDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcReceivedPlottOrderStepDAO
extends AbstrIdDAO<ReceivedPlottOrderStep>
implements ReceivedPlottOrderStepDAO {
    public JdbcReceivedPlottOrderStepDAO() {
        super(ReceivedPlottOrderStep.class, "orderId", "received_plott_order_step", new String[]{"order_id", "order_step_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcReceivedPlottOrderStepDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_step_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcReceivedPlottOrderStepDAO.getSelectClauseForDto("received_plott_order_step", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcReceivedPlottOrderStepDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".order_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_id") + "," + entityLocalName + ".order_step_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_step_id") + " ";
    }

    protected ReceivedPlottOrderStep fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ReceivedPlottOrderStep receivedPlottOrderStep = new ReceivedPlottOrderStep();
        receivedPlottOrderStep.setOrderId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        receivedPlottOrderStep.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return receivedPlottOrderStep;
    }

    public static ReceivedPlottOrderStep fillReceivedPlottOrderStepFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ReceivedPlottOrderStep receivedPlottOrderStep = new ReceivedPlottOrderStep();
        receivedPlottOrderStep.setOrderId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        receivedPlottOrderStep.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return receivedPlottOrderStep;
    }

    public static ReceivedPlottOrderStep fillReceivedPlottOrderStepFromResultSet(ResultSet rs) throws SQLException {
        return JdbcReceivedPlottOrderStepDAO.fillReceivedPlottOrderStepFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteByOrderStep(final Long orderStepId) {
        String sql = "DELETE FROM received_plott_order_step WHERE order_step_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, orderStepId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(ReceivedPlottOrderStep dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ReceivedPlottOrderStep> dtos) {
        Iterator<ReceivedPlottOrderStep> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ReceivedPlottOrderStep receivedPlottOrderStep) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)receivedPlottOrderStep.getOrderId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)receivedPlottOrderStep.getOrderStepId());
    }

    @Override
    public List<ReceivedPlottOrderStep> getByOrder(PlottOrder plottOrder) {
        return this.getByOrder(plottOrder.getId());
    }

    @Override
    public List<ReceivedPlottOrderStep> getByOrder(final Long plottOrderId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, plottOrderId);
            }
        });
    }

    @Override
    public List<ReceivedPlottOrderStep> getByOrderStep(OrderStep orderStep) {
        return this.getByOrderStep(orderStep.getId());
    }

    @Override
    public List<ReceivedPlottOrderStep> getByOrderStep(final Long orderStepId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_step_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, orderStepId);
            }
        });
    }

    @Override
    public List<ReceivedPlottOrderStep> getByOrders(Collection<Long> plottOrderId) {
        if (plottOrderId.isEmpty()) {
            return new ArrayList<ReceivedPlottOrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[plottOrderId.size()];
        int n = 0;
        Iterator<Long> it = plottOrderId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ReceivedPlottOrderStep> getByOrderSteps(Collection<Long> orderStepId) {
        if (orderStepId.isEmpty()) {
            return new ArrayList<ReceivedPlottOrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[orderStepId.size()];
        int n = 0;
        Iterator<Long> it = orderStepId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_step_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

