/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.MetaTag;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.PlanningNotificationAttachment;
import at.cdes.api.dto.PlanningNotificationDateMetaInformation;
import at.cdes.api.dto.PlanningNotificationOrderTag;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.WorkflowNodeTemplate;
import at.cdes.api.dto.searchModel.PlanningNotificationOrderSearchModel;
import at.cdes.api.dto.searchModel.PlanningNotificationSearchModel;
import at.cdes.api.dto.searchModel.PlanningReviewProtocolSearchModel;
import at.cdes.api.guiService.PlanningNotificationService;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.job.core.JobHandle;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.PlanningNotificationReportJoin;
import at.cdes.api.joinDto.WorkflowActivityPositionResultJoin;
import at.cdes.api.joinDto.WorkflowNodeJoin;
import at.cdes.api.planning.compositeDto.FlatReportInfo;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportColumnSettings;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportExportInfo;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportInfo;
import at.cdes.api.planning.voc.PlanningNotificationReportFileType;
import at.cdes.api.planning.voc.PlanningNotificationReportLayout;
import at.cdes.api.planning.voc.PlanningNotificationReportType;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.job.JobType;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.MetaTagDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.WorkflowNodeTemplateDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.planning.CellTextStyles;
import at.cdes.impl.export.planning.PlanningExportHelper;
import at.cdes.impl.export.planning.PlanningReportHelper;
import at.cdes.impl.export.planning.PlanningReportLocalStyles;
import at.cdes.impl.export.planning.StateChartData;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.job.core.JobRegistry;
import at.cdes.impl.job.util.JobHelper;
import at.cdes.impl.planning.PlanningReportResult;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.apache.pdfbox.util.PDFMergerUtility;
import org.clazzes.odf.util.chart.OdfChart;
import org.clazzes.odf.util.chart.OdfChartColumn;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.draw.FrameFactory;
import org.clazzes.odf.util.draw.ObjectFactory;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.factory.ReferenceFactory;
import org.clazzes.odf.util.file.OdfConversionHandle;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawObjectElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawImage;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PlanningReportPdfExporter {
    private ActionDAO actionDAO;
    private Bundle bundle;
    private JobRegistry jobRegistry;
    private String odfStylePrefix;
    private MetaTagDAO metaTagDAO;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private OrganisationPersonDAO organisationPersonDAO;
    private String planningNotificationAttachmentRepository;
    private PlanningNotificationService planningNotificationService;
    private ProjectDAO projectDAO;
    private String tempDirName;
    private WorkflowNodeTemplateDAO workflowNodeTemplateDAO;
    private PersonVariablesDAO personVariablesDAO;
    private UtilService utilService;
    private static final Logger log = LoggerFactory.getLogger(PlanningReportPdfExporter.class);
    private static final String PLANNING_NOTIFICATION_ORDER_ANCHOR_PREFIX = "Order_";
    private static Map<String, Double> ORDER_DETAIL_MIN_ABS_COLUMN_WIDTH = new HashMap<String, Double>();
    private static Map<String, Double> PDF_LIST_MIN_ABS_COLUMN_WIDTH = new HashMap<String, Double>();

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setMetaTagDAO(MetaTagDAO metaTagDAO) {
        this.metaTagDAO = metaTagDAO;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPlanningNotificationAttachmentRepository(String planningNotificationAttachmentRepository) {
        this.planningNotificationAttachmentRepository = planningNotificationAttachmentRepository;
    }

    public void setPlanningNotificationService(PlanningNotificationService planningNotificationService) {
        this.planningNotificationService = planningNotificationService;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setWorkflowNodeTemplateDAO(WorkflowNodeTemplateDAO workflowNodeTemplateDAO) {
        this.workflowNodeTemplateDAO = workflowNodeTemplateDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanningReportResult export(String cdesUuid, PlanningNotificationReportExportInfo exportInfo, boolean enableCustomerLogo) throws Exception {
        try {
            String pdfFileName;
            ExportResult exportResult;
            String tmpFileName;
            String finalFileName;
            String templatePath;
            CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
            Long personId = loginPrincipal.getPersonId();
            List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(personId);
            PersonVariables personVariables = personVariablesList.get(0);
            ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariables.getUserLocale());
            final OdfConversionHandle conversionHandle = new OdfConversionHandle();
            JobHandle jobHandle = new JobHandle(){

                public void destroy() {
                    conversionHandle.destroy();
                }
            };
            JobHelper.registerCallableJob(this.jobRegistry, JobType.EXPORT_PDF_REPORT, exportInfo.getOrganisationPersonId(), exportInfo.getNetworkId(), null, cdesUuid, jobHandle);
            PlanningNotificationReportLayout layout = exportInfo.getLayout();
            if (layout == PlanningNotificationReportLayout.PORTRAIT) {
                templatePath = "export/emptyPortraitTemplate.odt";
            } else if (layout == PlanningNotificationReportLayout.LANDSCAPE) {
                templatePath = "export/emptyLandscapeTemplate.odt";
            } else {
                throw new IllegalArgumentException("Unsupported layout: [" + layout + "]");
            }
            OdfTextDocument document = DocumentFactory.constructTextDocument((String)templatePath, PlanningReportPdfExporter.class, (Locale)ThreadLocalManager.getLoginLocale());
            OfficeTextElement officeText = document.getContentRoot();
            OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
            PlanningReportLocalStyles localStyles = this.constructLocalStyles(context, exportInfo);
            String reportName = exportInfo.getReportName();
            PlanningNotificationSearchModel notificationSearchModel = PlanningReportHelper.getPlanningNotificationSearchModel(exportInfo);
            PlanningNotificationOrderSearchModel orderSearchModel = PlanningReportHelper.getPlanningNotificationOrderSearchModel(exportInfo);
            PlanningReviewProtocolSearchModel reviewProtocolSearchModel = PlanningReportHelper.getPlanningReviewProtocolSearchModel(exportInfo);
            List metaTags = this.metaTagDAO.getAll();
            MetaTag baulosMetaTag = this.getBaulosMetaTag(metaTags);
            List<PlanningNotificationReportInfo> reportInfos = this.planningNotificationService.getPlanningNotificationReportJoins(notificationSearchModel, orderSearchModel, reviewProtocolSearchModel, baulosMetaTag.getId());
            HashSet<Long> planningNotificationIdSet = new HashSet<Long>();
            HashSet<Long> workflowEntityIdSet = new HashSet<Long>();
            for (PlanningNotificationReportInfo reportInfo : reportInfos) {
                planningNotificationIdSet.add(reportInfo.getReportJoin().getPlanningNotificationId());
                workflowEntityIdSet.add(reportInfo.getReportJoin().getPlanningNotificationOrderWorkflowEntityId());
            }
            ArrayList<Long> planningNotificationIds = new ArrayList<Long>();
            ArrayList<Long> workflowEntityIds = new ArrayList<Long>();
            planningNotificationIds.addAll(planningNotificationIdSet);
            workflowEntityIds.addAll(workflowEntityIdSet);
            Long organisationPersonId = exportInfo.getOrganisationPersonId();
            reportInfos = PlanningReportHelper.filterReportInfosForPrivileges(reportInfos, organisationPersonId, this.actionDAO);
            OrganisationPersonJoin organisationPersonJoin = this.getOrganisationPersonJoin(exportInfo);
            String organisationName = organisationPersonJoin.getOrganisationName();
            List<Project> affectedProjects = this.getAffectedProjects(exportInfo, reportInfos);
            PlanningReportHelper.constructPlanningNotificationHeader(context, document, localStyles.getStandardParagraphStyle(), affectedProjects, enableCustomerLogo);
            PlanningReportHelper.constructPlanningNotificationFooter(context, document, localStyles.getStandardParagraphStyle(), this.bundle, reportName, organisationName);
            HashMap<Long, AttachmentPageInfo> attachmentIdToPageInfo = new HashMap<Long, AttachmentPageInfo>();
            ArrayList<AttachmentPageInfo> attachmentPageInfos = new ArrayList<AttachmentPageInfo>();
            this.setupAttachmentPageInfos(reportInfos, attachmentPageInfos, attachmentIdToPageInfo);
            this.doExport(officeText, context, localStyles, exportInfo, reportInfos, attachmentPageInfos, attachmentIdToPageInfo, organisationPersonJoin, resourceBundle);
            log.info("Setting up odf document finished, about to generate it.");
            if (Thread.currentThread().isInterrupted()) {
                // empty if block
            }
            finalFileName = (finalFileName = (tmpFileName = (exportResult = OdfHelper.constructExportResult(pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Auflagen_Report_Tmp_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.REPORT.getValue(), (OdfConversionHandle)conversionHandle))).getTmpFileName()).replace("Tmp_", "")).indexOf(46) != -1 ? finalFileName.substring(0, finalFileName.lastIndexOf(46)) : finalFileName;
            finalFileName = finalFileName + ".pdf";
            try (PDDocument pdDocument = PDDocument.load((String)tmpFileName);){
                if (attachmentPageInfos.size() > 0 && (exportInfo.getColumnSettings().getShowAttachment().booleanValue() || exportInfo.getType() == PlanningNotificationReportType.ALL)) {
                    this.appendPlanningNotificationOrderAttachments(pdDocument, exportInfo, reportInfos, attachmentPageInfos, attachmentIdToPageInfo, resourceBundle);
                }
                pdDocument.save(finalFileName);
            }
            File finalFile = new File(finalFileName);
            ScratchFile scratchFile = new ScratchFile(finalFile, "application/pdf", "attachment; filename*=UTF-8''" + (exportInfo.getFileName() != null && exportInfo.getFileName().trim().length() > 0 ? exportInfo.getFileName() + ".pdf" : finalFile.getName()));
            PlanningReportResult result = new PlanningReportResult();
            result.setScratchFile(scratchFile);
            result.setPlanningNotificationIds(planningNotificationIds);
            result.setWorkflowEntityIds(workflowEntityIds);
            PlanningReportResult planningReportResult = result;
            return planningReportResult;
        }
        finally {
            this.jobRegistry.clearJob(cdesUuid);
        }
    }

    private MetaTag getBaulosMetaTag(List<MetaTag> metaTags) {
        for (MetaTag metaTag : metaTags) {
            if (!"Baulos".equals(metaTag.getName())) continue;
            return metaTag;
        }
        return null;
    }

    public String constructStandardParagraphStyle(Styles context) {
        return context.getParagraphStyle("StandardParagraphStyle", "text", new OdfStylePropertiesBase[]{PlanningReportPdfExporter.constructStandardParagraphProperties(context), PlanningReportPdfExporter.constructStandardTextProperties(context)});
    }

    public static StyleParagraphPropertiesElement constructStandardParagraphProperties(Styles context) {
        StyleParagraphPropertiesElement paragraphProperties = context.constructParagraphProperties();
        paragraphProperties.setStyleLineHeightAtLeastAttribute("0.423cm");
        paragraphProperties.setFoTextAlignAttribute("start");
        paragraphProperties.setStyleJustifySingleWordAttribute(Boolean.valueOf(false));
        paragraphProperties.setFoOrphansAttribute(Integer.valueOf(2));
        paragraphProperties.setFoWidowsAttribute(Integer.valueOf(2));
        paragraphProperties.setStyleWritingModeAttribute("lr-tb");
        return paragraphProperties;
    }

    public static StyleTextPropertiesElement constructStandardTextProperties(Styles context) {
        StyleTextPropertiesElement textProperties = context.constructTextProperties();
        textProperties.setFoColorAttribute("#00000a");
        textProperties.setStyleUseWindowFontColorAttribute(Boolean.valueOf(true));
        textProperties.setStyleFontNameAttribute("Arial");
        textProperties.setFoFontFamilyAttribute("Arial");
        textProperties.setStyleFontFamilyGenericAttribute("roman");
        textProperties.setStyleFontPitchAttribute("variable");
        textProperties.setFoFontSizeAttribute("10pt");
        textProperties.setFoLanguageAttribute("de");
        textProperties.setFoCountryAttribute("DE");
        textProperties.setFoHyphenateAttribute(Boolean.valueOf(false));
        textProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        textProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        return textProperties;
    }

    private PlanningReportLocalStyles constructLocalStyles(OdfContext context, PlanningNotificationReportExportInfo exportInfo) {
        Styles officeStyles = context.getStylesOfficeStyles();
        PlanningReportLocalStyles localStyles = new PlanningReportLocalStyles();
        String standardParagraphStyle = this.constructStandardParagraphStyle(officeStyles);
        localStyles.setStandardParagraphStyle(standardParagraphStyle);
        StyleParagraphPropertiesElement headerTopParagraphProperties = officeStyles.constructParagraphProperties();
        headerTopParagraphProperties.setFoKeepWithNextAttribute("always");
        localStyles.setHeadingTopStyle(officeStyles.getParagraphStyle(new OdfStylePropertiesBase[]{headerTopParagraphProperties, officeStyles.constructTextPropertiesWithFont("Liberation Sans", "Liberation Sans", "14pt", null, "variable")}));
        localStyles.setHeadingTwoStyle(officeStyles.getParagraphStyleWithParent(localStyles.getHeadingTopStyle(), new OdfStylePropertiesBase[]{officeStyles.constructParagraphPropertiesWithMargin(null, null, "0.353cm", "0.212cm"), officeStyles.constructTextPropertiesWithFont(null, null, "115%", "bold", null)}));
        String style14pt = officeStyles.getTextStyle(new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithFont("Arial", "Arial", "14pt", null, null)});
        localStyles.setStyle14pt(style14pt);
        String style12pt = officeStyles.getTextStyle(new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithFont("Arial", "Arial", "12pt", null, null)});
        localStyles.setStyle12pt(style12pt);
        Styles automaticStyles = context.getContentAutomaticStyles();
        String tableUnderCaptionStyle = automaticStyles.getTableStyle(new OdfStylePropertiesBase[]{automaticStyles.constructTablePropertiesWithMargin(null, null, "0.5cm", null)});
        localStyles.setTableUnderCaptionStyle(tableUnderCaptionStyle);
        String headerCellStyle = automaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{automaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000")});
        localStyles.setHeaderCellStyle(headerCellStyle);
        Integer headerFontSize = exportInfo.getHeaderFontSize();
        String headerFontSizeString = headerFontSize != null ? headerFontSize + "pt" : "8pt";
        StyleTextPropertiesElement headerTextProperties = automaticStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", headerFontSizeString, "bold");
        headerTextProperties.setFoHyphenateAttribute(Boolean.valueOf(true));
        headerTextProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        headerTextProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        String headerTextStyle = automaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        localStyles.setHeaderTextStyle(headerTextStyle);
        String dataCellStyle = automaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{automaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000")});
        localStyles.setDataCellStyle(dataCellStyle);
        Integer dataFontSize = exportInfo.getDataFontSize();
        String dataFontSizeString = dataFontSize != null ? dataFontSize + "pt" : "9pt";
        StyleTextPropertiesElement dataTextProperties = automaticStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", dataFontSizeString, null);
        dataTextProperties.setFoHyphenateAttribute(Boolean.valueOf(true));
        dataTextProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        dataTextProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        String dataTextStyle = automaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        StyleTextPropertiesElement invalidatedProperties = automaticStyles.constructStrikeThroughTextPropertiesWithColorAndFont("#BBBBBB", "Arial", dataFontSizeString, null);
        String invalidatedDataTextStyle = automaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{invalidatedProperties});
        String dataRowStyle = automaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{automaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "auto")});
        localStyles.setDataRowStyle(dataRowStyle);
        String dataCaptionTextStyle = officeStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", "9pt", "bold")});
        String invalidatedDataCaptionTextStyle = officeStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{officeStyles.constructStrikeThroughTextPropertiesWithColorAndFont("#BBBBBB", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = officeStyles.getTextStyle(new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", "9pt", "bold")});
        String invalidatedDataBoldTextStyle = officeStyles.getTextStyle(new OdfStylePropertiesBase[]{officeStyles.constructStrikeThroughTextPropertiesWithColorAndFont("#BBBBBB", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = officeStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", "9pt", "italic")});
        String invalidatedDataItalicTextStyle = officeStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#BBBBBB", "Arial", "9pt", "italic")});
        String dataRedTextStyle = officeStyles.getTextStyle(new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#FF0000", "Arial", "9pt", null)});
        String invalidatedDataRedTextStyle = officeStyles.getTextStyle(new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#BBBBBB", "Arial", "9pt", null)});
        localStyles.setNormalCellTextStyles(new CellTextStyles(dataTextStyle, dataBoldTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle));
        localStyles.setInvalidatedCellTextStyles(new CellTextStyles(invalidatedDataTextStyle, invalidatedDataBoldTextStyle, invalidatedDataItalicTextStyle, invalidatedDataCaptionTextStyle, invalidatedDataRedTextStyle));
        StyleTextPropertiesElement internetLinkProperties = automaticStyles.constructTextProperties();
        internetLinkProperties.setFoColorAttribute("#000080");
        internetLinkProperties.setFoLanguageAttribute("zxx");
        internetLinkProperties.setFoCountryAttribute("none");
        internetLinkProperties.setStyleTextUnderlineStyleAttribute("solid");
        internetLinkProperties.setStyleTextUnderlineWidthAttribute("auto");
        internetLinkProperties.setStyleTextUnderlineColorAttribute("font-color");
        String internetLinkStyle = automaticStyles.getTextStyle(new OdfStylePropertiesBase[]{internetLinkProperties});
        localStyles.setInternetLinkStyle(internetLinkStyle);
        return localStyles;
    }

    private String constructPageBreakStyle(OdfContext context, String parentParagraphStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphPropertiesElement = stylesOfficeStyles.constructParagraphPropertiesWithBreakBefore("page");
        paragraphPropertiesElement.setFoMarginTopAttribute("0cm");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentParagraphStyle, new OdfStylePropertiesBase[]{paragraphPropertiesElement});
    }

    private OrganisationPersonJoin getOrganisationPersonJoin(PlanningNotificationReportExportInfo exportInfo) {
        Long organisationPersonId = exportInfo.getOrganisationPersonId();
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoin(organisationPersonId);
        if (organisationPersonJoins.size() != 1) {
            throw new IllegalArgumentException("Found [" + organisationPersonJoins.size() + "] instances of OrganisationPersonJoin, expected exactly one for organisationPersonId [" + organisationPersonId + "]");
        }
        OrganisationPersonJoin organisationPersonJoin = organisationPersonJoins.get(0);
        CdesPrincipal principal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = principal.getPersonId();
        if (organisationPersonJoin.getPersonId().longValue() != personId.longValue()) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] transmitted by the client does not match the personId [" + personId + "] of the person logged in.");
        }
        return organisationPersonJoin;
    }

    private void checkForInterrupted() {
        if (Thread.interrupted()) {
            throw new RuntimeException("Generation was interrupted.");
        }
    }

    private void doExport(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, List<PlanningNotificationReportInfo> reportInfos, List<AttachmentPageInfo> attachmentPageInfos, Map<Long, AttachmentPageInfo> attachmentIdToPageInfo, OrganisationPersonJoin organisationPersonJoin, ResourceBundle resourceBundle) {
        PlanningNotificationReportColumnSettings columnSettings = exportInfo.getColumnSettings();
        Boolean includeOverallStatusGraphic = exportInfo.getIncludeOverallStatusGraphic();
        PlanningNotificationReportType type = exportInfo.getType();
        PlanningNotificationReportFileType fileType = exportInfo.getFileType();
        String coverComment = exportInfo.getCoverComment();
        String coverCommentTwo = exportInfo.getCoverCommentTwo();
        List metaTags = this.metaTagDAO.getAll();
        HashMap<Long, MetaTag> idToMetaTag = new HashMap<Long, MetaTag>();
        for (MetaTag metaTag : metaTags) {
            idToMetaTag.put(metaTag.getId(), metaTag);
        }
        List workflowNodeTemplates = this.workflowNodeTemplateDAO.getAll();
        HashMap<Long, WorkflowNodeTemplate> idToWorkflowNodeTemplate = new HashMap<Long, WorkflowNodeTemplate>();
        for (WorkflowNodeTemplate workflowNodeTemplate : workflowNodeTemplates) {
            idToWorkflowNodeTemplate.put(workflowNodeTemplate.getId(), workflowNodeTemplate);
        }
        this.appendCaptionCommentFrame(officeText, context, localStyles, exportInfo, coverComment, coverCommentTwo, resourceBundle);
        this.appendReportCreationDate(officeText, context, localStyles, resourceBundle);
        this.appendCreator(officeText, context, localStyles, organisationPersonJoin, resourceBundle);
        this.appendSignature(officeText, context, localStyles, organisationPersonJoin, resourceBundle);
        this.checkForInterrupted();
        if (includeOverallStatusGraphic != null && includeOverallStatusGraphic.booleanValue()) {
            this.appendStateCaption(officeText, context, localStyles, resourceBundle);
            this.appendStateChart(officeText, context, reportInfos, resourceBundle);
            this.checkForInterrupted();
        }
        if (fileType == PlanningNotificationReportFileType.PDF) {
            Long documentDateMetaTagId = this.getDocumentDateMetaTagId(metaTags);
            this.sortPdfReportInfos(reportInfos, exportInfo, documentDateMetaTagId);
            this.appendContentCaption(officeText, context, localStyles, resourceBundle);
            if (type == PlanningNotificationReportType.ALL) {
                this.appendAllContentTable(officeText, context, localStyles, exportInfo, reportInfos, metaTags, resourceBundle);
            } else if (type == PlanningNotificationReportType.INDIVIDUAL) {
                this.appendIndividualContentTable(officeText, context, localStyles, exportInfo, reportInfos, metaTags, resourceBundle);
            } else {
                throw new IllegalArgumentException("Unsupported report type: " + type);
            }
            this.checkForInterrupted();
        }
        boolean showReviewResults = false;
        boolean bl = showReviewResults = exportInfo.getColumnSettings().getShowWorkflowNodeName() != false || exportInfo.getColumnSettings().getShowReviewBaulos() != false || exportInfo.getColumnSettings().getShowTokenInitiator() != false || exportInfo.getColumnSettings().getShowReviewer() != false || exportInfo.getColumnSettings().getShowResult() != false || exportInfo.getColumnSettings().getShowIssued() != false || exportInfo.getColumnSettings().getShowAttachment() != false;
        if (fileType == PlanningNotificationReportFileType.PDF) {
            for (PlanningNotificationReportInfo reportInfo : reportInfos) {
                this.appendPlanningNotificationOrderCaption(officeText, context, localStyles, reportInfo, resourceBundle);
                this.appendPlanningNotificationOrderNotificationTable(officeText, context, localStyles, exportInfo, reportInfo, metaTags, columnSettings, resourceBundle);
                this.appendPlanningNotificationOrderDetailTable(officeText, context, localStyles, exportInfo, reportInfo, columnSettings, resourceBundle);
                this.appendPlanningNotificationOrderReviewOverviewTable(officeText, context, localStyles, exportInfo, reportInfo, columnSettings, resourceBundle);
                if (showReviewResults || type == PlanningNotificationReportType.ALL) {
                    this.appendPlanningNotificationOrderReviewHistoryTable(officeText, context, localStyles, exportInfo, reportInfo, columnSettings, idToWorkflowNodeTemplate, resourceBundle);
                }
                this.checkForInterrupted();
            }
            if (attachmentPageInfos.size() > 0 && (columnSettings.getShowAttachment().booleanValue() || type == PlanningNotificationReportType.ALL)) {
                this.appendPlanningNotificationOrderAttachmentCaption(officeText, context, localStyles, resourceBundle);
                for (PlanningNotificationReportInfo reportInfo : reportInfos) {
                    this.appendPlanningNotificationOrderAttachmentTable(officeText, context, localStyles, exportInfo, reportInfo, attachmentPageInfos, attachmentIdToPageInfo, resourceBundle);
                    this.checkForInterrupted();
                }
            }
        } else if (fileType == PlanningNotificationReportFileType.PDF_LIST) {
            this.appendCompleteOrderTableToPdf(officeText, context, localStyles, metaTags, idToMetaTag, reportInfos, exportInfo, resourceBundle);
        } else {
            throw new IllegalArgumentException("Unsupported file type: " + fileType);
        }
    }

    private static <T> T getLayoutDependentValue(PlanningNotificationReportExportInfo exportInfo, T landscapeValue, T portraitValue) {
        PlanningNotificationReportLayout layoutFormat = exportInfo.getLayout();
        if (layoutFormat == PlanningNotificationReportLayout.LANDSCAPE) {
            return landscapeValue;
        }
        if (layoutFormat == PlanningNotificationReportLayout.PORTRAIT) {
            return portraitValue;
        }
        throw new IllegalArgumentException("Unsupported layout format: [" + layoutFormat + "]");
    }

    private int compareSerialNumbers(Long serialNumberOne, Long serialNumberTwo) {
        if (serialNumberOne == null) {
            serialNumberOne = -1L;
        }
        if (serialNumberTwo == null) {
            serialNumberTwo = -1L;
        }
        if (serialNumberOne < serialNumberTwo) {
            return -1;
        }
        if (serialNumberOne > serialNumberTwo) {
            return 1;
        }
        return 0;
    }

    private Long getMetaTagIdByCssClass(List<MetaTag> metaTags, String cssClass) {
        for (MetaTag metaTag : metaTags) {
            if (!cssClass.equals(metaTag.getCssClass())) continue;
            return metaTag.getId();
        }
        return null;
    }

    private Long getDocumentDateMetaTagId(List<MetaTag> metaTags) {
        return this.getMetaTagIdByCssClass(metaTags, "Dokumentendatum");
    }

    private Long getGzMetaTagId(List<MetaTag> metaTags) {
        return this.getMetaTagIdByCssClass(metaTags, "GZ");
    }

    private void sortPdfReportInfos(List<PlanningNotificationReportInfo> reportInfos, PlanningNotificationReportExportInfo exportInfo, final Long documentDateMetaTagId) {
        final PlanningNotificationReportType type = exportInfo.getType();
        reportInfos.sort(new Comparator<PlanningNotificationReportInfo>(){

            @Override
            public int compare(PlanningNotificationReportInfo reportInfoOne, PlanningNotificationReportInfo reportInfoTwo) {
                PlanningNotificationReportJoin joinOne = reportInfoOne.getReportJoin();
                PlanningNotificationReportJoin joinTwo = reportInfoTwo.getReportJoin();
                Long serialNumberOne = joinOne.getPlanningNotificationOrderSerialNumber();
                Long serialNumberTwo = joinTwo.getPlanningNotificationOrderSerialNumber();
                if (type == PlanningNotificationReportType.ALL) {
                    Long planningNotificationIdOne = joinOne.getPlanningNotificationId() != null ? joinOne.getPlanningNotificationId() : -1L;
                    Long planningNotificationIdTwo = joinTwo.getPlanningNotificationId() != null ? joinTwo.getPlanningNotificationId() : -1L;
                    if (planningNotificationIdOne.longValue() == planningNotificationIdTwo.longValue()) {
                        return PlanningReportPdfExporter.this.compareSerialNumbers(serialNumberOne, serialNumberTwo);
                    }
                    Map metaTagIdToDateMetaInformationsOne = reportInfoOne.getMetaTagIdToDateMetaInformations();
                    Map metaTagIdToDateMetaInformationsTwo = reportInfoTwo.getMetaTagIdToDateMetaInformations();
                    List dateListOne = metaTagIdToDateMetaInformationsOne != null ? (List)metaTagIdToDateMetaInformationsOne.get(documentDateMetaTagId) : null;
                    List dateListTwo = metaTagIdToDateMetaInformationsTwo != null ? (List)metaTagIdToDateMetaInformationsTwo.get(documentDateMetaTagId) : null;
                    PlanningNotificationDateMetaInformation metaInformationOne = dateListOne != null && dateListOne.size() > 0 ? (PlanningNotificationDateMetaInformation)dateListOne.get(0) : null;
                    PlanningNotificationDateMetaInformation metaInformationTwo = dateListTwo != null && dateListTwo.size() > 0 ? (PlanningNotificationDateMetaInformation)dateListTwo.get(0) : null;
                    Double timeOne = metaInformationOne != null && metaInformationOne.getValue() != null ? metaInformationOne.getValue() : Double.MAX_VALUE;
                    Double timeTwo = metaInformationTwo != null && metaInformationTwo.getValue() != null ? metaInformationTwo.getValue() : Double.MAX_VALUE;
                    if (Math.abs(timeOne - timeTwo) > 1.0E-10) {
                        return timeOne < timeTwo ? -1 : 1;
                    }
                    return PlanningReportPdfExporter.this.compareSerialNumbers(serialNumberOne, serialNumberTwo);
                }
                return PlanningReportPdfExporter.this.compareSerialNumbers(serialNumberOne, serialNumberTwo);
            }
        });
    }

    private List<Project> getAffectedProjects(PlanningNotificationReportExportInfo exportInfo, List<PlanningNotificationReportInfo> reportInfos) {
        ArrayList<Project> projects = new ArrayList<Project>();
        if (exportInfo.getType() == PlanningNotificationReportType.ALL) {
            Project project = (Project)this.projectDAO.get(exportInfo.getProjectId());
            projects.add(project);
        } else {
            HashMap<Long, Project> idToProject = new HashMap<Long, Project>();
            for (PlanningNotificationReportInfo reportInfo : reportInfos) {
                List currProjects = reportInfo.getProjects();
                for (Project currProject : currProjects) {
                    idToProject.put(currProject.getId(), currProject);
                }
            }
            projects.addAll(idToProject.values());
        }
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(projects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                String prjOne = o1.getName();
                String prjTwo = o2.getName();
                return collator.compare(prjOne, prjTwo);
            }
        });
        return projects;
    }

    private void appendCaptionCommentFrame(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, String coverComment, String coverCommentTwo, ResourceBundle resourceBundle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String coverBoxParentTextStyle = stylesOfficeStyles.getParagraphStyleWithParent(localStyles.getStandardParagraphStyle(), new OdfStylePropertiesBase[]{stylesOfficeStyles.constructParagraphPropertiesWithTextAlignAndMargin("center", Boolean.valueOf(false), null, null, null, null), stylesOfficeStyles.constructTextPropertiesWithFontSize("14pt")});
        StyleGraphicPropertiesElement outerDrawFrameProperties = stylesOfficeStyles.constructGraphicProperties();
        outerDrawFrameProperties.setStyleRunThroughAttribute("foreground");
        outerDrawFrameProperties.setStyleWrapAttribute("none");
        outerDrawFrameProperties.setDrawFillAttribute("none");
        outerDrawFrameProperties.setFoBorderAttribute("none");
        String outerDrawFrameStyle = stylesOfficeStyles.getGraphicStyle(new OdfStylePropertiesBase[]{outerDrawFrameProperties});
        String outerContentDrawFrameStyle = contentAutomaticStyles.getGraphicStyleWithParent(outerDrawFrameStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructGraphicPropertiesWithAlignment("from-top", "paragraph-content", "left", "paragraph", "middle")});
        TextPElement outerPElement = TextFactory.constructTextNode((Node)officeText, null, (String)coverBoxParentTextStyle);
        String outerDrawFrameWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, "26.53cm", "17.83cm");
        DrawFrameElement outerDrawFrameElement = FrameFactory.constructDrawFrameNode((Node)outerPElement, (String)outerContentDrawFrameStyle, (String)"paragraph", null, null, (String)outerDrawFrameWidth, null, (Integer)2);
        DrawTextBoxElement outerTextBoxElement = TextFactory.constructTextBox((Node)outerDrawFrameElement, (String)"10cm");
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphPropertiesWithMargin(null, null, null, null);
        paragraphProperties.setFoTextAlignAttribute("center");
        String captionStyle = stylesOfficeStyles.getParagraphStyleWithParent(localStyles.getStandardParagraphStyle(), new OdfStylePropertiesBase[]{stylesOfficeStyles.constructTextPropertiesWithFontSize("14pt"), paragraphProperties});
        PlanningNotificationReportType type = exportInfo.getType();
        String caption = type == PlanningNotificationReportType.ALL ? resourceBundle.getString("planningNotificationReportCompleteReportCaption") : resourceBundle.getString("planningNotificationReportCdesBuek");
        TextFactory.constructTextNode((Node)outerTextBoxElement, (String)caption, (String)captionStyle);
        if (coverComment != null && coverComment.length() > 0 || coverCommentTwo != null && coverCommentTwo.length() > 0) {
            String[] commentLines;
            StyleParagraphPropertiesElement paragraphCommentProperties = stylesOfficeStyles.constructParagraphPropertiesWithMargin(null, null, null, null);
            paragraphCommentProperties.setFoTextAlignAttribute("center");
            String captionCommentStyle = stylesOfficeStyles.getParagraphStyleWithParent(localStyles.getStandardParagraphStyle(), new OdfStylePropertiesBase[]{stylesOfficeStyles.constructTextPropertiesWithFontSize("14pt"), paragraphCommentProperties});
            String captionComment2Style = stylesOfficeStyles.getParagraphStyleWithParent(localStyles.getStandardParagraphStyle(), new OdfStylePropertiesBase[]{stylesOfficeStyles.constructTextPropertiesWithFontSize("10pt"), paragraphCommentProperties});
            if (coverComment != null) {
                TextFactory.constructTextNode((Node)outerTextBoxElement, (String)"", (String)captionComment2Style);
                for (String commentLine : commentLines = coverComment.split("\\n")) {
                    TextFactory.constructTextNode((Node)outerTextBoxElement, (String)commentLine, (String)captionCommentStyle);
                }
            }
            if (coverCommentTwo != null) {
                TextFactory.constructTextNode((Node)outerTextBoxElement, (String)"", (String)captionComment2Style);
                for (String commentLine : commentLines = coverCommentTwo.split("\\n")) {
                    TextFactory.constructTextNode((Node)outerTextBoxElement, (String)commentLine, (String)captionComment2Style);
                }
            }
        }
    }

    private void appendReportCreationDate(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, ResourceBundle resourceBundle) {
        String dateString = PlanningReportHelper.formatUtcMillisAsYearToDay(System.currentTimeMillis());
        String formattedString = MessageFormat.format(resourceBundle.getString("planningNotificationReportCreationDate"), dateString);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        String standardParagraphStyle = localStyles.getStandardParagraphStyle();
        String marginTopStyle = stylesOfficeStyles.getParagraphStyleWithParent(standardParagraphStyle, "text", new OdfStylePropertiesBase[0]);
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphPropertiesWithMargin(null, null, "1.0cm", null);
        paragraphProperties.setFoTextAlignAttribute("left");
        String marginStyle = stylesOfficeStyles.getParagraphStyleWithParent(marginTopStyle, new OdfStylePropertiesBase[]{paragraphProperties});
        TextFactory.constructTextNode((Node)officeText, (String)formattedString, (String)marginStyle);
    }

    private void appendCreator(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, OrganisationPersonJoin organisationPersonJoin, ResourceBundle resourceBundle) {
        String creatorString = resourceBundle.getString("planningNotificationReportCreator");
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        String standardParagraphStyle = localStyles.getStandardParagraphStyle();
        String marginTopStyle = stylesOfficeStyles.getParagraphStyleWithParent(standardParagraphStyle, "text", new OdfStylePropertiesBase[0]);
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphPropertiesWithMargin(null, null, "0.5cm", null);
        paragraphProperties.setFoTextAlignAttribute("left");
        String marginStyle = stylesOfficeStyles.getParagraphStyleWithParent(marginTopStyle, new OdfStylePropertiesBase[]{paragraphProperties});
        TextFactory.constructTextNode((Node)officeText, (String)creatorString, (String)marginStyle);
    }

    private void appendSignature(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, OrganisationPersonJoin organisationPersonJoin, ResourceBundle resourceBundle) {
        String lowerStyle;
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        String standardParagraphStyle = localStyles.getStandardParagraphStyle();
        String topStyle = stylesOfficeStyles.getParagraphStyleWithParent(standardParagraphStyle, "text", new OdfStylePropertiesBase[0]);
        StyleParagraphPropertiesElement nameParagraphProperties = stylesOfficeStyles.constructParagraphPropertiesWithMargin(null, null, null, null);
        nameParagraphProperties.setFoTextAlignAttribute("left");
        String nameStyle = stylesOfficeStyles.getParagraphStyleWithParent(topStyle, new OdfStylePropertiesBase[]{stylesOfficeStyles.constructTextPropertiesWithFontSize("10pt"), nameParagraphProperties});
        String givenName = organisationPersonJoin.getPersonGivenName();
        String surName = organisationPersonJoin.getPersonSurName();
        TextFactory.constructTextNode((Node)officeText, (String)(givenName + " " + surName), (String)nameStyle);
        StyleParagraphPropertiesElement lowerParagraphProperties = stylesOfficeStyles.constructParagraphPropertiesWithMargin(null, null, null, null);
        lowerParagraphProperties.setFoTextAlignAttribute("left");
        lowerParagraphProperties.setStyleVerticalAlignAttribute("bottom");
        String organisationStyle = lowerStyle = stylesOfficeStyles.getParagraphStyleWithParent(topStyle, new OdfStylePropertiesBase[]{stylesOfficeStyles.constructTextPropertiesWithFontSize("10pt"), lowerParagraphProperties});
        String organisationName = organisationPersonJoin.getOrganisationName();
        TextFactory.constructTextNode((Node)officeText, (String)organisationName, (String)organisationStyle);
        String addressStyle = lowerStyle;
        String postalCode = organisationPersonJoin.getOrganisationPersonPostalCode();
        String localityName = organisationPersonJoin.getOrganisationPersonLocalityName();
        String postalAddress = organisationPersonJoin.getOrganisationPersonPostalAddress();
        String addressString = MessageFormat.format(resourceBundle.getString("oneLineAddress"), postalCode, localityName, postalAddress);
        TextFactory.constructTextNode((Node)officeText, (String)addressString, (String)addressStyle);
        String mailStyle = lowerStyle;
        String mailAddress = organisationPersonJoin.getOrganisationPersonEmailAddress();
        TextFactory.constructTextNode((Node)officeText, (String)mailAddress, (String)mailStyle);
    }

    private void appendStateCaption(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, ResourceBundle resourceBundle) {
        String captionStyle = this.constructPageBreakStyle(context, localStyles.getHeadingTwoStyle());
        String caption = resourceBundle.getString("planningNotificationReportStateCaption");
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)captionStyle, (Integer)2);
    }

    private void appendStateChart(OfficeTextElement officeText, OdfContext context, List<PlanningNotificationReportInfo> reportInfos, ResourceBundle resourceBundle) {
        String oleStyle = this.getChartOleStyle(context);
        String fr1Style = this.getChartFr1Style(context, oleStyle);
        TextPElement pElement = TextFactory.constructTextNode((Node)officeText, null, null);
        DrawFrameElement frameElement = FrameFactory.constructDrawFrameNode((Node)pElement, (String)fr1Style, (String)"paragraph", null, null, (String)"16.0cm", (String)"9.0cm", (Integer)0);
        DrawObjectElement objectElement = ObjectFactory.constructObject((Node)frameElement);
        String chartStylePrefix = context.getStylePrefix() + "__charts";
        OdfContext chartContext = DocumentFactory.constructDefaultOfficeDocumentElement((Node)objectElement, (String)"TODO", (String)chartStylePrefix);
        OfficeBodyElement chartDocumentBodyElement = chartContext.getOfficeBodyElement();
        int redCount = 0;
        int yellowCount = 0;
        int greenCount = 0;
        for (PlanningNotificationReportInfo reportInfo : reportInfos) {
            PlanningNotificationOrderState state = this.getPlanningNotificationOrderState(reportInfo);
            if (state == PlanningNotificationOrderState.RED) {
                ++redCount;
                continue;
            }
            if (state == PlanningNotificationOrderState.YELLOW) {
                ++yellowCount;
                continue;
            }
            if (state == PlanningNotificationOrderState.GREEN) {
                ++greenCount;
                continue;
            }
            throw new IllegalArgumentException("Unsupported PlanningNotificationOrderState: " + (Object)((Object)state));
        }
        ArrayList<StateChartData> stateChartData = new ArrayList<StateChartData>();
        String redString = MessageFormat.format(resourceBundle.getString("planningNotificationReportRedCount"), String.valueOf(redCount));
        String yellowString = MessageFormat.format(resourceBundle.getString("planningNotificationReportYellowCount"), String.valueOf(yellowCount));
        String greenString = MessageFormat.format(resourceBundle.getString("planningNotificationReportGreenCount"), String.valueOf(greenCount));
        stateChartData.add(new StateChartData(greenString, Double.valueOf(greenCount), "#00ff00"));
        stateChartData.add(new StateChartData(yellowString, Double.valueOf(yellowCount), "#ff6600"));
        stateChartData.add(new StateChartData(redString, Double.valueOf(redCount), "#ff0000"));
        Styles stylesStyles = chartContext.getStylesOfficeStyles();
        AutomaticStyles stylesAutomaticStyles = chartContext.getStylesAutomaticStyles();
        OdfChart odfChart = new OdfChart();
        odfChart.setWidth("16cm");
        odfChart.setHeight("9cm");
        odfChart.setChartClass("chart:circle");
        odfChart.setLegendPosition("end");
        odfChart.setLegendX("14.211cm");
        odfChart.setLegendY("3.453cm");
        odfChart.setLegendExpansion("high");
        odfChart.setPlotAreaX("0.319cm");
        odfChart.setPlotAreaY("0.179cm");
        odfChart.setPlotAreaWidth("13.573cm");
        odfChart.setPlotAreaHeight("8.641cm");
        odfChart.setCoordRegionX("2.785cm");
        odfChart.setCoordRegionY("0.18cm");
        odfChart.setCoordRegionWidth("8.64cm");
        odfChart.setCoordRegionHeight("8.64cm");
        odfChart.addColumn((OdfChartColumn)new OdfChartColumn<StateChartData>(true, "label", "label"){

            public void appendDataTableCell(TableTableRowElement rowElement, StateChartData data) {
                TableFactory.appendCell((TableTableRowElement)rowElement, (String[])new String[]{data.getLineCaption()});
            }
        });
        odfChart.addColumn((OdfChartColumn)new OdfChartColumn<StateChartData>("value", "value"){

            public void appendDataTableCell(TableTableRowElement rowElement, StateChartData data) {
                TableFactory.appendCell(null, null, (TableTableRowElement)rowElement, (Double)data.getValue());
            }
        });
        odfChart.render(stylesStyles, (Styles)stylesAutomaticStyles, (Node)chartDocumentBodyElement, stateChartData);
    }

    private PlanningNotificationOrderState getPlanningNotificationOrderState(PlanningNotificationReportInfo reportInfo) {
        Set matchingBaulosIds = reportInfo.getMatchingBaulosIds();
        if (matchingBaulosIds == null || matchingBaulosIds.size() == 0) {
            String workflowEntityStatusName = reportInfo.getReportJoin().getWorkflowEntityStatusName();
            if ("in Durchf\u00fchrung".equals(workflowEntityStatusName) || "durchgef\u00fchrt".equals(workflowEntityStatusName) || "zugestimmt".equals(workflowEntityStatusName)) {
                return PlanningNotificationOrderState.YELLOW;
            }
            if ("freigegeben".equals(workflowEntityStatusName)) {
                return PlanningNotificationOrderState.GREEN;
            }
            return PlanningNotificationOrderState.RED;
        }
        List resultJoins = reportInfo.getWorkflowActivityPositionResultJoins();
        Map workflowActivityIdToBaulose = reportInfo.getWorkflowActivityIdToBaulose();
        HashMap baulosIdToResultJoins = new HashMap();
        for (WorkflowActivityPositionResultJoin resultJoin : resultJoins) {
            Long workflowActivityId = resultJoin.getWorkflowActivityId();
            List baulose = (List)workflowActivityIdToBaulose.get(workflowActivityId);
            if (baulose == null) continue;
            for (PlanningNotificationTextMetaInformation baulos : baulose) {
                Long baulosId = baulos.getMetaInformationId();
                if (!baulosIdToResultJoins.containsKey(baulosId)) {
                    baulosIdToResultJoins.put(baulosId, new ArrayList());
                }
                ((List)baulosIdToResultJoins.get(baulosId)).add(resultJoin);
            }
        }
        PlanningNotificationOrderState retState = PlanningNotificationOrderState.RED;
        for (Long baulosId : baulosIdToResultJoins.keySet()) {
            List baulosResultJoins = (List)baulosIdToResultJoins.get(baulosId);
            Collections.sort(baulosResultJoins, new Comparator<WorkflowActivityPositionResultJoin>(){

                @Override
                public int compare(WorkflowActivityPositionResultJoin joinOne, WorkflowActivityPositionResultJoin joinTwo) {
                    if (joinOne.getWorkflowActivityIssued() == null) {
                        return -1;
                    }
                    if (joinTwo.getWorkflowActivityIssued() == null) {
                        return 1;
                    }
                    return joinOne.getWorkflowActivityIssued() < joinTwo.getWorkflowActivityIssued() ? -1 : 1;
                }
            });
            if (baulosResultJoins.size() <= 0) continue;
            WorkflowActivityPositionResultJoin lastBaulosResultJoin = (WorkflowActivityPositionResultJoin)baulosResultJoins.get(baulosResultJoins.size() - 1);
            String result = lastBaulosResultJoin.getWorkflowActivityPositionResultResult();
            PlanningNotificationOrderState currState = null;
            currState = "Zwischenergebnis".equals(result) || "Durchf\u00fchrung".equals(result) || "Zustimmung".equals(result) ? PlanningNotificationOrderState.YELLOW : ("Freigabe".equals(result) ? PlanningNotificationOrderState.GREEN : PlanningNotificationOrderState.RED);
            if (retState == null) {
                retState = currState;
                continue;
            }
            if (currState.getOrder() >= retState.getOrder()) continue;
            retState = currState;
        }
        return retState;
    }

    private String getChartOleStyle(OdfContext context) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleGraphicPropertiesElement oleGraphicProperties = stylesOfficeStyles.constructGraphicProperties();
        oleGraphicProperties.setTextAnchorTypeAttribute("paragraph");
        oleGraphicProperties.setSvgXAttribute("0cm");
        oleGraphicProperties.setSvgYAttribute("0cm");
        oleGraphicProperties.setStyleWrapAttribute("dynamic");
        oleGraphicProperties.setStyleWrapContourAttribute(Boolean.valueOf(false));
        oleGraphicProperties.setStyleVerticalPosAttribute("top");
        oleGraphicProperties.setStyleVerticalRelAttribute("paragraph");
        oleGraphicProperties.setStyleHorizontalPosAttribute("center");
        oleGraphicProperties.setStyleHorizontalRelAttribute("paragraph");
        return stylesOfficeStyles.getGraphicStyle(new OdfStylePropertiesBase[]{oleGraphicProperties});
    }

    private String getChartFr1Style(OdfContext context, String oleStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleGraphicPropertiesElement fr1GraphicProperties = stylesOfficeStyles.constructGraphicProperties();
        fr1GraphicProperties.setStyleHorizontalPosAttribute("center");
        fr1GraphicProperties.setStyleHorizontalRelAttribute("paragraph");
        fr1GraphicProperties.setDrawOleDrawAspectAttribute(Integer.valueOf(1));
        return stylesOfficeStyles.getGraphicStyleWithParent(oleStyle, new OdfStylePropertiesBase[]{fr1GraphicProperties});
    }

    private void appendContentCaption(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, ResourceBundle resourceBundle) {
        String captionStyle = this.constructPageBreakStyle(context, localStyles.getHeadingTwoStyle());
        String caption = resourceBundle.getString("planningNotificationReportContentCaption");
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)captionStyle, (Integer)2);
    }

    private void appendAllContentTable(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, List<PlanningNotificationReportInfo> reportInfos, List<MetaTag> metaTags, ResourceBundle resourceBundle) {
        HashSet<Long> alreadyProcessedPlanningNotificationIds = new HashSet<Long>();
        for (PlanningNotificationReportInfo reportInfo : reportInfos) {
            Long planningNotificationId = reportInfo.getReportJoin().getPlanningNotificationId();
            if (alreadyProcessedPlanningNotificationIds.contains(planningNotificationId)) continue;
            alreadyProcessedPlanningNotificationIds.add(planningNotificationId);
            this.appendAllContentTableSection(officeText, context, localStyles, exportInfo, reportInfo, metaTags, resourceBundle);
        }
    }

    private void appendAllContentTableSection(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, PlanningNotificationReportInfo reportInfo, List<MetaTag> metaTags, ResourceBundle resourceBundle) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Map metaTagIdToTextMetaInformations = reportInfo.getMetaTagIdToTextMetaInformations();
        Map metaTagIdToDateMetaInformations = reportInfo.getMetaTagIdToDateMetaInformations();
        Long gzMetaTagId = this.getGzMetaTagId(metaTags);
        Long documentDateMetaTagId = this.getDocumentDateMetaTagId(metaTags);
        List gzTextMetaInformations = metaTagIdToTextMetaInformations != null ? (List)metaTagIdToTextMetaInformations.get(gzMetaTagId) : null;
        List documentDateMetaInformations = metaTagIdToDateMetaInformations != null ? (List)metaTagIdToDateMetaInformations.get(documentDateMetaTagId) : null;
        PlanningNotificationTextMetaInformation gzMetaInformation = gzTextMetaInformations != null && gzTextMetaInformations.size() > 0 ? (PlanningNotificationTextMetaInformation)gzTextMetaInformations.get(0) : null;
        PlanningNotificationDateMetaInformation documentDateMetaInformation = documentDateMetaInformations != null && documentDateMetaInformations.size() > 0 ? (PlanningNotificationDateMetaInformation)documentDateMetaInformations.get(0) : null;
        String gz = gzMetaInformation != null ? gzMetaInformation.getValue() : "";
        String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
        Double documentDateUtcSeconds = documentDateMetaInformation != null ? documentDateMetaInformation.getValue() : null;
        String documentDateString = documentDateUtcSeconds != null ? DateHelper.formatUtcSeconds(documentDateUtcSeconds, "Europe/Vienna", dateFormatPattern) : "";
        String tableStyle = localStyles.getTableUnderCaptionStyle();
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "none")});
        String dataTextStyle = localStyles.getDataTextStyle(reportInfo);
        Styles styles = context.getContentAutomaticStyles();
        String leftColumnWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, "8200*", "7800*");
        String centerColumnWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, "1000*", "1200*");
        String rightColumnWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, "800*", "1000*");
        String leftColumnStyle = styles.getTableColumnStyle(new OdfStylePropertiesBase[]{styles.constructTableColumnPropertiesWithRelativeWidth(leftColumnWidth)});
        String centerColumnStyle = styles.getTableColumnStyle(new OdfStylePropertiesBase[]{styles.constructTableColumnPropertiesWithRelativeWidth(centerColumnWidth)});
        String rightColumnStyle = styles.getTableColumnStyle(new OdfStylePropertiesBase[]{styles.constructTableColumnPropertiesWithRelativeWidth(rightColumnWidth)});
        TableTableElement tableElement = officeText.newTableTableElement();
        tableElement.setStyleName(tableStyle);
        TableTableColumnElement leftColumnElement = tableElement.newTableTableColumnElement();
        leftColumnElement.setStyleName(leftColumnStyle);
        TableTableColumnElement centerColumnElement = tableElement.newTableTableColumnElement();
        centerColumnElement.setStyleName(centerColumnStyle);
        TableTableColumnElement rightColumnElement = tableElement.newTableTableColumnElement();
        rightColumnElement.setStyleName(rightColumnStyle);
        TableTableRowElement upperRow = tableElement.newTableTableRowElement();
        TableTableCellElement upperCell = TableFactory.appendTextStyledCell((String)dataTextStyle, (TableTableRowElement)upperRow, (String[])new String[]{reportInfo.getReportJoin().getPlanningNotificationTitle()});
        upperCell.setStyleName(dataCellStyle);
        upperCell.setTableNumberColumnsSpannedAttribute(Integer.valueOf(3));
        upperRow.newTableCoveredTableCellElement(0.0, null);
        upperRow.newTableCoveredTableCellElement(0.0, null);
        TableTableRowElement lowerRow = tableElement.newTableTableRowElement();
        TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)lowerRow, (String[])new String[]{gz});
        TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)lowerRow, (String[])new String[]{documentDateString});
        TableTableCellElement cell = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)lowerRow);
        TextPElement pElement = TextFactory.constructTextNode((Node)cell, (String)resourceBundle.getString("planningNotificationReportContentPagePrefix"), (String)dataTextStyle);
        ReferenceFactory.appendReference((Node)pElement, (String)"page", (String)(PLANNING_NOTIFICATION_ORDER_ANCHOR_PREFIX + reportInfo.getReportJoin().getPlanningNotificationOrderWorkflowEntityId()), (String)"TODO");
    }

    private void appendIndividualContentTable(OfficeTextElement officeText, OdfContext context, final PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, List<PlanningNotificationReportInfo> reportInfos, List<MetaTag> metaTags, final ResourceBundle resourceBundle) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = localStyles.getTableUnderCaptionStyle();
        Styles automaticStyles = context.getContentAutomaticStyles();
        final String dataCellStyle = automaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{automaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "none")});
        ArrayList columns = new ArrayList();
        columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("serialNumber", resourceBundle.getString("planningNotificationOrderSerialNumberColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                String dataTextStyle = localStyles.getDataTextStyle(data);
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getReportJoin().getPlanningNotificationOrderSerialNumber(), (Long)dataTwo.getReportJoin().getPlanningNotificationOrderSerialNumber(), (boolean)descending);
            }

            private String getOutput(PlanningNotificationReportInfo reportInfo) {
                Long serialNumber = reportInfo.getReportJoin().getPlanningNotificationOrderSerialNumber();
                return serialNumber != null ? serialNumber.toString() : "";
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("text", resourceBundle.getString("planningNotificationOrderTextColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                String dataTextStyle = localStyles.getDataTextStyle(data);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
            }

            private String getOutput(PlanningNotificationReportInfo reportInfo) {
                return reportInfo.getReportJoin().getPlanningNotificationOrderText();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("planningNotification", resourceBundle.getString("planningNotificationOrderPlanningNotificationColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                String dataTextStyle = localStyles.getDataTextStyle(data);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
            }

            private String getOutput(PlanningNotificationReportInfo reportInfo) {
                return reportInfo.getReportJoin().getPlanningNotificationTitle();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("documentPage", resourceBundle.getString("planningNotificationOrderDocumentPageColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                String dataTextStyle = localStyles.getDataTextStyle(data);
                TableTableCellElement cell = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                TextPElement pElement = TextFactory.constructTextNode((Node)cell, (String)resourceBundle.getString("planningNotificationReportContentPagePrefix"), (String)dataTextStyle);
                ReferenceFactory.appendReference((Node)pElement, (String)"page", (String)(PlanningReportPdfExporter.PLANNING_NOTIFICATION_ORDER_ANCHOR_PREFIX + data.getReportJoin().getPlanningNotificationOrderWorkflowEntityId()), (String)"TODO");
            }

            public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
            }

            private String getOutput(PlanningNotificationReportInfo reportInfo) {
                return "";
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("serialNumber", 0.05);
        relativeColumnWidths.put("text", 0.5);
        relativeColumnWidths.put("planningNotification", 0.25);
        relativeColumnWidths.put("documentPage", 0.07);
        HashMap<Long, MetaTag> idToMetaTag = new HashMap<Long, MetaTag>();
        for (MetaTag metaTag : metaTags) {
            idToMetaTag.put(metaTag.getId(), metaTag);
        }
        List columnSortSpecs = ColumnSortSpec.getFromClient((List)exportInfo.getSortSpecs());
        PlanningReportHelper.convertReportColumnSortSpecsFromClientToServer(columnSortSpecs, idToMetaTag);
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = PlanningReportPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(false);
        table.render((Node)officeText, reportInfos, columnSortSpecs);
    }

    private void appendPlanningNotificationOrderCaption(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportInfo reportInfo, ResourceBundle resourceBundle) {
        String captionStyle = this.constructPageBreakStyle(context, localStyles.getHeadingTwoStyle());
        String rawCaption = resourceBundle.getString("planningNotificationReportOrderCaption");
        String serialNumberString = reportInfo.getReportJoin().getPlanningNotificationOrderSerialNumber().toString();
        String formattedCaption = MessageFormat.format(rawCaption, serialNumberString);
        TextHElement headerNode = TextFactory.constructTextHeaderNode((Node)officeText, (String)formattedCaption, (String)captionStyle, (Integer)2);
        ReferenceFactory.appendAnchor((Node)headerNode, (String)(PLANNING_NOTIFICATION_ORDER_ANCHOR_PREFIX + reportInfo.getReportJoin().getPlanningNotificationOrderWorkflowEntityId()));
    }

    private void appendPlanningNotificationOrderNotificationTable(OfficeTextElement officeText, OdfContext context, final PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, PlanningNotificationReportInfo reportInfo, List<MetaTag> metaTags, PlanningNotificationReportColumnSettings columnSettings, final ResourceBundle resourceBundle) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = localStyles.getTableUnderCaptionStyle();
        final String dataCellStyle = localStyles.getDataCellStyle();
        ArrayList columns = new ArrayList();
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTitle())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("title", resourceBundle.getString("planningNotificationListTitleColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, data.getReportJoin().getPlanningNotificationTitle());
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)dataOne.getReportJoin().getPlanningNotificationTitle(), (String)dataTwo.getReportJoin().getPlanningNotificationTitle(), (boolean)descending);
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowNotificationComment())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("comment", resourceBundle.getString("planningNotificationListCommentColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, data.getReportJoin().getPlanningNotificationComment());
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)dataOne.getReportJoin().getPlanningNotificationComment(), (String)dataTwo.getReportJoin().getPlanningNotificationComment(), (boolean)descending);
                }
            });
        }
        Collections.sort(metaTags, new Comparator<MetaTag>(){

            @Override
            public int compare(MetaTag metaTagOne, MetaTag metaTagTwo) {
                return metaTagOne.getPosition() - metaTagTwo.getPosition();
            }
        });
        for (final MetaTag metaTag : metaTags) {
            if (columnSettings.getMetaTagIdToShow() == null || !PlanningReportPdfExporter.doShow(exportInfo, (Boolean)columnSettings.getMetaTagIdToShow().get(metaTag.getId()))) continue;
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>(metaTag.getCssClass(), metaTag.getName()){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    List<String> tokens = this.getTokens(data);
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, tokens);
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, this.getTokens(dataOne), this.getTokens(dataTwo), (boolean)descending);
                }

                private List<String> getTokens(PlanningNotificationReportInfo data) {
                    return PlanningExportHelper.getMetaTagTokens(resourceBundle, metaTag, data.getMetaTagIdToTextMetaInformations(), data.getMetaTagIdToDateMetaInformations());
                }
            });
        }
        ArrayList<PlanningNotificationReportInfo> reportInfos = new ArrayList<PlanningNotificationReportInfo>();
        reportInfos.add(reportInfo);
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = PlanningReportPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, null);
        table.setTableStyle(tableUnderCaptionStyle);
        table.render((Node)officeText, reportInfos, null);
    }

    private void appendPlanningNotificationOrderDetailTable(OfficeTextElement officeText, OdfContext context, final PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, PlanningNotificationReportInfo reportInfo, PlanningNotificationReportColumnSettings columnSettings, final ResourceBundle resourceBundle) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = localStyles.getTableUnderCaptionStyle();
        final String dataCellStyle = localStyles.getDataCellStyle();
        ArrayList columns = new ArrayList();
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSerialNumber())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("serialNumber", resourceBundle.getString("planningNotificationOrderSerialNumberColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getReportJoin().getPlanningNotificationOrderSerialNumber(), (Long)dataTwo.getReportJoin().getPlanningNotificationOrderSerialNumber(), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    Long serialNumber = reportInfo.getReportJoin().getPlanningNotificationOrderSerialNumber();
                    return serialNumber != null ? serialNumber.toString() : "";
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowText())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("text", resourceBundle.getString("planningNotificationOrderTextColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getOutput(data));
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    String text = reportInfo.getReportJoin().getPlanningNotificationOrderText();
                    return text;
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowDocumentPosition())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("documentPosition", resourceBundle.getString("planningNotificationOrderDocumentPositionColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return reportInfo.getReportJoin().getPlanningNotificationOrderDocumentPosition();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowDocumentPage())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("documentPage", resourceBundle.getString("planningNotificationOrderDocumentPageColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return reportInfo.getReportJoin().getPlanningNotificationOrderDocumentPage();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSubjectArea())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("subjectArea", resourceBundle.getString("planningNotificationOrderSubjectAreaColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return reportInfo.getReportJoin().getSubjectAreaName();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowAuthorizedInspector())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("authorizedInspector", resourceBundle.getString("planningNotificationOrderAuthorizedInspectorColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return reportInfo.getReportJoin().getPlanningNotificationOrderAuthorizedInspector();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowReference())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("reference", resourceBundle.getString("planningNotificationOrderReferenceColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo orderInfo) {
                    List referenceInfos = orderInfo.getReferenceInfos();
                    return PlanningExportHelper.getReferenceOutput(referenceInfos);
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSource())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("source", resourceBundle.getString("planningNotificationOrderSourceColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getOutput(data));
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return reportInfo.getReportJoin().getPlanningNotificationOrderSource();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSubmitAuthority())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("submitAuthority", resourceBundle.getString("planningNotificationOrderSubmitAuthorityColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    Boolean submitAuthority = reportInfo.getReportJoin().getPlanningNotificationOrderSubmitAuthority();
                    return submitAuthority != null && submitAuthority == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTags())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("tag", resourceBundle.getString("planningNotificationOrderTagColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    String tagString = "";
                    List tags = reportInfo.getTags();
                    for (int n = 0; n < tags.size(); ++n) {
                        tagString = tagString + ((PlanningNotificationOrderTag)tags.get(n)).getLabel();
                        if (n >= tags.size() - 1) continue;
                        tagString = tagString + ", ";
                    }
                    return tagString;
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowInvalidated())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("invalidated", resourceBundle.getString("planningNotificationOrderInvalidatedColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    Boolean invalidated = reportInfo.getReportJoin().getWorkflowEntityInvalidated();
                    return invalidated != null && invalidated == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
                }
            });
        }
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "serialNumber", 0.05, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSerialNumber()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "text", 0.2, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowText()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "documentPosition", 0.1, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowDocumentPosition()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "documentPage", 0.1, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowDocumentPage()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "subjectArea", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSubjectArea()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "authorizedInspector", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowAuthorizedInspector()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "reference", 0.1, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowReference()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "source", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSource()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "submitAuthority", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSubmitAuthority()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "tag", 0.1, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTags()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "invalidated", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowInvalidated()));
        Styles styles = context.getContentAutomaticStyles();
        ArrayList<PlanningNotificationReportInfo> reportInfos = new ArrayList<PlanningNotificationReportInfo>();
        reportInfos.add(reportInfo);
        Double tableWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, 23.9, 15.2);
        PlanningReportHelper.ensureAbsoluteColumnWidth(relativeColumnWidths, ORDER_DETAIL_MIN_ABS_COLUMN_WIDTH, tableWidth);
        FancyOdfTable table = PlanningReportPdfExporter.constructFancyTable(styles, localStyles, tableWidth, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.render((Node)officeText, reportInfos, null);
    }

    private void appendPlanningNotificationOrderReviewOverviewTable(OfficeTextElement officeText, OdfContext context, final PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, PlanningNotificationReportInfo reportInfo, PlanningNotificationReportColumnSettings columnSettings, final ResourceBundle resourceBundle) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = localStyles.getTableUnderCaptionStyle();
        final String dataCellStyle = localStyles.getDataCellStyle();
        ArrayList columns = new ArrayList();
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDuty())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("statutoryDuty", resourceBundle.getString("planningNotificationOrderStatutoryDutyColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return reportInfo.getReportJoin().getStatutoryDutyName();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowPersonInCharge())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("personInCharge", resourceBundle.getString("planningNotificationOrderPersonInChargeColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return reportInfo.getReportJoin().getPersonInChargeName();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyFrom())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("statutoryDutyFrom", resourceBundle.getString("planningNotificationOrderStatutoryDutyFromColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getReportJoin().getPlanningNotificationOrderStatutoryDutyFrom(), (Long)dataTwo.getReportJoin().getPlanningNotificationOrderStatutoryDutyFrom(), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo orderInfo) {
                    String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                    Long utcMillis = orderInfo.getReportJoin().getPlanningNotificationOrderStatutoryDutyFrom();
                    return utcMillis != null ? DateHelper.formatUtcMillis(utcMillis, "Europe/Vienna", dateFormatPattern) : "";
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyTo())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("statutoryDutyTo", resourceBundle.getString("planningNotificationOrderStatutoryDutyToColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getReportJoin().getPlanningNotificationOrderStatutoryDutyTo(), (Long)dataTwo.getReportJoin().getPlanningNotificationOrderStatutoryDutyTo(), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo orderInfo) {
                    String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                    Long utcMillis = orderInfo.getReportJoin().getPlanningNotificationOrderStatutoryDutyTo();
                    return utcMillis != null ? DateHelper.formatUtcMillis(utcMillis, "Europe/Vienna", dateFormatPattern) : "";
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyInterval())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("statutoryDutyInterval", resourceBundle.getString("planningNotificationOrderStatutoryDutyIntervalColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    Integer intervalOne = dataOne.getReportJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                    Integer intervalTwo = dataTwo.getReportJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)(intervalOne != null ? Long.valueOf(intervalOne.longValue()) : null), (Long)(intervalTwo != null ? Long.valueOf(intervalTwo.longValue()) : null), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo orderInfo) {
                    Integer interval = orderInfo.getReportJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                    return interval != null ? interval.toString() : "";
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyLeadTime())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("statutoryDutyLeadTime", resourceBundle.getString("planningNotificationOrderStatutoryDutyLeadTimeColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    Integer leadTimeOne = dataOne.getReportJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                    Integer leadTimeTwo = dataTwo.getReportJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)(leadTimeOne != null ? Long.valueOf(leadTimeOne.longValue()) : null), (Long)(leadTimeTwo != null ? Long.valueOf(leadTimeTwo.longValue()) : null), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo orderInfo) {
                    Integer leadTime = orderInfo.getReportJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                    return leadTime != null ? leadTime.toString() : "";
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyExpired())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("statutoryDutyExpired", resourceBundle.getString("planningNotificationOrderStatutoryDutyExpiredColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo orderInfo) {
                    Boolean expired = orderInfo.getReportJoin().getPlanningNotificationOrderStatutoryDutyExpired();
                    return expired != null && expired == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowWorkflowNode())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("workflowNode", resourceBundle.getString("planningNotificationOrderWorkflowNodeColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo reportInfo) {
                    List<WorkflowNodeJoin> workflowNodeJoins = this.getWorkflowNodeJoins(reportInfo);
                    String dataTextStyle = localStyles.getDataTextStyle(reportInfo);
                    String dataItalicTextStyle = localStyles.getDataItalicStyle(reportInfo);
                    String dataRedTextStyle = localStyles.getDataRedStyle(reportInfo);
                    String dataCaptionTextStyle = localStyles.getDataCaptionStyle(reportInfo);
                    PlanningExportHelper.appendWorkflowNodeCell(rowElement, resourceBundle, workflowNodeJoins, reportInfo.getWorkflowNodeIdToPositions(), reportInfo.getWorkflowNodePositionIdToBaulose(), dataCellStyle, dataTextStyle, dataItalicTextStyle, dataRedTextStyle, dataCaptionTextStyle);
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private List<WorkflowNodeJoin> getWorkflowNodeJoins(PlanningNotificationReportInfo reportInfo) {
                    List workflowNodeJoins = reportInfo.getWorkflowNodeJoins();
                    if (workflowNodeJoins != null) {
                        Collections.sort(workflowNodeJoins, new Comparator<WorkflowNodeJoin>(){

                            @Override
                            public int compare(WorkflowNodeJoin joinOne, WorkflowNodeJoin joinTwo) {
                                return joinOne.getWorkflowNodeTemplatePosition() - joinTwo.getWorkflowNodeTemplatePosition();
                            }
                        });
                        return workflowNodeJoins;
                    }
                    return new ArrayList<WorkflowNodeJoin>();
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return "Not implemented.";
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowState())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("state", resourceBundle.getString("planningNotificationOrderStateColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    String workflowEntityStatusName = reportInfo.getReportJoin().getWorkflowEntityStatusName();
                    if (workflowEntityStatusName == null) {
                        return resourceBundle.getString("workflowStatusNotInitialized");
                    }
                    return reportInfo.getReportJoin().getWorkflowEntityStatusName();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowOrderComment())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("comment", resourceBundle.getString("planningNotificationOrderCommentColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getOutput(data));
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    return reportInfo.getReportJoin().getPlanningNotificationOrderComment();
                }
            });
        }
        if (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowEnvironmentallyRelevant())) {
            columns.add(new FancyOdfTableColumn<PlanningNotificationReportInfo>("environmentallyRelevant", resourceBundle.getString("planningNotificationOrderEnvironmentallyRelevantColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(PlanningNotificationReportInfo dataOne, PlanningNotificationReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private String getOutput(PlanningNotificationReportInfo reportInfo) {
                    Boolean environmentallyRelevant = reportInfo.getReportJoin().getPlanningNotificationOrderEnvironmentallyRelevant();
                    return environmentallyRelevant != null && environmentallyRelevant == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
                }
            });
        }
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "statutoryDuty", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDuty()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "personInCharge", 0.1, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowPersonInCharge()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "statutoryDutyFrom", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSerialNumber()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "statutoryDutyTo", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowText()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "statutoryDutyInterval", 0.1, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTitle()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "statutoryDutyLeadTime", 0.1, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowProject()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "statutoryDutyExpired", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowAuthorizedInspector()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "workflowNode", 0.18, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowWorkflowNode()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "state", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowState()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "comment", 0.1, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowOrderComment()));
        PlanningReportHelper.setColumnWidth(relativeColumnWidths, "environmentallyRelevant", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowEnvironmentallyRelevant()));
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles stylesStyles = context.getStylesOfficeStyles();
        ArrayList<PlanningNotificationReportInfo> reportInfos = new ArrayList<PlanningNotificationReportInfo>();
        reportInfos.add(reportInfo);
        boolean includeTrafficLights = exportInfo.getIncludeOrderStatusGraphics() != null && exportInfo.getIncludeOrderStatusGraphics() == true;
        double numericWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, includeTrafficLights ? 25.7 : 27.15, includeTrafficLights ? 17.0 : 18.45);
        String stringWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, includeTrafficLights ? "25.7cm" : "27.15cm", includeTrafficLights ? "17cm" : "18.45cm");
        FancyOdfTable table = PlanningReportPdfExporter.constructFancyTable(contentAutomaticStyles, localStyles, numericWidth, columns, relativeColumnWidths);
        String tableStyle = contentAutomaticStyles.getTableStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableProperties(stringWidth, null, "margins", null)});
        table.setTableStyle(tableStyle);
        StyleGraphicPropertiesElement frameProperties = FrameFactory.constructFrameParentProperties((Styles)stylesStyles);
        frameProperties.setFoMarginTopAttribute("0.5cm");
        String frameStyle = stylesStyles.getGraphicStyle(new OdfStylePropertiesBase[]{frameProperties});
        String drawFrameStyle = contentAutomaticStyles.getGraphicStyleWithParent(frameStyle, new OdfStylePropertiesBase[]{FrameFactory.constructFrameProperties((Styles)contentAutomaticStyles, (String)"right", (String)"from-left")});
        TextPElement pElement = TextFactory.constructTextNode((Node)officeText, null, null);
        DrawFrameElement drawFrameElement = FrameFactory.constructDrawFrameNode((Node)pElement, (String)drawFrameStyle, (String)"as-char", null, (String)"0cm", (String)stringWidth, null, (Integer)0);
        DrawTextBoxElement textBoxElement = TextFactory.constructTextBox((Node)drawFrameElement, null);
        table.render((Node)textBoxElement, reportInfos, null);
        if (includeTrafficLights) {
            StyleGraphicPropertiesElement trafficLightFrameProperties = FrameFactory.constructFrameProperties((Styles)contentAutomaticStyles, (String)"left", (String)"from-right");
            trafficLightFrameProperties.setFoMarginLeftAttribute("0.24cm");
            trafficLightFrameProperties.setFoMarginTopAttribute("0.5cm");
            String trafficLightFrameStyle = contentAutomaticStyles.getGraphicStyleWithParent(frameStyle, new OdfStylePropertiesBase[]{trafficLightFrameProperties});
            String trafficLightFrameX = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, "25.7cm", "17cm");
            DrawFrameElement trafficLightFrameElement = FrameFactory.constructDrawFrameNode((Node)pElement, (String)trafficLightFrameStyle, (String)"as-char", (String)trafficLightFrameX, null, (String)"1.2cm", null, (Integer)0);
            DrawTextBoxElement trafficLightTextBoxElement = TextFactory.constructTextBox((Node)trafficLightFrameElement, null);
            this.constructTrafficLightImageInTable((Node)trafficLightTextBoxElement, context, reportInfo);
        }
    }

    private TableTableElement constructTrafficLightImageInTable(Node parentNode, OdfContext context, PlanningNotificationReportInfo reportInfo) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles stylesStyles = context.getStylesOfficeStyles();
        String tableStyle = contentAutomaticStyles.getTableStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableProperties("1.2cm", null, "left", null)});
        String tableColumnStyle = contentAutomaticStyles.getTableColumnStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableColumnPropertiesWithAbsoluteWidth("1.2cm")});
        String tableCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithPaddingAndBorders("0.1cm", "0.05pt solid #000000", "0.1cm", "0.05pt solid #000000", "0.05cm", "0.05pt solid #000000", "0.1cm", "0.05pt solid #000000")});
        TableTableElement tableElement = TableFactory.constructTableElement((Node)parentNode, (String)tableStyle);
        TableTableColumnElement columnElement = tableElement.newTableTableColumnElement();
        columnElement.setTableStyleNameAttribute(tableColumnStyle);
        TableTableRowElement rowElement = tableElement.newTableTableRowElement();
        TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)tableCellStyle, null, (TableTableRowElement)rowElement);
        String frameContentsStyle = stylesStyles.getParagraphStyleWithParent(stylesStyles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[0]), "extra", new OdfStylePropertiesBase[0]);
        TextPElement innerPElement = TextFactory.constructTextNode((Node)cellElement, null, (String)frameContentsStyle);
        String trafficLightImageFrameStyle = contentAutomaticStyles.getGraphicStyleWithParent(stylesStyles.getGraphicStyle(new OdfStylePropertiesBase[]{FrameFactory.constructImageFrameParentProperties((Styles)stylesStyles)}), new OdfStylePropertiesBase[]{FrameFactory.constructImageFrameProperties((Styles)contentAutomaticStyles)});
        DrawFrameElement trafficLightInnerFrame = FrameFactory.constructDrawFrameNode((Node)innerPElement, (String)trafficLightImageFrameStyle, (String)"as-char", null, null, (String)"1cm", (String)"3cm", (Integer)0);
        PlanningNotificationOrderState orderState = this.getPlanningNotificationOrderState(reportInfo);
        String path = PlanningReportPdfExporter.getImagePathForOrderState(orderState);
        try {
            ClassLoader classLoader = PlanningReportHelper.class.getClassLoader();
            URL ampelUrl = classLoader.getResource(path);
            URI ampelUri = ampelUrl.toURI();
            OdfDrawImage image = (OdfDrawImage)trafficLightInnerFrame.newDrawImageElement();
            image.setXlinkShowAttribute("embed");
            image.setXlinkActuateAttribute("onLoad");
            image.newImage(ampelUri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tableElement;
    }

    private void appendPlanningNotificationOrderReviewHistoryTable(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, PlanningNotificationReportInfo reportInfo, PlanningNotificationReportColumnSettings columnSettings, Map<Long, WorkflowNodeTemplate> idToWorkflowNodeTemplate, ResourceBundle resourceBundle) {
        String baulos;
        List resultJoins = reportInfo.getWorkflowActivityPositionResultJoins();
        if (resultJoins.size() == 0) {
            return;
        }
        String headerCellStyle = localStyles.getHeaderCellStyle();
        String headerTextStyle = localStyles.getHeaderTextStyle();
        String dataCellStyle = localStyles.getDataCellStyle();
        String dataTextStyle = localStyles.getDataTextStyle(reportInfo);
        String dataRowStyle = localStyles.getDataRowStyle();
        String internetLinkStyle = localStyles.getInternetLinkStyle();
        String captionStyle = localStyles.getHeadingTwoStyle();
        Long workflowNodeTemplateId = exportInfo.getReviewSearchModel() != null ? exportInfo.getReviewSearchModel().getWorkflowNodeTemplateId() : null;
        WorkflowNodeTemplate workflowNodeTemplate = workflowNodeTemplateId != null ? idToWorkflowNodeTemplate.get(workflowNodeTemplateId) : null;
        String workflowNodeName = workflowNodeTemplate != null ? workflowNodeTemplate.getName() : null;
        String string = baulos = exportInfo.getReviewSearchModel() != null ? exportInfo.getReviewSearchModel().getBaulos() : null;
        String caption = workflowNodeName != null && workflowNodeName.trim().length() > 0 ? (baulos != null && baulos.trim().length() > 0 ? MessageFormat.format(resourceBundle.getString("planningNotificationReportReviewPhaseCaption"), baulos, workflowNodeName) : MessageFormat.format(resourceBundle.getString("planningNotificationReportReviewBaulosPhaseCaption"), workflowNodeName)) : (baulos != null && baulos.trim().length() > 0 ? MessageFormat.format(resourceBundle.getString("planningNotificationReportReviewBaulosCaption"), baulos) : resourceBundle.getString("planningNotificationReportReviewFullCaption"));
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)captionStyle, (Integer)2);
        HashMap<String, Double> historyColumnToWidth = new HashMap<String, Double>();
        PlanningReportHelper.setColumnWidth(historyColumnToWidth, "workflowNodeName", 0.09, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowWorkflowNodeName()));
        PlanningReportHelper.setColumnWidth(historyColumnToWidth, "baulos", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowReviewBaulos()));
        PlanningReportHelper.setColumnWidth(historyColumnToWidth, "tokenInitiator", 0.24, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTokenInitiator()));
        PlanningReportHelper.setColumnWidth(historyColumnToWidth, "reviewer", 0.24, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowReviewer()));
        PlanningReportHelper.setColumnWidth(historyColumnToWidth, "issued", 0.07, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowIssued()));
        PlanningReportHelper.setColumnWidth(historyColumnToWidth, "comment", 0.16, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowReviewComment()));
        PlanningReportHelper.setColumnWidth(historyColumnToWidth, "result", 0.08, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowResult()));
        PlanningReportHelper.setColumnWidth(historyColumnToWidth, "attachment", 0.05, PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowAttachment()));
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        final Map workflowActivityIdToBaulose = reportInfo.getWorkflowActivityIdToBaulose();
        Map workflowActivityIdToAttachments = reportInfo.getWorkflowActivityIdToAttachments();
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(resultJoins, new Comparator<WorkflowActivityPositionResultJoin>(){

            @Override
            public int compare(WorkflowActivityPositionResultJoin joinOne, WorkflowActivityPositionResultJoin joinTwo) {
                List bauloseTwo;
                String baulosTwo;
                String baulosStringTwo;
                List bauloseOne = (List)workflowActivityIdToBaulose.get(joinOne.getWorkflowActivityId());
                String baulosOne = bauloseOne != null && bauloseOne.size() > 0 ? ((PlanningNotificationTextMetaInformation)bauloseOne.get(0)).getValue() : null;
                String baulosStringOne = baulosOne != null ? baulosOne : "";
                int baulosResult = collator.compare(baulosStringOne, baulosStringTwo = (baulosTwo = (bauloseTwo = (List)workflowActivityIdToBaulose.get(joinTwo.getWorkflowActivityId())) != null && bauloseTwo.size() > 0 ? ((PlanningNotificationTextMetaInformation)bauloseTwo.get(0)).getValue() : null) != null ? baulosTwo : "");
                if (baulosResult != 0) {
                    return baulosResult;
                }
                Double issuedOne = joinOne.getWorkflowActivityIssued();
                Double issuedTwo = joinTwo.getWorkflowActivityIssued();
                if (issuedOne < issuedTwo) {
                    return -1;
                }
                if (issuedOne > issuedTwo) {
                    return 1;
                }
                return 0;
            }
        });
        String tableUnderCaptionStyle = localStyles.getTableUnderCaptionStyle();
        FancyOdfTable<WorkflowActivityPositionResultJoin> historyTable = PlanningExportHelper.constructHistoryTable(resourceBundle, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, dataRowStyle, internetLinkStyle, historyColumnToWidth, workflowActivityIdToBaulose, workflowActivityIdToAttachments, true, this.utilService);
        historyTable.setTableStyle(tableUnderCaptionStyle);
        historyTable.setDataRowStyle(dataRowStyle);
        historyTable.render((Node)officeText, resultJoins, null);
    }

    private void appendPlanningNotificationOrderAttachmentCaption(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, ResourceBundle resourceBundle) {
        String captionStyle = this.constructPageBreakStyle(context, localStyles.getHeadingTwoStyle());
        String caption = resourceBundle.getString("planningNotificationReportAttachmentCaption");
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)captionStyle, (Integer)2);
    }

    private void appendPlanningNotificationOrderAttachmentTable(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, PlanningNotificationReportInfo reportInfo, List<AttachmentPageInfo> attachmentPageInfos, Map<Long, AttachmentPageInfo> attachmentIdToPageInfo, ResourceBundle resourceBundle) {
        List resultJoins = reportInfo.getWorkflowActivityPositionResultJoins();
        HashMap<Long, WorkflowActivityPositionResultJoin> workflowActivityIdToResultJoin = new HashMap<Long, WorkflowActivityPositionResultJoin>();
        for (WorkflowActivityPositionResultJoin resultJoin : resultJoins) {
            workflowActivityIdToResultJoin.put(resultJoin.getWorkflowActivityId(), resultJoin);
        }
        ArrayList<AttachmentInfo> attachmentInfos = new ArrayList<AttachmentInfo>();
        Map workflowActivityIdToAttachments = reportInfo.getWorkflowActivityIdToAttachments();
        for (Long workflowActivityId : workflowActivityIdToAttachments.keySet()) {
            WorkflowActivityPositionResultJoin resultJoin = (WorkflowActivityPositionResultJoin)workflowActivityIdToResultJoin.get(workflowActivityId);
            List attachments = (List)workflowActivityIdToAttachments.get(workflowActivityId);
            for (PlanningNotificationAttachment attachment : attachments) {
                attachmentInfos.add(new AttachmentInfo(resultJoin, attachment));
            }
        }
        Collections.sort(attachmentInfos, new Comparator<AttachmentInfo>(){

            @Override
            public int compare(AttachmentInfo attachmentOne, AttachmentInfo attachmentTwo) {
                Double issuedTwo;
                Double issuedOne = attachmentOne != null && attachmentOne.getResultJoin() != null ? attachmentOne.getResultJoin().getWorkflowActivityIssued() : null;
                Double d = issuedTwo = attachmentTwo != null && attachmentTwo.getResultJoin() != null ? attachmentTwo.getResultJoin().getWorkflowActivityIssued() : null;
                if (issuedOne == null) {
                    return -1;
                }
                if (issuedTwo == null) {
                    return 1;
                }
                return issuedOne < issuedTwo ? -1 : 1;
            }
        });
        if (attachmentInfos.size() > 0) {
            this.appendAttachmentTable(officeText, context, localStyles, exportInfo, reportInfo, attachmentInfos, attachmentPageInfos, attachmentIdToPageInfo, resourceBundle);
        }
    }

    private void appendPlanningNotificationOrderAttachments(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportInfo reportInfo) {
        List resultJoins = reportInfo.getWorkflowActivityPositionResultJoins();
        Collections.sort(resultJoins, new Comparator<WorkflowActivityPositionResultJoin>(){

            @Override
            public int compare(WorkflowActivityPositionResultJoin joinOne, WorkflowActivityPositionResultJoin joinTwo) {
                Double issuedOne = joinOne.getWorkflowActivityIssued();
                Double issuedTwo = joinTwo.getWorkflowActivityIssued();
                if (issuedOne == null) {
                    return -1;
                }
                if (issuedTwo == null) {
                    return 1;
                }
                return issuedOne < issuedTwo ? -1 : 1;
            }
        });
        Map workflowActivityIdToAttachments = reportInfo.getWorkflowActivityIdToAttachments();
        for (WorkflowActivityPositionResultJoin resultJoin : resultJoins) {
            Long workflowActivityId = resultJoin.getWorkflowActivityId();
            List attachments = (List)workflowActivityIdToAttachments.get(workflowActivityId);
            if (attachments == null) continue;
            for (PlanningNotificationAttachment attachment : attachments) {
                String relPath = attachment.getFileName();
                Path path = FileSystems.getDefault().getPath(this.planningNotificationAttachmentRepository, relPath);
                Styles stylesOfficeStyles = context.getStylesOfficeStyles();
                String topStyle = stylesOfficeStyles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[0]);
                String textStyle = stylesOfficeStyles.getParagraphStyleWithParent(topStyle, new OdfStylePropertiesBase[]{stylesOfficeStyles.constructTextPropertiesWithFontSize("10pt"), stylesOfficeStyles.constructParagraphPropertiesWithMargin(null, null, "1.0cm", null)});
                TextFactory.constructTextNode((Node)officeText, (String)path.toString(), (String)textStyle);
            }
        }
    }

    private void appendAttachmentTable(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo, PlanningNotificationReportInfo reportInfo, List<AttachmentInfo> attachmentInfos, List<AttachmentPageInfo> attachmentPageInfos, Map<Long, AttachmentPageInfo> attachmentIdToPageInfo, ResourceBundle resourceBundle) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String tableStyle = localStyles.getTableUnderCaptionStyle();
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "none")});
        String dataTextStyle = localStyles.getDataTextStyle(reportInfo);
        String internetLinkStyle = localStyles.getInternetLinkStyle();
        Styles styles = context.getContentAutomaticStyles();
        String leftColumnWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, "1250*", "1677*");
        String rightColumnWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, "8750*", "8323*");
        String leftColumnStyle = styles.getTableColumnStyle(new OdfStylePropertiesBase[]{styles.constructTableColumnPropertiesWithRelativeWidth(leftColumnWidth)});
        String rightColumnStyle = styles.getTableColumnStyle(new OdfStylePropertiesBase[]{styles.constructTableColumnPropertiesWithRelativeWidth(rightColumnWidth)});
        TableTableElement tableElement = officeText.newTableTableElement();
        tableElement.setStyleName(tableStyle);
        TableTableColumnElement leftColumnElement = tableElement.newTableTableColumnElement();
        leftColumnElement.setStyleName(leftColumnStyle);
        TableTableColumnElement rightColumnElement = tableElement.newTableTableColumnElement();
        rightColumnElement.setStyleName(rightColumnStyle);
        TableTableRowElement upperRow = tableElement.newTableTableRowElement();
        TableTableCellElement upperCell = TableFactory.appendTextStyledCell((String)dataTextStyle, (TableTableRowElement)upperRow, (String[])new String[]{reportInfo.getReportJoin().getPlanningNotificationTitle()});
        upperCell.setStyleName(dataCellStyle);
        upperCell.setTableNumberColumnsSpannedAttribute(Integer.valueOf(2));
        upperRow.newTableCoveredTableCellElement(0.0, null);
        TableTableRowElement lowerRow = tableElement.newTableTableRowElement();
        ArrayList<PlanningNotificationAttachment> attachments = new ArrayList<PlanningNotificationAttachment>();
        for (AttachmentInfo attachmentInfo : attachmentInfos) {
            attachments.add(attachmentInfo.getAttachment());
        }
        String anchor = PLANNING_NOTIFICATION_ORDER_ANCHOR_PREFIX + reportInfo.getReportJoin().getPlanningNotificationOrderWorkflowEntityId();
        PlanningExportHelper.constructSerialNumberLinkCell(lowerRow, dataTextStyle, dataCellStyle, internetLinkStyle, anchor, reportInfo);
        PlanningExportHelper.constructAttachmentLinkCell(lowerRow, dataTextStyle, dataCellStyle, internetLinkStyle, attachments);
    }

    private void appendCompleteOrderTableToPdf(OfficeTextElement officeText, OdfContext context, PlanningReportLocalStyles localStyles, List<MetaTag> metaTags, Map<Long, MetaTag> idToMetaTag, List<PlanningNotificationReportInfo> reportInfos, PlanningNotificationReportExportInfo exportInfo, ResourceBundle resourceBundle) {
        List columnSortSpecs = ColumnSortSpec.getFromClient((List)exportInfo.getSortSpecs());
        PlanningReportHelper.convertReportColumnSortSpecsFromClientToServer(columnSortSpecs, idToMetaTag);
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String captionStyle = this.constructPageBreakStyle(context, localStyles.getHeadingTwoStyle());
        String caption = resourceBundle.getString("planningNotificationReportPdfListCaption");
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)captionStyle, (Integer)2);
        PlanningNotificationReportColumnSettings columnSettings = exportInfo.getColumnSettings();
        boolean duplicateRows = PlanningReportHelper.duplicateRows(columnSettings);
        List<FlatReportInfo> flatReportInfos = PlanningReportHelper.getFlatReportInfos(this.planningNotificationService, exportInfo, this.actionDAO, duplicateRows);
        List columns = PlanningReportHelper.constructFlatReportColumns(localStyles, metaTags, columnSettings, false, this.utilService, contentAutomaticStyles);
        Map<String, Double> columnWidths = exportInfo.getColumnToWidth();
        if (columnWidths == null) {
            columnWidths = PlanningReportHelper.getFlatReportColumnWidths(metaTags, columnSettings);
        } else {
            this.addReviewColumnWidths(exportInfo, metaTags, columnWidths, columnSettings);
        }
        Double tableWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, 23.9, 15.2);
        PlanningReportHelper.ensureAbsoluteColumnWidth(columnWidths, PDF_LIST_MIN_ABS_COLUMN_WIDTH, tableWidth);
        FancyOdfTable table = PlanningReportPdfExporter.constructFancyTable(contentAutomaticStyles, localStyles, tableWidth, columns, columnWidths);
        String tablePropertiesWidth = PlanningReportPdfExporter.getLayoutDependentValue(exportInfo, "23.9cm", "15.2cm");
        StyleTablePropertiesElement tableProperties = contentAutomaticStyles.constructTableProperties(tablePropertiesWidth, null, "margins", null);
        tableProperties.setFoMarginTopAttribute("1cm");
        String tableStyle = contentAutomaticStyles.getTableStyle(new OdfStylePropertiesBase[]{tableProperties});
        table.setTableStyle(tableStyle);
        table.render((Node)officeText, flatReportInfos, columnSortSpecs, true);
    }

    private static Double getOrZero(Boolean show, Double d) {
        return show != null && show == true && d != null ? d : 0.0;
    }

    private static void setIfVisible(Map<String, Double> columnWidths, String columnName, Boolean show, Double width) {
        if (show != null && show.booleanValue() && columnWidths.get(columnName) == null) {
            columnWidths.put(columnName, width);
        }
    }

    private void addReviewColumnWidths(PlanningNotificationReportExportInfo exportInfo, List<MetaTag> metaTags, Map<String, Double> columnWidths, PlanningNotificationReportColumnSettings columnSettings) {
        int nonReviewColumnCount = (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowAuthorizedInspector()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowDocumentPage()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowDocumentPosition()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowEnvironmentallyRelevant()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowInvalidated()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowNotificationComment()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowOrderComment()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowPersonInCharge()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowProject()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowReference()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSerialNumber()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSource()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowState()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDuty()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyExpired()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyFrom()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyInterval()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyLeadTime()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyTo()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSubjectArea()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSubmitAuthority()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTags()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowText()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTitle()) ? 1 : 0) + (PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowWorkflowNode()) ? 1 : 0);
        if (columnSettings.getMetaTagIdToShow() != null) {
            Map metaTagIdToShow = columnSettings.getMetaTagIdToShow();
            for (Long metaTagId : metaTagIdToShow.keySet()) {
                if (metaTagIdToShow.get(metaTagId) == null) continue;
                nonReviewColumnCount += (Boolean)metaTagIdToShow.get(metaTagId) == true ? 1 : 0;
            }
        }
        Double nonReviewTotalWidth = PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowAuthorizedInspector()), columnWidths.get("authorizedInspector")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowDocumentPage()), columnWidths.get("documentPage")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowDocumentPosition()), columnWidths.get("documentPosition")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowEnvironmentallyRelevant()), columnWidths.get("environmentallyRelevant")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowInvalidated()), columnWidths.get("invalidated")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowNotificationComment()), columnWidths.get("notificationComment")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowOrderComment()), columnWidths.get("orderComment")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowPersonInCharge()), columnWidths.get("personInCharge")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowProject()), columnWidths.get("project")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowReference()), columnWidths.get("reference")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSerialNumber()), columnWidths.get("serialNumber")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSource()), columnWidths.get("source")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowState()), columnWidths.get("state")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDuty()), columnWidths.get("statutoryDuty")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyExpired()), columnWidths.get("statutoryDutyExpired")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyFrom()), columnWidths.get("statutoryDutyFrom")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyInterval()), columnWidths.get("statutoryDutyInterval")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyLeadTime()), columnWidths.get("statutoryDutyLeadTime")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowStatutoryDutyTo()), columnWidths.get("statutoryDutyTo")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSubjectArea()), columnWidths.get("subjectArea")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowSubmitAuthority()), columnWidths.get("submitAuthority")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTags()), columnWidths.get("tag")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowText()), columnWidths.get("text")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowTitle()), columnWidths.get("title")) + PlanningReportPdfExporter.getOrZero(PlanningReportPdfExporter.doShow(exportInfo, columnSettings.getShowWorkflowNode()), columnWidths.get("workflowNode"));
        if (columnSettings.getMetaTagIdToShow() != null) {
            for (MetaTag metaTag : metaTags) {
                String cssClass = metaTag.getCssClass();
                nonReviewTotalWidth = nonReviewTotalWidth + PlanningReportPdfExporter.getOrZero((Boolean)columnSettings.getMetaTagIdToShow().get(cssClass), columnWidths.get(cssClass));
            }
        }
        Double averageNonReviewWidth = nonReviewTotalWidth > 0.0 && nonReviewColumnCount > 0 ? nonReviewTotalWidth / (double)nonReviewColumnCount : 1.0;
        PlanningReportPdfExporter.setIfVisible(columnWidths, "workflowNodeName", columnSettings.getShowWorkflowNodeName(), averageNonReviewWidth);
        PlanningReportPdfExporter.setIfVisible(columnWidths, "reviewBaulos", columnSettings.getShowReviewBaulos(), averageNonReviewWidth);
        PlanningReportPdfExporter.setIfVisible(columnWidths, "tokenInitiator", columnSettings.getShowTokenInitiator(), averageNonReviewWidth);
        PlanningReportPdfExporter.setIfVisible(columnWidths, "reviewer", columnSettings.getShowReviewer(), averageNonReviewWidth);
        PlanningReportPdfExporter.setIfVisible(columnWidths, "issued", columnSettings.getShowIssued(), averageNonReviewWidth);
        PlanningReportPdfExporter.setIfVisible(columnWidths, "reviewComment", columnSettings.getShowReviewComment(), averageNonReviewWidth);
        PlanningReportPdfExporter.setIfVisible(columnWidths, "result", columnSettings.getShowResult(), averageNonReviewWidth);
        PlanningReportPdfExporter.setIfVisible(columnWidths, "attachment", columnSettings.getShowAttachment(), averageNonReviewWidth);
    }

    private static <T> FancyOdfTable<T> constructFancyTable(Styles styles, PlanningReportLocalStyles localStyles, Double width, List<FancyOdfTableColumn<T>> columns, Map<String, Double> relativeColumnWidths) {
        String headerCellStyle = localStyles.getHeaderCellStyle();
        String headerTextStyle = localStyles.getHeaderTextStyle();
        String dataCellStyle = localStyles.getDataCellStyle();
        String dataTextStyle = localStyles.getNormalDataTextStyle();
        String dataRowStyle = localStyles.getDataRowStyle();
        FancyOdfTable table = new FancyOdfTable(styles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, width, relativeColumnWidths, columns);
        table.setDataRowStyle(dataRowStyle);
        return table;
    }

    private static String getImagePathForOrderState(PlanningNotificationOrderState orderState) {
        if (orderState == PlanningNotificationOrderState.RED) {
            return "export/ampeln/rot.svg";
        }
        if (orderState == PlanningNotificationOrderState.YELLOW) {
            return "export/ampeln/orange.svg";
        }
        if (orderState == PlanningNotificationOrderState.GREEN) {
            return "export/ampeln/gruen.svg";
        }
        throw new IllegalArgumentException("Unsupported PlanningNotificationOrderState: " + (Object)((Object)orderState));
    }

    private static boolean doShow(PlanningNotificationReportExportInfo exportInfo, Boolean show) {
        return exportInfo.getType() == PlanningNotificationReportType.ALL || show != null && show == true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAttachmentPageInfos(List<PlanningNotificationReportInfo> reportInfos, List<AttachmentPageInfo> attachmentPageInfos, Map<Long, AttachmentPageInfo> attachmentIdToPageInfo) throws Exception {
        for (PlanningNotificationReportInfo reportInfo : reportInfos) {
            List resultJoins = reportInfo.getWorkflowActivityPositionResultJoins();
            Collections.sort(resultJoins, new Comparator<WorkflowActivityPositionResultJoin>(){

                @Override
                public int compare(WorkflowActivityPositionResultJoin joinOne, WorkflowActivityPositionResultJoin joinTwo) {
                    Double issuedOne = joinOne.getWorkflowActivityIssued();
                    Double issuedTwo = joinTwo.getWorkflowActivityIssued();
                    if (issuedOne == null) {
                        return -1;
                    }
                    if (issuedTwo == null) {
                        return 1;
                    }
                    return issuedOne < issuedTwo ? -1 : 1;
                }
            });
            Map workflowActivityIdToAttachments = reportInfo.getWorkflowActivityIdToAttachments();
            for (WorkflowActivityPositionResultJoin resultJoin : resultJoins) {
                Long workflowActivityId = resultJoin.getWorkflowActivityId();
                List attachments = (List)workflowActivityIdToAttachments.get(workflowActivityId);
                if (attachments == null) continue;
                for (PlanningNotificationAttachment attachment : attachments) {
                    attachmentPageInfos.add(new AttachmentPageInfo(attachment));
                }
            }
        }
        for (AttachmentPageInfo attachmentPageInfo : attachmentPageInfos) {
            PlanningNotificationAttachment attachment = attachmentPageInfo.getAttachment();
            String relPath = attachment.getFileName();
            Path path = FileSystems.getDefault().getPath(this.planningNotificationAttachmentRepository, relPath);
            Integer numberOfPages = null;
            try (PDDocument attachmentDocument = null;){
                attachmentDocument = PDDocument.load((File)path.toFile());
                numberOfPages = attachmentDocument.getNumberOfPages();
            }
            attachmentPageInfo.setNumberOfPages(numberOfPages);
        }
        for (AttachmentPageInfo attachmentPageInfo : attachmentPageInfos) {
            Long attachmentId = attachmentPageInfo.getAttachment().getId();
            attachmentIdToPageInfo.put(attachmentId, attachmentPageInfo);
        }
    }

    private void appendPlanningNotificationOrderAttachments(PDDocument pdDocument, PlanningNotificationReportExportInfo exportInfo, List<PlanningNotificationReportInfo> reportInfos, List<AttachmentPageInfo> attachmentPageInfos, Map<Long, AttachmentPageInfo> attachmentIdToPageInfo, ResourceBundle resourceBundle) throws IOException {
        int currPageNumber = pdDocument.getNumberOfPages();
        for (AttachmentPageInfo attachmentPageInfo : attachmentPageInfos) {
            attachmentPageInfo.setPagePosition(currPageNumber);
            Integer numberOfPages = attachmentPageInfo.getNumberOfPages();
            currPageNumber += numberOfPages != null ? numberOfPages : 0;
        }
        List pages = pdDocument.getDocumentCatalog().getAllPages();
        for (PDPage page : pages) {
            List annotations = page.getAnnotations();
            for (PDAnnotation annotation : annotations) {
                PDActionURI actionURI;
                String uri;
                PDAnnotationLink link;
                PDAction action;
                if (!(annotation instanceof PDAnnotationLink) || !((action = (link = (PDAnnotationLink)annotation).getAction()) instanceof PDActionURI) || !(uri = (actionURI = (PDActionURI)action).getURI()).startsWith("attachment://nae0uic3Xu2uoD5x/")) continue;
                String attachmentIdString = uri.substring("attachment://nae0uic3Xu2uoD5x/".length());
                Long attachmentId = Long.valueOf(attachmentIdString);
                AttachmentPageInfo pageInfo = attachmentIdToPageInfo.get(attachmentId);
                if (log.isDebugEnabled()) {
                    log.info("uri: " + uri + " annotationName: " + annotation.getAnnotationName());
                    log.info("attachmentId: " + attachmentId + " pageInfo.getAttachment().getOriginalName: " + pageInfo.getAttachment().getOriginalName() + " pageInfo.getNumberOfPages: " + pageInfo.getNumberOfPages() + " pageInfo.getPagePosition: " + pageInfo.getPagePosition());
                }
                if (pageInfo == null) continue;
                PDPageFitWidthDestination destination = new PDPageFitWidthDestination();
                if (log.isDebugEnabled()) {
                    log.info("pageInfo.getPagePosition(): " + pageInfo.getPagePosition() + " pages.size(): " + pages.size());
                }
                if (pageInfo.getPagePosition() > pages.size()) {
                    log.error("pageInfo.getPagePosition() > pages.size(): " + pageInfo.getPagePosition() + ">" + pages.size() + " - will continue despite!");
                }
                PDPage targetPage = (PDPage)pages.get(pages.size() - 1);
                destination.setPage(targetPage);
                PDActionGoTo newAction = new PDActionGoTo();
                newAction.setDestination((PDDestination)destination);
                link.setAction((PDAction)newAction);
            }
        }
        for (AttachmentPageInfo attachmentPageInfo : attachmentPageInfos) {
            PlanningNotificationAttachment attachment = attachmentPageInfo.getAttachment();
            String relPath = attachment.getFileName();
            if (relPath != null) {
                relPath = relPath.replace("\\", File.separator);
                Path path = FileSystems.getDefault().getPath(this.planningNotificationAttachmentRepository, relPath);
                this.appendAttachment(pdDocument, path);
                continue;
            }
            log.warn("Ignoring attachment [" + attachment.getId() + "] because it has an empty fileName");
        }
        String string = PlanningReportHelper.formatUtcMillisAsYearToDay(System.currentTimeMillis());
        PlanningNotificationReportType reportType = exportInfo.getType();
        String captionI18nString = null;
        if (reportType == PlanningNotificationReportType.ALL) {
            captionI18nString = "planningNotificationReportAllCaption";
        } else if (reportType == PlanningNotificationReportType.INDIVIDUAL) {
            captionI18nString = "planningNotificationReportIndividualCaption";
        } else {
            throw new IllegalArgumentException("Unsupported report type: [" + reportType + "]");
        }
        PDDocumentInformation documentInfo = pdDocument.getDocumentInformation();
        documentInfo.setTitle(MessageFormat.format(resourceBundle.getString(captionI18nString), string));
        pdDocument.setDocumentInformation(documentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAttachment(PDDocument pdDocument, Path path) throws IOException {
        try (PDDocument attachmentDocument = null;){
            attachmentDocument = PDDocument.load((File)path.toFile());
            if (log.isDebugEnabled()) {
                log.info("trying to merge attachment with documentId = " + attachmentDocument.getDocumentId());
            }
            PDFMergerUtility mergerUtility = new PDFMergerUtility();
            mergerUtility.appendDocument(pdDocument, attachmentDocument);
        }
    }

    static {
        ORDER_DETAIL_MIN_ABS_COLUMN_WIDTH.put("text", 5.0);
        PDF_LIST_MIN_ABS_COLUMN_WIDTH.put("text", 5.0);
    }

    private static enum PlanningNotificationOrderState {
        RED(0),
        YELLOW(1),
        GREEN(2);

        private int order;

        private PlanningNotificationOrderState(int order) {
            this.order = order;
        }

        private int getOrder() {
            return this.order;
        }
    }

    private static class AttachmentInfo {
        private WorkflowActivityPositionResultJoin resultJoin;
        private PlanningNotificationAttachment attachment;

        private AttachmentInfo(WorkflowActivityPositionResultJoin resultJoin, PlanningNotificationAttachment attachment) {
            this.resultJoin = resultJoin;
            this.attachment = attachment;
        }

        private WorkflowActivityPositionResultJoin getResultJoin() {
            return this.resultJoin;
        }

        private PlanningNotificationAttachment getAttachment() {
            return this.attachment;
        }
    }

    private static class AttachmentPageInfo {
        private PlanningNotificationAttachment attachment;
        private Integer numberOfPages;
        private Integer pagePosition;

        private AttachmentPageInfo(PlanningNotificationAttachment attachment) {
            this.attachment = attachment;
        }

        public PlanningNotificationAttachment getAttachment() {
            return this.attachment;
        }

        public void setAttachment(PlanningNotificationAttachment attachment) {
            this.attachment = attachment;
        }

        public Integer getNumberOfPages() {
            return this.numberOfPages;
        }

        public void setNumberOfPages(Integer numberOfPages) {
            this.numberOfPages = numberOfPages;
        }

        public Integer getPagePosition() {
            return this.pagePosition;
        }

        public void setPagePosition(Integer pagePosition) {
            this.pagePosition = pagePosition;
        }
    }
}

