/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.compositeDto.MasterDataInfo;
import at.cdes.api.compositeDto.PlanDeliverJoinCompositeDto;
import at.cdes.api.compositeDto.PlanDeliverSaveResult;
import at.cdes.api.compositeDto.PlanDeliverSearchData;
import at.cdes.api.dto.ActionInfo;
import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentDateHistoryPart;
import at.cdes.api.dto.DocumentList;
import at.cdes.api.dto.DocumentListRelease;
import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentNumberPartGroup;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PlanDeliverSearchModel;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.Signature;
import at.cdes.api.guiService.ContextService;
import at.cdes.api.guiService.PlanDeliverService;
import at.cdes.api.guiService.TaskService;
import at.cdes.api.joinDto.DocumentHistoryJoin;
import at.cdes.api.joinDto.DocumentListReleaseVersion;
import at.cdes.api.joinDto.DocumentNumberUniqueJoin;
import at.cdes.api.joinDto.PlanDeliverJoinDto;
import at.cdes.api.joinDto.PlanDeliverNewJoin;
import at.cdes.api.joinDto.PlanDeliverSaveJoin;
import at.cdes.api.joinDto.PlanDeliverSearchJoin;
import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.api.joinDto.TaskWithEmailJoin;
import at.cdes.api.result.ResultSummary;
import at.cdes.api.sec.SignatureCalculator;
import at.cdes.api.voc.DocumentDateHistoryModType;
import at.cdes.api.voc.DocumentModifiedState;
import at.cdes.api.voc.DocumentNumberUniqueness;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.EntityVoc;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentDateHistoryPartDAO;
import at.cdes.impl.dao.DocumentListDAO;
import at.cdes.impl.dao.DocumentListReleaseDAO;
import at.cdes.impl.dao.DocumentReleaseDAO;
import at.cdes.impl.dao.DocumentTaskDAO;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.ObjectListReleaseDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.OrderAddressDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PlottPropertiesDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ReviewCycleEntryTaskDAO;
import at.cdes.impl.dao.SignatureDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.dao.TaskEmailSnippetDAO;
import at.cdes.impl.dao.unionComponent.PlanDeliverNewComponent;
import at.cdes.impl.dao.unionComponent.PlanDeliverSaveComponent;
import at.cdes.impl.dao.unionComponent.PlanDeliverSearchComponent;
import at.cdes.impl.digest.DocumentDigester;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.BatchedDAOGetter;
import at.cdes.impl.util.CodeHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.holiday.HolidayCalculator;
import at.cdes.impl.util.holiday.HolidayCalculatorFactory;
import at.cdes.impl.util.i18n.I18nHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanDeliverServiceImpl
implements PlanDeliverService {
    private static final Logger log = LoggerFactory.getLogger(PlanDeliverServiceImpl.class);
    private ActionDAO actionDAO;
    private CertificateDAO certificateDAO;
    private ContextService contextService;
    private DocumentDAO documentDAO;
    private DocumentDateHistoryPartDAO documentDateHistoryPartDAO;
    private DocumentDigester documentDigester;
    private DocumentListDAO documentListDAO;
    private DocumentListReleaseDAO documentListReleaseDAO;
    private DocumentReleaseDAO documentReleaseDAO;
    private DocumentTaskDAO documentTaskDAO;
    private EmailSnippetDAO emailSnippetDAO;
    private FutureEmailDAO futureEmailDAO;
    private ObjectListReleaseDAO objectListReleaseDAO;
    private OrderAddressDAO orderAddressDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private PlottPropertiesDAO plotPropertiesDAO;
    private ProjectDAO projectDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO;
    private SignatureCalculator signatureCalculator;
    private SignatureDAO signatureDAO;
    private int sqlQueryBatchSize;
    private TaskDAO taskDAO;
    private TaskEmailSnippetDAO taskEmailSnippetDAO;
    private TaskService taskService;
    private HolidayCalculatorFactory holidayCalculatorFactory;
    private Boolean enableCustomerLogo;
    private String costumerLabel;
    private Boolean enableAutoInitSearch;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentDateHistoryPartDAO(DocumentDateHistoryPartDAO documentDateHistoryPartDAO) {
        this.documentDateHistoryPartDAO = documentDateHistoryPartDAO;
    }

    public void setDocumentDigester(DocumentDigester documentDigester) {
        this.documentDigester = documentDigester;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setDocumentListReleaseDAO(DocumentListReleaseDAO documentListReleaseDAO) {
        this.documentListReleaseDAO = documentListReleaseDAO;
    }

    public void setDocumentReleaseDAO(DocumentReleaseDAO documentReleaseDAO) {
        this.documentReleaseDAO = documentReleaseDAO;
    }

    public void setDocumentTaskDAO(DocumentTaskDAO documentTaskDAO) {
        this.documentTaskDAO = documentTaskDAO;
    }

    public void setEmailSnippetDAO(EmailSnippetDAO emailSnippetDAO) {
        this.emailSnippetDAO = emailSnippetDAO;
    }

    public void setFutureEmailDAO(FutureEmailDAO futureEmailDAO) {
        this.futureEmailDAO = futureEmailDAO;
    }

    public void setObjectListReleaseDAO(ObjectListReleaseDAO objectListReleaseDAO) {
        this.objectListReleaseDAO = objectListReleaseDAO;
    }

    public void setOrderAddressDAO(OrderAddressDAO orderAddressDAO) {
        this.orderAddressDAO = orderAddressDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPlottPropertiesDAO(PlottPropertiesDAO plotPropertiesDAO) {
        this.plotPropertiesDAO = plotPropertiesDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setReviewCycleEntryTaskDAO(ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO) {
        this.reviewCycleEntryTaskDAO = reviewCycleEntryTaskDAO;
    }

    public void setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setSqlQueryBatchSize(int sqlQueryBatchSize) {
        this.sqlQueryBatchSize = sqlQueryBatchSize;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public void setTaskEmailSnippetDAO(TaskEmailSnippetDAO taskEmailSnippetDAO) {
        this.taskEmailSnippetDAO = taskEmailSnippetDAO;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setHolidayCalculatorFactory(HolidayCalculatorFactory holidayCalculatorFactory) {
        this.holidayCalculatorFactory = holidayCalculatorFactory;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public void setEnableAutoInitSearch(Boolean enableAutoInitSearch) {
        this.enableAutoInitSearch = enableAutoInitSearch;
    }

    public List<DocumentListReleaseVersion> getDocumentListReleaseVersions(Long organisationPersonId, Long subProjectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        return this.documentListReleaseDAO.getDocumentListReleaseVersions(subProjectId);
    }

    public PlanDeliverSearchData getPlanDeliverSearchData(Long organisationPersonId, Long subProjectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<PlanDeliverSearchJoin> searchJoins = this.documentListReleaseDAO.getPlanDeliverSearchJoin(subProjectId);
        ArrayList<PlanDeliverSearchJoin> documentListReleaseVersions = new ArrayList<PlanDeliverSearchJoin>();
        ArrayList<PlanDeliverSearchJoin> persons = new ArrayList<PlanDeliverSearchJoin>();
        HashMap<Long, ObjectRelease> objectIdToObject = new HashMap<Long, ObjectRelease>();
        HashMap<Long, ObjectType> objectTypeIdToObjectType = new HashMap<Long, ObjectType>();
        ArrayList<ObjectPlannerRelease> objectPlanners = new ArrayList<ObjectPlannerRelease>();
        ArrayList<CdesRole> roles = new ArrayList<CdesRole>();
        for (PlanDeliverSearchJoin searchJoin : searchJoins) {
            int component = searchJoin.getUnionClause();
            if (component == PlanDeliverSearchComponent.DOCUMENT_LIST_RELEASE_VERSION.getValue()) {
                documentListReleaseVersions.add(searchJoin);
                continue;
            }
            if (component == PlanDeliverSearchComponent.OBJECT_PLANNER_POSITION_PERSON.getValue()) {
                persons.add(searchJoin);
                continue;
            }
            if (component == PlanDeliverSearchComponent.OBJECT_PLANNER_PERSON.getValue()) {
                persons.add(searchJoin);
                continue;
            }
            if (component == PlanDeliverSearchComponent.OBJECT_PLANNER.getValue()) {
                objectIdToObject.put(searchJoin.getObjectReleaseObjectId(), searchJoin.getObjectRelease());
                if (searchJoin.getObjectTypeId() != null) {
                    objectTypeIdToObjectType.put(searchJoin.getObjectTypeId(), searchJoin.getObjectType());
                }
                objectPlanners.add(searchJoin.getObjectPlannerRelease());
                continue;
            }
            if (component == PlanDeliverSearchComponent.CDES_ROLE.getValue()) {
                roles.add(searchJoin.getCdesRole());
                continue;
            }
            throw new IllegalArgumentException("Detected illegal join component: " + component + "; please check wether you have to improve getPlanDeliverSearchData.");
        }
        ArrayList objects = new ArrayList();
        objects.addAll(objectIdToObject.values());
        int numberOfObjectListReleases = this.objectListReleaseDAO.getCountBySubProject(subProjectId);
        List<String> contentLocales = I18nHelper.getContentLocales(this.projectDAO, subProjectId);
        PlanDeliverSearchData searchData = new PlanDeliverSearchData();
        searchData.setEnableAutoInitSearch(this.enableAutoInitSearch.booleanValue());
        searchData.setDocumentListReleaseVersions(documentListReleaseVersions);
        searchData.setPersons(persons);
        searchData.setObjects(objects);
        searchData.setObjectTypeIdToObjectType(objectTypeIdToObjectType);
        searchData.setObjectPlanners(objectPlanners);
        searchData.setNumberOfObjectListReleases(numberOfObjectListReleases);
        searchData.setContentLocales(contentLocales);
        searchData.setCdesRoles(roles);
        return searchData;
    }

    public List<String> getPlanDeliverReleaseData(Long subProjectId) {
        List<String> contentLocales = I18nHelper.getContentLocales(this.projectDAO, subProjectId);
        return contentLocales;
    }

    public PlanDeliverJoinCompositeDto getPlanDeliverUnreleasedJoin(PlanDeliverSearchModel searchModel) {
        return this.getPlanDeliverJoin(searchModel, false);
    }

    public PlanDeliverJoinCompositeDto getPlanDeliverReleasedJoin(PlanDeliverSearchModel searchModel) {
        return this.getPlanDeliverJoin(searchModel, true);
    }

    /*
     * WARNING - void declaration
     */
    private PlanDeliverJoinCompositeDto getPlanDeliverJoin(PlanDeliverSearchModel searchModel, boolean released) {
        List<Object> planDeliverJoinDtos;
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Long projectId = searchModel.getProjectId();
        Long subProjectId = searchModel.getSubProjectId();
        long beforeMillis = System.currentTimeMillis();
        Map<Action, ActionInfo> allowedProjectActions = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, Action.PLAN_DELIVER_CATALOGUE_OVERVIEW, Action.SHOW_OBJECT_PLANNER, Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES_PROJ_CONT);
        if (log.isDebugEnabled()) {
            log.debug("Fetched " + allowedProjectActions.size() + " allowed project actions in " + (System.currentTimeMillis() - beforeMillis) + "ms");
        }
        beforeMillis = System.currentTimeMillis();
        Map<Long, Set<Action>> allowedObjectPlannerActions = this.actionDAO.getObjectPlannerActionsForSubProject(organisationPersonId, subProjectId, Action.SHOW_OBJECT_PLANNER_OP_CONTEXT, Action.EDIT_PLAN_DELIVER_CATALOGUE, Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES, Action.EDIT_PLAN_DELIVER_CATALOGUE_START_DATE, Action.EDIT_PLAN_DELIVER_CATALOGUE_END_DATE, Action.UPLOAD_DOCUMENT, Action.SUPER_ADMIN_RIGHT);
        if (log.isDebugEnabled()) {
            log.debug("Fetched allowed actions for " + allowedObjectPlannerActions.size() + " ObjectPlanners in " + (System.currentTimeMillis() - beforeMillis) + "ms");
        }
        if (!allowedProjectActions.containsKey(Action.PLAN_DELIVER_CATALOGUE_OVERVIEW)) {
            planDeliverJoinDtos = new ArrayList();
        } else {
            beforeMillis = System.currentTimeMillis();
            planDeliverJoinDtos = released ? this.documentDAO.getPlanDeliverReleasedJoin(searchModel) : this.documentDAO.getPlanDeliverUnreleasedJoin(searchModel);
            if (log.isDebugEnabled()) {
                log.debug("Fetched planDeliverJoinDtos in " + (System.currentTimeMillis() - beforeMillis) + "ms");
            }
        }
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinBySubProject(subProjectId);
        String projectLocale = I18nHelper.getProjectLocale(localisationJoin);
        List<String> contentLocales = I18nHelper.getContentLocales(localisationJoin);
        for (Object planDeliverJoin : planDeliverJoinDtos) {
            void var16_15;
            String string = planDeliverJoin.getDocumentContent();
            if (contentLocales != null || string != null && string.startsWith("{")) {
                String string2 = I18nHelper.convertDatabaseToJs(string, projectLocale, contentLocales);
            }
            planDeliverJoin.setDocumentContent((String)var16_15);
        }
        ArrayList<PlanDeliverJoinDto> filteredPlanDeliverJoinDtos = new ArrayList<PlanDeliverJoinDto>();
        for (PlanDeliverJoinDto planDeliverJoinDto : planDeliverJoinDtos) {
            if (allowedProjectActions.containsKey(Action.SHOW_OBJECT_PLANNER)) {
                filteredPlanDeliverJoinDtos.add(planDeliverJoinDto);
                if (!log.isDebugEnabled()) continue;
                log.debug("Granted: Document [" + planDeliverJoinDto.getDocumentId() + "] for objectPlanner [" + planDeliverJoinDto.getObjectPlannerId() + "] due to action [showObjectPlanner]");
                continue;
            }
            Long objectPlannerId = planDeliverJoinDto.getObjectPlannerId();
            if (allowedObjectPlannerActions.containsKey(objectPlannerId) && allowedObjectPlannerActions.get(objectPlannerId).contains(Action.SHOW_OBJECT_PLANNER_OP_CONTEXT)) {
                filteredPlanDeliverJoinDtos.add(planDeliverJoinDto);
                if (!log.isDebugEnabled()) continue;
                log.debug("Granted: Document [" + planDeliverJoinDto.getDocumentId() + "] for objectPlanner [" + planDeliverJoinDto.getObjectPlannerId() + "] due to action [showObjectPlannerOPContext]");
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Filtered out document [" + planDeliverJoinDto.getDocumentId() + "] for objectPlanner [" + planDeliverJoinDto.getObjectPlannerId() + "] for security reasons");
        }
        HashMap documentIdToHistoryItemMap = new HashMap();
        HashMap<Long, PlanDeliverJoinDto> hashMap = new HashMap<Long, PlanDeliverJoinDto>();
        List<ProjectParticipation> ownParticipations = this.projectParticipationDAO.getParticipationsByOrganisationPerson(organisationPersonId);
        HashSet<Long> ownParticipationIds = new HashSet<Long>();
        for (ProjectParticipation projectParticipation : ownParticipations) {
            ownParticipationIds.add(projectParticipation.getId());
        }
        for (PlanDeliverJoinDto planDeliverJoinDto : filteredPlanDeliverJoinDtos) {
            Map historyItemMap;
            boolean firstItem;
            Long documentId = planDeliverJoinDto.getDocumentId();
            boolean bl = firstItem = !documentIdToHistoryItemMap.containsKey(documentId);
            if (firstItem) {
                documentIdToHistoryItemMap.put(documentId, new HashMap());
            }
            if (!(historyItemMap = (Map)documentIdToHistoryItemMap.get(documentId)).containsKey(planDeliverJoinDto.getDocumentDateHistoryPartId())) {
                DocumentHistoryJoin historyItem = new DocumentHistoryJoin();
                historyItem.setDocumentDateHistoryPart(planDeliverJoinDto.getDocumentDateHistoryPart());
                historyItem.setPerson(planDeliverJoinDto.getHistoryPerson());
                historyItemMap.put(planDeliverJoinDto.getDocumentDateHistoryPartId(), historyItem);
            }
            if (!firstItem) continue;
            planDeliverJoinDto.setDocumentDateHistoryPartNull();
            planDeliverJoinDto.setHistoryPersonNull();
            boolean lastVersionDeleted = planDeliverJoinDto.getLastVersionStatus() != null && planDeliverJoinDto.getLastVersionStatus().intValue() == DocumentVersionStatus.DELETED.getValue();
            planDeliverJoinDto.setDerivedInfoLastVersionDeleted(Boolean.valueOf(lastVersionDeleted));
            if (planDeliverJoinDto.getLastVersionStatus() != null && planDeliverJoinDto.getLastVersionStatus().intValue() == DocumentVersionStatus.INVALIDATEDALL.getValue()) {
                boolean lastVersionStatusU = planDeliverJoinDto.getRevisedLastVersionId() != null ? planDeliverJoinDto.getRevisedLastVersionStatus().intValue() == DocumentVersionStatus.INVALIDATEDALL.getValue() : planDeliverJoinDto.getLastVersionStatus().intValue() == DocumentVersionStatus.INVALIDATEDALL.getValue();
                planDeliverJoinDto.setDerivedInfoLastVersionStatusU(Boolean.valueOf(lastVersionStatusU));
            }
            planDeliverJoinDto.setDerivedInfoOwnObjectPlanner(Boolean.valueOf(ownParticipationIds.contains(planDeliverJoinDto.getProjectParticipationId())));
            hashMap.put(planDeliverJoinDto.getDocumentId(), planDeliverJoinDto);
        }
        HashMap documentIdToHistoryItems = new HashMap();
        for (Long documentId : documentIdToHistoryItemMap.keySet()) {
            Map idToHistoryJoin = (Map)documentIdToHistoryItemMap.get(documentId);
            ArrayList historyJoins = new ArrayList();
            historyJoins.addAll(idToHistoryJoin.values());
            Collections.sort(historyJoins, new Comparator<DocumentHistoryJoin>(){

                @Override
                public int compare(DocumentHistoryJoin historyJoinOne, DocumentHistoryJoin historyJoinTwo) {
                    if (historyJoinOne.getDocumentDateHistoryPartId() == null) {
                        return 1;
                    }
                    if (historyJoinTwo.getDocumentDateHistoryPartId() == null) {
                        return -1;
                    }
                    return (int)(historyJoinOne.getDocumentDateHistoryPartId() - historyJoinTwo.getDocumentDateHistoryPartId());
                }
            });
            documentIdToHistoryItems.put(documentId, historyJoins);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashMap.values());
        PlanDeliverJoinCompositeDto planDeliverJoin = new PlanDeliverJoinCompositeDto();
        planDeliverJoin.setJoinDtos(arrayList);
        planDeliverJoin.setObjectPlannerIdToActions(ActionHelper.convertEnumToString(allowedObjectPlannerActions));
        planDeliverJoin.setHistoryItems(documentIdToHistoryItems);
        return planDeliverJoin;
    }

    public PlanDeliverJoinCompositeDto insertDocuments(List<Document> documents, Long organisationPersonId, Long subProjectId, Long projectId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Map<Long, Set<Action>> allowedObjectPlannerActions = this.actionDAO.getObjectPlannerActionsForSubProject(organisationPersonId, subProjectId, Action.SHOW_OBJECT_PLANNER_OP_CONTEXT, Action.EDIT_PLAN_DELIVER_CATALOGUE, Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES, Action.EDIT_PLAN_DELIVER_CATALOGUE_START_DATE, Action.EDIT_PLAN_DELIVER_CATALOGUE_END_DATE, Action.UPLOAD_DOCUMENT);
        int numberOfObjectListReleases = this.objectListReleaseDAO.getCountBySubProject(subProjectId);
        if (numberOfObjectListReleases == 0) {
            throw new SecurityException("Inserting documents is not allowed if no ObjectListReleases exist; subProjectId = [" + subProjectId + "]");
        }
        ProjectParticipant signer = this.projectParticipantDAO.getSigner(organisationPersonId, projectId, Action.EDIT_PLAN_DELIVER_CATALOGUE.getName());
        if (signer == null) {
            throw new SecurityException("No valid signer for organisationPersonId = [" + organisationPersonId + "] and projectId = [" + projectId + "] found.");
        }
        HashMap newObjectPlannerIdsToDocuments = new HashMap();
        ArrayList<Long> newObjectPlannerIds = new ArrayList<Long>();
        Iterator<Document> documentIterator = documents.iterator();
        while (documentIterator.hasNext()) {
            Document document = documentIterator.next();
            if (!I18nHelper.isAnyLanguageFilled(document.getContent()) || document.getNumber() == null || document.getNumber() < 0) {
                documentIterator.remove();
                continue;
            }
            Long newObjectPlannerId = document.getObjectPlannerId();
            if (!allowedObjectPlannerActions.containsKey(newObjectPlannerId) || !allowedObjectPlannerActions.get(newObjectPlannerId).contains(Action.EDIT_PLAN_DELIVER_CATALOGUE)) {
                throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to [editPlanDeliverCatalogue] ObjectPlanner [" + newObjectPlannerId + "] (Project [" + projectId + "], SubProject [" + subProjectId + "]). Thus inserting documents is not allowed.");
            }
            Set<Action> allowedActions = allowedObjectPlannerActions.get(newObjectPlannerId);
            if (!newObjectPlannerIdsToDocuments.containsKey(newObjectPlannerId)) {
                newObjectPlannerIds.add(newObjectPlannerId);
                newObjectPlannerIdsToDocuments.put(newObjectPlannerId, new ArrayList());
            }
            ((List)newObjectPlannerIdsToDocuments.get(newObjectPlannerId)).add(document);
        }
        PlanDeliverJoinCompositeDto planDeliverJoin = new PlanDeliverJoinCompositeDto();
        for (Long newObjectPlannerId : newObjectPlannerIds) {
            List<PlanDeliverNewJoin> planDeliverNewJoins = this.documentDAO.getPlanDeliverNewJoin(newObjectPlannerId);
            Long objectId = null;
            Long numberPartGroupId = null;
            Project project = null;
            List newObjectPlannersDocuments = (List)newObjectPlannerIdsToDocuments.get(newObjectPlannerId);
            PlanDeliverNewJoin planDeliverNewJoin = null;
            ArrayList<ProjectHoliday> projectHolidays = new ArrayList<ProjectHoliday>();
            for (PlanDeliverNewJoin join : planDeliverNewJoins) {
                if (join.getUnionClause().intValue() == PlanDeliverNewComponent.OBJECT_PLANNER.getValue()) {
                    planDeliverNewJoin = join;
                    objectId = join.getObjectId();
                    numberPartGroupId = join.getProjectDocumentNumberPartGroupId();
                    project = join.getProject();
                    continue;
                }
                if (join.getUnionClause().intValue() != PlanDeliverNewComponent.PROJECT_HOLIDAY.getValue()) continue;
                projectHolidays.add(join.getProjectHoliday());
            }
            ObjectRelease newJoinsObjectRel = planDeliverNewJoin.getObjectRelease();
            ObjectPlanner newJoinsObjectPlanner = planDeliverNewJoin.getObjectPlanner();
            ProjectParticipation projectParticipation = (ProjectParticipation)this.projectParticipationDAO.get(newJoinsObjectPlanner.getPlannerId());
            Map idToMasterDataInfo = this.contextService.getMasterData(networkId);
            Map idToDocumentType = null;
            Map idToObjectType = null;
            for (MasterDataInfo masterDataInfo : idToMasterDataInfo.values()) {
                for (DocumentNumberPartGroup group : masterDataInfo.getGroupIdToDocumentNumberGroup().values()) {
                    if (group.getId().longValue() != project.getDocumentNumberPartGroupId().longValue()) continue;
                    idToDocumentType = masterDataInfo.getIdToDocumentType();
                    idToObjectType = masterDataInfo.getIdToObjectType();
                }
            }
            if (idToDocumentType == null || idToObjectType == null) {
                log.warn("No matching documentType or objectType map could be located for networkId [" + networkId + "], project = [" + projectId + "], documentNumberPartGroupId = [" + project.getDocumentNumberPartGroupId() + "]; taking an arbitrary one to avoid a complete failure.");
                idToDocumentType = ((MasterDataInfo)idToMasterDataInfo.values().iterator().next()).getIdToDocumentType();
            }
            if (planDeliverNewJoin == null) {
                throw new IllegalArgumentException("Could not find planDeliverNewJoin for objectPlannerId = [" + newObjectPlannerId + "]");
            }
            if (planDeliverNewJoin.getDocumentListId() == null) {
                throw new IllegalArgumentException("PlanDeliverNewJoin does not contain a document list id.");
            }
            HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", projectHolidays);
            List<DocumentNumberPart> numberParts = CodeHelper.getDocumentNumberPartsByGroupId(idToMasterDataInfo, numberPartGroupId);
            DocumentNumberUniqueness uniqueness = CodeHelper.getDocumentNumberUniqueness(numberParts);
            List<DocumentNumberUniqueJoin> existingDocumentJoins = null;
            if (uniqueness == DocumentNumberUniqueness.OBJECT_PLANNER) {
                HashSet<Long> objectPlannerIds = new HashSet<Long>();
                objectPlannerIds.add(newObjectPlannerId);
                existingDocumentJoins = this.documentDAO.getUniqueJoinByObjectPlanners(objectPlannerIds);
            } else if (uniqueness == DocumentNumberUniqueness.OBJECT) {
                HashSet<Long> objectIds = new HashSet<Long>();
                objectIds.add(objectId);
                existingDocumentJoins = this.documentDAO.getByObjects(objectIds);
            } else {
                existingDocumentJoins = this.documentDAO.getBySubproject(subProjectId);
            }
            HashSet<String> existingDocumentNumbers = new HashSet<String>();
            for (DocumentNumberUniqueJoin existingDocumentJoin : existingDocumentJoins) {
                Document document = existingDocumentJoin.getDocument();
                if (document.isInvalidated() != null && document.isInvalidated().booleanValue()) continue;
                String documentKey = CodeHelper.getUniqueKeyForDocument(document, numberParts, idToDocumentType, idToObjectType, existingDocumentJoin.getProjectParticipation(), existingDocumentJoin.getObjectRelease());
                if (existingDocumentNumbers.contains(documentKey)) {
                    throw new RuntimeException("While adding new documents: Already the existing document numbers are not unique.  Example for objectPlannerId [" + newObjectPlannerId + "] and uniqueness [" + uniqueness + "]: documentNumber [" + document.getNumber() + "] occurs multiple times, last for document [" + document.getId() + "]");
                }
                existingDocumentNumbers.add(documentKey);
            }
            for (Document newDocument : newObjectPlannersDocuments) {
                String documentKey = CodeHelper.getUniqueKeyForDocument(newDocument, numberParts, idToDocumentType, idToObjectType, projectParticipation, newJoinsObjectRel);
                if (existingDocumentNumbers.contains(documentKey)) {
                    throw new RuntimeException("Trying to add duplicate document number for objectPlanner [" + newObjectPlannerId + "]: documentNumber [" + newDocument.getNumber() + "]");
                }
                existingDocumentNumbers.add(documentKey);
            }
            for (Document newDocument : newObjectPlannersDocuments) {
                newDocument.setId(null);
                newDocument.setDocumentListId(planDeliverNewJoin.getDocumentListId());
                newDocument.setObjectPlannerId(newObjectPlannerId);
                newDocument.setModified(Integer.valueOf(DocumentModifiedState.NEW.getValue()));
                newDocument.setHasDocumentVersions(Boolean.valueOf(false));
                newDocument.setInvalidated(Boolean.valueOf(false));
                String documentName = CodeHelper.getDocumentNumber((Map<Long, MasterDataInfo>)idToMasterDataInfo, newDocument, planDeliverNewJoin, false);
                newDocument.setName(documentName);
                Set<Action> allowedActions = allowedObjectPlannerActions.get(newObjectPlannerId);
                if (newDocument.getStartDate() != null && !allowedActions.contains(Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES) && !allowedActions.contains(Action.EDIT_PLAN_DELIVER_CATALOGUE_END_DATE)) {
                    Double endDate = holidayCalculator.addWorkingDays(newDocument.getStartDate(), planDeliverNewJoin.getReviewCycleInstanceDuration());
                    newDocument.setEndDate(endDate);
                } else if (newDocument.getEndDate() != null && !allowedActions.contains(Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES) && !allowedActions.contains(Action.EDIT_PLAN_DELIVER_CATALOGUE_START_DATE)) {
                    Double startDate = holidayCalculator.addWorkingDays(newDocument.getEndDate(), -planDeliverNewJoin.getReviewCycleInstanceDuration().intValue());
                    newDocument.setStartDate(startDate);
                }
                newDocument.setDuration(planDeliverNewJoin.getReviewCycleInstanceDuration());
                log.info("Storing document: documentListId = " + newDocument.getDocumentListId() + "; newObjectPlannerId = " + newDocument.getObjectPlannerId());
            }
            List savedNewDocuments = this.documentDAO.saveBatch(newObjectPlannersDocuments);
            HashMap documentIdToDocumentHistoryJoin = new HashMap();
            ArrayList<DocumentDateHistoryPart> historyParts = new ArrayList<DocumentDateHistoryPart>();
            for (Document savedNewDocument : savedNewDocuments) {
                if (savedNewDocument.getEndDate() == null) continue;
                DocumentDateHistoryPart historyPart = new DocumentDateHistoryPart();
                historyPart.setDocumentId(savedNewDocument.getId());
                historyPart.setEditDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
                historyPart.setProjectParticipantId(signer.getId());
                historyPart.setStartDate(savedNewDocument.getStartDate());
                historyPart.setEndDate(savedNewDocument.getEndDate());
                historyPart.setModType(Integer.valueOf(DocumentDateHistoryModType.BOTH.getValue()));
                historyParts.add(historyPart);
                DocumentHistoryJoin historyJoin = new DocumentHistoryJoin();
                historyJoin.setDocumentDateHistoryPart(historyPart);
                historyJoin.setPerson(planDeliverNewJoin.getPerson());
                ArrayList<DocumentHistoryJoin> historyJoins = new ArrayList<DocumentHistoryJoin>();
                historyJoins.add(historyJoin);
                documentIdToDocumentHistoryJoin.put(savedNewDocument.getId(), historyJoins);
            }
            this.documentDateHistoryPartDAO.saveBatch(historyParts);
            ArrayList<PlanDeliverJoinDto> documentJoins = new ArrayList<PlanDeliverJoinDto>();
            for (Document newDocument : newObjectPlannersDocuments) {
                PlanDeliverJoinDto documentJoin = new PlanDeliverJoinDto();
                documentJoin.setObject(planDeliverNewJoin.getObject());
                documentJoin.setObjectPlanner(planDeliverNewJoin.getObjectPlanner());
                documentJoin.setReviewCycleInstance(planDeliverNewJoin.getReviewCycleInstance());
                documentJoin.setOrganisation(planDeliverNewJoin.getOrganisation());
                documentJoin.setProjectParticipation(planDeliverNewJoin.getProjectParticipation());
                documentJoin.setPerson(planDeliverNewJoin.getPerson());
                documentJoin.setDocument(newDocument);
                documentJoin.setDerivedInfoNumberOfReleasedDocuments(Integer.valueOf(0));
                documentJoins.add(documentJoin);
            }
            planDeliverJoin.setJoinDtos(documentJoins);
            planDeliverJoin.setHistoryItems(documentIdToDocumentHistoryJoin);
            planDeliverJoin.setObjectPlannerIdToActions(ActionHelper.convertEnumToString(allowedObjectPlannerActions));
        }
        return planDeliverJoin;
    }

    public PlanDeliverSaveResult savePlanDeliverCatalogue(List<Document> documents, List<Long> documentIdsToDelete, final Long organisationPersonId, final Long subProjectId, final Long projectId, Long networkId) {
        List<DocumentNumberUniqueJoin> existingDocumentJoins;
        String documentKey;
        Integer documentNumber;
        boolean numberChanged;
        Document oldDocument;
        Document document;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ArrayList<Long> documentIds = new ArrayList<Long>();
        HashMap<Long, Document> documentIdToNewDocument = new HashMap<Long, Document>();
        Iterator<Document> documentIterator = documents.iterator();
        while (documentIterator.hasNext()) {
            Document document2 = documentIterator.next();
            if (I18nHelper.isAnyLanguageFilled(document2.getContent()) && document2.getNumber() != null && document2.getNumber() >= 0) continue;
            documentIterator.remove();
        }
        for (Document document3 : documents) {
            documentIds.add(document3.getId());
            documentIdToNewDocument.put(document3.getId(), document3);
        }
        int numberOfObjectListReleases = this.objectListReleaseDAO.getCountBySubProject(subProjectId);
        if (numberOfObjectListReleases == 0) {
            throw new SecurityException("Saving documents is not allowed if no ObjectListReleases exist; subProjectId = [" + subProjectId + "]");
        }
        List<PlanDeliverSaveJoin> saveJoins = QueryHelper.executeDAOGetter(documentIds, this.sqlQueryBatchSize, new BatchedDAOGetter<PlanDeliverSaveJoin, Long>(){

            @Override
            public List<PlanDeliverSaveJoin> execute(List<Long> ids) {
                return PlanDeliverServiceImpl.this.documentDAO.getPlanDeliverSaveJoin(ids, organisationPersonId, subProjectId, projectId);
            }
        });
        HashMap<Long, PlanDeliverSaveJoin> documentIdToOldPersistent = new HashMap<Long, PlanDeliverSaveJoin>();
        HashMap<Long, DocumentRelease> documentIdToRelease = new HashMap<Long, DocumentRelease>();
        HashMap<Long, DocumentVersion> documentIdToLastVersion = new HashMap<Long, DocumentVersion>();
        ArrayList<ProjectHoliday> projectHolidays = new ArrayList<ProjectHoliday>();
        String countryCodeTwo = null;
        Project project = null;
        ProjectParticipant signer = null;
        Person signerPerson = null;
        Long numberPartGroupId = null;
        HashSet<Long> objectPlannerIds = new HashSet<Long>();
        HashSet<Long> objectIds = new HashSet<Long>();
        HashMap<Long, ProjectParticipation> documentIdToProjectParticipation = new HashMap<Long, ProjectParticipation>();
        for (PlanDeliverSaveJoin saveJoin : saveJoins) {
            if (saveJoin.getUnionClause().intValue() == PlanDeliverSaveComponent.DOCUMENT.getValue()) {
                documentIdToOldPersistent.put(saveJoin.getDocumentId(), saveJoin);
                if (saveJoin.getDocumentReleaseId() != null) {
                    documentIdToRelease.put(saveJoin.getDocumentId(), saveJoin.getDocumentRelease());
                }
                if (saveJoin.getReactivatedVersionId() != null) {
                    documentIdToLastVersion.put(saveJoin.getDocumentId(), saveJoin.getReactivatedVersion());
                } else if (saveJoin.getLastVersionId() != null) {
                    documentIdToLastVersion.put(saveJoin.getDocumentId(), saveJoin.getLastVersion());
                }
                numberPartGroupId = saveJoin.getProjectDocumentNumberPartGroupId();
                objectPlannerIds.add(saveJoin.getObjectPlannerId());
                objectIds.add(saveJoin.getObjectId());
                documentIdToProjectParticipation.put(saveJoin.getDocumentId(), saveJoin.getProjectParticipation());
                continue;
            }
            if (saveJoin.getUnionClause().intValue() == PlanDeliverSaveComponent.PROJECT_HOLIDAY.getValue()) {
                projectHolidays.add(saveJoin.getProjectHoliday());
                continue;
            }
            if (saveJoin.getUnionClause().intValue() == PlanDeliverSaveComponent.PROJECT_LOCALISATION.getValue()) {
                countryCodeTwo = saveJoin.getCountryCode2();
                project = saveJoin.getProject();
                continue;
            }
            if (saveJoin.getUnionClause().intValue() == PlanDeliverSaveComponent.SIGNER.getValue()) {
                signer = saveJoin.getProjectParticipant();
                signerPerson = saveJoin.getPerson();
                continue;
            }
            throw new RuntimeException("Unknown PlanDeliverSaveComponent: " + saveJoin.getUnionClause());
        }
        Map idToMasterDataInfo = this.contextService.getMasterData(networkId);
        Map idToDocumentType = null;
        Map idToObjectType = null;
        for (MasterDataInfo masterDataInfo : idToMasterDataInfo.values()) {
            for (DocumentNumberPartGroup group : masterDataInfo.getGroupIdToDocumentNumberGroup().values()) {
                if (group.getId().longValue() != project.getDocumentNumberPartGroupId().longValue()) continue;
                idToDocumentType = masterDataInfo.getIdToDocumentType();
                idToObjectType = masterDataInfo.getIdToObjectType();
            }
        }
        if (idToDocumentType == null || idToObjectType == null) {
            log.warn("No matching documentType or objectType map could be located for networkId [" + networkId + "], project = [" + projectId + "], documentNumberPartGroupId = [" + project.getDocumentNumberPartGroupId() + "]; taking an arbitrary one to avoid a complete failure.");
            idToDocumentType = ((MasterDataInfo)idToMasterDataInfo.values().iterator().next()).getIdToDocumentType();
        }
        if (signer == null) {
            throw new SecurityException("No valid signer for organisationPersonId = [" + organisationPersonId + "] and projectId = [" + projectId + "] found.");
        }
        DocumentNumberUniqueness uniqueness = null;
        HashMap<Long, Long> documentIdToKey = new HashMap<Long, Long>();
        HashMap<Long, Set<String>> keyToExistingDocuments = new HashMap<Long, Set<String>>();
        List<DocumentNumberPart> numberParts = CodeHelper.getDocumentNumberPartsByGroupId(idToMasterDataInfo, numberPartGroupId);
        uniqueness = CodeHelper.getDocumentNumberUniqueness(numberParts);
        if (uniqueness == DocumentNumberUniqueness.OBJECT_PLANNER) {
            List<DocumentNumberUniqueJoin> existingDocuments = this.documentDAO.getUniqueJoinByObjectPlanners(objectPlannerIds);
            for (DocumentNumberUniqueJoin uniqueJoin : existingDocuments) {
                document = uniqueJoin.getDocument();
                oldDocument = documentIdToNewDocument.containsKey(document.getId()) ? (Document)documentIdToNewDocument.get(document.getId()) : null;
                boolean bl = numberChanged = oldDocument != null && this.didValueChange(oldDocument.getNumber(), document.getNumber());
                if (document.isInvalidated().booleanValue()) continue;
                Long l = document.getObjectPlannerId();
                documentIdToKey.put(document.getId(), l);
                documentNumber = document.getNumber();
                documentKey = CodeHelper.getUniqueKeyForDocument(document, numberParts, idToDocumentType, idToObjectType, uniqueJoin.getProjectParticipation(), uniqueJoin.getObjectRelease());
                if (keyToExistingDocuments.containsKey(l) && ((Set)keyToExistingDocuments.get(l)).contains(documentKey)) {
                    throw new RuntimeException("While adding new documents: Already the existing document numbers are not unique. Example for objectPlannerId [" + l + "] and uniqueness [" + uniqueness + "]: [" + documentNumber + "] occurs multiple times, last for document [" + document.getId() + "]");
                }
                if (numberChanged) continue;
                if (!keyToExistingDocuments.containsKey(l)) {
                    keyToExistingDocuments.put(l, new HashSet());
                }
                ((Set)keyToExistingDocuments.get(l)).add(documentKey);
            }
        } else if (uniqueness == DocumentNumberUniqueness.OBJECT) {
            existingDocumentJoins = this.documentDAO.getByObjects(objectIds);
            for (DocumentNumberUniqueJoin join : existingDocumentJoins) {
                document = join.getDocument();
                oldDocument = documentIdToNewDocument.containsKey(document.getId()) ? (Document)documentIdToNewDocument.get(document.getId()) : null;
                boolean bl = numberChanged = oldDocument != null && this.didValueChange(oldDocument.getNumber(), document.getNumber());
                if (join.isDocumentInvalidated().booleanValue()) continue;
                Long l = join.getObjectPlannerObjectId();
                documentIdToKey.put(join.getDocumentId(), l);
                documentNumber = join.getDocumentNumber();
                documentKey = CodeHelper.getUniqueKeyForDocument(join.getDocument(), numberParts, idToDocumentType, idToObjectType, join.getProjectParticipation(), join.getObjectRelease());
                if (keyToExistingDocuments.containsKey(l) && ((Set)keyToExistingDocuments.get(l)).contains(documentKey)) {
                    throw new RuntimeException("While adding new documents: Existing documentNumbers are not unique. Example for objectPlannerId [" + l + "] and uniqueness/number [" + uniqueness + "]/[" + documentNumber + "] occurs multiple times, last for document [" + join.getDocumentId() + "], name [" + join.getDocumentName() + "]");
                }
                if (numberChanged) continue;
                if (!keyToExistingDocuments.containsKey(l)) {
                    keyToExistingDocuments.put(l, new HashSet());
                }
                ((Set)keyToExistingDocuments.get(l)).add(documentKey);
            }
        } else {
            existingDocumentJoins = this.documentDAO.getBySubproject(subProjectId);
            for (DocumentNumberUniqueJoin join : existingDocumentJoins) {
                document = join.getDocument();
                oldDocument = documentIdToNewDocument.containsKey(document.getId()) ? (Document)documentIdToNewDocument.get(document.getId()) : null;
                boolean bl = numberChanged = oldDocument != null && this.didValueChange(oldDocument.getNumber(), document.getNumber());
                if (join.isDocumentInvalidated().booleanValue()) continue;
                Long l = subProjectId;
                documentIdToKey.put(join.getDocumentId(), l);
                documentNumber = join.getDocumentNumber();
                documentKey = CodeHelper.getUniqueKeyForDocument(join.getDocument(), numberParts, idToDocumentType, null, join.getProjectParticipation(), join.getObjectRelease());
                if (keyToExistingDocuments.containsKey(l) && ((Set)keyToExistingDocuments.get(l)).contains(documentKey)) {
                    throw new RuntimeException("While adding new documents: Already the existing document numbers are not unique. Example for subProjectId [" + l + "] and uniqueness [" + uniqueness + "]: [" + documentNumber + "] occurs multiple times, last for document [" + join.getDocumentId() + "]");
                }
                if (numberChanged) continue;
                if (!keyToExistingDocuments.containsKey(l)) {
                    keyToExistingDocuments.put(l, new HashSet());
                }
                ((Set)keyToExistingDocuments.get(l)).add(documentKey);
            }
        }
        HashSet<Long> documentIdsWithChangedStartDate = new HashSet<Long>();
        HashSet<Long> documentIdsWithChangedEndDate = new HashSet<Long>();
        documents = this.checkDocumentsForSave(documents, documentIdToOldPersistent, documentIdToProjectParticipation, organisationPersonId, projectId, subProjectId, documentIdsWithChangedStartDate, documentIdsWithChangedEndDate, idToMasterDataInfo, documentIdToKey, documentIdToLastVersion, numberParts, idToDocumentType, keyToExistingDocuments, countryCodeTwo, projectHolidays);
        if (countryCodeTwo == null) {
            throw new IllegalArgumentException("Could not find a countryCode2 for projectId [" + projectId + "].  Please check the project configuration.");
        }
        List<DocumentDateHistoryPart> newHistoryParts = new ArrayList();
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinBySubProject(subProjectId);
        String projectLocale = I18nHelper.getProjectLocale(localisationJoin);
        for (Document document2 : documents) {
            PlanDeliverSaveJoin oldSaveJoin = (PlanDeliverSaveJoin)documentIdToOldPersistent.get(document2.getId());
            String documentName = CodeHelper.getDocumentNumber((Map<Long, MasterDataInfo>)idToMasterDataInfo, document2, oldSaveJoin, false);
            document2.setName(documentName);
            String newDocumentContent = I18nHelper.convertJsToDatabase(document2.getContent(), projectLocale);
            document2.setContent(newDocumentContent);
            boolean startChanged = documentIdsWithChangedStartDate.contains(document2.getId());
            boolean endChanged = documentIdsWithChangedEndDate.contains(document2.getId());
            if (startChanged || endChanged) {
                DocumentDateHistoryPart newHistoryPart = this.constructDocumentDateHistoryPart(document2, signer, startChanged, endChanged);
                newHistoryParts.add(newHistoryPart);
            }
            if (documentIdToRelease.containsKey(document2.getId())) {
                DocumentRelease oldReleasedDocument = (DocumentRelease)documentIdToRelease.get(document2.getId());
                boolean nameChanged = this.didValueChange(oldReleasedDocument.getName(), document2.getName());
                boolean contentChanged = this.didValueChange(oldReleasedDocument.getContent(), document2.getContent());
                boolean scaleChanged = this.didValueChange(oldReleasedDocument.getScale(), document2.getScale());
                boolean startDateChanged = this.didValueChange(oldReleasedDocument.getStartDate(), document2.getStartDate());
                boolean endDateChanged = this.didValueChange(oldReleasedDocument.getEndDate(), document2.getEndDate());
                if (startDateChanged || endDateChanged) {
                    document2.setModified(Integer.valueOf(DocumentModifiedState.DATE_MODIFIED.getValue()));
                } else if (nameChanged || contentChanged || scaleChanged) {
                    document2.setModified(Integer.valueOf(DocumentModifiedState.CONTENT_MODIFIED.getValue()));
                } else {
                    document2.setModified(Integer.valueOf(DocumentModifiedState.NOT_MODIFIED.getValue()));
                }
            } else {
                document2.setModified(Integer.valueOf(DocumentModifiedState.NEW.getValue()));
            }
            if (document2.getInvalidated() != null) continue;
            document2.setInvalidated(Boolean.valueOf(false));
        }
        newHistoryParts = this.documentDateHistoryPartDAO.saveBatch(newHistoryParts);
        this.documentDAO.updateBatch(documents);
        log.info(documents.size() + " documents are for save.");
        ArrayList<DocumentHistoryJoin> newHistoryJoins = new ArrayList<DocumentHistoryJoin>();
        for (DocumentDateHistoryPart newHistoryPart : newHistoryParts) {
            DocumentHistoryJoin newHistoryJoin = new DocumentHistoryJoin();
            newHistoryJoin.setDocumentDateHistoryPart(newHistoryPart);
            newHistoryJoin.setPerson(signerPerson);
            newHistoryJoins.add(newHistoryJoin);
        }
        PlanDeliverSaveResult planDeliverSaveResult = new PlanDeliverSaveResult();
        planDeliverSaveResult.setSavedHistoryParts(newHistoryJoins);
        planDeliverSaveResult.setUpdatedDocuments(documents);
        return planDeliverSaveResult;
    }

    private boolean didValueChange(Object v1, Object v2) {
        return v1 == null != (v2 == null) || v1 != null && !v1.equals(v2);
    }

    private List<Document> checkDocumentsForSave(List<Document> documents, Map<Long, PlanDeliverSaveJoin> documentIdToOldPersistent, Map<Long, ProjectParticipation> documentIdToProjectParticipation, Long organisationPersonId, Long projectId, Long subProjectId, Set<Long> documentIdsWithChangedStartDate, Set<Long> documentIdsWithChangedEndDate, Map<Long, MasterDataInfo> idToMasterDataInfo, Map<Long, Long> documentIdToKey, Map<Long, DocumentVersion> documentIdToLastVersion, List<DocumentNumberPart> numberParts, Map<Long, DocumentType> idToDocumentType, Map<Long, Set<String>> keyToExistingDocumentNumbers, String countryCodeTwo, List<ProjectHoliday> projectHolidays) {
        Map<Action, ActionInfo> actionsForProject = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES_PROJ_CONT);
        Map<Long, Set<Action>> allowedObjectPlannerActions = this.actionDAO.getObjectPlannerActionsForSubProject(organisationPersonId, subProjectId, Action.EDIT_PLAN_DELIVER_CATALOGUE, Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES, Action.EDIT_PLAN_DELIVER_CATALOGUE_START_DATE, Action.EDIT_PLAN_DELIVER_CATALOGUE_END_DATE, Action.SUPER_ADMIN_RIGHT);
        HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance(countryCodeTwo, projectHolidays);
        ArrayList<Document> retList = new ArrayList<Document>();
        for (Document document : documents) {
            Document oldDocument = documentIdToOldPersistent.get(document.getId()).getDocument();
            Long objectPlannerId = documentIdToOldPersistent.get(document.getId()).getDocumentObjectPlannerId();
            ObjectRelease objectRel = documentIdToOldPersistent.get(document.getId()).getObjectRelease();
            boolean editNameAllowed = (oldDocument.getHasDocumentVersions() == null || oldDocument.getHasDocumentVersions() == false || ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.SUPER_ADMIN_RIGHT)) && ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.EDIT_PLAN_DELIVER_CATALOGUE);
            boolean editContentAllowed = ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.EDIT_PLAN_DELIVER_CATALOGUE);
            boolean editCommentAllowed = ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.EDIT_PLAN_DELIVER_CATALOGUE);
            boolean editScaleAllowed = ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.EDIT_PLAN_DELIVER_CATALOGUE);
            boolean dateChangeAllowed = !documentIdToLastVersion.containsKey(document.getId()) || documentIdToLastVersion.get(document.getId()).getStatus().intValue() != DocumentVersionStatus.RELEASEDPOSITIV.getValue();
            boolean editStartDateAllowed = dateChangeAllowed && (ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES) || ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.EDIT_PLAN_DELIVER_CATALOGUE_START_DATE) || actionsForProject.containsKey(Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES_PROJ_CONT));
            boolean editEndDateAllowed = dateChangeAllowed && (ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES) || ActionHelper.isObjectPlannerActionAllowed(allowedObjectPlannerActions, objectPlannerId, Action.EDIT_PLAN_DELIVER_CATALOGUE_END_DATE) || actionsForProject.containsKey(Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES_PROJ_CONT));
            boolean numberChanged = this.didValueChange(oldDocument.getNumber(), document.getNumber());
            boolean partChanged = this.didValueChange(oldDocument.getPart(), document.getPart());
            boolean documentTypeChanged = this.didValueChange(oldDocument.getDocumentTypeId(), document.getDocumentTypeId());
            boolean contentChanged = this.didValueChange(oldDocument.getContent(), document.getContent());
            boolean commentChanged = this.didValueChange(oldDocument.getComment(), document.getComment());
            boolean scaleChanged = this.didValueChange(oldDocument.getScale(), document.getScale());
            boolean startDateChanged = this.didValueChange(oldDocument.getStartDate(), document.getStartDate());
            boolean endDateChanged = this.didValueChange(oldDocument.getEndDate(), document.getEndDate());
            boolean saveNeverTheless = true;
            if (!saveNeverTheless && !numberChanged && !partChanged && !documentTypeChanged && !contentChanged && !commentChanged && !scaleChanged && !startDateChanged && !endDateChanged) continue;
            if (numberChanged && !editNameAllowed || partChanged && !editNameAllowed || documentTypeChanged && !editNameAllowed || contentChanged && !editContentAllowed || commentChanged && !editCommentAllowed || scaleChanged && !editScaleAllowed || startDateChanged && !editStartDateAllowed && !editEndDateAllowed || endDateChanged && !editEndDateAllowed && !editStartDateAllowed) {
                throw new SecurityException("Illegal field change: name = ((" + numberChanged + "," + partChanged + "," + documentTypeChanged + ") / " + editNameAllowed + "), content = (" + contentChanged + " / " + editContentAllowed + "), comment = (" + commentChanged + " / " + editCommentAllowed + "), scale = (" + scaleChanged + " / " + editScaleAllowed + "), startDate = (" + startDateChanged + " / " + editStartDateAllowed + "), endDate = (" + endDateChanged + " / " + editEndDateAllowed + ")");
            }
            Document newDocument = oldDocument;
            if (documentTypeChanged) {
                newDocument.setDocumentTypeId(document.getDocumentTypeId());
            }
            if (partChanged) {
                newDocument.setPart(document.getPart());
            }
            if (numberChanged) {
                Long key = documentIdToKey.get(document.getId());
                Set<Object> existingDocumentNumbers = new HashSet();
                if (keyToExistingDocumentNumbers != null && !keyToExistingDocumentNumbers.isEmpty()) {
                    existingDocumentNumbers = keyToExistingDocumentNumbers.get(key);
                }
                ProjectParticipation projectParticipation = documentIdToProjectParticipation.get(document.getId());
                newDocument.setNumber(document.getNumber());
                String documentKey = CodeHelper.getUniqueKeyForDocument(newDocument, numberParts, idToDocumentType, null, projectParticipation, objectRel);
                if (existingDocumentNumbers.contains(documentKey)) {
                    throw new RuntimeException("Trying to add duplicate document number for key (ObjectPlanner or Object) [" + key + "]: [" + document.getNumber() + "]");
                }
                existingDocumentNumbers.add(documentKey);
            }
            if (numberChanged || partChanged || documentTypeChanged) {
                PlanDeliverSaveJoin planDeliverSaveJoin = documentIdToOldPersistent.get(newDocument.getId());
                String documentName = CodeHelper.getDocumentNumber(idToMasterDataInfo, document, planDeliverSaveJoin, false);
                newDocument.setName(documentName);
            }
            if (contentChanged) {
                newDocument.setContent(document.getContent());
            }
            if (commentChanged) {
                newDocument.setComment(document.getComment());
            }
            if (scaleChanged) {
                newDocument.setScale(document.getScale());
            }
            if (startDateChanged) {
                newDocument.setStartDate(document.getStartDate());
                Double endDate = null;
                if (document.getStartDate() != null) {
                    endDate = holidayCalculator.addWorkingDays(document.getStartDate(), document.getDuration());
                }
                newDocument.setEndDate(endDate);
            } else if (endDateChanged) {
                newDocument.setEndDate(document.getEndDate());
                Double startDate = null;
                if (document.getEndDate() != null) {
                    startDate = holidayCalculator.addWorkingDays(document.getEndDate(), -document.getDuration().intValue());
                }
                newDocument.setStartDate(startDate);
            }
            if (newDocument.getEndDate() != null && newDocument.getStartDate() != null) {
                newDocument.setDuration(holidayCalculator.getWorkingDaysBetween(newDocument.getStartDate(), newDocument.getEndDate()));
            }
            retList.add(newDocument);
            if (startDateChanged) {
                documentIdsWithChangedStartDate.add(newDocument.getId());
            }
            if (!endDateChanged) continue;
            documentIdsWithChangedEndDate.add(newDocument.getId());
        }
        return retList;
    }

    private DocumentDateHistoryPart constructDocumentDateHistoryPart(Document document, ProjectParticipant signer, boolean startChanged, boolean endChanged) {
        DocumentDateHistoryPart part = new DocumentDateHistoryPart();
        part.setProjectParticipantId(signer.getId());
        part.setEditDate(new Double((double)System.currentTimeMillis() / 1000.0));
        part.setStartDate(document.getStartDate());
        part.setEndDate(document.getEndDate());
        part.setDocumentId(document.getId());
        if (startChanged && endChanged) {
            part.setModType(Integer.valueOf(DocumentDateHistoryModType.BOTH.getValue()));
        } else if (startChanged) {
            part.setModType(Integer.valueOf(DocumentDateHistoryModType.START.getValue()));
        } else if (endChanged) {
            part.setModType(Integer.valueOf(DocumentDateHistoryModType.END.getValue()));
        }
        return part;
    }

    public ResultSummary releasePlanDeliverCatalogue(Long organisationPersonId, Long projectId, Long subProjectId, String password, boolean updateAllDocuments) {
        int numberOfObjectListReleases;
        Map<Action, ActionInfo> projectActions;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (log.isDebugEnabled()) {
            log.debug("==========================================================================");
            log.debug("==========================================================================");
            log.debug("Starting to release plan deliver catalogue for orgPerson [" + organisationPersonId + "], project [" + projectId + "], subProject [" + subProjectId + "]");
        }
        if (!(projectActions = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, Action.RELEASE_PLAN_DELIVER_CATALOGUE)).containsKey(Action.RELEASE_PLAN_DELIVER_CATALOGUE)) {
            throw new SecurityException("Project permission [releasePlanDeliverCatalogue] is missing.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Fetched " + projectActions.size() + " project actions.");
        }
        if ((numberOfObjectListReleases = this.objectListReleaseDAO.getCountBySubProject(subProjectId)) == 0) {
            throw new SecurityException("Releasing the plan deliver catalogue is not allowed if no ObjectListReleases exist; subProjectId = [" + subProjectId + "]");
        }
        ResultSummary resultSummary = new ResultSummary();
        ProjectParticipant signer = this.projectParticipantDAO.getSigner(organisationPersonId, projectId, Action.RELEASE_PLAN_DELIVER_CATALOGUE.getName());
        resultSummary.recordReceivedTuples(EntityVoc.PROJECT_PARTICIPANT, 1);
        if (signer == null) {
            throw new SecurityException("No valid signer for organisationPersonId = [" + organisationPersonId + "] and projectId = [" + projectId + "] found; will NOT release the plan deliver catalogue.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Fetched the signer.");
        }
        Certificate certificate = this.certificateDAO.getSignerCertificate(organisationPersonId);
        resultSummary.recordReceivedTuples(EntityVoc.CERTIFICATE, 1);
        if (certificate == null) {
            throw new SecurityException("No valid certificate found for organisationPersonId = [" + organisationPersonId + "]");
        }
        if (log.isDebugEnabled()) {
            log.debug("Fetched the signer certificate");
        }
        PlanDeliverSearchModel searchModel = new PlanDeliverSearchModel();
        searchModel.setOrganisationPersonId(organisationPersonId);
        searchModel.setProjectId(projectId);
        searchModel.setSubProjectId(subProjectId);
        List<PlanDeliverJoinDto> unreleasedJoinDtos = this.documentDAO.getPlanDeliverUnreleasedJoin(searchModel);
        resultSummary.recordReceivedJoinComponentTuples("PlanDeliverJoinDto", unreleasedJoinDtos.size());
        if (log.isDebugEnabled()) {
            log.debug("Fetched the unreleased plan deliver catalogue join, received " + unreleasedJoinDtos.size() + " tuples.");
        }
        DocumentList unreleasedDocumentList = null;
        HashMap<Long, Document> idToUnreleasedDocument = new HashMap<Long, Document>();
        for (PlanDeliverJoinDto joinDto : unreleasedJoinDtos) {
            unreleasedDocumentList = joinDto.getDocumentList();
            if (joinDto.getDocumentId() == null) continue;
            idToUnreleasedDocument.put(joinDto.getDocumentId(), joinDto.getDocument());
        }
        List<DocumentRelease> lastReleasedDocuments = this.documentReleaseDAO.getReleasedDocuments(unreleasedDocumentList.getId(), unreleasedDocumentList.getVersion() - 1);
        resultSummary.recordReceivedTuples(EntityVoc.DOCUMENT_RELEASE, lastReleasedDocuments.size());
        if (log.isDebugEnabled()) {
            log.debug("Fetched " + lastReleasedDocuments.size() + " lastReleasedDocuments.");
        }
        HashMap<Long, DocumentRelease> idToLastReleasedDocument = new HashMap<Long, DocumentRelease>();
        for (DocumentRelease lastReleasedDocument : lastReleasedDocuments) {
            idToLastReleasedDocument.put(lastReleasedDocument.getDocumentId(), lastReleasedDocument);
        }
        DocumentListRelease documentListToRelease = new DocumentListRelease();
        documentListToRelease.setVersion(unreleasedDocumentList.getVersion());
        documentListToRelease.setSubProjectId(subProjectId);
        documentListToRelease.setDocumentListId(unreleasedDocumentList.getId());
        documentListToRelease.setDigest(null);
        documentListToRelease.setHasDocumentVersions(Boolean.valueOf(false));
        ArrayList<Object> documentsToRelease = new ArrayList<Object>();
        ArrayList<Object> dateChangedDocuments = new ArrayList<Object>();
        for (Object unreleasedDocument : idToUnreleasedDocument.values()) {
            Object documentToRelease = new DocumentRelease();
            documentToRelease.setDigest(null);
            documentToRelease.setDocumentId(unreleasedDocument.getId());
            documentToRelease.setDocumentTypeId(unreleasedDocument.getDocumentTypeId());
            documentToRelease.setDocumentListId(null);
            documentToRelease.setModified(unreleasedDocument.getModified());
            documentToRelease.setNumber(unreleasedDocument.getNumber());
            documentToRelease.setName(unreleasedDocument.getName());
            documentToRelease.setScale(unreleasedDocument.getScale());
            documentToRelease.setStartDate(unreleasedDocument.getStartDate());
            documentToRelease.setHasDocumentVersions(unreleasedDocument.isHasDocumentVersions());
            documentToRelease.setObjectPlannerId(unreleasedDocument.getObjectPlannerId());
            documentToRelease.setComment(unreleasedDocument.getComment());
            documentToRelease.setContent(unreleasedDocument.getContent());
            documentToRelease.setEndDate(unreleasedDocument.getEndDate());
            documentToRelease.setDuration(unreleasedDocument.getDuration());
            if (documentToRelease.isHasDocumentVersions() == null) {
                log.warn("hasDocVersions == null: unreleasedDocId = " + unreleasedDocument.getId());
            }
            documentsToRelease.add(documentToRelease);
            if (updateAllDocuments) {
                dateChangedDocuments.add(documentToRelease);
                continue;
            }
            if (idToLastReleasedDocument.containsKey(unreleasedDocument.getId())) {
                DocumentRelease lastReleasedDocument = (DocumentRelease)idToLastReleasedDocument.get(unreleasedDocument.getId());
                if (lastReleasedDocument.getStartDate() != null) {
                    if (documentToRelease.getStartDate() != null && !(Math.abs(documentToRelease.getStartDate() - lastReleasedDocument.getStartDate()) > 1.0E-6)) continue;
                    dateChangedDocuments.add(documentToRelease);
                    continue;
                }
                if (documentToRelease.getStartDate() != null) {
                    dateChangedDocuments.add(documentToRelease);
                    continue;
                }
                if (lastReleasedDocument.getEndDate() != null) {
                    if (documentToRelease.getEndDate() != null && !(Math.abs(documentToRelease.getEndDate() - lastReleasedDocument.getEndDate()) > 1.0E-6)) continue;
                    dateChangedDocuments.add(documentToRelease);
                    continue;
                }
                if (documentToRelease.getEndDate() == null) continue;
                dateChangedDocuments.add(documentToRelease);
                continue;
            }
            if (documentToRelease.getStartDate() == null && documentToRelease.getEndDate() == null) continue;
            dateChangedDocuments.add(documentToRelease);
        }
        DocumentListRelease releasedDocumentList = (DocumentListRelease)this.documentListReleaseDAO.save(documentListToRelease);
        resultSummary.recordInsertedTuples(EntityVoc.DOCUMENT_LIST_RELEASE, 1);
        for (Object documentToRelease : documentsToRelease) {
            documentToRelease.setDocumentListId(releasedDocumentList.getId());
        }
        List releasedDocuments = this.documentReleaseDAO.saveBatch(documentsToRelease);
        resultSummary.recordInsertedTuples(EntityVoc.DOCUMENT_RELEASE, documentsToRelease.size());
        if (log.isDebugEnabled()) {
            log.debug("Saved " + releasedDocuments.size() + " released documents.");
        }
        releasedDocumentList.setDigest(this.documentDigester.getDocumentListHash(releasedDocumentList, releasedDocuments));
        releasedDocumentList.setDigestCalculatorId(null);
        for (DocumentRelease releasedDocument : releasedDocuments) {
            releasedDocument.setDigest(this.documentDigester.getDocumentHash(releasedDocument));
            releasedDocument.setDigestCalculatorId(null);
        }
        this.documentListReleaseDAO.update(releasedDocumentList);
        this.documentReleaseDAO.updateBatch(releasedDocuments);
        if (log.isDebugEnabled()) {
            log.debug("Updated " + releasedDocuments.size() + " released documents.");
        }
        String contentToSign = this.documentDigester.getDocumentListCompositeHash(releasedDocumentList, releasedDocuments);
        Signature signature = this.signatureCalculator.createSignature(signer, contentToSign, certificate, password);
        signature = (Signature)this.signatureDAO.save(signature);
        resultSummary.recordInsertedTuples(EntityVoc.SIGNATURE, 1);
        if (log.isDebugEnabled()) {
            log.debug("Calculated and saved the signature.");
        }
        releasedDocumentList.setSignatureId(signature.getId());
        this.documentListReleaseDAO.update(releasedDocumentList);
        for (Document unreleasedDocument : idToUnreleasedDocument.values()) {
            unreleasedDocument.setModified(Integer.valueOf(DocumentModifiedState.NOT_MODIFIED.getValue()));
        }
        ArrayList unreleasedDocumentsToSave = new ArrayList(idToUnreleasedDocument.values());
        this.documentDAO.updateBatch(unreleasedDocumentsToSave);
        resultSummary.recordUpdatedTuples(EntityVoc.DOCUMENT, unreleasedDocumentsToSave.size());
        if (log.isDebugEnabled()) {
            log.debug("Updated " + unreleasedDocumentsToSave.size() + " unreleased documents.");
        }
        unreleasedDocumentList.setVersion(Integer.valueOf(unreleasedDocumentList.getVersion() + 1));
        this.documentListDAO.update(unreleasedDocumentList);
        resultSummary.recordUpdatedTuples(EntityVoc.DOCUMENT_LIST, 1);
        ArrayList<Long> unreleasedDocumentIds = new ArrayList<Long>();
        for (DocumentRelease documentRelease : dateChangedDocuments) {
            unreleasedDocumentIds.add(documentRelease.getDocumentId());
        }
        if (log.isDebugEnabled()) {
            log.debug("About to call updateReviewTasks for " + unreleasedDocumentIds.size() + " dateChanged documents (only done if that count is > 0)");
        }
        if (unreleasedDocumentIds.size() > 0) {
            this.taskService.updateReviewTasks(resultSummary, projectId, subProjectId, unreleasedDocumentIds);
        }
        if (log.isDebugEnabled()) {
            log.debug("Finished releasing the plan deliver catalogue; query summary:");
        }
        resultSummary.printToLog(log);
        if (log.isDebugEnabled()) {
            log.debug("==========================================================================");
            log.debug("==========================================================================");
        }
        return resultSummary;
    }

    public void deleteDocument(Long organisationPersonId, Long documentId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Document document = (Document)this.documentDAO.get(documentId);
        if (document == null) {
            log.warn("Trying to delete non-existent document: [" + documentId + "]");
        }
        if (document.isHasDocumentVersions().booleanValue()) {
            throw new SecurityException("Cannot delete document [" + documentId + "]: hasDocumentVersion is true.");
        }
        List<DocumentRelease> documentReleases = this.documentReleaseDAO.getByDocument(documentId);
        boolean invalidate = documentReleases.size() > 0;
        Long objectPlannerId = document.getObjectPlannerId();
        ArrayList<Long> objectPlannerIds = new ArrayList<Long>();
        objectPlannerIds.add(objectPlannerId);
        Map<Long, Set<Action>> objectPlannerIdToActionNames = this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerIds, Action.EDIT_PLAN_DELIVER_CATALOGUE);
        if (!objectPlannerIdToActionNames.containsKey(objectPlannerId) || !objectPlannerIdToActionNames.get(objectPlannerId).contains(Action.EDIT_PLAN_DELIVER_CATALOGUE)) {
            throw new SecurityException("Trying to delete document [" + documentId + "] without role editPlanDeliverCatalogue for objectPlanner [" + objectPlannerId + "]");
        }
        int objectListReleaseCount = this.objectListReleaseDAO.getCountByDocument(documentId);
        if (objectListReleaseCount == 0) {
            throw new SecurityException("May not delete document which no ObjectListReleases existing. documentId = [" + documentId + "]");
        }
        if (!invalidate) {
            List<DocumentDateHistoryPart> dateHistoryParts = this.documentDateHistoryPartDAO.getByDocument(document.getId());
            ArrayList<Long> historyPartIdsToDelete = new ArrayList<Long>();
            for (DocumentDateHistoryPart part : dateHistoryParts) {
                historyPartIdsToDelete.add(part.getId());
            }
            this.documentDateHistoryPartDAO.deleteBatch(historyPartIdsToDelete);
        }
        List<TaskWithEmailJoin> taskWithEmailJoins = this.reviewCycleEntryTaskDAO.getReviewCycleEntryTasksWithMail(documentId);
        HashSet<Long> taskIds = new HashSet<Long>();
        ArrayList<Long> emailSnippetIds = new ArrayList<Long>();
        ArrayList<Long> futureEmailIds = new ArrayList<Long>();
        for (TaskWithEmailJoin taskWithEmailJoin : taskWithEmailJoins) {
            taskIds.add(taskWithEmailJoin.getTaskId());
            if (taskWithEmailJoin.getEmailSnippetId() != null) {
                emailSnippetIds.add(taskWithEmailJoin.getEmailSnippetId());
            }
            if (taskWithEmailJoin.getFutureEmailId() == null) continue;
            futureEmailIds.add(taskWithEmailJoin.getFutureEmailId());
        }
        this.futureEmailDAO.deleteBatch(futureEmailIds);
        this.taskEmailSnippetDAO.deleteBatch(emailSnippetIds);
        this.emailSnippetDAO.deleteBatch(emailSnippetIds);
        this.reviewCycleEntryTaskDAO.deleteBatch(taskIds);
        this.documentTaskDAO.deleteBatch(taskIds);
        this.taskDAO.deleteBatch(taskIds);
        if (invalidate) {
            document.setInvalidated(Boolean.valueOf(true));
            this.documentDAO.update(document);
        } else {
            this.documentDAO.delete(documentId);
        }
    }
}

