/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.datetime.UtcTimestamp;

public class DateHelper {
    public static String formatUtcSeconds(Double utcSeconds, String timeZone, String formatPattern) {
        long utcMillis = new Double(utcSeconds * 1000.0).longValue();
        return DateHelper.formatUtcMillis(utcMillis, timeZone, formatPattern);
    }

    public static String formatUtcMillis(long utcMillis, String timeZone, String formatPattern) {
        UtcTimestamp utcTimeStamp = new UtcTimestamp(TimeZone.getTimeZone(timeZone), utcMillis);
        Calendar calendar = utcTimeStamp.toCalendar();
        Locale locale = ThreadLocalManager.getLoginLocale();
        FastDateFormat format = FastDateFormat.getInstance((String)formatPattern, (Locale)locale);
        String formattedDateString = format.format(calendar);
        return formattedDateString;
    }

    public static String formatCurrentTime(String timeZone, String formatPattern) {
        long utcMillis = System.currentTimeMillis();
        return DateHelper.formatUtcMillis(utcMillis, timeZone, formatPattern);
    }

    public static Double getCurrentUtcSeconds() {
        long currentMillis = System.currentTimeMillis();
        Double currentUtcSeconds = (double)currentMillis / 1000.0;
        return currentUtcSeconds;
    }
}

